/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReduceRpcFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public final class CslOrgTreeUtil {
    public static final String KEY_OrgStructureColl = "orgStructureCollection";
    public static final String KEY_PermOrgs = "permOrgs";

    private CslOrgTreeUtil() {
    }

    public static DefaultKingdeeTreeNode getUnionDebtTree(OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean useFilter) throws EASBizException, BOSException {
        String rootID = null;
        if (unitInfo != null) {
            rootID = unitInfo.getId().toString();
        }
        CtrlUnitInfo ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        Map unionTreeInfoMap = CslReduceRpcFacadeFactory.getRemoteInstance().buildTreeModelInfo(userInfo.getId().toString(), ctrlInfo.getId().toString(), treeInfo.getId().toString(), rootID, false);
        Map permOrgsMap = (Map)unionTreeInfoMap.get(KEY_PermOrgs);
        OrgStructureCollection orgStructColl = (OrgStructureCollection)unionTreeInfoMap.get(KEY_OrgStructureColl);
        DefaultTreeModel treeModel = CslOrgTreeUtil.buildTreeByOrgStructCollection(orgStructColl);
        CslOrgTreeUtil.treatTreeModel(treeModel, permOrgsMap, useFilter, false);
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)treeModel.getRoot();
        return rootNode;
    }

    public static void treatTreeModel(DefaultTreeModel treeModel, int level, Map permOrgsMap, boolean useFilter, boolean checkValid) {
        CslOrgTreeUtil.treatTreeModel(treeModel, level, permOrgsMap, useFilter, checkValid, null);
    }

    public static void treatTreeModel(DefaultTreeModel treeModel, Map permOrgsMap, boolean useFilter, boolean checkValid) {
        if (treeModel == null || treeModel.getRoot() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            OrgF7InnerUtils.filterTreeNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)treeModel.getRoot()), (HashMap)((HashMap)permOrgsMap), (boolean)useFilter, (boolean)checkValid);
            OrgF7InnerUtils.clipTreeNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)treeModel.getRoot()));
        }
    }

    public static void treatTreeModel(DefaultTreeModel treeModel, int level, Map permOrgsMap, boolean useFilter, boolean checkValid, Set noPermissionUnitSet) {
        if (treeModel == null || treeModel.getRoot() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            CslOrgTreeUtil.diableNotAllowedNodeByLevel(root, level);
            OrgF7InnerUtils.filterTreeNode((DefaultKingdeeTreeNode)root, (HashMap)((HashMap)permOrgsMap), (boolean)useFilter, (boolean)checkValid);
            CslOrgTreeUtil.getNoPermissionUnitSet(noPermissionUnitSet, root);
            CslOrgTreeUtil.clipTreeNode(root, level, noPermissionUnitSet);
            CslOrgTreeUtil.setFolderImage(root, level);
        }
    }

    private static void diableNotAllowedNodeByLevel(DefaultKingdeeTreeNode root, int level) {
        if (level == 0) {
            return;
        }
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            CslOrgTreeUtil.diableNotAllowedNodeByLevel((DefaultKingdeeTreeNode)root.getChildAt(i), level);
        }
        OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
        if (structInfo.getLevel() != level) {
            CslOrgTreeUtil.disableTreeNode(root, false);
        }
    }

    private static void disableTreeNode(DefaultKingdeeTreeNode treeNode, boolean disable) {
        treeNode.setCheckBoxEnabled(disable);
        treeNode.setCheckBoxVisible(disable);
    }

    private static void clipTreeNode(DefaultKingdeeTreeNode root, int level, Set noPermissionUnitSet) {
        DefaultKingdeeTreeNode node = null;
        if (root != null && root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                CslOrgTreeUtil.clipTreeNode(node, level, noPermissionUnitSet);
                CslOrgTreeUtil.getNoPermissionUnitSet(noPermissionUnitSet, node);
                if ((node.getChildCount() != 0 || node.isCheckBoxEnabled() || level == 0) && (node.getChildCount() != 0 || OrgF7InnerUtils.isUserObjectEnable((DefaultKingdeeTreeNode)node))) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    private static void clipTreeNode(DefaultKingdeeTreeNode root, int level) {
        CslOrgTreeUtil.clipTreeNode(root, level, null);
    }

    private static void getNoPermissionUnitSet(Set noPermissionUnitSet, DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnit;
        Object orgStructure;
        if (noPermissionUnitSet != null && node != null && !node.isCheckBoxEnabled() && (orgStructure = node.getUserObject()) != null && orgStructure instanceof OrgStructureInfo && (orgUnit = ((OrgStructureInfo)orgStructure).getUnit()) != null && orgUnit.getId() != null) {
            noPermissionUnitSet.add(orgUnit.getId().toString());
        }
    }

    private static void setFolderImage(DefaultKingdeeTreeNode root, int level) {
        if (level == 0) {
            return;
        }
        if (root != null && root.getUserObject() != null) {
            int n = root.getChildCount();
            for (int i = 0; i < n; ++i) {
                CslOrgTreeUtil.setFolderImage((DefaultKingdeeTreeNode)root.getChildAt(i), level);
            }
            CslOrgTreeUtil.disableTreeNode(root, true);
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo unitInfo = structInfo.getUnit();
            if (unitInfo.isIsUnion()) {
                if (root.getChildCount() == 0) {
                    root.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
                } else {
                    root.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_open"));
                }
            }
        }
    }

    public static DefaultTreeModel buildTreeByOrgStructCollection(OrgStructureCollection collection) throws BOSException {
        DefaultKingdeeTreeNode root = NewOrgViewHelper.buildTreeByRowSet2((OrgStructureCollection)collection);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        return treeModel;
    }

    public static DefaultTreeModel getCompanyF7TreeModel() throws BOSException, EASBizException {
        OrgStructureCollection collection = CslReduceRpcFacadeFactory.getRemoteInstance().getOrgStructureCollection();
        DefaultTreeModel treeModel = CslOrgTreeUtil.buildTreeByOrgStructCollection(collection);
        return treeModel;
    }

    public static OrgStructureCollection getOrgStructureCollection(Context ctx) throws BOSException, EASBizException {
        String treeId = "00000000-0000-0000-0000-0000000000024F2827FD";
        StringBuffer sql = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sql.append(" SELECT ORGSTRUCTURE.FID       \"ID\", \t\t\t\r\n");
        sql.append("   ORGSTRUCTURE.FLongNumber    \"LONGNUMBER\",\t\r\n");
        sql.append("   ORGSTRUCTURE.FLevel         \"LEVEL\",\t\t\r\n");
        sql.append("   ORGSTRUCTURE.FIsLeaf        \"ISLEAF\",\t\t\r\n");
        sql.append("   ORGSTRUCTURE.FIsValid       \"ISVALID\",\t\t\r\n");
        sql.append("   ORGSTRUCTURE.FParentID      \"PARENT.ID\",\t\r\n");
        sql.append("   UNIT.FID                    \"UNIT.ID\",\t\t\r\n");
        sql.append("   UNIT.FNumber                \"UNIT.NUMBER\",\t\r\n");
        sql.append("   UNIT.FName_").append(language).append(" \"UNIT.NAME\",\t\r\n");
        sql.append("   UNIT.FLongNumber            \"UNIT.LONGNUMBER\",\t\t\t\r\n");
        sql.append("   UNIT.FIsGrouping            \"UNIT.ISGROUPING\",\t\t\t\r\n");
        sql.append("   UNIT.FIsUnion               \"UNIT.ISUNION\",\t\t\t\r\n");
        sql.append("   UNIT.FIsCompanyOrgUnit      \"UNIT.ISCOMPANYORGUNIT\",\t\r\n");
        sql.append("   UNIT.FIsProfitOrgUnit       \"UNIT.IsProfitOrgUnit\",\t\r\n");
        sql.append("   UNIT.FOrgTypeStr      \t   \"UNIT.orgTypeStr\",\t\t\t\r\n");
        sql.append("   UNIT.FIsFreeze              \"UNIT.ISFREEZE\"\t\t\t\r\n");
        sql.append(" \tFROM T_ORG_Structure ORGSTRUCTURE\t\t\t\r\n");
        sql.append("\tINNER JOIN T_ORG_BaseUnit UNIT\t\t\t\t\r\n");
        sql.append(" \t\tON ORGSTRUCTURE.FUnitId = UNIT.FID\t\t\r\n");
        sql.append(" \tINNER JOIN T_ORG_Tree TREE\t\t\t\t\t\r\n");
        sql.append(" \t\tON ORGSTRUCTURE.FTreeId = TREE.FID\t\t\r\n");
        sql.append("\tLEFT OUTER JOIN T_ORG_Structure PARENT\t\t\r\n");
        sql.append(" \t\t ON ORGSTRUCTURE.FParentID = PARENT.FID\t\r\n");
        sql.append(" \tLEFT OUTER JOIN T_ORG_OUPartCtrl CTRL\t\t\r\n");
        sql.append("  \t\tON UNIT.FID = CTRL.FUnitID\t\t\t\t\r\n");
        sql.append(" \tLEFT OUTER JOIN t_org_oupartfi as partFI\t\r\n");
        sql.append("    \tON UNIT.FID = partFI.FUnitID\t\t\t\r\n");
        sql.append(" \tWHERE UNIT.FID <> '11111111-1111-1111-1111-111111111111CCE7AED4' \r\n");
        sql.append("     AND TREE.FID = '").append(treeId).append("'\t\t\t\t\t \r\n");
        sql.append("  and ORGSTRUCTURE.FISVALID = 1 and partFI.fisSealUp = 0 \r\n");
        sql.append("  and UNIT.fisAssistantOrg = 0 \r\n");
        sql.append(" ORDER BY ORGSTRUCTURE.FLongNumber ASC");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return CslOrgTreeUtil.createOrgStructureCol(rowSet, treeId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map _buildTreeModelInfo(Context ctx, String userID, String ctrlUnitID, String treeID, String orgUnitID, boolean isGetChildOrg) throws BOSException, EASBizException {
        if (treeID == null || userID == null) {
            return new HashMap(2);
        }
        HashMap map = new HashMap(4);
        ObjectUuidPK ctrlUnitPK = null;
        if (ctrlUnitID != null) {
            ctrlUnitPK = new ObjectUuidPK(ctrlUnitID);
        }
        Map displayOrgIDs = CslOrgTreeUtil.getAuthorizedOrgs(ctx, (IObjectPK)ctrlUnitPK, (IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK(treeID), isGetChildOrg);
        OrgStructureCollection collection = CslOrgTreeUtil.createStructureCol(ctx, treeID, orgUnitID);
        map.put(KEY_PermOrgs, displayOrgIDs);
        map.put(KEY_OrgStructureColl, collection);
        return map;
    }

    public static OrgStructureCollection createStructureCol(Context ctx, String treeID, String orgUnitID, boolean isRevised) throws BOSException, EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            String orgStruLongNumber = null;
            if (orgUnitID != null) {
                sql.append(" SELECT FLongNumber from T_ORG_STRUCTURE ");
                sql.append(" WHERE FTREEID = ? AND FUNITID = ?");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeID, orgUnitID});
                if (rowSet.next()) {
                    orgStruLongNumber = rowSet.getString("FLongNumber");
                }
                sql.delete(0, sql.length());
            }
            String language = ctx.getLocale().getLanguage();
            sql.append(" SELECT ORGSTRUCTURE.FID       \"ID\", \t\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FLongNumber    \"LONGNUMBER\",\t\r\n");
            sql.append("   ORGSTRUCTURE.FLevel         \"LEVEL\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FIsLeaf        \"ISLEAF\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FIsValid       \"ISVALID\",\t\t\r\n");
            sql.append("   ORGSTRUCTURE.FParentID      \"PARENT.ID\",\t\r\n");
            sql.append("   UNIT.FID                    \"UNIT.ID\",\t\t\r\n");
            sql.append("   UNIT.FNumber                \"UNIT.NUMBER\",\t\r\n");
            sql.append("   UNIT.FName_").append(language).append(" \"UNIT.NAME\",\r\n");
            sql.append("   UNIT.FLongNumber            \"UNIT.LONGNUMBER\",\t\t\r\n");
            sql.append("   UNIT.FIsGrouping            \"UNIT.ISGROUPING\",\t\t\r\n");
            sql.append("   UNIT.FIsUnion               \"UNIT.ISUNION\",\t\t\r\n");
            sql.append("   UNIT.FIsCompanyOrgUnit      \"UNIT.ISCOMPANYORGUNIT\",\r\n");
            sql.append("   UNIT.FIsProfitOrgUnit      \"UNIT.IsProfitOrgUnit\",\r\n");
            sql.append("   UNIT.FOrgTypeStr      \t  \"UNIT.orgTypeStr\",\r\n");
            sql.append("   UNIT.FIsFreeze              \"UNIT.ISFREEZE\"\t\t\r\n");
            sql.append(" \tFROM T_ORG_Structure ORGSTRUCTURE\t\t\t\r\n");
            sql.append("\tINNER JOIN T_ORG_BaseUnit UNIT\t\t\t\t\r\n");
            sql.append(" \t\tON ORGSTRUCTURE.FUnitId = UNIT.FID\t\t\r\n");
            sql.append(" \tINNER JOIN T_ORG_Tree TREE\t\t\t\t\t\r\n");
            sql.append(" \t\tON ORGSTRUCTURE.FTreeId = TREE.FID\t\t\r\n");
            sql.append("\tLEFT OUTER JOIN T_ORG_Structure PARENT\t\t\r\n");
            sql.append(" \t\t ON ORGSTRUCTURE.FParentID = PARENT.FID\t\r\n");
            sql.append(" \tLEFT OUTER JOIN T_ORG_OUPartCtrl CTRL\t\t\r\n");
            sql.append("  \t\tON UNIT.FID = CTRL.FUnitID\t\t\t\t\r\n");
            sql.append(" \tWHERE UNIT.FID <> '11111111-1111-1111-1111-111111111111CCE7AED4' \r\n");
            sql.append("     AND TREE.FID = '").append(treeID).append("'\t\t\t\t\t \r\n");
            if (orgStruLongNumber != null) {
                sql.append(" AND (ORGSTRUCTURE.FLongNumber = '").append(orgStruLongNumber).append("' OR ORGSTRUCTURE.FLongNumber LIKE '").append(orgStruLongNumber).append("%' )");
            }
            sql.append(" ORDER BY ORGSTRUCTURE.FLongNumber ASC");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            OrgStructureCollection collection = CslOrgTreeUtil.createOrgStructureCol(rowSet, treeID);
            return collection;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static OrgStructureCollection createStructureCol(Context ctx, String treeID, String orgUnitID) throws BOSException, EASBizException {
        return CslOrgTreeUtil.createStructureCol(ctx, treeID, orgUnitID, false);
    }

    public static OrgStructureCollection createStructureCol(Context ctx, String treeID) throws BOSException, EASBizException {
        return CslOrgTreeUtil.createStructureCol(ctx, treeID, null, false);
    }

    public static OrgStructureCollection createOrgStructureCol(IRowSet row, String treeID) throws EASBizException, BOSException, SQLException {
        OrgStructureCollection orgStrCol = new OrgStructureCollection();
        OrgTreeInfo treeInfo = new OrgTreeInfo();
        treeInfo.setId(BOSUuid.read((String)treeID));
        while (row.next()) {
            OrgStructureInfo structInfo = new OrgStructureInfo();
            structInfo.setId(BOSUuid.read((String)row.getString("id")));
            structInfo.setLongNumber(row.getString("longNumber"));
            structInfo.setLevel(row.getInt("level"));
            structInfo.setIsLeaf(row.getBoolean("isLeaf"));
            structInfo.setIsValid(row.getBoolean("isValid"));
            FullOrgUnitInfo fullUnitInfo = new FullOrgUnitInfo();
            fullUnitInfo.setId(BOSUuid.read((String)row.getString("unit.id")));
            fullUnitInfo.setNumber(row.getString("unit.number"));
            fullUnitInfo.setName(row.getString("unit.name"));
            fullUnitInfo.setIsGrouping(row.getBoolean("unit.isGrouping"));
            fullUnitInfo.setIsFreeze(row.getBoolean("unit.isFreeze"));
            fullUnitInfo.setLongNumber(row.getString("unit.longNumber"));
            fullUnitInfo.setIsUnion(row.getBoolean("unit.isunion"));
            fullUnitInfo.setIsCompanyOrgUnit(row.getBoolean("unit.isCompanyOrgUnit"));
            fullUnitInfo.setIsProfitOrgUnit(row.getBoolean("unit.IsProfitOrgUnit"));
            fullUnitInfo.setOrgTypeStr(row.getString("unit.orgTypeStr"));
            structInfo.setUnit(fullUnitInfo);
            OrgStructureInfo parentStructInfo = null;
            if (row.getString("parent.id") != null && !row.getString("parent.id").equals("")) {
                parentStructInfo = new OrgStructureInfo();
                parentStructInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
            }
            structInfo.setParent(parentStructInfo);
            structInfo.setTree(treeInfo);
            orgStrCol.add(structInfo);
        }
        return orgStrCol;
    }

    public static Map getAuthorizedOrgs(Context ctx, IObjectPK userPK, IObjectPK treePk, boolean isGetChildOrg) throws BOSException, EASBizException {
        return CslOrgTreeUtil.getAuthorizedOrgs(ctx, null, userPK, treePk, isGetChildOrg);
    }

    public static Map getAuthorizedOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, IObjectPK treePk, boolean isGetChildOrg) throws BOSException, EASBizException {
        Map permOrgs = null;
        permOrgs = ctrlUnitPK != null ? PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs(ctrlUnitPK, userPK, OrgType.UnionDebt, treePk, null, null) : PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs(userPK, OrgType.UnionDebt, treePk, null, null);
        if (permOrgs == null) {
            permOrgs = new HashMap(2);
        }
        if (!isGetChildOrg) {
            return permOrgs;
        }
        HashMap orgIds = CslOrgTreeUtil.getCompanyFromUnionGroup(ctx, treePk.toString(), permOrgs);
        if (orgIds == null) {
            orgIds = new HashMap(2);
        }
        if (permOrgs != null) {
            orgIds.putAll(permOrgs);
        }
        return orgIds;
    }

    private static Map getCompanyFromUnionGroup(Context ctx, String treeID, Map unionGroup) throws BOSException, EASBizException {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        Iterator it = unionGroup.keySet().iterator();
        if (!it.hasNext()) {
            return ret;
        }
        StringBuffer groupIDs = new StringBuffer();
        while (it.hasNext()) {
            String groupID = (String)it.next();
            if (StringUtils.isEmpty((String)groupID)) continue;
            if (groupIDs.length() != 0) {
                groupIDs.append(",");
            }
            groupIDs.append("'").append(groupID).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("\tSELECT T0.FUNITID  \tUNITID\t\t\r\n");
        sql.append("\tFROM T_ORG_STRUCTURE T0\t\t\t\r\n");
        sql.append("\tINNER JOIN T_ORG_TREE T1\t\t\r\n");
        sql.append(" \t ON T0.FTREEID = T1.FID\t\t\t\r\n");
        sql.append("\tINNER JOIN T_ORG_BASEUNIT T2\t\r\n");
        sql.append("  \tON T0.FUNITID = T2.FID\t\t\t\r\n");
        sql.append("\tLEFT OUTER JOIN T_ORG_OUPARTFI T3\t\r\n");
        sql.append("  ON T2.FPARTFIID = T3.FID\t\t\t\t\r\n");
        sql.append("\tLEFT OUTER JOIN T_ORG_STRUCTURE T4\t\r\n");
        sql.append("  ON T0.FPARENTID = T4.FID\t\t\t\t\r\n");
        sql.append(" WHERE T1.FID = '").append(treeID).append("' AND T4.FUNITID IN \r\n");
        sql.append("  (").append(groupIDs.toString()).append(") \t\r\n");
        sql.append("   AND T2.FISUNION = 0 AND T3.FISSEALUP = 0\t\t");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                ret.put(rowSet.getString("UNITID"), Boolean.FALSE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static Set getPermOrgUnitSetForServer(Context ctx, String treeId, String orgUnitId, String userId) throws BOSException, SQLException {
        IRowSet rowSet;
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String orgStruLongNumber = null;
        if (!StringUtils.isEmpty((String)treeId) && !StringUtils.isEmpty((String)orgUnitId)) {
            sql.append(" SELECT FLongNumber from T_ORG_STRUCTURE ");
            sql.append(" WHERE FTREEID = ? AND FUNITID = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, orgUnitId});
            if (rowSet.next()) {
                orgStruLongNumber = rowSet.getString("FLongNumber");
            }
            sql.delete(0, sql.length());
        }
        sql.append("SELECT ORGRANGE.FORGID UNITID FROM T_PM_ORGRANGE ORGRANGE ");
        if (!StringUtils.isEmpty((String)treeId)) {
            sql.append(" INNER JOIN T_ORG_STRUCTURE  STRUCTURE ON ");
            sql.append(" STRUCTURE.FUNITID = ORGRANGE.FORGID ");
        }
        sql.append(" WHERE ORGRANGE.FUSERID = '").append(userId).append("'");
        sql.append("\tAND ORGRANGE.FTYPE=").append(10);
        if (!StringUtils.isEmpty((String)treeId)) {
            sql.append("  AND STRUCTURE.FTREEID ='").append(treeId).append("'");
        }
        if (orgStruLongNumber != null) {
            sql.append(" AND (STRUCTURE.FLongNumber = '").append(orgStruLongNumber).append("' OR STRUCTURE.FLongNumber LIKE '").append(orgStruLongNumber).append("%' )");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            set.add(rowSet.getString("UNITID"));
        }
        return set;
    }

    public static Set getPermOrgUnitSetForClient(String treeId, String orgUnitId, String userId) throws BOSException, EASBizException {
        MessagePostManManager msgMng = new MessagePostManManager("getPermOrgUnitSetForClient");
        msgMng.addMessage(new MessagePostMan("treeId", treeId));
        msgMng.addMessage(new MessagePostMan("orgUnitId", orgUnitId));
        msgMng.addMessage(new MessagePostMan("userId", userId));
        msgMng = RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(msgMng);
        return (Set)msgMng.getItem("returnValue").getValue();
    }
}

