/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DataElementProvider {
    private static final Logger logger = Logger.getLogger(DataElementProvider.class);
    private static HashMap dataElementsMap = null;
    private static HashMap clientNameMap = null;
    private static HashMap serverDataMap = null;

    private static HashMap initialDataElementMap(IDataElement iDataElement) throws BOSException {
        HashMap<Object, Serializable> dataMap = new HashMap<Object, Serializable>();
        String upperNumber = null;
        Iterator iter = iDataElement.getDataElementCollection().iterator();
        while (iter.hasNext()) {
            DataElementInfo element = (DataElementInfo)iter.next();
            dataMap.put(new Integer(element.getInterSeq()), element);
            dataMap.put(element.getNumber(), new Integer(element.getInterSeq()));
            upperNumber = element.getNumber().toUpperCase();
            if (dataMap.containsKey(upperNumber)) continue;
            dataMap.put(upperNumber, new Integer(element.getInterSeq()));
        }
        return dataMap;
    }

    private static HashMap initialClientNameMap(IDataElement iDataElement) throws BOSException {
        HashMap<Object, Serializable> dataMap = new HashMap<Object, Serializable>();
        Locale locale = SysContext.getSysContext().getLocale();
        Iterator iter = iDataElement.getDataElementCollection().iterator();
        while (iter.hasNext()) {
            DataElementInfo element = (DataElementInfo)iter.next();
            String elementName = element.getName(locale);
            if (elementName == null || elementName.length() == 0) continue;
            dataMap.put(new Integer(element.getInterSeq()), element);
            dataMap.put(elementName, new Integer(element.getInterSeq()));
        }
        return dataMap;
    }

    public static synchronized HashMap getDataElementNameMap() {
        if (clientNameMap == null) {
            try {
                clientNameMap = DataElementProvider.initialClientNameMap(DataElementFactory.getRemoteInstance());
            }
            catch (BOSException e) {
                logger.error((Object)"initialDataElementMap_BOSException", (Throwable)e);
            }
        }
        return clientNameMap;
    }

    public static synchronized HashMap getDataElementMap() {
        if (dataElementsMap == null) {
            try {
                dataElementsMap = DataElementProvider.initialDataElementMap(DataElementFactory.getRemoteInstance());
            }
            catch (BOSException e) {
                logger.error((Object)"initialDataElementMap_BOSException", (Throwable)e);
            }
        }
        return dataElementsMap;
    }

    public static void refresh() {
        dataElementsMap = null;
    }

    public static DataElementInfo getDataElementInfo(int innerValue) {
        HashMap tempMap = DataElementProvider.getDataElementMap();
        if (tempMap.containsKey(new Integer(innerValue))) {
            return (DataElementInfo)tempMap.get(new Integer(innerValue));
        }
        return null;
    }

    public static DataElementInfo getDataElementInfo(String number) {
        HashMap tempMap = DataElementProvider.getDataElementMap();
        if (tempMap.containsKey(number)) {
            return (DataElementInfo)tempMap.get(tempMap.get(number));
        }
        return null;
    }

    public static DataElementInfo getDataElementInfoByName(String name) {
        HashMap tempMap = DataElementProvider.getDataElementNameMap();
        if (tempMap.containsKey(name)) {
            return (DataElementInfo)tempMap.get(tempMap.get(name));
        }
        return null;
    }

    public static int getDataElementInnerValue(String number) throws BOSException {
        HashMap tempMap = DataElementProvider.getDataElementMap();
        if (tempMap.containsKey(number)) {
            return (Integer)tempMap.get(number);
        }
        DataElementProvider.refresh();
        tempMap = DataElementProvider.getDataElementMap();
        if (tempMap.containsKey(number)) {
            return (Integer)tempMap.get(number);
        }
        throw new BOSException("The DataElement whose number is " + number + " can not be found! It has been deleted from the database possibly.");
    }

    public static boolean existsDataElement(String number) {
        HashMap tempMap = DataElementProvider.getDataElementMap();
        return tempMap.containsKey(number);
    }

    public static String getDataElementName(int innerValue) {
        DataElementInfo info = DataElementProvider.getDataElementInfo(innerValue);
        if (info != null) {
            return info.getName();
        }
        return null;
    }

    public static String getDataElementName(String number) {
        DataElementInfo info = DataElementProvider.getDataElementInfo(number);
        if (info != null) {
            return info.getName();
        }
        return null;
    }

    public static String getDataElementNumber(int innerValue) {
        DataElementInfo info = DataElementProvider.getDataElementInfo(innerValue);
        if (info != null) {
            return info.getNumber();
        }
        return null;
    }

    private static synchronized HashMap getDataElementMap(Context ctx) {
        HashMap result;
        if (serverDataMap == null) {
            serverDataMap = new HashMap();
        }
        if ((result = (HashMap)serverDataMap.get(ctx.getAIS())) == null) {
            HashMap tempMap = null;
            try {
                tempMap = DataElementProvider.initialDataElementMap(DataElementFactory.getLocalInstance(ctx));
            }
            catch (BOSException e) {
                logger.error((Object)"initialDataElementMap_BOSException", (Throwable)e);
            }
            serverDataMap.put(ctx.getAIS(), tempMap);
            result = tempMap;
        }
        return result;
    }

    public static void refresh(Context ctx) {
        if (serverDataMap != null && serverDataMap.containsKey(ctx.getAIS())) {
            serverDataMap.remove(ctx.getAIS());
        }
    }

    public static DataElementInfo getDataElementInfo(Context ctx, int innerValue) {
        HashMap tempMap = DataElementProvider.getDataElementMap(ctx);
        if (tempMap.containsKey(new Integer(innerValue))) {
            return (DataElementInfo)tempMap.get(new Integer(innerValue));
        }
        return null;
    }

    public static DataElementInfo getDataElementInfo(Context ctx, String number) {
        HashMap tempMap = DataElementProvider.getDataElementMap(ctx);
        if (tempMap.containsKey(number)) {
            return (DataElementInfo)tempMap.get(tempMap.get(number));
        }
        return null;
    }

    public static int getDataElementInnerValue(Context ctx, String number) throws BOSException, EASBizException {
        HashMap tempMap = DataElementProvider.getDataElementMap(ctx);
        if (tempMap.containsKey(number)) {
            return (Integer)tempMap.get(number);
        }
        DataElementProvider.refresh(ctx);
        tempMap = DataElementProvider.getDataElementMap(ctx);
        if (tempMap.containsKey(number)) {
            return (Integer)tempMap.get(number);
        }
        throw new EASBizException(new NumericExceptionSubItem("0001", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElementNotFound", (Locale)ctx.getOriginLocale())), new Object[]{number});
    }

    public static boolean existsDataElement(Context ctx, String number) {
        HashMap tempMap = null;
        tempMap = ctx != null ? DataElementProvider.getDataElementMap(ctx) : DataElementProvider.getDataElementMap();
        return tempMap.containsKey(number);
    }

    public static String getDataElementName(Context ctx, int innerValue) {
        if (DataElementProvider.getDataElementInfo(ctx, innerValue) != null) {
            return DataElementProvider.getDataElementInfo(ctx, innerValue).getName();
        }
        return null;
    }

    public static String getDataElementName(Context ctx, String number) {
        if (DataElementProvider.getDataElementInfo(ctx, number) != null) {
            return DataElementProvider.getDataElementInfo(ctx, number).getName();
        }
        return null;
    }

    public static String getDataElementNumber(Context ctx, int innerValue) {
        if (DataElementProvider.getDataElementInfo(ctx, innerValue) != null) {
            return DataElementProvider.getDataElementInfo(ctx, innerValue).getNumber();
        }
        return null;
    }
}

