/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RunTimeException;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DyRptSaveHelper {
    public static final int DynaValue = 0;
    public static final int DynaName = 1;
    public static final int DynaType = 2;
    public static final int DynaRow = 3;
    public static final int DynaCol = 4;
    public static final int DynaSheetId = 5;
    public static final int Grade = 6;
    public static final String HandDyItemNumber = "AUTO_HandDyItemNumber";
    public static final String SPLIT_BEGIN = "[";
    public static final String SPLIT_END = "]";
    public static final String SUPPORT_INNER_FLAG = "&@&";

    private static boolean isDyRptSaveUpdateItem4CM(Context ctx) {
        return CSLParamUtil.isDyRptSaveUpdateItem4CM(ctx);
    }

    public static void saveDyCslRptItemData(CslReportInfo reportInfo, Book book, boolean doOffset, boolean includeDiffTable, Map uiContext) throws BOSException, EASBizException {
        DyRptSaveHelper.saveDyCslRptItemData(null, reportInfo, book, doOffset, includeDiffTable, uiContext);
    }

    public static void saveDyCslRptItemData(Context ctx, CslReportInfo reportInfo, Book book, boolean doOffset, boolean includeDiffTable, Map uiContext) throws BOSException, EASBizException {
        if (reportInfo.getSourceType().getValue() == 12 || reportInfo.getSourceType().getValue() == 35) {
            DyRptSaveHelper.saveDyReportItemData(ctx, reportInfo, book, doOffset, includeDiffTable, uiContext);
        }
    }

    public static void saveDySumRptItemData(Context ctx, CslReportInfo reportInfo, Book book, boolean doOffset, boolean includeDiffTable, Map uiContext) throws BOSException, EASBizException {
        if (reportInfo.getSourceType().getValue() == 11 || reportInfo.getSourceType().getValue() == 32) {
            DyRptSaveHelper.saveDyReportItemData(ctx, reportInfo, book, doOffset, includeDiffTable, uiContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDyReportItemData(Context ctx, CslReportInfo reportInfo, Book book, boolean doOffset, boolean includeDiffTable, Map uiContext) throws BOSException, EASBizException {
        try {
            book.getUndoManager().enable(false);
            book.getUndoManager().startGroup();
            DynaSumMethodEnum method = (DynaSumMethodEnum)((Object)uiContext.get("DynaSumMethod"));
            boolean isdycslRpt = reportInfo.getSourceType().getValue() == 12 || reportInfo.getSourceType().getValue() == 35;
            boolean isSupportCrossMerger = false;
            String unitMap2SerialString = null;
            if (isdycslRpt && (isSupportCrossMerger = uiContext.containsKey("isSupportCrossMerger") ? (Boolean)uiContext.get("isSupportCrossMerger") : CSLParamUtil.isSupportCrossMerger(ctx, reportInfo.getOrgTree().getId().toString())) && book.getUserObject("unitMap2SerialString") != null) {
                unitMap2SerialString = (String)book.getUserObject("unitMap2SerialString").getValue();
            }
            boolean onlyList = Boolean.TRUE.equals(uiContext.get("onlyList"));
            boolean isDyRptSaveUpdateItem4CM = DyRptSaveHelper.isDyRptSaveUpdateItem4CM(ctx);
            if (isDyRptSaveUpdateItem4CM) {
                boolean allBasePointIsNotGrade = true;
                Sheet sheet = null;
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    sheet = book.getSheet(i);
                    if (DyRptSaveHelper.allBasePointIsNotGrade(sheet)) continue;
                    allBasePointIsNotGrade = false;
                    break;
                }
                if (allBasePointIsNotGrade) {
                    DyRptSaveHelper.newSaveType4CM(ctx, reportInfo, book, uiContext, method, doOffset, includeDiffTable, onlyList, isSupportCrossMerger, unitMap2SerialString);
                } else {
                    DyRptSaveHelper.oldSaveType(ctx, reportInfo, book, uiContext, doOffset, includeDiffTable, onlyList, isSupportCrossMerger, unitMap2SerialString);
                }
            } else {
                DyRptSaveHelper.oldSaveType(ctx, reportInfo, book, uiContext, doOffset, includeDiffTable, onlyList, isSupportCrossMerger, unitMap2SerialString);
            }
        }
        finally {
            book.getUndoManager().enable(true);
            book.getUndoManager().endGroup();
        }
    }

    private static void oldSaveType(Context ctx, CslReportInfo reportInfo, Book book, Map uiContext, boolean doOffset, boolean includeDiffTable, boolean onlyList, boolean isSupportCrossMerger, String unitMap2SerialString) throws BOSException, EASBizException {
        if (isSupportCrossMerger && unitMap2SerialString == null) {
            return;
        }
        if (isSupportCrossMerger) {
            boolean isCalcSingle = uiContext.containsKey("singlePageCompanyIds");
            HashMap<String, String> companyIDs = new HashMap<String, String>();
            HashMap tableValues = new HashMap();
            HashMap tableValues_list = new HashMap();
            companyIDs.put("unitMap2SerialString", unitMap2SerialString);
            if (isCalcSingle) {
                companyIDs.put("isSingeSheetCal", "");
                String sheetName = (String)uiContext.get("singlePageCompanyIds");
                SumHelper.scanDynaBook(true, book, sheetName, tableValues, tableValues_list, onlyList);
            } else {
                SumHelper.scanDynaBook(false, book, null, tableValues, tableValues_list, onlyList);
            }
            HashMap<String, String> tmpCompanyIds = new HashMap<String, String>();
            tmpCompanyIds.putAll(companyIDs);
            if (!tableValues.isEmpty()) {
                SumHelper.sumDynamicReportAndSave(ctx, reportInfo.getId().toString(), companyIDs, tableValues, doOffset, includeDiffTable);
            }
            if (tableValues_list.size() > 0) {
                SumHelper.sumDynamicReportAndSave(ctx, reportInfo.getId().toString(), tmpCompanyIds, tableValues_list, doOffset, includeDiffTable);
            }
        } else {
            Vector companys = (Vector)uiContext.get("companyIds");
            Map singlePageCompanyIds = (Map)uiContext.get("singlePageCompanyIds");
            SumHelper.saveItemData(ctx, reportInfo, book, companys, doOffset, includeDiffTable, singlePageCompanyIds, onlyList);
        }
    }

    private static void newSaveType4CM(Context ctx, CslReportInfo reportInfo, Book book, Map uiContext, DynaSumMethodEnum method, boolean doOffset, boolean includeDiffTable, boolean onlyList, boolean isSupportCrossMerger, String unitMap2SerialString) throws BOSException, EASBizException {
        HashMap mapByName = new HashMap(16);
        HashMap mapAll = new HashMap(16);
        HashMap<String, Map> tableValues_list = new HashMap<String, Map>();
        Sheet sheet = null;
        ArrayList basePointList = null;
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        boolean isMergeByFiscalPeriod = values[0];
        boolean isSupport13Period = values[1];
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, reportInfo.getOrgTree());
        }
        HashMap checkMap = new HashMap(8);
        ArrayList<String> sheetIds = new ArrayList<String>(5);
        boolean isSupportInnerExch = reportInfo.getTemplate().isIsSupportInnerExch();
        for (int ibook = 0; ibook < book.getSheetCount(); ++ibook) {
            sheet = book.getSheet(ibook);
            sheet.removeUserObject("FormulaErrorCell");
            basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            if (basePointList == null || basePointList.isEmpty()) continue;
            Point firstBasePoint = (Point)basePointList.get(0);
            DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)firstBasePoint);
            int spreadStyle = params.getSpreadStyle();
            DyRptSaveHelper.checkDynaNameRange(checkMap, sheet, basePointList, spreadStyle, isSupportInnerExch);
            if (!checkMap.isEmpty()) continue;
            boolean hasDItem = DyRptSaveHelper.hasDItem(sheet, basePointList);
            if (hasDItem) {
                DyRptSaveHelper.saveByNameType(ctx, reportInfo, mapByName, sheet, basePointList, isMergeByFiscalPeriod, isSupport13Period, periods, spreadStyle);
                tableValues_list.put(sheet.getSheetName(), SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.LIST_DETAIL_COMP_NAME, true, false, false));
                continue;
            }
            sheetIds.add(sheet.getID());
            DyRptSaveHelper.saveByListAllType(ctx, reportInfo, mapByName, mapAll, sheet, basePointList, isMergeByFiscalPeriod, isSupport13Period, periods, spreadStyle);
        }
        if (!checkMap.isEmpty()) {
            if (uiContext.containsKey("isFromFastMergeSolu") && ((Boolean)uiContext.get("isFromFastMergeSolu")).booleanValue()) {
                String errorMsg = DyRptSaveHelper.wrappedMessage(checkMap, book, true);
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = errorMsg.replaceAll("<br>", "").replaceAll("<[a|A]([^>]*)>", "").replaceAll("</a>", "").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                    uiContext.put("errorMsg", errorMsg);
                    return;
                }
            } else {
                DyRptSaveHelper.showRichMessage(checkMap, book);
                SysUtil.abort();
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(8);
        IItemDataProvider iItemData = ctx == null ? ItemDataProviderFactory.getRemoteInstance() : ItemDataProviderFactory.getLocalInstance(ctx);
        map.put("itemData", mapByName);
        map.put("valueType", new Integer(includeDiffTable ? 2 : 0));
        map.put("dynaType", new Integer(1));
        iItemData.saveDynaItemData(reportInfo.getId().toString(), map);
        map.put("itemData", mapAll);
        map.put("dynaType", new Integer(6));
        if (tableValues_list != null && !tableValues_list.isEmpty()) {
            map.put("sheetIds", sheetIds);
        }
        iItemData.saveDynaItemData(reportInfo.getId().toString(), map);
        DyRptSaveHelper.calcAndSave4ListAllType(ctx, tableValues_list, uiContext, doOffset, includeDiffTable, reportInfo.getId().toString(), isSupportCrossMerger, unitMap2SerialString);
    }

    private static void calcAndSave4ListAllType(Context ctx, Map tableValues_list, Map uiContext, boolean doOffset, boolean includeDiffTable, String reportId, boolean isSupportCrossMerger, String unitMap2SerialString) throws EASBizException, BOSException {
        if (tableValues_list == null || tableValues_list.isEmpty() || isSupportCrossMerger && unitMap2SerialString == null) {
            return;
        }
        HashMap<Object, Object> companyIDs = new HashMap<Object, Object>();
        if (isSupportCrossMerger) {
            boolean isCalcSingle = uiContext.containsKey("singlePageCompanyIds");
            if (isCalcSingle) {
                companyIDs.put("isSingeSheetCal", "");
            }
            companyIDs.put("unitMap2SerialString", unitMap2SerialString);
        } else {
            Vector companys = (Vector)uiContext.get("companyIds");
            Map singlePageCompanyIds = (Map)uiContext.get("singlePageCompanyIds");
            ArrayList<String> cs = new ArrayList<String>();
            if (singlePageCompanyIds != null && !singlePageCompanyIds.isEmpty()) {
                for (Map.Entry entry : singlePageCompanyIds.entrySet()) {
                    Vector company = (Vector)entry.getValue();
                    if (company == null || company.isEmpty()) continue;
                    for (int x = 0; x < company.size(); ++x) {
                        FullOrgUnitInfo com = (FullOrgUnitInfo)company.get(x);
                        cs.add(com.getId().toString());
                    }
                }
                companyIDs.put("isSingeSheetCal", "");
            } else if (companys != null && !companys.isEmpty() && companys.size() > 0) {
                for (int a = 0; a < companys.size(); ++a) {
                    FullOrgUnitInfo com = (FullOrgUnitInfo)companys.get(a);
                    cs.add(com.getId().toString());
                }
            }
            if (cs == null || cs.isEmpty()) {
                return;
            }
            Iterator it = tableValues_list.keySet().iterator();
            while (it.hasNext()) {
                companyIDs.put(it.next(), cs);
            }
        }
        SumHelper.sumDynamicReportAndSave(ctx, reportId, companyIDs, tableValues_list, doOffset, includeDiffTable);
    }

    public static void saveByListAllType(CslReportInfo reportInfo, Map mapByName, Map mapAll, Sheet sheet, ArrayList basePointList, boolean isMergeByFiscalPeriod, boolean isSupport13Period, PeriodCollection periods, int spreadStyle) throws EASBizException, BOSException, RunTimeException {
        DyRptSaveHelper.saveByListAllType(null, reportInfo, mapByName, mapAll, sheet, basePointList, isMergeByFiscalPeriod, isSupport13Period, periods, spreadStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveByListAllType(Context ctx, CslReportInfo reportInfo, Map mapByName, Map mapAll, Sheet sheet, ArrayList basePointList, boolean isMergeByFiscalPeriod, boolean isSupport13Period, PeriodCollection periods, int spreadStyle) throws EASBizException, BOSException, RunTimeException {
        boolean isSupportInnerExch = reportInfo.getTemplate().isIsSupportInnerExch();
        HashMap mapExt = null;
        mapExt = isSupportInnerExch ? DyRptSaveHelper.getDynaNameMap4SupportInner(sheet, basePointList, spreadStyle) : DyRptSaveHelper.getDynaNameMap(sheet, basePointList, spreadStyle);
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        HashMap dynaItemTypes = new HashMap();
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, false, true);
        Range range = null;
        ItemFormula formula = null;
        Map itemMap = DyRptSaveHelper.getItemFormulaMap(sheet, basePointList, spreadStyle, reportInfo, periods, isMergeByFiscalPeriod, isSupport13Period);
        HashMap<Point, DynaItemTypeEnum> dynaItemTypeMap = new HashMap<Point, DynaItemTypeEnum>();
        HashMap dynaParamMap = new HashMap();
        try {
            while (iter.hasNext()) {
                Cell cell = iter.next();
                Point point = new Point(cell.getCol(), cell.getRow());
                if (DyRptSaveHelper.isPointRow(cell, basePointList, spreadStyle)) continue;
                point = DynamicTemplateUtility.getBasePoint((Sheet)sheet, (Point)point, (ArrayList)basePointList, dynaParamMap);
                DynaItemTypeEnum dynaItemType = null;
                if (dynaItemTypeMap.containsKey(point)) {
                    dynaItemType = (DynaItemTypeEnum)dynaItemTypeMap.get(point);
                } else {
                    dynaItemType = DyRptSaveHelper.getDynaItemType(ctx, sheet, point, dynaItemTypes);
                    dynaItemTypeMap.put(point, dynaItemType);
                }
                range = sheet.getRange(cell.getRow(), cell.getCol());
                if (point == null || DyRptSaveHelper.isSumLine(sheet, point, cell.getRow(), cell.getCol())) {
                    formula = (ItemFormula)range.getUserObject("ITEM");
                    DyRptSaveHelper.offsetYearAndPeriod(formula, reportInfo, periods, isMergeByFiscalPeriod, isSupport13Period);
                    DyRptSaveHelper.setItemDataByH(ctx, reportInfo, sheet, range, formula, cell.getRow(), cell.getCol(), mapByName, mapExt, dynaItemType.getValue(), point);
                    continue;
                }
                boolean isValueNull = false;
                if (range.getValue() == null || range.getValue().isEmpty() || range.getValue().getValue() == null || range.getValue().getValue().toString().trim().equals("") || range.getValue().getValue().toString().trim().equals("0") || range.getText() == null || range.getText().toString().trim().equals("0")) {
                    if (ElimReportUtils.isElimReport(reportInfo)) continue;
                    isValueNull = true;
                }
                if ((formula = DyRptSaveHelper.getItemFormula(point, spreadStyle, cell.getRow(), cell.getCol(), itemMap)) == null) continue;
                String ks = DyRptSaveHelper.getItemKey(ctx, formula);
                String[] keyNames = DyRptSaveHelper.getKeyNameNew(cell.getRow(), cell.getCol(), mapExt, reportInfo.getOrgUnit().getName());
                if (StringUtils.isEmpty((String)keyNames[0]) && StringUtils.isEmpty((String)keyNames[1])) {
                    if (isValueNull) continue;
                    String cellName = Location.getCellName(cell.getRow(), cell.getCol());
                    String str = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslReportBCannotFindNameInCell");
                    throw new RunTimeException(RunTimeException.CUSTOMEXCEPTION, new Object[]{MessageFormat.format(str, sheet.getSheetName() + "!" + cellName)});
                }
                DyRptSaveHelper.setItemDataByHNew(ctx, reportInfo, sheet, range, formula, cell.getRow(), cell.getCol(), mapAll, dynaItemType.getValue(), point, ks, keyNames[0], false);
                DyRptSaveHelper.setItemDataByHNew(ctx, reportInfo, sheet, range, formula, cell.getRow(), cell.getCol(), mapByName, dynaItemType.getValue(), point, ks, keyNames[1], true);
            }
        }
        finally {
            dynaItemTypeMap.clear();
            dynaParamMap.clear();
        }
    }

    private static String dealInnerFlag(String keyName) {
        return keyName != null ? keyName.replaceFirst(SUPPORT_INNER_FLAG, "") : keyName;
    }

    private static void setItemDataByHNew(Context ctx, CslReportInfo report, Sheet sheet, Range range, ItemFormula f, int r, int c, Map mapH, int dynaItemType, Point basePoint, String ks, String keyName, boolean saveByName) throws EASBizException, BOSException {
        ArrayList valueList;
        String noFlagkeyName = DyRptSaveHelper.dealInnerFlag(keyName);
        Variant var = range.getValue();
        Map mapD = DyRptSaveHelper.getMapD(f, mapH, ks);
        Object v_item = DyRptSaveHelper.getItemValue(ctx, report, range, f, var, noFlagkeyName);
        if (saveByName && mapD.containsKey(noFlagkeyName)) {
            valueList = (ArrayList)mapD.get(noFlagkeyName);
            Object dynaValue = valueList.remove(0);
            if (f.getValueType() == 3) {
                valueList.add(0, new StringBuffer().append(dynaValue).append(";").append(v_item).toString());
            } else {
                valueList.add(0, ((BigDecimal)dynaValue).add((BigDecimal)v_item));
            }
        } else {
            valueList = DyRptSaveHelper.getValueListNew(sheet, r, c, dynaItemType, v_item, keyName);
            mapD.put(noFlagkeyName, valueList);
        }
        HashMap value1 = (HashMap)mapH.get(ks);
        if (value1 != null && value1.isEmpty()) {
            mapH.remove(ks);
        }
    }

    private static String[] getKeyNameNew(int r, int c, HashMap mapExt, String orgUnitName) throws RunTimeException {
        String keyName = DyRptSaveHelper.getKeyName(r, c, mapExt);
        String key4Name = null;
        String key4All = null;
        if (!StringUtils.isEmpty((String)keyName)) {
            int begin = keyName.indexOf(SPLIT_BEGIN);
            if (begin >= 0) {
                if (begin == 0) {
                    int end = keyName.lastIndexOf(SPLIT_END);
                    if (end + 1 == keyName.length()) {
                        end = keyName.indexOf(SPLIT_END);
                    }
                    key4Name = end == 0 || end + 1 == keyName.length() ? keyName : keyName.substring(end + 1);
                    key4All = keyName;
                } else {
                    key4Name = keyName.substring(0, begin);
                    key4All = new StringBuffer(keyName.substring(begin)).append(key4Name).toString();
                }
            } else {
                key4Name = keyName;
                key4All = keyName;
            }
        }
        return new String[]{key4All, key4Name};
    }

    private static String getKeyName(int r, int c, HashMap mapExt) throws RunTimeException {
        String keyName = DyRptSaveHelper.getDynaName(mapExt, r, c);
        return keyName;
    }

    public static void saveByNameType(CslReportInfo reportInfo, Map mapByName, Sheet sheet, ArrayList basePointList, boolean isMergeByFiscalPeriod, boolean isSupport13Period, PeriodCollection periods, int spreadStyle) throws EASBizException, BOSException {
        DyRptSaveHelper.saveByNameType(null, reportInfo, mapByName, sheet, basePointList, isMergeByFiscalPeriod, isSupport13Period, periods, spreadStyle);
    }

    public static void saveByNameType(Context ctx, CslReportInfo reportInfo, Map mapByName, Sheet sheet, ArrayList basePointList, boolean isMergeByFiscalPeriod, boolean isSupport13Period, PeriodCollection periods, int spreadStyle) throws EASBizException, BOSException {
        HashMap mapExt = DyRptSaveHelper.getDynaNameMap(sheet, basePointList, spreadStyle);
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        HashMap dynaItemTypes = new HashMap();
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, false, true);
        Range range = null;
        ItemFormula formula = null;
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (DyRptSaveHelper.isPointRow(cell, basePointList, spreadStyle) || (formula = (ItemFormula)(range = sheet.getRange(cell.getRow(), cell.getCol())).getUserObject("ITEM")) == null || formula.getFormula() == null) continue;
            DyRptSaveHelper.offsetYearAndPeriod(formula, reportInfo, periods, isMergeByFiscalPeriod, isSupport13Period);
            Point point = new Point(cell.getCol(), cell.getRow());
            point = DynamicTemplateUtility.getBasePoint((Sheet)sheet, (Point)point, (ArrayList)basePointList);
            DynaItemTypeEnum dynaItemType = DyRptSaveHelper.getDynaItemType(ctx, sheet, point, dynaItemTypes);
            DyRptSaveHelper.setItemDataByH(ctx, reportInfo, sheet, range, formula, cell.getRow(), cell.getCol(), mapByName, mapExt, dynaItemType.getValue(), point);
        }
    }

    private static void offsetYearAndPeriod(ItemFormula formula, CslReportInfo report, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) throws EASBizException, BOSException {
        RptCalcHelper.offsetYearAndPeriod(isMergeByFiscalPeriod, isSupport13Period, report.getPeriodType(), report.getYear(), report.getPeriod(), formula, periods);
    }

    private static boolean isPointRow(Cell cell, ArrayList basePointList, int spreadStyle) {
        Point point = null;
        for (int i = 0; i < basePointList.size(); ++i) {
            point = (Point)basePointList.get(i);
            if (i == 0 && (cell.getRow() < point.y || cell.getCol() < point.x)) {
                return true;
            }
            if (!(spreadStyle == 0 ? cell.getRow() == point.y : cell.getCol() == point.x)) continue;
            return true;
        }
        return false;
    }

    private static ItemFormula getItemFormula(Point point, int spreadStyle, int row, int col, Map itemMap) {
        if (point == null) {
            return null;
        }
        if (spreadStyle == 0) {
            return (ItemFormula)itemMap.get(new Point(col, point.y));
        }
        return (ItemFormula)itemMap.get(new Point(point.x, row));
    }

    private static Map getItemFormulaMap(Sheet sheet, ArrayList basePointList, int spreadStyle, CslReportInfo report, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) throws EASBizException, BOSException {
        HashMap<Point, ItemFormula> itemMap;
        block5: {
            Point p;
            ItemFormula formula;
            Range range;
            int rowCount;
            block4: {
                itemMap = new HashMap<Point, ItemFormula>(16);
                rowCount = sheet.getRows().getMaxIntMark() + 1;
                int colCount = sheet.getCols().getMaxIntMark() + 1;
                range = null;
                formula = null;
                p = null;
                if (spreadStyle != 0) break block4;
                for (int i = basePointList.size() - 1; i >= 0; --i) {
                    p = (Point)basePointList.get(i);
                    for (int col = p.x + 1; col < colCount; ++col) {
                        range = sheet.getRange(p.y, col);
                        formula = (ItemFormula)range.getUserObject("ITEM");
                        if (formula == null) continue;
                        DyRptSaveHelper.offsetYearAndPeriod(formula, report, periods, isMergeByFiscalPeriod, isSupport13Period);
                        itemMap.put(new Point(col, p.y), formula);
                    }
                }
                break block5;
            }
            if (spreadStyle != 1) break block5;
            for (int i = basePointList.size() - 1; i >= 0; --i) {
                p = (Point)basePointList.get(i);
                for (int row = p.y + 1; row < rowCount; ++row) {
                    range = sheet.getRange(p.x, row);
                    formula = (ItemFormula)range.getUserObject("ITEM");
                    if (formula == null) continue;
                    DyRptSaveHelper.offsetYearAndPeriod(formula, report, periods, isMergeByFiscalPeriod, isSupport13Period);
                    itemMap.put(new Point(row, p.x), formula);
                }
            }
        }
        return itemMap;
    }

    private static boolean isSumLine(Sheet sheet, Point basePoint, int row, int col) {
        boolean isLeftUp;
        if (basePoint == null) {
            return false;
        }
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        if (param == null) {
            return false;
        }
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        int sumFormulaCount = indexHandle.getSumRangeCount();
        int count = param.getDefaultCounter();
        int spreadStyle = param.getSpreadStyle();
        boolean bl = isLeftUp = param.getPosition() == 1;
        return spreadStyle == 0 ? row > basePoint.y && row <= basePoint.y + boforeSumFormulaCount || row > basePoint.y + boforeSumFormulaCount + count && row <= basePoint.y + count + sumFormulaCount : row > basePoint.x && row <= basePoint.x + boforeSumFormulaCount || row > basePoint.x + boforeSumFormulaCount + count && row <= basePoint.x + count + sumFormulaCount;
    }

    private static void setItemDataByH(CslReportInfo report, Sheet sheet, Range range, ItemFormula f, int r, int c, Map mapH, HashMap mapExt, int dynaItemType, Point basePoint) throws EASBizException, BOSException {
        DyRptSaveHelper.setItemDataByH(null, report, sheet, range, f, r, c, mapH, mapExt, dynaItemType, basePoint);
    }

    private static void setItemDataByH(Context ctx, CslReportInfo report, Sheet sheet, Range range, ItemFormula f, int r, int c, Map mapH, HashMap mapExt, int dynaItemType, Point basePoint) throws EASBizException, BOSException {
        HashMap value1;
        Object cellValue;
        if (f == null) {
            return;
        }
        String dNumber = f.getDItemNumber();
        if (dNumber == null || dNumber.length() == 0) {
            if (basePoint == null || DyRptSaveHelper.isSumLine(sheet, basePoint, r, c)) {
                dNumber = HandDyItemNumber + f.getItemNumber();
            } else {
                return;
            }
        }
        String ks = DyRptSaveHelper.getItemKey(ctx, f);
        Variant var = range.getValue();
        Object object = cellValue = var.isEmpty() ? null : var.getValue();
        if (cellValue != null && !cellValue.toString().equals("")) {
            Number number;
            BigDecimal bd;
            Map mapD = DyRptSaveHelper.getMapD(f, mapH, ks);
            Object v_item = DyRptSaveHelper.getItemValue(ctx, report, range, f, var, dNumber);
            if (ElimReportUtils.isElimReport(report) && v_item instanceof Number && (bd = new BigDecimal((number = (Number)v_item).toString())).compareTo(new BigDecimal("0.0")) == 0) {
                return;
            }
            ArrayList valueList = DyRptSaveHelper.getValueList(sheet, r, c, mapExt, dynaItemType, v_item);
            mapD.put(dNumber, valueList);
        }
        if ((value1 = (HashMap)mapH.get(ks)) != null && value1.isEmpty()) {
            mapH.remove(ks);
        }
    }

    private static ArrayList getValueListNew(Sheet sheet, int r, int c, int dynaItemType, Object v_item, String keyName) throws RunTimeException {
        ArrayList<Object> valueList = new ArrayList<Object>(7);
        boolean isSupportInnerExch = keyName != null && keyName.indexOf(SUPPORT_INNER_FLAG) != -1 && dynaItemType != 10;
        valueList.add(0, v_item);
        valueList.add(1, keyName != null ? keyName.replaceFirst(SUPPORT_INNER_FLAG, "") : keyName);
        valueList.add(2, new Integer(dynaItemType));
        valueList.add(3, new Integer(r));
        valueList.add(4, new Integer(c));
        valueList.add(5, sheet.getID());
        valueList.add(6, null);
        valueList.add(7, new Boolean(true));
        valueList.add(8, isSupportInnerExch);
        return valueList;
    }

    public static HashMap getDynaNameMap4SupportInner(Sheet sheet, ArrayList basePointList, int spreadStyle) {
        HashMap<Point, String> dynaNameMap;
        block5: {
            int colCount;
            Point firstBasePoint;
            block4: {
                dynaNameMap = new HashMap<Point, String>();
                firstBasePoint = (Point)basePointList.get(0);
                int rowCount = sheet.getRows().getMaxIntMark() + 1;
                colCount = sheet.getCols().getMaxIntMark() + 1;
                if (spreadStyle != 0) break block4;
                for (int i = firstBasePoint.y; i < rowCount; ++i) {
                    String ownerCompanyName;
                    Point pt = new Point(firstBasePoint.x, i);
                    String displayText = sheet.getRange(i, firstBasePoint.x).getText();
                    displayText = displayText == null ? "" : displayText.trim();
                    String string = ownerCompanyName = firstBasePoint.x - 1 < 0 ? "" : sheet.getRange(i, firstBasePoint.x - 1).getText();
                    if (!StringUtils.isEmpty((String)ownerCompanyName) && displayText.indexOf(ownerCompanyName) == -1 && displayText.indexOf(91) == -1 && displayText.indexOf(93) == -1) {
                        displayText = SPLIT_BEGIN + ownerCompanyName + SUPPORT_INNER_FLAG + SPLIT_END + displayText;
                    }
                    dynaNameMap.put(pt, displayText);
                }
                break block5;
            }
            if (spreadStyle != 1) break block5;
            for (int i = firstBasePoint.x; i < colCount; ++i) {
                String ownerCompanyName;
                Point pt = new Point(i, firstBasePoint.y);
                String displayText = sheet.getRange(firstBasePoint.y, i).getText();
                displayText = displayText == null ? "" : displayText.trim();
                String string = ownerCompanyName = firstBasePoint.y - 1 < 0 ? "" : sheet.getRange(firstBasePoint.y - 1, i).getText();
                if (!StringUtils.isEmpty((String)ownerCompanyName) && displayText.indexOf(ownerCompanyName) == -1) {
                    displayText = SPLIT_BEGIN + ownerCompanyName + SUPPORT_INNER_FLAG + SPLIT_END + displayText;
                }
                dynaNameMap.put(pt, displayText);
            }
        }
        return dynaNameMap;
    }

    private static ArrayList getValueList(Sheet sheet, int r, int c, HashMap mapExt, int dynaItemType, Object v_item) throws RunTimeException {
        String keyName = DyRptSaveHelper.getKeyName(r, c, mapExt);
        return DyRptSaveHelper.getValueListNew(sheet, r, c, dynaItemType, v_item, keyName);
    }

    private static Object getItemValue(Context ctx, CslReportInfo report, Range range, ItemFormula f, Variant var, String keyName) throws EASBizException, BOSException {
        Object v_item = null;
        if (f.getValueType() == 3) {
            v_item = range.getText();
        } else {
            if (var.isNumeric()) {
                try {
                    v_item = var.toBigDecimal();
                }
                catch (SyntaxErrorException e) {
                    v_item = range.getText();
                }
            } else {
                v_item = range.getText();
            }
            if (v_item != null && v_item instanceof String) {
                try {
                    v_item = new BigDecimal(range.getText());
                }
                catch (NumberFormatException e) {
                    if (ctx == null) {
                        AdjustException adjustException = new AdjustException(AdjustException.FILLVALUE_ERROR, new Object[]{keyName, ValueTypeEnum.getEnum(f.getValueType()).getAlias(), DataElementProvider.getDataElementName(f.getDataElementNumber()), new Integer(f.getYear()), new Integer(f.getPeriod()), range.getText(), report.getOrgUnit().getNumber() + "-" + report.getOrgUnit().getName(), report.getName(), "\n"});
                        DyRptSaveHelper.showRichMessage(adjustException.getMessage(), DesignerResource.getString((String)"saveFail").replaceAll("\uff0c", ""));
                        SysUtil.abort();
                    }
                    throw new BOSException("getItemValue error:range.getText() is:" + range.getText() + "reportId:" + report.getId() + "range:" + range.toString(), (Throwable)e);
                }
            }
        }
        return v_item;
    }

    private static Map getMapD(ItemFormula f, Map mapH, String ks) {
        HashMap value = null;
        if (!mapH.containsKey(ks)) {
            value = new HashMap();
            mapH.put(ks, value);
        } else {
            value = (HashMap)mapH.get(ks);
        }
        String itemNumber = f.getItemNumber();
        Map mapD = null;
        if (!value.containsKey(itemNumber)) {
            mapD = new HashMap();
            value.put(itemNumber, mapD);
        } else {
            mapD = (Map)value.get(itemNumber);
        }
        return mapD;
    }

    private static String getItemKey(ItemFormula f) throws BOSException, EASBizException {
        return DyRptSaveHelper.getItemKey(null, f);
    }

    private static String getItemKey(Context ctx, ItemFormula f) throws BOSException, EASBizException {
        StringBuffer key = new StringBuffer();
        if (ctx == null) {
            key.append(DataElementProvider.getDataElementInnerValue(f.getDataElementNumber()));
        } else {
            key.append(DataElementProvider.getDataElementInnerValue(ctx, f.getDataElementNumber()));
        }
        key.append(",");
        key.append(f.getValueType());
        key.append(",");
        key.append(f.getYear());
        key.append(",");
        key.append(f.getPeriod());
        key.append(",");
        key.append(f.getDay().toString());
        return key.toString();
    }

    private static String getDynaName(HashMap mapExt, int r, int c) {
        if (mapExt == null) {
            return null;
        }
        for (Point element : mapExt.keySet()) {
            if (r != element.y && c != element.x) continue;
            return (String)mapExt.get(element);
        }
        return null;
    }

    public static void checkDynaNameRange(Map checkMap, Sheet sheet, ArrayList basePointList, int spreadStyle, boolean isSupportInner) {
        block11: {
            int boforeSumFormulaCount;
            DynaRptBasePointIndexHandle indexHandle;
            boolean needChckInnerCompStr;
            String origDisplayText;
            String displayText;
            HashMap<String, String> nameMap;
            Range range;
            Point p;
            DynaParameters param;
            block10: {
                param = null;
                p = null;
                range = null;
                nameMap = new HashMap<String, String>();
                displayText = null;
                origDisplayText = null;
                needChckInnerCompStr = false;
                indexHandle = null;
                boforeSumFormulaCount = 0;
                if (spreadStyle != 0) break block10;
                int rowCount = 0;
                for (int i = 0; i < basePointList.size(); ++i) {
                    p = (Point)basePointList.get(i);
                    param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)p);
                    indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
                    boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
                    int begin = p.y + boforeSumFormulaCount;
                    needChckInnerCompStr = false;
                    needChckInnerCompStr = isSupportInner && p.x - 1 >= 0;
                    rowCount = begin + param.getDefaultCounter();
                    for (int j = begin + 1; j <= rowCount; ++j) {
                        range = sheet.getRange(j, p.x);
                        if (range.getUserObject("isSum") != null && range.getUserObject("isSum").equals("Y")) continue;
                        range.setUserObject("OWNERCELL", null);
                        range.setUserObject("SOURCECELL", null);
                        origDisplayText = displayText = range.getText();
                        if (StringUtils.isEmpty((String)displayText)) continue;
                        if (needChckInnerCompStr && !StringUtils.isEmpty((String)sheet.getRange(j, p.x - 1).getText())) {
                            displayText = sheet.getRange(j, p.x - 1).getText() + displayText;
                        }
                        if (nameMap.containsKey(displayText)) {
                            ArrayList<Range> l = (ArrayList<Range>)checkMap.get(sheet.getSheetName());
                            if (l == null) {
                                l = new ArrayList<Range>();
                                checkMap.put(sheet.getSheetName(), l);
                            }
                            range.setUserObject("OWNERCELL", (Object)TableToolkit.xy2range((int)p.x, (int)j));
                            range.setUserObject("SOURCECELL", nameMap.get(displayText));
                            l.add(range);
                            continue;
                        }
                        nameMap.put(displayText, TableToolkit.xy2range((int)p.x, (int)j));
                    }
                    nameMap.clear();
                }
                break block11;
            }
            if (spreadStyle != 1) break block11;
            int colCount = 0;
            for (int i = 0; i < basePointList.size(); ++i) {
                p = (Point)basePointList.get(i);
                param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)p);
                indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
                boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
                int begin = p.x + boforeSumFormulaCount;
                colCount = begin + param.getDefaultCounter();
                needChckInnerCompStr = false;
                needChckInnerCompStr = isSupportInner && p.y - 1 >= 0;
                for (int j = begin + 1; j <= colCount; ++j) {
                    range = sheet.getRange(p.y, j);
                    if (range.getUserObject("isSum") != null && range.getUserObject("isSum").equals("Y")) continue;
                    range.setUserObject("OWNERCELL", null);
                    range.setUserObject("SOURCECELL", null);
                    origDisplayText = displayText = range.getText();
                    if (StringUtils.isEmpty((String)displayText)) continue;
                    if (needChckInnerCompStr && !StringUtils.isEmpty((String)sheet.getRange(j - 1, p.x).getText())) {
                        displayText = sheet.getRange(j - 1, p.x).getText() + displayText;
                    }
                    if (nameMap.containsKey(displayText)) {
                        ArrayList<Range> l = (ArrayList<Range>)checkMap.get(sheet.getSheetName());
                        if (l == null) {
                            l = new ArrayList<Range>();
                            checkMap.put(sheet.getSheetName(), l);
                        }
                        range.setUserObject("OWNERCELL", (Object)TableToolkit.xy2range((int)j, (int)p.y));
                        range.setUserObject("SOURCECELL", nameMap.get(displayText));
                        l.add(range);
                        continue;
                    }
                    nameMap.put(displayText, TableToolkit.xy2range((int)j, (int)p.y));
                }
                nameMap.clear();
            }
        }
    }

    public static HashMap getDynaNameMap(Sheet sheet, ArrayList basePointList, boolean isAddItem_Point) {
        HashMap<Object, Cloneable> dynaNameMap = new HashMap<Object, Cloneable>();
        int rowCount = sheet.getRows().getMaxIntMark() + 1;
        int colCount = sheet.getCols().getMaxIntMark() + 1;
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < basePointList.size(); ++i) {
            int j;
            int end;
            HashMap<Point, String> curNameMap = new HashMap<Point, String>();
            Point point = (Point)basePointList.get(i);
            DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)point);
            boolean isVertical = params.getSpreadStyle() == 0;
            int start = isVertical ? point.y : point.x;
            int n = end = isVertical ? rowCount : colCount;
            if (i + 1 < basePointList.size()) {
                end = isVertical ? ((Point)basePointList.get((int)(i + 1))).y : ((Point)basePointList.get((int)(i + 1))).x;
            }
            for (j = start; j < end; ++j) {
                Point pt = isVertical ? new Point(point.x, j) : new Point(j, point.y);
                String displayText = sheet.getRange(pt.y, pt.x).getText();
                displayText = displayText == null ? "" : displayText.trim();
                curNameMap.put(pt, displayText);
            }
            if (!curNameMap.isEmpty()) {
                dynaNameMap.put(point, curNameMap);
            }
            if (!isAddItem_Point) continue;
            start = isVertical ? point.x : point.y;
            end = isVertical ? colCount : rowCount;
            for (j = start; j < end; ++j) {
                ItemFormula itemFormula = UserObjectHelper.getItemFormula((Cell)sheet.getCell(isVertical ? point.y : j, isVertical ? j : point.x, false));
                if (itemFormula == null) continue;
                key.setLength(0);
                ElimReportUtils.combineKey(key, itemFormula.getItemNumber());
                ElimReportUtils.combineKey(key, itemFormula.getDataElementNumber());
                ElimReportUtils.combineKey(key, String.valueOf(itemFormula.getValueType()));
                dynaNameMap.put(key.toString(), point);
            }
        }
        return dynaNameMap;
    }

    public static HashMap getDynaNameMap(Sheet sheet, ArrayList basePointList, int spreadStyle) {
        HashMap<Point, String> dynaNameMap;
        block3: {
            int colCount;
            Point firstBasePoint;
            block2: {
                dynaNameMap = new HashMap<Point, String>();
                firstBasePoint = (Point)basePointList.get(0);
                int rowCount = sheet.getRows().getMaxIntMark() + 1;
                colCount = sheet.getCols().getMaxIntMark() + 1;
                if (spreadStyle != 0) break block2;
                for (int i = firstBasePoint.y; i < rowCount; ++i) {
                    Point pt = new Point(firstBasePoint.x, i);
                    String displayText = sheet.getRange(i, firstBasePoint.x).getText();
                    displayText = displayText == null ? "" : displayText.trim();
                    dynaNameMap.put(pt, displayText);
                }
                break block3;
            }
            if (spreadStyle != 1) break block3;
            for (int i = firstBasePoint.x; i < colCount; ++i) {
                Point pt = new Point(i, firstBasePoint.y);
                String displayText = sheet.getRange(firstBasePoint.y, i).getText();
                displayText = displayText == null ? "" : displayText.trim();
                dynaNameMap.put(pt, displayText);
            }
        }
        return dynaNameMap;
    }

    public static void showRichMessage(Map checkMap, Book book) throws UIException {
        String rich = DyRptSaveHelper.wrappedMessage(checkMap, book, false);
        UIContext uiContext = new UIContext(null);
        uiContext.put((Object)"String", (Object)rich.toString());
        uiContext.put((Object)"book", (Object)book);
        uiContext.put((Object)"id", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static String wrappedMessage(Map checkMap, Book book, boolean isNoHTMLLabel) {
        StringBuffer rich = new StringBuffer();
        Object sheetName2 = null;
        List l = null;
        Range rang = null;
        Sheet sheet = null;
        SumcalcRange sumcalcRange = new SumcalcRange();
        for (Object sheetName2 : checkMap.keySet()) {
            sheet = book.getSheet(sheetName2.toString());
            sumcalcRange = new SumcalcRange();
            l = (List)checkMap.get(sheetName2);
            if (!isNoHTMLLabel) {
                rich.append("<font color=\"#000080\"><b>");
                rich.append(sheetName2).append("</b></font><br>");
            } else {
                rich.append(sheetName2);
            }
            for (int i = 0; i < l.size(); ++i) {
                rang = (Range)l.get(i);
                sumcalcRange.addCellBlock(rang.getBounds());
                Object ownerCell = rang.getUserObject("OWNERCELL");
                Object sourceCell = rang.getUserObject("SOURCECELL");
                rich.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"1_cell") + "<a href=\"null,").append(sheetName2).append(",").append(ownerCell).append("\">");
                rich.append(ownerCell).append("</a>").append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"2_listItem"));
                rich.append(rang.getText());
                rich.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"3_andCell") + "<a href=\"null,").append(sheetName2).append(",").append(sourceCell).append("\">");
                rich.append(sourceCell).append("</a>");
                rich.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"4_haveReName") + "\n<br>");
            }
            sheet.setUserObject("FormulaErrorCell", (Object)sumcalcRange);
            rich.append("<br>");
        }
        return rich.toString();
    }

    private static void showRichMessage(String rich, String title) {
        UIContext uiCtx = new UIContext(null);
        uiCtx.put((Object)"Title", (Object)title);
        uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
        SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)rich);
    }

    private static DynaItemTypeEnum getDynaItemType(Sheet sheet, Point point, Map dynaItemTypes) throws BOSException, EASBizException {
        return DyRptSaveHelper.getDynaItemType(null, sheet, point, dynaItemTypes);
    }

    private static DynaItemTypeEnum getDynaItemType(Context ctx, Sheet sheet, Point point, Map dynaItemTypes) throws BOSException, EASBizException {
        if (point == null) {
            return DynaItemTypeEnum.Other;
        }
        DynaItemTypeEnum type = null;
        if (dynaItemTypes.containsKey(point.x + "&" + point.y)) {
            type = (DynaItemTypeEnum)dynaItemTypes.get(point.x + "&" + point.y);
        } else {
            AsstActTypeInfo asstActTypeInfo;
            String asstType;
            DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)point);
            type = params.getDynaItemSource() == 0 ? DynaItemTypeEnum.ManualImport : ((asstType = (asstActTypeInfo = DyRptSaveHelper.getAsstActType(ctx, params.getAssistantType().properityName)).getAsstHGAttribute()).equals("companyOrg") ? DynaItemTypeEnum.Company : (asstType.equals("customer") ? DynaItemTypeEnum.Custom : (asstType.equals("provider") ? DynaItemTypeEnum.Provider : DynaItemTypeEnum.Other)));
            dynaItemTypes.put(point.x + "&" + point.y, type);
        }
        return type;
    }

    private static AsstActTypeInfo getAsstActType(String number) throws EASBizException, BOSException {
        return DyRptSaveHelper.getAsstActType(null, number);
    }

    private static AsstActTypeInfo getAsstActType(Context ctx, String number) throws EASBizException, BOSException {
        String sql = " where number = '" + number + "'";
        IAsstActType iType = null;
        iType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
        if (iType.exists(sql)) {
            return (AsstActTypeInfo)iType.getValue(sql);
        }
        return null;
    }

    public static boolean hasDItem(Sheet sheet, ArrayList basePointList) {
        DynaParameters param = null;
        Point p = null;
        DynaRptBasePointIndexHandle indexHandle = null;
        int boforeSumFormulaCount = 0;
        if (basePointList == null || basePointList.isEmpty()) {
            basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        }
        if (basePointList == null) {
            return false;
        }
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            p = (Point)basePointList.get(i);
            param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)p);
            indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
            boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
            int spreadStyle = param.getSpreadStyle();
            int rowCount = param.getDefaultCounter();
            int rowIndex = 0;
            for (int x = rowCount; x > 0; --x) {
                Sheet.ICellsIterator it = null;
                rowIndex = x + boforeSumFormulaCount;
                it = spreadStyle == 0 ? sheet.getCellsIterator(rowIndex + p.y, p.x + 1, rowIndex + p.y, sheet.getMaxColIndex(), false, true) : sheet.getCellsIterator(p.y + 1, rowIndex + p.x, sheet.getMaxRowIndex(), rowIndex + p.x, false, true);
                while (it.hasNext()) {
                    Cell cell = it.next();
                    ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                    if (item == null || item.isBasePoint()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean allBasePointIsNotGrade(Sheet sheet) {
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        DynaParameters param = null;
        for (int i = basePointList.size() - 1; i >= 0; --i) {
            Point p = (Point)basePointList.get(i);
            param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)p);
            if (param.getDynaItemSource() != 0 || !param.isGrade()) continue;
            return false;
        }
        return true;
    }
}

