/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDay;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvestDayUtil {
    private static final BigDecimal ZERO = new BigDecimal("0");

    private static IRowSet getEndOfYearInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException {
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfYear);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        return rowSet;
    }

    private static IRowSet getFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" order by FChangeDate asc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    private static IRowSet getThisYearInvests(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, boolean isIncludeFirst) throws BOSException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        if (!isIncludeFirst) {
            IRowSet firstInvest = InvestDayUtil.getFirstInvest(ctx, companyId, targetCompanyId, currencyId);
            try {
                Date first;
                if (firstInvest.next() && DateTimeUtils.getYear((java.util.Date)(first = firstInvest.getDate("FChangeDate"))) == year) {
                    beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(first));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        if (isIncludeFirst) {
            sql.append(" and FChangeDate >= " + beginOfYear);
        } else {
            sql.append(" and FChangeDate > " + beginOfYear);
        }
        sql.append(" and FChangeDate <= " + endOfYear);
        sql.append(" order by FChangeDate asc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    public static List getEndOfLastYearOwnerSum(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded, boolean isChanged) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                if (expanded) {
                    int flag = isChanged ? 1 : 0;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = ?");
                    sql.append(" and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = ?");
                    Object[] param = new Object[]{info.getString("FID"), new Integer(flag)};
                    IRowSet entry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                    while (entry.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("RPTITEM_ID", entry.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", entry.getBigDecimal("famount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                if (isChanged) {
                    data.put("Value", info.getBigDecimal("FOwnerSumNew"));
                } else {
                    data.put("Value", info.getBigDecimal("FOwnerSumOld"));
                }
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getEndOfLastYearHonorSum(Context ctx, String companyID, String targetCompanyID, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonorSum"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getEndOfLastYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, int year) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestAmout"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getEndOfLastYearSumInvestRate(Context ctx, String companyID, String targetCompanyID, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year - 1);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getFirstOwnerSum(Context ctx, String companyID, String targetCompanyID, boolean expanded, boolean isChanged) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                if (expanded) {
                    int flag = isChanged ? 1 : 0;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = ?");
                    sql.append(" and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = ?");
                    Object[] param = new Object[]{info.getString("FID"), new Integer(flag)};
                    IRowSet entry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                    while (entry.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("RPTITEM_ID", entry.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", entry.getBigDecimal("FAmount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                if (isChanged) {
                    data.put("Value", info.getBigDecimal("FOwnerSumNew"));
                } else {
                    data.put("Value", info.getBigDecimal("FOwnerSumOld"));
                }
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getFirstHonor(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonor"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getFirstSumInvestAmount(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestAmout"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getFirstMinority(Context ctx, String companyID, String targetCompanyID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getFirstInvest(ctx, companyID, targetCompanyID, currencyId);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FMinorityChange"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static List getThisYearMinoritySum(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumMinority = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal minority = invests.getBigDecimal("FMinorityChange");
                    if (minority == null) {
                        minority = ZERO;
                    }
                    sumMinority = sumMinority.add(minority);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumMinority.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumMinority);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearHonorSum(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumHonor = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal honor = invests.getBigDecimal("FHonor");
                    if (honor == null) {
                        honor = ZERO;
                    }
                    sumHonor = sumHonor.add(honor);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumHonor.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumHonor);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearOwnerSum(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            if (expanded) {
                HashMap<String, BigDecimal> sumItem = new HashMap<String, BigDecimal>();
                try {
                    while (invests.next()) {
                        BigDecimal sum;
                        BigDecimal amount;
                        String itemid;
                        StringBuffer sql = new StringBuffer();
                        sql.append("select t1.fitemid, t1.famount");
                        sql.append(" from t_csl_investDayEntry t1");
                        sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                        sql.append(" where t1.finvestDayId = ?");
                        sql.append(" and t1.fcontrolAttr = ");
                        sql.append(20);
                        sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                        sql.append(" and FAssistantFlag = ?");
                        Object[] param = new Object[]{invests.getString("FID"), new Integer(1)};
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                        while (rowSet.next()) {
                            itemid = rowSet.getString("fitemid");
                            amount = rowSet.getBigDecimal("FAmount");
                            if (amount == null) continue;
                            sum = (BigDecimal)sumItem.get(itemid);
                            if (sum == null) {
                                sum = ZERO;
                            }
                            sumItem.put(itemid, sum.add(amount));
                        }
                        param[1] = new Integer(0);
                        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                        while (rowSet.next()) {
                            itemid = rowSet.getString("fitemid");
                            amount = rowSet.getBigDecimal("FAmount");
                            if (amount == null) continue;
                            sum = (BigDecimal)sumItem.get(itemid);
                            if (sum == null) {
                                sum = ZERO;
                            }
                            sumItem.put(itemid, sum.subtract(amount));
                        }
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                for (String itemid : sumItem.keySet()) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("RPTITEM_ID", itemid);
                    data.put("KEY_CURRENCY_ID", currencyId);
                    data.put("Value", (String)sumItem.get(itemid));
                    result.add(data);
                }
                continue;
            }
            BigDecimal sumOwner = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal ownernew = invests.getBigDecimal("FOwnerSumNew");
                    BigDecimal ownerold = invests.getBigDecimal("FOwnerSumOld");
                    sumOwner = sumOwner.add(ownernew.subtract(ownerold));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumOwner.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumOwner);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, int year, boolean isIncludeFirst) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, isIncludeFirst);
            BigDecimal sumInvestAmount = ZERO;
            try {
                while (invests.next()) {
                    BigDecimal investAmount = invests.getBigDecimal("FInvestAmount");
                    sumInvestAmount = sumInvestAmount.add(investAmount);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumInvestAmount.compareTo(ZERO) == 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumInvestAmount);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearProfit(Context ctx, String companyID, String targetCompanyID, int year, boolean expanded) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getFirstThisYearInvest(ctx, companyID, targetCompanyID, currencyId, year);
            if (info == null) continue;
            try {
                if (!info.next()) continue;
                if (expanded) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = '");
                    sql.append(info.getString("FID"));
                    sql.append("' and t1.fcontrolAttr = ");
                    sql.append(21);
                    sql.append(" and t1.famount > 0 and t2.fisSumItem = 0");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowSet.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("RPTITEM_ID", rowSet.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", rowSet.getBigDecimal("famount"));
                        result.add(data);
                    }
                    continue;
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FProfit"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    private static IRowSet getFirstThisYearInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws EASBizException, BOSException {
        int firstYear = InvestDayUtil.getFirstInvestYear(ctx, companyId, targetCompanyId, currencyId);
        if (firstYear != year) {
            return null;
        }
        return InvestDayUtil.getFirstInvest(ctx, companyId, targetCompanyId, currencyId);
    }

    public static List getEndOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, int year) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, year);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static BigDecimal getEndOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, int year, String currencyId) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, year);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    public static List getEndOfThisYearHonorSum(Context ctx, String companyID, String targetCompanyID, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, year);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonorSum"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static BigDecimal getBeginOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws EASBizException, BOSException {
        return InvestDayUtil.getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, year - 1, currencyId);
    }

    public static List getEndOfThisYearSumInvestRateAndAmount(Context ctx, String companyId, String targetCompanyId, int year) throws BOSException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, year);
            try {
                while (info.next()) {
                    BigDecimal rate;
                    BigDecimal amount = info.getBigDecimal("FSumInvestAmout");
                    if (amount == null) {
                        amount = ZERO;
                    }
                    if ((rate = info.getBigDecimal("FSumInvestRate")) == null) {
                        rate = ZERO;
                    }
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("SumInvestAmount", amount);
                    data.put("SumInvestRate", rate);
                    data.put("KEY_CURRENCY_ID", currencyId);
                    result.add(data);
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static Map getThisYearAllProfit(Context ctx, String companyId, String targetCompanyId, int year) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyId, targetCompanyId, currencyId, year, true);
            ArrayList allProfit = new ArrayList();
            try {
                while (invests.next()) {
                    BigDecimal profit = invests.getBigDecimal("FProfit");
                    if (profit == null) {
                        profit = ZERO;
                    }
                    HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
                    data.put("Value", profit);
                    data.put("SumInvestRate", invests.getBigDecimal("FSumInvestRate"));
                    allProfit.add(data);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            result.put(currencyId, allProfit);
        }
        return result;
    }

    public static List getThisYearAllSumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        IRowSet invests = InvestDayUtil.getThisYearInvests(ctx, companyId, targetCompanyId, currencyId, year, true);
        try {
            while (invests.next()) {
                BigDecimal sumInvestRate = invests.getBigDecimal("FSumInvestRate");
                if (sumInvestRate == null) {
                    sumInvestRate = ZERO;
                }
                HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
                data.put("Profit", invests.getBigDecimal("FProfit"));
                data.put("SumInvestRate", sumInvestRate);
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static List getThisDaySumInvestRate(Context ctx, String companyId, String targetCompanyId, java.util.Date day) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        List currencies = InvestDayUtil.getCurrencyIds(ctx);
        int size = currencies.size();
        for (int i = 0; i < size; ++i) {
            String currencyId = (String)currencies.get(i);
            IRowSet info = InvestDayUtil.getThisDayInvest(ctx, companyId, targetCompanyId, currencyId, day);
            try {
                if (!info.next()) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestRate"));
                result.add(data);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static BigDecimal getThisDaySumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtil.getThisDayInvest(ctx, companyId, targetCompanyId, currencyId, day);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    private static IRowSet getThisDayInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws BOSException {
        String endOfDate = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(day));
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfDate);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    public static boolean existsInvest(Context ctx, String companyId, String targetCompanyId, int year) throws BOSException, EASBizException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfYear(year));
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("where company.id = '" + companyId);
        oql.append("' and targetCompany.id = '" + targetCompanyId);
        oql.append("' and changeDate >= " + beginOfYear);
        oql.append(" and changeDate <= " + endOfYear);
        return iinvestDay.exists(oql.toString());
    }

    public static boolean isThisYearByFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException, EASBizException {
        int firstYear = InvestDayUtil.getFirstInvestYear(ctx, companyId, targetCompanyId, currencyId);
        return firstYear == year;
    }

    public static int getFirstInvestYear(Context ctx, String companyId, String targetCompanyId, String currencyId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select min(FChangeDate) as firstDate from t_csl_investDay");
        oql.append(" where FCompanyId = '");
        oql.append(companyId);
        oql.append("' and FTargetCompanyId = '");
        oql.append(targetCompanyId);
        if (!StringUtils.isEmpty((String)currencyId)) {
            oql.append("' and FCurrencyId = '");
            oql.append(currencyId);
        }
        oql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            if (rowSet.next()) {
                Date changeDate = rowSet.getDate("firstDate");
                if (changeDate == null) {
                    return -1;
                }
                return DateTimeUtils.getYear((java.util.Date)changeDate);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return -1;
    }

    private static List getCurrencyIds(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select fcurrencyId from t_csl_investDay group by fcurrencyId";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("fcurrencyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static Map getTwoTypeCompanyForInvest(Context ctx, String orgTreeID, String orgUnitID, int relaParty, int controlRelationShip) throws BOSException, EASBizException {
        String longnumber;
        String numberSql = "select flongnumber from t_org_structure t where ftreeId = ? and funitId = ?";
        Object[] params = new Object[]{orgTreeID, orgUnitID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSql, (Object[])params);
        try {
            rowSet.next();
            longnumber = rowSet.getString(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String relationShipNumber = "";
        if (relaParty == 1) {
            relationShipNumber = "001";
        } else if (relaParty == 2) {
            relationShipNumber = "002', '007";
        }
        String controlRelaNumber = "";
        if (controlRelationShip == 3) {
            controlRelaNumber = "003";
        } else if (controlRelationShip == 4) {
            controlRelaNumber = "004', '005";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t1.fcompanyid, t1.ftargetCompanyid, t2.flongnumber,");
        sql.append(" t3.flongnumber from t_csl_investDay t1");
        sql.append(" inner join");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeID);
        sql.append("' and FLongNumber like '" + longnumber + "!%') t2");
        sql.append(" on t1.fcompanyid = t2.funitid");
        sql.append(" inner join ");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeID);
        sql.append("' and FLongNumber like '" + longnumber + "!%') t3");
        sql.append(" on t1.ftargetCompanyid = t3.funitid");
        sql.append(" where (t1.fcompanyid || t1.ftargetcompanyid) in");
        if (relaParty == 2) {
            sql.append(" (select (r1.fcontrolCompanyId || r1.finvestCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber in ('" + relationShipNumber + "'))");
            sql.append(" or (t1.fcompanyid || t1.ftargetcompanyid) in");
            sql.append(" (select (r1.finvestCompanyId || r1.fcontrolCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber in ('" + relationShipNumber + "'))");
        } else if (StringUtils.isEmpty((String)controlRelaNumber)) {
            sql.append(" (select (r1.fcontrolCompanyId || r1.finvestCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber = '" + relationShipNumber + "')");
        } else {
            sql.append(" (select p1.funionid from");
            sql.append(" (select (r1.finvestCompanyId || r1.fcontrolCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber in ('" + controlRelaNumber + "')) p1");
            sql.append(" join");
            sql.append(" (select (r1.fcontrolCompanyId || r1.finvestCompanyId) as funionid");
            sql.append(" from t_csl_relatedPartyRela r1 join t_csl_relatedParty r2");
            sql.append(" on r1.frelationShipId = r2.fid");
            sql.append(" where r2.fnumber = '" + relationShipNumber + "') p2");
            sql.append(" on p1.funionid = p2.funionid)");
        }
        HashMap result = new HashMap();
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String[] numbers = StringUtils.split((String)longnumber, (String)"!");
            int size = numbers.length;
            while (rowSet.next()) {
                String targetCompanyNumber;
                String[] num2;
                String companyNumber = rowSet.getString(3);
                String[] num1 = StringUtils.split((String)companyNumber, (String)"!");
                if (StringUtils.equals((String)num1[size], (String)(num2 = StringUtils.split((String)(targetCompanyNumber = rowSet.getString(4)), (String)"!"))[size])) continue;
                String companyid = rowSet.getString(1);
                String targetCompanyid = rowSet.getString(2);
                List<String> toCompanys = new ArrayList();
                if (result.containsKey(companyid)) {
                    toCompanys = (List)result.get(companyid);
                } else {
                    result.put(companyid, toCompanys);
                }
                if (toCompanys.contains(targetCompanyid)) continue;
                toCompanys.add(targetCompanyid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }
}

