/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.eas.fi.gr.cslrpt.util.ILevelTreeNode;
import com.kingdee.eas.fi.gr.cslrpt.util.ILevelTreePath;
import com.kingdee.eas.fi.gr.cslrpt.util.LevelTreePath;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class LevelTreeNode
implements ILevelTreeNode {
    private String longNumber = null;
    private Object userObject = null;
    private String name = null;
    private ArrayList treeNodes = new ArrayList();

    @Override
    public String getLongNumber() {
        return this.longNumber;
    }

    @Override
    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ArrayList getTreeNodes() {
        return this.treeNodes;
    }

    @Override
    public void setTreeNodes(ArrayList treeNodes) {
        this.treeNodes = treeNodes;
    }

    public LevelTreeNode(String longNumber, Object userObject, String name) {
        this.longNumber = longNumber;
        this.userObject = userObject;
        this.name = name;
    }

    @Override
    public int levelCount() {
        return this.longNumber.split("!").length;
    }

    @Override
    public void addChildPath(ILevelTreePath path) {
        ILevelTreeNode newNode = path.getHeadNode();
        ILevelTreeNode existNode = this.getChildNode(newNode);
        if (existNode == null) {
            this.addChildNode(newNode);
            existNode = newNode;
        }
        if (path.hasChildPath()) {
            existNode.addChildPath(path.getChildPath());
        }
    }

    @Override
    public void addChildNode(ILevelTreeNode childNode) {
        this.treeNodes.add(childNode);
    }

    @Override
    public ILevelTreeNode getChildNode(ILevelTreeNode node) {
        for (ILevelTreeNode element : this.treeNodes) {
            if (!node.getLongNumber().equalsIgnoreCase(element.getLongNumber())) continue;
            return element;
        }
        return null;
    }

    @Override
    public void sumUserObject() {
        BigDecimal sum = new BigDecimal(0);
        for (ILevelTreeNode element : this.treeNodes) {
            if (element.getTreeNodes().size() != 0) {
                element.sumUserObject();
            }
            sum = sum.add((BigDecimal)element.getUserObject());
        }
        this.setUserObject(sum);
    }

    @Override
    public void toPlatList(List list) {
        for (ILevelTreeNode element : this.treeNodes) {
            list.add(element);
            if (element.getTreeNodes().size() == 0) continue;
            element.toPlatList(list);
        }
    }

    @Override
    public void toPlatList(List list, int sumLevel) {
        for (ILevelTreeNode element : this.treeNodes) {
            int i = element.getTreeNodes().size();
            if (element.levelCount() <= sumLevel || i == 0) {
                list.add(element);
            }
            if (i == 0) continue;
            element.toPlatList(list, sumLevel);
        }
    }

    public String toString() {
        return this.longNumber + " : " + this.name + " : " + this.userObject;
    }

    public static void main(String[] args) {
        LevelTreeNode root = new LevelTreeNode("root", null, null);
        root.addChildPath(new LevelTreePath("1!2!3!4", new BigDecimal(10), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"765_LevelTreeNode")));
        root.addChildPath(new LevelTreePath("1!2!3!5", new BigDecimal(10), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"766_LevelTreeNode")));
        root.addChildPath(new LevelTreePath("1!3!3!5", new BigDecimal(10), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"767_LevelTreeNode")));
        root.addChildPath(new LevelTreePath("2!3!3!5", new BigDecimal(10), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"768_LevelTreeNode")));
        root.sumUserObject();
        ArrayList list = new ArrayList();
        root.toPlatList(list);
    }
}

