/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DyRptSaveHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.GradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SumHelper {
    public static final Map scanDynaTable(Sheet table, DynaSumMethodEnum method, boolean isOnlyList, boolean isShowTotal, boolean isOnlyListCompany) {
        HashMap result = new HashMap();
        ArrayList pointList = DynamicTemplateUtility.getBasePointList((Sheet)table);
        int n = pointList.size();
        for (int i = 0; i < n; ++i) {
            ItemFormula f;
            int j;
            int m;
            Point basePoint = (Point)pointList.get(i);
            HashMap<Point, ItemFormula> formulasMap = new HashMap<Point, ItemFormula>();
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)table, (Point)basePoint);
            param.setSumMethod(method);
            param.setOnlyList(isOnlyList);
            if (param.isGrade() || !param.getOrderBy().equals((Object)OrderByEnum.NONE) && param.getOrderRow() > 0) {
                param.setShowTotal(false);
                param.setOnlyListCompany(isOnlyListCompany);
            } else {
                param.setShowTotal(isShowTotal);
                param.setOnlyListCompany(isOnlyListCompany);
            }
            if (param.getSpreadStyle() == 1) {
                m = table.getRows().getMaxIntMark();
                for (j = basePoint.y + 1; j <= m; ++j) {
                    f = SumHelper.getFormula(table.getRange(j, basePoint.x));
                    if (f == null) continue;
                    formulasMap.put(new Point(basePoint.x, j), f);
                }
            } else {
                m = table.getCols().getMaxIntMark();
                for (j = basePoint.x + 1; j <= m; ++j) {
                    f = SumHelper.getFormula(table.getRange(basePoint.y, j));
                    if (f == null) continue;
                    formulasMap.put(new Point(j, basePoint.y), f);
                }
            }
            HashMap<String, Object> areaMap = new HashMap<String, Object>();
            areaMap.put("param", param.toString());
            areaMap.put("formulas", formulasMap);
            result.put(basePoint, areaMap);
        }
        return result;
    }

    public static ItemFormula getFormula(Range range) {
        ItemFormula f = (ItemFormula)range.getUserObject("ITEM");
        if (f == null || !f.isValidity()) {
            return null;
        }
        return f;
    }

    public static void saveItemData(Context ctx, CslReportInfo reportInfo, Book book, Vector companys, boolean doOffset, boolean includeDiffTable, Map singlePageCompanyIds, boolean onlyList) throws BOSException, EASBizException {
        HashMap<String, Object> companyIDs = new HashMap<String, Object>();
        HashMap<String, Map> tableValues = new HashMap<String, Map>();
        HashMap<String, Map> tableValues_list = new HashMap<String, Map>();
        boolean isHasDItem = false;
        if (companys != null && !companys.isEmpty() && companys.size() > 0) {
            ArrayList<String> cs = new ArrayList<String>();
            for (int a = 0; a < companys.size(); ++a) {
                FullOrgUnitInfo com = (FullOrgUnitInfo)companys.get(a);
                cs.add(com.getId().toString());
            }
            int x = book.getSheetCount();
            for (int i = 0; i < x; ++i) {
                Sheet sheet = book.getSheet(i);
                isHasDItem = !isHasDItem ? DyRptSaveHelper.hasDItem(sheet, null) : isHasDItem;
                tableValues_list.put(sheet.getSheetName(), SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.LIST_DETAIL_COMP_NAME, true, false, false));
                if (!isHasDItem) {
                    tableValues.put(sheet.getSheetName(), SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.SUM_BY_NAME, onlyList, false, false));
                }
                companyIDs.put(sheet.getSheetName(), cs);
            }
            if (isHasDItem) {
                tableValues.clear();
            }
        } else if (singlePageCompanyIds != null && !singlePageCompanyIds.isEmpty()) {
            for (Map.Entry entry : singlePageCompanyIds.entrySet()) {
                Vector company = (Vector)entry.getValue();
                if (company == null || company.isEmpty()) continue;
                ArrayList<String> cs = new ArrayList<String>();
                for (int x = 0; x < company.size(); ++x) {
                    FullOrgUnitInfo com = (FullOrgUnitInfo)company.get(x);
                    cs.add(com.getId().toString());
                }
                String sheetName = (String)entry.getKey();
                Sheet sheet = book.getSheet(sheetName);
                Map map = SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.LIST_DETAIL_COMP_NAME, true, false, false);
                tableValues_list.put(sheetName, map);
                isHasDItem = DyRptSaveHelper.hasDItem(sheet, null);
                if (!isHasDItem) {
                    map = SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.SUM_BY_NAME, onlyList, false, false);
                    tableValues.put(sheetName, map);
                }
                companyIDs.put(sheetName, cs);
                companyIDs.put("isSingeSheetCal", "");
            }
        } else {
            return;
        }
        if (!tableValues.isEmpty()) {
            SumHelper.sumDynamicReportAndSave(ctx, reportInfo.getId().toString(), companyIDs, tableValues, doOffset, includeDiffTable);
        }
        if (tableValues_list.size() > 0) {
            SumHelper.sumDynamicReportAndSave(ctx, reportInfo.getId().toString(), companyIDs, tableValues_list, doOffset, includeDiffTable);
        }
    }

    public static void sumDynamicReportAndSave(Context ctx, String reportid, Map companys, Map tableValues, boolean doOffset, boolean includeDiffTable) throws BOSException, EASBizException {
        if (companys.isEmpty()) {
            return;
        }
        ICSLReportCalculator remoteInstance = ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(ctx);
        remoteInstance.calculateDynaSumRptAndSave(reportid, companys, tableValues, doOffset, includeDiffTable);
    }

    public static void scanDynaBook(boolean isCalcSingle, Book book, String sheetName, Map tableValues, Map tableValues_list, boolean onlyList) {
        boolean isHasDItem = false;
        ArrayList basePointList = null;
        if (isCalcSingle) {
            Sheet sheet = book.getSheet(sheetName);
            Map map = SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.LIST_DETAIL_COMP_NAME, true, false, false);
            tableValues_list.put(sheetName, map);
            basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            if (basePointList == null || basePointList.isEmpty()) {
                return;
            }
            isHasDItem = DyRptSaveHelper.hasDItem(sheet, basePointList);
            if (!isHasDItem) {
                map = SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.SUM_BY_NAME, onlyList, false, false);
                tableValues.put(sheetName, map);
            }
        } else {
            int x = book.getSheetCount();
            for (int i = 0; i < x; ++i) {
                Sheet sheet = book.getSheet(i);
                tableValues_list.put(sheet.getSheetName(), SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.LIST_DETAIL_COMP_NAME, true, false, false));
                basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                if (basePointList == null || basePointList.isEmpty()) continue;
                boolean bl = isHasDItem = !isHasDItem ? DyRptSaveHelper.hasDItem(sheet, basePointList) : isHasDItem;
                if (isHasDItem) continue;
                tableValues.put(sheet.getSheetName(), SumHelper.scanDynaTable(sheet, DynaSumMethodEnum.SUM_BY_NAME, onlyList, false, false));
            }
            if (isHasDItem) {
                tableValues.clear();
            }
        }
    }

    public static List getOrderList(DItemGradeInfo gradeInfo, List orderList, Map nameMap, boolean isDesc) {
        int i;
        if (gradeInfo == null) {
            return orderList;
        }
        int size = orderList == null ? 0 : orderList.size();
        ArrayList<Object> returnList = new ArrayList<Object>(size);
        GradeEntryInfo entryInfo = null;
        Map map = null;
        String grade = null;
        ArrayList<GradeEntryInfo> gradeEntryList = new ArrayList<GradeEntryInfo>(size);
        for (int j = 0; j < size; ++j) {
            entryInfo = new GradeEntryInfo();
            entryInfo.number = orderList.get(j);
            map = (Map)nameMap.get(entryInfo.number);
            entryInfo.companyName = map.get("COMPANY_NAME");
            entryInfo.grade = (String)map.get("GRADE_NUMBER");
            gradeEntryList.add(entryInfo);
        }
        orderList.clear();
        List entries = gradeInfo.getEntries();
        DItemGradeEntryInfo info = null;
        ArrayList<GradeEntryInfo> midList = new ArrayList<GradeEntryInfo>();
        int _size = entries.size();
        for (int i2 = 0; i2 < _size; ++i2) {
            info = (DItemGradeEntryInfo)entries.get(isDesc ? _size - 1 - i2 : i2);
            if (info == null || info.getGrade() == null) continue;
            for (int nn = 0; nn < gradeEntryList.size(); ++nn) {
                entryInfo = (GradeEntryInfo)gradeEntryList.get(nn);
                grade = entryInfo.grade;
                if (grade == null || !grade.equals(info.getGrade())) continue;
                midList.add(entryInfo);
            }
        }
        String grade2 = null;
        GradeEntryInfo entryInfo2 = null;
        ArrayList<GradeEntryInfo> finalList = new ArrayList<GradeEntryInfo>(size);
        Object number = null;
        for (i = 0; i < midList.size(); ++i) {
            entryInfo = (GradeEntryInfo)midList.get(i);
            if (!isDesc) {
                finalList.add(entryInfo);
            }
            map = (Map)nameMap.get(number);
            grade = entryInfo.grade + ".D";
            for (int j = 0; j < gradeEntryList.size(); ++j) {
                entryInfo2 = (GradeEntryInfo)gradeEntryList.get(j);
                grade2 = entryInfo2.grade;
                if (grade == null || !grade2.equals(grade) || !entryInfo2.companyName.equals(entryInfo.companyName)) continue;
                finalList.add(entryInfo2);
            }
            if (!isDesc) continue;
            finalList.add(entryInfo);
        }
        midList.clear();
        gradeEntryList.clear();
        for (i = 0; i < finalList.size(); ++i) {
            returnList.add(((GradeEntryInfo)finalList.get((int)i)).number);
        }
        finalList.clear();
        return returnList;
    }
}

