/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.FastMergeSoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class FastMergeHandle {
    private static Logger LOGGER = Logger.getLogger((String)"com.kingdee.eas.fi.gr.fast.app.FastMergeExecute");
    protected Context ctx;

    public FastMergeHandle(Context ctx) {
        this.ctx = ctx;
    }

    public void execute(String fastMergeSoluId, String userId, String executeTaskId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new FastMergeExecSelector().getSelector();
        FastMergeSoluInfo soluInfo = FastMergeSoluFactory.getLocalInstance(this.ctx).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        if (!soluInfo.isIsAutoDispatch() || soluInfo.getDispatchPeriodId() == null) {
            LOGGER.info((Object)"FastMergeSolu No auto Dispatch!");
            return;
        }
        FastMergeTemplateCollection tempEnties = soluInfo.getTemplates();
        FastMergeOrgUnitCollection orgUnitEnties = soluInfo.getOrgUnits();
        if (tempEnties.size() == 0 || orgUnitEnties.size() == 0) {
            LOGGER.info((Object)"FastMergeSolu No Tmps or No Units!");
            return;
        }
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        if (!soluInfo.isIsCurrentPeriod()) {
            String orgTreeId = soluInfo.getOrgBound().getId().toString();
            boolean isMergeByFiscalPeriod = false;
            if (CSLParamUtil.getParamValue(this.ctx, orgTreeId, "KEY_SYSPARAM_MERGEBYFISCALPERIOD") != null && CSLParamUtil.getParamValue(this.ctx, orgTreeId, "KEY_SYSPARAM_MERGEBYFISCALPERIOD").equals("true")) {
                isMergeByFiscalPeriod = true;
            }
            int[] yearAndPeriod = FastMergeUtil.getPrePeriod(this.ctx, isMergeByFiscalPeriod, soluInfo.getOrgBound(), year, period, periodType);
            year = yearAndPeriod[0];
            period = yearAndPeriod[1];
        }
        this.execute(soluInfo, soluInfo.getCreator().getId().toString(), (int)year, (int)period, 0, executeTaskId);
    }

    public void execute(String fastMergeSoluId, String userId, int year, int period, int runErrorStrategy, String executeTaskId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new FastMergeExecSelector().getSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo compSeqSorter = new SorterItemInfo("orgUnits.seq");
        compSeqSorter.setSortType(SortType.DESCEND);
        sorter.add(compSeqSorter);
        SorterItemInfo templateSeqSorter = new SorterItemInfo("templates.seq");
        templateSeqSorter.setSortType(SortType.ASCEND);
        sorter.add(templateSeqSorter);
        FastMergeSoluInfo soluInfo = (FastMergeSoluInfo)FastMergeSoluFactory.getLocalInstance(this.ctx).getValue((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector, sorter);
        FastMergeTemplateCollection tempEnties = soluInfo.getTemplates();
        FastMergeOrgUnitCollection orgUnitEnties = soluInfo.getOrgUnits();
        if (tempEnties.size() == 0 || orgUnitEnties.size() == 0) {
            LOGGER.info((Object)"FastMergeSolu No Tmps or No Units!");
            return;
        }
        this.execute(soluInfo, userId, year, period, runErrorStrategy, executeTaskId);
    }

    public void execute(FastMergeSoluInfo soluInfo, String userId, int year, int period, int runErrorStrategy, String executeTaskId) throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        String description = soluInfo.getName() + "\uff08" + soluInfo.getNumber() + "\uff09";
        SolutionExecuteParam executeParam = new SolutionExecuteParam(this.ctx, soluInfo, userInfo, year, period, description, executeTaskId);
        FastMergeSoluExecute soluExecute = new FastMergeSoluExecute(this.ctx, executeParam);
        soluExecute.execute();
    }
}

