/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ReportCalcGroupKey;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptFillCondition;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.gr.fast.CSLContextData;
import com.kingdee.eas.fi.gr.fast.ElimTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.sqlUtil.SqlResultFillter;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoMnsRptExecute
implements ISoluExecute {
    private CslReportInfo cslRptInfo = null;
    private Context _ctx;
    private SolutionExecuteParam _executeParam;
    private TemplateInfo templateInfo;
    private CslRptQuerySoluInfo querySoluInfo;
    private CslRptQuerySoluInfo excludeQuerySoluInfo;
    private CSLContextData cslContest = null;
    private boolean iscontinue = true;
    private FastMergeSoluInfo soluInfo = null;
    private boolean isSupportCrossMerger = true;
    private String userId = null;
    private boolean isFromStatutory = false;
    private int calcType = 0;

    public AutoMnsRptExecute(Context ctx, SolutionExecuteParam executeParam, TemplateInfo templateInfo, CslRptQuerySoluInfo querySoluInfo, CslRptQuerySoluInfo excludeQuerySoluInfo) {
        this._ctx = ctx;
        this._executeParam = executeParam;
        this.templateInfo = templateInfo;
        this.querySoluInfo = querySoluInfo;
        this.excludeQuerySoluInfo = excludeQuerySoluInfo;
        this.soluInfo = executeParam.getSoluInfo();
        this.isSupportCrossMerger = executeParam.isSupportCrossMerger();
        this.userId = this._executeParam.getCurUser().getId().toString();
        this.init();
    }

    public AutoMnsRptExecute(FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, CslRptQuerySoluInfo excludeQuerySoluInfo) {
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.excludeQuerySoluInfo = excludeQuerySoluInfo;
    }

    public AutoMnsRptExecute() {
    }

    @Override
    public void execute() throws Exception {
        try {
            this.addNew();
            if (!this.iscontinue) {
                return;
            }
            if (this.cslRptInfo == null) {
                return;
            }
            this.calcAndSave();
        }
        finally {
            if (this.cslRptInfo != null && this.cslRptInfo.getId() != null) {
                FastMergeUtil.releaseObjIDForUpdate(this._ctx, this.cslRptInfo.getId().toString());
            }
        }
    }

    public void initForCalAndSave(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, CslRptQuerySoluInfo excludeQuerySoluInfo, String userId) {
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.cslRptInfo = cslRptInfo;
        this.excludeQuerySoluInfo = excludeQuerySoluInfo;
        this.userId = userId;
        this.isSupportCrossMerger = !soluInfo.isIsSupportGroupReport();
    }

    public void calcAndSave() throws Exception {
        this.calc(this._ctx, this.cslRptInfo, this.cslRptInfo.getBook(), this.userId, null, null);
        (this._ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(this._ctx)).submit((CoreBaseInfo)this.cslRptInfo);
    }

    public void calcFromMnsRpt(CslReportInfo cslRptInfo, Book book, String userId, int calcType, MnsRptParamInfo mnsRptParamInfo, List<OrgUnitInfo> fillCompanyList) throws Exception {
        this.initParamsFromMnsRpt(cslRptInfo, book, calcType);
        this.calc(null, cslRptInfo, book, userId, mnsRptParamInfo, fillCompanyList);
    }

    private void initParamsFromMnsRpt(CslReportInfo cslRptInfo, Book book, int calcType) throws Exception {
        this.calcType = calcType;
        if (cslRptInfo == null) {
            return;
        }
        if (this.soluInfo == null && cslRptInfo.getFastMergeSoluId() == null) {
            return;
        }
        this.cslRptInfo = cslRptInfo;
        if (this.soluInfo == null) {
            this.soluInfo = FastMergeUtil.getFastMergeSoluInfo(this._ctx, cslRptInfo.getFastMergeSoluId(), true);
            if (this.soluInfo == null) {
                return;
            }
        }
        this.isSupportCrossMerger = !this.soluInfo.isIsSupportGroupReport();
        FastMergeOrgUnitInfo fastMergeOrgUnitInfo = FastMergeUtil.getCslRptFastMergeOrgUnitInfo(this.soluInfo, cslRptInfo);
        if (this.querySoluInfo == null) {
            this.querySoluInfo = FastMergeUtil.getCslRptQuerySoluInfos(this._ctx, cslRptInfo.getOrgTree(), cslRptInfo.getOrgUnit().getId().toString(), fastMergeOrgUnitInfo, null, new int[]{1})[0];
        }
        if (this.excludeQuerySoluInfo == null) {
            this.excludeQuerySoluInfo = FastMergeUtil.getCslRptQuerySoluInfos(this._ctx, cslRptInfo.getOrgTree(), cslRptInfo.getOrgUnit().getId().toString(), fastMergeOrgUnitInfo, null, new int[]{3})[0];
        }
    }

    private void init() {
        this.cslContest = new CSLContextData(this._executeParam.getDataCollInfo(), this._executeParam.getSoluInfo().getOrgBound(), (OrgUnitInfo)this._executeParam.getCurOrgUnit(), this._executeParam.getReportDate(), this._executeParam.getPeriod(), RptPeriodTypeEnum.getEnum((int)this._executeParam.getPeriodType()), this._executeParam.getYear(), false);
    }

    private void addNew() throws Exception {
        String rptId = this.verifyMnsReport();
        boolean isSupportGroupReport = this._executeParam.getSoluInfo().isIsSupportGroupReport();
        Map map = null;
        if (!StringUtils.isEmpty((String)rptId)) {
            ICslReport iReport = CslReportFactory.getLocalInstance(this._ctx);
            this.cslRptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptId)), RptAutoWeaveUtil.getCslRptSelectors());
            boolean bl = this.iscontinue = this.cslRptInfo.getAuditedStatus() == AuditedStatusEnum.UNAUDITED;
            if (this.iscontinue) {
                FastMergeUtil.requestBizObjIDForUpdate(this._ctx, rptId);
                map = FastMergeUtil.getReportVersion(this._ctx, rptId);
                iReport.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptId)));
            } else {
                return;
            }
        }
        int year = this.cslContest.getCurRptYear();
        int period = this.cslContest.getCurRptPeriod();
        boolean isMergeByFiscalPeriod = this._executeParam.isMergeByFiscalPeriod();
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(this._ctx, this.cslContest.getCurOrgBound());
        }
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate(year, period, this.cslContest.getCurRptPeriodType(), periods, isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, this.cslContest.getCurRptPeriodType(), isMergeByFiscalPeriod);
        FullOrgUnitInfo companyInfo = new FullOrgUnitInfo();
        companyInfo.setId(this._executeParam.getCurOrgUnit().getId());
        this.cslRptInfo = FastMergeUtil.createMnsRpt(this.cslContest, this.templateInfo, this._executeParam.isSupportOtherDS(), this._executeParam.getSoluInfo().getCurrency(), startDate, endDate, this._executeParam.getDescription(), (OrgUnitInfo)companyInfo, isSupportGroupReport);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.templateInfo.getId().toString()));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("data"));
        TemplateCollection templateCollection = TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateCollection(view);
        if (templateCollection != null && templateCollection.size() > 0) {
            Book book = templateCollection.get(0).getBook();
            this.cslRptInfo.setBook(book);
            int periodType = this.templateInfo.getPeriodType().getValue();
            int templateType = this.templateInfo.getTemplateType().getValue();
            int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
            Boolean isSupportOtherDS = this._executeParam.isSupportOtherDS();
            RptAutoWeaveUtil rptAutoWeaveUtil = new RptAutoWeaveUtil();
            String fastMergeSoluId = null;
            if (this._executeParam.getSoluInfo().getId() != null) {
                fastMergeSoluId = this._executeParam.getSoluInfo().getId().toString();
            }
            SumRptAddedPerportyInfo addedPerporty = rptAutoWeaveUtil.getSumRptAddedPerporty(this._ctx, this.templateInfo, this._executeParam.getSoluInfo().getCurrency(), this._executeParam.getSoluInfo().getOrgBound(), (OrgUnitInfo)this._executeParam.getCurOrgUnit(), isSupportOtherDS, year, periodType, (short)period, reportType, isSupportGroupReport, fastMergeSoluId);
            this.cslRptInfo.put("addedPerporty", addedPerporty);
            if (map != null && !map.isEmpty()) {
                SumRptAddedPerportyInfo addedPerportyNew = (SumRptAddedPerportyInfo)this.cslRptInfo.get("addedperporty");
                int version = Integer.valueOf(map.get("version").toString());
                String addGroup = String.valueOf(map.get("group"));
                addedPerporty.setVersion(version);
                addedPerporty.setGroup(addGroup);
                this.cslRptInfo.put("addedPerporty", addedPerportyNew);
            }
            if (fastMergeSoluId != null) {
                this.cslRptInfo.setFastMergeSoluId(fastMergeSoluId);
            }
            IObjectPK pk = CslReportFactory.getLocalInstance(this._ctx).submit((CoreBaseInfo)this.cslRptInfo);
            this.cslRptInfo.setId(BOSUuid.read((String)pk.toString()));
        }
    }

    private String verifyMnsReport() throws BOSException, EASBizException {
        String treeID = this.cslContest.getCurOrgBound().getId().toString();
        String companyID = this.cslContest.getCurOrgGroup().getId().toString();
        String currencyID = this._executeParam.getSoluInfo().getCurrency().getId().toString();
        RptTmpTypeEnum tmpType = this.templateInfo.getTemplateType();
        boolean isSupportGroupReport = this._executeParam.getSoluInfo().isIsSupportGroupReport();
        String fastMergeSoluId = null;
        int rptType = RptAutoWeaveUtil.getReportTypeByTempType(tmpType.getValue(), isSupportGroupReport);
        if (!isSupportGroupReport) {
            fastMergeSoluId = this._executeParam.getSoluInfo().getId().toString();
        }
        String rptId = FastMergeUtil.get_ReportByTmpVersionFromFastMerge(this._ctx, treeID, companyID, currencyID, this.templateInfo.getId().toString(), rptType, this.cslContest.getCurRptPeriodType().getValue(), this.cslContest.getCurRptYear(), this.cslContest.getCurRptPeriod(), null, this._executeParam.getDataCollInfo().getNumber(), fastMergeSoluId, isSupportGroupReport);
        return rptId;
    }

    private List<String> getElimTypeFilter(EliminationEntiresSoluInfo elimSoluInfo) {
        ElimTypeEntriesCollection typeColl;
        if (elimSoluInfo != null && elimSoluInfo.isIsRelateExistData() && (typeColl = elimSoluInfo.getElimTypeEntries()) != null) {
            ArrayList<String> elimTypeList = new ArrayList<String>();
            for (int i = 0; i < typeColl.size(); ++i) {
                elimTypeList.add(typeColl.get(i).getElimType().getId().toString());
            }
            return elimTypeList;
        }
        return null;
    }

    private void initCompanyGroup(MnsRptParamInfo mnsRptParamInfo, List<OrgUnitInfo> fillCompanyList) throws Exception {
        if (fillCompanyList != null && !fillCompanyList.isEmpty() && mnsRptParamInfo != null) {
            Map<ReportCalcGroupKey, Set<String>> companyGroupMap;
            boolean isSupportGroupReport = this.soluInfo.isIsSupportGroupReport();
            String fastMergeSoluId = this.soluInfo.getId().toString();
            if (!(isSupportGroupReport || StringUtils.isEmpty((String)fastMergeSoluId) || (companyGroupMap = mnsRptParamInfo.getSrcCompanyGroupMap()) != null && !companyGroupMap.isEmpty() || mnsRptParamInfo.getCompanyMap() == null)) {
                HashMap unionOrgs = new HashMap();
                for (OrgUnitInfo orgUnit : fillCompanyList) {
                    if (!orgUnit.isIsUnion()) continue;
                    unionOrgs.put(orgUnit.getId().toString(), null);
                }
                if (!unionOrgs.isEmpty()) {
                    companyGroupMap = mnsRptParamInfo.getCompanyGroupMap();
                    companyGroupMap.clear();
                    ReportCalcGroupKey calcGroupKey = null;
                    Set<String> companyIdSet = null;
                    boolean isUnion = false;
                    for (OrgTreeInfo orgTree : mnsRptParamInfo.getCompanyMap().keySet()) {
                        companyIdSet = mnsRptParamInfo.getCompanyMap().get(orgTree);
                        for (String companyId : companyIdSet) {
                            isUnion = unionOrgs.containsKey(companyId);
                            calcGroupKey = new ReportCalcGroupKey();
                            calcGroupKey.setOrgTree(orgTree);
                            calcGroupKey.setFromStatutory(!isUnion);
                            if (isUnion) {
                                calcGroupKey.setSourceSoluInfo(this.soluInfo);
                            }
                            mnsRptParamInfo.addCompanyGroupMap(calcGroupKey, companyId);
                        }
                    }
                }
            }
        }
    }

    private void initCompany(List<OrgUnitInfo> fillCompanyList, List<OrgUnitInfo> fillExcludeCompanyList, MnsRptParamInfo mnsRptParamInfo, String userId) throws Exception {
        OrgTreeInfo curOrgTreeInfo = null;
        FullOrgUnitInfo curOrgUnitInfo = null;
        String ksqlDate = new StringBuffer().append("{ts'").append(DateTimeUtils.getYear((Date)this.cslRptInfo.getReportDate())).append("-").append(DateTimeUtils.getMonth((Date)this.cslRptInfo.getReportDate())).append("-").append(DateTimeUtils.getDay((Date)this.cslRptInfo.getReportDate())).append(" 00:00:00'}").toString();
        if (this.querySoluInfo != null) {
            this.querySoluInfo.initMnsFillOrgUnitColl(this._ctx, this.cslRptInfo.getReportDate());
        }
        MnsFillOrgUnitCollection mnsFillOrgUnitCol = this.querySoluInfo.getOrgUnitCollection();
        for (int i = 0; i < mnsFillOrgUnitCol.size(); ++i) {
            curOrgTreeInfo = mnsFillOrgUnitCol.get(i).getOrgTreeInfo();
            curOrgUnitInfo = mnsFillOrgUnitCol.get(i).getFullOrgUnitInfo();
            fillCompanyList.add((OrgUnitInfo)curOrgUnitInfo);
            if (curOrgTreeInfo.getId() == null) {
                throw new Exception(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"65_orgTreeIsnotStart"), curOrgTreeInfo.getNumber(), ksqlDate));
            }
            mnsRptParamInfo.addCompanyGroupMap(new ReportCalcGroupKey(mnsFillOrgUnitCol.get(i)), curOrgUnitInfo.getId().toString());
            if (!curOrgUnitInfo.isIsUnion() && !curOrgUnitInfo.isIsGrouping()) continue;
            mnsRptParamInfo.addUnion(curOrgTreeInfo, curOrgUnitInfo.getId().toString());
        }
        if (this.excludeQuerySoluInfo != null) {
            this.excludeQuerySoluInfo.initMnsFillOrgUnitColl(this._ctx, this.cslRptInfo.getReportDate());
            MnsFillOrgUnitCollection mnsExcludeFillOrgUnitCol = this.excludeQuerySoluInfo.getOrgUnitCollection();
            for (int i = 0; i < mnsExcludeFillOrgUnitCol.size(); ++i) {
                curOrgTreeInfo = mnsExcludeFillOrgUnitCol.get(i).getOrgTreeInfo();
                curOrgUnitInfo = mnsExcludeFillOrgUnitCol.get(i).getFullOrgUnitInfo();
                fillExcludeCompanyList.add((OrgUnitInfo)curOrgUnitInfo);
                if (curOrgTreeInfo.getId() == null) {
                    throw new Exception(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"65_orgTreeIsnotStart"), curOrgTreeInfo.getNumber(), ksqlDate));
                }
                mnsRptParamInfo.addExcludeCompany(curOrgTreeInfo, curOrgUnitInfo.getId().toString());
                if (!curOrgUnitInfo.isIsUnion() && !curOrgUnitInfo.isIsGrouping()) continue;
                mnsRptParamInfo.addExcludeUnion(curOrgTreeInfo, curOrgUnitInfo.getId().toString());
            }
        }
    }

    public void calc(Context ctx, CslReportInfo cslRptInfo, Book book, String userId, MnsRptParamInfo mnsRptParamInfo, List<OrgUnitInfo> fillCompanyList) throws Exception {
        ArrayList<OrgUnitInfo> fillExcludeCompanyList = new ArrayList<OrgUnitInfo>();
        List<OrgUnitInfo> curFillCompanyList = fillCompanyList;
        MnsRptParamInfo curMnsRptParamInfo = mnsRptParamInfo;
        if (curFillCompanyList == null) {
            curFillCompanyList = new ArrayList<OrgUnitInfo>();
        }
        if (curMnsRptParamInfo == null) {
            curMnsRptParamInfo = new MnsRptParamInfo();
        }
        if (fillCompanyList == null || fillCompanyList.isEmpty() || mnsRptParamInfo == null) {
            this.initCompany(curFillCompanyList, fillExcludeCompanyList, curMnsRptParamInfo, userId);
        } else {
            this.initCompanyGroup(curMnsRptParamInfo, curFillCompanyList);
        }
        MnsRptCalculate msnRptCalculate = new MnsRptCalculate(this._ctx);
        msnRptCalculate.setSupportCrossMerger(this.isSupportCrossMerger);
        curMnsRptParamInfo.setSupportCrossMerger(this.isSupportCrossMerger);
        msnRptCalculate.setCslRptInfo(cslRptInfo);
        msnRptCalculate.setCheckRptReceived(false);
        CslRptUtil.prepareCalculate(this._ctx, cslRptInfo, book, true);
        if (!this.isFromStatutory && !this.isSupportCrossMerger || this.isFromStatutory && this.isSupportCrossMerger) {
            MnsRptFillCondition condition = new MnsRptFillCondition(this._ctx, cslRptInfo.getOrgTree(), (OrgUnitInfo)cslRptInfo.getOrgUnit(), cslRptInfo.getYear(), cslRptInfo.getPeriod(), cslRptInfo.getPeriodType().getValue(), this.isSupportCrossMerger);
            condition.book = book;
            condition.companys = curFillCompanyList;
            condition.excludeCompanys = fillExcludeCompanyList;
            book = MnsRptGuideHelper.fillMnsRptSheet(condition);
            cslRptInfo.setBook(book);
        }
        msnRptCalculate.setBook(book);
        msnRptCalculate.setElimTypeFilter(this.getElimTypeFilter(this.soluInfo.getElimEntrySolu()));
        msnRptCalculate.setSupportHandElim(false);
        msnRptCalculate.setCalcType(this.calcType);
        book.setAutoCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        int dataElementRelat = p.getDataElementRelating();
        msnRptCalculate.setDataElementRelating(dataElementRelat);
        if (this.soluInfo.isIsContainUnRecive()) {
            msnRptCalculate.setIncludeUnAuditElim(true);
        } else {
            msnRptCalculate.setIncludeUnAuditElim(false);
        }
        msnRptCalculate.setMnsRptParamInfo(curMnsRptParamInfo);
        msnRptCalculate.setFillCompanyList(curFillCompanyList);
        msnRptCalculate.setFillExcludeCompanyList(fillExcludeCompanyList);
        if (this.soluInfo.getId() != null) {
            msnRptCalculate.setFastMergeSoluId(this.soluInfo.getId().toString());
        }
        msnRptCalculate.setSupportGroupReport(this.soluInfo.isIsSupportGroupReport());
        msnRptCalculate.setAdjustTypeFilter(FastMergeUtil.getAdjustTypeList(this.soluInfo));
        msnRptCalculate.prepareCalculate();
        msnRptCalculate.calculate();
        msnRptCalculate.afterCalculate();
        this.calcSqlGetData(book, cslRptInfo);
        book.calc();
        cslRptInfo.setBook(book);
    }

    private void calcSqlGetData(Book book, CslReportInfo reportInfo) {
        SqlResultFillter fillter = new SqlResultFillter(this._ctx, book, false, (ReportBaseInfo)reportInfo);
        fillter.fillResult();
    }

    public void initForCalAndSave(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, String userId, boolean isSupportCrossMerger, boolean isFromStatutory) {
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.cslRptInfo = cslRptInfo;
        this.userId = userId;
        this.isSupportCrossMerger = isSupportCrossMerger;
        this.isFromStatutory = isFromStatutory;
    }
}

