/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptCalcAssist;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.AdjustTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.ExistNoReceRptSelectCalcEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AutoSumSoluExecute
implements ISoluExecute {
    private static Logger LOGGER = Logger.getLogger(AutoSumSoluExecute.class);
    public static final int UNSELECTED = 16;
    private CslReportInfo cslRptInfo = null;
    private Context _ctx;
    private SolutionExecuteParam _executeParam;
    private TemplateInfo templateInfo;
    private OrgUnitCollection needSumUnits;
    private SumSchmInfo schmInfo;
    private DynaSumMethodEnum defaultDySumMethod;
    private CslRptQuerySoluInfo querySoluInfo = null;
    private boolean isFromStatutory = false;
    private int createRptStrategy;
    private FastMergeSoluInfo soluInfo = null;
    private boolean iscontinue = true;
    private FullOrgUnitInfo curOrgUnit = null;

    public AutoSumSoluExecute(Context ctx, SolutionExecuteParam executeParam, TemplateInfo templateInfo, OrgUnitCollection units, SumSchmInfo schmInfo, DynaSumMethodEnum defaultDySumMethod) {
        this._ctx = ctx;
        this._executeParam = executeParam;
        this.templateInfo = templateInfo;
        this.needSumUnits = units;
        this.schmInfo = schmInfo;
        this.defaultDySumMethod = defaultDySumMethod;
        this.createRptStrategy = executeParam.getCreateRptStrategy();
        this.soluInfo = executeParam.getSoluInfo();
    }

    public AutoSumSoluExecute(Context ctx, SolutionExecuteParam executeParam, TemplateInfo templateInfo, OrgUnitCollection units, SumSchmInfo schmInfo, FullOrgUnitInfo curOrgUnit, DynaSumMethodEnum defaultDySumMethod) {
        this(ctx, executeParam, templateInfo, units, schmInfo, defaultDySumMethod);
        this.curOrgUnit = curOrgUnit;
    }

    public AutoSumSoluExecute() {
        Object[] dynaSumMethods;
        if (this.defaultDySumMethod == null && (dynaSumMethods = CSLParamUtil.getDynaSumMethod(this._ctx)) != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
            this.defaultDySumMethod = (DynaSumMethodEnum)((Object)dynaSumMethods[0]);
        }
    }

    public void initParamsFromSumRpt(Context ctx, CslReportInfo cslRptInfo, Book book, UserInfo userInfo) throws Exception {
        OrgUnitCollection needSumUnits;
        if (cslRptInfo == null || cslRptInfo.getFastMergeSoluId() == null) {
            return;
        }
        this._ctx = ctx;
        this.cslRptInfo = cslRptInfo;
        IFastMergeSolu iFastMergeSolu = ctx != null ? FastMergeSoluFactory.getLocalInstance(ctx) : FastMergeSoluFactory.getRemoteInstance();
        FastMergeSoluInfo soluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(cslRptInfo.getFastMergeSoluId()), new FastMergeExecSelector().getSelector());
        if (soluInfo == null) {
            return;
        }
        this.soluInfo = soluInfo;
        this.createRptStrategy = soluInfo.isIsSupportGroupReport() ? 1 : 2;
        this._executeParam = new SolutionExecuteParam(ctx, soluInfo, userInfo, cslRptInfo.getYear(), cslRptInfo.getPeriod(), null, null);
        boolean isSupportGroupReport = false;
        if (this._executeParam.getCreateRptStrategy() == 1) {
            isSupportGroupReport = true;
        }
        FastMergeOrgUnitInfo fastMergeOrgUnitInfo = this.getFastMergeOrgUnitInfo(soluInfo.getOrgUnits(), cslRptInfo);
        String calcSoluId = null;
        if (fastMergeOrgUnitInfo != null) {
            calcSoluId = cslRptInfo.getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC) ? fastMergeOrgUnitInfo.getDynaCalcSolu() : fastMergeOrgUnitInfo.getFixedCalcSolu();
        }
        Set<String> calcOrgSet = null;
        SumSchmInfo schmInfo = null;
        OrgStructureCollection strucColl = null;
        if (!StringUtils.isEmpty((String)calcSoluId)) {
            calcOrgSet = FastMergeUtil.getSoluOrgUnit(ctx, calcSoluId);
            schmInfo = (ctx == null ? SumSchmFactory.getRemoteInstance() : SumSchmFactory.getLocalInstance(ctx)).getSumSchmInfo((IObjectPK)new ObjectUuidPK(calcSoluId));
            if (!isSupportGroupReport) {
                strucColl = FastMergeUtil.getOrgStructureColl(ctx, soluInfo.getOrgBound().getId().toString(), calcOrgSet);
            }
        }
        this.needSumUnits = needSumUnits = FastMergeUtil.getOrgUnitsIntersectSet(ctx, soluInfo.getOrgBound(), (OrgUnitInfo)cslRptInfo.getOrgUnit(), this._executeParam.isSupportCrossMerger(), calcOrgSet, strucColl, isSupportGroupReport, this._executeParam.getSoluBoundMergeMode().getValue());
        this.schmInfo = schmInfo;
    }

    private FastMergeOrgUnitInfo getFastMergeOrgUnitInfo(FastMergeOrgUnitCollection orgUnitColl, CslReportInfo cslRptInfo) {
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            if (!orgUnitColl.get(i).getOrgUnit().getNumber().equals(cslRptInfo.getOrgUnit().getNumber())) continue;
            return orgUnitColl.get(i);
        }
        return null;
    }

    @Override
    public void execute() throws Exception {
        this.addNew(this._executeParam.getSoluInfo().getOrgBound(), this.curOrgUnit != null ? this.curOrgUnit : this._executeParam.getCurOrgUnit(), this._executeParam.getSoluInfo().getCurrency());
        if (this.iscontinue) {
            if (this.cslRptInfo == null) {
                return;
            }
            Book book = this.cslRptInfo.getBook();
            this.calcAndSave(this.cslRptInfo, book);
            FastMergeUtil.releaseObjIDForUpdate(this._ctx, this.cslRptInfo.getId().toString());
        }
        if (this._executeParam.getCreateRptStrategy() == 2) {
            return;
        }
        if (this.iscontinue) {
            FastMergeUtil.cslrptAduit(this._ctx, this.cslRptInfo);
        }
        if (this.cslRptInfo.getCommittedStatus() == null || this.cslRptInfo.getCommittedStatus() == CommittedStatusEnum.UNCOMMITTED) {
            FastMergeUtil.cslrptCommit(this._ctx, this.cslRptInfo);
        }
        if (this.cslRptInfo.getCommittedStatus() == CommittedStatusEnum.COMMITTED) {
            FastMergeUtil.cslReceive(this._ctx, this.cslRptInfo);
        }
    }

    private void addNew(OrgTreeInfo treeInfo, FullOrgUnitInfo unitInfo, CurrencyInfo currency) throws Exception {
        this.templateInfo = TemplateFactory.getLocalInstance((Context)this._ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.templateInfo.getId().toString())), RptAutoWeaveUtil.getTemplateSelectorForWeaveRpt());
        RptAutoWeaveUtil rptUtil = new RptAutoWeaveUtil();
        this.cslRptInfo = new CslReportInfo();
        ArrayList allKeyRow = new ArrayList();
        Boolean isSupportOtherDS = this._executeParam.isSupportOtherDS();
        this._ctx.put((Object)"UserInfo", (Object)this._executeParam.getCurUser());
        boolean isSupportGroupReport = false;
        if (this._executeParam.getCreateRptStrategy() == 1) {
            isSupportGroupReport = true;
        }
        int year = this._executeParam.getYear();
        int period = this._executeParam.getPeriod();
        int periodType = this._executeParam.getPeriodType();
        String templateGroupNumber = this.templateInfo.getGroup();
        int templateType = this.templateInfo.getTemplateType().getValue();
        int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
        Map map = null;
        Object group = null;
        String sumRptId = this.getExistSumRptId(this._ctx, treeInfo.getId().toString(), unitInfo.getId().toString(), periodType, year, period, currency.getId().toString(), templateGroupNumber, reportType, isSupportGroupReport, this._executeParam.getSoluInfo().getId().toString());
        if (!StringUtils.isEmpty((String)sumRptId)) {
            LOGGER.error((Object)("FastMergeUtil1" + this._ctx.toString()));
            ICslReport iReport = CslReportFactory.getLocalInstance(this._ctx);
            this.cslRptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sumRptId)), RptAutoWeaveUtil.getCslRptSelectors());
            boolean bl = this.iscontinue = this.cslRptInfo.getAuditedStatus() == AuditedStatusEnum.UNAUDITED;
            if (this.iscontinue) {
                LOGGER.error((Object)("FastMergeUtil2" + this._ctx.toString()));
                FastMergeUtil.requestBizObjIDForUpdate(this._ctx, sumRptId);
                map = FastMergeUtil.getReportVersion(this._ctx, sumRptId);
                iReport.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sumRptId)));
            } else {
                return;
            }
        }
        this.cslRptInfo = rptUtil.initCslReportInfo(this._ctx, this.cslRptInfo, this.templateInfo, currency, treeInfo, (OrgUnitInfo)unitInfo, allKeyRow, isSupportOtherDS, this._executeParam.getDataCollInfo(), year, (short)period, this._executeParam.getReportDate(), isSupportGroupReport, this._executeParam.getDescription(), this._executeParam.getSoluInfo().getId().toString());
        if (map != null && !map.isEmpty()) {
            SumRptAddedPerportyInfo addedPerporty = (SumRptAddedPerportyInfo)this.cslRptInfo.get("addedperporty");
            int version = Integer.valueOf(map.get("version").toString());
            String addGroup = String.valueOf(map.get("group"));
            addedPerporty.setVersion(version);
            addedPerporty.setGroup(addGroup);
            this.cslRptInfo.put("addedPerporty", addedPerporty);
        }
        this.cslRptInfo.setOrgType(OrgType.getEnum((int)this._executeParam.getSoluInfo().getOrgBound().getLayerType().getValue()));
        this.cslRptInfo.setDataCollect(this._executeParam.getDataCollInfo());
        IObjectPK pk = CslReportFactory.getLocalInstance(this._ctx).submit((CoreBaseInfo)this.cslRptInfo);
        this.cslRptInfo.setId(BOSUuid.read((String)pk.toString()));
    }

    public void calcFromSumRpt(CslReportInfo cslRptInfo, Book book, UserInfo userInfo) throws Exception {
        this.initParamsFromSumRpt(this._ctx, cslRptInfo, book, userInfo);
        if (cslRptInfo == null || this._executeParam == null || this.needSumUnits == null) {
            return;
        }
        SumRptCalcAssist assist = this.getAssist(cslRptInfo, book);
        ExistNoReceRptSelectCalcEnum selectCalcType = ExistNoReceRptSelectCalcEnum.CONTINUECALC;
        assist.sumAutoCalc(false, null, selectCalcType);
    }

    public void saveFromSumRpt(CslReportInfo cslRptInfo, Book book, UserInfo userInfo) throws Exception {
        this.initParamsFromSumRpt(this._ctx, cslRptInfo, book, userInfo);
        if (cslRptInfo == null || this._executeParam == null || this.needSumUnits == null) {
            return;
        }
        SumRptCalcAssist assist = this.getAssist(cslRptInfo, book);
        assist.sumSaveAfterAutoCalc(cslRptInfo.getId().toString());
    }

    public void initForCalAndSave(CslReportInfo cslRptInfo, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo querySoluInfo, DynaSumMethodEnum defaultDySumMethod, String userId, boolean isFromStatutory) throws Exception {
        this.isFromStatutory = isFromStatutory;
        if (cslRptInfo == null) {
            return;
        }
        if (!isFromStatutory && cslRptInfo.getFastMergeSoluId() == null) {
            return;
        }
        this.cslRptInfo = cslRptInfo;
        if (soluInfo == null) {
            return;
        }
        this.soluInfo = soluInfo;
        this.querySoluInfo = querySoluInfo;
        this.createRptStrategy = soluInfo.isIsSupportGroupReport() ? 1 : 2;
        OrgUnitCollection needSumUnits = new OrgUnitCollection();
        MnsFillOrgUnitCollection mnsFillOrgColl = querySoluInfo.getOrgUnitCollection();
        for (int i = 0; i < mnsFillOrgColl.size(); ++i) {
            needSumUnits.add((OrgUnitInfo)mnsFillOrgColl.get(i).getFullOrgUnitInfo());
        }
        this.defaultDySumMethod = querySoluInfo.getSumMethod();
        this.needSumUnits = needSumUnits;
    }

    private boolean calcAndSave(CslReportInfo cslRptInfo, Book book) throws Exception {
        CslRptUtil.prepareCalculate(this._ctx, cslRptInfo, book, true);
        SumRptCalcAssist assist = this.getAssist(cslRptInfo, book);
        ExistNoReceRptSelectCalcEnum selectCalcType = ExistNoReceRptSelectCalcEnum.CONTINUECALC;
        boolean isContinue = assist.sumAutoCalc(false, this.getSelectedCompanys(), selectCalcType);
        if (!isContinue) {
            return false;
        }
        assist.sumSaveAfterAutoCalc(cslRptInfo.getId().toString());
        return true;
    }

    private Vector getSelectedCompanys() {
        if (this.needSumUnits == null) {
            return new Vector();
        }
        Vector<OrgUnitInfo> vector = new Vector<OrgUnitInfo>(this.needSumUnits.size());
        for (OrgUnitInfo info : this.needSumUnits) {
            vector.add(info);
        }
        return vector;
    }

    public boolean calcAndSave() throws Exception {
        this.calcAndSave(this.cslRptInfo, this.cslRptInfo.getBook());
        return true;
    }

    private SumRptCalcAssist getAssist(CslReportInfo cslRptInfo, Book book) throws Exception {
        if (!this.isFromStatutory && !this._executeParam.getSoluInfo().isIsAutoSum()) {
            return null;
        }
        boolean isShowTotal = false;
        int displayNumber = 0;
        boolean isGradeList = false;
        boolean isOrderList = false;
        DynaSumMethodEnum sumMethod = this.defaultDySumMethod;
        if (this.schmInfo != null && this.schmInfo.getSumMethod() > 0) {
            sumMethod = DynaSumMethodEnum.getEnum(this.schmInfo.getSumMethod());
        }
        boolean isByTemplate = sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE);
        if (cslRptInfo.getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC)) {
            if (this.schmInfo != null && this.schmInfo.getShowTotal() != 16) {
                isOrderList = true;
            }
            int n = displayNumber = this.schmInfo == null ? 200 : this.schmInfo.getDisplayNum();
            if (this.schmInfo != null && this.schmInfo.getOnlyList() != 16) {
                isGradeList = true;
            }
            if (isOrderList && (sumMethod.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || sumMethod.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME))) {
                isShowTotal = true;
            }
        }
        Boolean isBySumReport = true;
        if (this.schmInfo != null && this.schmInfo.getSumCalculateMethod() == 1) {
            isBySumReport = false;
        }
        SumRptCalcAssist assist = new SumRptCalcAssist(this._ctx, sumMethod, isBySumReport, cslRptInfo, book, isShowTotal, displayNumber, isByTemplate, isOrderList, isGradeList, null, this.createRptStrategy);
        assist.setRelateParamMap(this.getFastMergeParamMap());
        Vector<OrgUnitInfo> needSumCompanys = new Vector<OrgUnitInfo>(0);
        for (int i = 0; i < this.needSumUnits.size(); ++i) {
            needSumCompanys.add(this.needSumUnits.get(i));
        }
        assist.initCompanys(needSumCompanys);
        return assist;
    }

    private boolean calc() throws Exception {
        if (!this._executeParam.getSoluInfo().isIsAutoSum()) {
            return false;
        }
        boolean isShowTotal = false;
        int displayNumber = 0;
        boolean isGradeList = false;
        boolean isOrderList = false;
        ExistNoReceRptSelectCalcEnum selectCalcType = ExistNoReceRptSelectCalcEnum.CONTINUECALC;
        DynaSumMethodEnum sumMethod = this.defaultDySumMethod;
        if (this.schmInfo != null && this.schmInfo.getSumMethod() > 0) {
            sumMethod = DynaSumMethodEnum.getEnum(this.schmInfo.getSumMethod());
        }
        boolean isByTemplate = sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE);
        if (this.templateInfo.getDynaRptType().equals((Object)DynaEnumRptTypeEnum.DYNAMIC)) {
            if (this.schmInfo != null && this.schmInfo.getShowTotal() != 16) {
                isOrderList = true;
            }
            int n = displayNumber = this.schmInfo == null ? 200 : this.schmInfo.getDisplayNum();
            if (this.schmInfo != null && this.schmInfo.getOnlyList() != 16) {
                isGradeList = true;
            }
            if (isOrderList && (sumMethod.equals((Object)DynaSumMethodEnum.LIST_COMPANY_NAME) || sumMethod.equals((Object)DynaSumMethodEnum.LIST_DETAIL_COMP_NAME))) {
                isShowTotal = true;
            }
        }
        Boolean isBySumReport = true;
        Book book = this.cslRptInfo.getBook();
        if (this.schmInfo != null && this.schmInfo.getSumCalculateMethod() == 1) {
            isBySumReport = false;
        }
        SumRptCalcAssist assist = new SumRptCalcAssist(this._ctx, sumMethod, isBySumReport, this.cslRptInfo, book, isShowTotal, displayNumber, isByTemplate, isOrderList, isGradeList, null, this._executeParam.getCreateRptStrategy());
        Vector<OrgUnitInfo> needSumCompanys = new Vector<OrgUnitInfo>(0);
        for (int i = 0; i < this.needSumUnits.size(); ++i) {
            needSumCompanys.add(this.needSumUnits.get(i));
        }
        assist.setRelateParamMap(this.getFastMergeParamMap());
        boolean isContinue = assist.sumAutoCalc(false, needSumCompanys, selectCalcType);
        if (!isContinue) {
            return false;
        }
        assist.sumSaveAfterAutoCalc(this.cslRptInfo.getId().toString());
        return true;
    }

    private String getExistSumRptId(Context ctx, String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType, boolean isSupportGroupReport, String fastMergeSoluId) throws BOSException, EASBizException {
        String dataCollectNumber = "ACTUALDATA";
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", treeID);
        params.put("companyID", companyID);
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currencyID);
        params.put("templateGroupNumber", templateGroupNumber);
        params.put("reportType", new Integer(reportType));
        params.put("dataCollectNumber", dataCollectNumber);
        params.put("isSupportGroupReport", isSupportGroupReport);
        params.put("fastMergeSoluId", fastMergeSoluId);
        return RptAutoWeaveUtil.getSumRptid(ctx, params);
    }

    private Map getFastMergeParamMap() {
        HashMap<String, Object> fastMergeParamMap = new HashMap<String, Object>();
        fastMergeParamMap.put("isSupportGroupReport", this.isFromStatutory ? true : this.soluInfo.isIsSupportGroupReport());
        if (this.soluInfo.isIsAutoSum()) {
            fastMergeParamMap.put("fastMergeSoluId", this.soluInfo.getId().toString());
            if (this.soluInfo.getAdjustEntrySolu() != null) {
                AdjustTypeEntriesCollection typeColl;
                fastMergeParamMap.put("isRelateExistData_adjust", this.soluInfo.getAdjustEntrySolu().isIsRelateExistData());
                String orgBound_fast = this.soluInfo.getOrgBound().getId().toString();
                boolean isSameOrgBound = true;
                if (this._executeParam.getAdjustSolu().getOrgBound() != null) {
                    String orgBound_adjust = this.soluInfo.getAdjustEntrySolu().getOrgBound().getId().toString();
                    isSameOrgBound = orgBound_adjust.equals(orgBound_fast);
                }
                fastMergeParamMap.put("isSameOrgBound", isSameOrgBound);
                ArrayList<String> adjustTypeIds = new ArrayList<String>();
                if (this.soluInfo.getAdjustEntrySolu().isIsRelateExistData() && (typeColl = this.soluInfo.getAdjustEntrySolu().getAdjustTypeEntries()).size() > 0) {
                    StringBuffer sbuf = new StringBuffer();
                    for (int i = 0; i < typeColl.size(); ++i) {
                        String typeId = typeColl.get(i).getAdjustType().getId().toString();
                        adjustTypeIds.add(typeId);
                    }
                }
                fastMergeParamMap.put("adjustTypeIds", adjustTypeIds);
            }
        }
        return fastMergeParamMap;
    }
}

