/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaItemElimEntryCondition;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminateByMainInvestFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.IEliminateByMainInvestFacade;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationEntry;
import com.kingdee.eas.fi.gr.cslrpt.IInterCheck;
import com.kingdee.eas.fi.gr.cslrpt.IInterDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IInvestCheck;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.IRPTInterItemData;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckCondition;
import com.kingdee.eas.fi.gr.cslrpt.InvestCheckFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RecordTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.EliminationEntryCopy;
import com.kingdee.eas.fi.gr.cslrpt.app.EliminationTmpBatchImport;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.fast.CSLContextData;
import com.kingdee.eas.fi.gr.fast.ElimEntriesTemplateCollection;
import com.kingdee.eas.fi.gr.fast.ElimEntriesTemplateInfo;
import com.kingdee.eas.fi.gr.fast.ElimTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ElimSoluExecute
implements ISoluExecute {
    private static Logger LOGGER = Logger.getLogger(ElimSoluExecute.class);
    private static final int OPRT_AUDIT = 0;
    private static final int OPRT_UNAUDIT = 1;
    protected SolutionExecuteParam soluExecuteParam;
    protected Context ctx;
    private IElimination iElimination;
    private FullOrgUnitCollection orgUnits;
    private EliminationEntiresSoluInfo elimSolu = null;
    private CSLContextData cslContest = null;
    private boolean isSupportGroup = false;
    private IInterCheck iInterCheck = null;
    private IInvestDataProvider iInvestDataProvider = null;
    private IRPTInterItemData iRPTInterItemData = null;
    private IInterDataProvider iInterDataProvider = null;
    private IEliminationEntry iEliminationEntry = null;

    public ElimSoluExecute(SolutionExecuteParam soluExecuteParam, Context ctx) throws BOSException {
        this.soluExecuteParam = soluExecuteParam;
        this.ctx = ctx;
        this.iElimination = EliminationFactory.getLocalInstance(ctx);
        this.iInterCheck = InterCheckFactory.getLocalInstance(ctx);
        this.iInvestDataProvider = InvestDataProviderFactory.getLocalInstance(ctx);
        this.iRPTInterItemData = RPTInterItemDataFactory.getLocalInstance(ctx);
        this.iInterDataProvider = InterDataProviderFactory.getLocalInstance(ctx);
        this.iEliminationEntry = EliminationEntryFactory.getLocalInstance(ctx);
        this.init();
    }

    private void init() throws BOSException {
        this.elimSolu = this.soluExecuteParam.getElimSolu();
        this.isSupportGroup = this.soluExecuteParam.getSoluInfo().isIsSupportGroupReport();
        this.cslContest = new CSLContextData(this.soluExecuteParam.getDataCollInfo(), this.soluExecuteParam.getSoluInfo().getOrgBound(), (OrgUnitInfo)this.soluExecuteParam.getCurOrgUnit(), this.soluExecuteParam.getReportDate(), this.soluExecuteParam.getPeriod(), RptPeriodTypeEnum.getEnum((int)this.soluExecuteParam.getPeriodType()), this.soluExecuteParam.getYear(), false);
    }

    private boolean isCanExecute() {
        return this.elimSolu != null && this.elimSolu.getId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (!this.isCanExecute()) {
            return;
        }
        Map param = this.getInterCheckParam(false, null, null, ElimTypeEnum.ComeAndGo);
        HashSet createIds = null;
        this.beforeExecute(param);
        if (this.elimSolu.isIsImportDynaItemData()) {
            ElimEntriesTemplateCollection co = this.elimSolu.getTemplates();
            HashSet<String> templateNumbers = new HashSet<String>();
            for (int i = 0; i < co.size(); ++i) {
                ElimEntriesTemplateInfo info = co.get(i);
                templateNumbers.add(info.getTemplate().getNumber());
            }
            if (templateNumbers.size() > 0) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("KeyOrgTree", this.cslContest.getCurOrgBound());
                params.put("KeyOrgUnit", this.cslContest.getCurOrgGroup());
                params.put("Year", this.cslContest.getCurRptYear());
                params.put("Period", this.cslContest.getCurRptPeriod());
                params.put("PeriodType", this.cslContest.getCurRptPeriodType().getValue());
                params.put("MERGETYPE", this.soluExecuteParam.getElimBoundMergeMode().getValue());
                params.put("KEY_CURRENCY_ID", this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString());
                params.put("dataCollectNumber", this.cslContest.getCurDataCollect().getNumber());
                params.put("templateNumbers", templateNumbers);
                params.put("fastMergeSoluId", this.soluExecuteParam.getSoluInfo().getId().toString());
                params.put("isUnReceive", this.soluExecuteParam.getSoluInfo().isIsContainUnRecive());
                String msg = this.iRPTInterItemData.importInterAndExchItemData(params);
                if (!StringUtils.isEmpty((String)msg)) {
                    LOGGER.info((Object)msg);
                }
            }
        }
        if (this.elimSolu.isIsAutoCreateElimComeAndGo()) {
            param.put("elimType", ElimTypeEnum.ComeAndGo);
            this.iInterCheck.checkDataNew(param);
            this.checkEntriesConform(param, ElimTypeEnum.ComeAndGo, 0);
            this.deleteElimination(param, ElimTypeEnum.ComeAndGo);
            this.createElimination(param, ElimTypeEnum.ComeAndGo);
            if (!param.get("createIds").equals("")) {
                createIds = (HashSet)param.get("createIds");
            }
            if (this.isSupportGroup && createIds != null && createIds.size() > 0) {
                this.batchAudit(createIds);
            }
        }
        if (this.elimSolu.isIsAutoCreateElimExchange()) {
            param.put("elimType", ElimTypeEnum.exchange);
            this.iInterCheck.checkDataNew(param);
            this.checkEntriesConform(param, ElimTypeEnum.exchange, 0);
            this.deleteElimination(param, ElimTypeEnum.exchange);
            this.createElimination(param, ElimTypeEnum.exchange);
            if (!param.get("createIds").equals("")) {
                createIds = (HashSet)param.get("createIds");
            }
            if (this.isSupportGroup && createIds != null && createIds.size() > 0) {
                this.batchAudit(createIds);
            }
        }
        if (this.elimSolu.isIsAutoCreateElimInvest()) {
            block20: {
                this.investCheck();
                this.investAudit();
                this.addParamValueForMainInvest(param);
                IEliminateByMainInvestFacade elimInvest = EliminateByMainInvestFacadeFactory.getLocalInstance(this.ctx);
                try {
                    if (elimInvest.checkExists(param)) {
                        elimInvest.delete(param);
                    }
                }
                catch (AdjustException adjust) {
                    if (!adjust.getSubCode().equals(AdjustException.EXISTS_AUDITED_CAG_ELIMINATIONDATAS.getCode())) break block20;
                    return;
                }
            }
            param.put("mergeType", this.isSupportGroup ? 0 : 1);
            EliminateByMainInvestFacadeFactory.getLocalInstance(this.ctx).createElimRecords(param);
            if (!param.get("createIds").equals("")) {
                createIds = (HashSet)param.get("createIds");
            }
            if (this.isSupportGroup && createIds != null && createIds.size() > 0) {
                this.batchAudit(createIds);
            }
        }
        ElimSoluExecute elimSoluExecute = this;
        synchronized (elimSoluExecute) {
            Object o1 = this.ctx.get((Object)"KEY_ORGTREE_INFO");
            Object o2 = this.ctx.get((Object)OrgType.UnionDebt);
            Object o3 = this.ctx.get((Object)"KEY_DATACOLLECT_NUMBER");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY_ORGTREE_INFO", this.cslContest.getCurOrgBound());
            map.put((String)OrgType.UnionDebt, this.cslContest.getCurOrgGroup());
            map.put("KEY_DATACOLLECT_NUMBER", this.cslContest.getCurDataCollect().getNumber());
            IContextManager imanager = null;
            imanager = this.ctx == null ? ContextManagerFactory.getRemoteInstance() : ContextManagerFactory.getLocalInstance((Context)this.ctx);
            imanager.setContext(map);
            this.createElimDynaItem();
            this.copyFixedElimData();
            this.importFromBaseOrgBound();
            this.copyHisElimData();
            this.createElimByAdjTmpAndAudit();
            map.put("KEY_ORGTREE_INFO", o1);
            map.put((String)OrgType.UnionDebt, o2);
            map.put("KEY_DATACOLLECT_NUMBER", o3);
            imanager.setContext(map);
        }
    }

    private void beforeExecute(Map param) throws BOSException, EASBizException {
        if (!this.soluExecuteParam.getSoluInfo().isIsContainUnRecive()) {
            return;
        }
        if (this.elimSolu.isIsAutoCreateElimComeAndGo()) {
            this.deleteElimination(param, ElimTypeEnum.ComeAndGo);
        }
        if (this.elimSolu.isIsAutoCreateElimExchange()) {
            this.deleteElimination(param, ElimTypeEnum.exchange);
        }
        if (this.elimSolu.isIsAutoCreateElimComeAndGo()) {
            this.checkEntriesConform(param, ElimTypeEnum.ComeAndGo, 1);
        }
        if (this.elimSolu.isIsAutoCreateElimExchange()) {
            this.checkEntriesConform(param, ElimTypeEnum.exchange, 1);
        }
    }

    private void createElimDynaItem() throws BOSException, EASBizException {
        if (!this.soluExecuteParam.getElimSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getElimSolu().isIsGenDynaElim()) {
            return;
        }
        ArrayList<ElimTypeEnum> elimTypeLst = new ArrayList<ElimTypeEnum>();
        if (this.elimSolu.isIsAutoCreateElimComeAndGo()) {
            elimTypeLst.add(ElimTypeEnum.ComeAndGo);
        }
        if (this.elimSolu.isIsAutoCreateElimExchange()) {
            elimTypeLst.add(ElimTypeEnum.exchange);
        }
        if (this.elimSolu.isIsAutoCreateElimInvest()) {
            elimTypeLst.add(ElimTypeEnum.Main_Invest_New);
        }
        if (elimTypeLst.size() == 0) {
            elimTypeLst.add(ElimTypeEnum.ComeAndGo);
            elimTypeLst.add(ElimTypeEnum.exchange);
            elimTypeLst.add(ElimTypeEnum.Main_Invest_New);
        }
        ElimTypeEnum[] elimTypeArrs = new ElimTypeEnum[elimTypeLst.size()];
        elimTypeLst.toArray(elimTypeArrs);
        DynaItemElimEntryCondition condition = new DynaItemElimEntryCondition();
        HashMap<String, DynaItemElimEntryCondition> paramsMap = new HashMap<String, DynaItemElimEntryCondition>();
        paramsMap.put("queryCondition", condition);
        condition.setTreeid(this.cslContest.getCurOrgBound().getId().toString());
        condition.setOrgUnitId(this.cslContest.getCurOrgGroup().getId().toString());
        condition.setYear(this.cslContest.getCurRptYear());
        condition.setPeriod(this.cslContest.getCurRptPeriod());
        condition.setPeriodType(this.cslContest.getCurRptPeriodType().getValue());
        condition.setState(DynaItemElimEntryCondition.QueryAuditStatEnum.AllStat);
        condition.setElimTypes(elimTypeArrs);
        IElimDynaItemEntry elimDynaItemEntry = null;
        elimDynaItemEntry = this.ctx == null ? ElimDynaItemEntryFactory.getRemoteInstance() : ElimDynaItemEntryFactory.getLocalInstance(this.ctx);
        elimDynaItemEntry.generateDynaItemElimByGivenElimType(paramsMap);
    }

    private void copyFixedElimData() throws BOSException, EASBizException {
        if (!this.soluExecuteParam.getElimSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getElimSolu().isIsCopyFixedEntries()) {
            return;
        }
        RptProperties pp = new RptProperties();
        pp.setString("treeId", this.cslContest.getCurOrgBound().getId().toString());
        pp.setString("orgUnitId", this.cslContest.getCurOrgGroup().getId().toString());
        pp.setInt("year", this.cslContest.getCurRptYear());
        pp.setInt("period", this.cslContest.getCurRptPeriod());
        pp.setInt("periodType", this.cslContest.getCurRptPeriodType().getValue());
        pp.setObject("dataCollect", this.cslContest.getCurDataCollect());
        pp.setObject("KEY_ORGTREE_INFO", this.cslContest.getCurOrgBound());
        pp.setObject("KEY_ORGUNIT_INFO", this.cslContest.getCurOrgGroup());
        EliminationEntryCopy elimCopy = new EliminationEntryCopy();
        List<Object> pks = new ArrayList();
        try {
            pks = elimCopy.copyFixedElimData(this.ctx, pp);
        }
        catch (AdjustException e) {
            LOGGER.info((Object)ResourceDebugUtil.res("com.kingdee.eas.fi.gr.fast.FastMergeResource", "recordIsNotBeCopyed", " "));
        }
        if (this.isSupportGroup) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < pks.size(); ++i) {
                idSet.add(((IObjectPK)pks.get(i)).toString());
            }
            this.batchAudit(idSet);
        }
    }

    private void importFromBaseOrgBound() throws BOSException, EASBizException {
        String elimModeIds;
        boolean isByLevel;
        if (!this.soluExecuteParam.getElimSolu().isIsAutoCreateEntries()) {
            return;
        }
        if (!this.soluExecuteParam.getElimSolu().isIsImportFromBase()) {
            return;
        }
        if (this.soluExecuteParam.getSoluInfo().getOrgBound().isBasic()) {
            return;
        }
        Date reportDate = FastMergeUtil.getPeriodLastDate(this.ctx, this.cslContest.getCurOrgBound(), this.cslContest.getCurRptYear(), this.cslContest.getCurRptPeriod(), this.cslContest.getCurRptPeriodType());
        String treeNumber = this.cslContest.getCurOrgBound().getNumber();
        String unitNumber = this.cslContest.getCurOrgGroup().getNumber();
        int year = this.cslContest.getCurRptYear();
        int period = this.cslContest.getCurRptPeriod();
        int periodType = this.cslContest.getCurRptPeriodType().getValue();
        OrgTreeInfo orgTreeInfo = FastMergeUtil.getOrgTreeByDateAndNo(this.ctx, year, period, periodType, treeNumber);
        FullOrgUnitInfo orgUnitInfo = FastMergeUtil.getOrgUnitByDateAndNo(this.ctx, year, period, periodType, treeNumber, unitNumber);
        if (orgUnitInfo == null) {
            return;
        }
        String basicOrgTrees = CslRptUtil.getBasicTree(this.ctx, reportDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("year", year);
        param.put("period", period);
        param.put("periodType", periodType);
        param.put("orgBound.id", "'" + basicOrgTrees + "'");
        param.put("orgUnitInfo", orgUnitInfo);
        param.put("importBasicTreeType", "2");
        param.put("curTreeInfo", orgTreeInfo);
        List curCompanyIds = this.iElimination.getCurChildCompanyFromCurTree(param);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.item.number"));
        viewInfo.setSelector(selector);
        int iMergeMode = this.soluExecuteParam.getSoluBoundMergeMode().getValue();
        boolean bl = isByLevel = iMergeMode == 0;
        if (isByLevel) {
            this.filterShowImportElimByDirect(viewInfo, param, curCompanyIds);
        } else {
            this.filterShowImportElimByOrdinal(viewInfo, param, curCompanyIds, (OrgUnitInfo)orgUnitInfo);
        }
        IRowSet rs = this.iElimination.getElimCountByOrgUnit(param);
        ArrayList<String> lastList = new ArrayList<String>();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        if (isByLevel) {
            this.checkCurCompanyIsContainBasicCompany(rs, lastList, curCompanyIds);
        } else {
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    boolean boo = this.checkCurOrgUnitIsContainBasicCompanyForShunXu(orgTreeInfo, (OrgUnitInfo)orgUnitInfo, curCompanyIds, id);
                    if (!boo) continue;
                    lastList.add(id);
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
        if (lastList.size() > 0) {
            sbFormula.append("(");
            for (int i = 0; i < lastList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)lastList.get(i).toString(), CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++).append(")");
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
        } else {
            return;
        }
        if (this.soluExecuteParam.getSoluInfo().getCurrency() != null) {
            CurrencyInfo currency = this.soluExecuteParam.getSoluInfo().getCurrency();
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            sbFormula.append(" and #" + formulaIndex++);
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)currency.getId().toString()));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(elimModeIds = this.soluExecuteParam.getElimSolu().getElimModeIds()))) {
            String[] arr = elimModeIds.split(";");
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(arr));
            filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", set, CompareType.INCLUDE));
            if (elimModeIds.indexOf("null") >= 0) {
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", null, CompareType.EQUALS));
                sbFormula.append(" and ( #" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
            } else {
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        filter.setMaskString(sbFormula.toString());
        viewInfo.setFilter(filter);
        EliminationCollection recordElimColl = this.iElimination.getEliminationCollection(viewInfo);
        HashSet<String> idSet = new HashSet<String>();
        EliminationInfo elimInfo = null;
        String strOrgID = CSLServerHelper.getRootOrgIDForRootCU(this.ctx);
        boolean hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(this.ctx, (IObjectValue)new EliminationInfo(), strOrgID);
        for (int i = 0; i < recordElimColl.size(); ++i) {
            elimInfo = recordElimColl.get(i);
            BOSUuid sourceElimId = elimInfo.getId();
            EliminationInfo sourceElimInfo = new EliminationInfo();
            sourceElimInfo.setId(sourceElimId);
            elimInfo.setSourceElimination(sourceElimInfo);
            String orgTreeId = orgTreeInfo.getId().toString();
            elimInfo.setId(null);
            elimInfo.setOrgBound(orgTreeInfo);
            elimInfo.setOrgUnit((OrgUnitInfo)orgUnitInfo);
            if (!this.isSupportGroup) {
                elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                elimInfo.setAuditDate(null);
                elimInfo.setAuditor(null);
            }
            String currentNumber = this.getCurrentMaxNumber(this.ctx, orgTreeId, periodType, year, period, "T_CSL_Elimination");
            if (hasCodeRule) {
                currentNumber = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx).getNumber((IObjectValue)elimInfo, strOrgID);
            }
            elimInfo.setNumber(currentNumber);
            if (this.isImportBefore(sourceElimId.toString(), orgTreeId, periodType, year, period, orgUnitInfo.getId().toString())) continue;
            for (int j = 0; j < elimInfo.getEntries().size(); ++j) {
                EliminationEntryInfo entryInfo = elimInfo.getEntries().get(j);
                BOSUuid bosUuid = BOSUuid.create((BOSObjectType)new ElimDynaItemEntryInfo().getBOSType());
                entryInfo.setId(bosUuid);
            }
            ServiceManagerFactory.getServiceManager().disableService("PERMISSION_SERVICE");
            idSet.add(this.iElimination.addnew((CoreBaseInfo)elimInfo).toString());
        }
        if (this.isSupportGroup) {
            this.batchAudit(idSet);
        }
    }

    private ElimRelaOrgTreeInfo setElimRelaOrgTreeInfo(BOSUuid id, String orgTreeId) {
        ElimRelaOrgTreeInfo elimRelaOrgTreeInfo = new ElimRelaOrgTreeInfo();
        elimRelaOrgTreeInfo.setElimId(id.toString());
        elimRelaOrgTreeInfo.setOrgTreeId(orgTreeId);
        elimRelaOrgTreeInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        elimRelaOrgTreeInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        elimRelaOrgTreeInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        elimRelaOrgTreeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        elimRelaOrgTreeInfo.setRecordType(RecordTypeEnum.ELIMINATION);
        return elimRelaOrgTreeInfo;
    }

    private boolean isImportBefore(String sourceElimId, String orgTreeId, int periodType, int year, int period, String orgUnitId) throws BOSException, EASBizException {
        boolean hadCopyBySourceAdjustId = this.iElimination.exists("select 1 where sourceElimination.id ='" + sourceElimId + "' and checkedStatus=2 and orgBound.id = '" + orgTreeId + "' and periodType = " + periodType + " and year = " + year + " and period = " + period + " and orgUnit.id = '" + orgUnitId + "'");
        if (hadCopyBySourceAdjustId) {
            return true;
        }
        StringBuffer strSQL = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        strSQL.append(" delete from t_csl_elimination where ");
        strSQL.append(" fSourceEliminationid = ? ");
        params.add(sourceElimId);
        strSQL.append(" and fCheckedStatus = 1 ");
        strSQL.append(" and fOrgBoundId = ? ");
        params.add(orgTreeId);
        strSQL.append(" and fPeriodType = ? ");
        params.add(periodType);
        strSQL.append(" and fYear = ? ");
        params.add(year);
        strSQL.append(" and fPeriod = ? ");
        params.add(period);
        strSQL.append(" and fOrgUnit = ? ");
        params.add(orgUnitId);
        DbUtil.execute((Context)this.ctx, (String)strSQL.toString(), (Object[])params.toArray());
        return false;
    }

    private void investCheck() throws BOSException, EASBizException {
        String elimMethod = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(this.elimSolu.getOrgBound().getId()), (String)"GR_CSL_ELIMMETHOD_001");
        if (String.valueOf(4).equals(elimMethod)) {
            return;
        }
        InvestCheckCondition ic = new InvestCheckCondition();
        ic.setOrgTreeId(this.cslContest.getCurOrgBound().getId().toString());
        ic.setOrgBoundId(this.cslContest.getCurOrgGroup().getId().toString());
        ic.setPeriodType(this.cslContest.getCurRptPeriodType().getValue());
        ic.setYear(this.cslContest.getCurRptYear());
        ic.setPeriod(this.cslContest.getCurRptPeriod());
        ic.setCurrencyId(null);
        ic.setCompanyId(null);
        ic.setTargetCompanyId(null);
        ic.setDay(this.cslContest.getCurReportDate());
        boolean mergeMode = this.soluExecuteParam.getElimBoundMergeMode().getValue() == 1;
        ic.setMergeMode(mergeMode);
        InvestCheckFactory.getLocalInstance(this.ctx).buildCheckage(ic);
    }

    private void investAudit() throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        try {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.cslContest.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("orgUnit.id", (Object)this.cslContest.getCurOrgGroup().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("periodType", (Object)new Integer(this.cslContest.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("year", (Object)new Integer(this.cslContest.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem4 = new FilterItemInfo("period", (Object)new Integer(this.cslContest.getCurRptPeriod()), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (BOSException e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        FilterItemInfo filterItemCurrency = new FilterItemInfo("currency.id", (Object)this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemCurrency);
        sbFormula.append(" and #" + formulaIndex++);
        try {
            OrgUnitInfo uif = this.cslContest.getCurOrgGroup();
            if (uif.isIsGrouping()) {
                ArrayList arr = CslRptUtil.getAuthenticUnits(this.ctx, this.cslContest.getCurOrgBound().getId().toString(), uif.getId().toString(), (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "InvestCheckageListUI"), (IMetaDataPK)new MetaDataPK("actionView"), 1);
                OrgUnitInfo ouif = null;
                int n = arr.size();
                if (n > 0) {
                    sbFormula.append(" and (");
                }
                for (int i = 0; i < n; ++i) {
                    ouif = (OrgUnitInfo)arr.get(i);
                    if (i > 0) {
                        sbFormula.append("\tor \t");
                    }
                    String companyId = ouif.getId().toString();
                    FilterItemInfo filterItemCompany = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemCompany);
                    sbFormula.append(" #").append(formulaIndex++);
                }
                if (n > 0) {
                    sbFormula.append(" )");
                }
            } else {
                String companyId = uif.getId().toString();
                FilterItemInfo filterItemCompany = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemCompany);
                sbFormula.append("  and #" + formulaIndex++);
            }
        }
        catch (EASBizException e2) {
            LOGGER.error((Object)"", (Throwable)e2);
        }
        catch (BOSException e2) {
            LOGGER.error((Object)"", (Throwable)e2);
        }
        try {
            OrgUnitInfo uif2 = this.cslContest.getCurOrgGroup();
            if (uif2.isIsGrouping()) {
                ArrayList arr = CslRptUtil.getAuthenticUnits(this.ctx, this.cslContest.getCurOrgBound().getId().toString(), uif2.getId().toString(), (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt.client", "InvestCheckageListUI"), (IMetaDataPK)new MetaDataPK("actionView"), 1);
                OrgUnitInfo ouif = null;
                int n = arr.size();
                if (n > 0) {
                    sbFormula.append(" and (");
                }
                for (int i = 0; i < n; ++i) {
                    ouif = (OrgUnitInfo)arr.get(i);
                    if (i > 0) {
                        sbFormula.append("\tor \t");
                    }
                    String companyId = ouif.getId().toString();
                    FilterItemInfo filterItemTgtCompany = new FilterItemInfo("targetCompany.id", (Object)companyId, CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemTgtCompany);
                    sbFormula.append(" #").append(formulaIndex++);
                }
                if (n > 0) {
                    sbFormula.append(" )");
                }
            } else {
                String companyId = uif2.getId().toString();
                FilterItemInfo filterItemTgtCompany = new FilterItemInfo("targetCompany.id", (Object)companyId, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemTgtCompany);
                sbFormula.append("  and #" + formulaIndex++);
            }
        }
        catch (EASBizException e2) {
            LOGGER.error((Object)"", (Throwable)e2);
        }
        catch (BOSException e2) {
            LOGGER.error((Object)"", (Throwable)e2);
        }
        filterInfo.setMaskString(sbFormula.toString());
        String queryInfoPK = "com.kingdee.eas.fi.gr.cslrpt.InvestCheckageQuery";
        Set<String> idSet = this.getEntryIds(filterInfo, queryInfoPK);
        IInvestCheck investCheck = null;
        if (idSet.size() > 0) {
            investCheck = InvestCheckFactory.getLocalInstance(this.ctx);
            investCheck.batchAudit(new ArrayList<String>(idSet), 1);
        }
        if ((idSet = this.getEntryIds(filterInfo, queryInfoPK = "com.kingdee.eas.fi.gr.cslrpt.InterestCheckageQuery")).size() > 0) {
            if (investCheck == null) {
                investCheck = InvestCheckFactory.getLocalInstance(this.ctx);
            }
            investCheck.batchAudit(new ArrayList<String>(idSet), 2);
        }
    }

    private Set<String> getEntryIds(FilterInfo filterInfo, String queryInfoPK) throws BOSException, SQLDataException {
        MetaDataPK queryPK = MetaDataPK.create((String)queryInfoPK);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        exec.setObjectView(view);
        HashSet<String> idSet = new HashSet<String>();
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return idSet;
    }

    private Map getInterCheckParam(boolean isByCompany, String companyId, String targetCompanyId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (!isByCompany) {
            param.put("isByCompany", new Boolean(false));
            param.put("orgTreeId", this.soluExecuteParam.getElimSolu().getOrgBound().getId().toString());
            param.put("orgUnitId", this.soluExecuteParam.getCurOrgUnit().getId().toString());
            param.put("elimType", (Object)elimType);
            param.put("mergeType", this.soluExecuteParam.getElimBoundMergeMode().getValue());
        }
        param.put("companyId", companyId);
        param.put("targetCompanyId", targetCompanyId);
        param.put("year", this.soluExecuteParam.getYear());
        param.put("period", this.soluExecuteParam.getPeriod());
        param.put("periodType", this.soluExecuteParam.getPeriodType());
        param.put("elimType", (Object)elimType);
        OrgTreeInfo treeInfo = this.soluExecuteParam.getElimSolu().getOrgBound();
        param.put("date", FiscalPeriodHelper.getRptLastDate(treeInfo, this.soluExecuteParam.getYear(), this.soluExecuteParam.getPeriod(), RptPeriodTypeEnum.getEnum((int)this.soluExecuteParam.getPeriodType()), this.ctx));
        param.put("dataCollectNumber", this.soluExecuteParam.getDataCollInfo().getNumber());
        param.put("createIds", "");
        param.put("fastMergeSoluId", this.soluExecuteParam.getSoluInfo().getId().toString());
        param.put("isUnReceive", this.soluExecuteParam.getSoluInfo().isIsContainUnRecive());
        param.put("currencyId", this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString());
        return param;
    }

    private void autoCreateGoAndComeElim() throws BOSException, EASBizException {
        if (!this.elimSolu.isIsAutoCreateElimComeAndGo()) {
            return;
        }
        Map param = this.getInterCheckParam(false, null, null, ElimTypeEnum.ComeAndGo);
        this.iInterCheck.checkDataNew(param);
    }

    private void checkEntriesConform(Map param, ElimTypeEnum elimType, int oprtType) throws BOSException, EASBizException {
        int mergeType = this.soluExecuteParam.getElimBoundMergeMode().getValue();
        RptProperties pp = this.getCheckAuditParam(param, false, mergeType, oprtType);
        if (elimType.equals((Object)ElimTypeEnum.ComeAndGo)) {
            pp.setString("WINDOWNAME", "INTERCHECKNEWLISTUI");
        } else if (elimType.equals((Object)ElimTypeEnum.exchange)) {
            pp.setString("WINDOWNAME", "EXCHCHECKAGELISTUI");
        }
        pp = this.iInterDataProvider.prepareFetchExchItemData(pp);
        RptRowSet rst = null;
        if (elimType.equals((Object)ElimTypeEnum.ComeAndGo)) {
            rst = this.iInterDataProvider.getCAGCheckData(pp);
        } else if (elimType.equals((Object)ElimTypeEnum.exchange)) {
            rst = this.iInterDataProvider.getExchCheckData(pp);
        }
        ArrayList<String> newLst = new ArrayList<String>();
        if (rst != null) {
            while (rst.next()) {
                Object obj = rst.getObject(0);
                if (obj == null) continue;
                String id = (String)rst.getObject(0);
                newLst.add(id);
            }
        }
        if (newLst.size() == 0) {
            return;
        }
        if (oprtType == 1) {
            this.iInterCheck.batchUnAudit(newLst, elimType);
        } else if (oprtType == 0) {
            this.iInterCheck.batchAudit(newLst, elimType);
        }
    }

    private RptProperties getCheckAuditParam(Map paramMap, boolean isByCompany, int mergeType, int oprtType) throws BOSException, EASBizException {
        RptProperties rptP = new RptProperties();
        rptP.putAll(paramMap);
        rptP.setInt("MERGETYPE", mergeType);
        rptP.setBoolean("isByCompany", isByCompany);
        rptP.setString("treeId", this.elimSolu.getOrgBound().getId().toString());
        if (oprtType == 0) {
            rptP.setInt("confirmStatus", 1);
        } else if (oprtType == 1) {
            rptP.setInt("confirmStatus", 2);
        }
        rptP.setBoolean("isFastMerge", Boolean.TRUE);
        rptP.setInt("from", 0);
        rptP.setInt("length", 1000000);
        rptP.setString("fromCurrency", paramMap.get("currencyId").toString());
        return rptP;
    }

    private void createElimination(Map param, ElimTypeEnum elimType) throws BOSException, EASBizException {
        param.put("orgBoundId", this.elimSolu.getOrgBound().getId().toString());
        Timestamp elimDate = new Timestamp(this.soluExecuteParam.getReportDate().getTime());
        param.put("elimDate", elimDate);
        param.put("elimType", elimType);
        param.put("isByCompany", this.elimSolu.isIsBaseCombin());
        param.put("basicTreeId", this.iInterCheck.getBasicTree(elimDate));
        param.put("displayTypeId", null);
        param.put("dataCollect", this.soluExecuteParam.getDataCollInfo());
        param.put("KEY_ORGTREE_INFO", this.elimSolu.getOrgBound());
        param.put("KEY_ORGUNIT_INFO", this.soluExecuteParam.getCurOrgUnit());
        param.put("Year", this.soluExecuteParam.getYear());
        param.put("Period", this.soluExecuteParam.getPeriod());
        param.put("PeriodType", this.soluExecuteParam.getPeriodType());
        param.put("ElimType", elimType.getValue());
        param.put("OrgTreeID", this.elimSolu.getOrgBound().getId().toString());
        param.put("OrgUnitID", this.soluExecuteParam.getCurOrgUnit().getId().toString());
        param.put("currencyId", this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString());
        param.put("fastMergeSoluId", this.soluExecuteParam.getSoluInfo().getId().toString());
        this.iInterCheck.noMergeCreateElimination(param);
    }

    private void deleteElimination(Map param, ElimTypeEnum elimType) throws BOSException, EASBizException {
        if (param == null) {
            param = new HashMap<String, String>();
        }
        param.put("orgBoundId", this.elimSolu.getOrgBound().getId().toString());
        Timestamp elimDate = new Timestamp(this.soluExecuteParam.getReportDate().getTime());
        param.put("elimDate", (String)((Object)elimDate));
        param.put("elimType", (String)((Object)elimType));
        param.put("isByCompany", (String)((Object)Boolean.valueOf(this.elimSolu.isIsBaseCombin())));
        param.put("basicTreeId", this.iInterCheck.getBasicTree(elimDate));
        param.put("displayTypeId", null);
        param.put("dataCollect", (String)((Object)this.soluExecuteParam.getDataCollInfo()));
        param.put("KEY_ORGTREE_INFO", (String)this.elimSolu.getOrgBound());
        param.put("KEY_ORGUNIT_INFO", (String)this.soluExecuteParam.getCurOrgUnit());
        param.put("Year", (String)((Object)Integer.valueOf(this.soluExecuteParam.getYear())));
        param.put("Period", (String)((Object)Integer.valueOf(this.soluExecuteParam.getPeriod())));
        param.put("PeriodType", (String)((Object)Integer.valueOf(this.soluExecuteParam.getPeriodType())));
        param.put("ElimType", (String)((Object)Integer.valueOf(elimType.getValue())));
        param.put("OrgTreeID", this.elimSolu.getOrgBound().getId().toString());
        param.put("OrgUnitID", this.soluExecuteParam.getCurOrgUnit().getId().toString());
        param.put("fastMergeSoluId", this.soluExecuteParam.getSoluInfo().getId().toString());
        this.iInvestDataProvider.deleteElimRecord(param);
    }

    private void aduitElimData() throws BOSException, EASBizException {
        String defaultQueryName = "com.kingdee.eas.fi.gr.cslrpt.EliminationQuery";
        MetaDataPK mainQueryPK = MetaDataPK.create((String)defaultQueryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
        EntityViewInfo view = FastMergeUtil.getElimDefaultSolu(this.ctx, this.cslContest, "", this.soluExecuteParam.isSupportOtherDS());
        view.getFilter().appendFilterItem("CheckedStatus", (Object)new Integer(1));
        view.getFilter().appendFilterItem("entries.isVisible", (Object)new Integer(1));
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        exec.setObjectView(view);
        try {
            HashSet<String> idSet = new HashSet<String>();
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            this.batchAudit(idSet);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void batchAudit(Set<String> idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        Iterator<String> iter = idSet.iterator();
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iter.next()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entries.*"));
            selector.add(new SelectorItemInfo("entries.item.number"));
            selector.add(new SelectorItemInfo("entries.company.number"));
            selector.add(new SelectorItemInfo("entries.company.name"));
            EliminationInfo info = this.iElimination.getEliminationInfo((IObjectPK)pk, selector);
            this.iElimination.audit((IObjectPK)pk, info, (IObjectPK)new ObjectUuidPK(this.soluExecuteParam.getCurUser().getId()));
        }
    }

    private void addParamValueForMainInvest(Map param) {
        param.put("KEY_SOURCECURRENCY", this.soluExecuteParam.getSoluInfo().getCurrency());
        param.put("KEY_CURRENCY", this.soluExecuteParam.getSoluInfo().getCurrency());
        param.put("KEY_MAININVEST_ELIMI", new Boolean(true));
        param.put("KEY_MAININVEST_ADJUST", new Boolean(true));
        param.put("elimType", 7);
        param.put("OrgTreeID", this.elimSolu.getOrgBound().getId().toString());
        param.put("KeyOrgTree", this.elimSolu.getOrgBound());
        param.put("OrgUnitID", this.soluExecuteParam.getCurOrgUnit().getId().toString());
        param.put("KeyOrgUnit", this.soluExecuteParam.getCurOrgUnit());
        param.put("Day", param.get("date"));
        param.put("Year", param.get("year"));
        param.put("Period", param.get("period"));
        param.put("PeriodType", param.get("periodType"));
    }

    private void copyHisElimData() throws BOSException, EASBizException {
        if (!this.elimSolu.isIsAutoCreateEntries()) {
            return;
        }
        if (!this.elimSolu.isIsCopyShiftEntries()) {
            return;
        }
        FilterInfo filterInfo = this.getCopyHisElimDataFilter();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        EliminationCollection cols = this.iElimination.getEliminationCollection(view);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < cols.size(); ++i) {
            idSet.add(cols.get(i).getId().toString());
        }
        if (idSet.size() == 0) {
            LOGGER.info((Object)"copyHisAdjustData:Size is 0!");
            return;
        }
        LOGGER.info((Object)("copyHisAdjustData:Size is" + idSet.size()));
        RptProperties pp = new RptProperties();
        pp.setString("treeId", this.cslContest.getCurOrgBound().getId().toString());
        pp.setString("orgUnitId", this.cslContest.getCurOrgGroup().getId().toString());
        pp.setInt("year", this.cslContest.getCurRptYear());
        pp.setInt("period", this.cslContest.getCurRptPeriod());
        pp.setInt("periodType", this.cslContest.getCurRptPeriodType().getValue());
        pp.setBoolean("isSunElimination", false);
        pp.setBoolean("isInitYearProfit", false);
        pp.setObject("list", new ArrayList(idSet));
        pp.setObject("dataCollect", this.soluExecuteParam.getDataCollInfo());
        pp.setObject("KEY_ORGTREE_INFO", this.cslContest.getCurOrgBound());
        pp.setObject("KEY_ORGUNIT_INFO", this.cslContest.getCurOrgGroup());
        EliminationEntryCopy elimCopy = new EliminationEntryCopy();
        List<IObjectPK> pks = elimCopy.copyHisData(this.ctx, pp);
        idSet.clear();
        for (int i = 0; i < pks.size(); ++i) {
            idSet.add(pks.get(i).toString());
        }
        if (this.isSupportGroup) {
            this.batchAudit(idSet);
        }
    }

    private String getTreeId(int year, int period) throws BOSException, EASBizException {
        Iterator iter;
        PeriodCollection periods = null;
        if (this.soluExecuteParam.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(this.ctx, this.cslContest.getOrgTree());
        }
        Map mapResult = FiscalPeriodHelper.getOrgTreeByPeriods(this.ctx, periods, this.cslContest.getOrgTree().getNumber(), year, year, period, period, this.cslContest.getCurRptPeriodType().getValue(), this.soluExecuteParam.isMergeByFiscalPeriod(), CslRptUtil.isSupport13Period(null));
        String treeId = null;
        List permTreeIds = this.getAuthorizedTreeId();
        if (mapResult.size() > 0 && !mapResult.isEmpty() && (iter = mapResult.keySet().iterator()).hasNext() && !permTreeIds.contains(treeId = (String)iter.next())) {
            treeId = null;
        }
        return treeId;
    }

    private List getAuthorizedTreeId() throws BOSException, EASBizException {
        ArrayList<String> permTreeIdList = new ArrayList<String>();
        UserInfo userInfo = (UserInfo)this.ctx.get((Object)"UserInfo");
        OrgTreeCollection treeCol = CslRptUtil.getAllUnionTreesOrderByNumber(this.ctx, userInfo.getId().toString(), null);
        if (treeCol != null) {
            for (int i = 0; i < treeCol.size(); ++i) {
                if (permTreeIdList.contains(treeCol.get(i).getId().toString())) continue;
                permTreeIdList.add(treeCol.get(i).getId().toString());
            }
        }
        return permTreeIdList;
    }

    private FilterInfo getCopyHisElimDataFilter() throws BOSException, EASBizException {
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filterInfo = new FilterInfo();
        int formulaIndex = 0;
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)this.cslContest.getCurOrgGroup().getNumber(), CompareType.EQUALS));
        ++formulaIndex;
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.cslContest.getCurRptPeriodType().getValue()), CompareType.EQUALS));
        ++formulaIndex;
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString(), CompareType.EQUALS));
        ++formulaIndex;
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)this.soluExecuteParam.getSoluInfo().getCurrency().getId().toString(), CompareType.EQUALS));
        ++formulaIndex;
        int periodOff = this.soluExecuteParam.getElimSolu().getShiftValue();
        List times = RPTDateUtil.getRptYearAndPeriodAndDate(this.cslContest.getCurRptYear(), this.cslContest.getCurRptPeriod(), this.cslContest.getCurRptPeriodType().getValue(), 0, periodOff);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)times.get(2));
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)startTime, CompareType.EQUALS));
        ++formulaIndex;
        Integer year = (Integer)times.get(0);
        filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
        ++formulaIndex;
        Integer period = (Integer)times.get(1);
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        ++formulaIndex;
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.number", (Object)this.cslContest.getOrgTree().getNumber(), CompareType.EQUALS));
        ++formulaIndex;
        filterInfo.getFilterItems().add(new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS));
        ++formulaIndex;
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#" + i + ")");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        filterInfo.setMaskString(sbFormula.toString());
        return filterInfo;
    }

    private void createElimByAdjTmpAndAudit() throws BOSException, EASBizException {
        if (!this.elimSolu.isIsAutoCreateEntries()) {
            return;
        }
        if (this.elimSolu.getElimTmpEntries() == null || this.elimSolu.getElimTmpEntries().size() == 0) {
            return;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("orgBoundId", this.cslContest.getCurOrgBound().getId().toString());
        valueMap.put("orgUnitID", this.cslContest.getCurOrgGroup().getId().toString());
        ArrayList<String> tmpIds = new ArrayList<String>();
        for (int i = 0; i < this.elimSolu.getElimTmpEntries().size(); ++i) {
            tmpIds.add(this.elimSolu.getElimTmpEntries().get(i).getElimTmp().getId().toString());
        }
        valueMap.put("elimTmpTypeIds", tmpIds);
        ElimTempletCollection templetCollection = this.iElimination.getCurrentEliminationTemplate(valueMap);
        if (templetCollection == null || templetCollection.size() == 0) {
            return;
        }
        HashMap<String, FullOrgUnitInfo> companyMap = new HashMap<String, FullOrgUnitInfo>();
        FullOrgUnitInfo com = this.cslContest.getCurOrgGroup().castToFullOrgUnitInfo();
        for (int i = 0; i < templetCollection.size(); ++i) {
            ElimTempletEntryCollection entryColl = templetCollection.get(i).getEntries();
            for (int index = 0; index < entryColl.size(); ++index) {
                companyMap.put(entryColl.get(index).getId().toString(), com);
            }
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < templetCollection.size(); ++i) {
            ids.add(templetCollection.get(i).getId().toString());
        }
        valueMap.clear();
        valueMap.put("orgTreeInfo", this.cslContest.getCurOrgBound());
        valueMap.put("fullOrgUnit", (FullOrgUnitInfo)this.cslContest.getCurOrgGroup());
        valueMap.put("sourceCurrency", this.soluExecuteParam.getSoluInfo().getCurrency());
        valueMap.put("currency", this.soluExecuteParam.getSoluInfo().getCurrency());
        valueMap.put("dateBizDate", this.cslContest.getCurReportDate());
        valueMap.put("dateCreateTime", new Date());
        int periodType = this.cslContest.getCurRptPeriodType().getValue();
        int year = this.cslContest.getCurRptYear();
        int period = this.cslContest.getCurRptPeriod();
        valueMap.put("periodType", new Integer(periodType));
        valueMap.put("year", new Integer(year));
        valueMap.put("period", new Integer(period));
        valueMap.put("entryCompanyMap", companyMap);
        valueMap.put("displayType", null);
        EliminationTmpBatchImport batchImport = new EliminationTmpBatchImport();
        ServiceManagerFactory.getServiceManager().disableService("PERMISSION_SERVICE");
        IObjectPK[] ObjectPKs = batchImport.doTemplateBatchImportElimRecords(this.ctx, ids, valueMap, this.soluExecuteParam.getCurUser());
        if (ObjectPKs.length == 0) {
            LOGGER.info((Object)" no create Elimination Record");
            return;
        }
        if (this.isSupportGroup) {
            this.aduitElim(ObjectPKs);
        }
    }

    private void aduitElim(IObjectPK[] ObjectPKs) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(this.soluExecuteParam.getCurUser().getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.item.number"));
        selector.add(new SelectorItemInfo("entries.company.number"));
        selector.add(new SelectorItemInfo("entries.company.name"));
        int n = ObjectPKs.length;
        for (int i = 0; i < n; ++i) {
            EliminationInfo info = this.iElimination.getEliminationInfo(ObjectPKs[i], selector);
            this.iElimination.audit(ObjectPKs[i], info, (IObjectPK)userPK);
        }
    }

    public IRowSet getExistElimData() throws BOSException, EASBizException {
        ElimTypeEntriesCollection typeColl;
        if (this.soluExecuteParam.getElimSolu() == null) {
            return null;
        }
        if (!this.soluExecuteParam.getElimSolu().isIsRelateExistData()) {
            return null;
        }
        String importTreeId = this.soluExecuteParam.getSoluInfo().getOrgBound().getId().toString();
        String sourceTreeId = this.soluExecuteParam.getElimSolu().getOrgBound().getId().toString();
        int period = this.soluExecuteParam.getPeriod();
        int year = this.soluExecuteParam.getYear();
        int periodType = this.soluExecuteParam.getPeriodType();
        String orgUnitId = this.soluExecuteParam.getCurOrgUnit().getId().toString();
        boolean isForBugetBound = this.soluExecuteParam.getElimSolu().getOrgBound().isIsForBudget();
        String elimTypeIds = "";
        if (this.soluExecuteParam.getElimSolu().isIsRelateExistData() && (typeColl = this.soluExecuteParam.getElimSolu().getElimTypeEntries()).size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < typeColl.size(); ++i) {
                String typeId = typeColl.get(i).getElimType().getId().toString();
                sbuf.append("'").append(typeId).append("'").append(",");
            }
            sbuf.deleteCharAt(sbuf.lastIndexOf(","));
            elimTypeIds = sbuf.toString();
        }
        return this.iElimination.getElimRecordBySourceBound(period, year, periodType, sourceTreeId, importTreeId, orgUnitId, isForBugetBound, elimTypeIds);
    }

    private void filterShowImportElimByDirect(EntityViewInfo eliminationImportQuery, Map param, List curCompanyIds) throws EASBizException, BOSException {
        IRowSet rs = this.iElimination.getElimCountByOrgUnit(param);
        ArrayList lastList = new ArrayList();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        this.checkCurCompanyIsContainBasicCompany(rs, lastList, curCompanyIds);
        if (lastList.size() > 0) {
            for (int i = 0; i < lastList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)lastList.get(i).toString(), CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++);
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
            filter.setMaskString(sbFormula.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        }
        eliminationImportQuery.setFilter(filter);
    }

    private void checkCurCompanyIsContainBasicCompany(IRowSet rs, ArrayList lastList, List curCompanyIds) throws BOSException {
        if (rs != null) {
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    EliminationEntryCollection col = this.iEliminationEntry.getEliminationEntryCollection("select company where elimination ='" + id + "'");
                    boolean isContinue = true;
                    if (col != null && col.size() > 0) {
                        for (int i = 0; i < col.size(); ++i) {
                            EliminationEntryInfo elimInfo = col.get(i);
                            if (elimInfo.getCompany() == null) {
                                isContinue = false;
                                break;
                            }
                            String companyId = elimInfo.getCompany().getId().toString();
                            if (curCompanyIds != null && curCompanyIds.size() > 0) {
                                if (!curCompanyIds.contains(companyId)) {
                                    isContinue = false;
                                    break;
                                }
                            } else {
                                isContinue = false;
                                break;
                            }
                            isContinue = true;
                        }
                    } else {
                        isContinue = false;
                    }
                    if (!isContinue) continue;
                    int count = rs.getInt("entryCount");
                    EliminationEntryCollection collect = this.iEliminationEntry.getEliminationEntryCollection("select id where elimination.id = '" + id + "'");
                    if (collect == null || collect.size() <= 0 || collect.size() != count) continue;
                    lastList.add(id);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void filterShowImportElimByOrdinal(EntityViewInfo eliminationImportQuery, Map param, List curCompanyIds, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        boolean isShow;
        ArrayList<String> lastList = new ArrayList<String>();
        if (orgUnitInfo == null) {
            return;
        }
        IRowSet rs = this.iElimination.getAllElimByOrgUnit(param);
        String lastId = null;
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        try {
            if (rs != null) {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    if (curCompanyIds == null || curCompanyIds.size() <= 0 || !curCompanyIds.contains(id)) continue;
                    String longNumber = rs.getString("flongnumber");
                    if (lastId == null) {
                        lastId = id;
                    }
                    if (lastId.equals(id)) {
                        list.add(this.decomposeLongNumber(orgUnitInfo, longNumber));
                        continue;
                    }
                    isShow = this.checkIsCompanyForCurUnit(list);
                    if (isShow) {
                        lastList.add(lastId);
                    }
                    list.clear();
                    list.add(this.decomposeLongNumber(orgUnitInfo, longNumber));
                    lastId = id;
                }
                if (list.size() > 0) {
                    boolean isShow2 = this.checkIsCompanyForCurUnit(list);
                    if (isShow2) {
                        lastList.add(lastId);
                    }
                    list.clear();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        if (lastList.size() > 0) {
            for (int i = 0; i < lastList.size(); ++i) {
                String id = lastList.get(i).toString();
                isShow = this.checkCurCompanyIsContainBasicCompanyForShunXu(id, curCompanyIds);
                if (!isShow) continue;
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++);
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
            filter.setMaskString(sbFormula.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        }
        eliminationImportQuery.setFilter(filter);
    }

    private ArrayList decomposeLongNumber(OrgUnitInfo orgUnitInfo, String longNumber) {
        String topclassLongNumber = orgUnitInfo.getLongNumber();
        int leng = topclassLongNumber.length();
        String lastPart = longNumber.substring(leng, longNumber.length() - 1);
        longNumber = "@@" + lastPart;
        ArrayList<String> list = new ArrayList<String>(10);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < longNumber.length(); ++i) {
            if (longNumber.charAt(i) == '!') {
                list.add(s.toString());
                s.delete(0, s.length());
                continue;
            }
            s.append(longNumber.charAt(i));
        }
        if (s.length() > 0) {
            list.add(s.toString());
        }
        s.delete(0, s.length());
        return list;
    }

    private boolean checkIsCompanyForCurUnit(ArrayList list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean j = false;
        for (int i = 0; i < list.size(); ++i) {
            int size0;
            int size1 = ((ArrayList)list.get(i)).size();
            if (size1 >= (size0 = ((ArrayList)list.get(0)).size())) continue;
            Object temp = list.get(i);
            Object b = list.get(0);
            list.set(0, temp);
            list.set(i, b);
        }
        boolean isShow = true;
        ArrayList listLeastSize = (ArrayList)list.get(0);
        if (listLeastSize.size() == 1) {
            return false;
        }
        for (int w = listLeastSize.size() - 2; w >= 0; --w) {
            String node = listLeastSize.get(w).toString();
            int temp = 0;
            for (int k = list.size() - 1; k >= 1; --k) {
                ArrayList listOther = (ArrayList)list.get(k);
                String nodeOther = listOther.get(w).toString();
                if (w != 0 && !node.equals(nodeOther)) continue;
                if (w != 0 && node.equals(nodeOther)) {
                    ++temp;
                    continue;
                }
                if (w == 0 && !node.equals(nodeOther)) {
                    isShow = false;
                    break;
                }
                if (w != 0 || !node.equals(nodeOther)) continue;
                isShow = true;
                break;
            }
            if (temp == list.size() - 1) {
                isShow = false;
                break;
            }
            if (!isShow) break;
        }
        return isShow;
    }

    private boolean checkCurCompanyIsContainBasicCompanyForShunXu(String id, List curCompanyIds) throws BOSException {
        EliminationEntryCollection col = this.iEliminationEntry.getEliminationEntryCollection("select company where elimination ='" + id + "'");
        boolean isContinue = true;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                EliminationEntryInfo elimInfo = col.get(i);
                String companyId = elimInfo.getCompany().getId().toString();
                if (curCompanyIds != null && curCompanyIds.size() > 0) {
                    if (!curCompanyIds.contains(companyId)) {
                        isContinue = false;
                        break;
                    }
                } else {
                    isContinue = false;
                    break;
                }
                isContinue = true;
            }
        } else {
            isContinue = false;
        }
        return isContinue;
    }

    private boolean checkCurOrgUnitIsContainBasicCompanyForShunXu(OrgTreeInfo orgTreeInfo, OrgUnitInfo orgUnitInfo, List curCompanyIds, String id) throws BOSException {
        EliminationEntryCollection col = this.iEliminationEntry.getEliminationEntryCollection("select company where elimination ='" + id + "'");
        HashSet<String> idlist = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            EliminationEntryInfo elimInfo = col.get(i);
            if (elimInfo.getCompany() == null) {
                return false;
            }
            String companyId = elimInfo.getCompany().getId().toString();
            if (curCompanyIds != null && curCompanyIds.size() > 0 && !curCompanyIds.contains(companyId)) {
                return false;
            }
            idlist.add(companyId);
        }
        EntityViewInfo viewCompanyOrgUnit = new EntityViewInfo();
        SelectorItemCollection sicOrgRange = viewCompanyOrgUnit.getSelector();
        sicOrgRange.add(new SelectorItemInfo("longnumber"));
        FilterInfo filterCompanyOrgUnit = new FilterInfo();
        if (idlist.size() <= 0) {
            return false;
        }
        filterCompanyOrgUnit.getFilterItems().add(new FilterItemInfo("unit.id", idlist, CompareType.INCLUDE));
        filterCompanyOrgUnit.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeInfo.getId().toString()));
        viewCompanyOrgUnit.setFilter(filterCompanyOrgUnit);
        OrgStructureCollection coll = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection(viewCompanyOrgUnit);
        ArrayList<String> longnumberlist = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            longnumberlist.add(coll.get(i).getLongNumber());
        }
        String getgeneral = this.getGeneralString(longnumberlist);
        if (!getgeneral.equals("")) {
            if (orgUnitInfo != null) {
                return orgUnitInfo.getLongNumber().equals(getgeneral);
            }
            return false;
        }
        return false;
    }

    private String getGeneralString(List list) {
        if (list.size() > 0) {
            String number2 = (String)list.get(0);
            String[] num2 = null;
            if (number2 != null && !number2.equals("")) {
                num2 = number2.split("!");
                StringBuffer st = new StringBuffer();
                String ret = null;
                st.append(num2[0]);
                ret = st.toString();
                for (int i = 1; i < num2.length; ++i) {
                    if (i == 1) {
                        ret = st.toString();
                        st.append("!");
                    }
                    st.append(num2[i]);
                    for (int j = 0; j < list.size(); ++j) {
                        String longnumber = (String)list.get(j);
                        if (longnumber.startsWith(st.toString())) continue;
                        return ret;
                    }
                    ret = st.toString();
                    if (i + 1 >= num2.length) continue;
                    st.append("!");
                }
                if (ret.equals(number2)) {
                    ret.lastIndexOf("!");
                    ret = ret.substring(0, ret.lastIndexOf("!"));
                }
                return ret;
            }
            return "";
        }
        return "";
    }

    private String getCurrentMaxNumber(Context ctx, String orgTreeId, int periodType, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Replace(fnumber,'AUTO_','') As Fnumber From \r\n");
        sbSQL.append(tableName).append(" a  \r\n");
        sbSQL.append("  WHERE a.fOrgBoundId = '").append(orgTreeId).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fperiodType = ").append(periodType).append(" \r\n");
        sbSQL.append("  and a.fNumber like 'AUTO\\_%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            String tempNumber = "";
            BigDecimal curNumber = null;
            while (rs.next()) {
                tempNumber = rs.getString("Fnumber");
                if (StringUtils.isEmpty((String)tempNumber) || !tempNumber.matches("[0-9]{" + tempNumber.length() + "}") || number.compareTo(curNumber = new BigDecimal(tempNumber)) >= 0) continue;
                number = curNumber;
            }
            if (number != null) {
                number = number.add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        StringBuffer ret = new StringBuffer("AUTO_");
        int n = 8 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }
}

