/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemBusinessFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.IRpcHandleFacade;
import com.kingdee.eas.fi.gr.cslrpt.ISumSchm;
import com.kingdee.eas.fi.gr.cslrpt.NeedSelectorForFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SingleDataUpdateWayEnum;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.AdjustEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.SolutionExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.AdjustSoluExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoCslRptExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoMnsRptExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoSumSoluExecute;
import com.kingdee.eas.fi.gr.fast.biz.ElimSoluExecute;
import com.kingdee.eas.fi.gr.fast.biz.ISoluExecute;
import com.kingdee.eas.fi.gr.fast.log.AutoMergeLog;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class FastMergeSoluExecute
implements ISoluExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.fast.biz.FastMergeSoluExecute");
    private Context _ctx;
    private SolutionExecuteParam _executeParam;
    private AutoMergeLog autoMergeLog;
    private int rate = 0;
    private BigDecimal curRate = null;
    private DynaSumMethodEnum defaultDySumMethod = DynaSumMethodEnum.SUM_BY_NAME;
    private int threadCount = -1;
    public LinkedBlockingQueue<MultiThreadParams> queue = null;
    public AtomicInteger atomic = new AtomicInteger(0);
    public AtomicInteger atomicHandleThread = new AtomicInteger(0);
    public boolean isCreateThread = false;
    public boolean isContinue = true;
    public int execLevel = -1;

    public FastMergeSoluExecute(Context ctx, SolutionExecuteParam executeParam) {
        this._ctx = ctx;
        this._executeParam = executeParam;
        this.autoMergeLog = new AutoMergeLog(this._ctx, this._executeParam.getSoluInfo().getId().toString(), this._executeParam.getExecuteTaskId(), this._executeParam.getYear(), this._executeParam.getPeriod());
        Object[] dynaSumMethods = CSLParamUtil.getDynaSumMethod(this._ctx);
        if (dynaSumMethods != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
            this.defaultDySumMethod = (DynaSumMethodEnum)((Object)dynaSumMethods[0]);
        }
    }

    @Override
    public void execute() throws BOSException, EASBizException {
        this.autoMergeLog.start();
        try {
            this.initAdjustAndElimData();
            this.rate += 5;
            this.autoMergeLog.processing(this.rate);
        }
        catch (Exception e) {
            logger.error((Object)"initAdjustAndElimData", (Throwable)e);
            this.autoMergeLog.end();
            this.clear();
        }
        try {
            this.autoItemSoluExec();
            this.rate += 45;
            this.autoMergeLog.processing(this.rate);
        }
        catch (Exception e) {
            logger.error((Object)"autoItemSoluExec", (Throwable)e);
            this.autoMergeLog.end();
        }
        try {
            this.soluExec();
        }
        catch (Exception e) {
            logger.error((Object)"soluExec", (Throwable)e);
        }
        finally {
            this.autoMergeLog.end();
            this.clear();
        }
    }

    private void soluExec() throws Exception {
        if (this._executeParam.getSoluInfo().isIsAutoSum()) {
            this.sumSoluExec();
        }
        if (!this._executeParam.getSoluInfo().isIsAutoSum()) {
            this.cslSoluExec();
        }
    }

    private void initAdjustAndElimData() throws BOSException, EASBizException {
        FastMergeUtil.initSoluAdjustAndElimData(this._ctx, this._executeParam.getSoluInfo());
    }

    private void autoItemSoluExec() throws BOSException, EASBizException {
        FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
        FormulaCalcContextInfo calcContext = soluInfo.getAutoItemFormual();
        if (calcContext == null || calcContext.getId() == null) {
            return;
        }
        BOSUuid uuid = calcContext.getId();
        SelectorItemCollection needSelector = ActionFactory.get(NeedSelectorForFormulaCalcContext.class).exec();
        IFormulaCalcContext formulaCalcContextDao = new DBHandler(this._ctx).get(IFormulaCalcContext.class);
        if (!formulaCalcContextDao.exists((IObjectPK)new ObjectUuidPK(uuid.toString()))) {
            return;
        }
        FormulaCalcContextInfo calcContextInfo = formulaCalcContextDao.getFormulaCalcContextInfo((IObjectPK)new ObjectUuidPK(uuid.toString()), needSelector);
        calcContextInfo.setOffYear(this._executeParam.getYear());
        calcContextInfo.setOffPeriod(this._executeParam.getPeriod());
        calcContextInfo.setExePeriod(this._executeParam.getPeriod());
        calcContextInfo.setExeYear(this._executeParam.getYear());
        calcContextInfo.setCurrentCurrency(this._executeParam.getSoluInfo().getCurrency());
        calcContextInfo.setDataUpdateType(SingleDataUpdateWayEnum.RECAL);
        calcContextInfo.setDispatchCurrency(this._executeParam.getSoluInfo().getCurrency());
        String executeTaskId = this._executeParam.getExecuteTaskId();
        AutoItemBusinessFacadeFactory.getLocalInstance(this._ctx).calculate(calcContextInfo, executeTaskId);
    }

    private boolean adjustSoluExec(FullOrgUnitInfo orgUnit) throws Exception {
        if (this._executeParam.getAdjustSolu() != null) {
            try {
                FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
                AdjustEntiresSoluInfo adjustSolu = soluInfo.getAdjustEntrySolu();
                if (adjustSolu == null || adjustSolu.getId() == null) {
                    return true;
                }
                AdjustSoluExecute soluExec = new AdjustSoluExecute(this._executeParam, this._ctx, orgUnit);
                soluExec.execute();
                this.autoMergeLog.adaptEntry(orgUnit.getId().toString(), "", "", true);
            }
            catch (PermissionServiceException e) {
                logger.error((Object)"adjustSoluExec", (Throwable)e);
                this.autoMergeLog.adaptEntry(orgUnit.getId().toString(), "", e.getMessage(), false);
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"adjustSoluExec", (Throwable)e);
                this.autoMergeLog.adaptEntry(orgUnit.getId().toString(), "", FastMergeUtil.getStringRes("fail.system.error", this._ctx.getOriginLocale()) + ":" + e.getMessage(), false);
                return false;
            }
        }
        return true;
    }

    private boolean elimSoluExec(String orgUnitId) throws Exception {
        if (this._executeParam.getElimSolu() != null) {
            try {
                FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
                EliminationEntiresSoluInfo elimSolu = soluInfo.getElimEntrySolu();
                if (elimSolu == null || elimSolu.getId() == null || soluInfo.isIsAutoSum()) {
                    return true;
                }
                ElimSoluExecute soluExec = new ElimSoluExecute(this._executeParam, this._ctx);
                soluExec.execute();
                this.autoMergeLog.elimEntry(orgUnitId, "", true);
            }
            catch (PermissionServiceException e) {
                logger.error((Object)"elimSoluExec", (Throwable)e);
                this.autoMergeLog.elimEntry(orgUnitId, e.getMessage(), false);
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"elimSoluExec", (Throwable)e);
                this.autoMergeLog.elimEntry(orgUnitId, FastMergeUtil.getStringRes("fail.system.error", this._ctx.getLocale()) + ":" + e.getMessage(), false);
                return false;
            }
        }
        return true;
    }

    public synchronized void setUnContinue() {
        this.isContinue = false;
    }

    public synchronized void setExecLevel(int execLevel) {
        this.execLevel = execLevel;
    }

    public void multiThreadSumSoluExecByTemplate(FastMergeOrgUnitInfo fastOrgUnit, OrgUnitCollection unitsDyna, OrgUnitCollection unitsFixed, SumSchmInfo schmInfo, String tempId, boolean isSupportGroupReport, int orgUnitIndex, BigDecimal curRate, boolean isHasOrgUnit) throws Exception {
        if (this.threadCount > 1) {
            if (!this.isCreateThread) {
                for (int i = 0; i < this.threadCount; ++i) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                while (!FastMergeSoluExecute.this.queue.isEmpty() || FastMergeSoluExecute.this.atomic.get() > 0) {
                                    MultiThreadParams params;
                                    if (!FastMergeSoluExecute.this.queue.isEmpty() && (params = FastMergeSoluExecute.this.queue.poll()) != null) {
                                        try {
                                            FastMergeSoluExecute.this.setExecLevel(params.fastOrgUnit.getOrgUnit().getLevel());
                                            FastMergeSoluExecute.this.atomicHandleThread.incrementAndGet();
                                            boolean isCurContinue = FastMergeSoluExecute.this.sumSoluExecByTemplateByInvoke(FastMergeSoluExecute.this.getExecute(), params.fastOrgUnit, params.unitsDyna, params.unitsFixed, params.schmInfo, params.tempId, params.isSupportGroupReport, params.orgUnitIndex, params.curRate, params.isHasOrgUnit);
                                            if (!isCurContinue) {
                                                FastMergeSoluExecute.this.setUnContinue();
                                                FastMergeSoluExecute.this.queue.clear();
                                                FastMergeSoluExecute.this.atomic.decrementAndGet();
                                            }
                                        }
                                        finally {
                                            FastMergeSoluExecute.this.atomicHandleThread.decrementAndGet();
                                        }
                                    }
                                    if (!FastMergeSoluExecute.this.queue.isEmpty() || FastMergeSoluExecute.this.atomic.get() <= 0) continue;
                                    1.sleep(50L);
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"", (Throwable)ex);
                                FastMergeSoluExecute.this.queue.clear();
                            }
                        }
                    };
                    thread.start();
                }
                this.isCreateThread = true;
            }
            MultiThreadParams params = new MultiThreadParams();
            params.fastOrgUnit = fastOrgUnit;
            params.unitsDyna = unitsDyna;
            params.unitsFixed = unitsFixed;
            params.schmInfo = schmInfo;
            params.tempId = tempId;
            params.isSupportGroupReport = isSupportGroupReport;
            params.orgUnitIndex = orgUnitIndex;
            params.isHasOrgUnit = isHasOrgUnit;
            params.curRate = curRate;
            this.queue.add(params);
        } else {
            this.isContinue = this.sumSoluExecByTemplate(fastOrgUnit, unitsDyna, unitsFixed, schmInfo, tempId, isSupportGroupReport, orgUnitIndex, curRate, isHasOrgUnit);
        }
    }

    public FastMergeSoluExecute getExecute() {
        return this;
    }

    public boolean sumSoluExecByTemplateByInvoke(FastMergeSoluExecute execute, FastMergeOrgUnitInfo fastOrgUnit, OrgUnitCollection unitsDyna, OrgUnitCollection unitsFixed, SumSchmInfo schmInfo, String tempId, boolean isSupportGroupReport, int orgUnitIndex, BigDecimal curRate, boolean isHasOrgUnit) throws Exception {
        this.isContinue = (Boolean)CslRptUtil.invokeByManual(execute, "sumSoluExecByTemplate", new Class[]{FastMergeOrgUnitInfo.class, OrgUnitCollection.class, OrgUnitCollection.class, SumSchmInfo.class, String.class, Boolean.TYPE, Integer.TYPE, BigDecimal.class, Boolean.TYPE}, new Object[]{fastOrgUnit, unitsDyna, unitsFixed, schmInfo, tempId, isSupportGroupReport, orgUnitIndex, curRate, isHasOrgUnit}, 3);
        return this.isContinue;
    }

    public boolean sumSoluExecByTemplate(FastMergeOrgUnitInfo fastOrgUnit, OrgUnitCollection unitsDyna, OrgUnitCollection unitsFixed, SumSchmInfo schmInfo, String tempId, boolean isSupportGroupReport, int orgUnitIndex, BigDecimal curRate, boolean isHasOrgUnit) throws Exception {
        this.autoMergeLog.processing(this.rate + curRate.multiply(new BigDecimal(orgUnitIndex)).intValue());
        String orgUnitId = fastOrgUnit.getOrgUnit().getId().toString();
        FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
        String orgBound = soluInfo.getOrgBound().getId().toString();
        if (!isHasOrgUnit) {
            this.autoMergeLog.sumReport(orgUnitId, tempId, FastMergeUtil.getStringRes("fastmerge.check.orgUnit", this._ctx.getLocale()), false);
            return !isSupportGroupReport;
        }
        try {
            OrgUnitCollection needSumUnits = null;
            TemplateInfo tempInfo = FastMergeUtil.getLastestTemplate(this._ctx, orgBound, orgUnitId, tempId);
            needSumUnits = tempInfo.getDynaRptType() == DynaEnumRptTypeEnum.DYNAMIC ? unitsDyna : unitsFixed;
            if (needSumUnits == null || needSumUnits.size() == 0) {
                logger.error((Object)("get " + orgUnitId + " child org is null."));
                return true;
            }
            if (tempInfo.getTemplateType() == RptTmpTypeEnum.SUMREPORT || tempInfo.getTemplateType() == RptTmpTypeEnum.DYNAMICSUMREPORT) {
                AutoSumSoluExecute sunSolu = new AutoSumSoluExecute(this._ctx, this._executeParam, tempInfo, needSumUnits, schmInfo, fastOrgUnit.getOrgUnit(), this.defaultDySumMethod);
                sunSolu.execute();
            }
            this.autoMergeLog.sumReport(orgUnitId, tempId, "", true);
        }
        catch (PermissionServiceException e) {
            logger.error((Object)"sumSoluExec", (Throwable)e);
            this.autoMergeLog.sumReport(orgUnitId, tempId, e.getMessage(), false);
            return !isSupportGroupReport;
        }
        catch (RptWeaveException e) {
            logger.error((Object)"sumSoluExec", (Throwable)((Object)e));
            this.autoMergeLog.sumReport(orgUnitId, tempId, e.getMessage(), false);
            return !isSupportGroupReport;
        }
        catch (Exception e) {
            logger.error((Object)"sumSoluExec", (Throwable)e);
            this.autoMergeLog.sumReport(orgUnitId, tempId, FastMergeUtil.getStringRes("fail.system.error", this._ctx.getLocale()) + ":" + e.getMessage(), false);
            return !isSupportGroupReport;
        }
        return true;
    }

    public boolean sumSoluExecByOrgUnit(FastMergeOrgUnitInfo fastOrgUnit, int orgUnitIndex, BigDecimal curRate) throws Exception {
        FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
        FastMergeTemplateCollection tempateEnties = soluInfo.getTemplates();
        OrgStructureCollection strucColl = null;
        ISumSchm SumSchm2 = SumSchmFactory.getLocalInstance(this._ctx);
        OrgUnitCollection unitsDyna = new OrgUnitCollection();
        OrgUnitCollection unitsFixed = new OrgUnitCollection();
        boolean isSupportGroupReport = false;
        if (this._executeParam.getCreateRptStrategy() == 1) {
            isSupportGroupReport = true;
        }
        FullOrgUnitInfo unitInfo = fastOrgUnit.getOrgUnit();
        String orgUnitId = unitInfo.getId().toString();
        if (!this.adjustSoluExec(unitInfo)) {
            return !isSupportGroupReport;
        }
        SumSchmInfo schmInfo = null;
        try {
            if (!StringUtils.isEmpty((String)fastOrgUnit.getFixedCalcSolu())) {
                Set<String> numberSetFixedSolu = FastMergeUtil.getSoluOrgUnit(this._ctx, fastOrgUnit.getFixedCalcSolu());
                schmInfo = SumSchm2.getSumSchmInfo((IObjectPK)new ObjectUuidPK(fastOrgUnit.getFixedCalcSolu()));
                if (!isSupportGroupReport) {
                    strucColl = FastMergeUtil.getOrgStructureColl(this._ctx, soluInfo.getOrgBound().getId().toString(), numberSetFixedSolu);
                }
                unitsFixed = FastMergeUtil.getOrgUnitsIntersectSet(this._ctx, soluInfo.getOrgBound(), (OrgUnitInfo)unitInfo, this._executeParam.isSupportCrossMerger(), numberSetFixedSolu, strucColl, isSupportGroupReport, this._executeParam.getSoluBoundMergeMode().getValue());
            } else {
                unitsFixed = FastMergeUtil.getOrgUnitsIntersectSet(this._ctx, soluInfo.getOrgBound(), (OrgUnitInfo)unitInfo, this._executeParam.isSupportCrossMerger(), null, null, isSupportGroupReport, this._executeParam.getSoluBoundMergeMode().getValue());
            }
            if (!StringUtils.isEmpty((String)fastOrgUnit.getDynaCalcSolu())) {
                Set<String> numberSetDynaSolu = FastMergeUtil.getSoluOrgUnit(this._ctx, fastOrgUnit.getDynaCalcSolu());
                schmInfo = SumSchm2.getSumSchmInfo((IObjectPK)new ObjectUuidPK(fastOrgUnit.getDynaCalcSolu()));
                if (!isSupportGroupReport) {
                    strucColl = FastMergeUtil.getOrgStructureColl(this._ctx, soluInfo.getOrgBound().getId().toString(), numberSetDynaSolu);
                }
                unitsDyna = FastMergeUtil.getOrgUnitsIntersectSet(this._ctx, soluInfo.getOrgBound(), (OrgUnitInfo)unitInfo, this._executeParam.isSupportCrossMerger(), numberSetDynaSolu, strucColl, isSupportGroupReport, this._executeParam.getSoluBoundMergeMode().getValue());
            } else {
                unitsDyna = FastMergeUtil.getOrgUnitsIntersectSet(this._ctx, soluInfo.getOrgBound(), (OrgUnitInfo)unitInfo, this._executeParam.isSupportCrossMerger(), null, null, isSupportGroupReport, this._executeParam.getSoluBoundMergeMode().getValue());
            }
        }
        catch (PermissionServiceException e) {
            logger.error((Object)"sumSoluExec", (Throwable)e);
            this.autoMergeLog.sumReport(orgUnitId, "", e.getMessage(), false);
            return !isSupportGroupReport;
        }
        catch (Exception e) {
            logger.error((Object)"sumSoluExec", (Throwable)e);
            this.autoMergeLog.sumReport(orgUnitId, "", FastMergeUtil.getStringRes("fail.system.error", this._ctx.getLocale()) + ":" + e.getMessage(), false);
            return !isSupportGroupReport;
        }
        String orgBound = soluInfo.getOrgBound().getId().toString();
        String userId = this._executeParam.getCurUser().getId().toString();
        boolean isHasOrgUnit = FastMergeUtil.checkHasOrgUnit(this._ctx, userId, orgBound, orgUnitId);
        for (int j = 0; j < tempateEnties.size(); ++j) {
            String tempId = tempateEnties.get(j).getTemplate().getId().toString();
            if (!this.isContinue) {
                return false;
            }
            this.multiThreadSumSoluExecByTemplate(fastOrgUnit, unitsDyna, unitsFixed, schmInfo, tempId, isSupportGroupReport, orgUnitIndex, curRate, isHasOrgUnit);
        }
        return this.isContinue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sumSoluExec() throws Exception {
        try {
            FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
            if (!soluInfo.isIsAutoSum()) {
                return;
            }
            boolean isSupportGroupReport = false;
            if (this._executeParam.getCreateRptStrategy() == 1) {
                isSupportGroupReport = true;
            }
            this.initThreadCount(isSupportGroupReport);
            FastMergeOrgUnitCollection orgUnitColl = soluInfo.getOrgUnits();
            orgUnitColl = FastMergeUtil.sortOrgUnitColl(orgUnitColl);
            BigDecimal curRate = new BigDecimal(100 - this.rate - 5).divide(new BigDecimal(orgUnitColl.size()), 2, 4);
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                boolean isContinue = this.sumSoluExecByOrgUnit(orgUnitColl.get(i), i, curRate);
                if (!isContinue) {
                    return;
                }
                if (this.threadCount > 1) {
                    Thread.sleep(5L);
                }
                while (!(this.threadCount <= 1 || this.queue.isEmpty() && this.atomicHandleThread.get() <= 0)) {
                    Thread.sleep(50L);
                }
            }
        }
        finally {
            if (this.threadCount > 1) {
                this.atomic.decrementAndGet();
                while (this.queue.size() > 0) {
                    Thread.sleep(50L);
                }
            }
        }
    }

    private void initThreadCount(boolean isSupportGroupReport) {
        this.isCreateThread = false;
        this.isContinue = true;
        if (this.threadCount <= 0) {
            try {
                String threadStr = CSLParamUtil.getStringCslParamValue(this._ctx, "GR_CSL_FASTMERGESUMEXEC_THREADCOUNT");
                this.threadCount = !StringUtils.isEmpty((String)threadStr) ? Integer.valueOf(threadStr.trim()) : 3;
                if (this.threadCount > 10) {
                    this.threadCount = 10;
                }
                if (this.threadCount > 1) {
                    this.queue = new LinkedBlockingQueue();
                    this.atomic.incrementAndGet();
                    this.autoMergeLog.createThread();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
    }

    private void cslSoluExec() throws Exception {
        FastMergeSoluInfo soluInfo = this._executeParam.getSoluInfo();
        if (soluInfo.isIsAutoSum()) {
            return;
        }
        FastMergeOrgUnitCollection orgUnitColl = soluInfo.getOrgUnits();
        orgUnitColl = FastMergeUtil.sortOrgUnitColl(orgUnitColl);
        FastMergeTemplateCollection tempateEnties = soluInfo.getTemplates();
        tempateEnties = FastMergeUtil.sortTempateEnties(tempateEnties);
        boolean isSupportGroupReport = this._executeParam.getCreateRptStrategy() == 1;
        this.curRate = new BigDecimal(100 - this.rate - 5).divide(new BigDecimal(orgUnitColl.size()), 2, 4);
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            FullOrgUnitInfo unitInfo = orgUnitColl.get(i).getOrgUnit();
            String orgUnitId = unitInfo.getId().toString();
            this._executeParam.setCurOrgUnit(unitInfo);
            if (!(!this.adjustSoluExec(unitInfo) ? isSupportGroupReport : (!this.elimSoluExec(orgUnitId) ? isSupportGroupReport : !this.cslRptExecute(soluInfo, tempateEnties, orgUnitColl, i) && isSupportGroupReport))) continue;
            return;
        }
    }

    private boolean cslRptExecute(FastMergeSoluInfo soluInfo, FastMergeTemplateCollection tempateEnties, FastMergeOrgUnitCollection orgUnitColl, int orgUnitIndex) throws Exception {
        ISoluExecute soluExecute = null;
        IRpcHandleFacade rpcHand = RpcHandleFacadeFactory.getLocalInstance(this._ctx);
        FastMergeOrgUnitInfo fastMergeOrgUnitInfo = orgUnitColl.get(orgUnitIndex);
        CslRptQuerySoluInfo querySoluInfoFixedExclude = null;
        CslRptQuerySoluInfo querySoluInfo = null;
        String orgBound = soluInfo.getOrgBound().getId().toString();
        String orgUnitId = fastMergeOrgUnitInfo.getOrgUnit().getId().toString();
        if (!StringUtils.isEmpty((String)fastMergeOrgUnitInfo.getFixedCalcSolu())) {
            querySoluInfo = FastMergeUtil.getCslQuerySoluInfo(this._ctx, fastMergeOrgUnitInfo.getFixedCalcSolu(), soluInfo.getOrgBound(), this._executeParam.getReportDate());
        }
        if (querySoluInfo == null) {
            querySoluInfo = FastMergeUtil.getCslDefaultQuerySoluInfo(soluInfo, rpcHand, orgUnitId, this.defaultDySumMethod);
        }
        if (querySoluInfo.getOrgUnitCollection() == null || querySoluInfo.getOrgUnitCollection().size() == 0) {
            return true;
        }
        TemplateInfo tempInfo = null;
        for (int j = 0; j < tempateEnties.size(); ++j) {
            this.autoMergeLog.processing(this.rate + this.curRate.multiply(new BigDecimal(orgUnitIndex)).intValue());
            String tempId = tempateEnties.get(j).getTemplate().getId().toString();
            String userId = this._executeParam.getCurUser().getId().toString();
            if (!FastMergeUtil.checkHasOrgUnit(this._ctx, userId, orgBound, orgUnitId)) {
                this.autoMergeLog.cslReport(orgUnitId, tempId, FastMergeUtil.getStringRes("fastmerge.check.orgUnit", this._ctx.getLocale()), false);
                return false;
            }
            try {
                tempInfo = FastMergeUtil.getLastestTemplate(this._ctx, orgBound, orgUnitId, tempId);
                if (tempInfo.getTemplateType() == RptTmpTypeEnum.MANUSCRIPT) {
                    soluExecute = new AutoMnsRptExecute(this._ctx, this._executeParam, tempInfo, querySoluInfo, querySoluInfoFixedExclude);
                    soluExecute.execute();
                } else if (tempInfo.getTemplateType() == RptTmpTypeEnum.CSLREPORT || tempInfo.getTemplateType() == RptTmpTypeEnum.DYNAMICCSLREPORT) {
                    soluExecute = new AutoCslRptExecute(this._ctx, this._executeParam, tempInfo, querySoluInfo, this.defaultDySumMethod);
                    soluExecute.execute();
                }
                this.autoMergeLog.cslReport(orgUnitId, tempId, "", true);
                continue;
            }
            catch (PermissionServiceException e) {
                logger.error((Object)"cslSoluExec", (Throwable)e);
                this.autoMergeLog.cslReport(orgUnitId, tempId, e.getMessage(), false);
                return false;
            }
            catch (RptWeaveException e) {
                logger.error((Object)"cslSoluExec", (Throwable)((Object)e));
                this.autoMergeLog.cslReport(orgUnitId, tempId, e.getMessage(), false);
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"cslSoluExec", (Throwable)e);
                this.autoMergeLog.cslReport(orgUnitId, tempId, FastMergeUtil.getStringRes("fail.system.error", this._ctx.getLocale()) + ":" + e.getMessage(), false);
                return false;
            }
        }
        return true;
    }

    private void clear() {
        this._executeParam = null;
    }

    public class MultiThreadParams {
        public FastMergeOrgUnitInfo fastOrgUnit;
        public OrgUnitCollection unitsDyna;
        public OrgUnitCollection unitsFixed;
        public SumSchmInfo schmInfo;
        public String tempId;
        public boolean isSupportGroupReport;
        public int orgUnitIndex;
        public boolean isHasOrgUnit;
        public BigDecimal curRate;
    }
}

