/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.IRpcHandleFacade;
import com.kingdee.eas.fi.gr.cslrpt.ISumSchm;
import com.kingdee.eas.fi.gr.cslrpt.ISumSchmEntry;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumSchmFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.fast.AdjustEntiresSoluFactory;
import com.kingdee.eas.fi.gr.fast.AdjustEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.AdjustTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.AdjustTypeEntriesInfo;
import com.kingdee.eas.fi.gr.fast.AutoMergeLogCollection;
import com.kingdee.eas.fi.gr.fast.AutoMergeLogFactory;
import com.kingdee.eas.fi.gr.fast.ElimTypeEntriesCollection;
import com.kingdee.eas.fi.gr.fast.ElimTypeEntriesInfo;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluFactory;
import com.kingdee.eas.fi.gr.fast.EliminationEntiresSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeExecSelector;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluFactory;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.IAutoMergeLog;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.util.ManageMergeOrgUnit;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.app.ReportStatusHandle;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FastMergeUtil {
    public static String isExecutPermissionKey = "isExecutPermissionKey";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.fast.util.FastMergeUtil");

    public static EntityViewInfo getCopyHisDataDefaultSolu(Context ctx, OrgTreeInfo orgTree, int[] yearPeroid, int rptPeriodType, boolean isDisplayAdjustRPTMByOrg, Set<String> orgIds, int mergeMode, OrgUnitInfo uif, boolean isSupportOtherDS) throws BOSException {
        return FastMergeUtil.getCopyHisDataDefaultSolu(ctx, orgTree, yearPeroid, rptPeriodType, isDisplayAdjustRPTMByOrg, orgIds, mergeMode, uif, isSupportOtherDS, false);
    }

    public static EntityViewInfo getCopyHisDataDefaultSolu(Context ctx, OrgTreeInfo orgTree, int[] yearPeroid, int rptPeriodType, boolean isDisplayAdjustRPTMByOrg, Set<String> orgs, int mergeMode, OrgUnitInfo uif, boolean isSupportOtherDS, boolean orgIsByNumber) throws BOSException {
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.number", (Object)orgTree.getNumber(), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)rptPeriodType, CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(yearPeroid[0]), CompareType.EQUALS);
        FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(yearPeroid[1]), CompareType.EQUALS);
        FilterItemInfo filterItem4 = new FilterItemInfo("isCitedByLater", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem3);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem4);
        sbFormula.append(" and #" + formulaIndex++);
        if (isDisplayAdjustRPTMByOrg) {
            String orgfilterField = "orgUnit.id";
            if (orgIsByNumber) {
                orgfilterField = "orgUnit.number";
            }
            FilterItemInfo filterItem5 = new FilterItemInfo(orgfilterField, orgs, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItem5);
            sbFormula.append(" and #" + formulaIndex++);
        }
        String number = CslRptUtil.getCompanyStructureNumber(ctx, orgTree, uif);
        filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS));
        if (1 == mergeMode) {
            filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%!%"), CompareType.NOTLIKE));
            sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ")  and #" + formulaIndex++);
        } else {
            sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
        }
        filterInfo.setMaskString(sbFormula.toString());
        FastMergeUtil.addDataCollectFilterItems(filterInfo, isSupportOtherDS);
        evi.setFilter(filterInfo);
        evi.getSorter().add(new SorterItemInfo("number"));
        return evi;
    }

    public static void addDataCollectFilterItems(FilterInfo filterInfo, boolean isSupportOtherDS) throws BOSException {
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        StringBuffer maskString = filterInfo.getMaskString() == null ? new StringBuffer() : new StringBuffer(filterInfo.getMaskString());
        try {
            if (isSupportOtherDS) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                boolean hasBgPermission = CSLPermissionUtil.hasDataCollectPermission(null, userId, DataCollectConstant.getBudgetDC(), isSupportOtherDS);
                boolean hasAcPermission = CSLPermissionUtil.hasDataCollectPermission(null, userId, DataCollectConstant.getActualDC(), isSupportOtherDS);
                if (!hasBgPermission) {
                    FilterItemInfo filterItem6 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItem6);
                    maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
                }
                if (!hasAcPermission) {
                    FilterItemInfo filterItem8 = new FilterItemInfo("dataCollect.number", (Object)"BUDGETDATA", CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItem8);
                    maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
                }
            } else {
                FilterItemInfo filterItem7 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem7);
                maskString.append(" and #" + (filterInfo.getFilterItems().size() - 1));
            }
            filterInfo.setMaskString(maskString.toString());
        }
        catch (BOSException e) {
            throw new BOSException();
        }
        catch (EASBizException e) {
            throw new BOSException();
        }
    }

    public static int[] getPrePeriod(Context ctx, boolean isMergeByFiscalPeriod, OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodType) throws BOSException, EASBizException {
        int[] yearAndPeriod;
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        if ((yearAndPeriod = FiscalPeriodHelper.getPrevYearAndPeriod(periods, year, period, periodType, isMergeByFiscalPeriod, CslRptUtil.isSupport13Period(ctx), false)) != null && yearAndPeriod.length == 2) {
            return yearAndPeriod;
        }
        return new int[]{year, period};
    }

    public static int[] getYearAndPeriodByOffPeriod(Context ctx, boolean isMergeByFiscalPeriod, OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodType, int periodOff) throws BOSException, EASBizException {
        int[] yearAndPeriod;
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
        }
        if ((yearAndPeriod = FiscalPeriodHelper.getRptFormualYearAndPeriod(periods, year, period, periodType.getValue(), 0, periodOff, isMergeByFiscalPeriod, false)) != null && yearAndPeriod.length == 2) {
            return yearAndPeriod;
        }
        return new int[]{year, period};
    }

    public static FullOrgUnitCollection getUnionDebtAllOrgUnits(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)parentOrg;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        OrgStructureInfo strucInfo = FastMergeUtil.getOrgStructureByUnit(ctx, unitInfo, tInfo);
        FullOrgUnitCollection unitColl = new FullOrgUnitCollection();
        if (strucInfo != null) {
            int index = 0;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            StringBuffer sb = new StringBuffer();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
            sb.append(" #" + index++);
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(strucInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
            sb.append(" and ( #" + index++);
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(strucInfo.getLongNumber() + "!" + "%" + "!" + "%"), CompareType.NOTLIKE));
            sb.append(" and #" + index++ + " ) ");
            filter.setMaskString(sb.toString());
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.isGrouping"));
            view.getSelector().add(new SelectorItemInfo("unit.isUnion"));
            view.getSorter().add(new SorterItemInfo("unit.number"));
            IOrgStructure iStruc = null;
            iStruc = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
            OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(view);
            if (strucInfos.size() != 0) {
                for (int i = 0; i < strucInfos.size(); ++i) {
                    unitColl.add(strucInfos.get(i).getUnit());
                }
                return unitColl;
            }
        }
        return unitColl;
    }

    protected static OrgUnitCollection getUnionDebtChildrenIntersectSet(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo, Set<String> numberSet) throws BOSException, EASBizException {
        OrgUnitCollection unitInfos = new OrgUnitCollection();
        OrgUnitInfo unitInfo = (OrgUnitInfo)parentOrg;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        IOrgStructure iStruc = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureInfo structInfo = FastMergeUtil.getOrgStructureByUnit(ctx, unitInfo, tInfo);
        if (structInfo != null) {
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
            filter1.getFilterItems().add(new FilterItemInfo("parent.id", (Object)structInfo.getId()));
            if (numberSet != null && numberSet.size() > 0) {
                filter1.getFilterItems().add(new FilterItemInfo("unit.number", numberSet, CompareType.INCLUDE));
            }
            view1.setFilter(filter1);
            view1.getSelector().add(new SelectorItemInfo("id"));
            view1.getSelector().add(new SelectorItemInfo("unit.id"));
            view1.getSelector().add(new SelectorItemInfo("unit.isGrouping"));
            view1.getSelector().add(new SelectorItemInfo("unit.name"));
            view1.getSelector().add(new SelectorItemInfo("unit.number"));
            view1.getSorter().add(new SorterItemInfo("unit.number"));
            OrgStructureCollection infos = iStruc.getOrgStructureCollection(view1);
            for (int i = 0; i < infos.size(); ++i) {
                unitInfos.add((OrgUnitInfo)infos.get(i).getUnit());
            }
            return unitInfos;
        }
        return null;
    }

    protected static OrgUnitCollection getUnionDebtAllOrgUnitIntersectSet(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo, Set<String> numberSet) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)parentOrg;
        OrgTreeInfo tInfo = (OrgTreeInfo)treeInfo;
        OrgUnitCollection unitInfos = new OrgUnitCollection();
        OrgStructureInfo strucInfo = FastMergeUtil.getOrgStructureByUnit(ctx, unitInfo, tInfo);
        if (strucInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
            if (numberSet == null || numberSet.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(strucInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
            if (numberSet != null && numberSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("unit.number", numberSet, CompareType.INCLUDE));
            }
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            view.getSelector().add(new SelectorItemInfo("unit.number"));
            view.getSorter().add(new SorterItemInfo("unit.number"));
            IOrgStructure iStruc = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
            OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(view);
            if (strucInfos.size() != 0) {
                for (int i = 0; i < strucInfos.size(); ++i) {
                    unitInfos.add((OrgUnitInfo)strucInfos.get(i).getUnit());
                }
                return unitInfos;
            }
        }
        return null;
    }

    public static OrgUnitCollection getOrgUnitsIntersectSet(Context ctx, OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo, boolean isSupportCrossMerger, Set<String> numberSet, OrgStructureCollection orgStructures, boolean isSupportGroupReport, int mergeType) throws EASBizException, BOSException {
        OrgUnitCollection units = null;
        if (isSupportCrossMerger || !isSupportGroupReport && orgStructures != null) {
            IOrgStructure struct = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
            StringBuffer oql = new StringBuffer();
            oql.append("select longnumber,level where tree.id ='").append(orgTreeInfo.getId()).append("' and unit.id='").append(parentCompanyInfo.getId()).append("'");
            OrgStructureInfo structInfo = null;
            OrgStructureCollection structColl = struct.getOrgStructureCollection(oql.toString());
            if (structColl != null && structColl.size() > 0) {
                structInfo = structColl.get(0);
            }
            if (structInfo == null) {
                return null;
            }
            oql.setLength(0);
            oql.append("select longnumber,level, unit.id,unit.name,unit.number,unit.isunion where tree.id ='");
            int level = structInfo.getLevel() + 1;
            if (isSupportCrossMerger) {
                if (!isSupportGroupReport && orgStructures != null) {
                    FastMergeUtil.getNosupportGroupSql(orgTreeInfo, orgStructures, oql);
                } else {
                    oql.append(orgTreeInfo.getId()).append("' and longnumber like '").append(structInfo.getLongNumber()).append("!%' ");
                    if (numberSet != null && numberSet.size() > 0) {
                        oql.append(" and unit.number in (").append(CslRptUtil.AryToItemString(numberSet)).append(")");
                    }
                    oql.append(" and level = " + level);
                }
            } else {
                FastMergeUtil.getNosupportGroupSql(orgTreeInfo, orgStructures, oql);
            }
            oql.append(" order by longnumber,unit.number");
            OrgStructureCollection coll = struct.getOrgStructureCollection(oql.toString());
            if (coll == null) {
                return null;
            }
            units = new OrgUnitCollection();
            FullOrgUnitInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i).getUnit();
                info.setLevel(coll.get(i).getLevel() - level);
                info.setLongNumber(coll.get(i).getLongNumber());
                info.setIsLeaf(!info.isIsUnion());
                units.add((OrgUnitInfo)info);
            }
        } else {
            boolean isByLevel = true;
            int i = mergeType;
            isByLevel = i != 0;
            try {
                if (numberSet != null && !numberSet.isEmpty()) {
                    units = FastMergeUtil.getUnionDebtAllOrgUnitIntersectSet(ctx, (IObjectValue)parentCompanyInfo, (IObjectValue)orgTreeInfo, numberSet);
                }
                if (isByLevel) {
                    units = FastMergeUtil.getUnionDebtChildrenIntersectSet(ctx, (IObjectValue)parentCompanyInfo, (IObjectValue)orgTreeInfo, numberSet);
                }
                units = FastMergeUtil.getUnionDebtAllOrgUnitIntersectSet(ctx, (IObjectValue)parentCompanyInfo, (IObjectValue)orgTreeInfo, numberSet);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"692_SumRptCalculateGuideUI"), (Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"692_SumRptCalculateGuideUI"), (Throwable)e);
            }
        }
        return units;
    }

    private static void getNosupportGroupSql(OrgTreeInfo orgTreeInfo, OrgStructureCollection orgStructures, StringBuffer oql) {
        oql.append(orgTreeInfo.getId()).append("'");
        for (int i = 0; i < orgStructures.size(); ++i) {
            OrgStructureInfo info = orgStructures.get(i);
            if (i == 0) {
                oql.append(" and longnumber in ('").append(info.getLongNumber()).append("'");
                continue;
            }
            oql.append(",'").append(info.getLongNumber()).append("'");
        }
        oql.append(")");
    }

    public static OrgStructureInfo getOrgStructureByUnit(Context ctx, OrgUnitInfo unitInfo, OrgTreeInfo tInfo) throws BOSException {
        IOrgStructure iStruc = null;
        iStruc = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)tInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() != 0) {
            return structInfos.get(0);
        }
        return null;
    }

    public static FullOrgUnitCollection getAdjustOrgUnits(Context ctx, IObjectValue parentOrg, IObjectValue treeInfo, boolean isDisplayAdjustRPTMByOrg, BOSUuid userId) throws BOSException, EASBizException {
        Set<String> orgIDSet = null;
        if (isDisplayAdjustRPTMByOrg) {
            orgIDSet = CslRptUtil.getOrgUnitSetIdByUser(ctx, userId);
            FullOrgUnitCollection OrgUnitColl = FastMergeUtil.getUnionDebtAllOrgUnits(ctx, parentOrg, treeInfo);
            FullOrgUnitCollection returnUnits = new FullOrgUnitCollection();
            for (int i = 0; i < OrgUnitColl.size(); ++i) {
                if (!orgIDSet.contains(OrgUnitColl.get(i).getId().toString())) continue;
                returnUnits.add(OrgUnitColl.get(i));
            }
            return returnUnits;
        }
        return FastMergeUtil.getUnionDebtAllOrgUnits(ctx, parentOrg, treeInfo);
    }

    public static boolean checkNumberDup(IObjectValue model, boolean isOrgFilter, ICoreBase corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        return corebase.exists(filter);
    }

    public static boolean checkNameDup(IObjectValue model, boolean isOrgFilter, ICoreBase corebase) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        FilterItemInfo filterItem0 = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        int formulaIndex = 0;
        filter.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        if (dataBaseInfo.getId() != null) {
            FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (isOrgFilter) {
            FilterItemInfo filterItem2 = new FilterItemInfo("organUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        return corebase.exists(filter);
    }

    public static boolean checkHasUsed(String keyWord, String value, ICoreBase corebase) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(keyWord, (Object)value, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        return corebase.exists(filter);
    }

    public static TemplateInfo getLastestTemplate(Context ctx, String orgBound, String companyId, String templateId) throws BOSException, EASBizException {
        String selectStr = " select * from (SELECT distinct temp.fid fid ,temp.fnumber fnumber,temp.fname fname,temp.fperiodType fperiodType,";
        selectStr = selectStr + "temp.ftemplateType ftemplateType,temp.FGroup ,temp.FDynaRptType,temp.fversionnumber,temp.FIsFreezed \n";
        StringBuffer sqlBuff = new StringBuffer(selectStr);
        sqlBuff.append(" from T_CSL_TempletDispense dispense \n");
        sqlBuff.append(" INNER JOIN T_RPT_Template temp ON dispense.FDispenseSrcID = temp.FID \n");
        sqlBuff.append(" INNER JOIN T_RPT_Template curtemp ON curtemp.fgroup = temp.fgroup \n");
        sqlBuff.append(" WHERE  dispense.FSourceType = 1  \n");
        sqlBuff.append("  AND temp.FTemplateType in (3,4,5,11,13)  \n");
        sqlBuff.append("   AND dispense.FOrgBoundID = ? AND dispense.FCompanyID =?   \n");
        sqlBuff.append("  and curtemp.fid=? ) t \n");
        sqlBuff.append("  order by to_int(substring(t.fversionnumber,1,charindex('.',t.fversionnumber)-1)) desc  \n");
        TemplateInfo info = new TemplateInfo();
        ArrayList<String> params = new ArrayList<String>();
        params.add(orgBound);
        params.add(companyId);
        params.add(templateId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                if (rowSet.getInt("FIsFreezed") == 1) {
                    throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TEMPLATE_IS_FORBID"));
                }
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setNumber(rowSet.getString("fnumber"));
                info.setName(rowSet.getString("fname"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("fperiodType")));
                info.setTemplateType(RptTmpTypeEnum.getEnum((int)rowSet.getInt("ftemplateType")));
                info.setGroup(rowSet.getString("FGroup"));
                info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(rowSet.getInt("FDynaRptType")));
                return info;
            }
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TEMPLATE_ISNOT_DISPEN"));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static TemplateInfo getLastestByTemapIdAndComp(Context ctx, String orgBound, String companyId, String templateId, int periodType) throws BOSException, EASBizException {
        String selectStr = " SELECT distinct  temp.fid fid ,temp.fnumber fnumber,temp.fname fname,";
        selectStr = selectStr + "temp.fperiodType fperiodType,temp.ftemplateType ftemplateType,FGroup ,FDynaRptType \n";
        StringBuffer sqlBuff = new StringBuffer(selectStr);
        sqlBuff.append(" from T_CSL_TempletDispense dispense INNER JOIN T_RPT_Template temp ON dispense.FDispenseSrcID = temp.FID \n");
        sqlBuff.append("  INNER JOIN T_ORG_Tree ORGBOUND ON dispense.FOrgBoundID =ORGBOUND.FID \n");
        sqlBuff.append(" INNER JOIN T_ORG_BaseUnit COMPANY ON dispense.FCompanyID = COMPANY.FID \n ");
        sqlBuff.append(" WHERE  dispense.FSourceType = 1 AND temp.FVersionStatus = 1 AND temp.FIsFreezed = 0 \n");
        sqlBuff.append("  AND temp.FTemplateType in (3,4,5,11,13)  \n");
        sqlBuff.append("   AND ORGBOUND.FID = ? AND temp.FPeriodType = ? AND COMPANY.FID =?   \n");
        sqlBuff.append("  and temp.fid=?  \n");
        TemplateInfo info = new TemplateInfo();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(orgBound);
        params.add(new Integer(periodType));
        params.add(companyId);
        params.add(templateId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setNumber(rowSet.getString("fnumber"));
                info.setName(rowSet.getString("fname"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("fperiodType")));
                info.setTemplateType(RptTmpTypeEnum.getEnum((int)rowSet.getInt("ftemplateType")));
                info.setGroup(rowSet.getString("FGroup"));
                info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(rowSet.getInt("FDynaRptType")));
                return info;
            }
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TEMPLATE_ISNOT_DISPEN"));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static OrgTreeInfo getCurrentTree(Context ctx, Date date, String userId, String treeId) throws BOSException, RptWeaveException {
        String datestr = CslRptUtil.formatDateForSql(date);
        OrgTreeInfo info = new OrgTreeInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT top 1 Tree.FID, Tree.FNumber,Tree.FIsForBudget,Tree.FIsBasic  ").append(" FROM T_PM_OrgRange OrgRange  \n").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID  \n").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID \n").append(" INNER JOIN T_ORG_Tree Tree ON Tree.FId = Structure.FTreeId \n").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ?  \n").append(" AND OrgRange.FType = ").append(10).append(" and tree.fnumber in( select fnumber from   T_ORG_Tree where fid= ? )  \n").append(" and ((fstatus = 1  and fstartDate <=" + datestr + " ) or (fstatus = 2 and fstartDate <=" + datestr + " and fendDate >= " + datestr + " ))");
        Object[] params = new Object[]{userId, treeId};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            if (!rowSet.next()) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"BROUND_ISERROR"));
            }
            String ID = rowSet.getString("FID");
            String number = rowSet.getString("FNumber");
            boolean isForBudget = rowSet.getBoolean("FIsForBudget");
            info.setId(BOSUuid.read((String)ID));
            info.setNumber(number);
            info.setIsForBudget(isForBudget);
            info.setBasic(rowSet.getBoolean("FIsBasic"));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return info;
    }

    public static String getCurrentPeriodRptTempalteId(Context ctx, String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType) throws BOSException, EASBizException {
        String dataCollectNumber = "ACTUALDATA";
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", treeID);
        params.put("companyID", companyID);
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currencyID);
        params.put("templateGroupNumber", templateGroupNumber);
        params.put("reportType", new Integer(reportType));
        params.put("dataCollectNumber", dataCollectNumber);
        String sumRptId = RptAutoWeaveUtil.getSumRptid(ctx, params);
        if (StringUtils.isEmpty((String)sumRptId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("template.id"));
        CslReportInfo cslRptInfo = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(sumRptId), sic);
        if (cslRptInfo.getTemplate() != null) {
            return cslRptInfo.getTemplate().getId().toString();
        }
        return null;
    }

    public static EntityViewInfo getElimDefaultSolu(Context context, ICSLContext ctx, String number, boolean isSupportOtherDS) {
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        try {
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(ctx.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(ctx.getCurRptPeriod()), CompareType.EQUALS);
            OrgUnitInfo uif = ctx.getCurOrgGroup();
            number = CslRptUtil.getCompanyStructureNumber(context, ctx.getCurOrgBound(), uif);
            FilterItemInfo filterItem5 = new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            filterInfo.getFilterItems().add(filterItem5);
            sbFormula.append(" and #" + formulaIndex++);
            if (isSupportOtherDS) {
                FilterItemInfo filterItem6 = new FilterItemInfo("dataCollect.number", (Object)ctx.getCurDataCollect().getNumber(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem6);
                sbFormula.append(" and #" + formulaIndex++);
            } else {
                FilterItemInfo filterItem7 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItem7);
                sbFormula.append(" and #" + formulaIndex++);
            }
            filterInfo.setMaskString(sbFormula.toString());
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        evi.setFilter(filterInfo);
        return evi;
    }

    public static CslReportInfo createMnsRpt(ICSLContext cslCtx, TemplateInfo template, boolean isSupportOtherDS, CurrencyInfo currency, Date startDate, Date endDate, String description, OrgUnitInfo companyInfo, boolean isSupportGroupReport) throws BOSException {
        int year = cslCtx.getCurRptYear();
        short period = (short)cslCtx.getCurRptPeriod();
        int periodType = template.getPeriodType().getValue();
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (isSupportGroupReport) {
            if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)tmpType)) {
                rptType = RptSrcTypeEnum.MANUSCRIPT;
            } else if (RptTmpTypeEnum.MULTIDYNAMICMNSPORT.equals((Object)tmpType)) {
                rptType = RptSrcTypeEnum.MULTIDYNAMICMNSREPORT;
            }
        } else {
            rptType = RptSrcTypeEnum.MANUSCRIPT_FASTMERGE;
        }
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setOrgTree(cslCtx.getCurOrgBound());
        editData.setOrgUnit(cslCtx.getCurOrgGroup());
        editData.setZipData(new byte[]{0});
        if (companyInfo != null) {
            editData.setCompany(companyInfo);
        } else {
            editData.setCompany(cslCtx.getCurOrgGroup());
        }
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        editData.setSourceType(rptType);
        editData.setOrgTree(cslCtx.getCurOrgBound());
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(cslCtx.getCurReportDate().getTime()));
        DataCollectInfo dataCollect = cslCtx.getCurDataCollect();
        editData.setDataCollect(dataCollect);
        if (dataCollect != null) {
            editData.setDataCollectNumber(dataCollect.getNumber());
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public static CslReportInfo createCslRpt(ICSLContext cslCtx, TemplateInfo template, CurrencyInfo currency, boolean isSupportOtherDS, Date startDate, Date endDate, String description, OrgUnitInfo comp) throws Exception {
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(cslCtx.getCurRptYear());
        editData.setPeriod((short)cslCtx.getCurRptPeriod());
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setBook(RptUtilForServer.LockBookExpTank((Book)template.getBook()));
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        if (template.getTemplateType() == RptTmpTypeEnum.CSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
        } else if (template.getTemplateType() == RptTmpTypeEnum.DYNAMICCSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.DYNAMICCSLREPORT);
        } else if (template.getTemplateType() == RptTmpTypeEnum.MULTIDYNAMICCSLPORT) {
            editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICCSLREPORT);
        }
        editData.setOrgTree(cslCtx.getCurOrgBound());
        if (comp != null) {
            editData.setCompany(comp);
        } else {
            editData.setCompany(cslCtx.getCurOrgGroup());
        }
        editData.setOrgUnit(cslCtx.getCurOrgGroup());
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(cslCtx.getCurRptPeriodType());
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(cslCtx.getCurReportDate().getTime()));
        if (isSupportOtherDS) {
            DataCollectInfo dataCollect = cslCtx.getCurDataCollect();
            editData.setDataCollect(dataCollect);
            if (dataCollect != null) {
                editData.setDataCollectNumber(dataCollect.getNumber());
            }
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public static CslReportInfo createCslRpt(ICSLContext cslCtx, TemplateInfo template, CurrencyInfo currency, boolean isSupportOtherDS, Date startDate, Date endDate, String description, OrgUnitInfo comp, boolean isSupportGroupReport) throws Exception {
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(cslCtx.getCurRptYear());
        editData.setPeriod((short)cslCtx.getCurRptPeriod());
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setBook(RptUtilForServer.LockBookExpTank((Book)template.getBook()));
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        editData.setDynaRptType(DynaEnumRptTypeEnum.DYNAMIC);
        if (template.getTemplateType() == RptTmpTypeEnum.CSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
            editData.setDynaRptType(DynaEnumRptTypeEnum.FIXED);
        } else if (template.getTemplateType() == RptTmpTypeEnum.DYNAMICCSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.DYNAMICCSLREPORT);
        } else if (template.getTemplateType() == RptTmpTypeEnum.MULTIDYNAMICCSLPORT) {
            editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICCSLREPORT);
        }
        if (!isSupportGroupReport) {
            if (template.getTemplateType() == RptTmpTypeEnum.CSLREPORT) {
                editData.setSourceType(RptSrcTypeEnum.CONSOLIDATION_FASTMERGE);
            } else if (template.getTemplateType() == RptTmpTypeEnum.DYNAMICCSLREPORT) {
                editData.setSourceType(RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE);
            }
        }
        editData.setOrgTree(cslCtx.getCurOrgBound());
        if (comp != null) {
            editData.setCompany(comp);
        } else {
            editData.setCompany(cslCtx.getCurOrgGroup());
        }
        editData.setOrgUnit(cslCtx.getCurOrgGroup());
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(cslCtx.getCurRptPeriodType());
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(cslCtx.getCurReportDate().getTime()));
        DataCollectInfo dataCollect = cslCtx.getCurDataCollect();
        editData.setDataCollect(dataCollect);
        if (dataCollect != null) {
            editData.setDataCollectNumber(dataCollect.getNumber());
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public static CslReportInfo createCslRpt(Date date, int year, short period, OrgTreeInfo unitTree, OrgUnitInfo company, TemplateInfo template, CurrencyInfo currency, boolean isSupportOtherDS, Date startDate, Date endDate, String description, OrgUnitInfo comp, DataCollectInfo dataCollect) throws Exception {
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setTemplate(template);
        editData.setBook(RptUtilForServer.LockBookExpTank((Book)template.getBook()));
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        if (template.getTemplateType() == RptTmpTypeEnum.CSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
        } else if (template.getTemplateType() == RptTmpTypeEnum.DYNAMICCSLREPORT) {
            editData.setSourceType(RptSrcTypeEnum.DYNAMICCSLREPORT);
        } else if (template.getTemplateType() == RptTmpTypeEnum.MULTIDYNAMICCSLPORT) {
            editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICCSLREPORT);
        }
        editData.setOrgTree(unitTree);
        if (comp != null) {
            editData.setCompany(comp);
        } else {
            editData.setCompany(company);
        }
        editData.setOrgUnit(company);
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(template.getPeriodType());
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setReportDate(new Timestamp(date.getTime()));
        if (isSupportOtherDS) {
            editData.setDataCollect(dataCollect);
            if (dataCollect != null) {
                editData.setDataCollectNumber(dataCollect.getNumber());
            }
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public static FastMergeOrgUnitCollection sortOrgUnitColl(FastMergeOrgUnitCollection old_orgUnitColl) throws BOSException, EASBizException {
        FastMergeOrgUnitCollection new_orgUnitColl = new FastMergeOrgUnitCollection();
        for (int i = 0; i < old_orgUnitColl.size(); ++i) {
            if (!old_orgUnitColl.get(i).isIsSelected()) continue;
            if (i == 0) {
                new_orgUnitColl.add(old_orgUnitColl.get(0));
                continue;
            }
            int newsize = new_orgUnitColl.size();
            boolean isHasAdd = false;
            for (int j = 0; j < newsize; ++j) {
                if (old_orgUnitColl.get(i).getOrgUnit().getLevel() > new_orgUnitColl.get(j).getOrgUnit().getLevel()) {
                    new_orgUnitColl.addObject(j, (IObjectValue)old_orgUnitColl.get(i));
                    isHasAdd = true;
                    break;
                }
                if (old_orgUnitColl.get(i).getOrgUnit().getLevel() != new_orgUnitColl.get(j).getOrgUnit().getLevel() || old_orgUnitColl.get(i).getOrgUnit().getLongNumber().length() <= new_orgUnitColl.get(j).getOrgUnit().getLongNumber().length()) continue;
                new_orgUnitColl.addObject(j, (IObjectValue)old_orgUnitColl.get(i));
                isHasAdd = true;
                break;
            }
            if (isHasAdd) continue;
            new_orgUnitColl.add(old_orgUnitColl.get(i));
        }
        return new_orgUnitColl;
    }

    public static CslRptQuerySoluInfo getCslQuerySoluInfo(Context ctx, String soluId, OrgTreeInfo curOrgTree, Date date) throws BOSException, EASBizException {
        IQuerySolution iQuery = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionInfo querySoluInfo = iQuery.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(soluId));
        try {
            CslRptQuerySoluInfo cslRptQuerySoluInfo = FastMergeUtil.getCslRptQuerySoluInfo(querySoluInfo);
            FastMergeUtil.getOrgTreeAndUnionVersion(ctx, cslRptQuerySoluInfo, curOrgTree, date);
            return cslRptQuerySoluInfo;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void getOrgTreeAndUnionVersion(Context ctx, CslRptQuerySoluInfo cslRptQuerySoluInfo, OrgTreeInfo curOrgTree, Date date) throws Exception {
        if (cslRptQuerySoluInfo != null && date != null) {
            MnsFillOrgUnitCollection orgUnitColl = cslRptQuerySoluInfo.getOrgUnitCollection();
            String ksqlDate = new StringBuffer().append("{ts'").append(DateTimeUtils.getYear((Date)date)).append("-").append(DateTimeUtils.getMonth((Date)date)).append("-").append(DateTimeUtils.getDay((Date)date)).append(" 00:00:00'}").toString();
            StringBuffer whereSql = new StringBuffer();
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                if (!(StringUtils.isEmpty((String)orgUnitColl.get(i).getOrgTreeInfo().getNumber()) || orgUnitColl.get(i).getOrgTreeInfo().getNumber().equals(curOrgTree.getNumber()) || StringUtils.isEmpty((String)orgUnitColl.get(i).getFullOrgUnitInfo().getNumber()))) {
                    if (whereSql.length() > 0) {
                        whereSql.append(" or ");
                    }
                    whereSql.append(" (tree.number='").append(orgUnitColl.get(i).getOrgTreeInfo().getNumber()).append("'");
                    whereSql.append(" and unit.number='").append(orgUnitColl.get(i).getFullOrgUnitInfo().getNumber()).append("')");
                    continue;
                }
                orgUnitColl.get(i).setOrgTreeInfo(curOrgTree);
            }
            if (whereSql.length() > 0) {
                whereSql.insert(0, "(");
                whereSql.append(") and ((tree.status=").append(2).append(" and ").append("tree.startDate<=").append(ksqlDate).append(" and ").append("tree.endDate>=").append(ksqlDate).append(") or (tree.status=").append(1).append(" and tree.startDate<=").append(ksqlDate).append("))").toString();
                IOrgStructure iOrgStructure = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
                OrgStructureCollection coll = iOrgStructure.getOrgStructureCollection("select tree.id,tree.number,unit.id,unit.number where " + whereSql.toString());
                HashMap<String, OrgStructureInfo> tmp = new HashMap<String, OrgStructureInfo>();
                for (int i = 0; i < coll.size(); ++i) {
                    tmp.put(coll.get(i).getTree().getNumber() + coll.get(i).getUnit().getNumber(), coll.get(i));
                }
                if (!tmp.isEmpty()) {
                    OrgStructureInfo struntureInfo = null;
                    for (int i = 0; i < orgUnitColl.size(); ++i) {
                        if (!orgUnitColl.get(i).getOrgTreeInfo().getNumber().equals(curOrgTree.getNumber())) {
                            struntureInfo = (OrgStructureInfo)tmp.get(orgUnitColl.get(i).getOrgTreeInfo().getNumber() + orgUnitColl.get(i).getFullOrgUnitInfo().getNumber());
                            if (struntureInfo == null) continue;
                            orgUnitColl.get(i).getFullOrgUnitInfo().setId(struntureInfo.getUnit().getId());
                            orgUnitColl.get(i).getOrgTreeInfo().setId(struntureInfo.getTree().getId());
                            continue;
                        }
                        orgUnitColl.get(i).getOrgTreeInfo().setId(curOrgTree.getId());
                    }
                    tmp.clear();
                }
            }
        }
    }

    public static CslRptQuerySoluInfo getCslQuerySoluInfo(String soluId, IQuerySolution iQuery) throws BOSException, EASBizException {
        try {
            QuerySolutionInfo querySoluInfo = iQuery.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(soluId));
            return FastMergeUtil.getCslRptQuerySoluInfo(querySoluInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getCslQuerySoluInfo error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static CslRptQuerySoluInfo getCslRptQuerySoluInfo(QuerySolutionInfo querySoluInfo) throws Exception {
        if (querySoluInfo == null) {
            return null;
        }
        CslRptQuerySoluInfo cslRptQuerySoluInfo = new CslRptQuerySoluInfo();
        EntityViewInfo v = new EntityViewInfo();
        try {
            String entityViewInfo = querySoluInfo.getEntityViewInfo();
            if (StringUtils.isEmpty((String)entityViewInfo)) {
                return null;
            }
            v = new EntityViewInfo(entityViewInfo);
        }
        catch (ParserException e) {
            logger.error((Object)"getCslSoluOrgs", (Throwable)e);
            e.printStackTrace();
        }
        FilterItemCollection filterItems = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        for (int index = 0; index < filterItems.size(); ++index) {
            FilterItemInfo item = filterItems.get(index);
            if (item.getPropertyName().equalsIgnoreCase("mnsOrgs")) {
                cslRptQuerySoluInfo.setOrgUnitCollection(MnsFillOrgUnitCollection.parse(item.getCompareValue().toString()));
            }
            if (item.getPropertyName().equalsIgnoreCase("sumMethod")) {
                cslRptQuerySoluInfo.setSumMethod(DynaSumMethodEnum.getEnum((Integer)item.getCompareValue()));
            }
            if (item.getPropertyName().equalsIgnoreCase("displayNumber")) {
                cslRptQuerySoluInfo.setDisplayNumber((Integer)item.getCompareValue());
            }
            if (item.getPropertyName().equalsIgnoreCase("isShowTotal")) {
                cslRptQuerySoluInfo.setShowTotal("1".equals((String)item.getCompareValue()));
            }
            if (item.getPropertyName().equalsIgnoreCase("isOnlyList")) {
                cslRptQuerySoluInfo.setOnlyList("1".equals((String)item.getCompareValue()));
            }
            if (item.getPropertyName().equalsIgnoreCase("isOnlyListCompany")) {
                cslRptQuerySoluInfo.setOnlyListCompany("1".equals((String)item.getCompareValue()));
            }
            if (!item.getPropertyName().equalsIgnoreCase("isSupportHandSingleData")) continue;
            cslRptQuerySoluInfo.setSupportHandSingleData("1".equals((String)item.getCompareValue()));
        }
        return cslRptQuerySoluInfo;
    }

    public static Map<String, MnsFillOrgUnitCollection> getCalSolutOrgUnits(FastMergeOrgUnitCollection orgUnitColl, IQuerySolution iQuery) throws Exception {
        HashMap<String, MnsFillOrgUnitCollection> unionOrg_calSolutOrgs = new HashMap<String, MnsFillOrgUnitCollection>();
        if (orgUnitColl != null) {
            StringBuffer calSolutIds = new StringBuffer();
            HashMap<String, String> calSolutId_org = new HashMap<String, String>();
            String id = null;
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                id = orgUnitColl.get(i).getFixedCalcSolu();
                if (StringUtils.isEmpty((String)id) || !orgUnitColl.get(i).isIsSelected()) continue;
                calSolutIds.append("'").append(id).append("',");
                calSolutId_org.put(id, orgUnitColl.get(i).getChooseId());
            }
            if (calSolutIds.length() > 0) {
                calSolutIds.deleteCharAt(calSolutIds.lastIndexOf(","));
                QuerySolutionCollection querySolutions = iQuery.getQuerySolutionCollection("where id in(" + calSolutIds.toString() + ")");
                if (querySolutions != null) {
                    CslRptQuerySoluInfo soluInfo = null;
                    for (int i = 0; i < querySolutions.size(); ++i) {
                        if (querySolutions.get(i) == null || (soluInfo = FastMergeUtil.getCslRptQuerySoluInfo(querySolutions.get(i))) == null || soluInfo.getOrgUnitCollection() == null) continue;
                        unionOrg_calSolutOrgs.put((String)calSolutId_org.get(querySolutions.get(i).getId().toString()), soluInfo.getOrgUnitCollection());
                    }
                }
            }
            calSolutId_org.clear();
        }
        return unionOrg_calSolutOrgs;
    }

    public static CslRptQuerySoluInfo getCslDefaultQuerySoluInfo(FastMergeSoluInfo soluInfo, IRpcHandleFacade rpcHand, String companyId, DynaSumMethodEnum defaultDySumMethod) throws BOSException, EASBizException {
        CslRptQuerySoluInfo cslRptQuerySoluInfo = new CslRptQuerySoluInfo();
        FullOrgUnitCollection fullOrgUnitCollection = null;
        MessagePostManManager msgMng = new MessagePostManManager("getUnionDebtChildren");
        msgMng.addMessage(new MessagePostMan("treeId", soluInfo.getOrgBound().getId().toString()));
        msgMng.addMessage(new MessagePostMan("orgUnitId", companyId));
        msgMng = rpcHand.getRpcZipData(msgMng);
        fullOrgUnitCollection = (FullOrgUnitCollection)msgMng.getItem("returnValue").getValue();
        MnsFillOrgUnitInfo mnsFillOrgUnitInfo = null;
        if (fullOrgUnitCollection != null) {
            for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
                mnsFillOrgUnitInfo = new MnsFillOrgUnitInfo();
                mnsFillOrgUnitInfo.setFullOrgUnitInfo(fullOrgUnitCollection.get(i));
                mnsFillOrgUnitInfo.setOrgTreeInfo(soluInfo.getOrgBound());
                if (fullOrgUnitCollection.get(i).isIsUnion()) {
                    mnsFillOrgUnitInfo.setSourceSoluInfo(soluInfo);
                    mnsFillOrgUnitInfo.setFromStatutory(soluInfo.isIsSupportGroupReport());
                } else {
                    mnsFillOrgUnitInfo.setSourceSoluInfo(null);
                    mnsFillOrgUnitInfo.setFromStatutory(true);
                }
                mnsFillOrgUnitInfo.setOrgUnitType(fullOrgUnitCollection.get(i).isIsUnion() ? "1" : "0");
                cslRptQuerySoluInfo.getOrgUnitCollection().add(mnsFillOrgUnitInfo);
            }
        }
        cslRptQuerySoluInfo.setSumMethod(defaultDySumMethod);
        return cslRptQuerySoluInfo;
    }

    public static FastMergeTemplateCollection sortTempateEnties(FastMergeTemplateCollection old_tempateEnties) throws BOSException, EASBizException {
        FastMergeTemplateCollection new_tempateEnties = new FastMergeTemplateCollection();
        for (int i = 0; i < old_tempateEnties.size(); ++i) {
            if (i == 0) {
                new_tempateEnties.add(old_tempateEnties.get(0));
                continue;
            }
            int newsize = new_tempateEnties.size();
            boolean isHasAdd = false;
            for (int j = 0; j < newsize; ++j) {
                int iv = old_tempateEnties.get(i).getTemplate().getTemplateType().getValue();
                int jv = new_tempateEnties.get(j).getTemplate().getTemplateType().getValue();
                if (iv != 4 || iv >= jv) continue;
                new_tempateEnties.addObject(j, (IObjectValue)old_tempateEnties.get(i));
                isHasAdd = true;
                break;
            }
            if (isHasAdd) continue;
            new_tempateEnties.add(old_tempateEnties.get(i));
        }
        return new_tempateEnties;
    }

    public static String getStringRes(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)key);
    }

    public static String getStringRes(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)key, (Locale)locale);
    }

    public static String get_ReportByTmpVersionFromFastMerge(Context ctx, String treeId, String companyId, String currencyId, String templetId, int RptType, int periodType, int year, int period, String reportId, String dataCollectNumber, String fastMergeSoluId, boolean isSupportGroupReport) throws BOSException {
        boolean isSingle = false;
        if (RptType == 7 || RptType == 1) {
            isSingle = true;
        }
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("\tselect top 1 c.fid from t_csl_cslreport c\t\n");
        if (isSupportGroupReport) {
            strSQL.append(" inner join T_Csl_SumRptAddedPerporty perpoty on c.fid = perpoty.FReport \n");
        }
        strSQL.append("\twhere c.forgunitid = ? \t\t\t\t\t\n");
        strSQL.append("\t\tand c.fadjuststatus = 0 \t\t\t\t\n");
        if (!isSingle) {
            strSQL.append("\t\tand c.forgtreeid = ? \t\t\t\t\n");
        }
        strSQL.append("\t\tand c.fcurrencyid = ? \t\t\t\t\n");
        strSQL.append("\t\tand c.FSourceCurrencyID = ? \t\t\t\n");
        if (!isSingle) {
            strSQL.append("\t\tand c.fsourcetype = ? \t\t\t\n");
        } else {
            strSQL.append("\t\tand c.fsourcetype in (?, ?)\t\t\n");
        }
        if (isSupportGroupReport) {
            strSQL.append("\t\tand perpoty.fisSupportGroup = ? \t\t\t\t\n");
        }
        strSQL.append("\t\tand c.fperiodtype = ? \t\t\t\t\n");
        strSQL.append("\t\tand c.fyear = ? \t\t\t\t\t\t\n");
        strSQL.append("\t\tand c.fperiod = ? \t\t\t\t\t\n");
        strSQL.append("\t\tand c.ftemplateid in ( \t\t\t\t\n");
        strSQL.append("\t\tselect b.FID from t_rpt_template a,t_rpt_template b \t\n");
        strSQL.append("\t\twhere  a.fid = ? \t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\t       and a.fnumber = b.fnumber \t\t\t\t\t\t\n");
        strSQL.append("\t\t       and a.ftemplatetype = b.ftemplatetype \t\t\t\n");
        strSQL.append("\t\t       and a.fcompanyid = b.fcompanyid \t\t\t\t\t\n");
        strSQL.append("\t\t       and a.FperiodType = b.fperiodtype )\t\t\t\t\n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(companyId);
        if (!isSingle) {
            params.add(treeId);
        }
        params.add(currencyId);
        params.add(currencyId);
        if (!isSingle) {
            params.add(new Integer(RptType));
        } else {
            params.add(new Integer(7));
            params.add(new Integer(1));
        }
        if (isSupportGroupReport) {
            params.add(isSupportGroupReport);
        }
        params.add(new Integer(periodType));
        params.add(new Integer(year));
        params.add(new Integer(period));
        params.add(templetId);
        if (reportId != null && reportId.length() != 0) {
            strSQL.append("\t\tand c.fid <> ? ");
            params.add(reportId);
        }
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            strSQL.append("\t\tand c.fdataCollectNumber = ? ");
            params.add(dataCollectNumber);
        }
        if (!isSupportGroupReport && !StringUtils.isEmpty((String)fastMergeSoluId)) {
            strSQL.append(" and c.ffastMergeSoluId= ? ");
            params.add(fastMergeSoluId);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
        try {
            String rptId = null;
            if (rs != null && rs.next()) {
                rptId = rs.getString("FID");
            }
            return rptId;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static RptSrcTypeEnum transSourceType(int sourceType) {
        RptSrcTypeEnum retEnum = null;
        switch (sourceType) {
            case 3: {
                retEnum = RptSrcTypeEnum.SUM_FASTMERGE;
                break;
            }
            case 11: {
                retEnum = RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE;
                break;
            }
            case 4: {
                retEnum = RptSrcTypeEnum.MANUSCRIPT_FASTMERGE;
                break;
            }
            case 5: {
                retEnum = RptSrcTypeEnum.CONSOLIDATION_FASTMERGE;
                break;
            }
            case 13: {
                retEnum = RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE;
                break;
            }
            default: {
                retEnum = RptSrcTypeEnum.getEnum((int)sourceType);
            }
        }
        return retEnum;
    }

    public static RptSrcTypeEnum trans2SysSourceType(int sourceType) {
        RptSrcTypeEnum retEnum = null;
        switch (sourceType) {
            case 31: {
                retEnum = RptSrcTypeEnum.SUM;
                break;
            }
            case 32: {
                retEnum = RptSrcTypeEnum.DYNAMICSUMREPORT;
                break;
            }
            case 33: {
                retEnum = RptSrcTypeEnum.MANUSCRIPT;
                break;
            }
            case 34: {
                retEnum = RptSrcTypeEnum.CONSOLIDATION;
                break;
            }
            case 35: {
                retEnum = RptSrcTypeEnum.DYNAMICCSLREPORT;
                break;
            }
            default: {
                retEnum = RptSrcTypeEnum.getEnum((int)sourceType);
            }
        }
        return retEnum;
    }

    public static RptSrcTypeEnum trans2FastMergeSourceType(int sourceType) {
        RptSrcTypeEnum retEnum = null;
        switch (sourceType) {
            case 2: {
                retEnum = RptSrcTypeEnum.SUM_FASTMERGE;
                break;
            }
            case 11: {
                retEnum = RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE;
                break;
            }
            case 4: {
                retEnum = RptSrcTypeEnum.MANUSCRIPT_FASTMERGE;
                break;
            }
            case 3: {
                retEnum = RptSrcTypeEnum.CONSOLIDATION_FASTMERGE;
                break;
            }
            case 12: {
                retEnum = RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE;
                break;
            }
            default: {
                retEnum = RptSrcTypeEnum.getEnum((int)sourceType);
            }
        }
        return retEnum;
    }

    public static List getAdjustTypeList(FastMergeSoluInfo soluInfo) {
        AdjustTypeEntriesCollection typeEntries;
        AdjustEntiresSoluInfo adjustSoluInfo;
        ArrayList<String> adjustTypeList = new ArrayList<String>();
        if (soluInfo != null && (adjustSoluInfo = soluInfo.getAdjustEntrySolu()) != null && (typeEntries = adjustSoluInfo.getAdjustTypeEntries()) != null && !typeEntries.isEmpty()) {
            Iterator itr = typeEntries.iterator();
            String adjustTypeId = null;
            while (itr.hasNext()) {
                adjustTypeId = String.valueOf(((AdjustTypeEntriesInfo)itr.next()).getAdjustType().getId());
                if (adjustTypeList.contains(adjustTypeId)) continue;
                adjustTypeList.add(adjustTypeId);
            }
        }
        return adjustTypeList;
    }

    public static List getElimTypeList(FastMergeSoluInfo soluInfo) {
        ElimTypeEntriesCollection typeEntries;
        EliminationEntiresSoluInfo elimSoluInfo;
        ArrayList<String> elimTypeList = new ArrayList<String>();
        if (soluInfo != null && (elimSoluInfo = soluInfo.getElimEntrySolu()) != null && (typeEntries = elimSoluInfo.getElimTypeEntries()) != null && !typeEntries.isEmpty()) {
            Iterator itr = typeEntries.iterator();
            String elimTypeId = null;
            while (itr.hasNext()) {
                elimTypeId = String.valueOf(((ElimTypeEntriesInfo)itr.next()).getElimType().getId());
                if (elimTypeList.contains(elimTypeId)) continue;
                elimTypeList.add(elimTypeId);
            }
        }
        return elimTypeList;
    }

    public static void initSoluAdjustAndElimData(Context _ctx, FastMergeSoluInfo soluInfo) throws BOSException, EASBizException {
        EliminationEntiresSoluInfo elimSolu;
        AdjustEntiresSoluInfo adjustSolu = soluInfo.getAdjustEntrySolu();
        if (adjustSolu != null && adjustSolu.getId() != null && (adjustSolu.isIsRelateExistData() || adjustSolu.isIsCreateAdjustByAdTemp() && adjustSolu.isIsAutoCreateEntries())) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("adjustTmpEntries.id");
            selectors.add("adjustTmpEntries.adjustTmp.id");
            selectors.add("adjustTypeEntries.id");
            selectors.add("adjustTypeEntries.adjustType.id");
            AdjustEntiresSoluInfo info = AdjustEntiresSoluFactory.getLocalInstance(_ctx).getAdjustEntiresSoluInfo((IObjectPK)new ObjectUuidPK(adjustSolu.getId()), selectors);
            adjustSolu.setClientAdjustTypes((IObjectCollection)info.getAdjustTypeEntries());
            adjustSolu.setClientAdjustTmps((IObjectCollection)info.getAdjustTmpEntries());
        }
        if ((elimSolu = soluInfo.getElimEntrySolu()) != null && elimSolu.getId() != null && (elimSolu.isIsRelateExistData() || elimSolu.isIsAutoCreateElimByElimTemp() && elimSolu.isIsAutoCreateEntries() || elimSolu.isIsImportDynaItemData())) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("elimTypeEntries.id");
            selectors.add("elimTypeEntries.elimType.id");
            selectors.add("elimTmpEntries.id");
            selectors.add("elimTmpEntries.elimTmp.id");
            selectors.add("templates.template.id");
            selectors.add("templates.template.number");
            selectors.add("templates.template.name");
            selectors.add("templates.template.templateType");
            EliminationEntiresSoluInfo info = EliminationEntiresSoluFactory.getLocalInstance(_ctx).getEliminationEntiresSoluInfo((IObjectPK)new ObjectUuidPK(elimSolu.getId()), selectors);
            elimSolu.setClientElimTypes((IObjectCollection)info.getElimTypeEntries());
            elimSolu.setClientElimTmps((IObjectCollection)info.getElimTmpEntries());
            elimSolu.setClientTemplates((IObjectCollection)info.getTemplates());
        }
    }

    public static Object[] getAllOrgUnitByOrgTree(String orgTreeId, Context ctx) throws BOSException, EASBizException {
        int i;
        if (StringUtils.isEmpty((String)orgTreeId)) {
            return new Object[0];
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("unit.isAssistantOrg", (Object)new Integer(0)));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("unit.*"));
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        view.getSelector().add(new SelectorItemInfo("unit.parent.*"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("unit.longnumber");
        sorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterItemInfo);
        IOrgStructure iOrgStructure = null;
        iOrgStructure = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection orgStructures = iOrgStructure.getOrgStructureCollection(view);
        Object[] companyCollection = new Object[orgStructures.size()];
        OrgStructureInfo tmpOrgStructure = null;
        HashMap parents = new HashMap();
        for (i = 0; i < orgStructures.size(); ++i) {
            if (orgStructures.get(i).getParent() == null || orgStructures.get(i).getParent().getId() == null) continue;
            parents.put(orgStructures.get(i).getParent().getId().toString(), null);
        }
        for (i = 0; i < orgStructures.size(); ++i) {
            tmpOrgStructure = orgStructures.get(i);
            tmpOrgStructure.getUnit().setLevel(tmpOrgStructure.getLevel());
            tmpOrgStructure.getUnit().setIsLeaf(!parents.containsKey(tmpOrgStructure.getId().toString()));
            companyCollection[i] = tmpOrgStructure.getUnit();
        }
        parents.clear();
        return companyCollection;
    }

    public static Date getPeriodLastDate(Context ctx, OrgTreeInfo orgTreeInfo, int year, int period, RptPeriodTypeEnum periodType) throws EASBizException, BOSException {
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(ctx);
        PeriodCollection periods = null;
        if (FastMergeUtil.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTreeInfo);
        }
        return FiscalPeriodHelper.getPeriodLastDate(periods, year, period, periodType, isMergeByFiscalPeriod);
    }

    public static Date getPeriodLastDate(OrgTreeInfo orgTreeInfo, int year, int period, RptPeriodTypeEnum periodType) throws EASBizException, BOSException {
        return FastMergeUtil.getPeriodLastDate(null, orgTreeInfo, year, period, periodType);
    }

    private static boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodType) {
        RptPeriodTypeEnum p = RptPeriodTypeEnum.MONTHLY;
        if (periodType instanceof RptPeriodTypeEnum) {
            p = periodType;
        }
        return isMergeByFiscalPeriod && !p.equals((Object)RptPeriodTypeEnum.DAILY) && !p.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }

    public static boolean checkHasOrgTreeInfo(String userId, String fastMergeSoluId, int year, int period) throws EASBizException, BOSException {
        OrgTreeInfo info = FastMergeUtil.getOrgTreeInfo(userId, fastMergeSoluId, year, period);
        return info != null;
    }

    public static OrgTreeInfo getOrgTreeInfo(String userId, String fastMergeSoluId, int year, int period) throws EASBizException, BOSException {
        SelectorItemCollection selector = new FastMergeExecSelector().getSelector();
        FastMergeSoluInfo fastMergeSoluInfo = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        String treeNumber = fastMergeSoluInfo.getOrgBound().getNumber();
        RptPeriodTypeEnum periodType = fastMergeSoluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        Date reportDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
        OrgTreeCollection orgTrees = CslRptUtil.getAllUnionTrees(null, userId, reportDate);
        OrgTreeInfo orgTreeInfo = null;
        for (int i = 0; i < orgTrees.size(); ++i) {
            orgTreeInfo = orgTrees.get(i);
            if (!treeNumber.equals(orgTreeInfo.getNumber())) continue;
            return orgTreeInfo;
        }
        return null;
    }

    public static boolean checkHasOrgUnit(Context ctx, String userId, String treeId, String orgUnitId) throws EASBizException, BOSException {
        boolean isHas = false;
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        Map orgUnitMap = iPermission.getUnionUnits((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(treeId));
        if (orgUnitMap.containsKey(orgUnitId)) {
            isHas = true;
        }
        return isHas;
    }

    public static void requestCheckControlLock(Context ctx, BOSUuid userId, String actionName, String mutexName) throws Exception {
        IMutexServiceControl imc = null;
        imc = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Uuid requestId = Uuid.create();
        MutexParameter param = new MutexParameter();
        param.setRequestId(requestId);
        param.setDcName(SysContext.getSysContext().getDcName());
        param.setActionName(actionName);
        param.setMutexName(mutexName);
        param.setUserID(userId);
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        boolean ret = false;
        ret = imc.requestMutex(param);
        if (!ret) {
            throw new PermissionServiceException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CurrentRecordLocked"));
        }
    }

    public static void requestBizObjIDForUpdate(Context ctx, String str) throws Exception {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (!mutexService.requestBizObjIDForUpdate(str)) {
            throw new PermissionServiceException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Msg_CurrentRecordLocked"));
        }
    }

    public static void releaseObjIDForUpdate(Context ctx, String str) throws Exception {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseObjIDForUpdate(str);
    }

    public static String cslrptAduit(Context ctx, CslReportInfo editData) throws Exception {
        ReportStatusHandle rptStatusHandle = new ReportStatusHandle();
        return rptStatusHandle.cslrptAduit(ctx, editData);
    }

    public static void cslrptCommit(Context ctx, CslReportInfo editData) throws Exception {
        ReportStatusHandle rptStatusHandle = new ReportStatusHandle();
        if (editData.getCommittedStatus() != null && !CommittedStatusEnum.UNCOMMITTED.equals((Object)editData.getCommittedStatus())) {
            return;
        }
        rptStatusHandle.cslrptCommit(ctx, editData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cslReceive(Context ctx, CslReportInfo editData) throws Exception {
        ReportStatusHandle rptStatusHandle = new ReportStatusHandle();
        try {
            ctx.put((Object)isExecutPermissionKey, (Object)false);
            String string = rptStatusHandle.cslReceive(ctx, editData, String.valueOf(ctx.getCaller()));
            return string;
        }
        finally {
            ctx.remove((Object)isExecutPermissionKey);
        }
    }

    public static List getMergeCompanys(Context ctx, String fastMergeSoluId, String orgUtilId, int dynaType) throws EASBizException, BOSException {
        IFastMergeSolu iFastMergeSolu = FastMergeSoluFactory.getLocalInstance(ctx);
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("id");
        selectorColl.add("isAutoSum");
        selectorColl.add("orgBound");
        selectorColl.add("orgUnits");
        selectorColl.add("isSupportGroupReport");
        selectorColl.add("orgUnits.orgUnit");
        selectorColl.add("orgUnits.fixedCalcSolu");
        selectorColl.add("orgUnits.dynaCalcSolu");
        FastMergeSoluInfo fastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selectorColl);
        FastMergeOrgUnitCollection fastMergeOrgUnitCollection = fastMergeSoluInfo.getOrgUnits();
        for (int i = 0; i < fastMergeOrgUnitCollection.size(); ++i) {
            FastMergeOrgUnitInfo fastMergeOrgUnitInfo = fastMergeOrgUnitCollection.get(i);
            FullOrgUnitInfo curOrgUnitInfo = fastMergeOrgUnitInfo.getOrgUnit();
            if (!orgUtilId.equals(curOrgUnitInfo.getId().toString())) continue;
            String querySoluId = null;
            querySoluId = fastMergeSoluInfo.isIsAutoSum() && dynaType == 2 ? fastMergeOrgUnitInfo.getDynaCalcSolu() : fastMergeOrgUnitInfo.getFixedCalcSolu();
            if (StringUtils.isEmpty((String)querySoluId)) {
                return null;
            }
            if (fastMergeSoluInfo.isIsAutoSum()) {
                ISumSchm iSumSchm = SumSchmFactory.getLocalInstance(ctx);
                Set<String> numberSetDynaSolu = FastMergeUtil.getSoluOrgUnit(ctx, querySoluId);
                if (fastMergeSoluInfo.getOrgBound() == null) {
                    return null;
                }
                String orgBoundId = fastMergeSoluInfo.getOrgBound().getId().toString();
                MergeModeEnum soluBoundMergeMode = RptAutoWeaveUtil.getMergeMode(ctx, orgBoundId);
                OrgStructureCollection strucColl = FastMergeUtil.getOrgStructureColl(ctx, orgBoundId, numberSetDynaSolu);
                OrgUnitCollection orgUnitCollection = FastMergeUtil.getOrgUnitsIntersectSet(ctx, fastMergeSoluInfo.getOrgBound(), (OrgUnitInfo)curOrgUnitInfo, false, numberSetDynaSolu, strucColl, fastMergeSoluInfo.isIsSupportGroupReport(), soluBoundMergeMode.getValue());
                ArrayList<String> idList = new ArrayList<String>();
                for (int j = 0; j < orgUnitCollection.size(); ++j) {
                    idList.add(orgUnitCollection.get(j).getId().toString());
                }
                return idList;
            }
            IQuerySolution iQuery = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionInfo querySoluInfo = iQuery.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(querySoluId));
            EntityViewInfo v = new EntityViewInfo();
            String entityViewInfo = querySoluInfo.getEntityViewInfo();
            try {
                if (StringUtils.isEmpty((String)entityViewInfo)) {
                    return null;
                }
                v = new EntityViewInfo(entityViewInfo);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            FilterItemCollection filterItems = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
            ArrayList<MnsFillOrgUnitInfo> idList = new ArrayList<MnsFillOrgUnitInfo>();
            for (int index = 0; index < filterItems.size(); ++index) {
                FilterItemInfo item = filterItems.get(index);
                if (!item.getPropertyName().equalsIgnoreCase("mnsOrgs")) continue;
                MnsFillOrgUnitCollection mnsFillOrgUnitCollection = MnsFillOrgUnitCollection.parse(item.getCompareValue().toString());
                for (int j = 0; j < mnsFillOrgUnitCollection.size(); ++j) {
                    idList.add(mnsFillOrgUnitCollection.get(j));
                }
                return idList;
            }
        }
        return null;
    }

    public static Set<String> getSoluOrgUnit(Context ctx, String sumSchmId) throws BOSException, EASBizException {
        ISumSchmEntry iSumSchmEntry = ctx == null ? SumSchmEntryFactory.getRemoteInstance() : SumSchmEntryFactory.getLocalInstance(ctx);
        HashSet<String> numberSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumSchm.id", (Object)sumSchmId));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("comNum"));
        SumSchmEntryCollection sumSchmColl = iSumSchmEntry.getSumSchmEntryCollection(view);
        for (int i = 0; i < sumSchmColl.size(); ++i) {
            numberSet.add(sumSchmColl.get(i).getComNum());
        }
        return numberSet;
    }

    public static OrgStructureCollection getOrgStructureColl(Context ctx, String treeId, Set<String> orgNumbers) throws BOSException, EASBizException {
        if (orgNumbers == null || orgNumbers.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.number", orgNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        IOrgStructure iStruc = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection strucInfos = iStruc.getOrgStructureCollection(view);
        return strucInfos;
    }

    public static boolean getIsContainUnRecive(Context ctx, String fastMergeSoluId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return false;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isContainUnRecive"));
        selector.add(new SelectorItemInfo("isSupportGroupReport"));
        IFastMergeSolu iFastMergeSolu = null;
        iFastMergeSolu = ctx == null ? FastMergeSoluFactory.getRemoteInstance() : FastMergeSoluFactory.getLocalInstance(ctx);
        FastMergeSoluInfo fastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        if (fastMergeSoluInfo != null) {
            return fastMergeSoluInfo.isIsContainUnRecive() && !fastMergeSoluInfo.isIsSupportGroupReport();
        }
        return true;
    }

    public static void initConditionByFastMergeSolu(Context ctx, ItemDataCondition condition, DynaParamInfo paramInfo) throws BOSException, EASBizException {
        String fastMergeSoluId = null;
        if (condition != null) {
            fastMergeSoluId = condition.getFastMergeSoluId();
        } else if (paramInfo != null) {
            fastMergeSoluId = paramInfo.fastMergeSoluId;
        }
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isContainUnRecive"));
        selector.add(new SelectorItemInfo("isSupportGroupReport"));
        selector.add(new SelectorItemInfo("autoItemFormual.id"));
        IFastMergeSolu iFastMergeSolu = null;
        iFastMergeSolu = ctx == null ? FastMergeSoluFactory.getRemoteInstance() : FastMergeSoluFactory.getLocalInstance(ctx);
        FastMergeSoluInfo fastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        if (fastMergeSoluInfo != null) {
            if (condition != null) {
                condition.setContainUnRecive(fastMergeSoluInfo.isIsContainUnRecive() && !fastMergeSoluInfo.isIsSupportGroupReport());
                if (fastMergeSoluInfo.getAutoItemFormual() != null && fastMergeSoluInfo.getAutoItemFormual().getId() != null) {
                    condition.setAutoItemFormualId(fastMergeSoluInfo.getAutoItemFormual().getId().toString());
                }
            } else if (paramInfo != null) {
                boolean bl = paramInfo.isContainUnRecive = fastMergeSoluInfo.isIsContainUnRecive() && !fastMergeSoluInfo.isIsSupportGroupReport();
                if (fastMergeSoluInfo.getAutoItemFormual() != null && fastMergeSoluInfo.getAutoItemFormual().getId() != null) {
                    paramInfo.autoItemFormualId = fastMergeSoluInfo.getAutoItemFormual().getId().toString();
                }
            }
        }
    }

    public static Date getLastExcuteDate(Context ctx, String fastMergeSoluId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return null;
        }
        int year = 0;
        int period = 0;
        int[] value = FastMergeUtil.getLastExcuteYearAndPeriod(ctx, fastMergeSoluId);
        if (value != null) {
            year = value[0];
            period = value[1];
        }
        RptPeriodTypeEnum periodType = FastMergeUtil.getTemplatePeriodType(ctx, fastMergeSoluId);
        if (year != 0 && period != 0 && periodType != null) {
            Date lastExcuteDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            return lastExcuteDate;
        }
        return null;
    }

    public static int[] getLastExcuteYearAndPeriod(Context ctx, String fastMergeSoluId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mergeContext", (Object)fastMergeSoluId));
        filter.getFilterItems().add(new FilterItemInfo("nodeType", (Object)0));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("year"));
        selector.add(new SelectorItemInfo("period"));
        view.setSelector(selector);
        IAutoMergeLog iAutoMergeLog = null;
        iAutoMergeLog = ctx == null ? AutoMergeLogFactory.getRemoteInstance() : AutoMergeLogFactory.getLocalInstance(ctx);
        AutoMergeLogCollection autoMergeLogCollection = iAutoMergeLog.getCollection(view);
        int year = 0;
        int period = 0;
        if (autoMergeLogCollection.size() > 0) {
            year = autoMergeLogCollection.get(0).getYear();
            period = autoMergeLogCollection.get(0).getPeriod();
            if (year != 0 && period != 0) {
                return new int[]{year, period};
            }
        }
        return null;
    }

    public static Date getLastCalcDate(Context ctx, String formulaCalcId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)formulaCalcId)) {
            return null;
        }
        int year = 0;
        int period = 0;
        int[] value = FastMergeUtil.getLastCalcYearAndPeriod(ctx, formulaCalcId);
        if (value != null) {
            year = value[0];
            period = value[1];
        }
        RptPeriodTypeEnum periodType = FastMergeUtil.getTemplatePeriodType(ctx, formulaCalcId);
        if (year != 0 && period != 0 && periodType != null) {
            Date lastExcuteDate = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            return lastExcuteDate;
        }
        return null;
    }

    public static int[] getLastCalcYearAndPeriod(Context ctx, String formulaCalcId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)formulaCalcId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("context", (Object)formulaCalcId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)4));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("year"));
        selector.add(new SelectorItemInfo("period"));
        view.setSelector(selector);
        IFormulaCalcLog iFormulaCalcLog = null;
        iFormulaCalcLog = ctx == null ? FormulaCalcLogFactory.getRemoteInstance() : FormulaCalcLogFactory.getLocalInstance(ctx);
        CoreBaseCollection formulaCalcLogCollection = iFormulaCalcLog.getCollection(view);
        int year = 0;
        int period = 0;
        if (formulaCalcLogCollection.size() > 0) {
            FormulaCalcLogInfo formulaCalcLogInfo = (FormulaCalcLogInfo)formulaCalcLogCollection.get(0);
            year = formulaCalcLogInfo.getYear();
            period = formulaCalcLogInfo.getPeriod();
            if (year != 0 && period != 0) {
                return new int[]{year, period};
            }
        }
        return null;
    }

    public static RptPeriodTypeEnum getTemplatePeriodType(Context ctx, String fastMergeSoluId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("templates.template.periodType"));
        IFastMergeSolu iFastMergeSolu = null;
        iFastMergeSolu = ctx == null ? FastMergeSoluFactory.getRemoteInstance() : FastMergeSoluFactory.getLocalInstance(ctx);
        FastMergeSoluInfo fastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        if (fastMergeSoluInfo != null) {
            return fastMergeSoluInfo.getTemplates().get(0).getTemplate().getPeriodType();
        }
        return null;
    }

    public static void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = "true".equalsIgnoreCase(String.valueOf(CslRptUtil.isSupport13Period(null))) ? 13 : 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        CslRptUIUtil.setSpineRange((KDSpinner)sp, (int)min, (int)max);
    }

    public static Map getFastMergeFiterParam(Context ctx, String fastMergeSoluId) throws BOSException, EASBizException {
        HashMap<String, Object> fiterParam = null;
        if (StringUtils.isEmpty((String)fastMergeSoluId)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("orgBound.id"));
        selector.add(new SelectorItemInfo("orgBound.number"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("templates.template.periodType"));
        IFastMergeSolu iFastMergeSolu = null;
        iFastMergeSolu = ctx == null ? FastMergeSoluFactory.getRemoteInstance() : FastMergeSoluFactory.getLocalInstance(ctx);
        FastMergeSoluInfo fastMergeSoluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMergeSoluId), selector);
        if (fastMergeSoluInfo != null) {
            fiterParam = new HashMap<String, Object>();
            RptPeriodTypeEnum periodType = fastMergeSoluInfo.getTemplates().get(0).getTemplate().getPeriodType();
            String orgTreeNumber = fastMergeSoluInfo.getOrgBound().getNumber();
            fiterParam.put("currencyId", fastMergeSoluInfo.getCurrency().getId().toString());
            fiterParam.put("periodType", periodType);
            int[] yearAndPeriod = FastMergeUtil.getLastExcuteYearAndPeriod(ctx, fastMergeSoluId);
            if (yearAndPeriod != null && yearAndPeriod.length == 2) {
                int year = yearAndPeriod[0];
                int period = yearAndPeriod[1];
                fiterParam.put("year", year);
                fiterParam.put("period", period);
                fiterParam.put("orgBound", FastMergeUtil.getOrgTreeByDateAndNo(ctx, year, period, periodType.getValue(), orgTreeNumber));
            }
        }
        return fiterParam;
    }

    public static OrgTreeInfo getOrgTreeByDateAndNo(Context ctx, int year, int period, int periodType, String number) throws BOSException, EASBizException {
        Date d = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        String dateString = CslRptUtil.formatDateForSql(d);
        StringBuffer oql = new StringBuffer("select id, number where number=").append("'" + number + "' and type=8 ").append(" and ((status = 1  and startDate <= ").append(dateString).append(" ) or (status = 2 and startDate <= ").append(dateString).append(" and endDate >= ").append(dateString).append("))").append(" order by endDate desc ");
        IOrgTree iOrgTree = null;
        iOrgTree = ctx != null ? OrgTreeFactory.getLocalInstance((Context)ctx) : OrgTreeFactory.getRemoteInstance();
        OrgTreeInfo treeInfo = iOrgTree.getOrgTreeInfo(oql.toString());
        return treeInfo;
    }

    public static FullOrgUnitInfo getOrgUnitByDateAndNo(Context ctx, int year, int period, int periodType, String treeNumber, String unitNumber) throws BOSException, EASBizException {
        Date d = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        String dateString = CslRptUtil.formatDateForSql(d);
        SQLBuilder buffer = new SQLBuilder();
        String l = ctx.getLocale().toString();
        buffer.append("SELECT u.FId, u.FNumber, u.FLongNumber, u.FName_").append(l).append(" FName, u.FSimpleName \n");
        buffer.append("  FROM T_ORG_BaseUnit u \n");
        buffer.append("  JOIN T_ORG_Structure s ON s.FUnitId = u.FId \n");
        buffer.append("  JOIN T_ORG_Tree t ON t.FId = s.FTreeId \n");
        buffer.append(" WHERE u.FNumber = ? \n", (Object)unitNumber);
        buffer.append("\t AND t.FNumber = ? \n", (Object)treeNumber);
        buffer.append("\t AND t.FType = 8 \n");
        buffer.append("\t AND t.FIsForBudget = 0 \n");
        buffer.append("\t AND ((t.FStatus = 1 AND t.FStartDate <=").append(dateString).append(")");
        buffer.append("\t     OR (t.FStatus = 2 AND t.FStartDate <=").append(dateString);
        buffer.append("\t         AND FEndDate >=").append(dateString).append("))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        FullOrgUnitInfo fullOrgUnitInfo = null;
        try {
            while (rs.next()) {
                fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FId")));
                fullOrgUnitInfo.setNumber(rs.getString("FNumber"));
                fullOrgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                fullOrgUnitInfo.setName(rs.getString("FName"), ctx.getLocale());
                fullOrgUnitInfo.setSimpleName(rs.getString("FSimpleName"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return fullOrgUnitInfo;
    }

    public static void deleteMergeReport(Context ctx, IObjectPK arrayPK) throws BOSException, EASBizException {
        ICslReport iCslReport = null;
        iCslReport = ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(ctx);
        CslReportCollection cslReportColl = iCslReport.getCslReportCollection(" where fastMergeSoluId ='" + arrayPK.toString() + "'");
        for (int i = 0; i < cslReportColl.size(); ++i) {
            iCslReport.delete((IObjectPK)new ObjectUuidPK(cslReportColl.get(i).getId()));
        }
    }

    public static List<ManageMergeOrgUnit> getManageMergeOrgUnitList(String solutionId, String orgTreeId, FastMergeOrgUnitCollection orgUnitColl, boolean isSupportGroupReport, boolean isIncludeNoSelected) throws Exception {
        FastMergeSoluInfo curMergeSolu;
        String curOrgTreeId = orgTreeId;
        boolean curIsSupportGroupReport = isSupportGroupReport;
        if ((orgUnitColl == null || orgUnitColl.isEmpty()) && (curMergeSolu = FastMergeSoluFactory.getRemoteInstance().getFastMergeSoluInfo("select orgBound,isSupportGroupReport where id='" + solutionId + "'")) != null && curMergeSolu.getOrgBound() != null && curMergeSolu.getOrgBound().getId() != null) {
            curIsSupportGroupReport = curMergeSolu.isIsSupportGroupReport();
            curOrgTreeId = curMergeSolu.getOrgBound().getId().toString();
            orgUnitColl = (FastMergeOrgUnitCollection)FastMergeOrgUnitFactory.getRemoteInstance().constructFastMergeUnitColl(curOrgTreeId, solutionId, "isNotAutoSum");
        }
        if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
            Map<String, MnsFillOrgUnitCollection> calsolutOrgUnits = FastMergeUtil.getCalSolutOrgUnits(orgUnitColl, QuerySolutionFactory.getRemoteInstance());
            Map<String, List<OrgStructureInfo>> OrgStructureParentChildMap = FastMergeUtil.getOrgStructureParentChildMap(curOrgTreeId);
            return FastMergeUtil.getManageMergeOrgUnitList(orgUnitColl, calsolutOrgUnits, OrgStructureParentChildMap, curIsSupportGroupReport, isIncludeNoSelected);
        }
        return null;
    }

    private static List<ManageMergeOrgUnit> getManageMergeOrgUnitList(FastMergeOrgUnitCollection orgUnitColl, Map<String, MnsFillOrgUnitCollection> calsolutOrgUnits, Map<String, List<OrgStructureInfo>> OrgStructureParentChildMap, boolean isSupportGroupReport, boolean isIncludeNoSelected) throws Exception {
        ArrayList<ManageMergeOrgUnit> manageMergeOrgUnitList = new ArrayList<ManageMergeOrgUnit>();
        FastMergeOrgUnitInfo fastMergeOrgUnitInfo = null;
        MnsFillOrgUnitCollection mnsFillOrgUnitColl = null;
        List<OrgStructureInfo> orgStructureList = null;
        MnsFillOrgUnitInfo mnsFillOrgUnitInfo = null;
        String parentId = null;
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            fastMergeOrgUnitInfo = orgUnitColl.get(i);
            if (!isIncludeNoSelected && !fastMergeOrgUnitInfo.isIsSelected()) continue;
            parentId = fastMergeOrgUnitInfo.getOrgUnit().getParent() != null && fastMergeOrgUnitInfo.getOrgUnit().getParent().getId() != null ? fastMergeOrgUnitInfo.getOrgUnit().getParent().getId().toString() : null;
            manageMergeOrgUnitList.add(new ManageMergeOrgUnit(fastMergeOrgUnitInfo, parentId));
            if (!fastMergeOrgUnitInfo.isIsSelected()) continue;
            mnsFillOrgUnitColl = calsolutOrgUnits.get(fastMergeOrgUnitInfo.getOrgUnit().getId().toString());
            if (mnsFillOrgUnitColl != null) {
                for (int j = 0; j < mnsFillOrgUnitColl.size(); ++j) {
                    manageMergeOrgUnitList.add(new ManageMergeOrgUnit(mnsFillOrgUnitColl.get(j), fastMergeOrgUnitInfo.getOrgUnit().getId().toString()));
                }
                continue;
            }
            orgStructureList = OrgStructureParentChildMap.get(fastMergeOrgUnitInfo.getOrgUnit().getId().toString());
            if (orgStructureList == null) continue;
            for (OrgStructureInfo orgStructureInfo : orgStructureList) {
                mnsFillOrgUnitInfo = new MnsFillOrgUnitInfo();
                mnsFillOrgUnitInfo.setFullOrgUnitInfo(orgStructureInfo.getUnit());
                mnsFillOrgUnitInfo.setOrgTreeInfo(orgStructureInfo.getTree());
                mnsFillOrgUnitInfo.setOrgUnitType(orgStructureInfo.getUnit().isIsUnion() ? "1" : "0");
                mnsFillOrgUnitInfo.setFromStatutory(orgStructureInfo.getUnit().isIsUnion() ? isSupportGroupReport : true);
                manageMergeOrgUnitList.add(new ManageMergeOrgUnit(mnsFillOrgUnitInfo, fastMergeOrgUnitInfo.getOrgUnit().getId().toString()));
            }
        }
        return manageMergeOrgUnitList;
    }

    public static Map<String, List<OrgStructureInfo>> getOrgStructureParentChildMap(String orgTreeId) throws Exception {
        OrgStructureCollection orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id,level,isLeaf,unit.name,unit.number,unit.longNumber,unit.id,tree.number,tree.name,unit.isunion,parent.unit.id where tree.id='" + orgTreeId + "' order by longnumber asc");
        if (orgStructureColl != null && orgStructureColl.size() > 0) {
            OrgStructureInfo orgStructureInfo = null;
            HashMap<String, List<OrgStructureInfo>> parent_childs = new HashMap<String, List<OrgStructureInfo>>();
            for (int i = 0; i < orgStructureColl.size(); ++i) {
                orgStructureInfo = orgStructureColl.get(i);
                if (orgStructureInfo.getParent() == null || orgStructureInfo.getParent().getUnit() == null || orgStructureInfo.getParent().getUnit().getId() == null) continue;
                ArrayList<OrgStructureInfo> childList = (ArrayList<OrgStructureInfo>)parent_childs.get(orgStructureInfo.getParent().getUnit().getId().toString());
                if (childList == null) {
                    childList = new ArrayList<OrgStructureInfo>();
                    parent_childs.put(orgStructureInfo.getParent().getUnit().getId().toString(), childList);
                }
                childList.add(orgStructureInfo);
            }
            return parent_childs;
        }
        return null;
    }

    public static FastMergeSoluInfo getFastMergeSoluInfo(Context ctx, String soluId, boolean isInitElim) throws Exception {
        EliminationEntiresSoluInfo elimSolu;
        IFastMergeSolu iFastMergeSolu = ctx != null ? FastMergeSoluFactory.getLocalInstance(ctx) : FastMergeSoluFactory.getRemoteInstance();
        FastMergeSoluInfo soluInfo = iFastMergeSolu.getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(soluId), new FastMergeExecSelector().getSelector());
        if (isInitElim && (elimSolu = soluInfo.getElimEntrySolu()) != null && elimSolu.isIsRelateExistData() && (elimSolu.getElimTypeEntries() == null || elimSolu.getElimTypeEntries().isEmpty())) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("elimTypeEntries.id");
            selectors.add("elimTypeEntries.elimType.id");
            selectors.add("elimTmpEntries.id");
            selectors.add("elimTmpEntries.elimTmp.id");
            EliminationEntiresSoluInfo info = (ctx != null ? EliminationEntiresSoluFactory.getLocalInstance(ctx) : EliminationEntiresSoluFactory.getRemoteInstance()).getEliminationEntiresSoluInfo((IObjectPK)new ObjectUuidPK(elimSolu.getId()), selectors);
            elimSolu.setClientElimTypes((IObjectCollection)info.getElimTypeEntries());
        }
        return soluInfo;
    }

    public static FastMergeOrgUnitInfo getCslRptFastMergeOrgUnitInfo(FastMergeSoluInfo soluInfo, CslReportInfo cslRptInfo) {
        if (soluInfo != null && soluInfo.getOrgUnits() != null && cslRptInfo != null) {
            FullOrgUnitInfo orgUnitInfo = null;
            for (int i = 0; i < soluInfo.getOrgUnits().size(); ++i) {
                orgUnitInfo = soluInfo.getOrgUnits().get(i).getOrgUnit();
                if (!orgUnitInfo.getNumber().equals(cslRptInfo.getOrgUnit().getNumber())) continue;
                return soluInfo.getOrgUnits().get(i);
            }
        }
        return null;
    }

    public static CslRptQuerySoluInfo[] getCslRptQuerySoluInfos(Context ctx, OrgTreeInfo orgTreeInfo, String orgUnitId, FastMergeOrgUnitInfo fastMergeOrgUnitInfo, DynaSumMethodEnum defaultDySumMethod, int[] calSoluType) throws Exception {
        IQuerySolution iQuery = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance((Context)ctx);
        IRpcHandleFacade rpcHand = ctx == null ? RpcHandleFacadeFactory.getRemoteInstance() : RpcHandleFacadeFactory.getLocalInstance(ctx);
        CslRptQuerySoluInfo defaultSoluInfo = null;
        CslRptQuerySoluInfo soluInfo = null;
        CslRptQuerySoluInfo[] soluInfos = new CslRptQuerySoluInfo[calSoluType.length];
        if (fastMergeOrgUnitInfo != null && calSoluType.length > 0) {
            String soluId = null;
            int type = -1;
            for (int i = 0; i < calSoluType.length; ++i) {
                soluInfo = null;
                type = calSoluType[i];
                switch (type) {
                    case 1: {
                        soluId = fastMergeOrgUnitInfo.getFixedCalcSolu();
                        break;
                    }
                    case 2: {
                        soluId = fastMergeOrgUnitInfo.getDynaCalcSolu();
                        break;
                    }
                    case 3: {
                        soluId = fastMergeOrgUnitInfo.getFixExcludeCalcSolu();
                    }
                }
                if (!StringUtils.isEmpty(soluId)) {
                    soluInfo = FastMergeUtil.getCslQuerySoluInfo(soluId, iQuery);
                }
                if (type != 3) {
                    if (soluInfo == null && defaultSoluInfo == null) {
                        defaultSoluInfo = FastMergeUtil.getCslDefaultQuerySoluInfo(orgTreeInfo, rpcHand, orgUnitId, defaultDySumMethod);
                    }
                    if (soluInfo == null && defaultSoluInfo != null) {
                        soluInfo = defaultSoluInfo;
                    }
                }
                soluInfos[i] = soluInfo;
            }
        }
        return soluInfos;
    }

    public static CslRptQuerySoluInfo getCslDefaultQuerySoluInfo(OrgTreeInfo orgTreeInfo, IRpcHandleFacade rpcHand, String companyId, DynaSumMethodEnum defaultDySumMethod) throws BOSException, EASBizException {
        CslRptQuerySoluInfo cslRptQuerySoluInfo = new CslRptQuerySoluInfo();
        FullOrgUnitCollection fullOrgUnitCollection = null;
        MessagePostManManager msgMng = new MessagePostManManager("getUnionDebtChildren");
        msgMng.addMessage(new MessagePostMan("treeId", orgTreeInfo.getId().toString()));
        msgMng.addMessage(new MessagePostMan("orgUnitId", companyId));
        msgMng = rpcHand.getRpcZipData(msgMng);
        fullOrgUnitCollection = (FullOrgUnitCollection)msgMng.getItem("returnValue").getValue();
        MnsFillOrgUnitInfo mnsFillOrgUnitInfo = null;
        if (fullOrgUnitCollection != null) {
            for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
                mnsFillOrgUnitInfo = new MnsFillOrgUnitInfo();
                mnsFillOrgUnitInfo.setFullOrgUnitInfo(fullOrgUnitCollection.get(i));
                mnsFillOrgUnitInfo.setOrgTreeInfo(orgTreeInfo);
                mnsFillOrgUnitInfo.setOrgUnitType(fullOrgUnitCollection.get(i).isIsUnion() ? "1" : "0");
                if (!fullOrgUnitCollection.get(i).isIsUnion()) {
                    mnsFillOrgUnitInfo.setSourceSoluInfo(null);
                    mnsFillOrgUnitInfo.setFromStatutory(true);
                }
                cslRptQuerySoluInfo.getOrgUnitCollection().add(mnsFillOrgUnitInfo);
            }
        }
        cslRptQuerySoluInfo.setSumMethod(defaultDySumMethod);
        return cslRptQuerySoluInfo;
    }

    public static boolean isDynamicReport(CslReportInfo report) {
        boolean isDynaReport = CslRptUtil.isDynamicReport(report);
        return isDynaReport || report.getSourceType() != null && (report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE));
    }

    public static boolean isFastMergeRpt(int sourceType) {
        return sourceType == 31 || sourceType == 33 || sourceType == 32 || sourceType == 34 || sourceType == 35 || sourceType == 43 || sourceType == 44 || sourceType == 46;
    }

    public static Map getReportVersion(Context ctx, String reportid) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SumRptAddedPerportyCollection coll = SumRptAddedPerportyFactory.getLocalInstance(ctx).getSumRptAddedPerportyCollection("select group,version where report = '" + reportid + "'");
        if (coll != null && !coll.isEmpty()) {
            SumRptAddedPerportyInfo sumRptAddedPerportyInfo = coll.get(0);
            int version = sumRptAddedPerportyInfo.getVersion();
            map.put("version", version);
            String group = sumRptAddedPerportyInfo.getGroup();
            map.put("group", group);
        }
        return map;
    }
}

