/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.app.AbstractIndexAnalysisControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IndexAnalysisControllerBean
extends AbstractIndexAnalysisControllerBean {
    private static final long serialVersionUID = -4160984788767640900L;
    private static Logger logger = Logger.getLogger((String)IndexAnalysisControllerBean.class.getName());

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IndexAnalysisInfo info = (IndexAnalysisInfo)model;
        this.updateDefaultFlag(ctx, model);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateDefaultFlag(ctx, model);
        super._update(ctx, pk, model);
    }

    private void updateDefaultFlag(Context ctx, IObjectValue model) throws BOSException {
        if (model instanceof IndexAnalysisInfo) {
            IndexAnalysisInfo info = (IndexAnalysisInfo)model;
            if (info.isIsDefaultIndex()) {
                StringBuffer _sql = new StringBuffer("UPDATE T_CSL_INDEXANALYSIS SET");
                _sql.append(" FIsDefaultIndex = 0, FDefaultDE = 0");
                _sql.append(" WHERE FIndexTypeid = ? AND (FIsDefaultIndex = 1 OR FDefaultDE > 0)");
                Object[] params = new Object[]{info.getIndexType().getId().toString()};
                DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
            } else if (info.getId() != null) {
                String _sql = "UPDATE T_CSL_INDEXANALYSIS SET FDefaultDE = 0 WHERE FId =?";
                DbUtil.execute((Context)ctx, (String)_sql, (Object[])new Object[]{info.getId().toString()});
                model.remove("defaultDE");
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected void _syncIndexes(Context ctx, Map param) throws BOSException {
        if (param == null) {
            return;
        }
        String sourceIndexId = (String)param.get("sourceIndexId");
        Set set = (Set)param.get("targetIndexIds");
        StringBuffer ids = new StringBuffer();
        int index = 0;
        for (String id : set) {
            if (index > 0) {
                ids.append(",");
            }
            ids.append("'" + id + "'");
            ++index;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT * FROM T_CSL_IndexAnalysisEntry WHERE FIndexAnalysisId=?").append(" ORDER BY FDataElementType, FSeq");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{sourceIndexId});
        try {
            while (rowSet.next()) {
                ArrayList<Object> p = new ArrayList<Object>();
                p.add(rowSet.getInt("FIsDefault"));
                p.add(rowSet.getInt("FIsShow"));
                p.add(rowSet.getString("FDataElementType"));
                p.add(rowSet.getString("FDataTypeNumber"));
                paramList.add(p.toArray());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        buffer = new StringBuffer();
        buffer.append("UPDATE T_CSL_IndexAnalysisEntry SET FIsDefault=?, FIsShow=? ").append("WHERE FIndexanalysisId IN (" + ids + ") AND FDataElementType=? AND FDataTypeNumber=?");
        CslRptUtil.executeBatch(ctx, buffer.toString(), paramList);
    }

    @Override
    protected boolean _setDebuglogger(Context ctx) throws BOSException {
        MobileUtil.isDebug = !MobileUtil.isDebug;
        return MobileUtil.isDebug;
    }

    @Override
    protected Map _checkData(Context ctx, List ids) throws BOSException {
        StringBuffer msg = new StringBuffer();
        String idsStr = "";
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                idsStr = idsStr + ",";
            }
            idsStr = idsStr + "'" + ids.get(i) + "'";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT t.indexName, t.userName FROM (");
        buffer.append("SELECT idxAna.FName_l2 indexName, u.FName_l2 userName  ");
        buffer.append("       FROM T_CSL_Indexdispensed d");
        buffer.append(" INNER JOIN T_CSL_Indexanalysis idxAna ON d.FIndex = idxAna.FId");
        buffer.append(" INNER JOIN T_PM_User u ON d.FUser = u.FId ");
        buffer.append("      WHERE idxAna.FId  IN (" + idsStr + ")) t ORDER BY t.indexName, t.userName ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        try {
            String body = EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"41_IndexDispensed_Detail", (Locale)ctx.getLocale());
            while (rowSet.next()) {
                msg.append(rowSet.getString("indexName") + " " + body + " " + rowSet.getString("userName") + "\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (msg.length() > 0) {
            HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
            map.put("msg", msg);
            return map;
        }
        return null;
    }

    @Override
    protected Map _moveData(Context ctx, Map param) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (param == null) {
            return result;
        }
        if (param != null) {
            SQLBuilder buffer = null;
            String source = param.get("source").toString();
            String target = param.get("target").toString();
            List ids = (List)param.get("ids");
            buffer = new SQLBuilder();
            buffer.append("SELECT DISTINCT FOrgBoundId, FCurrencyId, FDimension ");
            buffer.append("  FROM T_CSL_IndexType ");
            buffer.append(" WHERE FId IN ", new String[]{source, target});
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
                int i = 0;
                while (rs.next()) {
                    ++i;
                }
                if (i > 1) {
                    result.put("errorMsg", EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"65_IndexTypeDiffer", (Locale)ctx.getLocale()));
                    return result;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            buffer.reset();
            HashMap<String, String> map = new HashMap<String, String>();
            String fName = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            buffer.append("SELECT analy.FNumber indexNum,analy." + fName + " indexName,scheme.FNumber schemeNum,scheme." + fName + " schemeName ");
            buffer.append("FROM T_CSL_IndexAnalysis analy ");
            buffer.append("JOIN T_CSL_IndexAnalysisSchemeEntry entry ON analy.FId = entry.FIndexId ");
            buffer.append("JOIN T_CSL_IndexAnalysisScheme scheme ON scheme.FId = entry.FSchemeId ");
            buffer.append("WHERE entry.FIndexId IN ", (Collection)ids);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
                StringBuffer errorMsg = new StringBuffer();
                String id = null;
                while (rs.next()) {
                    id = "[" + rs.getString("indexNum") + "]" + rs.getString("indexName");
                    if (map.containsKey(id)) {
                        map.put(id, (String)map.get(id) + ",[" + rs.getString("schemeNum") + "]" + rs.getString("schemeName"));
                        continue;
                    }
                    map.put(id, "[" + rs.getString("schemeNum") + "]" + rs.getString("schemeName"));
                }
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String idStr = it.next().toString();
                    errorMsg.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "82_CannotMoveEntry", new Object[]{idStr, map.get(id)}) + "\n");
                }
                if (id != null) {
                    result.put("errorMsg", errorMsg.toString());
                    return result;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            buffer.reset();
            buffer.append("UPDATE T_Csl_IndexAnalysis ");
            buffer.append("   SET FIndexTypeId = ?", (Object)target);
            buffer.append("       , FIsDefaultIndex = 0, FDefaultDE = 0");
            buffer.append(" WHERE FId IN ", (Collection)ids);
            DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            buffer.reset();
            buffer.append("UPDATE T_CSL_IndexAnalysisData ");
            buffer.append("   SET FIndexTypeId = ?", (Object)target);
            buffer.append(" WHERE FIndexAnalysisId IN ", (Collection)ids);
            DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            buffer.reset();
            buffer.append("UPDATE T_CSL_IndexDispensed ");
            buffer.append("   SET FIndexType = ?", (Object)target);
            buffer.append(" WHERE FIndex IN ", (Collection)ids);
            DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        }
        return result;
    }

    @Override
    protected Map _getSchemeEntry(Context ctx, List indexId) throws BOSException, EASBizException {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        StringBuffer buffer = new StringBuffer();
        try {
            String indexIdStr = "";
            for (int i = 0; i < indexId.size(); ++i) {
                indexIdStr = indexIdStr + "'" + indexId.get(i) + "',";
            }
            indexIdStr = indexIdStr.substring(0, indexIdStr.length() - 1);
            String fName = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            buffer.append("SELECT dispensed.FIndex,u.FNumber userNum,u." + fName + " userName,analysis.FNumber analysisNum,analysis." + fName + " analysisName");
            buffer.append(" FROM T_CSL_IndexDispensed dispensed ");
            buffer.append("JOIN T_PM_User u ");
            buffer.append("ON dispensed.FUser = u.FId ");
            buffer.append("JOIN T_CSL_IndexAnalysis analysis ");
            buffer.append("ON analysis.FId = dispensed.FIndex ");
            buffer.append("WHERE dispensed.FIndex IN (" + indexIdStr + ")");
            IRowSet rowIndex = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            HashMap<String, String> dispAnalysisMap = new HashMap<String, String>();
            while (rowIndex.next()) {
                String dispId = rowIndex.getString("FIndex");
                indexId.remove(dispId);
                String num = "[" + rowIndex.getString("analysisNum") + "]" + rowIndex.getString("analysisName");
                String name = "[" + rowIndex.getString("userNum") + "]" + rowIndex.getString("userName");
                if (dispAnalysisMap.containsKey(num)) {
                    dispAnalysisMap.put(num, (String)dispAnalysisMap.get(num) + "," + name);
                    continue;
                }
                dispAnalysisMap.put(num, name);
            }
            maps.put("dispAnalysisMap", dispAnalysisMap);
            if (indexId.size() == 0) {
                return maps;
            }
            indexIdStr = "";
            for (int i = 0; i < indexId.size(); ++i) {
                indexIdStr = indexIdStr + "'" + indexId.get(i) + "',";
            }
            indexIdStr = indexIdStr.substring(0, indexIdStr.length() - 1);
            buffer.setLength(0);
            buffer.append("SELECT a.FIndexId,c.FNumber FIndexNum,c." + fName + " FIndexName,a.FSchemeId,d.FNumber FSchemeNum,d." + fName + " FSchemeName,b.FDispenseId FROM ");
            buffer.append("(SELECT FIndexId,FSchemeId FROM T_CSL_IndexAnalysisSchemeEntry WHERE FIndexId IN(" + indexIdStr + "))");
            buffer.append("a LEFT JOIN T_CSL_ReportUserGroupDispEntry b ON a.FSchemeId = b.FSchemeId ");
            buffer.append("JOIN T_CSL_IndexAnalysis c ON c.FId = a.FIndexId ");
            buffer.append("JOIN T_CSL_IndexAnalysisScheme d ON d.FId = a.FSchemeId");
            IRowSet rowScheme = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            HashMap dispSch = new HashMap();
            HashMap impSch = new HashMap();
            while (rowScheme.next()) {
                HashMap<String, String> s;
                String fIndexId = rowScheme.getString("FIndexId");
                indexId.remove(fIndexId);
                String fDispenseId = rowScheme.getString("FDispenseId");
                String num = "[" + rowScheme.getString("FIndexNum") + "]" + rowScheme.getString("FIndexName");
                String name = "[" + rowScheme.getString("FSchemeNum") + "]" + rowScheme.getString("FSchemeName");
                if (fDispenseId != null) {
                    if (dispSch.containsKey(fIndexId)) {
                        if (((Map)dispSch.get(fIndexId)).containsKey(num)) {
                            ((Map)dispSch.get(fIndexId)).put(num, ((Map)dispSch.get(fIndexId)).get(num) + "," + name);
                            continue;
                        }
                        ((Map)dispSch.get(fIndexId)).put(num, name);
                        continue;
                    }
                    s = new HashMap<String, String>();
                    s.put(num, name);
                    dispSch.put(fIndexId, s);
                    continue;
                }
                if (impSch.containsKey(fIndexId)) {
                    if (((Map)impSch.get(fIndexId)).containsKey(num)) {
                        ((Map)impSch.get(fIndexId)).put(num, ((Map)impSch.get(fIndexId)).get(num) + "," + name);
                        continue;
                    }
                    ((Map)impSch.get(fIndexId)).put(num, name);
                    continue;
                }
                s = new HashMap();
                s.put(num, name);
                impSch.put(fIndexId, s);
            }
            maps.put("dispSch", dispSch);
            maps.put("impSch", impSch);
            maps.put("deleteId", indexId);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return maps;
    }

    @Override
    protected Map _appendMessage(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList dispensedId = new ArrayList();
        StringBuffer message = new StringBuffer();
        Map maps = this._getSchemeEntry(ctx, ids);
        Map dispAnalysisMap = (Map)maps.get("dispAnalysisMap");
        Map dispSch = (Map)maps.get("dispSch");
        Map impSch = (Map)maps.get("impSch");
        List deleteId = (List)maps.get("deleteId");
        ArrayList<String> importId = new ArrayList<String>();
        if (dispAnalysisMap.size() == 0 && dispSch.size() == 0 && impSch.size() == 0) {
            map.put("deleteId", deleteId);
            return map;
        }
        if (dispAnalysisMap.size() != 0) {
            for (String key : dispAnalysisMap.keySet()) {
                message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "79_IndexDispensed", new Object[]{key, dispAnalysisMap.get(key)})).append("\n");
            }
        }
        if (dispSch == null && impSch == null) {
            map.put("importId", importId);
            map.put("message", message);
            return map;
        }
        map.put("deleteId", deleteId);
        for (Map.Entry entryImp : impSch.entrySet()) {
            for (Map.Entry value1 : ((Map)entryImp.getValue()).entrySet()) {
                message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "81_IndexImport", new Object[]{value1.getKey(), value1.getValue()}));
                if (dispSch.containsKey(entryImp.getKey())) {
                    String disp = ((Map)dispSch.get(entryImp.getKey())).values().toString();
                    String dispValue = disp.substring(1, disp.length() - 1);
                    message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "80_Import_And_Dispensed", new Object[]{"," + dispValue, dispValue})).append("\n");
                    dispSch.remove(entryImp.getKey());
                    continue;
                }
                importId.add(entryImp.getKey().toString());
                message.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"83_Half_Import", (Locale)ctx.getLocale())).append("\n");
            }
        }
        for (Map.Entry entryDisp : dispSch.entrySet()) {
            for (Map.Entry value1 : ((Map)entryDisp.getValue()).entrySet()) {
                message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "84_IndexImport", new Object[]{value1.getKey(), value1.getValue()}));
                message.append(MobileUtil.getString("com.kingdee.eas.fi.gr.mobile.MobileCommonResource", "80_Import_And_Dispensed", new Object[]{"", value1.getValue()})).append("\n");
            }
        }
        map.put("importId", importId);
        map.put("message", message.toString());
        return map;
    }

    @Override
    protected Map _removeSchemeAndEntry(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        String idsStr = "";
        for (int i = 0; i < ids.size(); ++i) {
            idsStr = idsStr + "'" + ids.get(i) + "',";
        }
        idsStr = idsStr.substring(0, idsStr.length() - 1);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DELETE FROM T_CSL_IndexAnalysis WHERE FId IN (" + idsStr + ")");
            DbUtil.execute((Context)ctx, (String)buffer.toString());
            buffer.setLength(0);
            buffer.append("DELETE FROM T_CSL_IndexAnalysisSchemeEntry WHERE FIndexId IN (" + idsStr + ")");
            DbUtil.execute((Context)ctx, (String)buffer.toString());
            buffer.setLength(0);
            buffer.append("SELECT s.FId,count(e.FId) FROM T_CSL_IndexAnalysisScheme s ");
            buffer.append("LEFT JOIN T_CSL_IndexAnalysisSchemeEntry e ON s.FId = e.FSchemeId WHERE 1 = 1 ");
            buffer.append("GROUP BY s.FId ");
            buffer.append("HAVING count(e.fid) = 0");
            IRowSet s = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            StringBuffer sid = new StringBuffer();
            while (s.next()) {
                sid.append("'").append(s.getString("FId")).append("',");
            }
            if (sid.length() != 0) {
                buffer.setLength(0);
                buffer.append("DELETE FROM T_CSL_IndexAnalysisScheme WHERE FId IN (" + sid.substring(0, sid.length() - 1) + ")");
                DbUtil.execute((Context)ctx, (String)buffer.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

