/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.TimeLog;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.ReportQueryCondition;
import com.kingdee.eas.fi.gr.mobile.app.AbstractReportProcMonitorFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportProcMonitorFacadeControllerBean
extends AbstractReportProcMonitorFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)ReportProcMonitorFacadeControllerBean.class.getName());
    private static final String[] COL_LIST_MAIN_COMPANY = new String[]{"companyId", "longNumber", "companyDisplayName", "flevel", "unweave", "weave", "committed", "received", "isUnit"};
    private static final String[] COL_LIST_MAIN_REPORT = new String[]{"tgroup", "tmplName", "unweave", "weave", "committed", "received"};
    private static final String[] COL_LIST_DETAIL_CPMPANY = new String[]{"rptNumber", "rptName", "companyId", "companyNum", "companyDisplayName", "ID"};
    private static final String[] COL_LIST_DETAIL_REPORT = new String[]{"companyNum", "companyId", "companyDisplayName", "rptNumber", "rptName", "ID"};
    private static final String[] COL_TIP_REPORT = new String[]{"tmplName", "tgroup"};
    private static final String[] COL_TIP_COMPANY = new String[]{"companyDisplayName", "companyNum"};

    @Override
    protected List _getAuthorizedOrgTreeLst(Context ctx, ReportQueryCondition queryCondition) throws BOSException, EASBizException {
        int i;
        TimeLog time = new TimeLog();
        time.enterMethod("ReportProcMonitorFacadeControllerBean._getAuthorizedOrgTreeLst()");
        ArrayList<Map<String, String>> treeLst = new ArrayList<Map<String, String>>();
        OrgTreeCollection treeCol = CslRptUtil.getOrgTreeCollection(ctx, queryCondition.getUserId(), queryCondition.getRptDate());
        if (treeCol == null || treeCol.size() <= 0) {
            logger.warn((Object)("user'id is '" + queryCondition.getUserId() + "',it has't authorized orgTreeBound!"));
            return treeLst;
        }
        treeCol = CslRptUtil.getOrgTreeCollectionOrderByNumber(ctx, treeCol);
        OrgTreeInfo info = null;
        for (i = 0; i < treeCol.size(); ++i) {
            info = treeCol.get(i);
            if (!info.isIsHide()) continue;
            treeCol.remove(info);
            --i;
        }
        int size = treeCol.size();
        for (i = 0; i < size; ++i) {
            treeLst.add(this.wrappedOrgTreeRowInfo(treeCol.get(i)));
        }
        time.leaveMethod("ReportProcMonitorFacadeControllerBean._getAuthorizedOrgTreeLst()");
        logger.info((Object)time.print());
        return treeLst;
    }

    private Map<String, String> wrappedOrgTreeRowInfo(OrgTreeInfo info) {
        HashMap<String, String> rowMap = new HashMap<String, String>();
        rowMap.put("id", info.getId().toString());
        rowMap.put("name", info.getName());
        return rowMap;
    }

    @Override
    protected Map _getRptProcedureData(Context ctx, ReportQueryCondition queryCondition) throws BOSException, EASBizException {
        this.handleTmpTable(ctx, queryCondition);
        this.handleUserDefaultOrgAndBaseCurrency(ctx, queryCondition);
        this.insertData2Table(ctx, queryCondition);
        HashMap<String, Object> rstMap = new HashMap<String, Object>();
        rstMap.put("key_tempTable", queryCondition.getTable());
        rstMap.put("key_list", this.queryData(ctx, queryCondition, 0));
        return rstMap;
    }

    @Override
    protected Map _getSearchTip(Context ctx, ReportQueryCondition queryCondition) throws BOSException, EASBizException {
        HashMap<String, Object> rstMap = new HashMap<String, Object>();
        rstMap.put("key_tempTable", queryCondition.getTable());
        rstMap.put("key_list", this.queryData(ctx, queryCondition, 1));
        return rstMap;
    }

    private List<Map<String, String>> queryData(Context ctx, ReportQueryCondition condition, int flag) throws BOSException, EASBizException {
        ArrayList<Map<String, String>> rst = new ArrayList<Map<String, String>>();
        String sql = null;
        RptRowSet rs = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        try {
            String ksq;
            String[] cols;
            int len;
            int from;
            con = this.getConnection(ctx);
            if (flag == 1) {
                from = 0;
                len = 10;
                if (condition.getDimension() == 1) {
                    if (StringUtils.isEmpty((String)condition.getCompanyId())) {
                        sql = this.getReportDimensionTipSql(condition);
                        cols = COL_TIP_COMPANY;
                        ksq = sp.getSqlWithParams(sql);
                        MobileUtil.debugLog(logger, "CompanyDimension-getReportDimensionTipSql******************************************:\n" + ksq);
                    } else {
                        sql = this.getCompanyDimensionTipSql(condition);
                        cols = COL_TIP_REPORT;
                        ksq = sp.getSqlWithParams(sql);
                        MobileUtil.debugLog(logger, "CompanyDimension-getCompanyDimensionTipSql******************************************:\n" + ksq);
                    }
                } else if (StringUtils.isEmpty((String)condition.getTmplGroup())) {
                    sql = this.getCompanyDimensionTipSql(condition);
                    cols = COL_TIP_REPORT;
                    ksq = sp.getSqlWithParams(sql);
                    MobileUtil.debugLog(logger, "ReportDimension-getCompanyDimensionTipSql******************************************:\n" + ksq);
                } else {
                    sql = this.getReportDimensionTipSql(condition);
                    cols = COL_TIP_COMPANY;
                    ksq = sp.getSqlWithParams(sql);
                    MobileUtil.debugLog(logger, "ReportDimension-getReportDimensionTipSql******************************************:\n" + ksq);
                }
            } else {
                from = this.getPageFromIndex(condition);
                len = condition.getOnePageRows();
                if (condition.getDimension() == 1) {
                    if (StringUtils.isEmpty((String)condition.getCompanyId())) {
                        sql = this.getCompanyDimensionMainPageSql(condition);
                        cols = COL_LIST_MAIN_COMPANY;
                        ksq = sp.getSqlWithParams(sql);
                        MobileUtil.debugLog(logger, "getCompanyDimensionMainPageSql******************************************:\n" + ksq);
                    } else {
                        sql = this.getCompanyDimensionDetailPageSql(condition);
                        sp.addString(condition.getCompanyId());
                        cols = COL_LIST_DETAIL_CPMPANY;
                        ksq = sp.getSqlWithParams(sql);
                        MobileUtil.debugLog(logger, "getCompanyDimensionDetailPageSql******************************************:\n" + ksq);
                    }
                } else if (StringUtils.isEmpty((String)condition.getTmplGroup())) {
                    sql = this.getReportDimensionMainPageSql(condition);
                    cols = COL_LIST_MAIN_REPORT;
                    ksq = sp.getSqlWithParams(sql);
                    MobileUtil.debugLog(logger, "getReportDimensionMainPageSql******************************************:\n" + ksq);
                } else {
                    sql = this.getReportDimensionDetailPageSql(condition);
                    sp.addString(condition.getTmplGroup());
                    cols = COL_LIST_DETAIL_REPORT;
                    ksq = sp.getSqlWithParams(sql);
                    MobileUtil.debugLog(logger, "getReportDimensionDetailPageSql******************************************:\n" + ksq);
                }
            }
            rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)sp, (int)from, (int)len, (Connection)con);
            while (rs != null && rs.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                for (int i = 0; i < cols.length; ++i) {
                    row.put(cols[i], String.valueOf(rs.getObject(cols[i])));
                }
                rst.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    private void handleUserDefaultOrgAndBaseCurrency(Context ctx, ReportQueryCondition c) throws BOSException, EASBizException {
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(c.getUserId()));
        FullOrgUnitInfo unitInfo = userInfo.getDefOrgUnit();
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("where id='" + unitInfo.getId().toString() + "' or id ='00000000-0000-0000-0000-000000000000CCE7AED4' order by id desc");
        if (col.size() > 0) {
            c.setCurrencyId(col.get(0).getBaseCurrency().getId().toString());
        }
    }

    private int getPageFromIndex(ReportQueryCondition c) {
        return (c.getPageNumber() - 1) * c.getOnePageRows();
    }

    private String getReportDimensionMainPageSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        String[] cols = COL_LIST_MAIN_REPORT;
        String groupColumn = "tgroup, tmplName";
        if (cols.length > 2) {
            groupColumn = cols[0] + " ," + cols[1];
        }
        sql.append(" SELECT * FROM (").append(" SELECT " + groupColumn + ", max(tmplNumber) tmplNumber, max(sourceType) sourceType, \n").append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.tgroup=r1.tgroup \n").append(" AND R2.auditedStatus = 2 AND r2.isReport = 0) AS unweave, \n").append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.tgroup=r1.tgroup \n").append(" AND R2.auditedStatus >=1 AND r2.committedStatus =1 AND r2.isReport = 1) AS weave, \n").append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.tgroup=r1.tgroup \n").append(" AND R2.auditedStatus = 2 AND r2.committedStatus =2 AND r2.isReport = 1) AS committed, \n").append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.tgroup=r1.tgroup \n").append(" AND R2.auditedStatus = 2 AND r2.committedStatus =3 AND r2.isReport = 1) AS received \n").append(" FROM ").append(c.getTable()).append(" r1 ");
        if (c.getSearchTxt() != null) {
            sql.append(" WHERE (tmplName LIKE '%" + c.getSearchTxt().trim() + "%' OR tmplNumber LIKE '" + c.getSearchTxt().trim() + "%')");
        }
        sql.append(" GROUP BY " + groupColumn + ") a ORDER by sourceType,tmplNumber");
        return sql.toString();
    }

    private String getReportDimensionDetailPageSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT ");
        for (int i = 0; i < COL_LIST_DETAIL_REPORT.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(COL_LIST_DETAIL_REPORT[i]);
        }
        sql.append(" FROM ").append(c.getTable()).append(" WHERE tgroup = ? ");
        if (1 == c.getWeaveState()) {
            sql.append(" AND isReport = 0 ");
        } else if (2 == c.getWeaveState()) {
            sql.append(" AND auditedstatus >= 1 AND committedStatus =1 AND isReport = 1 ");
        } else if (3 == c.getWeaveState()) {
            sql.append(" AND auditedstatus = 2 AND committedStatus =2 AND isReport = 1 ");
        } else {
            sql.append(" AND auditedstatus = 2 AND committedStatus =3 AND isReport = 1 ");
        }
        if (c.getSearchTxt() != null) {
            sql.append(" AND (companyName LIKE '%" + c.getSearchTxt().trim() + "%' OR companyDisplayName LIKE '%" + c.getSearchTxt().trim() + "%')");
        }
        sql.append(" order by 1 ");
        return sql.toString();
    }

    private String getCompanyDimensionMainPageSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        String[] cols = COL_LIST_MAIN_COMPANY;
        String groupColumns = "companyID, companyDisplayName, longnumber, flevel";
        if (cols.length > 4) {
            groupColumns = cols[0] + " ," + cols[1] + " ," + cols[2] + " ," + cols[3];
        }
        sql.append(" SELECT * from (");
        sql.append(" SELECT " + groupColumns + ", Max(isUnit) isUnit, \n");
        sql.append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.companyID=r1.companyID \n");
        sql.append(" AND R2.auditedStatus = 2 AND r2.isReport = 0) AS unweave, \n");
        sql.append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.companyID=r1.companyID \n");
        sql.append(" AND R2.auditedStatus >=1 AND r2.committedStatus =1 AND r2.isReport = 1) AS weave, \n");
        sql.append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.companyID=r1.companyID \n");
        sql.append(" AND R2.auditedStatus = 2 AND r2.committedStatus =2 AND r2.isReport = 1) AS committed, \n");
        sql.append(" (SELECT count(1) FROM ").append(c.getTable()).append(" r2 WHERE r2.companyID=r1.companyID \n");
        sql.append(" AND R2.auditedStatus = 2 AND r2.committedStatus =3 AND r2.isReport = 1) AS received \n");
        sql.append(" FROM ").append(c.getTable()).append(" r1 WHERE 1=1 \n");
        if (!StringUtils.isEmpty((String)c.getSearchTxt())) {
            sql.append(" AND (companyName LIKE '%" + c.getSearchTxt().trim() + "%' \n");
            sql.append(" OR companyNum LIKE '" + c.getSearchTxt().trim() + "%' \n");
            sql.append(" OR companyDisplayName LIKE '%" + c.getSearchTxt().trim() + "%') \n");
        } else if (StringUtils.isEmpty((String)c.getLongNumber())) {
            sql.append(" AND (flevel=1 OR flevel=2) \n");
        } else {
            sql.append(" AND longnumber LIKE '" + c.getLongNumber() + "!%' \n");
            int level = c.getFlevel();
            if (level == 0) {
                level = c.getLongNumber().split("!").length;
            }
            sql.append(" AND flevel = " + ++level + " \n");
        }
        sql.append(" GROUP BY " + groupColumns + " \n");
        sql.append(") a ORDER BY longnumber");
        return sql.toString();
    }

    private String getCompanyDimensionDetailPageSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT ");
        for (int i = 0; i < COL_LIST_DETAIL_CPMPANY.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(COL_LIST_DETAIL_CPMPANY[i]);
        }
        sql.append(" FROM ").append(c.getTable()).append(" WHERE companyID = ? ");
        if (1 == c.getWeaveState()) {
            sql.append(" AND isReport = 0 ");
        } else if (2 == c.getWeaveState()) {
            sql.append(" AND auditedstatus >= 1 AND committedStatus = 1 AND isReport = 1 ");
        } else if (3 == c.getWeaveState()) {
            sql.append(" AND auditedstatus = 2 AND committedStatus = 2 AND isReport = 1 ");
        } else {
            sql.append(" AND auditedstatus = 2 AND committedStatus =3 AND isReport = 1 ");
        }
        if (c.getSearchTxt() != null) {
            sql.append(" AND (tmplName LIKE '%" + c.getSearchTxt().trim() + "%'  OR tmplNumber LIKE '" + c.getSearchTxt().trim() + "%')");
        }
        sql.append(" order by 1 ");
        return sql.toString();
    }

    private String getCompanyDimensionTipSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT * FROM (");
        sql.append(" SELECT DISTINCT ");
        for (int i = 0; i < COL_TIP_REPORT.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(COL_TIP_REPORT[i]);
        }
        sql.append(" FROM ").append(c.getTable());
        sql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)c.getCompanyId())) {
            sql.append(" AND companyID = '" + c.getCompanyId() + "' ");
            if (1 == c.getWeaveState()) {
                sql.append(" AND isReport = 0 ");
            } else if (2 == c.getWeaveState()) {
                sql.append(" AND auditedstatus >= 1 AND committedStatus =1 AND isReport = 1 ");
            } else if (3 == c.getWeaveState()) {
                sql.append(" AND auditedstatus = 2 AND committedStatus =2 AND isReport = 1 ");
            } else {
                sql.append(" AND auditedstatus = 2 AND committedStatus =3 AND isReport = 1 ");
            }
        }
        String st = c.getSearchTxt() == null ? "" : c.getSearchTxt();
        sql.append(" AND (tmplName LIKE '%" + st.trim() + "%'  OR tmplNumber LIKE '" + st.trim() + "%')");
        sql.append(" ) a ORDER BY 1 ");
        return sql.toString();
    }

    private String getReportDimensionTipSql(ReportQueryCondition c) {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" SELECT * FROM (");
        sql.append(" SELECT DISTINCT ");
        for (int i = 0; i < COL_TIP_COMPANY.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(COL_TIP_COMPANY[i]);
        }
        sql.append(" FROM ").append(c.getTable());
        sql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)c.getTmplGroup())) {
            sql.append(" AND tgroup = '" + c.getTmplGroup() + "' ");
            if (1 == c.getWeaveState()) {
                sql.append(" AND isReport = 0 ");
            } else if (2 == c.getWeaveState()) {
                sql.append(" AND auditedstatus >= 1 AND committedStatus =1 AND isReport = 1 ");
            } else if (3 == c.getWeaveState()) {
                sql.append(" AND auditedstatus = 2 AND committedStatus =2 AND isReport = 1 ");
            } else {
                sql.append(" AND auditedstatus = 2 AND committedStatus =3 AND isReport = 1 ");
            }
        }
        String st = c.getSearchTxt() == null ? "" : c.getSearchTxt();
        sql.append(" AND (companyName LIKE '%" + st.trim() + "%'  OR companyNum LIKE '" + st.trim() + "%'  OR companyDisplayName LIKE '%" + st.trim() + "%')");
        sql.append(" ) a ORDER BY 1 ");
        return sql.toString();
    }

    private void insertData2Table(Context ctx, ReportQueryCondition condition) throws BOSException, EASBizException {
        if (this.isNewQuery(condition)) {
            ParamTempTblService unitSrv = this.getAuthorizedOrgsTmpTblSrv(ctx, condition);
            String tblName = unitSrv.getTmpTableName();
            this.createTempTableIndex(ctx, tblName);
            this.insertRptData2Table(ctx, condition, tblName);
            this.insertTmplData2Table(ctx, condition, tblName);
            unitSrv.release();
        }
    }

    private void createTempTableIndex(Context ctx, String tblName) throws BOSException {
        TempTableJdbcTemplate tableJdbcTemplate = new TempTableJdbcTemplate(ctx);
        StringBuffer columns = new StringBuffer();
        columns.append("id");
        tableJdbcTemplate.createIndex(tblName, columns.toString(), true, false);
        tableJdbcTemplate.analyzeTable(tblName);
    }

    private void insertTmplData2Table(Context ctx, ReportQueryCondition c, String tblName) throws BOSException, EASBizException {
        String sql = this.getInsertTmplDataSql(ctx, c, tblName);
        Object[] params = new Object[]{c.getRptPeriodType(), c.getOrgTreeId(), c.getOrgTreeId(), c.getRptPeriodType()};
        String title = "insertTmplData2TableSql";
        this.doDebugLog(sql, params, title);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void insertRptData2Table(Context ctx, ReportQueryCondition c, String tblName) throws BOSException, EASBizException {
        String sql = this.getInsertRptDataSql(ctx, c, tblName);
        Object[] params = new Object[]{c.getOrgTreeId(), c.getCurrencyId(), c.getRptYear(), c.getRptPeriod(), c.getRptPeriodType(), c.getOrgTreeId(), c.getCurrencyId(), c.getRptYear(), c.getRptPeriod(), c.getRptPeriodType()};
        String title = "insertRptData2TableSql";
        this.doDebugLog(sql, params, title);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void doDebugLog(String sql, Object[] params, String title) {
        try {
            String kql = PsSql.getSqlWithParams((Object)sql, (Object[])params, (int)7, (boolean)false);
            MobileUtil.debugLog(logger, title + "******************************************:\n" + kql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String getInsertTmplDataSql(Context ctx, ReportQueryCondition condition, String tblName) throws BOSException {
        StringBuilder sql = new StringBuilder(1000);
        sql.append(" INSERT INTO ").append(condition.getTable()).append(" SELECT * FROM ( \n").append(this.getTmplSelectPartSql(ctx)).append(" FROM T_RPT_Template template \n").append(" INNER JOIN (Select distinct d.fdispensesrcid,d.fcompanyid companyid \n").append(" FROM T_CSL_TempletDispense d \n").append(" INNER JOIN t_rpt_template template ON d.fdispensesrcid = template.fid \n").append(" INNER JOIN ").append(tblName).append(" temptable ON temptable.id = d.fcompanyid \n").append(" WHERE template.fversionstatus = 1 AND template.FIsFreezed = 0 and template.fperiodtype = ? \n").append(" AND d.FOrgBoundId = ? AND template.FTemplateType in (3,5,6,10,11,13,15,17,18)) AS disp \n").append(" ON template.fid = disp.fdispensesrcid \n").append(" INNER JOIN t_org_BaseUnit unit ON disp.CompanyID = unit.FID \n").append(" INNER JOIN T_org_Structure s ON s.FUnitId = unit.FID \n").append(" WHERE s.FTreeId = ? AND template.FTemplateType not in(4,19) AND NOT EXISTS \n").append(" (SELECT 'X' \n").append(" FROM T_RPT_Template t \n").append(" INNER JOIN ").append(tblName).append(" temp ON temp.id = t.FCompanyID \n").append(" WHERE t.FVersionStatus = 1 AND t.fisfreezed = 0 AND t.fperiodtype = ? \n").append(" AND t.FTemplateType in (2,12,16) \n").append(" AND template.fid = t.FGroupTemplateID )) t \n").append(" WHERE NOT EXISTS ( \n").append(" SELECT 'X' from ").append(condition.getTable()).append(" t1 \n").append(" WHERE t.tgroup = t1.tgroup AND t.companyID = t1.companyID) \n ");
        return sql.toString();
    }

    private String getInsertRptDataSql(Context ctx, ReportQueryCondition condition, String tblName) throws BOSException {
        StringBuilder sql = new StringBuilder(1000);
        sql.append(" INSERT INTO ").append(condition.getTable()).append(" SELECT * FROM ( \n").append(this.getRptSelectPartSql(ctx)).append(" FROM T_CSL_CSLREPORT rpt \n").append(" JOIN T_ORG_BASEUNIT unit ON rpt.FCompanyID = unit.FId \n").append(" JOIN T_RPT_TEMPLATE tmpl ON rpt.FTemplateId = tmpl.FId \n").append(" JOIN T_BD_CURRENCY curr ON curr.FId = rpt.FCurrencyId \n").append(" JOIN T_ORG_STRUCTURE s ON s.FUnitId = unit.FId \n").append(" INNER JOIN ").append(tblName).append(" temp ON temp.id = unit.FID \n").append(" WHERE s.FTreeId = ? AND unit.FIsUnion = 0 AND curr.FID = ? \n").append(" AND rpt.Fyear = ? AND rpt.FPeriod = ? AND rpt.FPeriodType = ? \n").append(" AND rpt.FSourceType in (7,10,13) \n").append(" UNION ALL \n").append(this.getRptSelectPartSql(ctx)).append(" FROM T_CSL_CSLREPORT rpt \n").append(" JOIN T_ORG_BASEUNIT unit ON rpt.FOrgUnitID = unit.FId \n").append(" JOIN T_ORG_TREE tree ON tree.FID = rpt.FOrgTreeId \n").append(" JOIN T_RPT_TEMPLATE tmpl ON rpt.FTemplateId = tmpl.FId \n").append(" JOIN T_BD_CURRENCY curr ON curr.FId = rpt.FCurrencyId \n").append(" JOIN T_ORG_STRUCTURE s ON s.FUnitId = unit.FId AND s.FTreeId = tree.FID \n").append(" INNER JOIN ").append(tblName).append(" temptable ON temptable.id = unit.FID \n").append(" WHERE tree.FId = ? AND unit.FIsUnion = 1 AND curr.FID = ? \n").append(" AND rpt.Fyear = ? AND rpt.FPeriod = ? AND rpt.FPeriodType = ? AND rpt.FSourceType in (2,3,11,12,14,15) \n").append(") a");
        return sql.toString();
    }

    private String getRptSelectPartSql(Context ctx) {
        String lan = ctx.getLocale().getLanguage();
        StringBuffer selectSql = new StringBuffer(200);
        selectSql.append(" SELECT rpt.FID ID,unit.FID companyID,\n").append(" CASE WHEN TRIM(unit.FSimpleName) IS NULL THEN unit.FName_" + lan + " ELSE unit.FSimpleName END companyDisplayName, \n").append(" unit.FName_" + lan + " companyName,\n").append(" unit.FNumber,s.Flongnumber longNumber,s.FLevel,unit.FISUnion, \n").append(" rpt.FSourceType sourceType,rpt.FNumber rptNumber,rpt.FName rptName, \n").append(" rpt.FPeriodType periodType,tmpl.FName tmplName,tmpl.FNumber tmplNumber, \n").append(" rpt.FAuditedStatus auditedStatus,rpt.FCommittedStatus committedStatus, \n").append(" 1 as status,tmpl.FGroup tgroup,tmpl.FID tmplId \n");
        return selectSql.toString();
    }

    private String getTmplSelectPartSql(Context ctx) {
        String lan = ctx.getLocale().getLanguage();
        StringBuffer selectSql = new StringBuffer(200);
        selectSql.append(" SELECT template.FID ID,unit.FID companyID,").append(" CASE WHEN TRIM(unit.FSimpleName) IS NULL THEN unit.FName_" + lan + " ELSE unit.FSimpleName END companyDisplayName, \n").append(" unit.FName_" + lan + " companyName, \n").append(" unit.FNumber,s.Flongnumber longNumber, s.FLevel,unit.FISUnion, \n").append(" template.FTemplateType sourceType,template.FNumber rptNumber,template.FName rptName, \n").append(" template.FPeriodType periodType, template.FName tmplName,template.FNumber tmplNumber, \n").append(" template.FAuditedStatus auditedStatus,-1 as committedStatus,\n").append(" 0 as status,template.FGroup tgroup,template.FID tmplId \n");
        return selectSql.toString();
    }

    private ParamTempTblService getAuthorizedOrgsTmpTblSrv(Context ctx, ReportQueryCondition condition) throws EASBizException, BOSException {
        Map unitMap = CslOrgTreeUtil.getAuthorizedOrgs(ctx, (IObjectPK)new ObjectUuidPK(condition.getUserId()), (IObjectPK)new ObjectUuidPK(condition.getOrgTreeId()), true);
        TableInfo table = new TableInfo("T_RPTMONITOR_UNIT");
        table.addColumn("id");
        return new ParamTempTblService(ctx, table, unitMap.keySet(), null);
    }

    private void handleTmpTable(Context ctx, ReportQueryCondition condition) throws BOSException {
        if (this.isNewQuery(condition)) {
            this.releaseTable(ctx, condition.getTable());
            condition.setTable(ReportProcMonitorFacadeControllerBean.createTmpTable(ctx));
        }
    }

    private boolean isNewQuery(ReportQueryCondition c) {
        return c.isRefresh();
    }

    private void releaseTable(Context ctx, String table) {
        if (!StringUtils.isEmpty((String)table)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(table);
        }
    }

    public static String createTmpTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(400);
        createSql.append(" CREATE TABLE Tmp_ReportProcMonitor_Table(").append(" ID VARCHAR(44),companyID VARCHAR(44),companyDisplayName NVARCHAR(80), ").append(" companyName NVARCHAR(80),companyNum NVARCHAR(80),longNumber NVARCHAR(200),flevel INT, isUnit INT,").append(" sourceType INT,rptNumber NVARCHAR(80),rptName NVARCHAR(80),").append(" periodType INT,tmplName NVARCHAR(80),tmplNumber NVARCHAR(80),").append(" auditedStatus INT, committedStatus INT,").append(" isReport INT,tgroup VARCHAR(44),tmplId VARCHAR(44))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "isReport,auditedStatus,committedStatus,companyID", false, false);
            pool.createIndex(tableName, "isReport,auditedStatus,committedStatus,tgroup", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    @Override
    protected Map _receive(Context ctx, ReportQueryCondition condition) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.doReceive(ctx, condition);
            result.put("key_state", "SUCCESS");
        }
        catch (Exception e) {
            result.put("key_state", "FAIL");
            logger.error((Object)e);
        }
        return result;
    }

    private void doReceive(Context ctx, ReportQueryCondition condition) throws BOSException, EASBizException {
        String ids = condition.getExt();
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        String[] idArr = ids.split(",");
        RPTDataServiceFactory.getLocalInstance(ctx).shortcutReceive(Arrays.asList(idArr), condition.getUserId(), condition.getOrgTreeId());
    }

    @Override
    protected Map _sendBack(Context ctx, ReportQueryCondition condition) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("key_tempTable", condition.getTable());
        try {
            this.doSendBack(ctx, condition);
            result.put("key_state", "SUCCESS");
        }
        catch (Exception e) {
            result.put("key_state", "FAIL");
            logger.error((Object)e);
        }
        return result;
    }

    private void doSendBack(Context ctx, ReportQueryCondition condition) throws BOSException, EASBizException {
        String ext = condition.getExt();
        String[] ids = null;
        if (!StringUtils.isEmpty((String)ext)) {
            ids = ext.split(",");
        }
        if (ids == null || ids.length == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"9_reportid", (Locale)ctx.getLocale()));
        }
        RPTDataServiceFactory.getLocalInstance(ctx).sendBack(Arrays.asList(ids));
    }
}

