/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynItemFillData {
    private static Logger LOGGER = Logger.getLogger(DynItemFillData.class);
    private String formulaName;
    private List fourmulaFilterList;
    private Set fillItemSet;
    private CompanyOrgUnitInfo currentUnit;
    private Context ctx;
    private String fieldHg;
    private boolean isExecuteError = false;
    private List asstActTypeList = null;
    private Map useredAsstActTypes = null;
    private Map<String, List<String>> asstActType_values = new HashMap<String, List<String>>();
    private String tmpTableName = null;
    private boolean isSameYearPeriod = true;
    private String sameYear = null;
    private String samePeriod = null;
    private boolean isSameOrgUnit = true;
    private String sameOrgUnitId = null;
    private boolean isSameCurrency = true;
    private String sameCurrencyId = null;
    private boolean isGroupByFormulaId = false;
    private String filterSqls = null;

    public DynItemFillData(Context ctx, List fourmulaFilterList, String fieldHg, CompanyOrgUnitInfo currentUnit) {
        this.ctx = ctx;
        this.fourmulaFilterList = fourmulaFilterList;
        this.fieldHg = fieldHg;
        this.currentUnit = currentUnit;
        this.fillItemSet = new HashSet();
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, String fieldHg, CompanyOrgUnitInfo currentUnit, String filterSqls, boolean isGroupByFormulaId) {
        this(ctx, fourmulaFilterList, fieldHg, currentUnit);
        this.isGroupByFormulaId = isGroupByFormulaId;
        this.filterSqls = filterSqls;
    }

    public DynItemFillData(Context ctx, List fourmulaFilterList, List asstActTypeList, Map useredAsstActTypes, CompanyOrgUnitInfo currentUnit) {
        this.ctx = ctx;
        this.fourmulaFilterList = fourmulaFilterList;
        this.currentUnit = currentUnit;
        this.asstActTypeList = asstActTypeList;
        this.useredAsstActTypes = useredAsstActTypes;
        this.fillItemSet = new HashSet();
    }

    public void createFillDate() throws EASBizException, BOSException {
        try {
            this.preHandleStartPeriod();
            this.fillItemSet = this.getFillItemData();
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getFillDataByFormulaGroup() throws EASBizException, BOSException {
        try {
            this.preHandleStartPeriod();
            StringBuffer sql = this.getExecutesql();
            if (DebugLogger.isDebug) {
                LOGGER.error((Object)sql);
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
                if (rs != null) {
                    while (rs.next()) {
                        String id = rs.getString("ID");
                        String formulaId = rs.getString("formulaId");
                        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)formulaId)) continue;
                        Set<String> ids = resultMap.get(formulaId);
                        if (ids == null) {
                            ids = new HashSet<String>();
                            resultMap.put(formulaId, ids);
                        }
                        ids.add(id);
                    }
                }
                HashMap<String, Set<String>> hashMap = resultMap;
                return hashMap;
            }
            catch (SQLException e) {
                this.isExecuteError = true;
                LOGGER.error((Object)"getFillItemData", (Throwable)e);
                if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                    this.tmpTableName = null;
                }
            }
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
        return null;
    }

    public Map getMultiFillDate() throws EASBizException, BOSException {
        try {
            this.preHandleStartPeriod();
            Map map = this.getMultiFillItemData();
            return map;
        }
        finally {
            if (!StringUtils.isEmpty((String)this.tmpTableName) && !DebugLogger.isDebug) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tmpTableName);
                this.tmpTableName = null;
            }
        }
    }

    private Map getMultiFillItemData() throws EASBizException, BOSException {
        this.initAsstActType();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getMultiSql("T_GL_AssistBalance"));
        if (DebugLogger.isDebug) {
            LOGGER.error((Object)sql);
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        return this.getMultiResult(rs);
    }

    private Map getMultiResult(IRowSet rs) throws EASBizException, BOSException {
        OneToManyMap result = new OneToManyMap();
        if (rs.size() <= 0) {
            return result;
        }
        AsstActTypeInfo asstActTypeInfo = null;
        IObjectCollection coll = null;
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, IObjectValue> tmpMap = new HashMap<String, IObjectValue>();
        String field = null;
        for (Object obj : this.asstActTypeList) {
            asstActTypeInfo = (AsstActTypeInfo)obj;
            String defaultQueryName = asstActTypeInfo.getDefaultQueryName();
            MetaDataPK queryPK = new MetaDataPK(defaultQueryName);
            QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryPK);
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            field = this.getField(asstActTypeInfo);
            if (!(mainObjectInfo instanceof SubEntityInfo) || (mainEntityInfo = (SubEntityInfo)mainObjectInfo) == null || mainEntityInfo.getEntityRef() == null) continue;
            try {
                while (rs.next()) {
                    ids.add(rs.getString(field));
                }
                rs.beforeFirst();
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            IDynamicObject idynaObj = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            BOSObjectType type = mainEntityInfo.getEntityRef().getType();
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItem(asstActTypeInfo.getMappingFieldName()));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            ev.setFilter(filter);
            coll = idynaObj.getCollection(type, ev);
            for (int i = 0; i < coll.size(); ++i) {
                tmpMap.put(((DataBaseInfo)coll.getObject(i)).getId().toString(), coll.getObject(i));
            }
            for (String id : ids) {
                result.put(asstActTypeInfo.getAsstHGAttribute(), tmpMap.get(id));
            }
            tmpMap.clear();
            ids.clear();
        }
        return result;
    }

    private SelectorItemCollection getSelectorItem(String mappingFieldName) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
            sic.add(new SelectorItemInfo("browseGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else if (mappingFieldName.equals("material")) {
            sic.add(new SelectorItemInfo("materialGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else {
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        }
        return sic;
    }

    private void initAsstActType() throws EASBizException, BOSException {
        AsstActTypeInfo asstActTypeInfo = null;
        String field = null;
        for (Object asstActType : this.useredAsstActTypes.keySet()) {
            asstActTypeInfo = (AsstActTypeInfo)asstActType;
            field = this.getField(asstActTypeInfo);
            this.asstActType_values.put(field, (List)this.useredAsstActTypes.get(asstActType));
        }
    }

    private String getField(AsstActTypeInfo asstActTypeInfo) {
        String field = null;
        field = asstActTypeInfo.getMappingFieldName() == null ? "F" + asstActTypeInfo.getAsstHGAttribute() + "ID" : asstActTypeInfo.getMappingFieldName();
        return field;
    }

    private void preHandleStartPeriod() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            sql.append("create table t_csl_FormulFilter(companyNumber VARCHAR(44),startAccount VARCHAR(44),endAccount VARCHAR(44),");
            sql.append("currency VARCHAR(44),startYear VARCHAR(6),endYear VARCHAR(6),startPeriod VARCHAR(6),endPeriod VARCHAR(6)");
            if (this.isGroupByFormulaId) {
                sql.append(",formulaId VARCHAR(80)");
            }
            sql.append(")");
            this.tmpTableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Object[][] allParams = new Object[this.fourmulaFilterList.size()][this.isGroupByFormulaId ? 9 : 8];
        PeriodInfo periodInfo = this.getPeriodInfo();
        this.handleSame(periodInfo);
        for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
            FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
            allParams[i][0] = formulaFilterInfo.getCompanyNumber();
            allParams[i][1] = formulaFilterInfo.getStartAccount();
            allParams[i][2] = formulaFilterInfo.getEndAccount();
            allParams[i][3] = formulaFilterInfo.getCurrency();
            allParams[i][4] = formulaFilterInfo.getStartYear();
            allParams[i][5] = formulaFilterInfo.getEndYear();
            allParams[i][6] = formulaFilterInfo.getStartPeriod();
            allParams[i][7] = formulaFilterInfo.getEndPeriod();
            if (!this.isGroupByFormulaId) continue;
            allParams[i][8] = formulaFilterInfo.getFormulaId();
        }
        sql.setLength(0);
        sql.append(" insert into ").append(this.tmpTableName).append("(companyNumber,startAccount,endAccount,currency");
        sql.append(",startYear,endYear,startPeriod,endPeriod");
        if (this.isGroupByFormulaId) {
            sql.append(",formulaId");
        }
        sql.append(") values(?,?,?,?,?,?,?,?");
        if (this.isGroupByFormulaId) {
            sql.append(",?");
        }
        sql.append(") ");
        CslRptUtil.batchExecute(this.ctx, sql.toString(), allParams);
    }

    private void handleSame(PeriodInfo periodInfo) throws EASBizException, BOSException {
        CurrencyCollection coll;
        String tempCompanyNumber = null;
        String tempCurrency = null;
        for (int i = 0; i < this.fourmulaFilterList.size(); ++i) {
            FormulaFilterInfo formulaFilterInfo = (FormulaFilterInfo)this.fourmulaFilterList.get(i);
            if (formulaFilterInfo.getEndYear().equals(String.valueOf(periodInfo.getPeriodYear())) && Integer.valueOf(formulaFilterInfo.getEndPeriod()) > periodInfo.getPeriodNumber() || Integer.valueOf(formulaFilterInfo.getEndYear()) > periodInfo.getPeriodYear()) {
                formulaFilterInfo.setStartYear(String.valueOf(periodInfo.getPeriodYear()));
                formulaFilterInfo.setStartPeriod(String.valueOf(periodInfo.getPeriodNumber()));
            }
            if (i == 0) {
                tempCompanyNumber = formulaFilterInfo.getCompanyNumber();
                tempCurrency = formulaFilterInfo.getCurrency();
            }
            if (this.isSameYearPeriod && formulaFilterInfo.getStartPeriod().equals(formulaFilterInfo.getEndPeriod()) && formulaFilterInfo.getStartYear().equals(formulaFilterInfo.getEndYear())) {
                if (i == 0) {
                    this.samePeriod = formulaFilterInfo.getStartPeriod();
                    this.sameYear = formulaFilterInfo.getStartYear();
                } else if (!this.samePeriod.equals(formulaFilterInfo.getStartPeriod()) || !this.sameYear.equals(formulaFilterInfo.getStartYear())) {
                    this.isSameYearPeriod = false;
                }
            } else {
                this.isSameYearPeriod = false;
            }
            if (tempCompanyNumber != null && !tempCompanyNumber.equals(formulaFilterInfo.getCompanyNumber()) || tempCompanyNumber == null && formulaFilterInfo.getCompanyNumber() != null) {
                this.isSameOrgUnit = false;
            }
            if ((tempCurrency == null || tempCurrency.equals(formulaFilterInfo.getCurrency())) && (tempCurrency != null || formulaFilterInfo.getCurrency() == null)) continue;
            this.isSameCurrency = false;
        }
        if (this.isSameOrgUnit && !StringUtils.isEmpty(tempCompanyNumber)) {
            this.sameOrgUnitId = tempCompanyNumber.equals(this.currentUnit.getNumber()) ? this.currentUnit.getId().toString() : OrgUnitFactory.getLocalInstance((Context)this.ctx).getOrgUnitInfo("select id where number='" + tempCompanyNumber + "'").getId().toString();
        }
        if (this.isSameCurrency && !StringUtils.isEmpty(tempCurrency) && (coll = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection("select id where number='" + tempCurrency + "'")) != null) {
            this.sameCurrencyId = coll.get(0).getId().toString();
        }
    }

    private Set getFillItemData() throws EASBizException, BOSException {
        HashSet<String> fillItemSet = new HashSet<String>();
        StringBuffer sql = this.getExecutesql();
        if (DebugLogger.isDebug) {
            LOGGER.error((Object)sql);
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs != null) {
                while (rs.next()) {
                    if (StringUtils.isEmpty((String)rs.getString("ID"))) continue;
                    fillItemSet.add(rs.getString("ID"));
                }
            }
        }
        catch (SQLException e) {
            this.isExecuteError = true;
            LOGGER.error((Object)"getFillItemData", (Throwable)e);
        }
        return fillItemSet;
    }

    private StringBuffer getMultiSql(String tableName) throws EASBizException, BOSException {
        StringBuffer sBuf = new StringBuffer("select distinct ");
        String curField = null;
        HashMap<String, AsstActTypeInfo> field_AsstAct = new HashMap<String, AsstActTypeInfo>();
        for (Object obj : this.asstActTypeList) {
            curField = this.getField((AsstActTypeInfo)obj);
            if (this.asstActType_values.containsKey(curField)) {
                sBuf.append("A_Hg.").append(curField).append(" as ").append(curField).append(",");
            } else {
                sBuf.append(" null as ").append(curField).append(",");
            }
            field_AsstAct.put(curField, (AsstActTypeInfo)obj);
        }
        sBuf.deleteCharAt(sBuf.lastIndexOf(","));
        sBuf.append(" from T_BD_AssistantHG A_Hg  \n");
        String realtionTable = null;
        String tableAsName = null;
        String numberInStr = null;
        for (String field : this.asstActType_values.keySet()) {
            if (this.asstActType_values.get(field) == null || this.asstActType_values.get(field).isEmpty()) continue;
            tableAsName = ((AsstActTypeInfo)field_AsstAct.get(field)).getAsstHGAttribute();
            realtionTable = ((AsstActTypeInfo)field_AsstAct.get(field)).getRealtionDataObject();
            sBuf.append("inner join ").append(realtionTable).append(" ").append(tableAsName).append(" on ").append(tableAsName).append(".fid=A_Hg.").append(field);
            numberInStr = CslRptUtil.list2String(this.asstActType_values.get(field), ",", true);
            if (StringUtils.isEmpty((String)numberInStr) || StringUtils.isEmpty((String)numberInStr.replaceAll("'", "").trim())) continue;
            sBuf.append(" and fnumber in (").append(CslRptUtil.list2String(this.asstActType_values.get(field), ",", true)).append(")  \n");
        }
        sBuf.append(" inner join " + tableName + " A_Bal on A_Bal.FAssistGrpID = A_Hg.fid  \n");
        sBuf.append("inner join (select account1.* from T_BD_AccountView isNotLeaf, ").append(this.tmpTableName).append(" accountA ");
        sBuf.append(", T_BD_AccountView  account1 where isNotLeaf.fnumber>=accountA.startAccount and ");
        sBuf.append(" isNotLeaf.fnumber<=accountA.endAccount and isNotLeaf.fisleaf<>1 and account1.fnumber like concat(isNotLeaf.fnumber,'%') ");
        sBuf.append(" and isNotLeaf.FCompanyID = account1.FCompanyID and isNotLeaf.FAccountTableID = account1.FAccountTableID ");
        sBuf.append(" and isNotLeaf.FCompanyID ='").append(this.currentUnit.getId().toString()).append("'");
        sBuf.append(" union ");
        sBuf.append("select leaf.* from T_BD_AccountView leaf, ").append(this.tmpTableName).append(" accountB ");
        sBuf.append(" where leaf.fnumber>=accountB.startAccount and leaf.fnumber<=accountB.endAccount ");
        sBuf.append(" and leaf.FCompanyID ='").append(this.currentUnit.getId().toString()).append("'");
        sBuf.append(" and leaf.fisleaf=1) accountV on accountV.FID = A_Bal.fAccountid \n");
        sBuf.append(" inner join T_BD_Currency currency on currency.FID = A_Bal.fcurrencyid   \n");
        sBuf.append(" inner join T_ORG_BaseUnit baseunit on baseunit.FID = A_Bal.forgunitid \n");
        sBuf.append(" inner join ").append(this.tmpTableName).append(" as filter on (currency.fnumber = filter.currency ");
        sBuf.append(" and filter.companyNumber = baseunit.fnumber ");
        if (this.isSameYearPeriod) {
            sBuf.append(" ) ");
            sBuf.append(" where  A_Bal.fperiodyear='").append(this.sameYear).append("' ");
            sBuf.append(" and  A_Bal.FPeriodNumber='").append(this.samePeriod).append("' ");
        } else {
            sBuf.append(" and filter.endYear > A_Bal.fperiodyear and filter.startYear <  A_Bal.fperiodyear ");
            sBuf.append("  or (filter.endYear = A_Bal.fperiodyear and filter.endPeriod>=A_Bal.FPeriodNumber ");
            sBuf.append("   or filter.startYear = A_Bal.fperiodyear and filter.startPeriod<=A_Bal.FPeriodNumber) ) ");
        }
        sBuf.append(" order by ");
        int k = 0;
        for (String field : this.asstActType_values.keySet()) {
            if (k != 0) {
                sBuf.append(",");
            }
            sBuf.append("A_Hg.").append(field);
            ++k;
        }
        sBuf.append(" asc ");
        return sBuf;
    }

    private StringBuffer getExecutesql() throws EASBizException, BOSException {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("select distinct A_Hg.");
        sBuf.append(this.fieldHg).append(" as ID ");
        if (this.isGroupByFormulaId) {
            sBuf.append(",accountV.formulaId ");
        }
        sBuf.append("from T_BD_AssistantHG A_Hg  \n");
        sBuf.append(" inner join T_GL_AssistBalance A_Bal on A_Bal.FAssistGrpID = A_Hg.fid  \n");
        sBuf.append("inner join (select account1.fid ").append(this.isGroupByFormulaId ? ",accountA.formulaId" : "");
        sBuf.append("  \t\tfrom T_BD_AccountView isNotLeaf, ").append(this.tmpTableName).append(" accountA ");
        sBuf.append("\t\t, T_BD_AccountView  account1 where isNotLeaf.fnumber>=accountA.startAccount and ");
        sBuf.append(" \t\tisNotLeaf.fnumber<=accountA.endAccount and isNotLeaf.fisleaf<>1 and account1.fnumber like concat(isNotLeaf.fnumber,'%') ");
        sBuf.append("   \tand isNotLeaf.FCompanyID = account1.FCompanyID and isNotLeaf.FAccountTableID = account1.FAccountTableID ");
        sBuf.append(" \t\tand isNotLeaf.FCompanyID ='").append(this.currentUnit.getId().toString()).append("'");
        sBuf.append(" \tunion ");
        sBuf.append("\tselect leaf.fid ").append(this.isGroupByFormulaId ? ",accountB.formulaId" : "");
        sBuf.append(" \t\tfrom T_BD_AccountView leaf, ").append(this.tmpTableName).append(" accountB ");
        sBuf.append(" \t\twhere leaf.fnumber>=accountB.startAccount and leaf.fnumber<=accountB.endAccount ");
        sBuf.append(" \t\tand leaf.FCompanyID ='").append(this.currentUnit.getId().toString()).append("'");
        sBuf.append(" \t\tand leaf.fisleaf=1) accountV on accountV.FID = A_Bal.fAccountid \n");
        if (this.isSameOrgUnit && this.isSameCurrency) {
            if (this.isSameYearPeriod) {
                sBuf.append(" where  A_Bal.fperiodyear='").append(this.sameYear).append("' ");
                sBuf.append(" and  A_Bal.FPeriodNumber='").append(this.samePeriod).append("' ");
            } else {
                sBuf.append(" inner join ").append(this.tmpTableName).append(" as filter ");
                sBuf.append(" on (filter.endYear > A_Bal.fperiodyear and filter.startYear <  A_Bal.fperiodyear ");
                sBuf.append("  or (filter.endYear = A_Bal.fperiodyear and filter.endPeriod>=A_Bal.FPeriodNumber ");
                sBuf.append("   or filter.startYear = A_Bal.fperiodyear and filter.startPeriod<=A_Bal.FPeriodNumber) ) ");
                sBuf.append(" where 1=1 ");
            }
            sBuf.append(" and  A_Bal.forgunitid='").append(this.sameOrgUnitId).append("' ");
            sBuf.append(" and  A_Bal.fcurrencyid='").append(this.sameCurrencyId).append("' ");
        } else {
            sBuf.append(" inner join T_BD_Currency currency on currency.FID = A_Bal.fcurrencyid   \n");
            sBuf.append(" inner join T_ORG_BaseUnit baseunit on baseunit.FID = A_Bal.forgunitid \n");
            sBuf.append(" inner join ").append(this.tmpTableName).append(" as filter on (currency.fnumber = filter.currency ");
            sBuf.append(" and filter.companyNumber = baseunit.fnumber  ");
            if (this.isSameYearPeriod) {
                sBuf.append(" ) ");
                sBuf.append(" where  A_Bal.fperiodyear='").append(this.sameYear).append("' ");
                sBuf.append(" and  A_Bal.FPeriodNumber='").append(this.samePeriod).append("' ");
            } else {
                sBuf.append(" and filter.endYear > A_Bal.fperiodyear and filter.startYear <  A_Bal.fperiodyear ");
                sBuf.append("  or (filter.endYear = A_Bal.fperiodyear and filter.endPeriod>=A_Bal.FPeriodNumber ");
                sBuf.append("   or filter.startYear = A_Bal.fperiodyear and filter.startPeriod<=A_Bal.FPeriodNumber) ) ");
                sBuf.append(" where 1=1 ");
            }
            if (this.isSameOrgUnit) {
                sBuf.append(" and  A_Bal.forgunitid='").append(this.sameOrgUnitId).append("' ");
            }
            if (this.isSameCurrency) {
                sBuf.append(" and  A_Bal.fcurrencyid='").append(this.sameCurrencyId).append("' ");
            }
        }
        if (!StringUtils.isEmpty((String)this.filterSqls)) {
            sBuf.append(" and A_Hg.").append(this.fieldHg).append(" in(").append(this.filterSqls).append(") ");
        }
        if (this.isGroupByFormulaId) {
            sBuf.append(" order by accountV.formulaId ");
        }
        return sBuf;
    }

    private PeriodInfo getPeriodInfo() throws EASBizException, BOSException {
        String companyID = this.currentUnit.getId().toString();
        PeriodInfo periodInfo = null;
        periodInfo = this.currentUnit.isIsBizUnit() ? GlUtils.getCurrentPeriod((Context)this.ctx, (String)companyID) : AcctUtils.getSubCompanyMinCurrentPeriod((Context)this.ctx, (CompanyOrgUnitInfo)this.currentUnit);
        return periodInfo;
    }

    public Set getFillItemSet() {
        return this.fillItemSet;
    }

    public boolean isExecuteError() {
        return this.isExecuteError;
    }
}

