/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.DynaItemFillDataByAcctCash;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.gr.rptintegration.app.DynItemFillData;
import com.kingdee.eas.fi.gr.rptintegration.util.DynaItemFormulaParse;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QueryDynaItemDataHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.rptintegration.app.QueryDynaItemDataHandler");
    private Context _ctx;
    private final String ORG_KEY = "org";
    private final String YEAR_KEY = "year";
    private final String PERIOD_KEY = "period";
    private final String CURRENCY_KEY = "currency";
    private final String PERIODTYPE_KEY = "periodType";
    private final String ACCT_KEY = "acct";
    private final String ASSTREF_KEY = "asstRef";
    private final String FORMULA_KEY = "formula";
    private final String ASST_KEY = "asst";
    private final String FORMULA_ID = "formulaid";
    private Map<String, AsstActTypeInfo> asstTypeCatch = new HashMap<String, AsstActTypeInfo>();

    public QueryDynaItemDataHandler(Context ctx) {
        this._ctx = ctx;
    }

    public Map getDynaItemData(Map filter) throws EASBizException, BOSException {
        try {
            long begin = System.currentTimeMillis();
            String orgNumber = (String)filter.get("org");
            int year = Integer.valueOf(String.valueOf(filter.get("year")));
            int period = Integer.valueOf(String.valueOf(filter.get("period")));
            String currencyNumber = (String)filter.get("currency");
            int periodType = RptPeriodTypeEnum.getEnum((String)String.valueOf(filter.get("periodType"))).getValue();
            List accts = this.convertObjectArrayToList(filter, "acct");
            Map asstRefs = (Map)filter.get("asstRef");
            logger.error((Object)("filter_map_before:" + JSONUtils.convertObjectToJson(filter)));
            CompanyOrgUnitInfo company = null;
            CompanyOrgUnitCollection Coll = CompanyOrgUnitFactory.getLocalInstance((Context)this._ctx).getCompanyOrgUnitCollection("select id,number,name,longnumber,isBizUnit where number = '" + orgNumber + "'");
            if (Coll != null && Coll.size() > 0) {
                company = Coll.get(0);
            }
            if (company != null) {
                if (!PermissionFactory.getLocalInstance((Context)this._ctx).hasFunctionPermission(this._ctx.getCaller(), (IObjectPK)new ObjectStringPK(company.getId().toString()), "rpt_report_calculate")) {
                    throw new BOSException("you have not report calculate permission.");
                }
                HashMap<String, String> formulas = new HashMap<String, String>();
                HashMap<String, List<String>> formulaId_DetailNumbers = new HashMap<String, List<String>>();
                Iterator it = accts.iterator();
                while (it.hasNext()) {
                    ArrayList items = new ArrayList();
                    Map acct = (Map)it.next();
                    String asstRefKey = (String)acct.get("asstRef");
                    if (asstRefs == null || asstRefs.isEmpty() || asstRefs.get(asstRefKey) == null) {
                        acct.put("asst", new ArrayList(items));
                        continue;
                    }
                    String formula = (String)acct.get("formula");
                    if (!formula.startsWith("=")) {
                        formula = "=" + formula;
                    }
                    String formulaId = (String)acct.get("formulaid");
                    formulas.put(formulaId, formula);
                    List itemNums = this.convertObjectArrayToList(asstRefs, asstRefKey);
                    formulaId_DetailNumbers.put(formulaId, itemNums);
                }
                if (!formulas.isEmpty()) {
                    DynaItemFormulaParse formulaParse = new DynaItemFormulaParse(this._ctx, formulas, year, period, (OrgUnitInfo)company, currencyNumber, periodType);
                    formulaParse.formulaParse();
                    formulas.clear();
                    Map<String, String> asst_FilterSqls = this.getAssTypeDetailFitler(formulaId_DetailNumbers, formulaParse);
                    Map<String, List<FormulaFilterInfo>> acctFormulasGroupMap = formulaParse.getAcctFormulasGroupMap();
                    Map<String, Map<String, List<FormulaFilterInfo>>> acctCashGroupMap = formulaParse.getAcctCashformulaFilterGroupMap();
                    HashMap<String, Set<String>> formulaDatas = new HashMap<String, Set<String>>();
                    HashMap<String, Set<String>> removedFormulaIds = new HashMap<String, Set<String>>();
                    this.getSingleDynaItemData(formulaDatas, acctFormulasGroupMap, acctCashGroupMap, company, removedFormulaIds, asst_FilterSqls);
                    if (!formulaDatas.isEmpty()) {
                        it = accts.iterator();
                        while (it.hasNext()) {
                            HashSet<String> items = new HashSet<String>();
                            Map acct = (Map)it.next();
                            String asstRefKey = (String)acct.get("asstRef");
                            String formulaId = (String)acct.get("formulaid");
                            Set srcFroumlaIds = (Set)removedFormulaIds.get(formulaId);
                            if (srcFroumlaIds != null && !srcFroumlaIds.isEmpty()) {
                                for (String curFormulaId : srcFroumlaIds) {
                                    this.getFormulaDyitemNubmers(curFormulaId, formulaDatas, asstRefs, asstRefKey, items);
                                }
                            } else {
                                this.getFormulaDyitemNubmers(formulaId, formulaDatas, asstRefs, asstRefKey, items);
                            }
                            acct.put("asst", new ArrayList<String>(items));
                        }
                    }
                }
            }
            if (filter.containsKey("asstRef")) {
                filter.remove("asstRef");
            }
            long end = System.currentTimeMillis();
            logger.error((Object)("filter_map_after:" + JSONUtils.convertObjectToJson(filter)));
            logger.error((Object)("getDynaItemData[Cost Time:" + (end - begin) + "]"));
            return filter;
        }
        catch (Exception ex) {
            logger.error((Object)"getDynaItemData error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private Map<String, String> getAssTypeDetailFitler(Map<String, List<String>> formulaId_DetailNumbers, DynaItemFormulaParse formulaParse) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        Map<String, List<FormulaFilterInfo>> acctFormulasGroupMap = formulaParse.getAcctFormulasGroupMap();
        Map<String, Map<String, List<FormulaFilterInfo>>> acctCashGroupMap = formulaParse.getAcctCashformulaFilterGroupMap();
        HashMap<String, Set<String>> asst_Numbers = new HashMap<String, Set<String>>();
        if (!acctFormulasGroupMap.isEmpty()) {
            for (String asstTypeNumber : acctFormulasGroupMap.keySet()) {
                asstActTypeInfo = this.getAsstActType(asstTypeNumber);
                if (asstActTypeInfo == null) continue;
                List<FormulaFilterInfo> filters = acctFormulasGroupMap.get(asstTypeNumber);
                this.initAsstNumbers(formulaId_DetailNumbers, asst_Numbers, filters);
            }
        }
        if (!acctCashGroupMap.isEmpty()) {
            for (String asstTypeNumber : acctCashGroupMap.keySet()) {
                asstActTypeInfo = this.getAsstActType(asstTypeNumber);
                if (asstActTypeInfo == null) continue;
                Map<String, List<FormulaFilterInfo>> acctCashMap = acctCashGroupMap.get(asstTypeNumber);
                for (String acctCashType : acctCashMap.keySet()) {
                    List<FormulaFilterInfo> filters = acctCashMap.get(acctCashType);
                    this.initAsstNumbers(formulaId_DetailNumbers, asst_Numbers, filters);
                }
            }
        }
        formulaId_DetailNumbers.clear();
        return this.getIdFilterGroupByAsst(asst_Numbers);
    }

    private Map<String, String> getIdFilterGroupByAsst(Map<String, Set<String>> asst_Numbers) throws Exception {
        HashMap<String, String> asst_FilterSqls = new HashMap<String, String>();
        for (String asstTypeNumber : asst_Numbers.keySet()) {
            Set<String> numbers;
            AsstActTypeInfo asstActTypeInfo = this.getAsstActType(asstTypeNumber);
            if (asstActTypeInfo == null || (numbers = asst_Numbers.get(asstTypeNumber)) == null) continue;
            String numberIn = null;
            if (numbers.size() < 50) {
                numberIn = CslRptUtil.collection2String(numbers, ",", true);
            }
            if (numberIn == null) continue;
            StringBuffer inSql = new StringBuffer();
            String sql = "select fid from " + asstActTypeInfo.getRealtionDataObject() + " where fnumber in (" + numberIn + ")";
            IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql);
            while (rs.next()) {
                if (inSql.length() > 0) {
                    inSql.append(",");
                }
                inSql.append("'").append(rs.getString("fid")).append("'");
            }
            if (inSql.length() <= 0) continue;
            asst_FilterSqls.put(asstTypeNumber, inSql.toString());
        }
        asst_Numbers.clear();
        return asst_FilterSqls;
    }

    private void initAsstNumbers(Map<String, List<String>> formulaId_DetailNumbers, Map<String, Set<String>> asst_Numbers, List<FormulaFilterInfo> filters) throws Exception {
        if (filters != null) {
            for (FormulaFilterInfo fitler : filters) {
                List<String> numbers = formulaId_DetailNumbers.get(fitler.getFormulaId());
                Set<String> numberSet = asst_Numbers.get(fitler.getAsstactTypeNumber());
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    asst_Numbers.put(fitler.getAsstactTypeNumber(), numberSet);
                }
                numberSet.addAll(numbers);
            }
        }
    }

    private void getFormulaDyitemNubmers(String formulaId, HashMap<String, Set<String>> formulaDatas, Map<String, Object> asstRefs, String asstRefKey, Set<String> items) {
        Set<String> dynaItemNumbers = formulaDatas.get(formulaId);
        if (dynaItemNumbers != null && !dynaItemNumbers.isEmpty() && asstRefs.get(asstRefKey) != null) {
            List itemNums = this.convertObjectArrayToList(asstRefs, asstRefKey);
            if (itemNums != null && !itemNums.isEmpty()) {
                HashSet curItemNums = new HashSet(itemNums);
                for (String dynaItemNumber : dynaItemNumbers) {
                    if (!curItemNums.contains(dynaItemNumber)) continue;
                    items.add(dynaItemNumber);
                }
            } else {
                items.addAll(dynaItemNumbers);
            }
        }
    }

    private void combineMap(Map<String, Set<String>> targetMap, Map<String, Set<String>> srcMap) {
        if (srcMap != null && !srcMap.isEmpty()) {
            if (targetMap.isEmpty()) {
                targetMap.putAll(srcMap);
            } else {
                for (String mapKey : srcMap.keySet()) {
                    Set<String> values = targetMap.get(mapKey);
                    if (values == null) {
                        targetMap.put(mapKey, srcMap.get(mapKey));
                        continue;
                    }
                    values.addAll((Collection<String>)srcMap.get(mapKey));
                }
            }
        }
    }

    private void removeDupFormula(List<FormulaFilterInfo> filters, Map<String, Set<String>> removedFormulaIds) {
        HashMap<String, String> existIds = new HashMap<String, String>();
        ArrayList<FormulaFilterInfo> removeFilters = new ArrayList<FormulaFilterInfo>();
        for (FormulaFilterInfo formula : filters) {
            String id = formula.getFormulaId();
            String filterKey = formula.getKey();
            String existId = (String)existIds.get(filterKey);
            if (existId == null) {
                existIds.put(filterKey, existId);
                continue;
            }
            Set<String> srcIds = removedFormulaIds.get(id);
            if (srcIds == null) {
                srcIds = new HashSet<String>();
                removedFormulaIds.put(id, srcIds);
            }
            srcIds.add(existId);
            removeFilters.add(formula);
        }
        filters.removeAll(removeFilters);
        removeFilters.clear();
        existIds.clear();
    }

    private List convertObjectArrayToList(Map map, String key) {
        List<Object> result = new ArrayList();
        Object[] objects = (Object[])map.get(key);
        result = Arrays.asList(objects);
        return result;
    }

    private void getSingleDynaItemData(HashMap<String, Set<String>> formulaDatas, Map<String, List<FormulaFilterInfo>> acctFormulasGroupMap, Map<String, Map<String, List<FormulaFilterInfo>>> acctCashGroupMap, CompanyOrgUnitInfo company, Map<String, Set<String>> removedFormulaIds, Map<String, String> asst_FilterSqls) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        if (!acctFormulasGroupMap.isEmpty()) {
            for (String AsstTypeNumber : acctFormulasGroupMap.keySet()) {
                asstActTypeInfo = this.getAsstActType(AsstTypeNumber);
                if (asstActTypeInfo == null) continue;
                List<FormulaFilterInfo> filters = acctFormulasGroupMap.get(AsstTypeNumber);
                String fieldHg = null;
                fieldHg = asstActTypeInfo.getMappingFieldName() == null ? "F" + asstActTypeInfo.getAsstHGAttribute() + "ID" : asstActTypeInfo.getMappingFieldName();
                this.removeDupFormula(filters, removedFormulaIds);
                DynItemFillData fillData = new DynItemFillData(this._ctx, filters, fieldHg, company, asst_FilterSqls.get(AsstTypeNumber), true);
                Map<String, Set<String>> formulaId_ids = fillData.getFillDataByFormulaGroup();
                Map<String, Set<String>> formulaId_Numbers = this.getItemNumbers(asstActTypeInfo.getRealtionDataObject(), formulaId_ids);
                this.combineMap(formulaDatas, formulaId_Numbers);
            }
        }
        if (!acctCashGroupMap.isEmpty()) {
            for (String AsstTypeNumber : acctCashGroupMap.keySet()) {
                asstActTypeInfo = this.getAsstActType(AsstTypeNumber);
                if (asstActTypeInfo == null) continue;
                Map<String, List<FormulaFilterInfo>> acctCashMap = acctCashGroupMap.get(AsstTypeNumber);
                for (String acctCashType : acctCashMap.keySet()) {
                    List<FormulaFilterInfo> filters = acctCashMap.get(acctCashType);
                    String fieldHg = null;
                    fieldHg = asstActTypeInfo.getMappingFieldName() == null ? "F" + asstActTypeInfo.getAsstHGAttribute() + "ID" : asstActTypeInfo.getMappingFieldName();
                    this.removeDupFormula(filters, removedFormulaIds);
                    DynaItemFillDataByAcctCash acctCashHandle = new DynaItemFillDataByAcctCash(this._ctx, filters, null, fieldHg, company, acctCashType.equals("1"), false, asst_FilterSqls.get(AsstTypeNumber), true);
                    Map<String, Set<String>> formulaId_ids = acctCashHandle.getFillDataByFormulaGroup();
                    Map<String, Set<String>> formulaId_Numbers = this.getItemNumbers(asstActTypeInfo.getRealtionDataObject(), formulaId_ids);
                    this.combineMap(formulaDatas, formulaId_Numbers);
                }
            }
        }
        asst_FilterSqls.clear();
    }

    private Map<String, Set<String>> getItemNumbers(String realtionDataObject, Map<String, Set<String>> formulaId_ids) throws EASBizException, BOSException {
        HashMap<String, Set<String>> formulaIds = new HashMap<String, Set<String>>();
        if (formulaId_ids != null && !formulaId_ids.isEmpty()) {
            Set<String> ids = new HashSet<String>();
            Iterator<Set<String>> itr = formulaId_ids.values().iterator();
            while (itr.hasNext()) {
                ids.addAll(itr.next());
            }
            Map<String, String> id_numberMap = this.getItemNumbers(realtionDataObject, ids);
            for (String formulaId : formulaId_ids.keySet()) {
                ids = formulaId_ids.get(formulaId);
                Set<String> numbers = formulaIds.get(formulaId);
                if (numbers == null) {
                    numbers = new HashSet<String>();
                    formulaIds.put(formulaId, numbers);
                }
                for (String id : ids) {
                    String number = id_numberMap.get(id);
                    if (StringUtils.isEmpty((String)number)) continue;
                    numbers.add(number);
                }
            }
            formulaId_ids.clear();
        }
        return formulaIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getItemNumbers(String realtionDataObject, Set<String> itemIdSet) throws EASBizException, BOSException {
        Map<String, String> itemNumbers = new HashMap<String, String>();
        if (itemIdSet != null && !itemIdSet.isEmpty()) {
            logger.error((Object)("FillItemDataSize:" + itemIdSet.size()));
            String tmpTableName = null;
            try {
                tmpTableName = this.createItemIdTempTable(itemIdSet, "Fid", "VARCHAR(44)");
                itemNumbers = this.queryItemDataNumber(realtionDataObject, tmpTableName);
            }
            finally {
                if (!StringUtils.isEmpty((String)tmpTableName) && !DebugLogger.isDebug) {
                    TempTablePool.getInstance((Context)this._ctx).releaseTable(tmpTableName);
                    tmpTableName = null;
                }
            }
        }
        return itemNumbers;
    }

    private Map<String, String> queryItemDataNumber(String realtionDataObject, String tmpTableName) throws BOSException {
        HashMap<String, String> itemNumbers = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select rel.FNumber number,rel.Fid \n");
        sql.append(" From ").append(realtionDataObject).append(" rel \n");
        sql.append(" Inner join ").append(tmpTableName).append(" tmp On tmp.Fid = rel.Fid \n");
        IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                itemNumbers.put(rs.getString("Fid"), rs.getString("number"));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return itemNumbers;
    }

    private String createItemIdTempTable(Set<String> itemIdSet, String filed, String filedType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tmpTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        try {
            tmpTableName = pool.createTempTable("create table t_csl_ItemId(" + filed + " " + filedType + ")");
            Object[] allParams = new Object[itemIdSet.size()];
            allParams = itemIdSet.toArray();
            sql.append(" insert into ").append(tmpTableName).append("(Fid) values(?) ");
            CslRptUtil.batchExecute(this._ctx, sql.toString(), allParams);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tmpTableName;
    }

    private Map createParamMap(List<FormulaFilterInfo> FormulaFilterList, AsstActTypeInfo asstActTypeInfo, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formulaFilter", FormulaFilterList);
        if (asstActTypeInfo.getMappingFieldName() == null) {
            paramMap.put("fieldHg", "F" + asstActTypeInfo.getAsstHGAttribute() + "ID");
        } else {
            paramMap.put("fieldHg", asstActTypeInfo.getMappingFieldName());
        }
        paramMap.put("currentUnit", company);
        paramMap.put("realtionDataObject", asstActTypeInfo.getRealtionDataObject());
        return paramMap;
    }

    private AsstActTypeInfo getAsstActType(String actType) throws EASBizException, BOSException {
        AsstActTypeInfo info = this.asstTypeCatch.get(actType);
        if (info != null) {
            return info;
        }
        IAsstActType iType = AsstActTypeFactory.getLocalInstance((Context)this._ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isSelfAsstActaiatem"));
        view.getSelector().add(new SelectorItemInfo("defaultQueryName"));
        view.getSelector().add(new SelectorItemInfo("glAsstActTypeGrp.id"));
        view.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        view.getSelector().add(new SelectorItemInfo("isMultilevel"));
        view.getSelector().add(new SelectorItemInfo("groupTableName"));
        view.getSelector().add(new SelectorItemInfo("mappingfieldname"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)actType, CompareType.EQUALS));
        view.setFilter(filter);
        AsstActTypeCollection actTypeColl = iType.getAsstActTypeCollection(view);
        if (actTypeColl != null && actTypeColl.size() > 0) {
            info = actTypeColl.get(0);
            this.asstTypeCatch.put(actType, info);
            return info;
        }
        return null;
    }

    public void testGetDynaItemData() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("{\"acct\":[{\"formulaid\":\"BK\",\"asst\":[],\"formula\":\"if(ACCT(\\\"\\\",\\\"EI1.01.01|07|@\\\",\\\"\\\",0,0,0,0,\\\"\\\",\\\"\\\"),acctCash(\\\"KSF-01.02.01\\\",\\\"Z\\\",\\\"BB01\\\",2016,1,1,\\\"CI1.02.02|Z007|@\\\",\\\"\\\"),0)\",\"asstRef\":\"07InternalCompany\"},                                            ");
            sb.append("{\"formulaid\":\"BL\",\"asst\":[],\"formula\":\"if(acct(\\\"\\\",\\\"1111.03|Z007|@\\\",\\\"Y\\\",0,0,0,0,\\\"\\\",\\\"Company\\\"),acctCash(\\\"\\\",\\\"AZ\\\",\\\"GLC\\\",0,1,0,\\\"EI1.01.02|07|@\\\",\\\"\\\"),0)\",\"asstRef\":\"07InternalCompany\"}                                            ");
            sb.append(" ],\"periodType\":\"MONTHLY\",\"year\":\"2010\",\"org\":\"KSF-01.02.01\",\"period\":\"3\",\"currency\":\"BB01\",\"asstRef\":{\"07InternalCompany\":[\"KSF-02.01.01\",\"KSF-01.02.02\",\"KSF-01.01.01\"]} } ");
            HashMap<?, ?> filter = JSONUtils.convertJsonToObject(sb.toString());
            this.getDynaItemData(filter);
        }
        catch (Exception e) {
            logger.error((Object)"getDynaItemData:", (Throwable)e);
            e.printStackTrace();
        }
    }
}

