/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterCollection;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterFactory;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.IDataCenter;
import com.kingdee.eas.fi.gr.rptintegration.IWebservice;
import com.kingdee.eas.fi.gr.rptintegration.WebserviceFactory;
import com.kingdee.eas.fi.gr.rptintegration.WebserviceInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCenterUtil {
    public static WebServiceInfo getTopWebServiceInfo(Context ctx) throws RuntimeException, BOSException, EASBizException {
        IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
        DataCenterInfo datacenterInfo = iDataCenter.getDataCenterCollection(" where level=1 ").get(0);
        if (datacenterInfo == null) {
            throw new RuntimeException(CoreUtils.getResourceStr(ctx, "DataCenterHaveData"));
        }
        IWebservice iWebservice = ctx == null ? WebserviceFactory.getRemoteInstance() : WebserviceFactory.getLocalInstance(ctx);
        WebserviceInfo webserviceInfo = iWebservice.getWebserviceInfo((IObjectPK)new ObjectSingleKey((Object)datacenterInfo.getWebservice().getId().toString()));
        return DataCenterUtil.getWebServiceObject(null, webserviceInfo, datacenterInfo);
    }

    public static WebServiceInfo getParentServiceInfo(Context ctx) throws BOSException, EASBizException {
        return DataCenterUtil.getParentServiceInfo(ctx, null);
    }

    public static WebServiceInfo getParentServiceInfo(Context ctx, DataCenterInfo currentDatacenter) throws BOSException, EASBizException {
        if (currentDatacenter == null) {
            currentDatacenter = DataCenterUtil.getCurrentDatacenter(ctx);
        }
        if (currentDatacenter.getParent() == null) {
            throw new RuntimeException(CoreUtils.getResourceStr(ctx, "haveParentDataCenter"));
        }
        IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
        DataCenterInfo datacenterInfo = iDataCenter.getDataCenterCollection("where id='" + currentDatacenter.getParent().getId() + "'").get(0);
        if (datacenterInfo.getWebservice() == null) {
            throw new RuntimeException(CoreUtils.getResourceStr(ctx, "ParentNotConnection"));
        }
        IWebservice iWebservice = ctx == null ? WebserviceFactory.getRemoteInstance() : WebserviceFactory.getLocalInstance(ctx);
        WebserviceInfo webserviceInfo = iWebservice.getWebserviceInfo((IObjectPK)new ObjectSingleKey((Object)datacenterInfo.getWebservice().getId().toString()));
        return DataCenterUtil.getWebServiceObject(ctx, webserviceInfo, datacenterInfo);
    }

    public static WebServiceInfo getWebServiceObject(Context ctx, WebserviceInfo webserviceInfo, DataCenterInfo datacenterInfo) {
        WebServiceInfo serviceInfo = new WebServiceInfo();
        serviceInfo.setServerIPAddress(webserviceInfo.getServerIPAddress());
        serviceInfo.setServerPort(webserviceInfo.getServerPort());
        serviceInfo.setUserName(webserviceInfo.getAccount());
        serviceInfo.setUserPwd(webserviceInfo.getPassword() == null ? "" : webserviceInfo.getPassword());
        serviceInfo.setEasSolutionName("eas");
        serviceInfo.setDateCenterNumber(webserviceInfo.getDateCenterNumber());
        String language = null;
        int dbType = 0;
        if (ctx != null) {
            language = ctx.getLocale().getLanguage();
            String dbTypeName = (String)ctx.get((Object)"dbType");
            dbType = DbType.getValue((String)dbTypeName);
            dbType = dbType == 3 ? 0 : dbType;
        } else {
            language = SysContext.getSysContext().getLocale().getLanguage();
            dbType = (Integer)SysContext.getSysContext().getProperty((Object)"dbType");
        }
        serviceInfo.setLanguage(language);
        serviceInfo.setDbType(dbType);
        if (datacenterInfo != null) {
            serviceInfo.setDataCenterName(datacenterInfo.getName());
            serviceInfo.setDataCenterId(datacenterInfo.getId().toString());
        }
        return serviceInfo;
    }

    public static List<WebServiceInfo> getParentServiceInfoCollection() throws RuntimeException, BOSException, EASBizException {
        ArrayList<WebServiceInfo> serviceCollection = new ArrayList<WebServiceInfo>();
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(null);
        DataCenterInfo parent = datacenterInfo.getParent();
        while (parent != null) {
            DataCenterInfo parentInfo = DataCenterFactory.getRemoteInstance().getDataCenterCollection("where id='" + parent.getId() + "'").get(0);
            if (parentInfo.getWebservice() != null) {
                WebserviceInfo webserviceInfo = WebserviceFactory.getRemoteInstance().getWebserviceInfo((IObjectPK)new ObjectSingleKey((Object)parentInfo.getWebservice().getId().toString()));
                serviceCollection.add(DataCenterUtil.getWebServiceObject(null, webserviceInfo, parentInfo));
            }
            parent = parentInfo.getParent();
        }
        return serviceCollection;
    }

    public static DataCenterCollection getChildDataCenters(Context ctx) throws RuntimeException, EASBizException, BOSException {
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(ctx);
        if (datacenterInfo == null) {
            return null;
        }
        IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
        DataCenterCollection dataCenterColl = iDataCenter.getDataCenterCollection(" where parent.id='" + datacenterInfo.getId().toString() + "'");
        return dataCenterColl;
    }

    public static List<WebServiceInfo> getChildWebServiceList(Context ctx) throws RuntimeException, EASBizException, BOSException {
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(ctx);
        if (datacenterInfo == null) {
            throw new RuntimeException(CoreUtils.getResourceStr(ctx, "NotCurrentDataCenter"));
        }
        return DataCenterUtil.getWebserviceList(ctx, "parent.id='" + datacenterInfo.getId().toString() + "'");
    }

    public static List<WebServiceInfo> getAllChildWebServiceList(Context ctx) throws RuntimeException, EASBizException, BOSException {
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(ctx);
        if (datacenterInfo == null) {
            throw new RuntimeException(CoreUtils.getResourceStr(ctx, "NotCurrentDataCenter"));
        }
        return DataCenterUtil.getWebserviceList(ctx, "longNumber like '" + datacenterInfo.getLongNumber() + "!%'");
    }

    public static List<WebServiceInfo> getWebserviceList(Context ctx, String whereStr) throws EASBizException, BOSException {
        ArrayList<WebServiceInfo> xBangServiceCollection = new ArrayList<WebServiceInfo>();
        Map<String, WebServiceInfo> webserviceMap = DataCenterUtil.getWebserviceMap(ctx, whereStr);
        xBangServiceCollection.addAll(webserviceMap.values());
        webserviceMap.clear();
        return xBangServiceCollection;
    }

    public static Map<String, WebServiceInfo> getWebserviceMap(Context ctx, String whereStr) throws EASBizException, BOSException {
        HashMap<String, WebServiceInfo> webServiceMap = new HashMap<String, WebServiceInfo>();
        StringBuffer select = new StringBuffer();
        select.append("select id,name,webservice.id,webservice.account,webservice.easSolutionName,webservice.dateCenterNumber,");
        select.append("webservice.serverIPAddress,webservice.serverPort,webservice.password");
        IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
        DataCenterCollection dataCenterColl = iDataCenter.getDataCenterCollection(select.toString() + " where " + whereStr);
        DataCenterInfo datacenterInfo = null;
        WebserviceInfo webserviceInfo = null;
        for (int i = 0; i < dataCenterColl.size(); ++i) {
            datacenterInfo = dataCenterColl.get(i);
            webserviceInfo = datacenterInfo.getWebservice();
            webServiceMap.put(datacenterInfo.getId().toString(), DataCenterUtil.getWebServiceObject(ctx, webserviceInfo, datacenterInfo));
        }
        return webServiceMap;
    }

    public static List<WebServiceInfo> getWebservicesById(Context ctx, List<String> dataCenterIds) throws EASBizException, BOSException {
        String inStr = CslRptUtil.list2String(dataCenterIds, ",", true);
        return DataCenterUtil.getWebserviceList(ctx, " id in(" + inStr + ")");
    }

    public static Map<String, WebServiceInfo> getWebservicesMapById(Context ctx, List<String> dataCenterIds) throws EASBizException, BOSException {
        String inStr = CslRptUtil.list2String(dataCenterIds, ",", true);
        return DataCenterUtil.getWebserviceMap(ctx, " id in(" + inStr + ")");
    }

    public static DataCenterInfo getCurrentDatacenter(Context ctx) throws BOSException {
        IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
        return iDataCenter.getDataCenterCollection("where isatcurrentsys=1").get(0);
    }
}

