/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import edu.emory.mathcs.backport.java.util.Arrays;
import org.apache.log4j.Logger;

public class BookDataSynOperate
extends CoreUtils
implements SynchronizeHandle {
    private static final Logger logger = CoreUIObject.getLogger(BookDataSynOperate.class);
    private int batchSize = 0x100000;

    public byte[] getTargetBookData(Context ctx, String id, String type, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        try {
            xbangServiceInfo.setOperationName("invoke");
            xbangServiceInfo.setArgs(new Object[]{SynchronizeType.bookDataSyn, new String[]{operateType.getByteCount.name(), id, type}});
            String byteCount = (String)webServiceClient.callMethod(xbangServiceInfo);
            int curByteCount = Integer.valueOf(byteCount);
            byte[] dataArray = new byte[curByteCount];
            int fetchCount = curByteCount / this.batchSize + 1;
            int start = 0;
            int to = 0;
            for (int i = 0; i < fetchCount; ++i) {
                start = i * this.batchSize;
                to = curByteCount >= this.batchSize * (i + 1) ? this.batchSize * (i + 1) : curByteCount;
                xbangServiceInfo.setArgs(new Object[]{SynchronizeType.bookDataSyn, new String[]{operateType.getByteDetail.name(), id, type, String.valueOf(start), String.valueOf(to)}});
                String details = (String)webServiceClient.callMethod(xbangServiceInfo);
                JSONObject jsonObj = new JSONObject(details);
                JSONArray batchData = (JSONArray)jsonObj.get("data");
                for (int j = 0; j < batchData.length(); ++j) {
                    dataArray[start + j] = (byte)((Integer)batchData.get(j)).intValue();
                }
            }
            return dataArray;
        }
        catch (Exception e) {
            logger.error((Object)"getTargetBookData error.", (Throwable)e);
            throw new Exception("getTargetBookData error.", e);
        }
    }

    @Override
    public String targetDataCenterHandle(Context ctx, String[] args) throws Exception {
        String result = null;
        if (args != null && args.length > 2) {
            String curOperateType = args[0];
            String id = args[1];
            String type = args[2];
            try {
                byte[] bookDatas = this.getBookDatasById(ctx, id, type);
                if (operateType.getByteCount.name().equals(curOperateType)) {
                    result = String.valueOf(bookDatas.length);
                } else {
                    int from = Integer.valueOf(args[3]);
                    int to = Integer.valueOf(args[4]);
                    byte[] curBytes = Arrays.copyOfRange((byte[])bookDatas, (int)from, (int)to);
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("data", (Object)curBytes);
                    result = jsonObj.toString();
                }
            }
            catch (Exception e) {
                result = "get BookData error.";
                logger.error((Object)result, (Throwable)e);
                throw new Exception(result, e);
            }
        }
        return result;
    }

    private byte[] getBookDatasById(Context ctx, String id, String type) throws Exception {
        String oql = "select data where id='" + id + "'";
        if (type.equals("0")) {
            TemplateInfo template = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(oql);
            return template.getData();
        }
        if (type.equals("1")) {
            CslReportInfo cslrpt = CslReportFactory.getLocalInstance(ctx).getCslReportInfo(oql);
            return cslrpt.getData();
        }
        ReportInfo cslrpt = ReportFactory.getLocalInstance((Context)ctx).getReportInfo(oql);
        return cslrpt.getData();
    }

    @Override
    public ResultInfo sourceDataCenterHandle(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        return null;
    }

    public static enum operateType {
        getByteCount,
        getByteDetail;

    }
}

