/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterFactory;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.IDataCenter;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.CoverDeleteSynOperate;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.SynOperateByPushUtils;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptoTean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DataCenterParentWSUtil
extends SynOperateByPushUtils {
    private static Logger logger = Logger.getLogger(DataCenterParentWSUtil.class);

    @Override
    public CoreBaseInfo getCoreBaseInfo() throws Exception {
        return new DataCenterInfo();
    }

    @Override
    public ICoreBase getBizInterface(Context ctx) throws Exception {
        return ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
    }

    @Override
    public String getMethod() {
        return SynchronizeType.getDataCenter;
    }

    @Override
    public String getSelectStr(Context ctx) {
        StringBuffer select = new StringBuffer();
        select.append("webservice.id,webservice.account,webservice.easSolutionName,webservice.dateCenterNumber");
        select.append(",webservice.serverIPAddress,webservice.serverPort,webservice.password");
        select.append(",parent.id,id,name,number,level,longNumber,isVPN,companyOrgUnit.id");
        return select.toString();
    }

    @Override
    public IObjectCollection getObjectCollection(Context ctx, String selects, String whereStr, String orderStr) throws Exception {
        IObjectCollection coll = super.getObjectCollection(ctx, selects + ",webservice.isEncrypt", whereStr, orderStr);
        for (int i = 0; i < coll.size(); ++i) {
            DataCenterInfo info = (DataCenterInfo)coll.getObject(i);
            if (!info.getWebservice().isIsEncrypt() || info.getWebservice().getPassword() == null) continue;
            String pwd = CryptoTean.decrypt((String)info.getWebservice().getAccount(), (String)info.getWebservice().getPassword());
            info.getWebservice().setPassword(pwd);
            info.getWebservice().setIsEncrypt(false);
        }
        return coll;
    }

    @Override
    public String getOrderStr() {
        return "level asc";
    }

    public ResultInfo sourceDataCenterHandleByDownLoad(Context ctx, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        String parentStr = this.getTargetDataStr(this.getMethod(), this.getSelectStr(null), this.getWhereStr(), this.getOrderStr(), webServiceClient, xbangServiceInfo);
        this.saveDataCenter(ctx, parentStr);
        ((CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn)).coverSynTableByWhere(ctx, "*", null, "T_Csl_DataCenterCUMap", null, webServiceClient, xbangServiceInfo);
        ((CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn)).coverSynTableByWhere(ctx, "*", null, "T_Csl_DataCenterEipUserMap", null, webServiceClient, xbangServiceInfo);
        ((CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn)).coverSynTableByWhere(ctx, "*", null, "t_csl_webservice", null, webServiceClient, xbangServiceInfo);
        return null;
    }

    @Override
    public boolean sourceDataCenterHandleByPush(Context ctx, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        WebServiceInfo curWebService = DataCenterUtil.getTopWebServiceInfo(ctx);
        ArrayList<String> curArgs = new ArrayList<String>();
        curArgs.add(curWebService.userName);
        String pwd = curWebService.userPwd == null ? "" : curWebService.userPwd;
        pwd = "isFrom860" + pwd;
        curArgs.add(pwd);
        curArgs.add(curWebService.easSolutionName);
        curArgs.add(curWebService.dateCenterNumber);
        curArgs.add(curWebService.language);
        curArgs.add(String.valueOf(curWebService.dbType));
        curArgs.add(curWebService.getServerIPAddress());
        curArgs.add(curWebService.getServerPort());
        curArgs.add(this.isPush);
        xbangServiceInfo.setOperationName("invoke");
        xbangServiceInfo.setArgs(new Object[]{this.getMethod(), curArgs.toArray(new String[0])});
        String result = (String)webServiceClient.callMethod(xbangServiceInfo);
        if (result != null && result.equals("success")) {
            return true;
        }
        throw new Exception(result);
    }

    @Override
    public String targetDataCenterHandleByPush(Context ctx, String[] args) throws Exception {
        try {
            if (args != null && args.length > 0 && this.isPush.equals(args[args.length - 1])) {
                WebServiceInfo xbangServiceInfo = new WebServiceInfo();
                xbangServiceInfo.setUserName(args[0]);
                xbangServiceInfo.setUserPwd(args[1]);
                xbangServiceInfo.setEasSolutionName(args[2]);
                xbangServiceInfo.setDateCenterNumber(args[3]);
                xbangServiceInfo.setLanguage(args[4]);
                xbangServiceInfo.setDbType(Integer.valueOf(args[5]));
                xbangServiceInfo.setServerIPAddress(args[6]);
                xbangServiceInfo.setServerPort(args[7]);
                WebServiceClient webServiceClient = WebServiceClient.getInstance();
                this.sourceDataCenterHandleByDownLoad(ctx, webServiceClient, xbangServiceInfo);
                return "success";
            }
            return this.targetDataCenterHandleByDownLoad(ctx, args);
        }
        catch (Exception ex) {
            logger.error((Object)"syn error.", (Throwable)ex);
            return "syn error:" + ex.getMessage();
        }
    }

    public void saveDataCenter(Context ctx, String jsonString) throws EASBizException, BOSException, JSONException {
        try {
            CoreBaseCollection dcc = this.getDataCenterInfoCollection(ctx, jsonString);
            String sql = "delete from t_csl_datacenter";
            DbUtil.execute((Context)ctx, (String)sql);
            if (dcc.size() > 0) {
                IDataCenter iDataCenter = ctx == null ? DataCenterFactory.getRemoteInstance() : DataCenterFactory.getLocalInstance(ctx);
                iDataCenter.save(dcc);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public CoreBaseCollection getDataCenterInfoCollection(Context ctx, String jsonString) throws Exception {
        int i;
        CoreUtils corUtils = new CoreUtils();
        CoreBaseCollection corporationDataCenterCollection = new CoreBaseCollection();
        JSONArray dataCenterArrays = null;
        try {
            dataCenterArrays = new JSONArray(jsonString);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new Exception(jsonString + ";\n" + ex.getMessage());
        }
        DataCenterInfo info = null;
        String easServerIp = null;
        String dcNumber = null;
        if (ctx != null) {
            easServerIp = InetAddress.getLocalHost().getHostAddress().toString();
            dcNumber = ctx.getAIS();
        } else {
            String eas_server = System.getProperty("EAS_SERVER");
            easServerIp = eas_server.substring(6, eas_server.lastIndexOf(":"));
            dcNumber = SysContext.getSysContext().getDCNumber();
        }
        boolean isDcNumberDump = false;
        HashMap dcNumberMap = new HashMap();
        for (i = 0; i < dataCenterArrays.length(); ++i) {
            info = (DataCenterInfo)corUtils.jsonStringToObject(ctx, dataCenterArrays.getString(i), null);
            if (info.getWebservice() != null && !isDcNumberDump) {
                if (dcNumberMap.containsKey(info.getWebservice().getDateCenterNumber())) {
                    isDcNumberDump = true;
                    dcNumberMap.clear();
                } else {
                    dcNumberMap.put(info.getWebservice().getDateCenterNumber(), null);
                }
            }
            corporationDataCenterCollection.add((CoreBaseInfo)info);
        }
        dcNumberMap.clear();
        for (i = 0; i < corporationDataCenterCollection.size(); ++i) {
            info = (DataCenterInfo)corporationDataCenterCollection.get(i);
            if (info.getWebservice() == null || !info.getWebservice().getDateCenterNumber().equals(dcNumber) || isDcNumberDump && !info.getWebservice().getServerIPAddress().equals(easServerIp)) continue;
            info.setIsAtCurrentSys(true);
        }
        return corporationDataCenterCollection;
    }
}

