/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.webservice;

import com.kingdee.eas.fi.gr.rptintegration.RptIntegrationFacadeFactory;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.gr.rptintegration.webservice.login.EASLoginProxyServiceLocator;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebServiceClient {
    private static Logger logger = Logger.getLogger(WebServiceClient.class);
    private boolean isLogin;
    private Call loginCall;
    private String sessionId;
    private static WebServiceClient webServiceClient = null;
    private boolean isFromClient = false;

    private WebServiceClient() {
    }

    public static WebServiceClient getInstance() {
        if (webServiceClient == null) {
            webServiceClient = new WebServiceClient();
            webServiceClient.setFromClient(WebServiceClient.isClient());
        }
        return webServiceClient;
    }

    public static boolean isClient() {
        try {
            int i;
            Exception ex = new Exception();
            StackTraceElement[] elements = ex.getStackTrace();
            int elementLength = elements.length;
            String tmpElement = null;
            int n = i = elementLength > 2 ? 2 : 1;
            while (i < elementLength) {
                tmpElement = elements[i].toString();
                if (!StringUtils.isEmpty((String)tmpElement)) {
                    if (tmpElement.indexOf(".client.") > 0) {
                        return true;
                    }
                    if (tmpElement.indexOf(".app.") > 0) {
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isClient error.", (Throwable)e);
        }
        return false;
    }

    public boolean login(WebServiceInfo xbangServiceInfo) throws Exception {
        try {
            xbangServiceInfo.setOperationName("invoke");
            xbangServiceInfo.setArgs(new Object[]{SynchronizeType.login});
            this.sessionId = (String)this.callMethod(xbangServiceInfo);
            if (!StringUtils.isEmpty((String)this.sessionId)) {
                this.setLogin(true);
            } else {
                this.setLogin(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"login error.", (Throwable)ex);
            this.setLogin(false);
        }
        return this.isLogin();
    }

    public Object callMethod(WebServiceInfo xbangServiceInfo) throws Exception {
        if (this.isFromClient) {
            return RptIntegrationFacadeFactory.getRemoteInstance().callMethodServer(xbangServiceInfo);
        }
        return this.callMethodForWebService(xbangServiceInfo);
    }

    public Object callMethodForWebService(WebServiceInfo xbangServiceInfo) throws Exception {
        if (this.loginCall == null) {
            this.loginCall = (Call)new EASLoginProxyServiceLocator().createCall();
        }
        if (StringUtils.isEmpty((String)xbangServiceInfo.operationName)) {
            xbangServiceInfo.operationName = "invoke";
        }
        String sssoapxmlns = "http://webservice.rptintegration.gr.fi.eas.kingdee.com";
        this.loginCall.setOperationName(new QName(sssoapxmlns, xbangServiceInfo.operationName));
        String address = "http://" + xbangServiceInfo.serverIPAddress;
        if (!StringUtils.isEmpty((String)xbangServiceInfo.serverPort)) {
            address = address + ":" + xbangServiceInfo.serverPort;
        }
        address = address + "/ormrpc/services/RptIntegrationWebServiceFacade";
        this.loginCall.setTargetEndpointAddress(address);
        ArrayList<String> curArgs = new ArrayList<String>();
        if (xbangServiceInfo.args.length >= 2) {
            for (String arg : (String[])xbangServiceInfo.args[1]) {
                curArgs.add(arg);
            }
        }
        curArgs.add(xbangServiceInfo.userName);
        curArgs.add(xbangServiceInfo.userPwd);
        curArgs.add(xbangServiceInfo.easSolutionName);
        curArgs.add(xbangServiceInfo.dateCenterNumber);
        curArgs.add(xbangServiceInfo.language);
        curArgs.add(String.valueOf(xbangServiceInfo.dbType));
        xbangServiceInfo.setArgs(new Object[]{xbangServiceInfo.args[0], curArgs.toArray(new String[0])});
        try {
            if (SynchronizeType.login.equals(xbangServiceInfo.args[0]) || SynchronizeType.getDBList.equals(xbangServiceInfo.args[0])) {
                this.loginCall.setTimeout(Integer.valueOf(10000));
            } else {
                this.loginCall.setTimeout(Integer.valueOf(0x6DDD00));
            }
            return this.loginCall.invoke(xbangServiceInfo.args);
        }
        catch (Throwable ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("callMethod error:");
            sb.append(address);
            sb.append("/n OperationName:").append(xbangServiceInfo.operationName);
            sb.append("/n curArgs:").append(((Object)curArgs).toString());
            logger.error((Object)sb.toString());
            throw new Exception(ex);
        }
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public Call getLoginCall() {
        return this.loginCall;
    }

    public void setLoginCall(Call loginCall) {
        this.loginCall = loginCall;
    }

    public static Object invokeMethod(WebServiceInfo xbangServiceInfo) throws Exception {
        EASLoginProxyServiceLocator loginProxyServiceLocator = new EASLoginProxyServiceLocator(xbangServiceInfo.serverIPAddress, xbangServiceInfo.serverPort);
        loginProxyServiceLocator.getEASLogin().login(xbangServiceInfo.userName, xbangServiceInfo.userPwd, xbangServiceInfo.easSolutionName, xbangServiceInfo.dateCenterNumber, xbangServiceInfo.language, xbangServiceInfo.dbType);
        Call call = (Call)loginProxyServiceLocator.createCall();
        call.setOperationName(xbangServiceInfo.operationName);
        call.setTargetEndpointAddress("http://" + xbangServiceInfo.serverIPAddress + ":" + xbangServiceInfo.serverPort + "/ormrpc/services/WSXBWebServiceFacade");
        return call.invoke(xbangServiceInfo.args);
    }

    public boolean isFromClient() {
        return this.isFromClient;
    }

    public void setFromClient(boolean isFromClient) {
        this.isFromClient = isFromClient;
    }
}

