/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ReportNoticeAndCheckTool;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.JobServerRunningConfig;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTaskCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTaskFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTaskInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.CommonMsgBoxUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAutoWeaveUtil {
    private static final Logger logger = Logger.getLogger(RptAutoWeaveUtil.class);
    public static final String RPTWEAVERESOURCE_PATH = "com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource";
    public static final int BATCHSAVE_REPEAT = 1;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    public static final String KEY_VIEW = "KEY_VIEW";
    public static final String KEY_VIEW_ORG = "KEY_VIEW_ORG";
    public static final String KEY_VIEW_TMPL = "KEY_VIEW_TMPL";
    public static final String KEY_IS_NEWQUERY = "KEY_IS_NEWQUERY";

    public int addNewEditData(Context ctx, CslReportInfo editData, TemplateInfo template, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company, List allKeyRow, Object isSupportOtherDS, DataCollectInfo dataCollect, Date createDate, boolean isSupportGroupReport, String description, String fastMergeSoluId) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int periodType = template.getPeriodType().getValue();
        short period = (short)RPTDateUtil.getPeriod(year, month, day, template.getPeriodType());
        int templateType = template.getTemplateType().getValue();
        int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
        if (!this.verifySumReport(ctx, unitTree.getId().toString(), company.getId().toString(), periodType, year, period, currency.getId().toString(), template.getGroup(), reportType, isSupportOtherDS, isSupportGroupReport, fastMergeSoluId)) {
            return 1;
        }
        try {
            ICslReport ireport = null;
            ireport = ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(ctx);
            editData = this.initCslReportInfo(ctx, editData, template, currency, unitTree, company, allKeyRow, isSupportOtherDS, dataCollect, createDate, isSupportGroupReport, description, fastMergeSoluId);
            IObjectPK pk = ireport.submit((CoreBaseInfo)editData);
            editData.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (ServerException exc) {
            if (ServerException.EXISTS_SAME_RPT.getCode().equals(exc.getSubCode())) {
                return 1;
            }
            logger.error((Object)"RptAutoWeaveUtil.addNewEditData", (Throwable)((Object)exc));
            return 2;
        }
        catch (Exception exc) {
            logger.error((Object)"RptAutoWeaveUtil.addNewEditData", (Throwable)exc);
            return 2;
        }
        return 3;
    }

    public CslReportInfo initCslReportInfo(Context ctx, CslReportInfo editData, TemplateInfo template, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company, List allKeyRow, Object isSupportOtherDS, DataCollectInfo dataCollect, int year, short period, Date createDate, boolean isSupportGroupReport, String description, String fastMergeSoluId) throws Exception {
        int periodType = template.getPeriodType().getValue();
        int templateType = template.getTemplateType().getValue();
        int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType, isSupportGroupReport);
        if (editData == null) {
            editData = new CslReportInfo();
        }
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setStartDate(RPTDateUtil.getPeriodFirstDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
        editData.setEndDate(RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType)));
        editData.setTemplate(template);
        editData.setBook(template.getBook());
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        if (isSupportGroupReport) {
            if (RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)editData.getTemplate().getTemplateType())) {
                editData.setSourceType(RptSrcTypeEnum.DYNAMICSUMREPORT);
            } else if (RptTmpTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)editData.getTemplate().getTemplateType())) {
                editData.setSourceType(RptSrcTypeEnum.MULTIDYNAMICSUMREPORT);
            } else {
                editData.setSourceType(RptSrcTypeEnum.SUM);
            }
        } else {
            editData.setSourceType(FastMergeUtil.transSourceType(editData.getTemplate().getTemplateType().getValue()));
        }
        editData.setDynaRptType(template.getDynaRptType());
        editData.setFastMergeSoluId(fastMergeSoluId);
        editData.setOrgTree(unitTree);
        editData.setCompany(company);
        editData.setOrgUnit(company);
        editData.setCurrency(currency);
        editData.setName(template.getName());
        editData.setNumber("001");
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        if ("true".equals(isSupportOtherDS)) {
            editData.setDataCollect(dataCollect);
            if (dataCollect != null) {
                editData.setDataCollectNumber(dataCollect.getNumber());
            }
        }
        editData.setReportDate(new Timestamp(createDate.getTime()));
        this.getDynaKeyAndValue(editData, allKeyRow);
        this.setFormulaLocation(editData, allKeyRow);
        Book book = editData.getBook();
        CslRptUtil.clearCellFormulaByDataCollect(book);
        SumRptAddedPerportyInfo addedPerporty = this.getSumRptAddedPerporty(ctx, template, currency, unitTree, company, isSupportOtherDS, year, periodType, period, reportType, isSupportGroupReport, fastMergeSoluId);
        editData.put("addedPerporty", addedPerporty);
        if (ctx == null) {
            editData.setNumber("AT001");
            if (company.getCU() != null) {
                editData.setCU(company.getCU());
            } else {
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                cuInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                editData.setCU(cuInfo);
            }
        }
        if (description != null) {
            editData.setDescription(description);
        }
        return editData;
    }

    public CslReportInfo initCslReportInfo(Context ctx, CslReportInfo editData, TemplateInfo template, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company, List allKeyRow, Object isSupportOtherDS, DataCollectInfo dataCollect, Date createDate, boolean isSupportGroupReport, String description, String fastMergeSoluId) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        short period = (short)RPTDateUtil.getPeriod(year, month, day, template.getPeriodType());
        return this.initCslReportInfo(ctx, editData, template, currency, unitTree, company, allKeyRow, isSupportOtherDS, dataCollect, year, period, createDate, isSupportGroupReport, description, fastMergeSoluId);
    }

    public SumRptAddedPerportyInfo getSumRptAddedPerporty(Context ctx, TemplateInfo template, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company, Object isSupportOtherDS, int year, int periodType, short period, int reportType, boolean isSupportGroupReport, String fastMergeSoluId) throws BOSException, EASBizException {
        String dataCollectNumber = "ACTUALDATA";
        if (ctx == null && "true".equals(isSupportOtherDS)) {
            ICSLContext cslctx = CSLContextHelper.getCSLContext();
            dataCollectNumber = cslctx.getCurDataCollect().getNumber();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", unitTree.getId().toString());
        params.put("companyID", company.getId().toString());
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currency.getId().toString());
        params.put("templateGroupNumber", template.getGroup());
        params.put("reportType", new Integer(reportType));
        params.put("dataCollectNumber", dataCollectNumber);
        params.put("isSupportGroupReport", isSupportGroupReport);
        params.put("fastMergeSoluId", fastMergeSoluId);
        SumRptAddedPerportyInfo addedPerporty = RptAutoWeaveUtil.getNextSumRptAddedPerportyInfo(ctx, params);
        if (addedPerporty == null) {
            addedPerporty = new SumRptAddedPerportyInfo();
            addedPerporty.setVersion(1);
            addedPerporty.setRemark("");
            addedPerporty.setGroup(Uuid.create().toString());
        } else {
            addedPerporty.setVersion(addedPerporty.getVersion() + 1);
        }
        if (isSupportGroupReport) {
            addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
        } else {
            addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        }
        return addedPerporty;
    }

    public static int getReportTypeByTempType(int templateType, boolean isSupportGroupReport) {
        int reportType = -1;
        if (!isSupportGroupReport) {
            return FastMergeUtil.transSourceType(templateType).getValue();
        }
        switch (templateType) {
            case 1: {
                reportType = 1;
                break;
            }
            case 3: {
                reportType = 2;
                break;
            }
            case 4: {
                reportType = 4;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 10: {
                reportType = 10;
                break;
            }
            case 11: {
                reportType = 11;
                break;
            }
            case 12: {
                reportType = 12;
                break;
            }
            case 13: {
                reportType = 12;
                break;
            }
            case 15: {
                reportType = 15;
                break;
            }
            case 17: {
                reportType = 14;
                break;
            }
            case 18: {
                reportType = 18;
                break;
            }
            case 19: {
                reportType = 19;
            }
        }
        return reportType;
    }

    public static int getReportTypeByTempType(int templateType) {
        int reportType = -1;
        switch (templateType) {
            case 1: {
                reportType = 1;
                break;
            }
            case 3: {
                reportType = 2;
                break;
            }
            case 4: {
                reportType = 4;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 10: {
                reportType = 10;
                break;
            }
            case 11: {
                reportType = 11;
                break;
            }
            case 12: {
                reportType = 12;
                break;
            }
            case 13: {
                reportType = 12;
                break;
            }
            case 15: {
                reportType = 15;
                break;
            }
            case 17: {
                reportType = 14;
                break;
            }
            case 18: {
                reportType = 18;
                break;
            }
            case 19: {
                reportType = 19;
            }
        }
        return reportType;
    }

    public static SelectorItemCollection getTemplateSelectorForWeaveRpt() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("sumType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("displayTemplateType"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("group"));
        return sic;
    }

    public static SelectorItemCollection getTemplateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("sumType"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.sumType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    private boolean verifySumReport(Context ctx, String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType, Object isSupportOtherDS, boolean isSupportGroupReport, String fastMergeSoluId) throws Exception {
        String dataCollectNumber = "ACTUALDATA";
        if (ctx == null && "true".equals(isSupportOtherDS)) {
            ICSLContext cslctx = CSLContextHelper.getCSLContext();
            dataCollectNumber = cslctx.getCurDataCollect().getNumber();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", treeID);
        params.put("companyID", companyID);
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currencyID);
        params.put("templateGroupNumber", templateGroupNumber);
        params.put("reportType", new Integer(reportType));
        params.put("dataCollectNumber", dataCollectNumber);
        params.put("isSupportGroupReport", new Boolean(isSupportGroupReport));
        params.put("fastMergeSoluId", fastMergeSoluId);
        ITempletDispense tempDisp = null;
        tempDisp = ctx == null ? TempletDispenseFactory.getRemoteInstance() : TempletDispenseFactory.getLocalInstance(ctx);
        return !tempDisp.isHasSameSumRpt(params);
    }

    public static String getSumrptBizSql(StringBuffer strSQL, Map mapParams, List params) {
        boolean isSupportGroupReport;
        int RptType = (Integer)mapParams.get("reportType");
        boolean isSingle = false;
        if (RptType == 7 || RptType == 1) {
            isSingle = true;
        }
        strSQL.append(" inner join  T_csl_SumRptAddedPerporty perporty on perporty.freport=rpt.fid ");
        strSQL.append("\twhere forgunitid = ? \t\t\t\t\t\n");
        params.add((String)mapParams.get("companyID"));
        if (mapParams.containsKey("dataCollectNumber")) {
            strSQL.append("\t\tand FDataCollectNumber = ?\t\t\t\t\n");
            params.add(mapParams.get("dataCollectNumber"));
        }
        if (!isSingle) {
            strSQL.append("\t\tand forgtreeid = ? \t\t\t\t\n");
            params.add((String)mapParams.get("treeID"));
        }
        strSQL.append("\t\tand fcurrencyid = ? \t\t\t\t\n");
        strSQL.append("\t\tand FSourceCurrencyID = ? \t\t\t\n");
        params.add((String)mapParams.get("currencyID"));
        params.add((String)mapParams.get("currencyID"));
        if (isSingle) {
            strSQL.append("\t\tand fsourcetype in (?, ?)\t\t\n");
            params.add(new Integer(7));
            params.add(new Integer(1));
        }
        strSQL.append("\t\tand fperiodtype = ? \t\t\t\t\n");
        params.add((Integer)mapParams.get("periodType"));
        strSQL.append("\t\tand fyear = ? \t\t\t\t\t\t\n");
        params.add((Integer)mapParams.get("year"));
        strSQL.append("\t\tand fperiod = ? \t\t\t\t\t\n");
        params.add((Integer)mapParams.get("period"));
        boolean bl = isSupportGroupReport = mapParams.containsKey("isSupportGroupReport") && (Boolean)mapParams.get("isSupportGroupReport") != false;
        if (isSupportGroupReport) {
            strSQL.append(" and fissupportgroup=1 ");
            strSQL.append(" and FSourceType IN (11, 14, 2)      \n");
        } else {
            String fastMergeSoluId = (String)mapParams.get("fastMergeSoluId");
            if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
                strSQL.append(" and rpt.ffastMergeSoluId = ? ");
                params.add(fastMergeSoluId);
            } else {
                strSQL.append(" and fsourcetype = ? ");
                params.add((Integer)mapParams.get("reportType"));
            }
        }
        strSQL.append("\t\tand ftemplateid in ( \t\t\t\t\n");
        strSQL.append("\t\tselect b.FID from t_rpt_template a,t_rpt_template b \t\n");
        strSQL.append("\t\twhere  a.fgroup = ? \t\t\t\t\t\t\t\t\t\t\n");
        params.add((String)mapParams.get("templateGroupNumber"));
        strSQL.append("\t\t       and a.fnumber = b.fnumber \t\t\t\t\t\t\n");
        strSQL.append("\t\t       and a.ftemplatetype = b.ftemplatetype \t\t\t\n");
        strSQL.append("\t\t       and a.fcompanyid = b.fcompanyid \t\t\t\t\t\n");
        strSQL.append("\t\t       and a.FperiodType = b.fperiodtype )\t\t\t\t\n");
        String reportId = (String)mapParams.get("reportId");
        if (reportId != null && reportId.length() != 0) {
            strSQL.append("\t\tand rpt.fid <> ? ");
            params.add(reportId);
        }
        return strSQL.toString();
    }

    public static SumRptAddedPerportyInfo getNextSumRptAddedPerportyInfo(Context ctx, Map mapParams) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        ArrayList params = new ArrayList();
        strSQL.append("\tselect perporty.freport ,perporty.fid ,perporty.fgroup ,perporty.fversionnumber from \tt_csl_cslreport rpt\n");
        RptAutoWeaveUtil.getSumrptBizSql(strSQL, mapParams, params);
        strSQL.append(" order by perporty.fversionnumber asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
        SumRptAddedPerportyInfo info = null;
        try {
            HashSet<Integer> versionNumbers = new HashSet<Integer>();
            while (rs.next()) {
                if (info == null) {
                    info = new SumRptAddedPerportyInfo();
                    info.setReport(rs.getString("freport"));
                    info.setGroup(rs.getString("fgroup"));
                }
                versionNumbers.add(rs.getInt("fversionnumber"));
            }
            if (info != null) {
                int versionNumber = 1;
                while (versionNumbers.contains(versionNumber)) {
                    ++versionNumber;
                }
                info.setVersion(versionNumber);
            }
            versionNumbers.clear();
            return info;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static String getSumRptid(Context ctx, Map mapParams) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        ArrayList params = new ArrayList();
        strSQL.append("\tselect top 1 rpt.fid from t_csl_cslreport rpt\t\n");
        RptAutoWeaveUtil.getSumrptBizSql(strSQL, mapParams, params);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                return rs.getString("fid");
            }
            return null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void getDynaKeyAndValue(CslReportInfo editData, List allKeyRow) throws Exception {
        if (editData.getBook() == null) {
            return;
        }
        Book book = editData.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null) continue;
            HashMap leftKeyColAndAllRow = CslRptUtil.getLeftColAndAllLeftRow(sheet, keyZone);
            if (valueZone == null || leftKeyColAndAllRow.get("leftCol") == null || (allKeyRow = (ArrayList)leftKeyColAndAllRow.get("allRow")).size() == 0) continue;
            ArrayList allValueCol = RptAutoWeaveUtil.getKeyValueCol(sheet, valueZone, allKeyRow);
            sheet.setUserObject("allValueCol", (Object)allValueCol);
            sheet.setUserObject("keyLeftCol", (Object)((Integer)leftKeyColAndAllRow.get("leftCol")));
            this.reSaveKeyZoneByRange(sheet, allKeyRow, (Integer)leftKeyColAndAllRow.get("leftCol"));
        }
        editData.setNewBook(book);
    }

    private void reSaveKeyZoneByRange(Sheet sheet, List allKeyRow, Integer keyLeftCol) {
        int beginRow;
        SumcalcRange newKeyZone = new SumcalcRange();
        Object[] o = allKeyRow.toArray();
        Arrays.sort(o);
        int endRow = beginRow = ((Integer)o[0]).intValue();
        for (int i = 0; i <= o.length && i != o.length + 1; ++i) {
            CellBlock cb;
            int row;
            if (i != o.length) {
                row = (Integer)o[i];
                if (endRow == row) {
                    ++endRow;
                    continue;
                }
                cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
                beginRow = row;
                endRow = row + 1;
                newKeyZone.addRange(sheet.getRange(cb));
                continue;
            }
            row = (Integer)o[o.length - 1];
            if (endRow - 1 != row) continue;
            cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
            newKeyZone.addRange(sheet.getRange(cb));
        }
        sheet.setUserObject("DYNAMICSUMKEYZONE", (Object)newKeyZone);
    }

    private static ArrayList getKeyValueCol(Sheet sheet, SumcalcRange zone, List allRow) {
        ArrayList<Integer> valueCol = new ArrayList<Integer>();
        for (int index = 0; index < zone.size(); ++index) {
            CellBlock block = zone.getCellBlock(index);
            for (int i = block.getCol(); i <= block.getCol2(); ++i) {
                if (valueCol.contains(new Integer(i))) continue;
                valueCol.add(new Integer(i));
            }
        }
        return valueCol;
    }

    private void setFormulaLocation(CslReportInfo editData, List allKeyRow) throws Exception {
        if (editData.getBook() == null) {
            return;
        }
        Book book = editData.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null || valueZone == null) continue;
            this.saveValueFormual(sheet, keyZone, valueZone, allKeyRow);
        }
        editData.setBook(book);
    }

    private void saveValueFormual(Sheet sheet, SumcalcRange keyZone, SumcalcRange valueZone, List allKeyRow) {
        ArrayList allValueCol;
        ArrayList arrayList = allValueCol = sheet.getUserObjectValue("allValueCol") == null ? null : (ArrayList)sheet.getUserObjectValue("allValueCol");
        if (allKeyRow == null || allKeyRow.size() == 0) {
            return;
        }
        if (allValueCol == null || allValueCol.size() == 0) {
            return;
        }
        HashMap<String, Cloneable> mapAll = new HashMap<String, Cloneable>();
        ArrayList<String> valueList = new ArrayList<String>();
        HashMap<String, Boolean> allHaveFormulaCol = new HashMap<String, Boolean>();
        for (int i = 0; i < keyZone.size(); ++i) {
            CellBlock block = keyZone.getCellBlock(i);
            for (int k = 0; k < allValueCol.size(); ++k) {
                int interRowIndex = -1;
                int index = -1;
                for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                    String formula;
                    ++interRowIndex;
                    Integer valueCol = (Integer)allValueCol.get(k);
                    Range range = sheet.getRange(j, valueCol.intValue());
                    if (range == null || !valueZone.contains(CellBlock.getNewCellBlock((int)j, (int)valueCol)) || range.getFormula() == null || range.getFormula().equals("") || !sheet.getCell(j, valueCol.intValue(), false).hasFormula() || (formula = range.getFormula()) == null || (formula = formula.trim()).equals("")) continue;
                    String dynaValueIndex = formula + "&" + i + "&" + j + "&" + valueCol;
                    valueList.add(dynaValueIndex);
                    ++index;
                }
                if (index != block.getRow2() - block.getRow()) continue;
                allHaveFormulaCol.put(i + "&" + (Integer)allValueCol.get(k), new Boolean(true));
            }
        }
        mapAll.put("allHaveFormulaCol", allHaveFormulaCol);
        mapAll.put("formulaLocation", valueList);
        sheet.setUserObject("fomulaLocation", mapAll);
    }

    public static ReportInfo getReportInfoByCslrpt(Context ctx, String cslReportID) throws BOSException {
        IReport iReport = null;
        iReport = ctx == null ? ReportFactory.getRemoteInstance() : ReportFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("cslReport", (Object)cslReportID);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        ReportCollection rptColl = iReport.getReportCollection(view);
        ReportInfo info = null;
        if (rptColl.size() > 0) {
            info = rptColl.get(0);
        }
        return info;
    }

    public static UserInfo getCurrentUser(Context ctx, String userId) throws BOSException, EASBizException {
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = iuser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        return userInfo;
    }

    public static OrgTreeCollection getOrgTreeCollect(Context ctx, boolean isBudget, List timeList, String userId) throws BOSException, EASBizException {
        OrgTreeCollection collection = null;
        collection = ctx == null ? (isBudget ? CslRptUIUtil.getHistoryOrgTreeCollection((Date)((Date)timeList.get(2))) : CslRptUIUtil.getOrgTreeCollection((Date)((Date)timeList.get(2)))) : CslRptUtil.getOrgTreeCollection(ctx, userId, (Date)timeList.get(2));
        Object tree = null;
        Object info = null;
        IOrgTree itree = null;
        itree = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
        if (!isBudget) {
            int n = collection.size();
            String[] ids = new String[n];
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                ids[i] = collection.get(i).getId().toString();
                set.add(collection.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isHide", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isHide", (Object)Boolean.FALSE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            filter.setMaskString("(#0 or #1) and #2");
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("IsForBudget"));
            view.getSelector().add(new SelectorItemInfo("name"));
            SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
            sorterItemInfo.setSortType(SortType.ASCEND);
            view.getSorter().add(sorterItemInfo);
            view.setFilter(filter);
            collection = itree.getOrgTreeCollection(view);
        }
        return collection;
    }

    protected static CslReportInfo getReportInfo(Context ctx, String reportID) throws Exception {
        if (StringUtils.isEmpty((String)reportID)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Csl_NoReport")));
        }
        SelectorItemCollection sic = RptAutoWeaveUtil.getSelectorForSpecial();
        ICslReport iReport = null;
        iReport = ctx == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(ctx);
        ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)reportID));
        return iReport.getCslReportInfo((IObjectPK)objectPK, sic);
    }

    public static SelectorItemCollection getSelectorForSpecial() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("reportDate"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("structure.longNumber"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("convertStatus"));
        sic.add(new SelectorItemInfo("parentStructure.id"));
        sic.add(new SelectorItemInfo("template.versionNumber"));
        sic.add(new SelectorItemInfo("receiveTime"));
        sic.add(new SelectorItemInfo("commitTime"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.orgType"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("commitor.name"));
        sic.add(new SelectorItemInfo("receiver.name"));
        sic.add(new SelectorItemInfo("dcfname"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("dataCollect.id"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        return sic;
    }

    public static IObjectPK getReportOrgPK(Context ctx, String reportId) throws Exception {
        CslReportInfo cslRpt = RptAutoWeaveUtil.getReportInfo(ctx, reportId);
        ObjectUuidPK reportOrgUnitPK = new ObjectUuidPK(cslRpt.getOrgUnit().getId());
        return reportOrgUnitPK;
    }

    public static boolean checkParentOrgPermissionByReport(Context ctx, CslReportInfo reportInfo, IObjectPK userPK) throws BOSException, Exception {
        IPermission permission = null;
        IOrgStructure orgStructure = null;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            orgStructure = OrgStructureFactory.getRemoteInstance();
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            orgStructure = OrgStructureFactory.getLocalInstance((Context)ctx);
        }
        OrgTreeCollection trees = permission.getAllUnionTrees(userPK);
        HashSet<String> hasPermTreeSet = new HashSet<String>();
        for (int i = 0; i < trees.size(); ++i) {
            hasPermTreeSet.add(trees.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("parent"));
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)RptAutoWeaveUtil.getReportOrgPK(ctx, reportInfo.getId().toString()).toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8)));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", hasPermTreeSet, CompareType.INCLUDE));
        OrgStructureCollection orgUnit = orgStructure.getOrgStructureCollection(view);
        boolean hasDirectMode = false;
        for (int i = 0; i < orgUnit.size(); ++i) {
            MergeModeEnum mergeMode;
            if (!hasPermTreeSet.contains(orgUnit.get(i).getTree().getId().toString()) || !MergeModeEnum.DIRECT.equals((Object)(mergeMode = RptAutoWeaveUtil.getMergeMode(ctx, orgUnit.get(i).getTree().getId().toString())))) continue;
            hasDirectMode = true;
            break;
        }
        if (hasDirectMode) {
            return RptAutoWeaveUtil.checkOrgPermissionDirect(ctx, reportInfo, userPK);
        }
        List parentUnitIDs = RptAutoWeaveUtil.getParentUnitIDByStructure(ctx, orgUnit);
        String permItem = "csl_indirpt_view";
        for (IObjectPK parentOrgPK : parentUnitIDs) {
            if (!permission.hasFunctionPermission(userPK, parentOrgPK, permItem)) continue;
            return true;
        }
        return false;
    }

    public static List getParentUnitIDByStructure(Context ctx, OrgStructureCollection orgUnit) throws BOSException {
        ArrayList<ObjectUuidPK> result = new ArrayList<ObjectUuidPK>();
        if (orgUnit != null && orgUnit.size() > 0) {
            HashSet<String> parentIDSet = new HashSet<String>();
            for (int i = 0; i <= orgUnit.size() - 1; ++i) {
                OrgStructureInfo parent = orgUnit.get(i).getParent();
                if (parent == null) continue;
                parentIDSet.add(parent.getId().toString());
            }
            if (parentIDSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("unit.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", parentIDSet, CompareType.INCLUDE));
                view.setFilter(filter);
                OrgStructureCollection orgStructureCollection = null;
                orgStructureCollection = ctx == null ? OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(view) : OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
                for (int i = 0; orgStructureCollection != null && i < orgStructureCollection.size(); ++i) {
                    result.add(new ObjectUuidPK(orgStructureCollection.get(i).getUnit().getId()));
                }
            }
        }
        return result;
    }

    public static boolean checkOrgPermissionDirect(Context ctx, CslReportInfo reportInfo, IObjectPK userPK) throws BOSException, Exception, EASBizException {
        IPermission permission = null;
        List ortUnitList = null;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            ortUnitList = RPTDataServiceFactory.getRemoteInstance().getAllCslReportParentOrg(reportInfo.getId().toString());
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            ortUnitList = RPTDataServiceFactory.getLocalInstance(ctx).getAllCslReportParentOrg(reportInfo.getId().toString());
        }
        if (ortUnitList != null && ortUnitList.size() > 0) {
            for (int i = 0; i <= ortUnitList.size() - 1; ++i) {
                if (!permission.hasFunctionPermission(userPK, (IObjectPK)new ObjectStringPK(ortUnitList.get(i).toString()), RptAutoWeaveUtil.getPermissionString(reportInfo))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPermissionString(CslReportInfo reportInfo) throws Exception {
        return "csl_indirpt_view";
    }

    public static void clearCurBookUserObject(Book book) {
        for (int m = 0; m < book.getSheetCount(); ++m) {
            book.getSheet(m).removeUserObject("FormulaErrorCell");
        }
    }

    public static boolean checkExistsRequisition(Context ctx, IObjectCollection coll, boolean isRptWeaveInvoke) throws Exception {
        ArrayList<List> list = new ArrayList<List>();
        String p1 = "";
        p1 = isRptWeaveInvoke ? ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_CACHECK_001") : ParamManager.getParamValue(null, null, (String)"GR_CSL_CACHECK_001");
        if (RptUtil.isTrue((Object)p1)) {
            return false;
        }
        p1 = isRptWeaveInvoke ? ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId()), (String)"GLG01") : ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), (String)"GLG01");
        if (RptUtil.isTrue((Object)p1)) {
            return false;
        }
        IVoucher iV = null;
        iV = isRptWeaveInvoke ? VoucherFactory.getLocalInstance((Context)ctx) : VoucherFactory.getRemoteInstance();
        Iterator it = coll.iterator();
        HashSet<String> PeriodAndYear = new HashSet<String>();
        while (it.hasNext()) {
            ReportBaseInfo info = (ReportBaseInfo)it.next();
            int period = info.getPeriod();
            int year = info.getYear();
            if (RptPeriodTypeEnum.MONTHLY != info.getPeriodType()) {
                Date periodLastDate = RPTDateUtil.getPeriodLastDate(year, period, info.getPeriodType());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                year = calendar.get(1);
                period = calendar.get(2) + 1;
            }
            if (PeriodAndYear.contains(String.valueOf(year) + String.valueOf(period))) continue;
            List checked = iV.requisitionCheckData(String.valueOf(year) + '.' + String.valueOf(period), 1, 2);
            if (list != null && list.size() > 0) {
                list.add(checked);
            }
            PeriodAndYear.add(String.valueOf(year) + String.valueOf(period));
        }
        if (list != null && list.size() > 0 && (Integer)list.get(0) != 0) {
            StringBuffer sResult = new StringBuffer();
            sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"265_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale())).append(list.get(1)).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"282_RptUtilForClient")).append("\n");
            sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"266_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale())).append(list.get(0)).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"282_RptUtilForClient")).append("\n");
            String[] s = (String[])list.get(2);
            if (s != null) {
                sResult.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"267_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
                for (int i = 0; i < s.length; ++i) {
                    sResult.append(s[i]).append(",");
                }
                sResult.deleteCharAt(sResult.length() - 1);
            }
            UIContext uictx = new UIContext((Object)ComponentUtil.getOwnerWindow(null));
            uictx.put((Object)"Title", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"268_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
            uictx.put((Object)"TextLabel", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"269_RptUtilForClient", (Locale)SysContext.getSysContext().getLocale()));
            uictx.put((Object)"TextMsg", (Object)sResult.toString());
            boolean result = CommonMsgBoxUI.showMessageByModel((UIContext)uictx);
            if (!result) {
                SysUtil.abort();
            }
        }
        return false;
    }

    public static TemplateInfo getTemplateInfo(Context ctx, String fid) throws BOSException, EASBizException {
        TemplateInfo template = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(fid));
        return template;
    }

    public static DataCollectInfo getDataColl() {
        return DataCollectConstant.getActualDC();
    }

    public static boolean checkReport(Context context, Object owner, String id, int iCheckEntry, Book book) throws BOSException, EASBizException {
        ICslReport icr = null;
        icr = context == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(context);
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        List result = icr.reportCheck(list, iCheckEntry);
        if (result != null && result.size() > 0) {
            boolean passed = true;
            String msg = null;
            for (int i = 0; i < result.size(); ++i) {
                Map data = (Map)result.get(i);
                if (data == null || data.get("KEY_CHECK_FLAG") == null) continue;
                passed = (Boolean)data.get("KEY_CHECK_FLAG");
                msg = (String)data.get("KEY_CHECK_MESSAGE");
                if (!passed) break;
            }
            if (context != null && !StringUtils.isEmpty(msg)) {
                ArrayList<String> unPassIdList = new ArrayList<String>();
                unPassIdList.add(id);
                ReportNoticeAndCheckTool.reportCommitNotice(context, unPassIdList, "checkAudit", msg);
                if (passed) {
                    return true;
                }
                throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail"));
            }
            if (!StringUtils.isEmpty(msg)) {
                UIContext ctx = new UIContext(owner);
                ctx.put((Object)"Title", (Object)CslRptUtil.getString("CslRptUUCheckResult"));
                ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                ctx.put((Object)"id", (Object)id);
                ctx.put((Object)"auditCheckAll", (Object)result);
                ctx.put((Object)"book", (Object)book);
                ctx.put((Object)"String", (Object)msg);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                uiWindow.show();
                ArrayList<String> unPassIdList = new ArrayList<String>();
                unPassIdList.add(id);
                ReportNoticeAndCheckTool.reportCommitNotice(unPassIdList, "checkAudit", msg);
            } else {
                RptAutoWeaveUtil.clearCurBookUserObject(book);
                ArrayList<String> reportIds = new ArrayList<String>();
                reportIds.add(id);
                if (reportIds.size() > 0) {
                    if (context == null) {
                        ItemFormulaCheckResultFactory.getRemoteInstance().batchDelete(reportIds);
                    } else {
                        ItemFormulaCheckResultFactory.getLocalInstance(context).batchDelete(reportIds);
                    }
                }
            }
            return passed;
        }
        return true;
    }

    public static SelectorItemCollection getCslRptSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("isCommitReport"));
        sic.add(new SelectorItemInfo("fastMergeSoluId"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("dataCollect"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.sumtype"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        return sic;
    }

    public static MergeModeEnum getMergeMode(Context ctx, String orgTreeId) throws EASBizException, BOSException {
        String mergeTypeStr = null;
        ObjectUuidPK pk = new ObjectUuidPK(orgTreeId);
        mergeTypeStr = ctx == null ? ParamManager.getParamValue((IObjectPK)pk, (String)"GR_CSL_MERGETYPE_004") : ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"GR_CSL_MERGETYPE_004");
        if ("0".equals(mergeTypeStr)) {
            return MergeModeEnum.DIRECT;
        }
        if ("1".equals(mergeTypeStr)) {
            return MergeModeEnum.ORDINAL;
        }
        throw new BOSException("error trying to get merge type");
    }

    public static FullOrgUnitInfo getTopOrgUnitInTree(Context ctx, String treeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT unit.fid,unit.fnumber,unit.flongnumber,unit.fname_l2,unit.FIsGrouping ,unit.fcontrolunitid from T_ORG_Structure s   \n ");
        sql.append(" inner join T_org_baseunit unit on s.funitid=unit.fid  \n ");
        sql.append(" WHERE ftreeid =? AND unit.fisGrouping = 1 and s.fparentid is null ");
        Object[] params = new Object[]{treeId};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rowSet.getString("fid")));
                orgUnit.setNumber(rowSet.getString("fnumber"));
                orgUnit.setLongNumber(rowSet.getString("flongnumber"));
                orgUnit.setName(rowSet.getString("fname_l2"));
                orgUnit.setIsGrouping(rowSet.getBoolean("FIsGrouping"));
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                cuInfo.setId(BOSUuid.read((String)rowSet.getString("fcontrolunitid")));
                orgUnit.setCU(cuInfo);
                return orgUnit;
            }
        }
        catch (SQLException e) {
            return null;
        }
        return null;
    }

    public static void saveRptWeaveTask(Context ctx, List jobList, List companyList, int year, int period, RptPeriodTypeEnum periodType, String schmId) throws BOSException, EASBizException {
        if (jobList.size() == 0) {
            return;
        }
        RptAutoWeaveUtil.setRptTaskNoUsage(ctx, year, period, periodType, schmId);
        RptWeaveSchmTaskInfo taskInfo = null;
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < jobList.size(); ++i) {
            taskInfo = new RptWeaveSchmTaskInfo();
            taskInfo.setJobinstid((String)jobList.get(i));
            taskInfo.setRptWeaveSchmId(schmId);
            taskInfo.setPeriodType(periodType);
            taskInfo.setYear(year);
            taskInfo.setPeriod(period);
            Calendar d = Calendar.getInstance();
            taskInfo.setCreateTime(new Timestamp(d.getTime().getTime()));
            taskInfo.setIsUsage(true);
            taskInfo.setCompanyId((String)companyList.get(i));
            baseColl.add((CoreBaseInfo)taskInfo);
        }
        RptWeaveSchmTaskFactory.getLocalInstance(ctx).addnew(baseColl);
    }

    private static void setRptTaskNoUsage(Context ctx, int year, int period, RptPeriodTypeEnum periodType, String schmId) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" update  T_CSL_Rptweaveschmtask  set fisUsage = 0  where FRptWeaveSchmId='").append(schmId).append("' and fisUsage = 1 ");
        DbUtil.execute((Context)ctx, (String)buffer.toString());
    }

    public static Job createWeaveRptJob(Context ctx, RptWeaveParams param, String title, String mutex, IJobHandler jobHandler) {
        JobInstanceConfig jobInstance = new JobInstanceConfig(jobHandler, true, false, 1, mutex, null, JobIsolationLevel.Server);
        String server = JobServerRunningConfig.getRptWeaveSetServer(ctx);
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis());
        Job job = new Job(ctx, title, jobInstance, (Object)param, scheduledTime, null, -1, server);
        try {
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            logger.error((Object)"RptAutoWeaveUtil.createWeaveRptJob", (Throwable)e);
        }
        return job;
    }

    public static boolean isQueueRptAutoWeave(Context ctx) {
        Map paramsMap;
        try {
            paramsMap = RptUtil.getCslParams((Context)ctx, (String[])new String[]{"KEY_CSLPARAM_RPTAUTOWEAVE_ISQUEUE"});
        }
        catch (Exception e) {
            return true;
        }
        return !"false".equalsIgnoreCase((String)paramsMap.get("KEY_CSLPARAM_RPTAUTOWEAVE_ISQUEUE"));
    }

    public static void clearSheetSumCellData(Book book) {
        Sheet sheet = null;
        Variant value = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            SumcalcRange sumRange;
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation() || (sumRange = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE")) == null) continue;
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int row = 0; row < rowCount; ++row) {
                int colCount = sheet.getMaxColIndex() + 1;
                for (int col = 0; col < colCount; ++col) {
                    CellBlock b;
                    Cell cell = sheet.getCell(row, col, false);
                    if (cell == null || !sumRange.contains(b = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol())) || (value = cell.getValue()) == null || value.isString()) continue;
                    cell.setValue(Variant.nullVariant);
                }
            }
        }
    }

    public static void clearSheetDynaCellData(Book book) {
        Sheet sheet = null;
        Variant value = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation()) continue;
            SumcalcRange dynaKeyRange = (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange dynaValueRange = (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (dynaKeyRange == null || dynaValueRange == null) continue;
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int row = 0; row < rowCount; ++row) {
                int colCount = sheet.getMaxColIndex() + 1;
                for (int col = 0; col < colCount; ++col) {
                    CellBlock b;
                    Cell cell = sheet.getCell(row, col, false);
                    if (cell == null || !dynaKeyRange.contains(b = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol())) && !dynaValueRange.contains(b) || (value = cell.getValue()) == null) continue;
                    cell.setValue(Variant.nullVariant);
                }
            }
        }
    }

    public static void clearCellData(Book book, boolean keepNoneSumRange, boolean keepLocked, boolean keepItemFormula, boolean onlyClearIncludeItem) {
        Sheet sheet = null;
        Variant value = null;
        int iLeft = 0;
        int iTop = 0;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation()) continue;
            SumcalcRange sumRange = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
            iTop = CslRptUtil.getBasePosition_Top(sheet);
            iLeft = CslRptUtil.getBasePosition_Left(sheet);
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int row = 0; row < rowCount; ++row) {
                if (row == iTop) continue;
                int colCount = sheet.getMaxColIndex() + 1;
                for (int col = 0; col < colCount; ++col) {
                    Cell cell;
                    if (col == iLeft || (cell = sheet.getCell(row, col, false)) == null || cell.isLocked() && keepLocked || onlyClearIncludeItem && cell.getUserObject("ITEM") == null) continue;
                    CellBlock b = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol());
                    if (keepNoneSumRange && sumRange != null && !sumRange.contains(b)) continue;
                    if (!keepItemFormula) {
                        cell.setUserObject("ITEM", null);
                    }
                    if (cell.getStyle() != null && cell.getStyle().getNumberFormat().equals("@") || (value = cell.getValue()) == null || value.isString()) continue;
                    cell.setValue(Variant.nullVariant);
                }
            }
        }
    }

    public static void refreshTableData(Map sheets, Map sheetData, int precision, boolean isRoundingByPrecision) {
        if (sheets == null || sheets.size() == 0 || sheetData == null || sheetData.size() == 0) {
            return;
        }
        for (String tableID : sheetData.keySet()) {
            if (tableID == null || tableID.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(tableID);
            HashMap curSheetData = (HashMap)sheetData.get(tableID);
            Iterator iterCell = curSheetData.keySet().iterator();
            Object o = null;
            HashMap v = new HashMap();
            while (iterCell.hasNext()) {
                Object obj = iterCell.next();
                Point position = (Point)obj;
                BigDecimal newValue = null;
                o = curSheetData.get(position);
                if (o != null && o instanceof HashMap) {
                    v = (HashMap)curSheetData.get(position);
                    if (v != null && v.get("value") != null) {
                        newValue = isRoundingByPrecision ? ((BigDecimal)v.get("value")).setScale(precision, 4) : (BigDecimal)v.get("value");
                    }
                } else if (o != null) {
                    newValue = isRoundingByPrecision ? ((BigDecimal)o).setScale(precision, 4) : (BigDecimal)o;
                }
                Cell cell = curSheet.getCell(position.y, position.x, true);
                if (newValue == null) {
                    cell.setValue(Variant.nullVariant);
                    continue;
                }
                cell.setValue(new Variant((Object)newValue));
            }
        }
    }

    public static HashMap getDynaKeyAndValue(Book book) throws Exception {
        if (book == null) {
            return null;
        }
        HashMap<Integer, ArrayList> sheetMap = new HashMap<Integer, ArrayList>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null) continue;
            HashMap leftKeyColAndAllRow = CslRptUtil.getLeftColAndAllLeftRow(sheet, keyZone);
            if (valueZone == null || leftKeyColAndAllRow.get("leftCol") == null) continue;
            ArrayList allKeyRow = (ArrayList)leftKeyColAndAllRow.get("allRow");
            sheetMap.put(new Integer(i), allKeyRow);
            if (allKeyRow.size() == 0) continue;
            ArrayList allValueCol = RptAutoWeaveUtil.getKeyValueCol(sheet, valueZone, allKeyRow);
            sheet.setUserObject("allValueCol", (Object)allValueCol);
            sheet.setUserObject("keyLeftCol", (Object)((Integer)leftKeyColAndAllRow.get("leftCol")));
            RptAutoWeaveUtil.reSaveKeyZoneByRange(sheet, allKeyRow, (Integer)leftKeyColAndAllRow.get("leftCol"));
        }
        return sheetMap;
    }

    public static SumcalcRange reSaveKeyZoneByRange(Sheet sheet, ArrayList allKeyRow, Integer keyLeftCol) {
        int beginRow;
        SumcalcRange newKeyZone = new SumcalcRange();
        if (allKeyRow.size() == 0) {
            return null;
        }
        Object[] o = allKeyRow.toArray();
        Arrays.sort(o);
        int endRow = beginRow = ((Integer)o[0]).intValue();
        for (int i = 0; i <= o.length && i != o.length + 1; ++i) {
            CellBlock cb;
            int row;
            if (i != o.length) {
                row = (Integer)o[i];
                if (endRow == row) {
                    ++endRow;
                    continue;
                }
                cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
                beginRow = row;
                endRow = row + 1;
                newKeyZone.addRange(sheet.getRange(cb));
                continue;
            }
            row = (Integer)o[o.length - 1];
            if (endRow - 1 != row) continue;
            cb = CellBlock.getNewCellBlock((int)beginRow, (int)keyLeftCol, (int)(endRow - 1), (int)keyLeftCol);
            newKeyZone.addRange(sheet.getRange(cb));
        }
        return newKeyZone;
    }

    public static void setFormulaLocation(Book book) throws Exception {
        if (book == null) {
            return;
        }
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            SumcalcRange valueZone;
            Sheet sheet = book.getSheet(i);
            SumcalcRange keyZone = sheet.getUserObjectValue("DYNAMICSUMKEYZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            SumcalcRange sumcalcRange = valueZone = sheet.getUserObjectValue("DYNAMICSUMVALUEZONE") == null ? null : (SumcalcRange)sheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            if (keyZone == null || valueZone == null) continue;
            RptAutoWeaveUtil.saveValueFormual(sheet, keyZone, valueZone);
        }
    }

    public static void saveValueFormual(Sheet sheet, SumcalcRange keyZone, SumcalcRange valueZone) {
        ArrayList allValueCol;
        ArrayList arrayList = allValueCol = sheet.getUserObjectValue("allValueCol") == null ? null : (ArrayList)sheet.getUserObjectValue("allValueCol");
        if (allValueCol == null || allValueCol.size() == 0) {
            return;
        }
        HashMap<String, Cloneable> mapAll = new HashMap<String, Cloneable>();
        ArrayList<String> valueList = new ArrayList<String>();
        HashMap<String, Boolean> allHaveFormulaCol = new HashMap<String, Boolean>();
        for (int i = 0; i < keyZone.size(); ++i) {
            CellBlock block = keyZone.getCellBlock(i);
            for (int k = 0; k < allValueCol.size(); ++k) {
                int interRowIndex = -1;
                int index = -1;
                for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                    String formula;
                    ++interRowIndex;
                    Integer valueCol = (Integer)allValueCol.get(k);
                    Range range = sheet.getRange(j, valueCol.intValue());
                    if (range == null || !valueZone.contains(CellBlock.getNewCellBlock((int)j, (int)valueCol)) || range.getFormula() == null || range.getFormula().equals("") || !sheet.getCell(j, valueCol.intValue(), false).hasFormula() || (formula = range.getFormula()) == null || (formula = formula.trim()).equals("")) continue;
                    String dynaValueIndex = formula + "&" + i + "&" + j + "&" + valueCol;
                    valueList.add(dynaValueIndex);
                    ++index;
                }
                if (index != block.getRow2() - block.getRow()) continue;
                allHaveFormulaCol.put(i + "&" + (Integer)allValueCol.get(k), new Boolean(true));
            }
        }
        mapAll.put("allHaveFormulaCol", allHaveFormulaCol);
        mapAll.put("formulaLocation", valueList);
        sheet.setUserObject("fomulaLocation", mapAll);
    }

    public static void paintBackColor(Sheet curSheet, SumcalcRange newSumRange) {
        if (curSheet == null || newSumRange == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(new Color(223, 225, 0, 60));
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        for (int i = 0; i < newSumRange.size(); ++i) {
            CellBlock sb = newSumRange.getCellBlock(i);
            for (int iCol = sb.getCol(); iCol <= sb.getCol2(); ++iCol) {
                for (int iRow = sb.getRow(); iRow <= sb.getRow2(); ++iRow) {
                    curSheet.getCell(iRow, iCol, true);
                }
            }
        }
    }

    public static HashMap getAllValueRow(Sheet sheet, SumcalcRange zone, Integer colIndex) {
        HashMap map = new HashMap();
        ArrayList<Integer> allRow = new ArrayList<Integer>();
        for (int index = 0; index < zone.size(); ++index) {
            CellBlock block = zone.getCellBlock(index);
            for (int i = block.getRow(); i <= block.getRow2(); ++i) {
                if (block.getCol() > colIndex || block.getCol2() < colIndex) continue;
                for (int j = block.getCol(); j <= block.getCol2(); ++j) {
                    if (j != colIndex || allRow.contains(new Integer(i))) continue;
                    allRow.add(new Integer(i));
                }
            }
        }
        map.put("allRow", allRow);
        return map;
    }

    public static RptWeaveSchmTaskCollection getSchmTaskColl(Context ctx, String schemeId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("jobinstid"));
        sic.add(new SelectorItemInfo("companyId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rptWeaveSchmId", (Object)schemeId));
        filter.getFilterItems().add(new FilterItemInfo("isUsage", (Object)Boolean.TRUE));
        view.setFilter(filter);
        RptWeaveSchmTaskCollection taskColl = RptWeaveSchmTaskFactory.getLocalInstance(ctx).getRptWeaveSchmTaskCollection(view);
        return taskColl;
    }

    public static Map getCslParams(Context ctx, String[] keys) throws BOSException, EASBizException {
        HashMap<Object, Object> paramsMap = new HashMap<Object, Object>();
        StringBuffer sql = new StringBuffer("Select FKey, FValue From T_Csl_CslParam where FKey in ( ");
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(keys[i]).append("'");
        }
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                Object fkey = rowSet.getObject("FKey");
                Object fvalue = rowSet.getObject("FValue");
                paramsMap.put(fkey, fvalue);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return paramsMap;
    }
}

