/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ReportNoticeAndCheckTool;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractRptWeaveExecute {
    protected static final Logger logger = Logger.getLogger(AbstractRptWeaveExecute.class);
    protected RptWeaveParams schmParam;
    protected Context ctx;
    protected String userId;
    protected LogService logService;

    public AbstractRptWeaveExecute(RptWeaveParams schmParam, Context ctx) {
        this.schmParam = schmParam;
        this.ctx = ctx;
        this.logService = new LogService(logger);
    }

    protected void beforeExecute() throws Exception {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        this.userId = execParam.getUserId();
        this.executeLogInfo("start.");
    }

    public void execute() throws Exception {
        this.beforeExecute();
        try {
            this.executeRptWeave();
        }
        catch (Exception e) {
            this.executeLogInfo("error.\n" + e.getCause());
            throw e;
        }
        this.afterExecute();
    }

    protected void afterExecute() {
        this.executeLogInfo("completed.");
    }

    protected OrgType getTemplateOrgType() {
        return this.getTemplateInfo().getOrgType();
    }

    protected void checkPermissionByReport(Context ctx, CslReportInfo editData, IObjectPK userPK, boolean isReceived) throws Exception {
        if (!RptAutoWeaveUtil.checkParentOrgPermissionByReport(ctx, editData, userPK)) {
            StringBuffer buffer = new StringBuffer();
            if (isReceived) {
                buffer.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"you", (Locale)ctx.getOriginLocale())).append(1).append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"596_ReceiveListUI", (Locale)ctx.getOriginLocale())).append("\n");
                buffer.append(CslRptUtil.getString("NO_ReceivePermissio_Report"));
            } else {
                buffer.append(CslRptUtil.getString("906_hasNotSendBackPermission"));
            }
            buffer.append(editData.getOrgUnit().getName()).append("  ").append(editData.getNumber()).append("  ").append(editData.getName());
            throw new RptWeaveException(buffer.toString());
        }
    }

    protected String executeLogInfo(String appendEndingStr) {
        StringBuffer msg = new StringBuffer(100);
        String templateId = this.getTemplateInfo() == null ? "NULL" : this.getTemplateInfo().getId().toString();
        msg.append(":::RptWeaveExeNode=").append(this.getClass().getSimpleName()).append(",[company:").append(this.getCompanyOrgUnitInfo().getNumber()).append(",templateID:").append(templateId).append("] execute " + appendEndingStr);
        this.logService.addLogItem("", msg.toString());
        return msg.toString();
    }

    protected abstract void executeRptWeave() throws Exception;

    private FullOrgUnitInfo getCompanyOrgUnitInfo() {
        return (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
    }

    private TemplateInfo getTemplateInfo() {
        return (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
    }

    protected String getExistRptId() throws BOSException, EASBizException {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        FullOrgUnitInfo orgUnitInfo = this.getCompanyOrgUnitInfo();
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
        String cslrptId = execParam.getCslrptId();
        if (StringUtils.isEmpty((String)cslrptId)) {
            TemplateInfo templateInfo = this.getTemplateInfo();
            int periodType = templateInfo.getPeriodType().getValue();
            int period = this.schmParam.getInt("Period");
            int year = this.schmParam.getInt("Year");
            CurrencyInfo currency = null;
            currency = this.schmParam.containsKey("currency") ? (CurrencyInfo)this.schmParam.getObject("currency") : schmRptInfo.getCurrency();
            cslrptId = RptWeaveCalcHelper.getRptidInSameVersion(templateInfo, (OrgUnitInfo)orgUnitInfo, currency, periodType, period, year, this.ctx);
            if (cslrptId == null) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"NOREPORT_CannotOPER", (Locale)this.ctx.getOriginLocale()));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isCommitReport"));
            ICslReport iReport = CslReportFactory.getLocalInstance(this.ctx);
            CslReportInfo cslrptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslrptId)), sic);
            execParam.setCommitReport(cslrptInfo.isIsCommitReport());
            if (cslrptInfo.isIsCommitReport()) {
                try {
                    return RptAutoWeaveUtil.getReportInfoByCslrpt(this.ctx, cslrptInfo.getId().toString()).getId().toString();
                }
                catch (BOSException e) {
                    logger.error((Object)("getExistRptId:" + cslrptInfo.getId()), (Throwable)e);
                    throw e;
                }
            }
        }
        if (StringUtils.isEmpty((String)execParam.getCslrptId())) {
            execParam.setCslrptId(cslrptId);
        }
        return cslrptId;
    }

    protected void cslrptAduit(Context ctx, CslReportInfo editData) throws Exception {
        if (editData.getPublishedStatus() == PublishedStatusEnum.PUBLISHED) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"3_BaseReportDesignerUI", (Locale)ctx.getOriginLocale()));
        }
        if (CommittedStatusEnum.GROUPCOMMITTED.equals((Object)editData.getCommittedStatus())) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORTISAUDIT_CANNOTAUDIT", (Locale)ctx.getOriginLocale()));
        }
        if (editData.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            return;
        }
        boolean isTopLevel = false;
        if (editData.getAuditedStatus() == AuditedStatusEnum.UNAUDITED) {
            RptSrcTypeEnum srcType = editData.getSourceType();
            if ((srcType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || srcType.equals((Object)RptSrcTypeEnum.SUM) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || srcType.equals((Object)RptSrcTypeEnum.MANUSCRIPT) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) && CslRptUtil.isCslTopLevelAtServer(ctx, editData)) {
                isTopLevel = true;
            }
            if (!RptAutoWeaveUtil.checkReport(ctx, null, editData.getId().toString(), 2, editData.getBook())) {
                String errMsg = CslRptUtil.getString("CslRptUCheckFail");
                ArrayList<String> unPassIdList = new ArrayList<String>();
                unPassIdList.add(editData.getId().toString());
                ReportNoticeAndCheckTool.reportCommitNotice(unPassIdList, "checkAudit", errMsg);
                throw new RptWeaveException(errMsg);
            }
            ArrayList<String> ReportIdList = new ArrayList<String>();
            ReportIdList.add(editData.getId().toString());
            if (ReportIdList.size() > 0) {
                ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
                RptAutoWeaveUtil.clearCurBookUserObject(editData.getBook());
            }
            RptSrcTypeEnum rptSrcType = editData.getSourceType();
            if (RptUtil.isTrue((Object)ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_CheckNumber")) && (rptSrcType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || rptSrcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || rptSrcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT))) {
                Book book = editData.getBook();
                FullOrgUnitInfo object = editData.getCompany();
                ArrayList result1 = new ArrayList();
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    DynamicTemplateUtility.checkDynaAccountItem((Sheet)book.getSheet(i), (int)editData.getSourceType().getValue(), (boolean)true, (Object)object, result1);
                }
                if (result1 != null && result1.size() > 0) {
                    if (result1.size() > 50) {
                        throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail") + "\n" + result1.subList(0, 30).toString());
                    }
                    throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail") + "\n" + result1.toString());
                }
            }
        }
        this.resetContext(editData);
        CslReportFactory.getLocalInstance(ctx).audit((IObjectPK)new ObjectUuidPK(editData.getId()));
        editData.setAuditedStatus(AuditedStatusEnum.AUDITED);
        if (isTopLevel) {
            editData.setCommittedStatus(CommittedStatusEnum.GROUPCOMMITTED);
        }
    }

    private void resetContext(CslReportInfo reportInfo) throws BOSException, EASBizException {
        String companyid = reportInfo.getOrgUnit().getId().toString();
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        this.ctx.put((Object)"CompanyInfo", (Object)fullOrgUnitInfo);
        this.ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)fullOrgUnitInfo, this.ctx));
    }

    public String buildLogMsg() {
        return this.logService.builderLogMessage();
    }

    protected void cslrptCommit(Context ctx, CslReportInfo editData) throws Exception {
        String result;
        if (editData.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"224_RptReportProcessUI", (Locale)ctx.getOriginLocale()));
        }
        ArrayList<String> passedIdList = new ArrayList<String>();
        if (!CslRptUtil.isNewVersionStatus(ctx, editData, null)) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"8_BaseReportDesignerUI", (Locale)ctx.getOriginLocale()));
        }
        if (!RptAutoWeaveUtil.checkReport(ctx, this, editData.getId().toString(), 3, editData.getBook())) {
            throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail"));
        }
        ArrayList<String> ReportIdList = new ArrayList<String>();
        ReportIdList.add(editData.getId().toString());
        if (ReportIdList.size() > 0) {
            ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
            RptAutoWeaveUtil.clearCurBookUserObject(editData.getBook());
        }
        passedIdList.add(editData.getId().toString());
        HashSet<String> companyidset = new HashSet<String>();
        if (editData.getReportSourceType() != null && !CslRptUtil.isCslRpt(editData.getReportSourceType().getValue())) {
            companyidset.add(editData.getCompany().getId().toString());
            HashMap isCheckOpenmap = new HashMap();
            if (companyidset.size() > 0) {
                isCheckOpenmap = CslRptUtil.getrptSysStatusCtrol(ctx, companyidset);
            }
            if (!CslRptUtil.checkGeneralLedgerIsCheckout(ctx, isCheckOpenmap, editData)) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"General_Ledger_Not_Checkout", (Locale)ctx.getOriginLocale());
                throw new RptWeaveException(MessageFormat.format(msg, String.valueOf(editData.getYear()), String.valueOf(CslRptUIUtil.getPeriod((int)editData.getPeriodType().getValue(), (int)editData.getPeriod()))));
            }
        }
        if ((result = CslReportFactory.getLocalInstance(ctx).commitReportLocal(editData.getId().toString())) == null) {
            editData.setCommittedStatus(CommittedStatusEnum.COMMITTED);
        }
        if (passedIdList != null && passedIdList.size() > 0) {
            ReportNoticeAndCheckTool.reportCommitNotice(ctx, passedIdList, "reportCommit", null);
        }
    }

    protected void cslReceive(Context ctx, CslReportInfo editData) throws Exception {
        if (editData.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            return;
        }
        if (CommittedStatusEnum.COMMITTED != editData.getCommittedStatus()) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORT_NORECEIVE", (Locale)ctx.getOriginLocale()));
        }
        ObjectStringPK userPK = new ObjectStringPK(this.userId);
        this.checkPermissionByReport(ctx, editData, (IObjectPK)userPK, true);
        String rptId = editData.getId().toString();
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(rptId);
        List time = RPTDateUtil.getRptYearAndPeriodAndDate(editData.getYear(), editData.getPeriod(), editData.getPeriodType());
        OrgTreeCollection collection = RptAutoWeaveUtil.getOrgTreeCollect(ctx, false, time, this.userId);
        if (collection.size() == 0) {
            return;
        }
        this.resetContext(editData);
        List checkResult = RPTDataServiceFactory.getLocalInstance(ctx).receive(list, this.userId, collection.get(0).getId().toString());
        String param = ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_RECEIVECHECK_001");
        StringBuffer error = new StringBuffer();
        if ("true".equalsIgnoreCase(param)) {
            ArrayList<String> unPassIds = new ArrayList<String>();
            for (int i = 0; i < checkResult.size(); ++i) {
                Map data = (Map)checkResult.get(i);
                if (data == null || data.get("KEY_ID") == null) continue;
                String id = (String)data.get("KEY_ID");
                String currency = editData.getCurrency().getName();
                boolean passed = (Boolean)data.get("KEY_CHECK_FLAG");
                String msg = (String)data.get("KEY_CHECK_MESSAGE");
                if (!StringUtils.isEmpty((String)msg)) {
                    error.append(CslRptUtil.getStringWithFormat("batchAuditCheckErrorMsg", new Object[]{editData.getName(), editData.getDataCollect().getName(), currency}));
                    error.append(msg);
                    unPassIds.add(id);
                }
                if (passed) continue;
                ReportNoticeAndCheckTool.reportCommitNotice(ctx, unPassIds, "checkReceive", error.toString());
                throw new RptWeaveException(error.toString());
            }
        }
        ReportNoticeAndCheckTool.reportCommitNotice(ctx, list, "reportReceive", null);
    }

    protected SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        return sic;
    }

    protected CslReportInfo getCslReportInfo(Context ctx, String reportID) throws Exception {
        ICslReport iReport = CslReportFactory.getLocalInstance(ctx);
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), RptAutoWeaveUtil.getCslRptSelectors());
    }

    public void checkOperatePermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(userPK, orgPK, permItemName);
    }
}

