/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmBase;
import com.kingdee.eas.fi.gr.weaverpt.LogTrace;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptAutoWeaveSchmBaseControllerBean;
import com.kingdee.eas.fi.gr.weaverpt.app.RowSetHandler;
import com.kingdee.eas.fi.gr.weaverpt.app.SchmReportReduplicateStrategy;
import com.kingdee.eas.fi.gr.weaverpt.app.Statistic;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAutoWeaveSchmBaseControllerBean
extends AbstractRptAutoWeaveSchmBaseControllerBean {
    private static final long serialVersionUID = 4186242577721804795L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.weaverpt.app.RptAutoWeaveSchmBaseControllerBean");

    @Override
    protected boolean _exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            return super._exists(ctx, pk);
        }
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            return this.getRptSchmInstance(ctx).exists(pk);
        }
        return this.getSumSchmInstance(ctx).exists(pk);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RptAutoWeaveSchmRptInfo info = (RptAutoWeaveSchmRptInfo)this.getValue(ctx, pk);
        if (info != null) {
            return info.getLogInfo();
        }
        return null;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            return super._getValue(ctx, pk);
        }
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            return this.getRptSchmInstance(ctx).getValue(pk);
        }
        return this.getSumSchmInstance(ctx).getValue(pk);
    }

    private IRptAutoWeaveSchmBase getRptSchmInstance(Context ctx) throws BOSException {
        return RptAutoWeaveSchmRptFactory.getLocalInstance(ctx);
    }

    private IRptAutoWeaveSchmBase getSumSchmInstance(Context ctx) throws BOSException {
        return RptWeaveSchmSumFactory.getLocalInstance(ctx);
    }

    private boolean isNotBaseInvoke() {
        return !new RptAutoWeaveSchmBaseInfo().getBOSType().equals((Object)this.getBOSType());
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            super._update(ctx, pk, model);
            return;
        }
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            this.getRptSchmInstance(ctx).update(pk, (RptAutoWeaveSchmRptInfo)model);
            return;
        }
        this.getSumSchmInstance(ctx).update(pk, (RptAutoWeaveSchmRptInfo)model);
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            return super._update(ctx, colls);
        }
        if (colls.isEmpty()) {
            return null;
        }
        BOSUuid id = (BOSUuid)colls.getObject(0).get(colls.getObject(0).getPKField());
        CoreBaseCollection cbColls = new CoreBaseCollection();
        cbColls.addObjectCollection(colls);
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            return this.getRptSchmInstance(ctx).update(cbColls);
        }
        return this.getSumSchmInstance(ctx).update(cbColls);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            if (this.isRunningScheme(ctx, pk.toString())) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANNOT_GOON_FOR_SCHM_EXECUTING"));
            }
            model.put("isFreezed", (Object)Boolean.TRUE);
            super._cancel(ctx, pk, model);
            if (!StringUtils.isEmpty((String)model.getString("jobProcessDef"))) {
                EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(model.getString("jobProcessDef"), false);
            }
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            model.put("isFreezed", (Object)Boolean.FALSE);
        }
        if (this.isNotBaseInvoke()) {
            super._cancelCancel(ctx, pk, model);
            if (!StringUtils.isEmpty((String)model.getString("jobProcessDef"))) {
                EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(model.getString("jobProcessDef"), true);
            }
            return;
        }
        BOSUuid id = BOSUuid.read((String)pk.toString());
        RptAutoWeaveSchmBaseInfo completeModel = (RptAutoWeaveSchmBaseInfo)model;
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            this.getRptSchmInstance(ctx).cancelCancel(pk, (CoreBaseInfo)completeModel);
        } else {
            this.getSumSchmInstance(ctx).cancelCancel(pk, (CoreBaseInfo)completeModel);
        }
        if (!StringUtils.isEmpty((String)model.getString("jobProcessDef"))) {
            EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(model.getString("jobProcessDef"), true);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            super._delete(ctx, pk);
            return;
        }
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            this.getRptSchmInstance(ctx).delete(pk);
            return;
        }
        this.getSumSchmInstance(ctx).delete(pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            super._delete(ctx, arrayPK);
            return;
        }
        LinkedList<IObjectPK> rptSchmPKs = new LinkedList<IObjectPK>();
        LinkedList<IObjectPK> sumSchmPKs = new LinkedList<IObjectPK>();
        BOSUuid id = null;
        IObjectPK pk = null;
        BOSObjectType rptSchmBOSType = new RptAutoWeaveSchmRptInfo().getBOSType();
        for (int i = 0; i < arrayPK.length; ++i) {
            pk = arrayPK[i];
            id = BOSUuid.read((String)pk.toString());
            if (rptSchmBOSType.equals((Object)id.getType())) {
                rptSchmPKs.add(pk);
                continue;
            }
            sumSchmPKs.add(pk);
        }
        if (!rptSchmPKs.isEmpty()) {
            this.getRptSchmInstance(ctx).delete(rptSchmPKs.toArray(new IObjectPK[rptSchmPKs.size()]));
        }
        if (!sumSchmPKs.isEmpty()) {
            this.getSumSchmInstance(ctx).delete(sumSchmPKs.toArray(new IObjectPK[sumSchmPKs.size()]));
        }
    }

    @Override
    public RptAutoWeaveSchmBaseCollection _getCollectionForDimStyle(Context ctx, EntityViewInfo view) throws BOSException {
        if (this.isNotBaseInvoke()) {
            return super.getCollectionForDimStyle(ctx, view);
        }
        RptAutoWeaveSchmBaseCollection schmInfos = new RptAutoWeaveSchmBaseCollection();
        RptAutoWeaveSchmRptCollection rptSchmInfos = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptCollection(view);
        int size = rptSchmInfos.size();
        for (int i = 0; i < size; ++i) {
            schmInfos.add(rptSchmInfos.get(i));
        }
        return schmInfos;
    }

    @Override
    protected IRowSet _queryReport(Context ctx, EntityViewInfo entityViewInfo, RptWeaveSchmTypeEnum schmType) throws BOSException, EASBizException {
        String queryPK = "com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmReportQuery";
        if (RptWeaveSchmTypeEnum.RPTSCHM.equals((Object)schmType)) {
            queryPK = "com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveRptSchmReportQuery";
        } else if (RptWeaveSchmTypeEnum.SUMRPTSCHM.equals((Object)schmType)) {
            queryPK = "com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSumSchmReportQuery";
        }
        LogTrace.trace("queryPK", queryPK);
        MetaDataPK pk = MetaDataPK.create((String)queryPK);
        if (!(entityViewInfo.get("preparedSqlParams") instanceof Object[])) {
            LogTrace.trace("error", "preparedSqlParams is null");
            return null;
        }
        LogTrace.trace("preparedSqlParams's size", entityViewInfo.get("preparedSqlParams"));
        IQueryExecutor queryExe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        queryExe.setObjectView(entityViewInfo);
        String sql = queryExe.getSQL();
        LogTrace.trace("sql", sql);
        LogTrace.recordTime();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])entityViewInfo.get("preparedSqlParams")));
        LogTrace.printRecordTime("sql execute time");
        SchmReportReduplicateStrategy reduplicateStrategy = new SchmReportReduplicateStrategy();
        try {
            return new RowSetHandler().deleteDup(rs, reduplicateStrategy);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
    }

    private int queryReportAssistToIsRepeat(Map repeatStrs, ResultSet result) throws SQLException {
        StringBuffer repeatKey = new StringBuffer();
        repeatKey.append(result.getString("SCHMID"));
        repeatKey.append('|');
        repeatKey.append(result.getString("COMPNUMBER"));
        repeatKey.append('|');
        repeatKey.append(result.getString("TPLNUMBER"));
        String currRowRptId = result.getString("RPTID");
        if (repeatStrs.containsKey(repeatKey.toString())) {
            String preRowRptId = (String)repeatStrs.get(repeatKey.toString());
            if (preRowRptId != null && currRowRptId == null) {
                return 0;
            }
            if (preRowRptId == null && currRowRptId != null) {
                return -1;
            }
            logger.error((Object)"repeat's stragry is error", (Throwable)new Exception());
        }
        repeatStrs.put(repeatKey.toString(), currRowRptId);
        return -2;
    }

    @Override
    public Map _abortSchemeTask(Context ctx, String schemeId) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)schemeId);
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            return RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).abortSchemeTask(schemeId);
        }
        if (new RptWeaveSchmSumInfo().getBOSType().equals((Object)id.getType())) {
            return RptWeaveSchmSumFactory.getLocalInstance(ctx).abortSchemeTask(schemeId);
        }
        return null;
    }

    @Override
    protected boolean _isRunningScheme(Context ctx, String schemeId) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from T_CSL_RptWeaveSchmTask task");
        sql.append(" inner join T_JOB_INST  job on task.FJobinstid=job.fjobinstid ");
        sql.append(" where task.frptWeaveSchmId=? and  fstate= ?");
        Object[] params = new Object[]{schemeId, JobState.Running.toString()};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private boolean isCreateJobAndNOComplate(Context ctx, String schemeId) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from T_CSL_RptWeaveSchmTask task");
        sql.append(" inner join T_JOB_INST  job on task.FJobinstid=job.fjobinstid ");
        sql.append(" where task.frptWeaveSchmId=?  and task.fisusage=1 ");
        sql.append(" and fstate in('");
        sql.append(JobState.Created).append("','").append(JobState.ReScheduled).append("','").append(JobState.Running).append("')");
        Object[] params = new Object[]{schemeId};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    @Override
    protected void _schemeImmediatelyRun(Context ctx, String pk, String userId, Map executeParams) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            return;
        }
        if (this.isCreateJobAndNOComplate(ctx, pk)) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE"));
        }
        BOSUuid id = BOSUuid.read((String)pk);
        if (new RptAutoWeaveSchmRptInfo().getBOSType().equals((Object)id.getType())) {
            this.getRptSchmInstance(ctx).schemeImmediatelyRun(pk, userId, executeParams);
        } else if (new RptWeaveSchmSumInfo().getBOSType().equals((Object)id.getType())) {
            this.getSumSchmInstance(ctx).schemeImmediatelyRun(pk, userId, executeParams);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNotBaseInvoke()) {
            super._checkNumberDup(ctx, model);
            return;
        }
        if (model == null || !(model instanceof RptAutoWeaveSchmBaseInfo)) {
            return;
        }
    }

    @Override
    protected Map<String, Object> _queryReportNew(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        boolean isNewQuery = condition.getBoolean("KEY_IS_NEWQUERY");
        if (isNewQuery) {
            this.releaseTmpTbl(ctx, condition.getString("rstTbl"));
            this.constructReportData2TmpTbl(ctx, condition);
        }
        HashMap<String, Object> rstMap = new HashMap<String, Object>();
        rstMap.put("result", this.getNextPageResult(ctx, condition));
        rstMap.put("statistic", this.getStatistic(ctx, condition));
        rstMap.put("condition", condition);
        return rstMap;
    }

    private RptRowSet getNextPageResult(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(50);
        sql.append(" select CompNumber,CompName,TplNumber,TplVersionNum,RptNameOrTplName,").append(" TplType,RptCurrencyName,RptCommittedStatus,ResultType,").append(" TplPeriodType,RptId,CompId,LogTplId,LogStartTime,SchmType,RPTAUDITEDSTATUS from ").append(condition.getString("rstTbl")).append(this.getQueryWhereSql(condition)).append(" order by compnumber,tplnumber asc");
        Connection con = null;
        SqlParams sp = new SqlParams();
        try {
            con = this.getConnection(ctx);
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql.toString(), (SqlParams)sp, (int)condition.getInt("from"), (int)condition.getInt("length"), (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void constructReportData2TmpTbl(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        this.createTmpTable(ctx, condition);
        this.insertHavenRptInfo2RptTmpTbl(ctx, condition);
        this.insertRptLogInfo2RstTmpTbl(ctx, condition);
        this.insertSchmInfo2TmpTbl(ctx, condition);
        this.insertConvertReportInfo2TmpTbl(ctx, condition);
        this.releaseTmpTbl(ctx, condition.getString("rptTbl"));
        condition.remove("rptTbl");
    }

    private void insertConvertReportInfo2TmpTbl(Context ctx, RptProperties condition) throws EASBizException, BOSException {
        String schmid = condition.getString("SchmId");
        RptAutoWeaveSchmRptInfo info = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptInfo("select convertSolution where id = '" + schmid + "'");
        QuerySolutionInfo convertSolution = info.getConvertSolution();
        if (convertSolution != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(condition.getString("rstTbl")).append(" \n");
            sql.append(" select temp.schmid,temp.compnumber,temp.compname,temp.tplnumber,temp.tpltype,temp.tplversionnum,currency.fname_l2,temp.tplperiodtype, \n");
            sql.append(" temp.compid,temp.schmtplid,temp.resulttype,temp.logrptyear,temp.logrptperiod,report.fid,report.FCOMMITTEDSTATUS, \n");
            sql.append(" temp.logtplid,temp.logstarttime,temp.schmtype,report.fname, temp.fgroup,report.fauditedstatus \n");
            sql.append(" from t_rpt_report report \n");
            sql.append(" inner join t_bd_currency currency on report.FCURRENCYID = currency.FID \n");
            sql.append(" inner join ").append(condition.getString("rstTbl")).append(" temp on temp.compid = report.FCOMPANYID  and temp.logtplid = report.FTEMPLATEID \n");
            sql.append(" where report.FSRCREPORT = temp.rptid and report.FYEAR = ? and report.fperiod = ?");
            ArrayList<Integer> params = new ArrayList<Integer>(2);
            params.add(condition.getInt("year"));
            params.add(condition.getInt("period"));
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
    }

    private int[] getStatistic(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        int from = condition.getInt("from");
        String tblName = condition.getString("rstTbl");
        if (from == 0) {
            String whereSql = this.getQueryWhereSql(condition);
            String statisSql = Statistic.getInstance().getStatisticSql(tblName, whereSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)statisSql);
            int[] statistic = new int[5];
            int count = 0;
            try {
                while (rs.next()) {
                    statistic[rs.getInt((String)"state")] = rs.getInt("cnt");
                    count += rs.getInt("cnt");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            statistic[4] = count;
            return statistic;
        }
        return null;
    }

    private String getQueryWhereSql(RptProperties condition) {
        String whereSql = "";
        whereSql = "KEY_VIEW_ORG".equals(condition.getString("KEY_VIEW")) ? this.getOrgViewWhereSql(condition) : this.getTemplateViewWhereSql(condition);
        return whereSql;
    }

    private String getTemplateViewWhereSql(RptProperties condition) {
        String templateID = condition.getString("SchmTplID");
        String whereSql = "ALL".equals(templateID) ? "" : " where FGROUP in( select fgroup from t_rpt_template where fid ='" + templateID + "')";
        return whereSql;
    }

    private String getOrgViewWhereSql(RptProperties condition) {
        String companyID = condition.getString("CompID");
        String whereSql = "ALL".equals(companyID) ? "" : " where compID = '" + companyID + "'";
        return whereSql;
    }

    private void insertRptLogInfo2RstTmpTbl(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(800);
        String lan = ctx.getLocale().getLanguage();
        sql.append(" insert into ").append(condition.getString("rstTbl")).append(" select schm.fid,cmp.fnumber,cmp.fname_" + lan + ",logtmpl.fnumber,rpt.fsourcetype, \n").append(" logtmpl.fversionnumber,currency.fname_" + lan + ",logtmpl.ftemplatetype,cmp.fid, \n").append(" logtmpl.fid,rptlog.fresulttype,rptlog.fyear,rptlog.fperiod,rpt.fid, \n").append(" rpt.fcommittedstatus,logtmpl.fid,rptlog.fcreatetime,1, \n").append(" case when (rpt.fname is null) then logtmpl.fname else rpt.fname end,logtmpl.fgroup,rpt.fauditedstatus \n").append(" from t_csl_rptautoweavelog rptlog \n").append(" join t_csl_rptweaveschmrpt schm on rptlog.frptweaveschmid = schm.fid \n").append(" join t_org_baseUnit cmp on cmp.fid = rptlog.fcompanyid").append(" join t_bd_currency currency on schm.flastCalculateCurrency = currency.fid \n").append(" join t_rpt_template logtmpl on rptlog.ftemplateid = logtmpl.fid \n").append(" left join ").append(condition.getString("rptTbl")).append(" rpt ").append(" on logtmpl.fgroup = rpt.fgroup and rptlog.fcompanyid = rpt.fcompanyid \n").append(" where schm.fid = ? \n").append(" and rptlog.fyear = ? \n").append(" and rptlog.fperiod = ? \n").append(" and rptlog.fperiodtype = ? \n").append(" ");
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(condition.getString("SchmId"));
        params.add(condition.getInt("year"));
        params.add(condition.getInt("period"));
        params.add(condition.getInt("periodType"));
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private void insertHavenRptInfo2RptTmpTbl(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        boolean isReceiveSchm = false;
        if (condition.containsKey("isReceiveSchm") && condition.getBoolean("isReceiveSchm")) {
            isReceiveSchm = true;
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append(" insert into ").append(condition.getString("rptTbl"));
        if (isReceiveSchm) {
            sql.append(" select distinct case when rpt2.fid is null then rpt.fid else rpt.fid end fid, rpt.fcompanyid,rpt.fname, rpt.fnumber, tmpl.fgroup,rpt.fsourcetype,rpt.fcommittedstatus,rpt.fauditedstatus  \n").append(" from t_csl_cslreport rpt \n").append(" left join t_rpt_report rpt2 on rpt.fid=rpt2.fcslreportid ");
        } else {
            sql.append(" select distinct rpt.fid, rpt.fcompanyid,rpt.fname, rpt.fnumber, tmpl.fgroup,rpt.fsourcetype,rpt.fcommittedstatus,rpt.fauditedstatus  \n").append(" from t_rpt_report rpt \n");
        }
        sql.append(" join t_rpt_template tmpl on rpt.ftemplateid = tmpl.fid \n").append(" join ( select tmpl2.fgroup from t_csl_rptweaveschmtempentry tmpEntry \n").append("        join t_rpt_template tmpl2 on tmpEntry.ftemplate = tmpl2.fid \n").append("        where tmpEntry.Fschemeid = ? ) tmpEntry2 on tmpl.fgroup = tmpEntry2.fgroup \n").append(" join t_csl_rptweaveschmcompentry schmcmp on rpt.fcompanyid = schmcmp.fcompany \n").append(" where schmcmp.fscheme = ? \n");
        if (isReceiveSchm) {
            sql.append(" and rpt.fsourceType in(1,7,10,13) ");
        } else {
            sql.append("  and rpt.FIsSupportGroup = 1 ");
        }
        sql.append(" and rpt.fperiodtype = ? \n").append(" and rpt.fyear = ? and rpt.fperiod = ? \n").append(" and rpt.fcurrencyid = ? and rpt.fsourceType <> ? \n");
        ArrayList<Object> params = new ArrayList<Object>(6);
        params.add(condition.getString("SchmId"));
        params.add(condition.getString("SchmId"));
        params.add(condition.getInt("periodType"));
        params.add(condition.getInt("year"));
        params.add(condition.getInt("period"));
        params.add(condition.getString("currencyId"));
        params.add(100);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        if (isReceiveSchm) {
            Date rptDate = RPTDateUtil.getPeriodLastDate(condition.getInt("year"), condition.getInt("period"), RptPeriodTypeEnum.getEnum((int)condition.getInt("periodType")));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = sdf.format(rptDate);
            String rptdateFormat = "{ts'" + curDate + "'}";
            sql.setLength(0);
            sql.append(" insert into ").append(condition.getString("rptTbl")).append(" select distinct rpt.fid,company.fsrcCompanyId,rpt.fname,rpt.fnumber,tmpl.fgroup,rpt.fsourcetype,rpt.fcommittedstatus,rpt.fauditedstatus \n").append("from t_csl_cslreport rpt \n").append("inner join t_rpt_template tmpl on rpt.ftemplateid = tmpl.fid \n").append("inner join ( select tmpl2.fgroup from t_csl_rptweaveschmtempentry tmpEntry \n").append("        inner join t_rpt_template tmpl2 on tmpEntry.ftemplate = tmpl2.fid \n").append("       where tmpEntry.Fschemeid = ? and  tmpl2.ftemplateType in(3,5,11,13,17,18) ) tmpEntry2 on tmpl.fgroup = tmpEntry2.fgroup\n").append("inner join ( \n").append("  select distinct unit2.fid frptCompanyId,unit.fid fsrcCompanyId from t_csl_rptweaveschmcompentry schmcmp  \n").append("  inner join t_org_baseunit unit on schmcmp.fcompany=unit.fid \n").append("  inner join t_org_structure struc on struc.funitid=unit.fid \n").append("  inner join t_org_tree tree on tree.fid=struc.ftreeid \n").append("  inner join t_org_tree tree2 on tree2.fnumber=tree.fnumber and tree2.fstatus in(1,2) and tree2.ftype=8 \n").append("  inner join t_org_structure struc2 on struc2.ftreeid=tree2.fid \n").append("  inner join t_org_baseunit unit2 on unit2.fid=struc2.funitid and unit2.fnumber=unit.fnumber \n").append("  where schmcmp.fscheme = ? and unit.fisunion=1 and unit2.fisunion=1 and tree2.fstartdate<=").append(rptdateFormat).append("  and (tree2.fenddate>=").append(rptdateFormat).append(" or tree2.fenddate is null) ) company on company.frptCompanyId=rpt.forgunitid  \n").append("inner join T_Csl_SumRptAddedPerporty addedPerporty on addedPerporty.freport=rpt.fid and addedPerporty.FIsSupportGroup=1 ").append("where rpt.fperiodtype = ? \n").append("and rpt.fyear = ? and rpt.fperiod = ? \n").append("and rpt.fcurrencyid = ? and rpt.fsourceType <> ? \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
    }

    private void insertSchmInfo2TmpTbl(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(1000);
        String lan = ctx.getLocale().getLanguage();
        sql.append(" insert into ").append(condition.getString("rstTbl")).append(" select schm.fid,cmp.fnumber,cmp.fname_" + lan + ",schmTmpl.fnumber,\n").append(" CASE schmTmpl.ftemplatetype  WHEN 6 THEN 2 WHEN 10 THEN 12 \n").append(" WHEN 15 THEN 16 ELSE schmTmpl.FTemplateType END AS ftemplatetype, \n").append(" schmTmpl.fversionnumber,currency.fname_" + lan + ",schmTmpl.fperiodtype,cmp.fid,schmTmpl.fid, \n").append(" 3,0,0,rpt.fid,rpt.fcommittedstatus,schmTmpl.fid,null,1, \n").append(" case when (rpt.fname is null) then schmTmpl.fname else rpt.fname end,schmTmpl.fgroup,rpt.fauditedstatus \n").append(" FROM T_CSL_RptWeaveSchmRpt schm \n").append(" INNER JOIN T_CSL_RptWeaveSchmCompEntry cmpEntry ON schm.FID = cmpEntry.FScheme \n").append(" INNER JOIN T_CSL_RptWeaveSchmTempEntry tmplEntry ON schm.FID = tmplEntry.FSchemeID \n").append(" INNER JOIN T_ORG_BASEUNIT cmp ON cmpEntry.FCompany = cmp.FID \n").append(" INNER JOIN T_BD_currency currency on schm.flastCalculateCurrency = currency.fid \n").append(" INNER JOIN T_RPT_Template schmTmpl ON tmplEntry.FTemplate = schmTmpl.FID \n").append(" LEFT JOIN ").append(condition.getString("rptTbl")).append(" rpt \n").append(" ON schmTmpl.fgroup = rpt.fgroup and cmpEntry.FCompany = rpt.fcompanyid \n").append(" where schm.fid = ? \n").append(" and not exists( select 'X' from ").append(condition.getString("rstTbl")).append(" rptlog where rptlog.fgroup = schmTmpl.fgroup and rptlog.compid = cmp.FID ) \n").append(" and (schmTmpl.FTemplateType in(2,6,10,12,15,16) and cmp.fisunion<>1 ").append(" or schmTmpl.FTemplateType in(3,5,11,13,17,18) and cmp.fisunion=1 )");
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(condition.getString("SchmId"));
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private void releaseTmpTbl(Context ctx, String tblName) {
        if (!StringUtils.isEmpty((String)tblName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tblName);
        }
    }

    private void createTmpTable(Context ctx, RptProperties condition) throws BOSException {
        String tmpTable = this.createResultTmpTbl(ctx);
        condition.setString("rstTbl", tmpTable);
        tmpTable = this.createTmpTbl4Rpt(ctx);
        condition.setString("rptTbl", tmpTable);
    }

    private String createResultTmpTbl(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(400);
        createSql.append(" create table T_AUTOWEAVE_TMPTBL(").append(" SCHMID VARCHAR(44),COMPNUMBER NVARCHAR(80),COMPNAME NVARCHAR(255),").append(" TPLNUMBER NVARCHAR(80),TPLTYPE INT,TPLVERSIONNUM NVARCHAR(80),").append(" RPTCURRENCYNAME NVARCHAR(255),TPLPERIODTYPE INT,COMPID VARCHAR(44),").append(" SCHMTPLID VARCHAR(44),RESULTTYPE INT,LOGRPTYEAR INT,LOGRPTPERIOD INT,").append(" RPTID VARCHAR(44),RPTCOMMITTEDSTATUS INT,LOGTPLID VARCHAR(44),").append(" LOGSTARTTIME DateTime,SCHMTYPE INT,RptNameOrTplName NVARCHAR(255),").append(" FGROUP VARCHAR(44),RPTAUDITEDSTATUS INT)");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "FGROUP", false, false);
            pool.createIndex(tableName, "COMPID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTmpTbl4Rpt(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(400);
        createSql.append(" create table T_WEAVERPT_TMPTBL(").append(" FID VARCHAR(44),FCOMPANYID VARCHAR(44),FNAME NVARCHAR(255),FNUMBER NVARCHAR(80),").append(" FGROUP VARCHAR(44),FSOURCETYPE INT,FCOMMITTEDSTATUS INT,FAUDITEDSTATUS INT)");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "FGROUP,FCOMPANYID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _qucikDeleteRptBySchm(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        boolean isDel = false;
        String rptIdTbl = this.createRptIdTbl(ctx);
        try {
            List<String> rptIds = this.InsertRptIdToTempTable(ctx, rptIdTbl, condition);
            List<String> convertedRptIds = this.getConvertedRptBySourceRptId(ctx, rptIdTbl, condition);
            if (convertedRptIds != null && !convertedRptIds.isEmpty()) {
                this.batchDeleteRpt(ctx, convertedRptIds);
                isDel = true;
            }
            if (rptIds != null && !rptIds.isEmpty()) {
                this.batchDeleteRpt(ctx, rptIds);
                isDel = true;
            }
        }
        finally {
            this.releaseTmpTbl(ctx, rptIdTbl);
        }
        return isDel;
    }

    private void batchDeleteRpt(Context ctx, List<String> ids) throws BOSException {
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(ids);
            HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
            ArrayList<String> exceptionIds = new ArrayList<String>();
            Iterator<String> lt = ids.iterator();
            Throwable[] ex = null;
            while (lt.hasNext()) {
                String id = lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.", (String)"Error_ObjectUpdateLock_Request", (Locale)ctx.getOriginLocale())));
                exceptionMap.put(id, mutexException);
                exceptionIds.add(id);
                lt.remove();
            }
            if (ids.size() > 0) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (ids.get(i) == null) continue;
                    ObjectStringPK pk = new ObjectStringPK(ids.get(i));
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class, Boolean.class}, new Object[]{pk, true});
                }
                BatchExecuteResult result = ReportFactory.getLocalInstance((Context)ctx).batchExecute("forceDelete", new Class[]{IObjectPK.class, Boolean.class}, paramEntries);
                ex = result.getExceptions();
                for (int i = 0; i < ex.length; ++i) {
                    if (ex[i] == null) continue;
                    exceptionMap.put(ids.get(i), ex[i]);
                    exceptionIds.add(ids.get(i));
                }
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(ids);
        }
    }

    private List<String> getConvertedRptBySourceRptId(Context ctx, String rptIdTbl, RptProperties condition) throws EASBizException, BOSException {
        String schmid = condition.getString("schmId");
        RptAutoWeaveSchmRptInfo info = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptInfo("select convertSolution where id = '" + schmid + "'");
        QuerySolutionInfo convertSolution = info.getConvertSolution();
        ArrayList<String> rptIds = new ArrayList<String>();
        if (convertSolution != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select report.fid id \n");
            sql.append(" from t_rpt_report report \n");
            sql.append(" inner join ").append(rptIdTbl).append(" temp On report.FSRCREPORT = temp.rptId \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rowset.next()) {
                    String rptId = rowset.getString("id");
                    rptIds.add(rptId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return rptIds;
    }

    private List<String> InsertRptIdToTempTable(Context ctx, String rptIdTbl, RptProperties condition) throws BOSException {
        ArrayList<String> rptIds = new ArrayList<String>();
        StringBuffer sql = new StringBuffer(200);
        sql.append(" insert into ").append(rptIdTbl);
        sql.append(" select distinct rpt.fid \n").append(" from t_rpt_report rpt \n");
        sql.append(" join t_rpt_template tmpl on rpt.ftemplateid = tmpl.fid \n").append(" join ( select tmpl2.fgroup from t_csl_rptweaveschmtempentry tmpEntry \n").append("        join t_rpt_template tmpl2 on tmpEntry.ftemplate = tmpl2.fid \n").append("        where tmpEntry.Fschemeid = ? ) tmpEntry2 on tmpl.fgroup = tmpEntry2.fgroup \n").append(" join t_csl_rptweaveschmcompentry schmcmp on rpt.fcompanyid = schmcmp.fcompany \n").append(" where schmcmp.fscheme = ? and rpt.FIsSupportGroup = 1 \n");
        sql.append(" and rpt.fperiodtype = ? and rpt.fyear = ? and rpt.fperiod = ?  ");
        sql.append(" and rpt.fcurrencyid = ? and rpt.fsrcreport is null \n");
        int stataus = condition.getInt("status");
        if (stataus == 0) {
            sql.append(" and rpt.FAuditedStatus = ? \n");
        } else if (stataus == 1) {
            sql.append(" and rpt.FAuditedStatus in (?,?) And rpt.FCommittedStatus = ? \n");
        } else if (stataus == 2) {
            sql.append(" and rpt.FAuditedStatus in (?,?) And rpt.FCommittedStatus = ? \n");
        } else {
            sql.append(" and rpt.FAuditedStatus in (?,?) And rpt.FCommittedStatus in (?,?) \n");
        }
        sql.append(" and rpt.fsourceType <> ? \n");
        ArrayList<Object> params = new ArrayList<Object>(6);
        params.add(condition.getString("schmId"));
        params.add(condition.getString("schmId"));
        params.add(condition.getInt("periodType"));
        params.add(condition.getInt("year"));
        params.add(condition.getInt("period"));
        params.add(condition.getString("currencyId"));
        if (stataus == 0) {
            params.add(1);
        } else if (stataus == 1) {
            params.add(1);
            params.add(2);
            params.add(1);
        } else if (stataus == 2) {
            params.add(1);
            params.add(2);
            params.add(2);
        } else {
            params.add(1);
            params.add(2);
            params.add(1);
            params.add(2);
        }
        params.add(100);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        sql = new StringBuffer(200);
        sql.append(" select rptId from ").append(rptIdTbl);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowset.next()) {
                String rptId = rowset.getString("rptId");
                rptIds.add(rptId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rptIds;
    }

    private String createRptIdTbl(Context ctx) throws BOSException {
        String tableName;
        StringBuffer sql = new StringBuffer();
        sql.append(" create table T_Weave_Rpt(rptId VARCHAR(44))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }
}

