/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeRelaInfo;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointFactory;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class RptWeaveExecAddNew
extends AbstractRptWeaveExecute {
    private static final String RPT_NUMBER_HEAD = "AT";

    public RptWeaveExecAddNew(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void executeRptWeave() throws Exception {
        TemplateInfo templateInfo = (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        int periodType = templateInfo.getPeriodType().getValue();
        int period = this.schmParam.getInt("Period");
        int year = this.schmParam.getInt("Year");
        boolean isFromAutoGetData = this.schmParam.getBoolean("rptautoweave_isfromgeextractdataf");
        CurrencyInfo currency = null;
        if (this.schmParam.containsKey("currency")) {
            currency = (CurrencyInfo)this.schmParam.getObject("currency");
        } else if (!this.schmParam.getBoolean("rpt_web_isRptExec")) {
            RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
            currency = schmRptInfo.getCurrency();
        }
        String cslrptId = null;
        if (!isFromAutoGetData) {
            cslrptId = RptWeaveCalcHelper.getRptidInSameVersion(templateInfo, (OrgUnitInfo)orgUnitInfo, currency, periodType, period, year, this.ctx);
        }
        logger.info((Object)("addNew:cslrptId-----------------" + cslrptId == null ? "null" : cslrptId));
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        if (cslrptId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isCommitReport"));
            ICslReport iReport = CslReportFactory.getLocalInstance(this.ctx);
            CslReportInfo cslrptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslrptId)), sic);
            if (!cslrptInfo.isIsCommitReport()) {
                throw new ServerException(ServerException.EXISTS_SAME_RPT);
            }
            execParam.setCommitReport(cslrptInfo.isIsCommitReport());
            cslrptId = RptAutoWeaveUtil.getReportInfoByCslrpt(this.ctx, cslrptInfo.getId().toString()).getId().toString();
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"840_RptWeaveExceCopyPre", (Locale)this.ctx.getOriginLocale()));
        } else {
            String rptId;
            cslrptId = rptId = this.addNewReport();
            execParam.setCommitReport(true);
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"841_RptWeaveExecAddNew", (Locale)this.ctx.getOriginLocale()) + cslrptId));
        }
        execParam.setCslrptId(cslrptId);
    }

    @Override
    protected void beforeExecute() throws Exception {
        super.beforeExecute();
        if (this.schmParam.getBoolean("rptautoweave_isfromgeextractdataf")) {
            return;
        }
        if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
            return;
        }
        FullOrgUnitInfo orgUnitInfo = null;
        try {
            orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
            this.checkAddNewPermission(this.ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getAddNewPermNameByOrgType((OrgType)this.getTemplateOrgType()));
        }
        catch (Exception exc) {
            logger.info((Object)("Permission-user:" + this.userId + " comp:" + orgUnitInfo.getId()));
            throw exc;
        }
    }

    public void checkAddNewPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission ip = PermissionFactory.getLocalInstance((Context)ctx);
        ip.checkFunctionPermission(userPK, orgPK, permItemName);
    }

    private void setRptNumber(Context ctx, ReportBaseInfo baseInfo, String templateNumber, int year, int period) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)baseInfo.getCompany(), ctx);
        boolean isCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)baseInfo, company.getId().toString(), "sourceType");
        if (!isCodingRule) {
            String number = this.getCurrentNumber(ctx, templateNumber, year, period, "T_RPT_Report");
            baseInfo.setNumber(number);
        }
    }

    private String getCurrentNumber(Context ctx, String templateNumber, int year, int period, String tableName) throws BOSException {
        BigDecimal number = this.getCurrentMaxNumberVauleFromDb(ctx, templateNumber, year, period, tableName);
        String numberStr = number.toString();
        if (numberStr.contains(".")) {
            String[] array = numberStr.split("\\.");
            numberStr = array[0];
            number = new BigDecimal(numberStr);
        }
        StringBuffer ret = new StringBuffer(RPT_NUMBER_HEAD);
        ret.append(templateNumber).append(year).append(period);
        int n = 3 - number.toString().length();
        for (int i = 0; i < n; ++i) {
            ret.append("0");
        }
        ret.append(number);
        return ret.toString();
    }

    private BigDecimal getCurrentMaxNumberVauleFromDb(Context ctx, String templateNumber, int year, int period, String tableName) throws BOSException {
        BigDecimal number = new BigDecimal("1");
        StringBuffer sbSQL = new StringBuffer(" SELECT Max(to_number(Right(a.fnumber,3))) As Fmaxnumber From \r\n");
        sbSQL.append(tableName).append(" a   INNER JOIN  T_RPT_Template  b on (a.ftemplateid= b.fid or a.ftemplateid = b.fgrouptemplateid) \r\n");
        sbSQL.append("\tWHERE b.fnumber = '").append(templateNumber).append("' \r\n");
        sbSQL.append("  and a.fyear = ").append(year).append(" \r\n");
        sbSQL.append("  and a.fperiod = ").append(period).append(" \r\n");
        sbSQL.append("  and a.fNumber like N'AT" + templateNumber + year + period + "%' escape '\\' \r\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
            if (rs.next() && rs.getBigDecimal("Fmaxnumber") != null) {
                number = rs.getBigDecimal("Fmaxnumber").add(new BigDecimal("1"));
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return number;
    }

    public String addNewReport() throws Exception {
        logger.info((Object)"addNewReport-----------------");
        TemplateInfo templateInfo = (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
        templateInfo = RptAutoWeaveUtil.getTemplateInfo(this.ctx, templateInfo.getId().toString());
        int periodType = templateInfo.getPeriodType().getValue();
        int period = this.schmParam.getInt("Period");
        int year = this.schmParam.getInt("Year");
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE)) {
            reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.COMMITREPORT);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        }
        Object obj = this.schmParam.getObject("rptautoweave_extractdatafid");
        if (obj != null && obj instanceof FormulaCalcContextInfo) {
            reportInfo.put("KEY_FORMULACALCID", (Object)((FormulaCalcContextInfo)obj).getId().toString());
        }
        reportInfo.setYear(year);
        reportInfo.setPeriod((short)period);
        reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
        reportInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
        reportInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        reportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        reportInfo.setCompany(orgUnitInfo);
        reportInfo.setCU(orgUnitInfo.getCU());
        reportInfo.setName(templateInfo.getName());
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
        CurrencyInfo currency = null;
        if (this.schmParam.containsKey("currency")) {
            currency = (CurrencyInfo)this.schmParam.getObject("currency");
        } else if (schmRptInfo != null) {
            currency = schmRptInfo.getCurrency();
        }
        reportInfo.setCurrency(currency);
        reportInfo.setTemplate(templateInfo);
        reportInfo.setExchangeRate(new BigDecimal("1"));
        reportInfo.setPeriodType(templateInfo.getPeriodType());
        reportInfo.setHandleStatus(RptHandleStatusEnum.FINISHED);
        reportInfo.setOrgType(templateInfo.getOrgType());
        DataCollectInfo dataCollectSelected = RptAutoWeaveUtil.getDataColl();
        reportInfo.setDataCollect(dataCollectSelected);
        reportInfo.setDataCollectNumber(dataCollectSelected.getNumber());
        this.setSavePoint(templateInfo, reportInfo, orgUnitInfo);
        PeriodCollection periods = null;
        if (templateInfo.getOrgType().getValue() == 6) {
            CompanyOrgUnitInfo fiOrg = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.ProfitCenter, orgUnitInfo.getId().toString(), this.ctx);
            String fiOrgId = fiOrg.getId().toString();
            periods = InitDataFacadaFactory.getLocalInstance((Context)this.ctx).getFiscal((IObjectPK)new ObjectUuidPK(fiOrgId));
        } else {
            periods = InitDataFacadaFactory.getLocalInstance((Context)this.ctx).getFiscal((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
        }
        if (periods == null || periods != null && periods.size() == 0) {
            reportInfo = this.setStartDateAndEndDate(periodType, reportInfo);
        } else {
            Date periodfirstDate = FiscalPeriodHelper.getPeriodFirstDate(year, period, templateInfo.getPeriodType(), periods, true);
            Date periodLastDate = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, templateInfo.getPeriodType(), true);
            if (periodfirstDate == null && periodLastDate == null) {
                reportInfo = this.setStartDateAndEndDate(periodType, reportInfo);
            } else {
                reportInfo.setStartDate(periodfirstDate);
                reportInfo.setEndDate(periodLastDate);
            }
        }
        this.setRptNumber(this.ctx, (ReportBaseInfo)reportInfo, templateInfo.getNumber(), year, period);
        reportInfo.setIsOpenAutoCalc(false);
        reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
        reportInfo.setIsSupportAdjust(false);
        UserInfo user = new UserInfo();
        if (StringUtils.isEmpty((String)this.userId)) {
            RptWeaveExecParams taskExecParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_web_execparams");
            this.userId = taskExecParam.getUserId();
        }
        user.setId(BOSUuid.read((String)this.userId));
        reportInfo.setCreator(user);
        reportInfo.put("rptautoweave_extractdatafid", this.schmParam.getObject("rptautoweave_extractdatafid"));
        Book book = null;
        FormulaSoluInfo formulaSoluInfo = null;
        try {
            boolean isK3Enable = AccountORMFactory.getLocalInstance((Context)this.ctx).isLockByCompany((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
            TemplateInfo k3template = null;
            if (isK3Enable && (k3template = this.getK3TmpByEasTmpid(this.ctx, templateInfo.getId().toString(), orgUnitInfo.getId().toString())) != null) {
                reportInfo.setK3Template(k3template);
                book = k3template.getBook();
                RptUtilForServer.LockBookExpTank((Book)book);
                reportInfo.setBook(book);
                this.ctx.put((Object)"CurOU", (Object)orgUnitInfo);
            }
            if (!isK3Enable || k3template == null) {
                TemplateInfo template = reportInfo.getTemplate();
                book = template.getBook();
                template.setFromTemplate(false);
                try {
                    formulaSoluInfo = FormulaSoluCalcHelp.getInstance().preTemplateBookFormulaSoluForServer(this.ctx, book, (OrgUnitInfo)orgUnitInfo, template);
                    Book newBook = formulaSoluInfo.getReportBook();
                    reportInfo.setBook(newBook);
                }
                catch (Exception e) {
                    RptUtilForServer.LockBookExpTank((Book)book);
                    reportInfo.setBook(book);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"addNewReport", (Throwable)e);
            if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"311_addNewError", (Locale)this.ctx.getOriginLocale()), e.getLocalizedMessage());
            }
            throw e;
        }
        reportInfo.getSheetParam().addCollection(this.queryTemplateParams());
        reportInfo.put("rptautoweave_isfromgeextractdataf", (Object)this.schmParam.getBoolean("rptautoweave_isfromgeextractdataf"));
        this.resetContext(reportInfo);
        IObjectPK pk = ReportFactory.getLocalInstance((Context)this.ctx).addnew((CoreBaseInfo)reportInfo);
        if (formulaSoluInfo != null && formulaSoluInfo.getId() != null) {
            FormulaSoluCalcHelp.getInstance().saveReportUseFormula(pk.toString(), formulaSoluInfo.getId().toString(), formulaSoluInfo.getData());
        }
        return pk.toString();
    }

    private void resetContext(ReportInfo reportInfo) throws BOSException, EASBizException {
        String companyid = reportInfo.getCompany().getId().toString();
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        this.ctx.put((Object)"CompanyInfo", (Object)fullOrgUnitInfo);
        this.ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)fullOrgUnitInfo, this.ctx));
    }

    private ReportInfo setStartDateAndEndDate(int periodType, ReportInfo reportInfo) {
        if (periodType == 1) {
            Date default_GR_Date = null;
            default_GR_Date = reportInfo.getPeriod() == 13 ? RPTDateUtil.getEndOfMonth(reportInfo.getYear(), 12) : RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod(), RptPeriodTypeEnum.DAILY);
            reportInfo.setStartDate(default_GR_Date);
            reportInfo.setEndDate(default_GR_Date);
        } else if (periodType == 2) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.WEEKLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.WEEKLY));
        } else if (periodType == 3) {
            if (reportInfo.getPeriod() == 13) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, reportInfo.getYear());
                calendar.set(2, 11);
                calendar.set(5, 31);
                Date date = new Date(calendar.getTimeInMillis());
                reportInfo.setStartDate(date);
                reportInfo.setEndDate(date);
            } else {
                reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.MONTHLY));
                reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.MONTHLY));
            }
        } else if (periodType == 4) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.QUARTERLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.QUARTERLY));
        } else if (periodType == 5) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.SEMIYEARLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.SEMIYEARLY));
        } else if (periodType == 6) {
            reportInfo.setPeriod((short)1);
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.YEARLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.YEARLY));
        } else {
            Calendar calendar = Calendar.getInstance();
            reportInfo.setStartDate(new Date(calendar.getTimeInMillis()));
            reportInfo.setEndDate(new Date(calendar.getTimeInMillis()));
        }
        return reportInfo;
    }

    private void setSavePoint(TemplateInfo templateInfo, ReportInfo reportInfo, FullOrgUnitInfo orgUnitInfo) throws BOSException, IOException, ClassNotFoundException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateInfo.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(filterInfo);
        TemplateReportSavePointCollection ccc = TemplateReportSavePointFactory.getLocalInstance((Context)this.ctx).getCollection(view);
        if (ccc != null && ccc.size() > 0) {
            TemplateReportSavePointInfo spInfo = ccc.get(0);
            ByteArrayInputStream ins = new ByteArrayInputStream(spInfo.getIds());
            ObjectInputStream in = new ObjectInputStream(ins);
            HashSet<String> ids = new HashSet<String>();
            String firstId = null;
            int count = in.readInt();
            for (int j = 0; j < count; ++j) {
                if (j == 0) {
                    firstId = in.readObject().toString();
                    ids.add(firstId);
                    continue;
                }
                ids.add(in.readObject().toString());
            }
            filterInfo = new FilterInfo();
            if (count > 1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)firstId));
            }
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filterInfo);
            entityView.getSelector().add(new SelectorItemInfo("rptTypeStd.seq"));
            entityView.getSorter().add(new SorterItemInfo("rptTypeStd.seq"));
            entityView.getSelector().add(new SelectorItemInfo("*"));
            ReportTypeCollection r = ReportTypeFactory.getLocalInstance((Context)this.ctx).getReportTypeCollection(entityView);
            if (r != null && r.size() > 0) {
                for (int k = 0; k < r.size(); ++k) {
                    RptTypeRelaInfo temp = new RptTypeRelaInfo();
                    temp.setRptType(r.get(k));
                    temp.setRelaType(ReportTypeEnum.REPORT);
                    reportInfo.getSavePoint().add(temp);
                }
            }
        }
    }

    protected RptSheetParamCollection queryTemplateParams() throws BOSException, Exception {
        TemplateInfo temp = (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
        String tempId = temp.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("sheetName"));
        sic.add(new SelectorItemInfo("startYear"));
        sic.add(new SelectorItemInfo("endYear"));
        sic.add(new SelectorItemInfo("startPeriod"));
        sic.add(new SelectorItemInfo("endPeriod"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isIncludingUnposted"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("relaType"));
        sic.add(new SelectorItemInfo("sheetID"));
        sic.add(new SelectorItemInfo("report.id"));
        sic.add(new SelectorItemInfo("reportClass"));
        sic.add(new SelectorItemInfo("postil.*"));
        sic.add(new SelectorItemInfo("dfData.*"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("report", (Object)tempId);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        RptSheetParamCollection rptSheetParamCollection = RptSheetParamFactory.getLocalInstance((Context)this.ctx).getRptSheetParamCollection(view);
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                RptSheetParamInfo info = rptSheetParamCollection.get(j);
                info.setRelaType(ReportTypeEnum.REPORT);
                info.setId(null);
                info.setStatus(1);
            }
        }
        return rptSheetParamCollection;
    }

    private TemplateInfo getK3TmpByEasTmpid(Context ctx, String easTmpId, String companyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 fid from ( \n").append(" select TEMPLATE.fid  as fid \n").append(" from T_RPT_Template as TEMPLATE  \n").append("   INNER JOIN T_RPT_Template as EAS_TPL  \n").append(" ON (EAS_TPL.FISK3TPL = 0 AND ( ( TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)   \n").append("   OR ( TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND  \n").append("  NOT EXISTS (SELECT * FROM T_RPT_TEMPLATE t where EAS_TPL.FID = t.FEASTPLIDFORK3))))  \n").append("  inner join T_CSL_TempletDispense d on EAS_TPL.fid = d.FDispenseSrcID \n").append(" INNER JOIN T_ORG_Company AS COMPANY ON TEMPLATE.FCompanyID = COMPANY.FID \n").append(" where (d.FCompanyID = ? )  \n").append(" and TEMPLATE.fversionstatus = 1   \n").append(" and (TEMPLATE.FTemplateType = 6  or TEMPLATE.FTemplateType=10  or TEMPLATE.FTemplateType=15) \n").append("  and TEMPLATE.FIsFreezed = 0  \n").append("  and  not exists(  \n").append("   select t.FGroupTemplateID  \n").append("   from T_RPT_Template t  \n").append("   where TEMPLATE.fid=t.FGroupTemplateID and t.FCompanyID =?  \n").append("  and t.FVersionStatus = 1  \n").append("  and (t.FTemplateType = 2 or t.FTemplateType=12 or t.FTemplateType=16))  \t\n").append(" and EAS_TPL.fid=? \n").append(" union all \n").append("  select TEMPLATE.fid as fid   \n").append("   from T_RPT_Template TEMPLATE  \n").append("    INNER JOIN T_RPT_Template as EAS_TPL     \n").append("   ON (EAS_TPL.FISK3TPL = 0 AND ( ( TEMPLATE.FISK3TPL = 1 AND EAS_TPL.FID = TEMPLATE.FEASTPLIDFORK3)      \n").append("  OR ( TEMPLATE.FISK3TPL = 0 AND EAS_TPL.FID = TEMPLATE.FID  AND      \n").append("    NOT EXISTS (SELECT * FROM T_RPT_TEMPLATE t where EAS_TPL.FID = t.FEASTPLIDFORK3))))     \n").append("  inner  join T_RPT_Template t2 on EAS_TPL.FGroup = t2.FGroup    \n").append("   inner  join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID     \n").append("   INNER JOIN T_ORG_Company AS COMPANY ON TEMPLATE.FCompanyID = COMPANY.FID    \n").append("  where TEMPLATE.fcompanyid =?   \n").append("  and d.FIsAllowChgTemplet = 1     \n").append("    and TEMPLATE.fversionstatus < 2     \n").append("    and TEMPLATE.FIsFreezed = 0 and t2.FIsFreezed = 0    \n").append("    and (TEMPLATE.FTemplateType = 2 or TEMPLATE.FTemplateType=12  or TEMPLATE.FTemplateType=16)    \n").append("   AND TEMPLATE.FPublishedStatus = 1   \n").append("  AND TEMPLATE.FVERSIONSTATUS = 1    \n").append("     and EAS_TPl.fid=?  ) \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, easTmpId, companyID, easTmpId});
        try {
            if (rowSet.next()) {
                String k3TmpId = rowSet.getString("fid");
                SelectorItemCollection selectItem = RptAutoWeaveUtil.getTemplateSelectorForWeaveRpt();
                return TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(k3TmpId), selectItem);
            }
        }
        catch (SQLException e) {
            return null;
        }
        return null;
    }
}

