/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmSum;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmSumUnitEntry;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmTempEntry;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumUnitEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumUnitEntryFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTaskCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryFactory;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveSchmSumControllerBean;
import com.kingdee.eas.fi.gr.weaverpt.app.SumCalcSchemeHandle;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptWeaveSchmSumControllerBean
extends AbstractRptWeaveSchmSumControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveSchmSumControllerBean");

    @Override
    protected void _sumRptWeaveSolution(Context ctx, String pk, String userId) throws BOSException, EASBizException {
        if (this.isRunningScheme(ctx, pk)) {
            logger.info((Object)("scheme is Running:" + pk));
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE"));
        }
        IRptWeaveSchmSum schmSum = RptWeaveSchmSumFactory.getLocalInstance(ctx);
        RptWeaveSchmSumInfo schmSumInfo = schmSum.getRptWeaveSchmSumInfo((IObjectPK)new ObjectUuidPK(pk), this.getSumSchmSelector());
        if (schmSumInfo.isIsFreezed()) {
            return;
        }
        RptWeaveSchmSumUnitEntryCollection orgUnitEnties = schmSumInfo.getOrgUnitEntries();
        RptWeaveSchmTempEntryCollection tempEnties = schmSumInfo.getTemplateEtries();
        if (orgUnitEnties.size() == 0 || tempEnties.size() == 0) {
            return;
        }
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        times = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), schmSumInfo.getYear(), schmSumInfo.getPeriod());
        Integer weaveYear = (Integer)times.get(0);
        Integer weavePeriod = (Integer)times.get(1);
        Date rptDate = (Date)times.get(2);
        OrgTreeInfo treeInfo = this.getCurrentTree(ctx, rptDate, userId, schmSumInfo.getOrgBound().getId().toString());
        RptWeaveParams param = null;
        param = new RptWeaveParams();
        param.setInt("Year", weaveYear);
        param.setInt("Period", weavePeriod);
        param.setObject("Day", rptDate);
        param.setObject("rpt_weave_rptSchmObj", schmSumInfo);
        param.setObject("KEY_CONTEXT", ctx);
        RptWeaveExecParams execParam = new RptWeaveExecParams();
        execParam.setUserId(userId);
        param.setObject("rpt_weave_execparams", execParam);
        param.setObject("KEY_ORGTREE_INFO", treeInfo);
        param.setObject("UserInfo", RptAutoWeaveUtil.getCurrentUser(ctx, userId));
        String mutex = "sumAutoWeave";
        if (RptAutoWeaveUtil.isQueueRptAutoWeave(ctx)) {
            String title = "SumRptAutoWeave:" + schmSumInfo.getNumber();
            Job job = RptAutoWeaveUtil.createWeaveRptJob(ctx, param, title, mutex, new SumCalcSchemeHandle());
            ArrayList<String> taskList = new ArrayList<String>(1);
            ArrayList<String> companyList = new ArrayList<String>(1);
            taskList.add(job.getId());
            companyList.add(orgUnitEnties.get(0).getCompany().getId().toString());
            RptAutoWeaveUtil.saveRptWeaveTask(ctx, taskList, companyList, weaveYear, weavePeriod, periodType, pk);
        } else {
            SumCalcSchemeHandle jobHandler = new SumCalcSchemeHandle();
            Job job = new Job(ctx, (IJobHandler)jobHandler, (Object)param);
            try {
                jobHandler.execute(job);
            }
            catch (Exception e) {
                logger.error((Object)"sumRptWeaveSolution", (Throwable)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
    }

    private SelectorItemCollection getSumSchmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isFreezed"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("dependSchm"));
        sic.add(new SelectorItemInfo("existSameSumSaveType"));
        sic.add(new SelectorItemInfo("existNoReceRptCalcType"));
        sic.add(new SelectorItemInfo("sumMethodType"));
        sic.add(new SelectorItemInfo("displayNumber"));
        sic.add(new SelectorItemInfo("isShowTotal"));
        sic.add(new SelectorItemInfo("isGradeOnlyList"));
        sic.add(new SelectorItemInfo("isOrderListCompany"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("orgBound.id"));
        sic.add(new SelectorItemInfo("orgUnitEntries.id"));
        sic.add(new SelectorItemInfo("orgUnitEntries.company.id"));
        sic.add(new SelectorItemInfo("orgUnitEntries.company.number"));
        sic.add(new SelectorItemInfo("orgUnitEntries.company.isUnion"));
        sic.add(new SelectorItemInfo("orgUnitEntries.company.CU"));
        sic.add(new SelectorItemInfo("orgUnitEntries.company.IsCU"));
        sic.add(new SelectorItemInfo("templateEtries.id"));
        sic.add(new SelectorItemInfo("templateEtries.template.id"));
        sic.add(new SelectorItemInfo("templateEtries.template.number"));
        sic.add(new SelectorItemInfo("templateEtries.template.periodtype"));
        sic.add(new SelectorItemInfo("templateEtries.template.templateType"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptWeaveSchmTempEntryCollection tplEntries;
        RptWeaveSchmSumUnitEntryCollection companyEntries;
        IObjectPK modelPK = super._submit(ctx, model);
        if (!(model instanceof RptWeaveSchmSumInfo)) {
            return modelPK;
        }
        RptWeaveSchmSumInfo schmInfo = (RptWeaveSchmSumInfo)model;
        if (schmInfo.getId() == null) {
            schmInfo.setId(BOSUuid.read((String)modelPK.toString()));
        }
        if (!(companyEntries = schmInfo.getOrgUnitEntries()).isEmpty()) {
            IRptWeaveSchmSumUnitEntry compDao = RptWeaveSchmSumUnitEntryFactory.getLocalInstance(ctx);
            compDao.delete("where schemeSum='" + schmInfo.getId() + "'");
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < companyEntries.size(); ++i) {
                companyEntries.get(i).setId(null);
                companyEntries.get(i).setSchemeSum(schmInfo);
            }
            coll.addObjectCollection((IObjectCollection)companyEntries);
            compDao.addnew(coll);
        }
        if (!(tplEntries = schmInfo.getTemplateEtries()).isEmpty()) {
            IRptWeaveSchmTempEntry tempDao = RptWeaveSchmTempEntryFactory.getLocalInstance(ctx);
            tempDao.delete("where scheme='" + schmInfo.getId() + "'");
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < tplEntries.size(); ++i) {
                tplEntries.get(i).setId(null);
                tplEntries.get(i).setScheme(schmInfo);
            }
            coll.addObjectCollection((IObjectCollection)tplEntries);
            tempDao.addnew(coll);
        }
        return modelPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
        this.assistDeleteCompAndTempByScheme(ctx, arrayPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        this.assistDeleteCompAndTempByScheme(ctx, new IObjectPK[]{pk});
    }

    private void assistDeleteCompAndTempByScheme(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK.length == 0) {
            return;
        }
        IRptWeaveSchmSumUnitEntry compDao = RptWeaveSchmSumUnitEntryFactory.getLocalInstance(ctx);
        IRptWeaveSchmTempEntry tplDao = RptWeaveSchmTempEntryFactory.getLocalInstance(ctx);
        FilterInfo compfilter = new FilterInfo();
        compfilter.getFilterItems().add(new FilterItemInfo("schemeSum", new HashSet<IObjectPK>(Arrays.asList(arrayPK)), CompareType.INCLUDE));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme", new HashSet<IObjectPK>(Arrays.asList(arrayPK)), CompareType.INCLUDE));
        compDao.delete(compfilter);
        tplDao.delete(filter);
    }

    private OrgTreeInfo getCurrentTree(Context ctx, Date date, String userId, String treeId) throws BOSException, RptWeaveException {
        String datestr = CslRptUtil.formatDateForSql(date);
        OrgTreeInfo info = new OrgTreeInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT top 1 Tree.FID, Tree.FNumber,Tree.FIsForBudget  ").append(" FROM T_PM_OrgRange OrgRange  \n").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID  \n").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = OrgRange.FOrgID \n").append(" INNER JOIN T_ORG_Tree Tree ON Tree.FId = Structure.FTreeId \n").append(" WHERE BaseUnit.FIsUnion = 1 AND OrgRange.FUserID = ?  \n").append(" AND OrgRange.FType = ").append(10).append(" and tree.fnumber in( select fnumber from   T_ORG_Tree where fid= ? )  \n").append(" and ((fstatus = 1  and fstartDate <=" + datestr + " ) or (fstatus = 2 and fstartDate <=" + datestr + "and fendDate >= " + datestr + " ))");
        Object[] params = new Object[]{userId, treeId};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            if (!rowSet.next()) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"BROUND_ISERROR"));
            }
            String ID = rowSet.getString("FID");
            String number = rowSet.getString("FNumber");
            boolean isForBudget = rowSet.getBoolean("FIsForBudget");
            info.setId(BOSUuid.read((String)ID));
            info.setNumber(number);
            info.setIsForBudget(isForBudget);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLDataException(e);
        }
        return info;
    }

    @Override
    public Map _abortSchemeTask(Context ctx, String schemeId) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        RptWeaveSchmTaskCollection taskColl = RptAutoWeaveUtil.getSchmTaskColl(ctx, schemeId);
        if (taskColl == null || taskColl.size() == 0) {
            returnMap.put("IsSuccess", "true");
        }
        ArrayList<String> jobInstIds = new ArrayList<String>(taskColl.size());
        for (int i = 0; i < taskColl.size(); ++i) {
            jobInstIds.add(taskColl.get(i).getJobinstid());
        }
        int result = 0;
        try {
            result += JobServiceFactory.getLocalInstance((Context)ctx).abort((String[])jobInstIds.toArray());
        }
        catch (BOSException e) {
            logger.warn((Object)"task is running or completed ,abort is error!", (Throwable)e);
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TASKRUNORCOMP_CANNOTABORT"));
        }
        returnMap.put("canAbortJobList", jobInstIds);
        returnMap.put("IsSuccess", "true");
        return returnMap;
    }

    @Override
    protected void _schemeImmediatelyRun(Context ctx, String pk, String userId, Map executeParams) throws BOSException, EASBizException {
        super._schemeImmediatelyRun(ctx, pk, userId, executeParams);
        if (!executeParams.containsKey("OMIT_DEPEND_SCHM") && !this.isRunSuccessForDependSchm(ctx, pk)) {
            throw new RptWeaveException("10001", "");
        }
        this.sumRptWeaveSolution(ctx, pk, userId);
    }

    protected boolean isRunSuccessForDependSchm(Context ctx, String pk) throws BOSException, EASBizException {
        SumCalcSchemeHandle sumHandle = new SumCalcSchemeHandle();
        return sumHandle.isRunSuccessForDependSchm(ctx, pk);
    }
}

