/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.QueryHisBudgetUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.app.AbstractDynaRptItemDataFacadeControllerBean;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.util.RptLoggerUtils;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynaRptItemDataFacadeControllerBean
extends AbstractDynaRptItemDataFacadeControllerBean {
    private static final long serialVersionUID = 3869375167725562809L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.dynamic.app.DynaRptItemDataFacadeControllerBean");
    private static final int ITEMDATA_MAIN = 2;
    private static final int ITEMDATA_ELIMINATION = 3;
    private static final int ITEMDATA_ADJUST = 4;
    private static final int ITEMDATA_ADJUSTING = 1;
    private static final int DYNA_CLIENT_FIELD_LENGTH = 25;

    private Object getDyItemDataForTxt(Context ctx, String[] dynaItemTables, String orgBoundID, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String itemNumber, String dyItemNumber, int iYear, int iStartPeriod, int iEndPeriod, int iPeriodType, int iDataSource, int iDataElement, int iValueType, int iCommitStatus) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> lstParams = new ArrayList<Object>();
        strSql.append("Select top 1 ItemDataEntry.FTextValue as FValue From ").append(dynaItemTables[0]).append(" ItemData,").append(dynaItemTables[1]).append(" ItemDataEntry,").append("T_Org_BaseUnit BaseUnit,T_BD_Currency SourceCurrency, T_BD_Currency Currency,T_CSL_RptReceived RptReceived").append(" Where ItemData.FID=ItemDataEntry.FItemDataID and ItemData.FReportID=RptReceived.FReportID").append(" and ItemData.FOrgUnitID=BaseUnit.FID and FSourceCurrencyId = SourceCurrency.FId and FCurrencyID=Currency.FID");
        if (!StringUtils.isEmpty((String)orgBoundID)) {
            strSql.append(" and RptReceived.FOrgTreeID = ?");
            lstParams.add(orgBoundID);
        }
        if (!StringUtils.isEmpty((String)orgUnitNumber)) {
            strSql.append(" and BaseUnit.FNumber = ?");
            lstParams.add(orgUnitNumber);
        }
        if (!StringUtils.isEmpty((String)sourceCurrencyNumber)) {
            strSql.append(" and SourceCurrency.FNumber = ?");
            lstParams.add(sourceCurrencyNumber);
        }
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            strSql.append(" and Currency.FNumber = ?");
            lstParams.add(currencyNumber);
        }
        if (!StringUtils.isEmpty((String)itemNumber)) {
            strSql.append(" and ItemDataEntry.FItemID = ?");
            lstParams.add(itemNumber);
        }
        if (!StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append(" and ItemDataEntry.FKeyNumber = ?");
            lstParams.add(dyItemNumber);
        }
        strSql.append(" and ItemDataEntry.FYear = ?");
        lstParams.add(new Integer(iYear));
        strSql.append(" and ItemDataEntry.FPeriod >= ?");
        lstParams.add(new Integer(iStartPeriod));
        strSql.append(" and ItemDataEntry.FPeriod <= ?");
        lstParams.add(new Integer(iEndPeriod));
        strSql.append(" and ItemData.FPeriodType = ?");
        lstParams.add(new Integer(iPeriodType));
        strSql.append(" and ItemData.FDataSource = ?");
        lstParams.add(new Integer(iDataSource));
        if (iCommitStatus != -1) {
            strSql.append(" and ItemData.FCommitStatus = ?");
            lstParams.add(new Integer(iCommitStatus));
        }
        strSql.append(" and ItemDataEntry.FDataElement = ?");
        lstParams.add(new Integer(iDataElement));
        strSql.append(" and ItemDataEntry.FValueType = ?");
        lstParams.add(new Integer(iValueType));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        try {
            if (rs.next()) {
                Object bgValue = rs.getObject("FValue");
                return bgValue;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        logger.debug((Object)"DyItem return value is null!");
        logger.debug((Object)("DyItem :" + strSql.toString()));
        logger.debug((Object)("Params :" + ((Object)lstParams).toString()));
        return null;
    }

    private BigDecimal getDyItemData(Context ctx, String[] dynaItemTables, Map orgTree, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String itemNumber, String dyItemNumber, int iPeriodType, int iDataSource, int iDataElement, int iValueType, int iCommitStatus, boolean isAdjusted, String dataCollectNumber) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> params1 = new ArrayList<Object>();
        strSql.append("Select IsNull(Sum(t2.FValue),0) FValue").append("\r\n");
        strSql.append("From ").append(dynaItemTables[0]).append(" t1").append("\r\n");
        strSql.append("inner join ").append(dynaItemTables[1]).append(" t2").append("\r\n");
        strSql.append("on t1.FID=t2.FItemDataID").append("\r\n");
        strSql.append("inner join T_CSL_RptReceived t3").append("\r\n");
        strSql.append("on t1.FReportID=t3.FReportID").append("\r\n");
        strSql.append("inner join T_Org_BaseUnit BaseUnit").append("\r\n");
        strSql.append("on t1.FOrgUnitID=BaseUnit.FID").append("\r\n");
        strSql.append("inner join T_BD_Currency SourceCurrency").append("\r\n");
        strSql.append("on t1.FSourceCurrencyID=SourceCurrency.FID").append("\r\n");
        strSql.append("inner join T_BD_Currency Currency").append("\r\n");
        strSql.append("on t1.FCurrencyID=Currency.FID").append("\r\n");
        StringBuffer querySql = new StringBuffer();
        ArrayList<Object> params2 = new ArrayList<Object>();
        querySql.append("Select sum(t3.fvalue) FValue").append("\r\n");
        querySql.append("From T_CSL_Adjust t1").append("\r\n");
        querySql.append("inner join T_CSL_AdjustEntry t2").append("\r\n");
        querySql.append("on t1.FID=t2.fadjustid").append("\r\n");
        querySql.append("inner join t_Csl_Adjustdynamicitem t3").append("\r\n");
        querySql.append("on t2.FID=t3.FAdjustEntryID").append("\r\n");
        querySql.append("inner join T_Org_BaseUnit orgUnit").append("\r\n");
        querySql.append("on t1.FOrgUnit=orgUnit.FID").append("\r\n");
        querySql.append("inner join T_BD_Currency sourceCurrency").append("\r\n");
        querySql.append("on t1.FSourceCurrencyID=sourceCurrency.FID").append("\r\n");
        querySql.append("inner join T_BD_Currency currency").append("\r\n");
        querySql.append("on t1.FCurrencyID=currency.FID").append("\r\n");
        querySql.append("inner join T_CSL_RptItem rptItem").append("\r\n");
        querySql.append("on t3.FRptItemID=rptItem.FID").append("\r\n");
        querySql.append("where t1.FDataSource=").append(iDataSource - 9).append("\r\n");
        StringBuffer subWhere1 = new StringBuffer();
        StringBuffer subWhere2 = new StringBuffer();
        Iterator iter = orgTree.entrySet().iterator();
        while (iter.hasNext()) {
            if (subWhere1.length() > 0) {
                subWhere1.append(" or ");
            }
            subWhere1.append("(t3.FOrgTreeID = ? and t2.FYear = ?");
            subWhere1.append(" and t2.FPeriod >= ? and t2.FPeriod <= ?)").append("\r\n");
            Map.Entry element = iter.next();
            Map value = (Map)element.getValue();
            params1.add(element.getKey());
            params1.add(value.get("KEY_STARTYEAR"));
            params1.add(value.get("KEY_STARTPERIOD"));
            params1.add(value.get("KEY_ENDPERIOD"));
            if (subWhere2.length() > 0) {
                subWhere2.append(" or ");
            }
            subWhere2.append("(t1.FOrgBoundID = ? and t1.FYear = ?");
            subWhere2.append(" and t1.FPeriod >= ? and t1.FPeriod <= ?)").append("\r\n");
            params2.add(element.getKey());
            params2.add(value.get("KEY_STARTYEAR"));
            params2.add(value.get("KEY_STARTPERIOD"));
            params2.add(value.get("KEY_ENDPERIOD"));
        }
        strSql.append("where (").append(subWhere1.toString()).append(")");
        querySql.append("and (").append(subWhere2.toString()).append(")");
        if (!isAdjusted) {
            strSql.append(" and FDataType = ").append(0);
        }
        if (!StringUtils.isEmpty((String)orgUnitNumber)) {
            strSql.append(" and BaseUnit.FNumber = ?");
            querySql.append("and orgUnit.FNumber=?").append("\r\n");
            params1.add(orgUnitNumber);
            params2.add(orgUnitNumber);
        }
        if (!StringUtils.isEmpty((String)sourceCurrencyNumber)) {
            strSql.append(" and sourceCurrency.FNumber = ?");
            querySql.append("and sourcecurrency.FNumber=?").append("\r\n");
            params1.add(sourceCurrencyNumber);
            params2.add(sourceCurrencyNumber);
        }
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            strSql.append(" and Currency.FNumber = ?");
            querySql.append("and currency.FNumber=?").append("\r\n");
            params1.add(currencyNumber);
            params2.add(currencyNumber);
        }
        if (!StringUtils.isEmpty((String)itemNumber)) {
            strSql.append(" and t2.FItemID = ?");
            querySql.append("and rptItem.FNumber=?").append("\r\n");
            params1.add(itemNumber);
            params2.add(itemNumber);
        }
        if (!StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append(" and t2.FKeyNumber = ?");
            querySql.append("and t3.fkeyLongNumber=?").append("\r\n");
            params1.add(dyItemNumber);
            params2.add(dyItemNumber);
        }
        strSql.append(" and t1.FPeriodType = ?");
        querySql.append("and t1.FPeriodType=?").append("\r\n");
        params1.add(new Integer(iPeriodType));
        params2.add(new Integer(iPeriodType));
        strSql.append(" and t1.FDataSource = ?");
        params1.add(new Integer(iDataSource));
        if (iCommitStatus != -1) {
            strSql.append(" and t1.FCommitStatus = ?");
            params1.add(new Integer(iCommitStatus));
        }
        querySql.append("and t1.FCheckedStatus=?").append("\r\n");
        params2.add(new Integer(2));
        strSql.append(" and t2.FDataElement = ?");
        querySql.append("and t2.FDataElement=?").append("\r\n");
        params1.add(new Integer(iDataElement));
        params2.add(new Integer(iDataElement));
        strSql.append(" and t2.FValueType = ?");
        querySql.append("and t1.FValueType=?").append("\r\n");
        params1.add(new Integer(iValueType));
        params2.add(new Integer(iValueType));
        if (StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append("and t2.FGradeIsleaf = ? \n");
            params1.add(new Integer(1));
        }
        strSql.append(" and t1.FDataType = 0");
        strSql.append(" and t1.FDataCollectNumber = ?");
        querySql.append("and t1.FDataCollectNumber=?").append("\r\n");
        params1.add(dataCollectNumber);
        params2.add(dataCollectNumber);
        BigDecimal bgValue = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params1.toArray());
        try {
            if (rs.next()) {
                bgValue = rs.getBigDecimal("FValue");
            }
            if (isAdjusted && (rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params2.toArray())).next()) {
                BigDecimal adjustValue = rs.getBigDecimal("FValue");
                if (bgValue == null) {
                    bgValue = adjustValue;
                    logger.debug((Object)"DyItem return value is null!");
                    logger.debug((Object)("DyItem :" + strSql.toString()));
                    logger.debug((Object)("Params :" + ((Object)params1).toString()));
                } else if (adjustValue != null) {
                    bgValue = bgValue.add(adjustValue);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return bgValue;
    }

    @Override
    protected String _getParentAsstActName(Context ctx, String asstActNumber, String number) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FIsSelfAsstActaiatem, FIsSystemAsstActItem, FRealtionDataObject,");
        sql.append(" FGlAsstActTypeGrpID, FGroupTableName, FIsMultilevel, FName_" + ctx.getLocale());
        sql.append(" from T_BD_AsstActType");
        sql.append(" where FNumber = '" + asstActNumber + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String oql;
                IRowSet rowSet;
                boolean isSelfAsstActItem = rs.getBoolean("FIsSelfAsstActaiatem");
                boolean isSysAsstActItem = rs.getBoolean("FIsSystemAsstActItem");
                boolean isMulti = rs.getBoolean("FIsMultilevel");
                String groupId = rs.getString("FGlAsstActTypeGrpID");
                if (!StringUtils.isEmpty((String)rs.getString("FGroupTableName"))) {
                    isMulti = false;
                }
                if (!isMulti) {
                    return rs.getString("FName_" + ctx.getLocale());
                }
                String tableName = rs.getString("FRealtionDataObject");
                if (isSysAsstActItem && StringUtils.isEmpty((String)groupId) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(oql = "select FName_" + ctx.getLocale() + " as FName from " + tableName + " where FLongNumber = '" + number + "'"))).next()) {
                    return rowSet.getString("FName");
                }
                if ((isSelfAsstActItem || !StringUtils.isEmpty((String)groupId)) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(oql = "select FName_" + ctx.getLocale() + " as FName from " + tableName + " where FLongNumber = '" + number + "' and FGroupID = '" + groupId + "'"))).next()) {
                    return rowSet.getString("FName");
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected List _getLinkCommDynaRpt(Context ctx, Map mapParams) throws BOSException, EASBizException {
        FullOrgUnitInfo orgUnit;
        OrgTreeInfo orgTree = (OrgTreeInfo)OrgTreeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgTreeID")));
        ArrayList lstOrg = CslRptUtil.getCslOrgs((Context)ctx, (OrgTreeInfo)orgTree, (OrgUnitInfo)(orgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgUnitID")))));
        if (lstOrg == null || lstOrg.size() <= 0) {
            return null;
        }
        String[] dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")), (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")));
        StringBuffer strSql = new StringBuffer();
        ArrayList lstParams = new ArrayList();
        strSql.append("select distinct a.FReportid as FReportid from ").append(dynaItemTables[0]).append(" a,").append(dynaItemTables[1]).append(" b ").append("where a.FID=b.FItemDataID ").append("and (FDataSource = 10  or FDataSource = 11) ").append("and FCommitStatus = 3 ").append("and Exists(select * from ").append(dynaItemTables[0]).append(" c,").append(dynaItemTables[1]).append(" d ").append("where c.FID=d.FItemDataID ").append("and c.FReportID = ? ");
        lstParams.add(mapParams.get("KEY_REPORT_ID"));
        strSql.append("and b.FItemID = d.FItemID ").append("and b.FKeyName=d.FKeyName ").append("and b.FDataElement=d.FDataElement ").append("and b.FValueType=d.FValueType) ").append("and a.FCurrencyID=? ");
        lstParams.add(mapParams.get("KEY_CURRENCY_ID"));
        strSql.append("and a.FPeriodType = ? ");
        lstParams.add(mapParams.get("PeriodType"));
        strSql.append("and b.FYear=? ");
        lstParams.add(mapParams.get("Year"));
        strSql.append("and b.FPeriod=? ");
        lstParams.add(mapParams.get("Period"));
        strSql.append("and FOrgUnitId in (");
        int n = lstOrg.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                strSql.append(",");
            }
            strSql.append("'").append(lstOrg.get(i)).append("'");
        }
        strSql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        if (rs == null) {
            return null;
        }
        try {
            ArrayList<String> lstResult = null;
            while (rs.next()) {
                if (lstResult == null) {
                    lstResult = new ArrayList<String>();
                }
                lstResult.add(rs.getString("FReportid"));
            }
            return lstResult;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected List _getLinkCellDynaRpt(Context ctx, Map mapParams) throws BOSException, EASBizException {
        RptSrcTypeEnum type = (RptSrcTypeEnum)mapParams.get("KEY_SOURCETYPE");
        ctx.put((Object)"ISQUERYBUDGET", mapParams.get("ISQUERYBUDGET"));
        if (type != null && RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)type) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)type)) {
            return this.link_Dynamic_CSL_cell(ctx, mapParams);
        }
        RptSrcTypeEnum rptType = (RptSrcTypeEnum)mapParams.get("RptSrcType");
        if (rptType != null && (RptSrcTypeEnum.MULTIDYNAMICSUMREPORT.equals((Object)rptType) || RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)rptType))) {
            return this.link_MultiDynamic_SUM_cell(ctx, mapParams);
        }
        return this.link_dynamic_SUM_cell(ctx, mapParams);
    }

    private List link_dynamic_SUM_cell(Context ctx, Map mapParams) throws BOSException, EASBizException, SQLDataException {
        Object orgTreeid = null;
        String[] dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")), (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")));
        OrgTreeInfo orgTree = (OrgTreeInfo)OrgTreeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgTreeID")));
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgUnitID")));
        ArrayList lstOrg = CslRptUtil.getCslOrgs((Context)ctx, (OrgTreeInfo)orgTree, (OrgUnitInfo)orgUnit);
        int isQueryBudget = (Integer)mapParams.get("ISQUERYBUDGET");
        if (lstOrg == null || lstOrg.size() <= 0) {
            return null;
        }
        String sheetId = (String)mapParams.get("Key_Active_SheetName");
        String reportIds = CslRptUtil.getRptIdsFromSumRptRela((Context)ctx, (String)((String)mapParams.get("KEY_REPORT_ID")), (String)sheetId);
        if (StringUtils.isEmpty((String)reportIds)) {
            throw new SumRptException(SumRptException.NOTFOUNDSUMRELA);
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        String strItemNumber = (String)mapParams.get("KEY_ITEM_NUMBER");
        int valueType = (Integer)mapParams.get("ValueType");
        if (valueType != 3) {
            strSql.append("select FName,sum(FValue)").append("\r\n");
        } else {
            strSql.append("select FName,FValue").append("\r\n");
        }
        strSql.append("from").append("\r\n");
        strSql.append("(").append("\r\n");
        strSql.append("select to_char(o.FName_").append(ctx.getLocale().toString()).append(") as FName,");
        if (valueType == 3) {
            strSql.append("b.FTextValue as FValue ");
        } else {
            strSql.append("b.FValue as FValue ");
        }
        strSql.append(" from ").append(dynaItemTables[0]).append(" a,").append(dynaItemTables[1]).append(" b,T_Org_BaseUnit o ").append("where a.FID=b.FItemDataID and a.FOrgUnitID=o.FID ").append("and (FDataSource = 10 or FDataSource = 11) ").append("and FCommitStatus = 3 ").append("and a.FReportID in (").append(reportIds);
        strSql.append(") and a.FCurrencyID=? ");
        params.add(mapParams.get("KEY_CURRENCY_ID"));
        strSql.append("and a.FDataCollectNumber = ? ");
        params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
        strSql.append("and a.FPeriodType = ? ");
        params.add(mapParams.get("PeriodType"));
        strSql.append("and b.FYear=? ");
        params.add(mapParams.get("Year"));
        strSql.append("and b.FPeriod=? ");
        params.add(mapParams.get("Period"));
        strSql.append("and b.FItemID=? ");
        params.add(mapParams.get("KEY_ITEM_NUMBER"));
        strSql.append("and b.FKeyNumber=? ");
        params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
        strSql.append("and b.FDataElement=? ");
        params.add(mapParams.get("DataElement"));
        strSql.append(" and b.FValueType = ? ");
        params.add(mapParams.get("ValueType"));
        StringBuffer orgUnitIds = new StringBuffer();
        int n = lstOrg.size();
        for (int i = 0; i < n; ++i) {
            orgUnitIds.append("'").append(lstOrg.get(i)).append("',");
        }
        if (orgUnitIds.length() > 0) {
            orgUnitIds.setLength(orgUnitIds.length() - 1);
        }
        if (valueType != 3) {
            strSql.append(" UNION ALL \n");
            strSql.append(" select to_char(t5.FName_" + ctx.getLocale() + ") as FName\t\t\t\t\t\t\n");
            strSql.append(" ,sum(t3.fvalue) as FValue\t\t\t\t\t\t\t\t\n");
            if (isQueryBudget == 1) {
                strSql.append(" From T_CSL_HisAdjust t1\t\t\t\t\t\t\t\t\t\n");
                strSql.append(" inner join T_CSL_HisAdjustEntry t2                         \n");
                strSql.append(" on t1.FID=t2.fadjustid                                  \n");
                strSql.append(" inner join t_Csl_HisAdjustdynamicitem t3                   \n");
            } else {
                strSql.append(" From T_CSL_Adjust t1                                    \n");
                strSql.append(" inner join T_CSL_AdjustEntry t2                         \n");
                strSql.append(" on t1.FID=t2.fadjustid                                  \n");
                strSql.append(" inner join t_Csl_Adjustdynamicitem t3                   \n");
            }
            strSql.append(" on t2.FID=t3.FAdjustEntryID\t\t\t\t\t\t\t\t\n");
            strSql.append(" inner join T_CSL_RptItem rptItem\t\t\t\t\t\t\n");
            strSql.append(" on t3.FRptItemID=rptItem.FID\t\t\t\t\t\t\t\t\n");
            strSql.append(" inner join T_ORG_Tree t4 ON t1.Forgboundid = t4.FID\t\t\n");
            strSql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnit = t5.FID\t\n");
            strSql.append(" WHERE t1.FOrgUnit IN (" + orgUnitIds.toString() + ")\t\n");
            strSql.append("    and t1.FOrgBoundID = ?\t\t\t\t\t\t\t\t\n");
            strSql.append("    and t1.FCurrencyID = ?\t\t\t\t\t\t\t\t\n");
            strSql.append("    and rptItem.FNumber = ?\t\t\t\t\t\t\t\t\n");
            strSql.append("    and t2.FDataElement = ?                             \t\n");
            strSql.append("    and t1.FDataSource in (1,2)                          \n");
            strSql.append("    and t1.FValueType = ?                               \t\n");
            strSql.append("    and t1.FYear = ?                                    \t\n");
            strSql.append("    and t1.FPeriod = ?                                  \t\n");
            strSql.append("    and t1.FCheckedStatus = ?                           \t\n");
            strSql.append("    and t3.FKeyLongNumber = ?                           \t\n");
            strSql.append("    and t1.FDataCollectNumber = ?                           \t\n");
            strSql.append(" group by t5.FName_" + ctx.getLocale() + ",t3.fkeylongnumber\t\t\t\t\t\n");
            if (orgTreeid != null) {
                params.add(orgTreeid);
            } else {
                params.add(orgTree.getId().toString());
            }
            params.add(mapParams.get("KEY_CURRENCY_ID"));
            params.add(mapParams.get("KEY_ITEM_NUMBER"));
            params.add(mapParams.get("DataElement"));
            params.add(mapParams.get("ValueType"));
            params.add(mapParams.get("Year"));
            params.add(mapParams.get("Period"));
            params.add(new Integer(2));
            params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
            params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
        }
        strSql.append(") as t").append("\r\n");
        if (valueType != 3) {
            strSql.append("group by FName");
        }
        strSql.append("\n union all \n");
        strSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"0_DynaRptItemDataFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        if (valueType == 3) {
            strSql.append("b.FTextValue as FValue ");
        } else {
            strSql.append("b.FValue as FValue ");
        }
        strSql.append("  from ").append(dynaItemTables[0]).append(" a,").append(dynaItemTables[1]).append(" b,T_Org_BaseUnit o ").append("where a.FID = b.FItemDataID and a.FOrgUnitID = o.FID ").append("and FDataSource = 8 and FCommitStatus = 1").append("and a.FReportID in (").append(reportIds);
        strSql.append(") and a.FCurrencyID=? ");
        params.add(mapParams.get("KEY_CURRENCY_ID"));
        strSql.append("and a.FDataCollectNumber = ? ");
        params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
        strSql.append("and a.FPeriodType = ? ");
        params.add(mapParams.get("PeriodType"));
        strSql.append("and b.FYear=? ");
        params.add(mapParams.get("Year"));
        strSql.append("and b.FPeriod=? ");
        params.add(mapParams.get("Period"));
        strSql.append("and b.FItemID=? ");
        params.add(mapParams.get("KEY_ITEM_NUMBER"));
        strSql.append("and b.FKeyNumber=? ");
        params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
        strSql.append("and b.FDataElement=? ");
        params.add(mapParams.get("DataElement"));
        strSql.append(" and b.FValueType = ? ");
        params.add(mapParams.get("ValueType"));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params.toArray());
        if (rs == null) {
            return null;
        }
        int currencyScale = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK((String)mapParams.get("KEY_CURRENCY_ID"))).getPrecision();
        if (currencyScale == 0) {
            currencyScale = 2;
        }
        ArrayList lstResult = new ArrayList();
        RPTItemInfo itemInfo = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemInfo("SELECT name WHERE number = '" + strItemNumber + "'");
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem", (Locale)ctx.getOriginLocale()) + ":  ");
        tempList.add(itemInfo.getName());
        lstResult.add(tempList);
        tempList = new ArrayList();
        tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement", (Locale)ctx.getOriginLocale()) + ":  ");
        tempList.add(DataElementProvider.getDataElementName((Context)ctx, (int)((Integer)mapParams.get("DataElement"))));
        lstResult.add(tempList);
        try {
            while (rs.next()) {
                if (lstResult == null) {
                    lstResult = new ArrayList();
                }
                ArrayList<Object> lstTemp = new ArrayList<Object>();
                lstTemp.add(rs.getString(1));
                if (valueType == 3) {
                    lstTemp.add(rs.getString(2));
                } else {
                    BigDecimal value = new BigDecimal(rs.getString(2));
                    value = value.setScale(currencyScale, 4);
                    lstTemp.add(value);
                }
                lstResult.add(lstTemp);
            }
            return lstResult;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private List link_Dynamic_CSL_cell(Context ctx, Map mapParams) throws BOSException, EASBizException {
        int currencyScale;
        OrgTreeInfo orgTree = (OrgTreeInfo)OrgTreeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgTreeID")));
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgUnitID")));
        ArrayList lstOrg = CslRptUtil.getCslOrgs((Context)ctx, (OrgTreeInfo)orgTree, (OrgUnitInfo)orgUnit);
        int isQueryBudget = (Integer)mapParams.get("ISQUERYBUDGET");
        if (lstOrg == null || lstOrg.size() <= 0) {
            return null;
        }
        StringBuffer companyIDs = new StringBuffer();
        int n = lstOrg.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                companyIDs.append(", ");
            }
            companyIDs.append("'" + (String)lstOrg.get(i) + "'");
        }
        int valueType = (Integer)mapParams.get("ValueType");
        RptSrcTypeEnum srcType = (RptSrcTypeEnum)mapParams.get("KEY_SOURCETYPE");
        String fastMergeId = (String)mapParams.get("KEY_FASTMERGEID");
        String FValue = null;
        FValue = valueType == 3 ? "FTextValue" : "FValue";
        String[] dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")), (int)((Integer)mapParams.get("Year")), (int)((Integer)mapParams.get("Period")));
        StringBuffer sql = new StringBuffer();
        CSLServerHelper serverHelper = new CSLServerHelper(ctx);
        String ext = serverHelper.getFieldNameExtend();
        if (valueType != 3) {
            sql.append("select FKeyNumber,sum(FValue), FDataType ").append("\r\n");
            sql.append("from").append("\r\n");
            sql.append("(").append("\r\n");
        }
        sql.append(" SELECT u.FName" + ext + " AS FKeyNumber, de." + FValue + " AS FValue, case when d.FDataType =1 then 0 else d.FDataType end as FDataType \n").append(" FROM ").append(dynaItemTables[1]).append(" de                        \n").append(" INNER JOIN ").append(dynaItemTables[0]).append(" d                        \n").append("    ON de.FItemDataID = d.FID and d.FDataSource in(12,10)    \n").append(" INNER JOIN T_ORG_BASEUNIT u on u.FID = d.FOrgUnitID    \n");
        if (isQueryBudget == 1) {
            sql.append(" inner join t_csl_HisRptreceived rc on rc.freportid = d.freportid \n");
        } else {
            sql.append(" inner join t_csl_rptreceived rc on rc.freportid = d.freportid \n");
        }
        sql.append(" WHERE rc.forgtreeid = ? \n").append(" and d.FOrgUnitID IN (" + companyIDs.toString() + ")  \n").append("    AND d.FCurrencyID = ?                               \n").append("    AND de.FItemID = ?                                  \n").append("    AND de.FDataElement = ?                             \n").append("    AND de.FValueType = ?                               \n").append("    AND de.FYear = ?                                    \n").append("    AND de.FPeriod = ?                                  \n").append("    AND de.FKeyNumber = ?\t\t\t\t\t\t\t\t\n").append("    AND d.FCommitStatus = ?                             \n").append("    AND d.FDataCollectNumber = ?                             \n").append("    AND d.FDataType = 0 \n");
        if (valueType != 3) {
            String rptSrcTypeSql = "    AND d.FDataSource in (10," + srcType.getValue() + ") \n";
            if (!StringUtils.isEmpty((String)fastMergeId)) {
                rptSrcTypeSql = " AND (d.FDataSource = 10 or (d.FDataSource =" + srcType.getValue() + " and d.FFastMergeSoluId ='" + fastMergeId + "' )) \n";
            }
            sql.append(rptSrcTypeSql).append(" UNION ALL \n").append(" SELECT N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslRptItemDataNameElim", (Locale)ctx.getOriginLocale()) + "' AS FKeyNumber \n").append(" , de.FValue AS FValue , 100 as FDataType\n");
            if (isQueryBudget == 1) {
                sql.append(" FROM t_csl_HisElimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_HisElimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_HisElimINatiON e ON ee.FElimINatiONID = e.FID            \n");
            } else {
                sql.append(" FROM t_csl_elimDynaItemEntry de                                        \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID            \n");
            }
            sql.append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID                  \n").append(" WHERE e.FOrgUnit =?                    \n").append(" AND e.FCurrencyID = ?                                                  \n").append(" AND ri.fNumber = ?                                                     \n").append(" AND ee.FDataElement = ?                                                \n").append(" AND e.FValueType = ?                                                   \n").append(" AND e.FYear = ?                                                      \n").append(" AND e.FPeriod= ?                                                       \n").append(" AND e.FOrgBoundID = ?                                                  \n").append(" AND e.FCheckedStatus = 2 ").append(" AND de.FKeyLongNumber = ?").append(" AND e.FDataCollectNumber = ?");
            sql.append(" UNION ALL \n");
            sql.append(" select t5.FName_" + ctx.getLocale() + " as FKeyNumber                       \n");
            sql.append(" ,sum(t3.fvalue) as FValue,0 as FDataType             \n");
            if (isQueryBudget == 1) {
                sql.append(" From T_CSL_HisAdjust t1                                   \n");
                sql.append(" inner join T_CSL_HisAdjustEntry t2                        \n");
                sql.append(" on t1.FID=t2.fadjustid                                 \n");
                sql.append(" inner join t_Csl_HisAdjustdynamicitem t3                  \n");
            } else {
                sql.append(" From T_CSL_Adjust t1                                   \n");
                sql.append(" inner join T_CSL_AdjustEntry t2                        \n");
                sql.append(" on t1.FID=t2.fadjustid                                 \n");
                sql.append(" inner join t_Csl_Adjustdynamicitem t3                  \n");
            }
            sql.append(" on t2.FID=t3.FAdjustEntryID                            \n");
            sql.append(" inner join T_CSL_RptItem rptItem                       \n");
            sql.append(" on t3.FRptItemID=rptItem.FID                               \n");
            sql.append(" inner join T_ORG_Tree t4 ON t1.Forgboundid = t4.FID    \n");
            sql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnit = t5.FID   \n");
            sql.append(" WHERE t1.FOrgUnit IN (" + companyIDs.toString() + ")   \n");
            sql.append("    and t1.FOrgBoundID = ?                              \n");
            sql.append("    and t1.FCurrencyID = ?                              \n");
            sql.append("    and rptItem.FNumber = ?                             \n");
            sql.append("    and t2.FDataElement = ?                             \n");
            sql.append("    and t1.FDataSource in (1,3)                         \n");
            sql.append("    and t1.FValueType = ?                               \n");
            sql.append("    and t1.FYear = ?                                    \n");
            sql.append("    and t1.FPeriod = ?                                  \n");
            sql.append("    and t1.FCheckedStatus = ?                           \n");
            sql.append("    and t3.FKeyLongNumber = ?                           \n");
            sql.append("    and t1.FDataCollectNumber = ?                       \n");
            sql.append(" group by t5.FName_" + ctx.getLocale() + ",FKeyName                          \n");
            sql.append(" UNION ALL \n");
            sql.append(" SELECT N'").append(ElimReportUtils.getResource4Server((String)"ElimReport", (Context)ctx)).append("'");
            sql.append(" AS FKeyNumber, de." + FValue + " AS FValue, 200 as FDataType \n");
            sql.append(" FROM ").append(dynaItemTables[1]).append(" de                     \n").append(" INNER JOIN ").append(dynaItemTables[0]).append(" d                        \n").append("    ON de.FItemDataID = d.FID                           \n").append(" INNER JOIN T_ORG_BASEUNIT u on u.FID = d.FOrgUnitID    \n");
            if (isQueryBudget == 1) {
                sql.append(" inner join t_csl_HisRptreceived rc on rc.freportid = d.freportid \n");
            } else {
                sql.append(" inner join t_csl_rptreceived rc on rc.freportid = d.freportid \n");
            }
            sql.append(" WHERE rc.forgtreeid = ?                           \n").append(" and d.FOrgUnitID =?                                  \n").append("    AND d.FCurrencyID = ?                             \n").append("    AND de.FItemID = ?                                \n").append("    AND de.FDataElement = ?                           \n").append("    AND de.FValueType = ?                             \n").append("    AND de.FYear = ?                                  \n").append("    AND de.FPeriod = ?                                \n").append("    AND de.FKeyNumber = ?\t\t\t\t\t\t\t   \n").append("    AND d.FDataSource = ?                             \n").append("    AND d.FDynaType = 1                               \n");
            if (!StringUtils.isEmpty((String)fastMergeId)) {
                sql.append("   AND d.FFastMergeSoluId = '" + fastMergeId + "'        \n");
            }
            sql.append(") as t").append("\r\n");
            sql.append("group by FKeyNumber, FDataType \n Order by FKeyNumber, FDataType desc");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(orgTree.getId().toString());
        params.add(mapParams.get("KEY_CURRENCY_ID"));
        params.add(mapParams.get("KEY_ITEM_NUMBER"));
        params.add(mapParams.get("DataElement"));
        params.add(mapParams.get("ValueType"));
        params.add(mapParams.get("Year"));
        params.add(mapParams.get("Period"));
        params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
        params.add(new Integer(3));
        params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
        if (valueType != 3) {
            params.add(orgUnit.getId().toString());
            params.add(mapParams.get("KEY_CURRENCY_ID"));
            params.add(mapParams.get("KEY_ITEM_NUMBER"));
            params.add(mapParams.get("DataElement"));
            params.add(mapParams.get("ValueType"));
            params.add(mapParams.get("Year"));
            params.add(mapParams.get("Period"));
            params.add(orgTree.getId().toString());
            params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
            params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
            params.add(orgTree.getId().toString());
            params.add(mapParams.get("KEY_CURRENCY_ID"));
            params.add(mapParams.get("KEY_ITEM_NUMBER"));
            params.add(mapParams.get("DataElement"));
            params.add(mapParams.get("ValueType"));
            params.add(mapParams.get("Year"));
            params.add(mapParams.get("Period"));
            params.add(new Integer(2));
            params.add(mapParams.get("KEY_DYNAITEM_NUMBER"));
            params.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
            params.add(orgTree.getId().toString());
            params.add(orgUnit.getId().toString());
            params.add(mapParams.get("KEY_CURRENCY_ID"));
            params.add(mapParams.get("KEY_ITEM_NUMBER"));
            params.add(mapParams.get("DataElement"));
            params.add(mapParams.get("ValueType"));
            params.add(mapParams.get("Year"));
            params.add(mapParams.get("Period"));
            params.add((String)mapParams.get("KEY_DYNAITEM_NUMBER"));
            params.add(RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)srcType) ? 42 : 43);
        }
        if ((currencyScale = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK((String)mapParams.get("KEY_CURRENCY_ID"))).getPrecision()) == 0) {
            currencyScale = 2;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            ArrayList lstResult = new ArrayList();
            RPTItemInfo itemInfo = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemInfo("SELECT name WHERE number = '" + mapParams.get("KEY_ITEM_NUMBER") + "'");
            ArrayList<String> tempList = new ArrayList<String>();
            tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem", (Locale)ctx.getOriginLocale()) + ":  ");
            tempList.add(itemInfo.getName());
            lstResult.add(tempList);
            tempList = new ArrayList();
            tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement", (Locale)ctx.getOriginLocale()) + ":  ");
            tempList.add(DataElementProvider.getDataElementName((Context)ctx, (int)((Integer)mapParams.get("DataElement"))));
            lstResult.add(tempList);
            String flag_keyName = null;
            while (rs.next()) {
                if (lstResult == null) {
                    lstResult = new ArrayList();
                }
                ArrayList<Object> lstTemp = new ArrayList<Object>();
                String name = rs.getString(1);
                lstTemp.add(name);
                if (valueType == 3) {
                    lstTemp.add(rs.getString(2));
                } else {
                    int type = rs.getInt("FDataType");
                    if (type == 2) {
                        flag_keyName = name;
                    } else if (name.equalsIgnoreCase(flag_keyName)) continue;
                    BigDecimal value = new BigDecimal(rs.getString(2));
                    value = value.setScale(currencyScale, 4);
                    lstTemp.add(value);
                }
                lstResult.add(lstTemp);
            }
            return lstResult;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getElimRptDynaKeyNameByKeyNum(Context ctx, String[] dynaItemTables, Map mapParams, String keyNumber) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fkeyname from ").append(dynaItemTables[1]).append(" where fyear = ? and fperiod = ?").append(" and fkeynumber = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{mapParams.get("Year"), mapParams.get("Period"), keyNumber});
        try {
            if (rs.next()) {
                return rs.getString("fkeyname");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return keyNumber;
    }

    @Override
    protected BigDecimal _getDyItemDataByTemplate(Context ctx, String companyNumber, String templateNumber, String templateType, String currencyNumber, String srcCurrency, int year, int period, String itemNumber, String dyItemNumber, int fetchType, int valueType, String isAdjusted, String dataCollectNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = "ACTUALDATA";
        }
        String[] dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)year, (int)period, (int)year, (int)period);
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> lstParams = new ArrayList<Object>();
        strSql.append("Select Sum(ItemDataEntry.FValue) FValue , ItemData.FDataType \n").append("From ").append(dynaItemTables[0]).append(" ItemData \n").append("inner join ").append(dynaItemTables[1]).append(" ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID \n").append("inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID \n").append("inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID \n").append("inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId=SrcCurrency.FID \n").append("inner join T_CSL_CSLReport Report on Report.FID = ItemData.FReportID \n").append("inner join T_RPT_Template Template on Template.FID = Report.FTemplateID \n").append("Where Template.FNumber = ? \n");
        lstParams.add(templateNumber);
        RptTmpTypeEnum type = RptTmpTypeEnum.getEnum((String)templateType);
        if (type != null) {
            if (type == RptTmpTypeEnum.DYNAMICNORMALREPORT || type == RptTmpTypeEnum.RPTDYNAMICREPORT) {
                strSql.append(" and (Template.FTemplateType = ? OR Template.FTemplateType = ?)");
                lstParams.add(new Integer(10));
                lstParams.add(new Integer(12));
            } else {
                strSql.append(" and Template.FTemplateType = ? ");
                lstParams.add(new Integer(type.getValue()));
            }
        }
        String orgBoundNumber = null;
        String orgBoundId = null;
        if (companyNumber.indexOf(33) != -1) {
            String[] numbers = companyNumber.split("!");
            orgBoundNumber = numbers[0];
            companyNumber = numbers[1];
            Map orgTrees = null;
            try {
                StringBuffer querySql = new StringBuffer();
                querySql.append("select FPeriodType from T_RPT_Template").append("\r\n");
                querySql.append("where FTemplateType = ").append(type.getValue()).append("\r\n");
                querySql.append("and FNumber = ? ").append("\r\n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{templateNumber});
                int periodType = 0;
                if (rs.next()) {
                    periodType = rs.getInt(1);
                }
                orgTrees = UnionVersionUtil.getOrgTreeByPeriods((Context)ctx, (String)orgBoundNumber, (int)year, (int)year, (int)period, (int)period, (int)periodType);
                orgBoundId = (String)orgTrees.keySet().iterator().next();
                strSql.append("and exists").append("\r\n");
                strSql.append("(").append("\r\n");
                strSql.append("select 1 from T_CSL_RptReceived t").append("\r\n");
                strSql.append("where t.FReportID = Report.FID ");
                strSql.append(" and t.FOrgTreeID='").append(orgBoundId).append("'\r\n");
                strSql.append(")").append("\r\n");
            }
            catch (Exception querySql) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(orgBoundId)) {
            // empty if block
        }
        if (!StringUtils.isEmpty((String)companyNumber)) {
            strSql.append(" and BaseUnit.FNumber = ? \n");
            lstParams.add(companyNumber);
        }
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            strSql.append(" and Currency.FNumber = ? \n");
            lstParams.add(currencyNumber);
        }
        if (!StringUtils.isEmpty((String)srcCurrency)) {
            strSql.append(" and SrcCurrency.FNumber = ? \n");
            lstParams.add(srcCurrency);
        }
        if (!StringUtils.isEmpty((String)itemNumber)) {
            strSql.append(" and ItemDataEntry.FItemID = ? \n");
            lstParams.add(itemNumber);
        }
        if (!StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append(" and ItemDataEntry.FKeyNumber = ? \n");
            lstParams.add(dyItemNumber);
        }
        strSql.append("and ItemDataEntry.FYear = ? \n");
        lstParams.add(new Integer(year));
        strSql.append("and ItemDataEntry.FPeriod = ? \n");
        lstParams.add(new Integer(period));
        strSql.append("and ItemDataEntry.FDataElement = ? \n");
        lstParams.add(new Integer(fetchType));
        strSql.append("and ItemDataEntry.FValueType = ? \n");
        lstParams.add(new Integer(valueType));
        strSql.append("and ItemData.FDataCollectNumber = ? \n");
        lstParams.add(dataCollectNumber);
        if (StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append("and ItemDataEntry.FGradeIsleaf = ? \n");
            lstParams.add(new Integer(1));
        }
        strSql.append(" group by ItemData.FDataType \n");
        BigDecimal[] values = new BigDecimal[3];
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        try {
            while (rs.next()) {
                values[rs.getInt((int)2)] = rs.getBigDecimal(1);
            }
            if (RptUtil.isTrue((Object)isAdjusted) && values[2] != null) {
                return values[2];
            }
            if (!RptUtil.isTrue((Object)isAdjusted)) {
                return values[0];
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        strSql = new StringBuffer();
        lstParams = new ArrayList();
        strSql.append("Select Sum(ItemDataEntry.FValue) FValue , ItemData.FDataType \n").append("From ").append(dynaItemTables[0]).append(" ItemData \n").append("inner join ").append(dynaItemTables[1]).append(" ItemDataEntry on ItemData.FID=ItemDataEntry.FItemDataID \n").append("inner join T_Org_BaseUnit BaseUnit on ItemData.FOrgUnitID=BaseUnit.FID \n").append("inner join T_BD_Currency Currency on ItemData.FCurrencyID=Currency.FID \n").append("inner join T_BD_Currency SrcCurrency on ItemData.FSourceCurrencyId=SrcCurrency.FID \n").append("Where ItemData.FDataType = 1 \n");
        type = RptTmpTypeEnum.getEnum((String)templateType);
        if (type != null) {
            strSql.append(" and ItemData.FDataSource = ? \n");
            if (type.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT)) {
                lstParams.add(new Integer(10));
            } else if (type.equals((Object)RptTmpTypeEnum.DYNAMICSUMREPORT)) {
                lstParams.add(new Integer(11));
            } else if (type.equals((Object)RptTmpTypeEnum.DYNAMICCSLREPORT)) {
                lstParams.add(new Integer(12));
            } else if (type.equals((Object)RptTmpTypeEnum.DIFFTABLE)) {
                lstParams.add(new Integer(8));
            }
        }
        if (!StringUtils.isEmpty((String)companyNumber)) {
            strSql.append(" and BaseUnit.FNumber = ? \n");
            lstParams.add(companyNumber);
        }
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            strSql.append(" and Currency.FNumber = ? \n");
            lstParams.add(currencyNumber);
        }
        if (!StringUtils.isEmpty((String)srcCurrency)) {
            strSql.append(" and SrcCurrency.FNumber = ? \n");
            lstParams.add(srcCurrency);
        }
        if (!StringUtils.isEmpty((String)itemNumber)) {
            strSql.append(" and ItemDataEntry.FItemID = ? \n");
            lstParams.add(itemNumber);
        }
        if (!StringUtils.isEmpty((String)dyItemNumber)) {
            strSql.append(" and ItemDataEntry.FKeyNumber = ? \n");
            lstParams.add(dyItemNumber);
        }
        strSql.append("and ItemDataEntry.FYear = ? \n");
        lstParams.add(new Integer(year));
        strSql.append("and ItemDataEntry.FPeriod = ? \n");
        lstParams.add(new Integer(period));
        strSql.append("and ItemDataEntry.FDataElement = ? \n");
        lstParams.add(new Integer(fetchType));
        strSql.append("and ItemDataEntry.FValueType = ? \n");
        lstParams.add(new Integer(valueType));
        strSql.append("and ItemData.FDataCollectNumber = ? \n");
        lstParams.add(dataCollectNumber);
        strSql.append(" group by ItemData.FDataType \n");
        rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        try {
            if (rs.next()) {
                values[rs.getInt((int)2)] = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return (values[0] == null ? CslConstant.BGZERO : values[0]).add(values[1] == null ? CslConstant.BGZERO : values[1]);
    }

    private void transDynamicItemData(Context ctx, List result, IRowSet rs, int itemDataType, Map adjustValues, boolean isAdjusted, boolean isPerspectiveAdjust) throws SQLDataException {
        if (rs == null) {
            return;
        }
        RptLoggerUtils.getInstance().printLog(logger, rs, "transDynamicItemData:");
        String attribute = null;
        StringBuffer key = new StringBuffer();
        RptSrcTypeEnum srcTypeEnum = null;
        String autoFetchDataStr = EASResource.getString((String)ItemAnalysisConstant.resClassName, (String)"96_autoFetchData");
        try {
            while (rs.next()) {
                Object[] curRow;
                Object[] adjustRow;
                Object[] row = new Object[30];
                row[0] = rs.getString("orgTreeNumber");
                row[1] = rs.getString("orgTreeName");
                row[2] = rs.getString("orgUnitNumber");
                row[3] = rs.getString("orgUnitName");
                row[4] = rs.getString("currencyName");
                row[5] = rs.getString("targetCurrencyName");
                srcTypeEnum = RptSrcTypeEnum.getEnum((int)rs.getInt("fdataSource"));
                row[6] = srcTypeEnum != null ? srcTypeEnum.getAlias() : autoFetchDataStr;
                row[29] = rs.getInt("fdataSource");
                row[7] = RptPeriodTypeEnum.getEnum((int)rs.getInt("fperiodType")).getAlias();
                row[8] = rs.getString("fyear");
                row[9] = rs.getString("fperiod");
                row[10] = ValueTypeEnum.getEnum((int)rs.getInt("fvalueType")).getAlias();
                row[26] = new Integer(rs.getInt("fvalueType"));
                row[11] = rs.getString("itemnumber");
                row[12] = rs.getString("itemname");
                row[13] = rs.getString("dataElementNumber");
                row[14] = rs.getString("dataElementName");
                row[15] = rs.getString("dyItemnumber");
                row[16] = rs.getString("dyItemname");
                if (ctx.getLocale().toString().equals("l2")) {
                    row[18] = rs.getString("DataCollectName");
                } else if (ctx.getLocale().toString().equals("l3")) {
                    row[18] = rs.getString("DataCollectNameL3");
                } else if (ctx.getLocale().toString().equals("l1")) {
                    row[18] = rs.getString("DataCollectName");
                }
                row[19] = rs.getString("fkeyNumber");
                row[20] = rs.getString("fkeyName");
                BigDecimal debit = rs.getBigDecimal("debit");
                BigDecimal credit = rs.getBigDecimal("credit");
                if (row[10] != null && row[10].toString().trim().equals(ValueTypeEnum.QUANTITY.getAlias().trim())) {
                    debit = CslRptUtil.cutZeroFromBigdecimal((BigDecimal)debit, null);
                    credit = CslRptUtil.cutZeroFromBigdecimal((BigDecimal)credit, null);
                }
                row[23] = rs.getString("FTextValue");
                row[24] = rs.getString("currencyNumber");
                row[25] = rs.getString("targetCurrencyNumber");
                if (rs.getString("DataElementSeq") != null) {
                    row[27] = rs.getString("DataElementSeq");
                }
                int adjustType = rs.getInt("FDataType");
                row[28] = 2;
                if (itemDataType == 2) {
                    key.setLength(0);
                    key.append(rs.getString("orgBoundID")).append(", ");
                    key.append(rs.getString("orgUnitId")).append(", ");
                    key.append(rs.getString("sourceCurrencyId")).append(", ");
                    key.append(rs.getString("currencyId")).append(", ");
                    key.append(rs.getString("fperiodtype")).append(", ");
                    key.append(rs.getString("fvaluetype")).append(", ");
                    key.append(rs.getString("fyear")).append(", ");
                    key.append(rs.getString("fperiod")).append(", ");
                    key.append(row[11]).append(", ");
                    key.append(rs.getString("DataElementSeq")).append(", ");
                    key.append(row[15]);
                    key.append(row[19]);
                    key.append(rs.getInt("fdataSource"));
                    if (adjustType == 2) {
                        adjustRow = (Object[])adjustValues.get(key.toString());
                        if (adjustRow != null) {
                            adjustRow[21] = debit;
                            adjustRow[22] = credit;
                            continue;
                        }
                        row[21] = debit;
                        row[22] = credit;
                    } else {
                        if (isPerspectiveAdjust) {
                            row[21] = debit;
                            row[22] = credit;
                            curRow = (Object[])row.clone();
                            curRow[28] = 0;
                            result.add(curRow);
                        }
                        if ((adjustRow = (Object[])adjustValues.get(key.toString())) != null) {
                            adjustRow[21] = adjustRow[21] == null ? debit : debit.add((BigDecimal)adjustRow[21]);
                            if (adjustRow[22] == null) {
                                adjustRow[22] = credit;
                                continue;
                            }
                            adjustRow[22] = credit.add((BigDecimal)adjustRow[22]);
                            continue;
                        }
                        row[21] = debit;
                        row[22] = credit;
                        adjustValues.put(key.toString(), row);
                    }
                } else if (itemDataType == 1) {
                    if (isPerspectiveAdjust) {
                        row[21] = debit;
                        row[22] = credit;
                        curRow = (Object[])row.clone();
                        curRow[28] = 1;
                        result.add(curRow);
                    }
                    key.setLength(0);
                    key.append(rs.getString("orgBoundID")).append(", ");
                    key.append(rs.getString("orgUnitId")).append(", ");
                    key.append(rs.getString("sourceCurrencyId")).append(", ");
                    key.append(rs.getString("currencyId")).append(", ");
                    key.append(rs.getString("fperiodtype")).append(", ");
                    key.append(rs.getString("fvaluetype")).append(", ");
                    key.append(rs.getString("fyear")).append(", ");
                    key.append(rs.getString("fperiod")).append(", ");
                    key.append(row[11]).append(", ");
                    key.append(rs.getString("DataElementSeq")).append(", ");
                    key.append(row[15]);
                    key.append(row[19]);
                    key.append(rs.getInt("fdataSource"));
                    adjustType = 2;
                    adjustRow = (Object[])adjustValues.get(key.toString());
                    if (adjustRow != null) {
                        if (rs.getInt("debit") != 0) {
                            adjustRow[21] = debit.add((BigDecimal)adjustRow[21]);
                            continue;
                        }
                        adjustRow[22] = credit.add((BigDecimal)adjustRow[22]);
                        continue;
                    }
                    row[21] = debit;
                    row[22] = credit;
                    adjustValues.put(key.toString(), row);
                } else {
                    row[21] = debit;
                    row[22] = credit;
                }
                switch (itemDataType) {
                    case 1: 
                    case 2: {
                        attribute = !isAdjusted ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataService_BeforeAdjust", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataService_AfterAdjust", (Locale)ctx.getOriginLocale());
                        attribute = attribute + row[6];
                        break;
                    }
                    case 3: {
                        attribute = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataService_ElimEntry", (Locale)ctx.getOriginLocale());
                        attribute = attribute + rs.getString("FNumber") + "[" + rs.getString("FSeq") + "]";
                        break;
                    }
                    case 4: {
                        attribute = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataService_AdjustEntry", (Locale)ctx.getOriginLocale());
                        attribute = attribute + rs.getString("FNumber") + "[" + rs.getString("FSeq") + "]";
                        break;
                    }
                }
                row[17] = attribute;
                result.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        RptLoggerUtils.getInstance().printList(logger, result, "transDynamicItemDataResult:");
    }

    @Override
    protected List _getDynamicItemData(Context ctx, ItemDataCondition condition, Map exCondition) throws BOSException, EASBizException {
        Integer dataType;
        List compNumbers;
        ArrayList result = new ArrayList();
        HashMap adjustValue = new HashMap();
        IRowSet rowSet = null;
        if (condition.getOrgTreeNumber() != null && exCondition.get("ORG_TREE_NUMBER") != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FNUMBER FROM T_ORG_TREE WHERE FID=?", (Object[])new String[]{condition.getOrgTreeNumber()});
            try {
                if (rs.next()) {
                    exCondition.put("ORG_TREE_NUMBER", rs.getString(1));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (condition.getOrgUnit() != null && !(compNumbers = CslRptUtil.getORGNumbersByID((Context)ctx, (String)condition.getOrgUnitString())).isEmpty()) {
            condition.setOrgUnitNumber(compNumbers);
        }
        if ((dataType = (Integer)exCondition.get("dataType")) == 2) {
            boolean isPerspectiveAdjust;
            boolean bl = isPerspectiveAdjust = exCondition.get("isPerspectiveAdjust") != null ? (Boolean)exCondition.get("isPerspectiveAdjust") : false;
            if (condition.getIsAdjusted()) {
                rowSet = this.getAdjustDynamicItemData(ctx, condition, exCondition);
                this.transDynamicItemData(ctx, result, rowSet, 1, adjustValue, true, isPerspectiveAdjust);
            }
            rowSet = this.getMainDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 2, adjustValue, condition.getIsAdjusted(), isPerspectiveAdjust);
        } else if (dataType == 3) {
            rowSet = this.getElimDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 3, null, false, false);
            exCondition.put("isElimReport", true);
            rowSet = this.getMainDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 2, adjustValue, condition.getIsAdjusted(), false);
            exCondition.remove("isElimReport");
        } else if (dataType == 4) {
            rowSet = this.getAdjustDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 4, null, false, false);
        } else if (dataType == 5) {
            rowSet = this.getElimDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 3, null, false, false);
        } else {
            if (condition.getIsAdjusted()) {
                rowSet = this.getAdjustDynamicItemData(ctx, condition, exCondition);
                this.transDynamicItemData(ctx, result, rowSet, 1, adjustValue, true, false);
            }
            rowSet = this.getMainDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 2, adjustValue, condition.getIsAdjusted(), false);
            rowSet = this.getElimDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 3, null, false, false);
            rowSet = this.getAdjustDynamicItemData(ctx, condition, exCondition);
            this.transDynamicItemData(ctx, result, rowSet, 4, null, false, false);
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        Integer integer = (Integer)exCondition.get("maxReturnRowCount");
        if (integer != null && integer < result.size()) {
            ArrayList newResult = new ArrayList(integer);
            for (int i = 0; i < integer; ++i) {
                newResult.add(result.get(i));
            }
            return newResult;
        }
        return result;
    }

    private void getWhereStr(Context ctx, SQLBuilder querySql, ItemDataCondition conditions, Map exCondition, boolean isAutoFetch) throws EASBizException, BOSException {
        String targetCurrencyID;
        String dataCollectNumber;
        boolean isElimReport = exCondition.containsKey("isElimReport") ? (Boolean)exCondition.get("isElimReport") : false;
        querySql.append(" WHERE 1=1 ");
        if (!isAutoFetch) {
            if (!conditions.isForBiReport() && !isElimReport && (!conditions.isUsedFastMerge() && !exCondition.containsKey("unCommitStatusFlag4MgCslDyna") || conditions.isUsedFastMerge() && conditions.getCommitStatus() != -1)) {
                querySql.append(" AND t1.FCommitStatus = ").append((Object)3).append(" \r\n");
            }
            if (conditions.isForBiReport() && conditions.getCommitStatus() != -1) {
                querySql.append(" AND t1.FCommitStatus = ").append((Object)conditions.getCommitStatus()).append(" \r\n");
            }
            querySql.append("and t1.FDataType = ").append((Object)0).append("\r\n");
            querySql.append("and t1.fdynatype=1 ");
        }
        if (StringUtils.isEmpty((String)(dataCollectNumber = conditions.getDataCollectNumber()))) {
            dataCollectNumber = "ACTUALDATA";
        }
        querySql.append(" AND t1.FDataCollectNumber = '").append(dataCollectNumber).append("' ");
        if (!isAutoFetch) {
            String orgBoundID = conditions.getOrgTreeNumber();
            if (exCondition.get("ORG_TREE_NUMBER") != null) {
                querySql.append(" \tAND t4.FNumber =? ", exCondition.get("ORG_TREE_NUMBER"));
            } else if (orgBoundID != null && orgBoundID.trim().length() > 0) {
                querySql.append(" \tAND t4.FID = ? ", (Object)orgBoundID);
            }
        }
        if (conditions.getOrgUnitNumber() != null) {
            querySql.append(" AND t5.FNumber in ", (Collection)conditions.getOrgUnitNumber());
        } else {
            String orgUnitID = conditions.getOrgUnitString();
            if (orgUnitID != null && orgUnitID.trim().length() > 0) {
                querySql.append(" \tAND t5.FID in (").append(orgUnitID).append(")").append("\r\n");
            }
        }
        if (!StringUtils.isEmpty((String)conditions.getReportClass())) {
            querySql.append(" \tAND t8.FReportClassID = '").append(conditions.getReportClass()).append("'").append("\r\n");
        }
        boolean isItemData = false;
        if (exCondition.containsKey("isItemData")) {
            boolean bl = isItemData = "Y".equals(exCondition.get("isItemData"));
        }
        if (conditions.getRptYearStart() != -1 && conditions.getRptYearEnd() != -1 && conditions.getRptPeriodStart() != -1 && conditions.getRptPeriodEnd() != -1 && conditions.getRptYearStart() == conditions.getRptYearEnd() && conditions.getRptPeriodStart() == conditions.getRptPeriodEnd()) {
            querySql.append(" AND t2.FYear = ? ", (Object)conditions.getRptYearStart());
            if (isItemData) {
                Integer period = new Integer(conditions.getRptPeriodStart());
                if (exCondition.containsKey("period")) {
                    period = (Integer)exCondition.get("period");
                    querySql.append(" AND t2.FPeriod = ? ", (Object)period);
                } else if (period != null && period == 12) {
                    querySql.append(" AND t2.FPeriod in (12,13)");
                } else {
                    querySql.append(" AND t2.FPeriod = ? ", (Object)period);
                }
                if (exCondition.containsKey("query13Period") && "N".equals((String)exCondition.get("query13Period"))) {
                    querySql.append(" AND t2.FPeriod").append("!=13 ");
                }
            } else {
                querySql.append(" AND t2.FPeriod = ? ", (Object)conditions.getRptPeriodStart());
            }
        } else {
            int endPeriod = 0;
            if (conditions.getRptPeriodEnd() != -1) {
                endPeriod = conditions.getRptPeriodEnd();
                if (isItemData && endPeriod == 12 && conditions.getRptPeriodType() == 3) {
                    ++endPeriod;
                }
            }
            if (conditions.getRptYearStart() != -1 && conditions.getRptYearEnd() != -1 && conditions.getRptYearStart() == conditions.getRptYearEnd()) {
                querySql.append(" AND t2.FYear = ? ", (Object)conditions.getRptYearStart());
                if (conditions.getRptPeriodStart() != -1) {
                    querySql.append(" AND t2.FPeriod >= ? ", (Object)conditions.getRptPeriodStart());
                }
                if (conditions.getRptPeriodEnd() != -1) {
                    querySql.append(" AND t2.FPeriod <= ? ", (Object)endPeriod);
                }
            } else {
                if (conditions.getRptYearStart() != -1) {
                    querySql.append(" AND (t2.FYear > ? ", (Object)conditions.getRptYearStart());
                    querySql.append(" OR (t2.FYear = ? ", (Object)conditions.getRptYearStart());
                    if (conditions.getRptPeriodStart() != -1) {
                        querySql.append(" AND t2.FPeriod >= ? ", (Object)conditions.getRptPeriodStart());
                    }
                    querySql.append(")) ");
                }
                if (conditions.getRptYearEnd() != -1) {
                    querySql.append(" AND (t2.FYear < ? ", (Object)conditions.getRptYearEnd());
                    querySql.append(" OR (t2.FYear = ? ", (Object)conditions.getRptYearEnd());
                    if (conditions.getRptPeriodEnd() != -1) {
                        querySql.append(" AND t2.FPeriod <= ? ", (Object)endPeriod);
                    }
                    querySql.append(")) ");
                }
            }
            if (isItemData) {
                querySql.append(this.get13PeriodFilter(exCondition, "t2.FPeriod"));
            }
        }
        String currencyID = conditions.getCurrency();
        if (currencyID != null && currencyID.trim().length() > 0) {
            querySql.append(" \tAND t6.FID = '").append(currencyID).append("'").append("\r\n");
        }
        if (!StringUtils.isEmpty((String)(targetCurrencyID = conditions.getTargetCurrency()))) {
            querySql.append(" \tAND t7.FID = '").append(targetCurrencyID).append("'").append("\r\n");
        }
        if (conditions.isForBiReport()) {
            Map itemList = conditions.getItemList();
            if (itemList != null && itemList.size() > 0) {
                HashSet<String> itemSet = new HashSet<String>();
                Iterator it = itemList.keySet().iterator();
                while (it.hasNext()) {
                    itemSet.add(it.next().toString());
                }
                if (itemSet.size() > 0) {
                    querySql.append(" \tAND t8.FNumber in ", itemSet);
                }
            }
        } else {
            String RPTItemNumEnd;
            String RPTItemNumStart = conditions.getItemNumberStart();
            if (RPTItemNumStart != null && RPTItemNumStart.trim().length() > 0) {
                querySql.append(" \tAND t8.FNumber >= ? ", (Object)RPTItemNumStart);
            }
            if ((RPTItemNumEnd = conditions.getItemNumberEnd()) != null && RPTItemNumEnd.trim().length() > 0) {
                querySql.append(" \tAND t8.FNumber <= ? ", (Object)RPTItemNumEnd);
            }
        }
        if (conditions.getItemNumberLevelStart() != -1) {
            querySql.append(" \tAND t8.FLevel >=? ", (Object)conditions.getItemNumberLevelStart());
        }
        if (conditions.getItemNumberLevelEnd() != -1) {
            querySql.append(" \tAND t8.FLevel <=? ", (Object)conditions.getItemNumberLevelEnd());
        }
        if (conditions.getRptPeriodType() != -1) {
            querySql.append(" \tAND t1.FPeriodType =").append((Object)conditions.getRptPeriodType()).append(" \r\n");
        }
        if (isAutoFetch) {
            querySql.append(" and t1.FDataSource=100 \n");
        } else if (conditions.getDataSource() != -1) {
            if (conditions.isUsedFastMerge()) {
                if (1 != conditions.getDataSource()) {
                    if (conditions.getDataSource() == 3 && isElimReport) {
                        querySql.append(" AND t1.FDataSource in(42,43) \n");
                        querySql.append(" and t1.FFastMergeSoluId='").append(conditions.getFastMergeSoluId()).append("' \n");
                    } else {
                        querySql.append(" and (t1.FDataSource in(32,35) ").append(" and t1.FFastMergeSoluId='").append(conditions.getFastMergeSoluId()).append("' or t1.FDataSource=10) \n");
                    }
                }
            } else if (conditions.isForBiReport()) {
                querySql.append(" and (t1.FDataSource=").append((Object)(conditions.getDataSource() + 9)).append(" OR t1.FDataSource=10) ");
            } else {
                querySql.append(" and t1.FDataSource=").append((Object)(conditions.getDataSource() + 9));
            }
        } else if (conditions.isUsedFastMerge()) {
            if (isElimReport) {
                querySql.append(" AND t1.FDataSource in(42,43) \n");
                querySql.append(" and t1.FFastMergeSoluId='").append(conditions.getFastMergeSoluId()).append("' \n");
            } else {
                querySql.append(" and ((t1.FDataSource in(32,35) ");
                querySql.append(" and t1.FFastMergeSoluId='").append(conditions.getFastMergeSoluId()).append("') \n");
                querySql.append(" or t1.FDataSource =10 )");
            }
        } else if (isElimReport) {
            querySql.append(" AND t1.FDataSource in(42) \n");
        } else {
            querySql.append(" AND t1.FDataSource in(10,11,12) \n");
        }
        if (conditions.isForBiReport()) {
            List element = conditions.getLstDataElement();
            if (element != null && element.size() > 0) {
                querySql.append(" \tAND t2.FDataElement in ", (Collection)element);
            }
        } else if (conditions.getDataElement() != -1) {
            querySql.append(" \tAND t2.FDataElement = ? ", (Object)conditions.getDataElement());
        }
        if (conditions.isForBiReport()) {
            List ls = (List)exCondition.get("DATA_TYPE");
            if (ls != null && ls.size() > 0) {
                querySql.append(" \tAND t2.FValueType in (");
                for (int i = 0; i < ls.size(); ++i) {
                    if (i != 0) {
                        querySql.append(",");
                    }
                    querySql.append((Object)((ValueTypeEnum)ls.get(i)).getValue());
                }
                querySql.append(" )\r\n");
            }
        } else if (conditions.getValueType() != -1) {
            querySql.append(" \tAND t2.FValueType = ? ", (Object)conditions.getValueType()).append(" \r\n");
        }
        if (conditions.isForBiReport() && exCondition.get("keyName") != null) {
            List keynames = (List)exCondition.get("keyName");
            querySql.append(" \tAND t2.fkeyNumber in ", (Collection)keynames);
        } else if (exCondition.get("keyName") != null && !StringUtils.isEmpty((String)((String)exCondition.get("keyName")))) {
            querySql.append(" \tAND t2.FKeyname like ? ", (Object)(exCondition.get("keyName") + "%")).append(" \r\n");
        }
        if (!conditions.isShowFreezeItem()) {
            querySql.append(" and t8.FIsFreezed=0");
        }
    }

    private void constructWhere(SQLBuilder sql, ItemDataCondition conditions, Map exCondition, int itemDataType) {
        String targetCurrencyID;
        String orgBoundID = conditions.getOrgTreeNumber();
        if (exCondition.get("ORG_TREE_NUMBER") != null) {
            sql.append(" \tAND t4.FNumber = ? ", exCondition.get("ORG_TREE_NUMBER"));
        } else if (orgBoundID != null && orgBoundID.trim().length() > 0) {
            sql.append(" \tAND t4.FID = ? ", (Object)orgBoundID);
        }
        if (conditions.getOrgUnitNumber() != null) {
            sql.append(" AND t5.FNumber in ", (Collection)conditions.getOrgUnitNumber());
        } else {
            String orgUnitID = conditions.getOrgUnitString();
            if (orgUnitID != null && orgUnitID.trim().length() > 0) {
                sql.append(" \tAND t5.FID in (").append(orgUnitID).append(") \t\t\t\t\t\t\t\r\n");
            }
        }
        if (!StringUtils.isEmpty((String)conditions.getReportClass())) {
            sql.append(" \tAND t8.FReportClassID = '").append(conditions.getReportClass()).append("'\n");
        }
        boolean isItemData = false;
        if (exCondition.containsKey("isItemData")) {
            boolean bl = isItemData = "Y".equals(exCondition.get("isItemData"));
        }
        if (conditions.getRptYearStart() != -1 && conditions.getRptYearEnd() != -1 && conditions.getRptPeriodStart() != -1 && conditions.getRptPeriodEnd() != -1 && conditions.getRptYearStart() == conditions.getRptYearEnd() && conditions.getRptPeriodStart() == conditions.getRptPeriodEnd()) {
            sql.append(" AND FYear = ? ", (Object)conditions.getRptYearStart());
            if (isItemData) {
                Integer period = new Integer(conditions.getRptPeriodStart());
                if (exCondition.containsKey("period")) {
                    period = (Integer)exCondition.get("period");
                    sql.append(" AND FPeriod = ? ", (Object)period);
                } else if (period != null && period == 12) {
                    sql.append(" AND FPeriod in (12,13)");
                } else {
                    sql.append(" AND FPeriod = ?", (Object)period);
                }
                if (exCondition.containsKey("query13Period") && "N".equals((String)exCondition.get("query13Period"))) {
                    sql.append(" AND FPeriod").append("!=13 ");
                }
            } else {
                sql.append(" AND FPeriod = ? ", (Object)conditions.getRptPeriodStart());
            }
        } else {
            int endPeriod = 0;
            if (conditions.getRptPeriodEnd() != -1) {
                endPeriod = conditions.getRptPeriodEnd();
                if (isItemData && endPeriod == 12 && conditions.getRptPeriodType() == 3) {
                    ++endPeriod;
                }
            }
            if (conditions.getRptYearStart() != -1 && conditions.getRptYearEnd() != -1 && conditions.getRptYearStart() == conditions.getRptYearEnd()) {
                sql.append(" AND FYear = ? ", (Object)conditions.getRptYearStart());
                if (conditions.getRptPeriodStart() != -1) {
                    sql.append(" AND FPeriod >= ? ", (Object)conditions.getRptPeriodStart());
                }
                if (conditions.getRptPeriodEnd() != -1) {
                    sql.append(" AND FPeriod <= ? ", (Object)endPeriod);
                }
            } else {
                if (conditions.getRptYearStart() != -1) {
                    sql.append(" AND (FYear > ? ", (Object)conditions.getRptYearStart());
                    sql.append(" OR (FYear = ? ", (Object)conditions.getRptYearStart());
                    if (conditions.getRptPeriodStart() != -1) {
                        sql.append(" AND FPeriod >= ? ", (Object)conditions.getRptPeriodStart());
                    }
                    sql.append(")) ");
                }
                if (conditions.getRptYearEnd() != -1) {
                    sql.append(" AND (FYear < ? ", (Object)conditions.getRptYearEnd());
                    sql.append(" OR (FYear = ? ", (Object)conditions.getRptYearEnd());
                    if (conditions.getRptPeriodEnd() != -1) {
                        sql.append(" AND FPeriod <= ? ", (Object)endPeriod);
                    }
                    sql.append(")) ");
                }
            }
            if (isItemData) {
                sql.append(this.get13PeriodFilter(exCondition, "FPeriod"));
            }
        }
        String currencyID = conditions.getCurrency();
        if (currencyID != null && currencyID.trim().length() > 0) {
            sql.append(" \tAND t6.FID = ? ", (Object)currencyID);
        }
        if (!StringUtils.isEmpty((String)(targetCurrencyID = conditions.getTargetCurrency()))) {
            sql.append(" \tAND t7.FID = ? ", (Object)targetCurrencyID);
        }
        if (conditions.isForBiReport()) {
            Map itemList = conditions.getItemList();
            if (itemList != null && !itemList.isEmpty()) {
                HashSet<String> itemSet = new HashSet<String>();
                Iterator iterator = itemList.keySet().iterator();
                while (iterator.hasNext()) {
                    itemSet.add(iterator.next().toString());
                }
                if (itemSet.size() > 0) {
                    sql.append(" \tAND t8.FNumber in ", itemSet);
                }
            }
        } else {
            String RPTItemNumEnd;
            String RPTItemNumStart = conditions.getItemNumberStart();
            if (RPTItemNumStart != null && RPTItemNumStart.trim().length() > 0) {
                sql.append(" \tAND t8.FNumber >= ? ", (Object)RPTItemNumStart);
            }
            if ((RPTItemNumEnd = conditions.getItemNumberEnd()) != null && RPTItemNumEnd.trim().length() > 0) {
                sql.append(" \tAND t8.FNumber <= ? ", (Object)RPTItemNumEnd);
            }
        }
        if (conditions.getItemNumberLevelStart() != -1) {
            sql.append(" \tAND t8.FLevel >= ? ", (Object)conditions.getItemNumberLevelStart());
        }
        if (conditions.getItemNumberLevelEnd() != -1) {
            sql.append(" \tAND t8.FLevel <=? ", (Object)conditions.getItemNumberLevelEnd());
        }
        if (conditions.getRptPeriodType() != -1) {
            sql.append(" \tAND FPeriodType = ? ", (Object)conditions.getRptPeriodType());
        }
        if (conditions.getDataSource() != -1) {
            if (conditions.isForBiReport()) {
                sql.append(" and (t1.FDataSource=").append((Object)conditions.getDataSource()).append(" OR t1.FDataSource=1) ");
            } else if (itemDataType == 3) {
                if (conditions.getDataSource() == 4) {
                    sql.append(" \tAND t8.FDc != 0\t\n");
                } else if (conditions.getDataSource() == 5) {
                    sql.append(" \tAND (1 - t8.FDc) != 0\t\n");
                }
            } else if (itemDataType == 4) {
                sql.append(" and FDataSource=").append((Object)conditions.getDataSource());
            } else {
                sql.append(" and FDataSource=").append((Object)(conditions.getDataSource() + 9));
            }
        }
        if (conditions.isForBiReport()) {
            List element = conditions.getLstDataElement();
            if (element != null && element.size() > 0) {
                sql.append(" \tAND t2.FDataElement in ", (Collection)element);
            }
        } else if (conditions.getDataElement() != -1) {
            sql.append(" \tAND t2.FDataElement = ?", (Object)conditions.getDataElement()).append(" \r\n");
        }
        if (conditions.isForBiReport()) {
            List ls = (List)exCondition.get("DATA_TYPE");
            if (ls != null && ls.size() > 0) {
                sql.append(" \tAND FValueType in (");
                for (int i = 0; i < ls.size(); ++i) {
                    if (i != 0) {
                        sql.append(",");
                    }
                    sql.append((Object)((ValueTypeEnum)ls.get(i)).getValue());
                }
                sql.append(" )\r\n");
            }
        } else if (conditions.getValueType() != -1) {
            sql.append(" \tAND FValueType =").append((Object)conditions.getValueType()).append(" \r\n");
        }
        if (conditions.isForBiReport() && exCondition.get("keyName") != null) {
            List keynames = (List)exCondition.get("keyName");
            sql.append(" \tAND t3.fkeyLongNumber in ", (Collection)keynames);
        } else if (exCondition.get("keyName") != null && !StringUtils.isEmpty((String)((String)exCondition.get("keyName")))) {
            sql.append(" \tAND FKeyname like ? ", (Object)(exCondition.get("keyName") + "%"));
        }
        if (!conditions.isShowFreezeItem()) {
            sql.append(" and t8.FIsFreezed=0");
        }
    }

    private IRowSet getMainDynamicItemData(Context ctx, ItemDataCondition condition, Map exCondition) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        SQLBuilder querySql = new SQLBuilder();
        querySql.append(this.getSelectStr(ctx, condition, exCondition, false));
        querySql.append(this.getFromStr(ctx, condition, exCondition, false));
        this.getWhereStr(ctx, querySql, condition, exCondition, false);
        if (condition.isUsedFastMerge()) {
            boolean isContainUnRecive = FastMergeUtil.getIsContainUnRecive((Context)ctx, (String)condition.getFastMergeSoluId());
            if (isContainUnRecive) {
                querySql.append(" union all ");
                querySql.append(this.getSelectStr(ctx, condition, exCondition, true));
                querySql.append(this.getFromStr(ctx, condition, exCondition, true));
                this.getWhereStr(ctx, querySql, condition, exCondition, true);
            }
        } else {
            querySql.append("order by t5.fnumber,t6.fnumber,t7.fnumber").append("\r\n");
            querySql.append(",t1.FDatasource,t1.FPeriodtype").append("\r\n");
            querySql.append(",t2.fyear,t2.fperiod,t2.fvaluetype").append("\r\n");
            querySql.append(",t8.fnumber,t2.fkeynumber").append("\r\n");
        }
        return DbUtil.executeQuery((Context)ctx, (String)querySql.getSQL(), (Object[])querySql.getParams());
    }

    private String getFromStr(Context ctx, ItemDataCondition condition, Map exCondition, boolean isAutoFetch) throws BOSException {
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName((boolean)condition.isQueryHisBudget());
        String cslReportTabName = QueryHisBudgetUtils.getCslReportTabName((boolean)condition.isQueryHisBudget());
        String[] dynaItemTables = new String[]{"t_csl_dynaitemdata", "t_csl_dynaitemdataentry"};
        if (condition.getRptYearStart() != -1 && condition.getRptPeriodStart() != -1 && condition.getRptYearEnd() != -1 && condition.getRptPeriodEnd() != -1) {
            dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)condition.getRptYearStart(), (int)condition.getRptPeriodStart(), (int)condition.getRptYearEnd(), (int)condition.getRptPeriodEnd());
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append(" from ").append(dynaItemTables[0]).append(" t1").append("\r\n");
        querySql.append(" inner join ").append(dynaItemTables[1]).append(" t2").append("\r\n");
        querySql.append(" on t1.fid=t2.fitemdataid").append("\r\n");
        if (!isAutoFetch) {
            querySql.append(" inner join ").append(rptReceiveTabName).append(" t3").append("\r\n");
            querySql.append(" on t1.freportid=t3.freportid").append("\r\n");
            querySql.append(" inner join T_ORG_Tree t4 ON t3.FOrgTreeID = t4.FID").append("\r\n");
        }
        querySql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnitID = t5.FID").append("\r\n");
        querySql.append(" INNER JOIN T_BD_Currency t6 ON t1.FSourceCurrencyId = t6.FID").append("\r\n");
        querySql.append(" INNER JOIN T_BD_Currency t7 ON t1.FCurrencyID = t7.FID").append("\r\n");
        querySql.append(" INNER JOIN T_CSL_RptItem t8 ON t2.FItemID = t8.FNumber").append("\r\n");
        querySql.append(" INNER JOIN T_CSL_DataElement t9").append("\r\n");
        querySql.append(" ON t2.FDataElement = t9.FInterSeq").append("\r\n");
        querySql.append(" INNER JOIN T_CSL_DataCollect t10 ON t1.FDataCollectNumber = t10.FNumber ").append("\r\n");
        if (!isAutoFetch) {
            querySql.append("left join ").append(cslReportTabName).append(" t").append("\r\n");
            querySql.append("on t.FSourceRptID = t3.freportid").append("\r\n");
            querySql.append("and t.FAdjustStatus = ").append(1).append("\r\n");
            querySql.append("and t.FIsSaveAs = ").append(0).append("\r\n");
            querySql.append("left join ").append(dynaItemTables[0]).append(" t11").append("\r\n");
            querySql.append("on t11.forgunitid=t1.forgunitid").append("\r\n");
            querySql.append("and t11.fcurrencyid=t1.fcurrencyid").append("\r\n");
            querySql.append("and t11.fperiodtype=t1.fperiodtype").append("\r\n");
            querySql.append("and t11.fdatasource=t1.fdatasource").append("\r\n");
            querySql.append("and t11.fdatatype=").append(2).append("\r\n");
            querySql.append("and t11.FReportID = t.FID").append("\r\n");
            querySql.append("left join ").append(dynaItemTables[1]).append(" t22").append("\r\n");
            querySql.append("on t11.FID=t22.fitemdataid").append("\r\n");
            querySql.append("and t2.fitemid=t22.fitemid").append("\r\n");
            querySql.append("and t2.fkeynumber=t22.fkeynumber").append("\r\n");
            querySql.append("and t2.fdataelement=t22.fdataelement").append("\r\n");
            querySql.append("and t2.fvaluetype=t22.fvaluetype").append("\r\n");
            querySql.append("and t2.fyear=t22.fyear").append("\r\n");
            querySql.append("and t2.fperiod=t22.fperiod").append("\r\n");
        }
        return querySql.toString();
    }

    private String getSelectStr(Context ctx, ItemDataCondition condition, Map exCondition, boolean isAutoFetch) {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer querySql = new StringBuffer();
        Integer integer = (Integer)exCondition.get("maxReturnRowCount");
        String top = "";
        if (integer != null) {
            top = " top " + integer;
        }
        querySql.append("select ").append(condition.isQueryHisBudget() ? " distinct " : " ").append(top);
        querySql.append(isAutoFetch ? "null" : "t4.fnumber").append(" orgTreeNumber, \r\n");
        querySql.append(isAutoFetch ? "null" : "t4.fname_" + lang).append(" orgTreeName").append("\r\n");
        querySql.append(",t5.fnumber orgUnitNumber").append("\r\n");
        querySql.append(",t5.fname_").append(lang).append(" orgUnitName").append("\r\n");
        querySql.append(",t6.fnumber currencyNumber\r\n");
        querySql.append(",t6.fname_").append(lang).append(" currencyName").append("\r\n");
        querySql.append(",t7.fnumber targetCurrencyNumber\r\n");
        querySql.append(",t7.fname_").append(lang).append(" targetCurrencyName").append("\r\n");
        querySql.append(",t1.fdatasource,t1.fperiodtype").append("\r\n");
        querySql.append(",t2.fyear,t2.fperiod,t2.fvaluetype").append("\r\n");
        querySql.append(",t8.fnumber itemNumber").append("\r\n");
        querySql.append(",t8.fname_").append(lang).append(" itemName").append("\r\n");
        querySql.append(",t9.fnumber dataElementNumber").append("\r\n");
        querySql.append(",t9.fname_").append(lang).append(" dataElementName").append("\r\n");
        querySql.append(",t8.fnumber dyItemNumber").append("\r\n");
        querySql.append(",t8.fname_").append(lang).append(" dyItemName").append("\r\n");
        querySql.append(",t2.fkeynumber,t2.fkeyname").append("\r\n");
        if (!isAutoFetch && condition.getIsAdjusted()) {
            querySql.append(",isnull(t22.FValue,t2.FValue)*(1-t8.FDc) CREDIT").append("\r\n");
            querySql.append(",isnull(t22.FValue,t2.FValue)*t8.FDc DEBIT").append("\r\n");
        } else {
            querySql.append(",t2.FValue*(1-t8.FDc) CREDIT").append("\r\n");
            querySql.append(",t2.FValue*t8.FDc DEBIT").append("\r\n");
        }
        querySql.append(",t10.FNAME_" + ctx.getLocale() + "  DataCollectName ").append("\r\n");
        querySql.append(",t10.FNAME_L3  DataCollectNameL3 ").append("\r\n");
        String orgBoundID = "''";
        if (!isAutoFetch && !condition.isQueryHisBudget()) {
            orgBoundID = "t4.fid";
        }
        querySql.append(",t2.ftextvalue,").append(orgBoundID).append(" as orgBoundID,t5.fid as orgUnitID").append("\r\n");
        querySql.append(",t6.fid as sourceCurrencyId, t7.fid as currencyId, t2.FDataElement as DataElementSeq").append("\r\n");
        if (isAutoFetch) {
            querySql.append(",0 ");
        } else {
            querySql.append(",case when t22.FValue is null then 0 else 2 end ");
        }
        querySql.append(" as FDataType").append("\r\n");
        return querySql.toString();
    }

    private IRowSet getAdjustDynamicItemData(Context ctx, ItemDataCondition condition, Map exCondition) throws BOSException {
        String dataCollectNumber;
        String lang = ctx.getLocale().getLanguage();
        String adjustTabName = QueryHisBudgetUtils.getAdjustTabName((boolean)condition.isQueryHisBudget());
        String adjustEntryTabName = QueryHisBudgetUtils.getAdjustEntryTabName((boolean)condition.isQueryHisBudget());
        Integer integer = (Integer)exCondition.get("maxReturnRowCount");
        String top = "";
        if (integer != null) {
            top = " top " + integer;
        }
        SQLBuilder querySql = new SQLBuilder();
        querySql.append("select");
        querySql.append(condition.isQueryHisBudget() ? " distinct * from ( select " : "");
        querySql.append(top);
        querySql.append(" t4.fnumber orgTreeNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t4.fname_").append(lang).append(" orgTreeName\t\t\t\n");
        querySql.append(",t5.fnumber orgUnitNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t5.fname_").append(lang).append(" orgUnitName\t\t\t\n");
        querySql.append(",t6.fnumber currencyNumber \n");
        querySql.append(",t6.fname_").append(lang).append(" currencyName\t\t\n");
        querySql.append(",t7.fnumber targetCurrencyNumber \n");
        querySql.append(",t7.fname_").append(lang).append(" targetCurrencyName\t\n");
        querySql.append(",t1.fdatasource+9 as fdatasource,t1.fperiodtype\t\t\n");
        querySql.append(",t1.fyear,t1.fperiod,t1.fvaluetype\t\t\t\t\t\t\n");
        querySql.append(",t8.fnumber itemNumber\t\t\t\t\t\t\t\t\t\n");
        querySql.append(",t8.fname_").append(lang).append(" itemName\t\t\t\n");
        querySql.append(",t9.fnumber dataElementNumber\t\t\t\t\t\t\t\n");
        querySql.append(",t9.fname_").append(lang).append(" dataElementName\t\t\n");
        querySql.append(",t10.fnumber dyItemNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t10.fname_").append(lang).append(" dyItemName\t\t\t\n");
        querySql.append(",t3.fkeyLongNumber as fkeynumber,t3.fkeyname\t\t\t\n");
        querySql.append(",t3.FValue*(1-t8.FDc) CREDIT,t3.FValue*t8.FDc DEBIT\t\n");
        querySql.append(",null as ftextvalue,0 as FDataType\t\t\t\t\t\t\n");
        querySql.append(",t1.FNumber,t2.FSeq\t\t\t\t\t\t\t\t\t\n");
        querySql.append(condition.isQueryHisBudget() ? ", '' as orgBoundID" : ", t4.FId as orgBoundID").append(", t5.FId as orgUnitId, t6.FId as sourceCurrencyId");
        querySql.append(", t7.FId as currencyId, t2.FDataElement as DataElementSeq \n");
        querySql.append(",t11.FNAME_" + ctx.getLocale() + " DataCollectName,t11.FNAME_L3 DataCollectNameL3 \n");
        querySql.append(" from ").append(adjustTabName).append(" t1\t\t\t\t\t\t\t\t\t\n");
        querySql.append(" inner join ").append(adjustEntryTabName).append(" t2\t\t\t\t\t\t\n");
        querySql.append(" on t1.fid=t2.fadjustid\t\t\t\t\t\t\t\t\n");
        querySql.append(" inner join t_Csl_AdjustDynamicItem t3\t\t\t\t\t\n");
        querySql.append(" on t2.fid=t3.fadjustentryid\t\t\t\t\t\t\t\n");
        querySql.append(" inner join T_ORG_Tree t4 ON t1.FOrgBoundID = t4.FID\t\n");
        querySql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnit = t5.FID\t\n");
        querySql.append(" INNER JOIN T_BD_Currency t6 ON t1.FSourceCurrencyID = t6.FID\n");
        querySql.append(" INNER JOIN T_BD_Currency t7 ON t1.FCurrencyID = t7.FID\n");
        querySql.append(" INNER JOIN T_CSL_RptItem t8 ON t2.FItemID = t8.FID\t\n");
        querySql.append(" INNER JOIN T_CSL_DataElement t9\t\t\t\t\t\t\n");
        querySql.append(" ON t2.FDataElement = t9.FInterSeq \t\t\t\t\t\n");
        querySql.append(" INNER JOIN T_CSL_RptItem t10 ON t3.FRptItemID = t10.FID   \n");
        querySql.append(" INNER JOIN T_CSL_DataCollect t11  ON t1.FDataCollectNumber = t11.FNumber   \n");
        if (!condition.isIncludeUnAuditAdjust()) {
            querySql.append(" WHERE t1.FCheckedStatus = ").append((Object)2).append("\n");
        }
        if (StringUtils.isEmpty((String)(dataCollectNumber = condition.getDataCollectNumber()))) {
            dataCollectNumber = "ACTUALDATA";
        }
        querySql.append(" AND t1.FDataCollectNumber = '").append(dataCollectNumber).append("' ");
        this.constructWhere(querySql, condition, exCondition, 4);
        querySql.append(" order by t5.fnumber,t6.fnumber,t7.fnumber\t\t\t\t\n");
        querySql.append(" ,FDatasource,FPeriodtype,fyear,fperiod,fvaluetype\t\t\n");
        querySql.append(" ,t8.fnumber,t3.fkeynumber\t\t\t\t\t\t\t\t\n");
        querySql.append(condition.isQueryHisBudget() ? ") dd" : "");
        return DbUtil.executeQuery((Context)ctx, (String)querySql.getSQL(), (Object[])querySql.getParams());
    }

    private IRowSet getElimDynamicItemData(Context ctx, ItemDataCondition condition, Map exCondition) throws BOSException {
        String dataCollectNumber;
        String lang = ctx.getLocale().getLanguage();
        boolean isQueryHisBudget = condition.isQueryHisBudget();
        String elimTabName = QueryHisBudgetUtils.getElimTabName((boolean)isQueryHisBudget);
        String elimEntryTabName = QueryHisBudgetUtils.getElimEntryTabName((boolean)isQueryHisBudget);
        String elimDynaEntryTabName = QueryHisBudgetUtils.getElimDynaEntryTabName((boolean)isQueryHisBudget);
        Integer integer = (Integer)exCondition.get("maxReturnRowCount");
        String top = "";
        if (integer != null) {
            top = " top " + integer;
        }
        SQLBuilder querySql = new SQLBuilder();
        querySql.append("select");
        querySql.append(isQueryHisBudget ? " distinct " : "");
        querySql.append(top);
        querySql.append(" t4.fnumber orgTreeNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t4.fname_").append(lang).append(" orgTreeName\t\t\t\n");
        querySql.append(",t5.fnumber orgUnitNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t5.fname_").append(lang).append(" orgUnitName\t\t\t\n");
        querySql.append(",t6.fnumber currencyNumber \n");
        querySql.append(",t6.fname_").append(lang).append(" currencyName\t\t\n");
        querySql.append(",t7.fnumber targetCurrencyNumber \n");
        querySql.append(",t7.fname_").append(lang).append(" targetCurrencyName\t\n");
        querySql.append(",t1.fdatasource+9 as fdatasource,t1.fperiodtype\t\t\n");
        querySql.append(",t1.fyear,t1.fperiod,t1.fvaluetype\t\t\t\t\t\t\n");
        querySql.append(",t8.fnumber itemNumber\t\t\t\t\t\t\t\t\t\n");
        querySql.append(",t8.fname_").append(lang).append(" itemName\t\t\t\n");
        querySql.append(",t9.fnumber dataElementNumber\t\t\t\t\t\t\t\n");
        querySql.append(",t9.fname_").append(lang).append(" dataElementName\t\t\n");
        querySql.append(",t10.fnumber dyItemNumber\t\t\t\t\t\t\t\t\n");
        querySql.append(",t10.fname_").append(lang).append(" dyItemName\t\t\t\n");
        querySql.append(",t3.fkeyLongNumber as fkeynumber,t3.fkeyname\t\t\t\n");
        querySql.append(",t3.FValue*(1-t8.FDc) CREDIT,t3.FValue*t8.FDc DEBIT\t\n");
        querySql.append(",null as ftextvalue,0 as FDataType\t\t\t\t\t\t\n");
        querySql.append(",t1.FNumber,t2.FSeq                                    \n");
        querySql.append(",t11.FNAME_" + ctx.getLocale() + " DataCollectName,t11.FNAME_L3 DataCollectNameL3 \n");
        querySql.append(", t2.FDataElement as DataElementSeq \n");
        querySql.append(" from ").append(elimTabName).append(" t1\t\t\t\t\t\t\t\t\n");
        querySql.append(" inner join ").append(elimEntryTabName).append(" t2\t\t\t\t\t\n");
        querySql.append(" on t1.fid=t2.FEliminationID\t\t\t\t\t\t\t\n");
        querySql.append(" inner join ").append(elimDynaEntryTabName).append(" t3\t\t\t\t\t\n");
        querySql.append(" on t2.fid=t3.FEliminationEntryID\t\t\t\t\t\t\n");
        querySql.append(" inner join T_ORG_Tree t4 ON t1.FOrgBoundID = t4.FID\t\n");
        querySql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnit = t5.FID\t\n");
        querySql.append(" INNER JOIN T_BD_Currency t6 ON t1.FSourceCurrencyID = t6.FID\n");
        querySql.append(" INNER JOIN T_BD_Currency t7 ON t1.FCurrencyID = t7.FID\n");
        querySql.append(" INNER JOIN T_CSL_RptItem t8 ON t2.FItemID = t8.FID\t\n");
        querySql.append(" INNER JOIN T_CSL_DataElement t9\t\t\t\t\t\t\n");
        querySql.append(" ON t2.FDataElement = t9.FInterSeq \t\t\t\t\t\n");
        querySql.append(" INNER JOIN T_CSL_RptItem t10 ON t3.FRptItemID = t10.FID\t\n");
        querySql.append(" INNER JOIN T_CSL_DataCollect t11  ON t1.FDataCollectNumber = t11.FNumber   \n");
        if (!condition.isIncludeUnAuditElim()) {
            querySql.append(" WHERE t1.FCheckedStatus = ").append((Object)2).append("\n");
        }
        if (StringUtils.isEmpty((String)(dataCollectNumber = condition.getDataCollectNumber()))) {
            dataCollectNumber = "ACTUALDATA";
        }
        querySql.append(" AND t1.FDataCollectNumber = '").append(dataCollectNumber).append("' ");
        this.constructWhere(querySql, condition, exCondition, 3);
        querySql.append(" order by t5.fnumber,t6.fnumber, t7.fnumber\t\t\t\n");
        querySql.append(" ,FDatasource,FPeriodtype,fyear,fperiod,fvaluetype\t\t\n");
        querySql.append(" ,t8.fnumber,t3.fkeynumber\t\t\t\t\t\t\t\t\n");
        return DbUtil.executeQuery((Context)ctx, (String)querySql.getSQL(), (Object[])querySql.getParams());
    }

    @Override
    protected Object _getDyItemDataByNumber(Context ctx, String orgBoundNumber, String orgUnitNumber, String sourceCurrencyNumber, String currencyNumber, String itemNumber, String dyItemNumber, int iYear, int iStartPeriod, int iEndPeriod, int iPeriodType, int iDataSource, int iDataElement, int iValueType, int iCommitStatus, boolean isAdjusted, String dataCollectNumber) throws BOSException, EASBizException {
        Object bgResult = null;
        Map mapOrgTree = null;
        PeriodCollection fiscalPeriods = null;
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)ctx);
        boolean isSupport13Period = CslRptUtil.isSupport13Period((Context)ctx);
        String[] dynaItemTables = CslRptUtil.getDyItemTables((Context)ctx, (int)iYear, (int)iStartPeriod, (int)iYear, (int)iEndPeriod);
        if (isMergeByFiscalPeriod) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setNumber(orgBoundNumber);
            fiscalPeriods = FiscalPeriodHelper.getPeriodCollection((Context)ctx, (OrgTreeInfo)orgTree);
        }
        if (iValueType == 3) {
            mapOrgTree = FiscalPeriodHelper.getOrgTreeByPeriods((Context)ctx, (PeriodCollection)fiscalPeriods, (String)orgBoundNumber, (int)iYear, (int)iYear, (int)iStartPeriod, (int)iEndPeriod, (int)iPeriodType, (boolean)isMergeByFiscalPeriod, (boolean)isSupport13Period);
            Set set = mapOrgTree.keySet();
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String strOrgTreeID = ite.next().toString();
                Map mapPeriod = (Map)mapOrgTree.get(strOrgTreeID);
                bgResult = this.getDyItemDataForTxt(ctx, dynaItemTables, strOrgTreeID, orgUnitNumber, sourceCurrencyNumber, currencyNumber, itemNumber, dyItemNumber, (Integer)mapPeriod.get("KEY_STARTYEAR"), (Integer)mapPeriod.get("KEY_STARTPERIOD"), (Integer)mapPeriod.get("KEY_ENDPERIOD"), iPeriodType, iDataSource, iDataElement, iValueType, iCommitStatus);
            }
            return bgResult;
        }
        if (isAdjusted) {
            if (StringUtils.isEmpty((String)dataCollectNumber)) {
                dataCollectNumber = "ACTUALDATA";
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append("select sum(t2.FValue) as FValue").append("\r\n");
            querySql.append("from ").append(dynaItemTables[0]).append(" t1").append("\r\n");
            querySql.append("inner join ").append(dynaItemTables[1]).append(" t2").append("\r\n");
            querySql.append("on t1.FID=t2.fitemdataid").append("\r\n");
            querySql.append("inner join T_Org_BaseUnit orgUnit").append("\r\n");
            querySql.append("on t1.FOrgUnitID=orgUnit.FID").append("\r\n");
            querySql.append("inner join T_BD_Currency sourceCurrency").append("\r\n");
            querySql.append("on t1.FSourceCurrencyID=sourceCurrency.FID").append("\r\n");
            querySql.append("inner join T_BD_Currency currency").append("\r\n");
            querySql.append("on t1.FCurrencyID=currency.FID").append("\r\n");
            querySql.append("join t_csl_rptreceived rec on rec.freportid=t1.freportid").append("\r\n");
            querySql.append("join t_org_tree tree on tree.fid=rec.forgtreeid").append("\r\n");
            querySql.append("where orgUnit.FNumber = ?").append("\r\n");
            if (sourceCurrencyNumber.length() != 0) {
                querySql.append("and sourceCurrency.FNumber = ?").append("\r\n");
            }
            querySql.append("and Currency.FNumber = ?").append("\r\n");
            querySql.append("and t2.FItemID = ?").append("\r\n");
            if (dyItemNumber.length() != 0) {
                querySql.append("and t2.FKeyNumber = ?").append("\r\n");
            }
            querySql.append("and t1.FPeriodType = ?").append("\r\n");
            querySql.append("and t2.FYear = ?").append("\r\n");
            querySql.append("and t2.FPeriod >= ?").append("\r\n");
            querySql.append("and t2.FPeriod <= ?").append("\r\n");
            querySql.append("and t1.FDataSource = ? ").append("\r\n");
            querySql.append("and t2.FDataElement = ?").append("\r\n");
            querySql.append("and t2.FValueType = ?").append("\r\n");
            querySql.append("and t1.fdatatype = ?").append("\r\n");
            querySql.append("and t1.fdataCollectNumber = ?").append("\r\n");
            querySql.append(" and tree.fnumber=?").append("\r\n");
            if (StringUtils.isEmpty((String)dyItemNumber)) {
                querySql.append("and t2.FGradeIsleaf = ? \n");
            }
            ArrayList<Object> params = new ArrayList<Object>(12);
            params.add(orgUnitNumber);
            if (sourceCurrencyNumber.length() != 0) {
                params.add(sourceCurrencyNumber);
            }
            params.add(currencyNumber);
            params.add(itemNumber);
            if (dyItemNumber.length() != 0) {
                params.add(dyItemNumber);
            }
            params.add(new Integer(iPeriodType));
            params.add(new Integer(iYear));
            params.add(new Integer(iStartPeriod));
            params.add(new Integer(iEndPeriod));
            params.add(new Integer(iDataSource));
            params.add(new Integer(iDataElement));
            params.add(new Integer(iValueType));
            params.add(new Integer(2));
            params.add(dataCollectNumber);
            params.add(orgBoundNumber);
            if (StringUtils.isEmpty((String)dyItemNumber)) {
                params.add(new Integer(1));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
            try {
                if (rs.next()) {
                    bgResult = rs.getBigDecimal(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (bgResult == null) {
            mapOrgTree = FiscalPeriodHelper.getOrgTreeByPeriods((Context)ctx, (PeriodCollection)fiscalPeriods, (String)orgBoundNumber, (int)iYear, (int)iYear, (int)iStartPeriod, (int)iEndPeriod, (int)iPeriodType, (boolean)isMergeByFiscalPeriod, (boolean)isSupport13Period);
            bgResult = this.getDyItemData(ctx, dynaItemTables, mapOrgTree, orgUnitNumber, sourceCurrencyNumber, currencyNumber, itemNumber, dyItemNumber, iPeriodType, iDataSource, iDataElement, iValueType, iCommitStatus, isAdjusted, dataCollectNumber);
        }
        return bgResult;
    }

    @Override
    protected BigDecimal _getDynamicAdjustingValue(Context ctx, ItemDataCondition condition, String dyItemNumber) throws BOSException {
        BigDecimal value = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append("Select sum(t3.fvalue) FValue").append("\r\n");
        querySql.append("From T_CSL_Adjust t1").append("\r\n");
        querySql.append("inner join T_CSL_AdjustEntry t2 on t1.FID = t2.fadjustid").append("\r\n");
        querySql.append("inner join t_Csl_AdjustDynamicItem t3 on t2.FID = t3.FAdjustEntryID ").append("\r\n");
        querySql.append("inner join T_CSL_RptItem rptItem on t3.FRptItemID = rptItem.FID ").append("\r\n");
        querySql.append("inner join T_ORG_Tree tree on tree.FID = t1.FOrgBoundID ").append("\r\n");
        querySql.append("inner join T_ORG_BaseUnit unit on unit.FID = t1.FOrgUnit ").append("\r\n");
        querySql.append("where t1.FCheckedStatus = ?").append("\r\n");
        querySql.append("and tree.FNumber = ?").append("\r\n");
        querySql.append("and unit.FNumber = ?").append("\r\n");
        querySql.append("and t1.FSourceCurrencyID = ?").append("\r\n");
        querySql.append("and t1.FCurrencyID = ?").append("\r\n");
        querySql.append("and t1.FDataSource = ?").append("\r\n");
        querySql.append("and t1.FValueType = ?").append("\r\n");
        querySql.append("and rptItem.FNumber = ?").append("\r\n");
        querySql.append("and t2.FDataElement = ?").append("\r\n");
        querySql.append("and t3.FKeyLongNumber = ?").append("\r\n");
        querySql.append(" and t1.FYear >= ? and t1.FYear <= ?\r\n");
        querySql.append(" and t1.FPeriod >= ? and t1.FPeriod <= ?\r\n");
        querySql.append(" and t1.FPeriodType = ?\r\n");
        querySql.append(" and t1.FDataCollectNumber = ?\r\n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Integer(2));
        params.add(condition.getOrgTreeNumber());
        params.add(condition.getOrgUnitNumber().get(0));
        params.add(condition.getCurrency());
        params.add(condition.getTargetCurrency());
        params.add(new Integer(condition.getDataSource() - 9));
        params.add(new Integer(condition.getValueType()));
        params.add(condition.getItemNumberStart());
        params.add(new Integer(condition.getDataElement()));
        params.add(dyItemNumber);
        params.add(new Integer(condition.getRptYearStart()));
        params.add(new Integer(condition.getRptYearEnd()));
        params.add(new Integer(condition.getRptPeriodStart()));
        params.add(new Integer(condition.getRptPeriodEnd()));
        params.add(new Integer(condition.getRptPeriodType()));
        params.add(condition.getDataCollectNumber());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                value = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (value == null) {
            value = new BigDecimal(0.0);
        }
        return value;
    }

    @Override
    protected List _getDynamicItemDataForVirtualQuery(Context ctx, ItemDataCondition condition, Map extCondition, String tempTableName, int firstRow, int length) throws BOSException, EASBizException {
        String sql = "Select FOrgTreeNumber,FOrgTreeName,FOrgUnitNumber,FOrgUnitName,FCurrencyName,FTargetCurrencyName,FDataSource,FPeriodType,FYear,FPeriod,FValueType,FItemNumber,FItemName,FDataElementNumber,FDataElementName,FDyItemNumber,FDyitemName,FAttribute,FKeyNumber,FKeyName,FDebit,FCredit,FTextValue,FCurrencyNumber,FTargetCurrencyNumber from " + tempTableName;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (int)firstRow, (int)length);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        try {
            while (rowSet.next()) {
                Object[] obj = new Object[25];
                for (int i = 0; i < 25; ++i) {
                    obj[i] = rowSet.getObject(i + 1);
                }
                result.add(obj);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected int _initTempararyTableForVirtualQuery(Context ctx, ItemDataCondition condition, Map extCondition, String tempTableName) throws BOSException, EASBizException {
        int n;
        DbUtil.execute((Context)ctx, (String)("delete from " + tempTableName));
        List datas = this._getDynamicItemData(ctx, condition, extCondition);
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            String sql = "insert into " + tempTableName + " (FOrgTreeNumber,FOrgTreeName,FOrgUnitNumber,FOrgUnitName,FCurrencyName,FTargetCurrencyName,FDataSource,FPeriodType,FYear,FPeriod,FValueType,FItemNumber,FItemName,FDataElementNumber,FDataElementName,FDyItemNumber,FDyitemName,FAttribute,FKeyNumber,FKeyName,FDebit,FCredit,FTextValue,FCurrencyNumber,FTargetCurrencyNumber) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            prepareStatement = connection.prepareStatement(sql);
            for (Object[] object : datas) {
                for (int i = 0; i < 25; ++i) {
                    prepareStatement.setObject(i + 1, object[i]);
                }
                prepareStatement.addBatch();
            }
            prepareStatement.executeBatch();
            n = datas.size();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, prepareStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
        return n;
    }

    @Override
    protected String _createTempTable(Context ctx, String tableName) throws BOSException {
        ITableManagerFacade tableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tempTableName = tableManager.getTableName(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(tempTableName).append(" (");
        sql.append(" FOrgTreeNumber NVARCHAR(80),      \t\t\n");
        sql.append(" FOrgTreeName   NVARCHAR(255),      \t\n");
        sql.append(" FOrgUnitNumber NVARCHAR(80),      \t\t\n");
        sql.append(" FOrgUnitName\tNVARCHAR(255),   \t\t\n");
        sql.append(" FCurrencyName  NVARCHAR(80),      \t\t\n");
        sql.append(" FTargetCurrencyName NVARCHAR(80),      \n");
        sql.append(" FDataSource    NVARCHAR(80),      \t\t\n");
        sql.append(" FPeriodType  \tNVARCHAR(80),      \t\t\n");
        sql.append(" FYear\t\t\t\t\tINT,      \t\t\n");
        sql.append(" FPeriod\t\t\t\tINT,      \t\t\n");
        sql.append(" FValueType\t\t\tNVARCHAR(80),     \t\n");
        sql.append(" FItemNumber    \tNVARCHAR(80),      \t\n");
        sql.append(" FItemName \t\tNVARCHAR(80),      \t\t\n");
        sql.append(" FDataElementNumber  NVARCHAR(80),      \n");
        sql.append(" FDataElementName\tNVARCHAR(255),      \n");
        sql.append(" FDyItemNumber\tNVARCHAR(80),      \t\t\n");
        sql.append(" FDyitemName\t\tNVARCHAR(255),      \n");
        sql.append(" FAttribute\t\t\tNVARCHAR(255),      \n");
        sql.append(" FKeyNumber \t\tNVARCHAR(500),      \n");
        sql.append(" FKeyName \t\tNVARCHAR(800),      \t\n");
        sql.append(" FDebit\t\t\tNUMERIC(21,6),      \t\n");
        sql.append(" FCredit \t\tNUMERIC(21,6),      \t\n");
        sql.append(" FTextValue      NVARCHAR(2000),    \t\n");
        sql.append(" FCurrencyNumber NVARCHAR(80),      \t\n");
        sql.append(" FTargetCurrencyNumber NVARCHAR(80)     \n");
        sql.append("  ) ");
        tableManager.createTempTable(sql.toString());
        return tempTableName;
    }

    private List link_MultiDynamic_SUM_cell(Context ctx, Map mapParams) throws BOSException, EASBizException, SQLDataException {
        IRowSet rs;
        FullOrgUnitInfo orgUnit;
        boolean isMultiCslRpt;
        ArrayList lstResult = new ArrayList();
        List asstHGAttributeList = null;
        RptSrcTypeEnum rptType = (RptSrcTypeEnum)mapParams.get("RptSrcType");
        boolean bl = isMultiCslRpt = rptType != null && RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)rptType);
        if (mapParams.containsKey("asstHGAttribute")) {
            asstHGAttributeList = (List)mapParams.get("asstHGAttribute");
            if (asstHGAttributeList == null || asstHGAttributeList.size() <= 0) {
                return lstResult;
            }
        } else {
            return lstResult;
        }
        Map asstActTypeMap = null;
        try {
            asstActTypeMap = DynamicTemplateUtility.getAsstActTypeMap(ctx, asstHGAttributeList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (asstActTypeMap == null || asstActTypeMap.size() <= 0) {
            return lstResult;
        }
        OrgTreeInfo orgTree = (OrgTreeInfo)OrgTreeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgTreeID")));
        ArrayList lstOrg = CslRptUtil.getCslOrgs((Context)ctx, (OrgTreeInfo)orgTree, (OrgUnitInfo)(orgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK((String)mapParams.get("OrgUnitID")))));
        if (lstOrg == null || lstOrg.size() <= 0) {
            return null;
        }
        String company_id = (String)mapParams.get("KEY_COMPANY_ID");
        String sheetId = (String)mapParams.get("Key_Active_SheetName");
        String reportIds = CslRptUtil.getRptIdsFromSumRptRela((Context)ctx, (String)((String)mapParams.get("KEY_REPORT_ID")), (String)sheetId);
        if (StringUtils.isEmpty((String)reportIds)) {
            throw new SumRptException(SumRptException.NOTFOUNDSUMRELA);
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        String strItemNumber = (String)mapParams.get("KEY_ITEM_NUMBER");
        int valueType = (Integer)mapParams.get("ValueType");
        String keyDynaNumber = (String)mapParams.get("KEY_DYNAITEM_NUMBER");
        Map tableAndWhere = this.getTableAndWhere(keyDynaNumber, asstActTypeMap);
        if (!tableAndWhere.containsKey("tables") || !tableAndWhere.containsKey("wheres") || StringUtils.isEmpty((String)((String)tableAndWhere.get("tables"))) || StringUtils.isEmpty((String)((String)tableAndWhere.get("wheres")))) {
            return lstResult;
        }
        if (valueType != 3) {
            strSql.append("select FName,sum(FValue) FValue").append("\r\n");
        } else {
            strSql.append("select FName,FValue").append("\r\n");
        }
        strSql.append(", unitId ");
        strSql.append(" from").append("\r\n");
        strSql.append(" (").append("\r\n");
        strSql.append(" select to_char(o.FName_").append(ctx.getLocale().toString()).append(") as FName,");
        if (valueType == 3) {
            strSql.append("b.FTextValue as FValue ");
        } else {
            strSql.append("b.FValue as FValue ");
        }
        strSql.append(",o.FID unitId ");
        strSql.append(" from T_Csl_MultiDynaItemData a,T_Csl_MultiDynaItemDataEntry b,T_Org_BaseUnit o,T_Csl_cslReport c,").append("T_CSL_CslRptAssistantHG hg ").append(tableAndWhere.get("tables")).append(" where a.FID=b.FItemDataID and a.FOrgUnitID=o.FID ").append(" and hg.fid=b.FCslRptAssistantHGId ").append(" and a.FreportID=c.FID ").append(tableAndWhere.get("wheres"));
        if (isMultiCslRpt) {
            strSql.append(" and (FDataSource = 13)   ");
            strSql.append(" and c.FCompanyID in(");
            strSql.append(CslRptUtil.expandCompanys((Context)ctx, (String)((String)mapParams.get("OrgTreeID")), (String)("'" + (mapParams.get("KEY_COMPANY_ID") == null ? (String)mapParams.get("OrgUnitID") : (String)mapParams.get("KEY_COMPANY_ID")) + "'"), (boolean)true)).append(")");
        } else {
            strSql.append(" and (FDataSource = 13 or FDataSource = 14)   ").append(" and (FCommitStatus = 3 or c.fsourcetype= 14) ").append(" and a.FReportID in (").append(reportIds).append(") ");
            if (!StringUtils.isEmpty((String)company_id)) {
                strSql.append(" and (c.FCompanyID = ? ");
                params.add(company_id);
                strSql.append(" or c.FOrgUnitID= ?) ");
                params.add(company_id);
            }
        }
        strSql.append(" and a.FCurrencyID=? ");
        params.add((String)mapParams.get("KEY_CURRENCY_ID"));
        strSql.append("and a.FPeriodType = ? ");
        params.add((String)mapParams.get("PeriodType"));
        strSql.append("and a.FYear=? ");
        params.add((String)mapParams.get("Year"));
        strSql.append("and a.FPeriod=? ");
        params.add((String)mapParams.get("Period"));
        strSql.append("and b.FItemID=? ");
        params.add((String)mapParams.get("KEY_ITEM_NUMBER"));
        strSql.append("and b.FDataElement=? ");
        params.add((String)mapParams.get("DataElement"));
        strSql.append(" and b.FValueType = ? ");
        params.add((String)mapParams.get("ValueType"));
        strSql.append(") as t").append("\r\n");
        if (valueType != 3) {
            strSql.append("group by FName,unitId");
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params.toArray())) == null) {
            return null;
        }
        int currencyScale = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK((String)mapParams.get("KEY_CURRENCY_ID"))).getPrecision();
        if (currencyScale == 0) {
            currencyScale = 2;
        }
        RPTItemInfo itemInfo = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemInfo("SELECT name WHERE number = '" + strItemNumber + "'");
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem", (Locale)ctx.getOriginLocale()) + ":  ");
        tempList.add(itemInfo.getName());
        lstResult.add(tempList);
        tempList.add("XXXID");
        tempList = new ArrayList();
        tempList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DataElement", (Locale)ctx.getOriginLocale()) + ":  ");
        tempList.add(DataElementProvider.getDataElementName((Context)ctx, (int)((Integer)mapParams.get("DataElement"))));
        tempList.add("XXXID");
        lstResult.add(tempList);
        try {
            BigDecimal value;
            ArrayList<Object> lstTemp;
            while (rs.next()) {
                if (lstResult == null) {
                    lstResult = new ArrayList();
                }
                lstTemp = new ArrayList<Object>();
                lstTemp.add(rs.getString("FName"));
                if (valueType == 3) {
                    lstTemp.add(rs.getString(2));
                } else {
                    value = new BigDecimal(rs.getString("FValue"));
                    value = value.setScale(currencyScale, 4);
                    lstTemp.add(value);
                }
                lstTemp.add(rs.getString("unitId"));
                lstResult.add(lstTemp);
            }
            if (isMultiCslRpt && (rs = this.getMultiCslElimCellVal(ctx, mapParams, asstActTypeMap)) != null) {
                while (rs.next()) {
                    if (lstResult == null) {
                        lstResult = new ArrayList();
                    }
                    lstTemp = new ArrayList();
                    lstTemp.add(rs.getString(1));
                    if (valueType == 3) {
                        lstTemp.add(rs.getString(2));
                    } else {
                        value = new BigDecimal(rs.getString(2));
                        value = value.setScale(currencyScale, 4);
                        lstTemp.add(value);
                    }
                    lstTemp.add(rs.getString("unitId"));
                    lstResult.add(lstTemp);
                }
            }
            if (lstResult.size() > 3) {
                SQLBuilder sql = new SQLBuilder(50);
                HashSet IDs = new HashSet(lstResult.size() - 1);
                int size = lstResult.size();
                for (int i = 1; i < size; ++i) {
                    IDs.add(((List)lstResult.get(i)).get(2));
                }
                sql.append(" select s.funitid unitId,s.flongnumber longnumber from \n").append(" t_org_Structure s ").append(" where s.ftreeId = ? ", mapParams.get("OrgTreeID")).append(" and s.funitId in ", IDs);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                final HashMap<String, String> map = new HashMap<String, String>();
                if (rs != null && rs.size() > 0) {
                    while (rs.next()) {
                        map.put(rs.getString("unitId"), rs.getString("longnumber"));
                    }
                    Collections.sort(lstResult, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            List lst1 = (List)o1;
                            List lst2 = (List)o2;
                            String id1 = (String)lst1.get(2);
                            String id2 = (String)lst2.get(2);
                            String longnumber1 = (String)map.get(id1);
                            String longnumber2 = (String)map.get(id2);
                            if (longnumber1 == null && longnumber2 == null) {
                                return 0;
                            }
                            if (longnumber1 == null) {
                                return -1;
                            }
                            if (longnumber2 == null) {
                                return 1;
                            }
                            return longnumber1.compareTo(longnumber2);
                        }
                    });
                }
            }
            return lstResult;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private IRowSet getMultiCslElimCellVal(Context ctx, Map mapParams, Map asstActTypeMap) throws BOSException, EASBizException {
        IRowSet rs = null;
        ArrayList params = new ArrayList();
        int valueType = (Integer)mapParams.get("ValueType");
        String keyDynaNumber = (String)mapParams.get("KEY_DYNAITEM_NUMBER");
        Map tableAndWhere = this.getTableAndWhereNew(keyDynaNumber, asstActTypeMap);
        SQLBuilder strSql = new SQLBuilder();
        String elimDataStr = ElimReportUtils.getResource4Server((String)"ElimData", (Context)ctx);
        elimDataStr = "'(" + elimDataStr + ")'";
        if (valueType != 3) {
            strSql.append("select FName||").append(elimDataStr).append(",sum(FValue)*(-1) FValue").append("\r\n");
        } else {
            strSql.append("select FName||").append(elimDataStr).append(",FValue").append("\r\n");
        }
        strSql.append(" ,unitId ");
        strSql.append("from").append("\r\n");
        strSql.append("(").append("\r\n");
        strSql.append("select to_char(o.FName_").append(ctx.getLocale().toString()).append(") as FName,");
        if (valueType == 3) {
            strSql.append("b.FTextValue as FValue ");
        } else {
            strSql.append("b.FValue as FValue ");
        }
        strSql.append(" ,o.FID unitId ");
        strSql.append(" from T_Csl_MultiDynaItemData a").append(" join T_Csl_MultiDynaItemDataEntry b on a.FID=b.FItemDataID \n").append(" join T_Org_BaseUnit o on a.FOrgUnitID=o.FID \n").append(" join T_Csl_cslReport c on a.FreportID=c.FID \n").append(" join T_CSL_CslRptAssistantHG hg on hg.fid=b.FCslRptAssistantHGId \n").append(" left join T_ORG_BaseUnit detailComp on   b.FDetailCompanyId = detailComp.FID \n").append(tableAndWhere.get("join").toString()).append(" where   ").append(" FDataSource = 45 ").append(tableAndWhere.get("wheres").toString());
        strSql.append(" and a.FCurrencyID=? ", mapParams.get("KEY_CURRENCY_ID"));
        strSql.append(" and c.ForgTreeId = ? ", mapParams.get("OrgTreeID"));
        strSql.append(" and c.ForgUnitId in(").append(CslRptUtil.expandCompanys((Context)ctx, (String)((String)mapParams.get("OrgTreeID")), (String)("'" + (String)mapParams.get("OrgUnitID") + "'"), (boolean)false)).append(")");
        strSql.append(" and a.FPeriodType = ? ", mapParams.get("PeriodType"));
        strSql.append(" and a.FYear=? ", mapParams.get("Year"));
        strSql.append(" and a.FPeriod=? ", mapParams.get("Period"));
        strSql.append(" and b.FItemID=? ", mapParams.get("KEY_ITEM_NUMBER"));
        strSql.append(" and b.FDataElement=? ", mapParams.get("DataElement"));
        strSql.append(" and b.FValueType = ? ", mapParams.get("ValueType"));
        strSql.append(" and b.FDetailCompanyId in(").append(CslRptUtil.expandCompanys((Context)ctx, (String)((String)mapParams.get("OrgTreeID")), (String)("'" + (mapParams.get("KEY_COMPANY_ID") == null ? (String)mapParams.get("OrgUnitID") : (String)mapParams.get("KEY_COMPANY_ID")) + "'"), (boolean)true)).append(")");
        strSql.append(") as t").append("\r\n");
        if (valueType != 3) {
            strSql.append("group by FName,unitID");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])strSql.getParams());
        return rs;
    }

    private Map getTableAndWhere(String keyNumber, Map AsstActTypeMap) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)keyNumber)) {
            AsstActTypeInfo asstActTypeInfo = null;
            String asstActType = null;
            String number = null;
            String numberOrLongNumber = null;
            StringBuffer tables = new StringBuffer();
            StringBuffer wheres = new StringBuffer();
            String[] asstActTypes = keyNumber.split(";");
            for (int i = 0; i < asstActTypes.length; ++i) {
                String[] temp;
                if (StringUtils.isEmpty((String)asstActTypes[i]) || (temp = asstActTypes[i].split("\\|")).length != 2) continue;
                asstActType = temp[0];
                number = temp[1];
                if (!AsstActTypeMap.containsKey(asstActType)) continue;
                asstActTypeInfo = (AsstActTypeInfo)AsstActTypeMap.get(asstActType);
                numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                tables.append(",").append(asstActTypeInfo.getRealtionDataObject());
                tables.append(" asstActType").append(asstActTypeInfo.getNumber());
                wheres.append(" and hg.").append(asstActTypeInfo.getMappingFieldName());
                wheres.append("=asstActType").append(asstActTypeInfo.getNumber()).append(".fid");
                wheres.append(" and asstActType").append(asstActTypeInfo.getNumber()).append(numberOrLongNumber);
                wheres.append("='").append(number).append("'");
            }
            result.put("tables", tables.toString());
            result.put("wheres", wheres.toString());
        }
        return result;
    }

    private Map getTableAndWhereNew(String keyNumber, Map AsstActTypeMap) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)keyNumber)) {
            AsstActTypeInfo asstActTypeInfo = null;
            String asstActType = null;
            String number = null;
            String numberOrLongNumber = null;
            StringBuffer join = new StringBuffer();
            StringBuffer wheres = new StringBuffer();
            String[] asstActTypes = keyNumber.split(";");
            for (int i = 0; i < asstActTypes.length; ++i) {
                String[] temp;
                if (StringUtils.isEmpty((String)asstActTypes[i]) || (temp = asstActTypes[i].split("\\|")).length != 2) continue;
                asstActType = temp[0];
                number = temp[1];
                if (!AsstActTypeMap.containsKey(asstActType)) continue;
                asstActTypeInfo = (AsstActTypeInfo)AsstActTypeMap.get(asstActType);
                numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? ".FLongNumber" : ".FNumber";
                join.append(" join ").append(asstActTypeInfo.getRealtionDataObject());
                join.append(" asstActType").append(asstActTypeInfo.getNumber());
                join.append(" on hg.").append(asstActTypeInfo.getMappingFieldName());
                join.append(" =asstActType").append(asstActTypeInfo.getNumber()).append(".fid");
                wheres.append(" and asstActType").append(asstActTypeInfo.getNumber()).append(numberOrLongNumber);
                wheres.append("='").append(number).append("'");
            }
            result.put("join", join.toString());
            result.put("wheres", wheres.toString());
        }
        return result;
    }

    private String get13PeriodFilter(Map extConditions, String periodColName) {
        StringBuffer sb = new StringBuffer();
        if (extConditions.containsKey("period")) {
            sb.append(" and ").append(periodColName).append("=").append(extConditions.get("period"));
        } else {
            if (extConditions.containsKey("query13Period") && "N".equals((String)extConditions.get("query13Period"))) {
                sb.append(" and ").append(periodColName).append("!=13 ");
            }
            if (extConditions.containsKey("query12Period") && "N".equals((String)extConditions.get("query12Period"))) {
                sb.append(" and ").append(periodColName).append("!=12 ");
            }
        }
        return sb.toString();
    }
}

