/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.dynainnerexch;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.CompanyCheckHandler;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.SheetAxisHelper;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynaInnerExchChecker {
    private Book book;
    private String treeId;
    private Map<String, List<Range>> checkMap = null;

    public DynaInnerExchChecker(Book book, String treeId) {
        this.book = book;
        this.treeId = treeId;
    }

    public void check() throws Exception {
        Map<String, Set<Object>> resultMap = this.collectCompanyAndCheckIt();
        this.checkMap = this.markNotExistCompany(resultMap);
    }

    private Map<String, List<Range>> markNotExistCompany(Map<String, Set<Object>> resultMap) {
        HashMap<String, List<Range>> checkMap = new HashMap<String, List<Range>>();
        Set<Object> selfCompanySet = resultMap.get("selfCompany");
        Set<Object> targCompanySet = resultMap.get("targCompany");
        if (!(selfCompanySet != null && selfCompanySet.size() != 0 || targCompanySet != null && targCompanySet.size() != 0)) {
            return checkMap;
        }
        int sheetCount = this.book.getSheetCount();
        Sheet sheet = null;
        ArrayList basePointList = null;
        DynaParameters param = null;
        Point p = null;
        Range selfRange = null;
        Range targRange = null;
        DynaRptBasePointIndexHandle indexHandle = null;
        int boforeSumFormulaCount = 0;
        for (int i = 0; i < sheetCount; ++i) {
            sheet = this.book.getSheet(i);
            basePointList = DynamicTemplateUtility.getBasePointList(sheet);
            for (int k = 0; k < basePointList.size(); ++k) {
                p = (Point)basePointList.get(k);
                param = DynamicTemplateUtility.getDynaParameters(sheet, p);
                int spreadStyle = param.getSpreadStyle();
                SheetAxisHelper axisHelper = new SheetAxisHelper(spreadStyle, p, boforeSumFormulaCount = (indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true)).getBeforeDynaItemSumRangeCount());
                if (!axisHelper.willBeContinue()) continue;
                int rowCount = axisHelper.getBegin() + param.getDefaultCounter();
                for (int rowIndex = axisHelper.getBegin() + 1; rowIndex < rowCount; ++rowIndex) {
                    List<Range> l;
                    selfRange = sheet.getRange(axisHelper.getSelfCompanyRowInx(rowIndex), axisHelper.getSelfCompanyColInx(rowIndex));
                    String selfCompanyName = selfRange.getText();
                    targRange = sheet.getRange(axisHelper.getTargCompanyRowInx(rowIndex), axisHelper.getTargCompanyColInx(rowIndex));
                    String targCompanyName = targRange.getText();
                    targCompanyName = CompanyCheckHandler.decodeCompanyName(targCompanyName);
                    if (StringUtils.isEmpty((String)selfCompanyName) && StringUtils.isEmpty((String)targCompanyName)) continue;
                    if (StringUtils.isEmpty((String)selfCompanyName) || selfCompanySet != null && selfCompanySet.contains(selfCompanyName)) {
                        l = (ArrayList)checkMap.get(sheet.getSheetName());
                        if (l == null) {
                            l = new ArrayList();
                            checkMap.put(sheet.getSheetName(), l);
                        }
                        selfRange.setUserObject("SELFPOINT", (Object)TableToolkit.xy2range((int)axisHelper.getSelfCompanyColInx(rowIndex), (int)axisHelper.getSelfCompanyRowInx(rowIndex)));
                        selfRange.setUserObject("SELFTXT", (Object)selfCompanyName);
                        l.add(selfRange);
                    }
                    if (targCompanySet == null || !targCompanySet.contains(targCompanyName)) continue;
                    l = (List)checkMap.get(sheet.getSheetName());
                    if (l == null) {
                        l = new ArrayList();
                        checkMap.put(sheet.getSheetName(), l);
                    }
                    targRange.setUserObject("TARGPOINT", (Object)TableToolkit.xy2range((int)axisHelper.getTargCompanyColInx(rowIndex), (int)axisHelper.getTargCompanyRowInx(rowIndex)));
                    targRange.setUserObject("TARGTXT", (Object)targCompanyName);
                    l.add(targRange);
                }
            }
        }
        return checkMap;
    }

    private Map<String, Set<Object>> collectCompanyAndCheckIt() throws Exception {
        int sheetCount = this.book.getSheetCount();
        Sheet sheet = null;
        ArrayList basePointList = null;
        DynaParameters param = null;
        Point p = null;
        Range selfRange = null;
        Range targRange = null;
        CompanyCheckHandler handler = CompanyCheckHandler.getInstance();
        DynaRptBasePointIndexHandle indexHandle = null;
        int boforeSumFormulaCount = 0;
        for (int i = 0; i < sheetCount; ++i) {
            sheet = this.book.getSheet(i);
            basePointList = DynamicTemplateUtility.getBasePointList(sheet);
            for (int k = 0; k < basePointList.size(); ++k) {
                p = (Point)basePointList.get(k);
                param = DynamicTemplateUtility.getDynaParameters(sheet, p);
                indexHandle = new DynaRptBasePointIndexHandle(param, p, sheet, true, true);
                boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
                int spreadStyle = param.getSpreadStyle();
                SheetAxisHelper axisHelper = new SheetAxisHelper(spreadStyle, p, boforeSumFormulaCount);
                if (!axisHelper.willBeContinue()) continue;
                int rowCount = axisHelper.getBegin() + param.getDefaultCounter();
                for (int rowIndex = axisHelper.getBegin() + 1; rowIndex < rowCount; ++rowIndex) {
                    selfRange = sheet.getRange(axisHelper.getSelfCompanyRowInx(rowIndex), axisHelper.getSelfCompanyColInx(rowIndex));
                    String selfCompanyName = selfRange.getText();
                    targRange = sheet.getRange(axisHelper.getTargCompanyRowInx(rowIndex), axisHelper.getTargCompanyColInx(rowIndex));
                    String targCompanyName = targRange.getText();
                    if (StringUtils.isEmpty((String)selfCompanyName) && StringUtils.isEmpty((String)targCompanyName)) continue;
                    handler.add(selfCompanyName, targCompanyName);
                }
            }
        }
        return handler.checkExists(null, this.treeId);
    }

    public String translateToMessage() {
        if (this.checkMap == null || this.checkMap.size() == 0) {
            return null;
        }
        StringBuffer rich = new StringBuffer();
        String sheetName2 = null;
        List<Range> l = null;
        Range rang = null;
        Sheet sheet = null;
        SumcalcRange sumcalcRange = new SumcalcRange();
        String tips_Cell = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"tips_Cell");
        String tips_OwnerCompany = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"tips_OwnerCompany");
        String tips_TargCompany = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"tips_TargCompany");
        String tips_NotExist = EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"tips_NotExist");
        for (String sheetName2 : this.checkMap.keySet()) {
            sheet = this.book.getSheet(sheetName2.toString());
            sumcalcRange = new SumcalcRange();
            l = this.checkMap.get(sheetName2);
            rich.append("<font color=\"#000080\"><b>");
            rich.append((Object)sheetName2).append("</b></font><br>");
            for (int i = 0; i < l.size(); ++i) {
                rang = l.get(i);
                sumcalcRange.addCellBlock(rang.getBounds());
                Object point = rang.getUserObject("SELFPOINT");
                Object text = rang.getUserObject("SELFTXT");
                if (point != null && text != null) {
                    rich.append(tips_Cell).append("<a href=\"null,").append((Object)sheetName2).append(",").append(point).append("\">");
                    rich.append(point).append("</a>,").append(tips_OwnerCompany).append("\u3010");
                    rich.append(rang.getText()).append("\u3011").append(tips_NotExist).append("\u3002\n<br>");
                }
                point = rang.getUserObject("TARGPOINT");
                text = rang.getUserObject("TARGTXT");
                if (point != null && text != null) {
                    rich.append(tips_Cell).append("<a href=\"null,").append((Object)sheetName2).append(",").append(point).append("\">");
                    rich.append(point).append("</a>,").append(tips_TargCompany).append("\u3010");
                    rich.append(rang.getText()).append("\u3011").append(tips_NotExist).append("\u3002\n<br>");
                }
                rang.setUserObject("SELFPOINT", null);
                rang.setUserObject("SELFTXT", null);
                rang.setUserObject("TARGPOINT", null);
                rang.setUserObject("TARGTXT", null);
            }
            sheet.setUserObject("FormulaErrorCell", (Object)sumcalcRange);
            rich.append("<br>");
        }
        return rich.toString();
    }
}

