/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DynamicTemplateUtilityOld {
    public static ArrayList getBasePointList(KDTable table) {
        int i;
        int rowCount = table.getExpandedRowCount();
        int columnCount = table.getExpandedColumnCount();
        ArrayList<Point> list = new ArrayList<Point>();
        boolean isFindBasePosition = false;
        ICell c = null;
        Point firstPoint = null;
        for (i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                c = table.getCell(i, j);
                if (!DynamicTemplateUtilityOld.isBasePointCell(c)) continue;
                isFindBasePosition = true;
                firstPoint = new Point(j, i);
                list.add(firstPoint);
                break;
            }
            if (isFindBasePosition) break;
        }
        if (firstPoint != null) {
            for (i = firstPoint.x + 1; i < columnCount; ++i) {
                c = table.getCell(firstPoint.y, i);
                if (!DynamicTemplateUtilityOld.isBasePointCell(c)) continue;
                firstPoint = new Point(i, firstPoint.y);
                list.add(firstPoint);
            }
            for (int j = firstPoint.y + 1; j < rowCount; ++j) {
                c = table.getCell(j, firstPoint.x);
                if (!DynamicTemplateUtilityOld.isBasePointCell(c)) continue;
                firstPoint = new Point(firstPoint.x, j);
                list.add(firstPoint);
            }
        }
        return list;
    }

    public static boolean isDynaHeadItemCell(ICell cell) {
        RptCell rptCell = null;
        ItemFormula f = null;
        if (cell.getUserObject() instanceof RptCell) {
            rptCell = (RptCell)cell.getUserObject();
        }
        return rptCell != null && (f = rptCell.getItemFormula()) != null && !StringUtils.isEmpty((String)f.getFormula());
    }

    public static boolean isBasePointCell(ICell cell) {
        return DynamicTemplateUtilityOld.getDynaParametersFromCell(cell) != null;
    }

    public static DynaParameters getDynaParameters(KDTable table, Point basepoint) {
        return DynamicTemplateUtilityOld.getDynaParametersFromCell(table.getCell(basepoint.y, basepoint.x));
    }

    public static DynaParameters getDynaParametersFromCell(ICell cell) {
        RptCell rptCell = null;
        ItemFormula f = null;
        if (cell == null) {
            return null;
        }
        if (cell.getUserObject() instanceof RptCell) {
            rptCell = (RptCell)cell.getUserObject();
        }
        if (rptCell != null) {
            f = rptCell.getItemFormula();
            if (f == null) {
                return null;
            }
            String obj = f.getExt("DynaParameters");
            if (obj != null && obj instanceof String) {
                return DynaParameters.getInstanceFromString(obj);
            }
        }
        return null;
    }

    public static void saveParametersToCell(ICell curCell, DynaParameters parameters) {
        RptCell curRptCell;
        Object curCellObj = curCell.getUserObject();
        if (curCellObj != null && curCellObj instanceof RptCell) {
            curRptCell = (RptCell)curCellObj;
        } else {
            curRptCell = new RptCell(curCell);
            curCell.setUserObject((Object)curRptCell);
        }
        if (curRptCell.getItemFormula() == null) {
            curRptCell.setItemFormula(new ItemFormula());
        }
        curRptCell.getItemFormula().putExt("DynaParameters", parameters.toString());
    }

    public static Rectangle getRectangle(KDTable table, Point point) {
        DynaParameters parameters = DynamicTemplateUtilityOld.getDynaParametersFromCell(table.getCell(point.y, point.x));
        int headWidth = DynamicTemplateUtilityOld.getDynaHeadItemCount(table, point);
        int bodyHeight = parameters.getDefaultCounter();
        if (parameters.isIncludeSum()) {
            ++bodyHeight;
        }
        if (parameters.getSpreadStyle() == 0) {
            return new Rectangle(point.x, point.y, headWidth + 1, bodyHeight + 1);
        }
        if (parameters.getSpreadStyle() == 1) {
            return new Rectangle(point.x, point.y, bodyHeight + 1, headWidth + 1);
        }
        return null;
    }

    public static int getDynaHeadItemCount(KDTable table, Point point) {
        int result;
        block4: {
            int spreadStyle;
            ICell cell;
            block3: {
                DynaParameters parameters = DynamicTemplateUtilityOld.getDynaParametersFromCell(table.getCell(point.y, point.x));
                cell = null;
                if (parameters == null) {
                    return 0;
                }
                result = 0;
                spreadStyle = parameters.getSpreadStyle();
                if (spreadStyle != 0) break block3;
                for (int i = point.x; i < table.getExpandedColumnCount(); ++i) {
                    cell = table.getCell(point.y, i);
                    if (!DynamicTemplateUtilityOld.isDynaHeadItemCell(cell)) continue;
                    ++result;
                }
                break block4;
            }
            if (spreadStyle != 1) break block4;
            for (int i = point.y; i < table.getExpandedRowCount(); ++i) {
                cell = table.getCell(i, point.x);
                if (!DynamicTemplateUtilityOld.isDynaHeadItemCell(cell)) continue;
                ++result;
            }
        }
        return result;
    }

    public static ArrayList getDynaHeadItemList(KDTable table, Point point) throws EASBizException, BOSException {
        ArrayList<DynaHeadItem> list;
        block4: {
            int spreadStyle;
            ICell cell;
            block3: {
                DynaParameters parameters = DynamicTemplateUtilityOld.getDynaParametersFromCell(table.getCell(point.y, point.x));
                list = new ArrayList<DynaHeadItem>();
                cell = null;
                if (parameters == null) {
                    return list;
                }
                spreadStyle = parameters.getSpreadStyle();
                if (spreadStyle != 0) break block3;
                for (int i = point.x; i < table.getExpandedColumnCount(); ++i) {
                    cell = table.getCell(point.y, i);
                    if (!DynamicTemplateUtilityOld.isDynaHeadItemCell(cell)) continue;
                    list.add(DynaHeadItem.getInstanceFromFormula((ItemFormula)((RptCell)cell.getUserObject()).getItemFormula()));
                }
                break block4;
            }
            if (spreadStyle != 1) break block4;
            for (int i = point.y; i < table.getExpandedRowCount(); ++i) {
                cell = table.getCell(i, point.x);
                if (!DynamicTemplateUtilityOld.isDynaHeadItemCell(cell)) continue;
                list.add(DynaHeadItem.getInstanceFromFormula((ItemFormula)((RptCell)cell.getUserObject()).getItemFormula()));
            }
        }
        return list;
    }

    public static Point getBasePoint(KDTable table, Point point, ArrayList basePointList) {
        for (Point element : basePointList) {
            if (!DynamicTemplateUtilityOld.getRectangle(table, element).contains(point)) continue;
            return element;
        }
        return null;
    }

    public static Point getLastPoint(ArrayList basePointList) {
        int[] temp = new int[basePointList.size()];
        int max = 0;
        for (int i = 0; i < basePointList.size(); ++i) {
            Point point = (Point)basePointList.get(i);
            temp[i] = point.x + point.y;
            if (temp[i] <= max) continue;
            max = temp[i];
        }
        int index = Arrays.binarySearch(temp, max);
        return (Point)basePointList.get(index);
    }

    public static void main(String[] args) {
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(new Point(2, 3));
        list.add(new Point(2, 9));
        list.add(new Point(5, 9));
        list.add(new Point(5, 3));
    }

    public static void clearDynaTableFirst(List sheets) {
        RptSheet sheet = null;
        KDTable table = null;
        ICell cell = null;
        int n = sheets.size();
        for (int i = 0; i < n; ++i) {
            sheet = (RptSheet)sheets.get(i);
            if (sheet == null || (table = sheet.getTable()) == null) continue;
            int rowCount = table.getExpandedRowCount();
            int colCount = table.getExpandedColumnCount();
            ArrayList baseList = DynamicTemplateUtilityOld.getBasePointList(table);
            int m = baseList.size();
            for (int j = 0; j < m; ++j) {
                int col;
                int row;
                int k;
                boolean isLeftUp;
                Point basePoint = (Point)baseList.get(j);
                DynaParameters param = DynamicTemplateUtilityOld.getDynaParameters(table, basePoint);
                if (param == null) continue;
                boolean isHorizon = param.getSpreadStyle() == 1;
                boolean bl = isLeftUp = param.getPosition() == 1;
                if (param.getSumMethod().equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) continue;
                ArrayList<Integer> xList = new ArrayList<Integer>();
                ArrayList<Integer> yList = new ArrayList<Integer>();
                if (isHorizon) {
                    yList.add(new Integer(basePoint.y));
                } else {
                    xList.add(new Integer(basePoint.x));
                }
                int start = isHorizon ? basePoint.y + 1 : basePoint.x + 1;
                int end = isHorizon ? rowCount : colCount;
                for (k = start; k < end; ++k) {
                    row = isHorizon ? k : basePoint.y;
                    cell = table.getCell(row, col = isHorizon ? basePoint.x : k);
                    if (cell == null || DynamicTemplateUtilityOld.getFormula(cell) == null) continue;
                    if (isHorizon) {
                        yList.add(new Integer(k));
                        continue;
                    }
                    xList.add(new Integer(k));
                }
                start = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                end = isHorizon ? basePoint.x : basePoint.y;
                end += param.getDefaultCounter();
                if (param.isIncludeSum() && isLeftUp) {
                    ++start;
                    ++end;
                }
                for (k = start; k <= end; ++k) {
                    row = isHorizon ? basePoint.y : k;
                    cell = table.getCell(row, col = isHorizon ? k : basePoint.x);
                    if (cell == null || k == start && cell.getStyleAttributes().isLocked() || cell.getValue() == null) continue;
                    if (isHorizon) {
                        xList.add(new Integer(k));
                        continue;
                    }
                    yList.add(new Integer(k));
                }
                Integer xInt2 = null;
                Integer yInt2 = null;
                for (Integer xInt2 : xList) {
                    for (Integer yInt2 : yList) {
                        cell = table.getCell(yInt2.intValue(), xInt2.intValue());
                        if (cell == null) continue;
                        cell.setValue(null);
                        cell.setUserObject(null);
                        cell.setExpressions(null);
                        RptCell rptcell = RptCell.getRptCellWithoutUserObject((ICell)cell);
                        if (rptcell == null) continue;
                        rptcell.applyCellRender();
                    }
                }
            }
        }
    }

    public static void autoAdjustSum(KDTable table, Point basePoint, int actualSize) {
        int baseLine;
        DynaParameters param = DynamicTemplateUtilityOld.getDynaParameters(table, basePoint);
        if (param == null) {
            return;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        boolean isLeftUp = param.getPosition() == 1;
        int n = baseLine = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
        if (isLeftUp) {
            ++baseLine;
        }
        if (param.isIncludeSum()) {
            int sumLine = isHorizon ? (isLeftUp ? basePoint.x + 1 : basePoint.x + actualSize + 1) : (isLeftUp ? basePoint.y + 1 : basePoint.y + actualSize + 1);
            int start = isHorizon ? basePoint.y + 1 : basePoint.x + 1;
            int end = isHorizon ? table.getExpandedRowCount() : table.getExpandedColumnCount();
            for (int dot = start; dot < end; ++dot) {
                String cellEnd;
                String exp;
                int col;
                int row = isHorizon ? dot : sumLine;
                ICell cell = table.getCell(row, col = isHorizon ? sumLine : dot);
                if (cell == null || (exp = cell.getExpressions()) == null || !exp.matches("\\=sum\\(.+")) continue;
                String cellStart = isHorizon ? Location.getCellName((int)dot, (int)baseLine) : Location.getCellName((int)baseLine, (int)dot);
                String string = cellEnd = isHorizon ? Location.getCellName((int)dot, (int)(baseLine + actualSize - 1)) : Location.getCellName((int)(baseLine + actualSize - 1), (int)dot);
                if (actualSize == 0) {
                    cell.setExpressions(null);
                    continue;
                }
                cell.setExpressions("=sum(" + cellStart + ":" + cellEnd + ")");
            }
        }
    }

    private static boolean beforeRowColEdit(KDTable table, int index, boolean isRow, boolean isInsert) {
        int minimum;
        boolean isLeftUp;
        ArrayList baseList = DynamicTemplateUtilityOld.getBasePointList(table);
        if (baseList == null || baseList.size() == 0) {
            return false;
        }
        Point basePoint = (Point)baseList.get(0);
        ICell cell = table.getCell(basePoint.y, basePoint.x);
        if (cell == null) {
            return false;
        }
        DynaParameters param = DynamicTemplateUtilityOld.getDynaParametersFromCell(cell);
        if (param == null) {
            return false;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        boolean bl = isLeftUp = param.getPosition() == 1;
        if (isHorizon == isRow) {
            return false;
        }
        boolean found = false;
        int n = minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
        if (index <= minimum) {
            return false;
        }
        for (int i = 0; i < baseList.size(); ++i) {
            if (baseList.size() > 0) {
                basePoint = (Point)baseList.get(i);
                cell = table.getCell(basePoint.y, basePoint.x);
                param = DynamicTemplateUtilityOld.getDynaParametersFromCell(cell);
                isLeftUp = param.getPosition() == 1;
                minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
            }
            int counter = param.getDefaultCounter();
            int maximum = minimum + counter - 1;
            int n2 = maximum = param.isIncludeSum() ? maximum + 1 : maximum;
            if (index < minimum || index > maximum) continue;
            if (isInsert) {
                if (isLeftUp && index == minimum) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"83_DynamicTemplateUtility"));
                    return true;
                }
            } else if (isLeftUp && index == minimum || !isLeftUp && index == maximum) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"84_DynamicTemplateUtility"));
                return true;
            }
            counter = isInsert ? counter + 1 : counter - 1;
            param.setDefaultCounter(counter);
            found = true;
            break;
        }
        if (found) {
            DynamicTemplateUtilityOld.saveParametersToCell(cell, param);
        }
        return false;
    }

    public static boolean beforeAddRow(KDTable table, int row) {
        return DynamicTemplateUtilityOld.beforeRowColEdit(table, row, true, true);
    }

    public static boolean beforeAddColumn(KDTable table, int col) {
        return DynamicTemplateUtilityOld.beforeRowColEdit(table, col, false, true);
    }

    public static boolean beforeDeleteRow(KDTable table, int row) {
        return DynamicTemplateUtilityOld.beforeRowColEdit(table, row, true, false);
    }

    public static boolean beforeDeleteColumn(KDTable table, int col) {
        return DynamicTemplateUtilityOld.beforeRowColEdit(table, col, false, false);
    }

    public static void autoAdjustPasteRange(KDTable table, int rowStart, int colStart, int rowEnd, int colEnd) {
        ArrayList baseList = DynamicTemplateUtilityOld.getBasePointList(table);
        if (baseList == null || baseList.size() == 0) {
            return;
        }
        Point basePoint = (Point)baseList.get(0);
        if (basePoint == null) {
            return;
        }
        ICell cell = table.getCell(basePoint.y, basePoint.x);
        if (cell == null) {
            return;
        }
        DynaParameters param = DynamicTemplateUtilityOld.getDynaParametersFromCell(cell);
        if (param == null) {
            return;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        Object[] baseArray = baseList.toArray();
        if (isHorizon) {
            Arrays.sort(baseArray, new PointXComparator());
        } else {
            Arrays.sort(baseArray, new PointXComparator());
        }
        for (int i = baseList.size() - 1; i >= 0; --i) {
            int indexForwardEnd;
            int indexItem;
            basePoint = (Point)baseList.get(i);
            int indexSideStart = isHorizon ? rowStart : colStart;
            int indexSideEnd = isHorizon ? rowEnd : colEnd;
            int n = indexItem = isHorizon ? basePoint.y : basePoint.x;
            if (indexItem < indexSideStart && indexItem > indexSideEnd) continue;
            cell = table.getCell(basePoint.y, basePoint.x);
            param = DynamicTemplateUtilityOld.getDynaParametersFromCell(cell);
            boolean isIncludeSum = param.isIncludeSum();
            boolean isLeftUp = param.getPosition() == 1;
            int minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
            minimum = isIncludeSum && isLeftUp ? minimum + 1 : minimum;
            int maximum = minimum + param.getDefaultCounter() - 1;
            int indexForwardStart = isHorizon ? colStart : rowStart;
            int n2 = indexForwardEnd = isHorizon ? colEnd : rowEnd;
            if (indexForwardStart < minimum || indexForwardStart > maximum) continue;
            if (indexForwardEnd < maximum - 1) break;
            int diff = indexForwardEnd - maximum + 1;
            for (int j = 0; j < diff; ++j) {
                if (isHorizon) {
                    table.addColumn(maximum + 1);
                    continue;
                }
                table.addRow(maximum + 1);
            }
            param.setDefaultCounter(param.getDefaultCounter() + diff);
            DynamicTemplateUtilityOld.saveParametersToCell(cell, param);
            DynamicTemplateUtilityOld.autoAdjustSum(table, basePoint, param.getDefaultCounter());
            break;
        }
    }

    public static void regrade(KDTable table, int site, boolean isDelRow) {
        block34: {
            int i;
            int spreadStyle;
            int colCount;
            int rowCount;
            int top;
            int left;
            block33: {
                int i2;
                int i3;
                int minimum;
                boolean isHorizon;
                ArrayList baseList = DynamicTemplateUtilityOld.getBasePointList(table);
                if (baseList == null || baseList.size() == 0) {
                    return;
                }
                Point basePoint = (Point)baseList.get(0);
                ICell basecell = table.getCell(basePoint.y, basePoint.x);
                if (basecell == null) {
                    return;
                }
                DynaParameters param = DynamicTemplateUtilityOld.getDynaParametersFromCell(basecell);
                if (param == null) {
                    return;
                }
                boolean bl = isHorizon = param.getSpreadStyle() == 1;
                if (isHorizon == isDelRow) {
                    return;
                }
                int n = minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                if (site < minimum) {
                    return;
                }
                boolean found = false;
                for (int i4 = 0; i4 < baseList.size(); ++i4) {
                    if (i4 > 0) {
                        basePoint = (Point)baseList.get(i4);
                        basecell = table.getCell(basePoint.y, basePoint.x);
                        param = DynamicTemplateUtilityOld.getDynaParametersFromCell(basecell);
                        minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                    }
                    int counter = param.getDefaultCounter();
                    int maximum = minimum + counter - 1;
                    int n2 = maximum = param.isIncludeSum() ? maximum + 1 : maximum;
                    if (site < minimum || site > maximum) continue;
                    found = true;
                    break;
                }
                if (!found || !param.isGrade()) {
                    return;
                }
                left = basePoint.x;
                top = basePoint.y;
                rowCount = 0;
                colCount = 0;
                spreadStyle = param.getSpreadStyle();
                if (spreadStyle == 0) {
                    rowCount = param.getDefaultCounter() + 1;
                    colCount = DynamicTemplateUtilityOld.getColCount(table, top, left);
                    if (param.isIncludeSum()) {
                        ++rowCount;
                    }
                } else {
                    rowCount = DynamicTemplateUtilityOld.getRowCount(table, top, left);
                    colCount = param.getDefaultCounter() + 1;
                    if (param.isIncludeSum()) {
                        ++colCount;
                    }
                }
                if (baseList.size() > 1) {
                    for (i3 = 0; i3 < baseList.size(); ++i3) {
                        Point point = (Point)baseList.get(i3);
                        if (spreadStyle == 0) {
                            if (point.y <= top) continue;
                            rowCount = point.y - top;
                            break;
                        }
                        if (point.x <= left) continue;
                        colCount = point.x - left;
                        break;
                    }
                }
                for (i3 = top + 1; i3 < rowCount; ++i3) {
                    IRow row = table.getRow(i3);
                    for (int j = left + 1; j < colCount; ++j) {
                        ICell cell = row.getCell(j);
                        cell.setExpressions(null);
                    }
                }
                if (spreadStyle != 0) break block33;
                IRow toprow = table.getRow(top);
                int index = -1;
                for (i = left + 1; i < left + colCount; ++i) {
                    Object itemCellObj = toprow.getCell(i).getUserObject();
                    if (itemCellObj == null || !(itemCellObj instanceof RptCell)) continue;
                    index = i;
                    break;
                }
                if (index <= 0) break block34;
                ArrayList<String> numbers = new ArrayList<String>();
                for (i2 = top + 1; i2 < top + rowCount; ++i2) {
                    Object itemCellObj = table.getCell(i2, index).getUserObject();
                    if (itemCellObj != null && itemCellObj instanceof RptCell) {
                        numbers.add(((RptCell)itemCellObj).getItemFormula().getDItemNumber());
                        continue;
                    }
                    numbers.add("");
                }
                for (i2 = 1; i2 <= numbers.size(); ++i2) {
                    String number = (String)numbers.get(i2 - 1);
                    if (StringUtils.isEmpty((String)number)) continue;
                    IRow row = table.getRow(top + i2);
                    for (int j = 1; j <= numbers.size(); ++j) {
                        String subNum = (String)numbers.get(j - 1);
                        if (StringUtils.isEmpty((String)subNum) || !subNum.startsWith(number + "!") || (subNum = subNum.substring(number.length() + 1)).indexOf("!") >= 0) continue;
                        for (int k = left + 1; k < left + colCount; ++k) {
                            if (!DynamicTemplateUtilityOld.hasFormula(toprow.getCell(k))) continue;
                            ICell cell = row.getCell(k);
                            String expression = cell.getExpressions();
                            String cellName = Location.getCellName((int)(top + j), (int)k);
                            if (StringUtils.isEmpty((String)expression)) {
                                cell.setExpressions("=" + cellName);
                                continue;
                            }
                            if (expression.toLowerCase().indexOf(cellName.toLowerCase()) >= 1) continue;
                            cell.setExpressions(expression + "+" + cellName);
                        }
                    }
                }
                break block34;
            }
            if (spreadStyle == 1) {
                int index = -1;
                for (int i5 = top + 1; i5 < top + rowCount; ++i5) {
                    if (!DynamicTemplateUtilityOld.hasFormula(table.getCell(i5, left))) continue;
                    index = i5;
                    break;
                }
                if (index > 0) {
                    ArrayList<String> numbers = new ArrayList<String>();
                    for (i = left + 1; i < left + colCount; ++i) {
                        IRow row = table.getRow(index);
                        Object itemCellObj = row.getCell(i).getUserObject();
                        if (itemCellObj != null && itemCellObj instanceof RptCell) {
                            numbers.add(((RptCell)itemCellObj).getItemFormula().getDItemNumber());
                            continue;
                        }
                        numbers.add("");
                    }
                    for (i = 1; i <= numbers.size(); ++i) {
                        String number = (String)numbers.get(i - 1);
                        if (StringUtils.isEmpty((String)number)) continue;
                        for (int j = 1; j <= numbers.size(); ++j) {
                            String subNum = (String)numbers.get(j - 1);
                            if (StringUtils.isEmpty((String)subNum) || !subNum.startsWith(number + "!") || (subNum = subNum.substring(number.length() + 1)).indexOf("!") >= 0) continue;
                            for (int k = top + 1; k < top + rowCount; ++k) {
                                if (!DynamicTemplateUtilityOld.hasFormula(table.getCell(k, left))) continue;
                                ICell cell = table.getCell(k, left + i);
                                String expression = cell.getExpressions();
                                String cellName = Location.getCellName((int)k, (int)(left + j));
                                if (StringUtils.isEmpty((String)expression)) {
                                    cell.setExpressions("=" + cellName);
                                    continue;
                                }
                                if (expression.toLowerCase().indexOf(cellName.toLowerCase()) >= 1) continue;
                                cell.setExpressions(expression + "+" + cellName);
                            }
                        }
                    }
                }
            }
        }
    }

    private static boolean hasFormula(ICell cell) {
        ItemFormula formula;
        Object itemCellObj = cell.getUserObject();
        return itemCellObj != null && itemCellObj instanceof RptCell && (formula = ((RptCell)itemCellObj).getItemFormula()) != null;
    }

    private static int getColCount(KDTable table, int top, int left) {
        int width = table.getExpandedColumnCount();
        IRow row = table.getRow(top);
        for (int i = width - 1; i > left; --i) {
            ICell cell = row.getCell(i);
            if (!DynamicTemplateUtilityOld.hasFormula(cell)) continue;
            return i + 1;
        }
        return 1;
    }

    private static int getRowCount(KDTable table, int top, int left) {
        int height = table.getExpandedRowCount();
        for (int i = height - 1; i > top; --i) {
            ICell cell = table.getCell(i, left);
            if (!DynamicTemplateUtilityOld.hasFormula(cell)) continue;
            return i + 1;
        }
        return 1;
    }

    public static ItemFormula getFormula(ICell cell) {
        if (cell == null) {
            return null;
        }
        Object o = cell.getUserObject();
        if (o == null || !(o instanceof RptCell)) {
            return null;
        }
        ItemFormula f = ((RptCell)o).getItemFormula();
        if (f == null || !f.isValidity()) {
            return null;
        }
        return f;
    }
}

