/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.lcm.AbstractLCMBillValidatorImpl;
import com.kingdee.eas.fi.lcm.ILCMCurCard;
import com.kingdee.eas.fi.lcm.ILCMMonCard;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDisPatchBillInfo;
import com.kingdee.eas.fi.lcm.LCMMonCardFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.client.LCMChangeBillEditUI;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMCardValidatorImpl
extends AbstractLCMBillValidatorImpl {
    private static Logger logger = Logger.getLogger(LCMCardValidatorImpl.class);
    private boolean hasInit = false;
    private CompanyOrgUnitInfo company;
    private boolean isRelAccount;
    private PeriodInfo currPeriod;
    private HashMap lcmParams;
    public static final BigDecimal ZERO = new BigDecimal("0");
    protected static final String RES_PATH = "com.kingdee.eas.fi.lcm.LCMCardResource";
    protected static final String CARDRESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    public LCMCardValidatorImpl(Context ctx, BillBaseInfo billInfo, boolean exitAnyError) {
        super(ctx, billInfo, exitAnyError);
    }

    public LCMCardValidatorImpl(BillBaseInfo billInfo, DataComponentMap componentMap, boolean exitAnyError) {
        super(billInfo, componentMap, exitAnyError);
    }

    @Override
    public boolean validate() {
        this.reset();
        try {
            if (this.bosType.equals(new LCMCurCardInfo().getBOSType().toString())) {
                return this.verifyCardInfo(false);
            }
            if (this.bosType.equals(new LCMMonCardInfo().getBOSType().toString())) {
                return this.verifyCardInfo(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.appendInvalidMsg(null, e.getMessage());
            return false;
        }
        throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"99_FaCardValidatorImpl", (Locale)this.locale));
    }

    private boolean verifyCardInfo(boolean isInitCard) throws Exception {
        Date accountDate;
        Date buyDate;
        BigDecimal exRate;
        AccountViewInfo aAccountViewInfo;
        String strTemp;
        LCMCardInfo card;
        block77: {
            this.initiate();
            card = (LCMCardInfo)this.billInfo;
            if (card.get("checkedStatus") == null) {
                throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"100_FaCardValidatorImpl", (Locale)this.locale));
            }
            ILCMCurCard icurcard = this.ctx == null ? LCMCurCardFactory.getRemoteInstance() : LCMCurCardFactory.getLocalInstance(this.ctx);
            ILCMMonCard imoncard = this.ctx == null ? LCMMonCardFactory.getRemoteInstance() : LCMMonCardFactory.getLocalInstance(this.ctx);
            boolean importCard = this.getParam("importCard") != null;
            boolean isFormChangeBill = false;
            if (this.getParam("fromBillUI") != null && this.getParam("fromBillUI").toString().equals(LCMChangeBillEditUI.class.getName())) {
                isFormChangeBill = true;
            }
            if (!isInitCard && !isFormChangeBill && card.getCheckedStatus().getValue() == 2) {
                throw new FaCardException(FaCardException.ALREADY_AUDIT);
            }
            strTemp = "";
            CurrencyInfo baseCurrency = this.company.getBaseCurrency();
            if (baseCurrency == null) {
                this.appendInvalidMsg(null, ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.standardMondeyIsNull", (Locale)this.locale));
            }
            if (!isFormChangeBill && this.isCheckNumber(card, importCard)) {
                if (card.getNumber() == null || card.getNumber().trim().length() == 0) {
                    strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_NumberIsNull", (Locale)this.locale);
                    this.appendInvalidMsg("number", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                } else {
                    try {
                        if (isInitCard) {
                            imoncard.checkNumberDup((IObjectPK)new ObjectUuidPK(card.getId()), (CoreBillBaseInfo)card);
                        } else {
                            icurcard.checkNumberDup((IObjectPK)new ObjectUuidPK(card.getId()), (CoreBillBaseInfo)card);
                        }
                    }
                    catch (Exception e) {
                        this.appendInvalidMsg("number", e.getMessage());
                        if (!this.exitAnyError) break block77;
                        return false;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)card.getName())) {
            strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strNameIsNull", (Locale)this.locale);
            this.appendInvalidMsg("name", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (this.getParam("verifySubmit") != null && !((Boolean)this.getParam("verifySubmit")).booleanValue()) {
            return this.getInvalidMsg() == null || this.getInvalidMsg().length() == 0;
        }
        if (card.getAssetCat() == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_FaCatIsNull", (Locale)this.locale);
            this.appendInvalidMsg("assetCat", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getMeasureUnit() == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_MeasureUnitIsNull", (Locale)this.locale);
            this.appendInvalidMsg("measureUnit", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getSourceMode() == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_AlterModeIsNull", (Locale)this.locale);
            this.appendInvalidMsg("sourceMode", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getUseStatus() == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_UseStatusIsNull", (Locale)this.locale);
            this.appendInvalidMsg("useStatus", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getAmortizeMode() == null) {
            strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"11_LCMCardEditUI", (Locale)this.locale);
            this.appendInvalidMsg("amortizeMode", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (card.getCurrency() == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_CurrencyIsNull", (Locale)this.locale);
            this.appendInvalidMsg("currency", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((aAccountViewInfo = card.getAccountAsset()) == null) {
            if (this.isRelAccount) {
                // empty if block
            }
        } else if (!aAccountViewInfo.isIsLeaf()) {
            strTemp = ResourceBase.getString((String)RES_PATH, (String)"accountNotIsLeaf", (Locale)this.locale);
            this.appendInvalidMsg("accountAsset", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        boolean isFormDispactBill = false;
        if (this.getParam("Dispach") != null || card.getSourceBillId() != null && BOSUuid.read((String)card.getSourceBillId()).getType().equals((Object)new LCMDisPatchBillInfo().getBOSType())) {
            isFormDispactBill = true;
        }
        if (!isFormDispactBill && card.getSourceBillId() == null) {
            BigDecimal originAmount;
            BigDecimal unitPrice;
            BigDecimal quantity = card.getAssetAmt();
            if (quantity == null || quantity.compareTo(ZERO) <= 0) {
                strTemp = ResourceBase.getString((String)RES_PATH, (String)"amoutLessthanZero", (Locale)this.locale);
                this.appendInvalidMsg("assetAmt", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
            if ((unitPrice = card.getUnitPrice()) == null || unitPrice.compareTo(ZERO) < 0) {
                strTemp = ResourceBase.getString((String)RES_PATH, (String)"unitPriceMoreThanZero", (Locale)this.locale);
                this.appendInvalidMsg("unitPrice", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
            if ((originAmount = card.getOriginAmount()) == null || originAmount.compareTo(ZERO) < 0) {
                strTemp = ResourceBase.getString((String)RES_PATH, (String)"originAmountMoreThanZero", (Locale)this.locale);
                this.appendInvalidMsg("originAmount", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
        }
        if ((exRate = card.getExRate()) == null || exRate.compareTo(ZERO) <= 0) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_ExchangeRate", (Locale)this.locale);
            this.appendInvalidMsg("exRate", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((buyDate = card.getBuyDate()) == null) {
            strTemp = ResourceBase.getString((String)RES_PATH, (String)"buyDateIsNull", (Locale)this.locale);
            this.appendInvalidMsg("buyDate", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if ((accountDate = card.getAccountDate()) == null) {
            strTemp = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_AccountDateIsNull", (Locale)this.locale);
            this.appendInvalidMsg("accountDate", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (buyDate != null && accountDate != null && buyDate.after(accountDate)) {
            strTemp = ResourceBase.getString((String)RES_PATH, (String)"buyDateAfterAcctDate", (Locale)this.locale);
            this.appendInvalidMsg("buyDate", strTemp);
            if (this.exitAnyError) {
                return false;
            }
        }
        if (isInitCard) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company);
            if (buyDate != null && !buyDate.before(startPeriod.getBeginDate())) {
                strTemp = ResourceBase.getString((String)RES_PATH, (String)"buyAfterStartPeriod", (Locale)this.locale);
                this.appendInvalidMsg("buyDate", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
            if (accountDate != null && !accountDate.before(startPeriod.getBeginDate())) {
                strTemp = ResourceBase.getString((String)RES_PATH, (String)"accAfterStartPeriod", (Locale)this.locale);
                this.appendInvalidMsg("accountDate", strTemp);
                if (this.exitAnyError) {
                    return false;
                }
            }
            String strNo = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_No", (Locale)this.locale);
            String strRow = ResourceBase.getString((String)CARDRESOURCE_PATH, (String)"FaCurCardEditUI_Row", (Locale)this.locale);
            String detail = ResourceBase.getString((String)RES_PATH, (String)"consumeDetail", (Locale)this.locale);
            String TOTAL = ResourceBase.getString((String)RES_PATH, (String)"total", (Locale)this.locale);
            LCMConsumeDetailCollection consumeDetailCollection = (LCMConsumeDetailCollection)((Object)card.get("consumeDetail"));
            int rowCount = consumeDetailCollection.size() - 1;
            if (rowCount > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    BigDecimal useAmt;
                    LCMConsumeDetailInfo consumeDetailInfo = consumeDetailCollection.get(i);
                    int rowNo = i + 1;
                    if (TOTAL.equals(consumeDetailInfo.getUseDate())) continue;
                    Date useDate = consumeDetailInfo.getUseDate();
                    if (useDate == null) {
                        strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"useDateIsNull", (Locale)this.locale);
                        this.appendInvalidMsg("useDate", strTemp);
                        if (this.exitAnyError) {
                            return false;
                        }
                    } else if (useDate != null && accountDate != null && useDate.before(accountDate)) {
                        strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"useDateBeforeAccountDate", (Locale)this.locale);
                        this.appendInvalidMsg("useDate", strTemp);
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (consumeDetailInfo.getUseDepartment() == null) {
                        strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"useDepartmentIsNull", (Locale)this.locale);
                        this.appendInvalidMsg("useDepartment", strTemp);
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (consumeDetailInfo.getUsePerson() == null) {
                        strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"usePersonIsNull", (Locale)this.locale);
                        this.appendInvalidMsg("usePerson", strTemp);
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if ((useAmt = consumeDetailInfo.getUseAmt()) == null) {
                        strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"useAmtIsNull", (Locale)this.locale);
                        this.appendInvalidMsg("useAmt", strTemp);
                        if (this.exitAnyError) {
                            return false;
                        }
                    }
                    if (useAmt == null || !(useAmt.doubleValue() <= 0.0)) continue;
                    strTemp = detail + strNo + rowNo + strRow + ResourceBase.getString((String)RES_PATH, (String)"useAmtLessthanZero", (Locale)this.locale);
                    this.appendInvalidMsg("useAmt", strTemp);
                    if (!this.exitAnyError) continue;
                    return false;
                }
            }
        } else {
            String canAddCard = (String)this.lcmParams.get("LCM_014");
            if (canAddCard == null || canAddCard.trim().length() == 0 || canAddCard.trim().equalsIgnoreCase("false")) {
                if (buyDate != null && buyDate.after(this.currPeriod.getEndDate())) {
                    strTemp = ResourceBase.getString((String)RES_PATH, (String)"buyDateNotInCurrPeriod", (Locale)this.locale);
                    this.appendInvalidMsg("buyDate", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                }
                if (accountDate != null && (accountDate.before(this.currPeriod.getBeginDate()) || accountDate.after(this.currPeriod.getEndDate()))) {
                    strTemp = ResourceBase.getString((String)RES_PATH, (String)"accDateNotInCurrPeriod", (Locale)this.locale);
                    this.appendInvalidMsg("accountDate", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            } else {
                PeriodInfo newPeriod;
                if (accountDate != null && accountDate.before(this.currPeriod.getBeginDate())) {
                    strTemp = ResourceBase.getString((String)RES_PATH, (String)"accDateNotBeforeCurrPeriod", (Locale)this.locale);
                    this.appendInvalidMsg("accountDate", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                }
                if (accountDate != null && (newPeriod = PeriodUtils.getPeriodInfo((Date)accountDate, (CompanyOrgUnitInfo)this.company)) == null) {
                    strTemp = ResourceBase.getString((String)RES_PATH, (String)"accDateNotInSystemPeriod", (Locale)this.locale);
                    this.appendInvalidMsg("accountDate", strTemp);
                    if (this.exitAnyError) {
                        return false;
                    }
                }
            }
        }
        return this.getInvalidMsg() == null || this.getInvalidMsg().length() == 0;
    }

    private void initiate() throws BOSException, EASBizException {
        if (this.hasInit) {
            return;
        }
        this.company = (CompanyOrgUnitInfo)this.getParam("Company");
        if (this.company == null) {
            String companyId = this.billInfo.getCompany().getId().toString();
            ICompanyOrgUnit icom = this.ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            this.company = icom.getCompanyOrgUnitInfo("select *,baseCurrency.precision,baseCurrency.name,baseCurrency.id where id='" + companyId + "'");
        }
        this.lcmParams = LCMUtils.getLCMParameter(this.company.getBOSUuid("id"), this.ctx);
        Object _isRelAccount = this.getParam("isRelAccount");
        this.isRelAccount = _isRelAccount != null ? (Boolean)_isRelAccount : SystemStatusCtrolUtils.isRelAccount((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company);
        this.currPeriod = (PeriodInfo)this.getParam("currentPeriod");
        if (this.currPeriod == null) {
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company);
        }
        this.hasInit = true;
    }

    protected boolean isCheckNumber(LCMCardInfo cardInfo, boolean importCard) throws Exception {
        if (importCard) {
            return true;
        }
        if (this.lcmParams == null || this.lcmParams.size() == 0) {
            return false;
        }
        String autoCode = (String)this.lcmParams.get("LCM_000");
        String codeChange = (String)this.lcmParams.get("LCM_005");
        if (autoCode == null || autoCode.trim().length() == 0 || autoCode.trim().equalsIgnoreCase("true")) {
            if (cardInfo.getId() == null) {
                return false;
            }
            return codeChange != null && codeChange.trim().length() != 0 && codeChange.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    public static class ValidParam {
        public static final String IS_IMPORT_CARD = "importCard";
        public static final String FROM_BILL_UI = "fromBillUI";
        public static final String IS_FROM_DISPACH = "Dispach";
        public static final String CURRENT_PERIOD = "currentPeriod";
        public static final String IS_REL_ACCOUNT = "isRelAccount";
        public static final String COMPANY = "Company";
        public static final String OPRT_STATE = "OprtState";
        public static final String VERIFY_SUBMIT = "verifySubmit";
    }
}

