/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnit;
import com.kingdee.eas.basedata.org.CompanyOrgUnit;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.lcm.ILCMCurCard;
import com.kingdee.eas.fi.lcm.ILCMMonCard;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMChangeBillInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardCollection;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDisPatchBillInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillInfo;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMException;
import com.kingdee.eas.fi.lcm.LCMMonCardFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillInfo;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BillEntryBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.IBillEntryBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LCMUtils {
    private static final Logger logger = Logger.getLogger(LCMUtils.class);
    private static final BigDecimal zero = new BigDecimal("0");
    private static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static String LCMMONCARD_BOSTYPE = new LCMMonCardInfo().getBOSType().toString();
    private static String LCMCURCARD_BOSTYPE = new LCMCurCardInfo().getBOSType().toString();
    public static final int OPERATE_DELETE = 0;
    public static final int OPERATE_SAVE = 1;
    public static final int OPERATE_GENVOUCHER = 2;
    public static final int OPERATE_SUBMIT = 3;
    public static final int OPERATE_AUDIT = 4;
    public static final int OPERATE_UNAUDIT = 5;
    public static final int OPERATE_DELVOUCHER = 6;
    public static final int OPERATE_EDIT = 7;

    public static HashMap getLCMParameter(BOSUuid id) throws EASBizException, BOSException {
        return LCMUtils.getLCMParameter(id, null);
    }

    public static HashMap getLCMParameter(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        if (id == null) {
            return new HashMap();
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_000", pk);
        paramKeyMap.put("LCM_001", pk);
        paramKeyMap.put("LCM_003", pk);
        paramKeyMap.put("LCM_004", pk);
        paramKeyMap.put("LCM_013", pk);
        paramKeyMap.put("LCM_014", pk);
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        return result == null ? new HashMap() : result;
    }

    public static boolean isUseWorkflow(Context ctx, String companyId) throws EASBizException, BOSException {
        if (companyId == null) {
            if (ctx == null) {
                companyId = SysContext.getSysContext().getCurrentFIUnit() == null ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            } else {
                String string = companyId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? null : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            }
            if (companyId == null) {
                return false;
            }
        }
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_004", new ObjectUuidPK(companyId));
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        String _useWorkflow = result.get("LCM_004") == null ? null : result.get("LCM_004").toString();
        return _useWorkflow == null ? false : Boolean.valueOf(_useWorkflow);
    }

    public static LCMCurCardInfo MonCard2CurCard(LCMMonCardInfo monCardInfo) {
        if (monCardInfo == null) {
            return null;
        }
        LCMCurCardInfo curCardInfo = new LCMCurCardInfo();
        try {
            LCMUtils.copyValueBetweenCard(monCardInfo, curCardInfo, false);
        }
        catch (Exception e) {
            return null;
        }
        return curCardInfo;
    }

    public static void copyValueBetweenCard(LCMCardInfo srcCard, LCMCardInfo destCard, boolean includeID) throws Exception {
        Enumeration enumKeys = srcCard.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            if (!element.equalsIgnoreCase("id")) {
                Object o = srcCard.get(element);
                destCard.put(element, o);
                continue;
            }
            if (!includeID) continue;
            destCard.put(element, srcCard.get(element));
        }
    }

    public static void updateLCMRefIds(Context ctx, String subId, String parentId, BOSObjectType type) throws BOSException {
        if (parentId == null) {
            return;
        }
        String[] companyFieldArray = new String[]{"company"};
        String[] adminFieldArray = new String[]{"department", "admin", "dept"};
        String[] asstActFieldArray = new String[]{"asstActType"};
        String lcmPreFix = "T_LCM_";
        CompanyOrgUnit comany = new CompanyOrgUnit();
        AdminOrgUnit admin = new AdminOrgUnit();
        AsstActType asstType = new AsstActType();
        if (comany.getType().equals((Object)type)) {
            FaManageUtils.updateRefIds((Context)ctx, (String[])companyFieldArray, (String)subId, (String)parentId, (String)lcmPreFix);
        } else if (admin.getType().equals((Object)type)) {
            FaManageUtils.updateRefIds((Context)ctx, (String[])adminFieldArray, (String)subId, (String)parentId, (String)lcmPreFix);
        } else if (asstType.getType().equals((Object)type)) {
            FaManageUtils.updateRefIds((Context)ctx, (String[])asstActFieldArray, (String)subId, (String)parentId, (String)lcmPreFix);
        }
    }

    public static boolean isLCMReferedId(Context ctx, String parentId, BOSObjectType type) throws BOSException {
        if (parentId == null) {
            return false;
        }
        String[] companyFieldArray = new String[]{"company"};
        String[] adminFieldArray = new String[]{"departmen", "admin", "dept"};
        String[] asstActFieldArray = new String[]{"asstActType"};
        String lcmPreFix = "T_LCM_";
        CompanyOrgUnit comany = new CompanyOrgUnit();
        AdminOrgUnit admin = new AdminOrgUnit();
        AsstActType asstType = new AsstActType();
        if (comany.getType().equals((Object)type)) {
            return FaManageUtils.isReffered((Context)ctx, (String[])companyFieldArray, (String)parentId, (String)lcmPreFix, null);
        }
        if (admin.getType().equals((Object)type)) {
            return FaManageUtils.isReffered((Context)ctx, (String[])adminFieldArray, (String)parentId, (String)lcmPreFix, null);
        }
        if (asstType.getType().equals((Object)type)) {
            return FaManageUtils.isReffered((Context)ctx, (String[])asstActFieldArray, (String)parentId, (String)lcmPreFix, null);
        }
        return false;
    }

    public static boolean checkReturnCardNeedVoucher(Context ctx, LCMCurCardInfo cardInfo) throws BOSException, EASBizException {
        return cardInfo.getAmortizeMode().getValue() != 1 || cardInfo.getLocalAmount().compareTo(zero) == 1;
    }

    public static int getCurrencyScale(Context ctx) throws EASBizException, BOSException {
        return LCMUtils.getCurrencyScale(ctx, ContextUtil.getCurrentFIUnit((Context)ctx));
    }

    public static int getCurrencyScale(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    public static BigDecimal getReturnCardAmt(Context ctx, String cardId, String type) throws BOSException, EASBizException {
        LCMCurCardInfo cardInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)new ObjectUuidPK(cardId));
        if (cardInfo.getAmortizeMode().getValue() == 1 && cardInfo.getOriginAmount().compareTo(zero) == 1 && type.equalsIgnoreCase("1")) {
            return cardInfo.getOriginAmount();
        }
        if (cardInfo.getAmortizeMode().getValue() == 1 && cardInfo.getLocalAmount().compareTo(zero) == 1 && type.equalsIgnoreCase("2")) {
            return cardInfo.getOriginAmount();
        }
        if (cardInfo.getAmortizeMode().getValue() == 2) {
            BigDecimal returnAmt = cardInfo.getOriginAmount();
            BigDecimal returnLocalAmt = cardInfo.getLocalAmount();
            BigDecimal exrate = cardInfo.getExRate() == null ? new BigDecimal("0") : cardInfo.getExRate();
            String sql = "select FcurcardID from T_LCM_LCMReturnConsumeBill  bill inner join T_LCM_LCMReturnConsumeEntry entry on bill.fid = entry.FEntryID where  entry.FReturnCurCardID='" + cardInfo.getId().toString() + "'";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set == null || set.size() == 0) {
                return zero;
            }
            try {
                if (set.next()) {
                    String flcmcurcardid = set.getString(1);
                    LCMCurCardInfo oldInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)new ObjectUuidPK(flcmcurcardid));
                    BigDecimal amortAmt = oldInfo.getUnitPrice().multiply(oldInfo.getAssetAmt()).divide(new BigDecimal("2"), LCMUtils.getCurrencyScale(ctx));
                    BigDecimal amortLocalAmt = oldInfo.getUnitPrice().multiply(oldInfo.getAssetAmt()).multiply(exrate).divide(new BigDecimal("2"), LCMUtils.getCurrencyScale(ctx));
                    if (type.equalsIgnoreCase("1") && amortAmt.compareTo(returnAmt.setScale(LCMUtils.getCurrencyScale(ctx))) != 0) {
                        return returnAmt.subtract(amortAmt);
                    }
                    if (type.equalsIgnoreCase("2") && amortLocalAmt.compareTo(returnLocalAmt.setScale(LCMUtils.getCurrencyScale(ctx))) != 0) {
                        return returnLocalAmt.subtract(amortLocalAmt);
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return zero;
    }

    public static void checkForSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillBaseInfo billInfo = null;
        if (!(model instanceof BillBaseInfo)) {
            return;
        }
        billInfo = (BillBaseInfo)model;
        if (billInfo.getId() == null || billInfo.getId().toString().trim().length() == 0) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        BOSObjectType type = BOSUuid.read((String)pk.toString()).getType();
        IObjectValue objValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)pk, selector);
        Integer audited = new Integer(2);
        if (audited.equals(objValue.get("checkedStatus"))) {
            String msg = LCMUtils.getCheckedStatus((BillBaseInfo)objValue, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private static StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    public static Date getBizDate(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo periodInfo = LCMUtils.getLCMCurrentPeriod(companyId, ctx);
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.before(periodInfo.getBeginDate())) {
            today = DateTimeUtils.truncateDate((Date)periodInfo.getBeginDate());
        } else if (today.after(periodInfo.getEndDate())) {
            today = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
        }
        return today;
    }

    public static PeriodInfo getLCMCurrentPeriod(String companyPK, Context ctx) throws BOSException, EASBizException {
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyPK));
        return aPeriodInfo;
    }

    public static PeriodInfo getGLCurrentPeriod(String companyPK, Context ctx) throws BOSException, EASBizException {
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyPK));
        return aPeriodInfo;
    }

    public static CompanyOrgUnitInfo getLcmCurrentCompany(Context ctx) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        aCompanyOrgUnitInfo = ctx.get((Object)"depCompanyID") != null ? (CompanyOrgUnitInfo)ctx.get((Object)"depCompanyID") : ContextUtil.getCurrentFIUnit((Context)ctx);
        return aCompanyOrgUnitInfo;
    }

    public static String getLaterPeriodIds(Context ctx, String currPeriod) throws BOSException {
        HashSet v = LCMUtils.getLaterPeriodIdSet(ctx, currPeriod);
        StringBuffer b = new StringBuffer();
        Iterator it = v.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        return b.length() > 0 ? b.substring(0, b.length() - 1) : "";
    }

    public static PeriodCollection getLaterPeriodCollection(Context ctx, String currPeriod) throws BOSException {
        HashSet v = LCMUtils.getLaterPeriodIdSet(ctx, currPeriod);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        view.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", (Object)v, CompareType.INCLUDE));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
    }

    public static HashSet getLaterPeriodIdSet(Context ctx, String currPeriod) throws BOSException {
        if (currPeriod.indexOf("'") != -1) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"83_FaLocalUtils", (Locale)ctx.getOriginLocale()));
        }
        try {
            String sql = "select fid from t_bd_period where FTypeID=(select FTypeID from t_bd_period where fid=?) and (fperiodyear=(select fperiodyear from t_bd_period where fid=?) and fperiodnumber>(select fperiodnumber from t_bd_period where fid=?) or fperiodyear>(select fperiodyear from t_bd_period where fid=?))";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currPeriod, currPeriod, currPeriod, currPeriod});
            HashSet<String> v = new HashSet<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            return v;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void verifyForLastestPeriod(Context ctx, IObjectValue val, int operType) throws EASBizException, BOSException {
        IObjectCollection e;
        boolean isInitEnd;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)val.get("company");
        if (companyInfo == null) {
            companyInfo = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        BOSUuid pk = val.getBOSUuid("id");
        BOSObjectType bostype = val.getBOSType();
        boolean isCardConsume = true;
        if (!bostype.toString().equals(LCMMONCARD_BOSTYPE)) {
            HashMap lcmParam;
            String canAddCard;
            boolean isConstraintPeriod = true;
            if (bostype.toString().equals(new LCMConsumeBillInfo().getBOSType().toString())) {
                if (pk == null) {
                    LCMConsumeBillEntryInfo entry;
                    LCMConsumeBillEntryCollection entries;
                    Iterator it;
                    LCMConsumeBillInfo bill = (LCMConsumeBillInfo)val;
                    if (bill.getEntry() != null && (it = (entries = bill.getEntry()).iterator()).hasNext() && (entry = (LCMConsumeBillEntryInfo)it.next()).getSrcBillEntry() != null && entry.getSrcBillEntry().getId() != null) {
                        isCardConsume = false;
                    }
                } else {
                    isCardConsume = LCMUtils.isConsumeFromCard(ctx, pk);
                }
                if (isCardConsume && (canAddCard = (String)(lcmParam = LCMUtils.getLCMParameter(companyInfo.getId(), ctx)).get("LCM_014")) != null && canAddCard.trim().length() > 0 && canAddCard.trim().equalsIgnoreCase("true")) {
                    isConstraintPeriod = false;
                }
            } else if (bostype.toString().equals(LCMCURCARD_BOSTYPE) && (canAddCard = (String)(lcmParam = LCMUtils.getLCMParameter(companyInfo.getId(), ctx)).get("LCM_014")) != null && canAddCard.trim().length() > 0 && canAddCard.trim().equalsIgnoreCase("true")) {
                isConstraintPeriod = false;
            }
            PeriodInfo billPeriod = bostype.toString().equals(LCMCURCARD_BOSTYPE) ? (PeriodInfo)val.getObjectValue("lcmperiod") : (PeriodInfo)val.getObjectValue("period");
            LCMUtils.checkPeriodConsistent(ctx, companyInfo, billPeriod, isConstraintPeriod);
            if (bostype.toString().equals(new LCMConsumeBillInfo().getBOSType().toString()) && !isCardConsume) {
                return;
            }
        }
        if (!bostype.toString().equals(LCMMONCARD_BOSTYPE) && !(isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)companyInfo))) {
            throw new LCMException(LCMException.LCMNOTENDINIT);
        }
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)companyInfo);
        if (bostype.equals((Object)new LCMCurCardInfo().getBOSType())) {
            curPeriod = val.get("lcmPeriod") == null ? curPeriod : (PeriodInfo)val.get("lcmPeriod");
        } else if (bostype.equals((Object)new LCMConsumeBillInfo().getBOSType())) {
            curPeriod = val.get("period") == null ? curPeriod : (PeriodInfo)val.get("period");
        }
        HashSet laterPeriods = LCMUtils.getLaterPeriodIdSet(ctx, curPeriod.getId().toString());
        String entryKey = "";
        String cardKey = "";
        if (!bostype.toString().equals(LCMMONCARD_BOSTYPE) && !bostype.toString().equals(LCMCURCARD_BOSTYPE)) {
            entryKey = LCMUtils.getBillHeadEntryRelName(bostype.toString(), true);
            cardKey = bostype.toString().equals(new LCMChangeBillInfo().getBOSType().toString()) || bostype.toString().equals(new LCMDisPatchBillInfo().getBOSType().toString()) ? "lcmCurCard" : "curCard";
        }
        HashSet<String> cardSet = new HashSet<String>();
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bostype);
        ILCMMonCard imon = LCMMonCardFactory.getLocalInstance(ctx);
        ILCMCurCard icur = LCMCurCardFactory.getLocalInstance(ctx);
        if (pk == null) {
            if (iBillBase instanceof ILCMCurCard || iBillBase instanceof ILCMMonCard) {
                return;
            }
            e = (IObjectCollection)val.get(entryKey);
            for (int i = 0; i < e.size(); ++i) {
                if (e.getObject(i).get(cardKey) == null) continue;
                cardSet.add(((LCMCurCardInfo)e.getObject(i).get(cardKey)).getBOSUuid("id").toString());
            }
            if (!(cardSet.size() <= 0 || operType == 1 && bostype.equals((Object)new LCMConsumeBillInfo().getBOSType()))) {
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("lcmPeriod.id", (Object)laterPeriods, CompareType.INCLUDE));
                f.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
                EntityViewInfo v = new EntityViewInfo();
                v.setFilter(f);
                v.getSelector().add(new SelectorItemInfo("number"));
                LCMCurCardCollection c = icur.getLCMCurCardCollection(v);
                if (c.size() > 0) {
                    String nums = LCMUtils.handleCardProp((IObjectCollection)c, "number");
                    throw new FaPeriodException(FaPeriodException.LATERINACCOUNTCARD, new Object[]{nums});
                }
            }
        } else if (iBillBase instanceof ILCMCurCard) {
            cardSet.add(pk.toString());
        } else if (iBillBase instanceof ILCMMonCard) {
            if (val.getObjectValue("curCard") != null) {
                cardSet.add(val.getObjectValue("curCard").get("id").toString());
            }
        } else {
            e = (IObjectCollection)val.get(entryKey);
            for (int i = 0; i < e.size(); ++i) {
                if (e.getObject(i).get(cardKey) == null) continue;
                cardSet.add(((LCMCurCardInfo)e.getObject(i).get(cardKey)).getBOSUuid("id").toString());
            }
        }
        if (cardSet.size() > 0) {
            if (!bostype.toString().equals(LCMMONCARD_BOSTYPE)) {
                LCMUtils.hasLCMNewBiz(ctx, laterPeriods, cardSet, companyInfo.getId().toString());
            } else {
                HashSet currAndLaterPeriods = (HashSet)laterPeriods.clone();
                currAndLaterPeriods.add(curPeriod.getId().toString());
                LCMUtils.hasLCMNewBiz(ctx, currAndLaterPeriods, cardSet, companyInfo.getId().toString());
            }
        }
    }

    private static boolean isConsumeFromCard(Context ctx, BOSUuid pk) throws BOSException {
        LCMConsumeBillEntryInfo entry;
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        v.getSelector().add(new SelectorItemInfo("srcBillEntry.id"));
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)pk, CompareType.EQUALS));
        LCMConsumeBillEntryCollection entryCol = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryCollection(v);
        Iterator it = entryCol.iterator();
        return !it.hasNext() || (entry = (LCMConsumeBillEntryInfo)it.next()).getSrcBillEntry() == null || entry.getSrcBillEntry().getId() == null;
    }

    public static void hasLCMNewBiz(Context ctx, HashSet periodSet, HashSet cardSet, String companyID) throws BOSException, EASBizException {
        if (periodSet == null || periodSet.size() == 0) {
            return;
        }
        IBillEntryBase[] iBizBases = new IBillEntryBase[]{LCMReturnGoodsBillEntryFactory.getLocalInstance(ctx), LCMConsumeBillEntryFactory.getLocalInstance(ctx), LCMDiscardBillEntryFactory.getLocalInstance(ctx), LCMReturnConsumeBillEntryFactory.getLocalInstance(ctx)};
        int size = iBizBases.length;
        for (int i = 0; i < size; ++i) {
            BOSObjectType bostype = iBizBases[i].getType();
            String billKey = LCMUtils.getBillHeadEntryRelName(bostype.toString(), false);
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            v.getSelector().add(new SelectorItemInfo("curCard.number"));
            filter.getFilterItems().add(new FilterItemInfo(billKey + ".period.id", (Object)periodSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo(billKey + ".company.id", (Object)companyID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo(billKey + ".checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            if (cardSet != null && cardSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("curCard.id", (Object)cardSet, CompareType.INCLUDE));
            }
            if (bostype.equals((Object)new LCMConsumeBillEntryInfo().getBOSType())) {
                filter.getFilterItems().add(new FilterItemInfo("srcBillEntry.id", null, CompareType.EQUALS));
            }
            if (cardSet == null || cardSet.size() == 0) {
                if (!iBizBases[i].exists(filter)) continue;
                throw new FaPeriodException(FaPeriodException.LATERPERIODCANNOTOPERATE);
            }
            BillEntryBaseCollection b = iBizBases[i].getBillEntryBaseCollection(v);
            if (b.size() <= 0) continue;
            String nums = LCMUtils.handleCardProp((IObjectCollection)b, "number");
            String bizName = LCMUtils.getEntityAlias(ctx, bostype);
            int wordIndex = bizName.indexOf(ResourceBase.getString((String)FACARDRESOURCE, (String)"bill2", (Locale)ctx.getOriginLocale()));
            if (wordIndex != -1) {
                bizName = bizName.substring(0, wordIndex + 1);
            }
            throw new FaPeriodException(FaPeriodException.LATERPERIODHASBIZ, new Object[]{nums, bizName});
        }
        IBillEntryBase[] faBizEntryInterface = new IBillEntryBase[]{LCMChangeBillEntryFactory.getLocalInstance(ctx), LCMDispatchBillEntryFactory.getLocalInstance(ctx)};
        int size2 = faBizEntryInterface.length;
        for (int i = 0; i < size2; ++i) {
            BOSObjectType bostype = faBizEntryInterface[i].getType();
            String billKey = LCMUtils.getBillHeadEntryRelName(bostype.toString(), false);
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            v.getSelector().add(new SelectorItemInfo("lcmCurCard.number"));
            filter.getFilterItems().add(new FilterItemInfo(billKey + ".period.id", (Object)periodSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo(billKey + ".company.id", (Object)companyID, CompareType.EQUALS));
            if (bostype.equals((Object)new LCMDispatchBillEntryInfo().getBOSType())) {
                filter.getFilterItems().add(new FilterItemInfo(billKey + ".checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            }
            if (cardSet != null && cardSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("lcmCurCard.id", (Object)cardSet, CompareType.INCLUDE));
            }
            if (cardSet == null || cardSet.size() == 0) {
                if (!faBizEntryInterface[i].exists(filter)) continue;
                throw new FaPeriodException(FaPeriodException.LATERPERIODCANNOTOPERATE);
            }
            BillEntryBaseCollection b = faBizEntryInterface[i].getBillEntryBaseCollection(v);
            if (b.size() <= 0) continue;
            String nums = LCMUtils.handleCardProp((IObjectCollection)b, "number");
            String bizName = LCMUtils.getEntityAlias(ctx, bostype);
            int wordIndex = bizName.indexOf(ResourceBase.getString((String)FACARDRESOURCE, (String)"bill2", (Locale)ctx.getOriginLocale()));
            if (wordIndex != -1) {
                bizName = bizName.substring(0, wordIndex + 1);
            }
            throw new FaPeriodException(FaPeriodException.LATERPERIODHASBIZ, new Object[]{nums, bizName});
        }
    }

    private static String getBillHeadEntryRelName(String bostype, boolean refEntry) {
        if (bostype == null || bostype.trim().length() == 0) {
            return null;
        }
        if (bostype.equals(new LCMChangeBillInfo().getBOSType().toString()) || bostype.equals(new LCMChangeBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "changeBillEntry" : "changeBill";
        }
        if (bostype.equals(new LCMConsumeBillInfo().getBOSType().toString()) || bostype.equals(new LCMConsumeBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "bill";
        }
        if (bostype.equals(new LCMDiscardBillInfo().getBOSType().toString()) || bostype.equals(new LCMDiscardBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "bill";
        }
        if (bostype.equals(new LCMReturnConsumeBillInfo().getBOSType().toString()) || bostype.equals(new LCMReturnConsumeBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "entry";
        }
        if (bostype.equals(new LCMDisPatchBillInfo().getBOSType().toString()) || bostype.equals(new LCMDispatchBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "lcmDispatchBill";
        }
        if (bostype.equals(new LCMReturnGoodsBillInfo().getBOSType().toString()) || bostype.equals(new LCMReturnGoodsBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entries" : "bill";
        }
        return null;
    }

    private static String handleCardProp(IObjectCollection c, String propName) {
        StringBuffer b = new StringBuffer();
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < c.size(); ++i) {
            IObjectValue o = c.getObject(i);
            String val = "";
            val = o instanceof LCMMonCardInfo ? ((LCMMonCardInfo)o).getCurCard().getString(propName) : (o instanceof LCMChangeBillEntryInfo ? ((LCMChangeBillEntryInfo)o).getLcmCurCard().getString(propName) : (o instanceof LCMConsumeBillEntryInfo ? ((LCMConsumeBillEntryInfo)o).getCurCard().getString(propName) : (o instanceof LCMDiscardBillEntryInfo ? ((LCMDiscardBillEntryInfo)o).getCurCard().getString(propName) : (o instanceof LCMReturnConsumeBillEntryInfo ? ((LCMReturnConsumeBillEntryInfo)o).getCurCard().getString(propName) : (o instanceof LCMDispatchBillEntryInfo ? ((LCMDispatchBillEntryInfo)o).getLcmCurCard().getString(propName) : o.getString(propName))))));
            if (val == null || s.contains(val)) continue;
            if (s.size() == 5) {
                b.append(". . . .");
                break;
            }
            s.add(val);
            b.append(val + "\uff0c");
        }
        return b.length() > 0 ? "[" + b.substring(0, b.length() - 1) + "]" : "";
    }

    public static String getEntityAlias(Context ctx, BOSObjectType bosType) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(bosType);
        String name = entity.getAlias();
        if (name == null) {
            name = entity.getName();
        }
        return name;
    }

    public static void deleteCurPeriodandLaterPeriodMoncard(Context ctx, CompanyOrgUnitInfo company, HashSet cardSet) throws EASBizException, BOSException {
        PeriodInfo curPeriod;
        String laterPeriods;
        if (cardSet.size() < 1) {
            return;
        }
        if (company == null) {
            company = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        laterPeriods = (laterPeriods = LCMUtils.getLaterPeriodIds(ctx, (curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company)).getId().toString())).length() > 0 ? laterPeriods + ", '" + curPeriod.getId().toString() + "'" : "'" + curPeriod.getId().toString() + "'";
        StringBuffer b = new StringBuffer();
        Iterator it = cardSet.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        String cardIDs = b.length() > 0 ? b.substring(0, b.length() - 1) : "";
        String sql = "Delete From T_LCM_LCMMonCard Where FCompanyID = '" + company.getId() + "' and FPeriodID in (" + laterPeriods + ") and FCurCardID in (" + cardIDs + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void updateMonCardfromCurCard(Context ctx, CompanyOrgUnitInfo company, HashSet cardSet) throws EASBizException, BOSException {
        if (cardSet.size() < 1) {
            return;
        }
        if (company == null) {
            company = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(ctx, company);
        int lastestNumber = 0;
        try {
            lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        }
        catch (Exception e) {
            lastestNumber = 0;
        }
        if (lastestNumber < curPeriod.getNumber()) {
            return;
        }
        String laterPeriods = LCMUtils.getLaterPeriodIds(ctx, curPeriod.getId().toString());
        laterPeriods = laterPeriods.length() > 0 ? laterPeriods + ", '" + curPeriod.getId().toString() + "'" : "'" + curPeriod.getId().toString() + "'";
        StringBuffer b = new StringBuffer();
        Iterator it = cardSet.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        String cardIDs = b.length() > 0 ? b.substring(0, b.length() - 1) : "";
        StringBuffer sql = new StringBuffer();
        sql.append("update T_LCM_LCMMonCard as t set \r\n");
        sql.append(" ( \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + " \r\n");
        sql.append(" ) = ( \r\n");
        sql.append(" Select \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"c") + " \r\n");
        sql.append(" From T_LCM_LCMCurCard c \r\n");
        sql.append(" Where c.FCompanyID = '" + company.getId() + "' \r\n");
        sql.append("   And c.FID in (" + cardIDs + ") \r\n");
        sql.append("   And c.FID = t.FCurCardID) \r\n");
        sql.append(" Where t.FCompanyID = '" + company.getId() + "' \r\n");
        sql.append("   And t.FPeriodID in (" + laterPeriods + ")\r\n");
        sql.append("   And t.FCurCardID in (" + cardIDs + ")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void updateMonCardfromMonCard(Context ctx, CompanyOrgUnitInfo company, String id, HashSet cardSet) throws EASBizException, BOSException {
        PeriodInfo curPeriod;
        String laterPeriods;
        if (id == null || "".equals(id)) {
            return;
        }
        if (cardSet.size() < 1) {
            return;
        }
        if (company == null) {
            company = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        laterPeriods = (laterPeriods = LCMUtils.getLaterPeriodIds(ctx, (curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company)).getId().toString())).length() > 0 ? laterPeriods + ", '" + curPeriod.getId().toString() + "'" : "'" + curPeriod.getId().toString() + "'";
        StringBuffer b = new StringBuffer();
        Iterator it = cardSet.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        String cardIDs = b.length() > 0 ? b.substring(0, b.length() - 1) : "";
        StringBuffer sql = new StringBuffer();
        sql.append("update T_LCM_LCMMonCard as t set \r\n");
        sql.append(" ( \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + " \r\n");
        sql.append(" ) = ( \r\n");
        sql.append(" Select \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"m") + " \r\n");
        sql.append(" From T_LCM_LCMMonCard m \r\n");
        sql.append(" Where m.FID = '" + id + "' \r\n");
        sql.append("   And m.FCurCardID = t.FCurCardID) \r\n");
        sql.append(" Where t.FCompanyID = '" + company.getId() + "' \r\n");
        sql.append("   And t.FPeriodID in (" + laterPeriods + ")\r\n");
        sql.append("   And t.FCurCardID in (" + cardIDs + ")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static String getLCMLastestPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select FNumber From T_LCM_LCMLASTESTPERIOD Where FCompanyID = '").append(company.getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String lastestPeriodNumber = null;
        try {
            if (rs.next()) {
                lastestPeriodNumber = rs.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return lastestPeriodNumber;
    }

    public static void updateCurcardFromMoncard(Context ctx, CompanyOrgUnitInfo company, String id, HashSet cardSet) throws BOSException {
        if (id == null || "".equals(id)) {
            return;
        }
        if (company == null) {
            company = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        StringBuffer b = new StringBuffer();
        Iterator it = cardSet.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        String cardIDs = b.length() > 0 ? b.substring(0, b.length() - 1) : "";
        StringBuffer sql = new StringBuffer();
        sql.append("update T_LCM_LCMCurCard as t set \r\n");
        sql.append(" ( \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + " \r\n");
        sql.append(" ) = ( \r\n");
        sql.append(" Select \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"m") + " \r\n");
        sql.append(" From T_LCM_LCMMonCard m \r\n");
        sql.append(" Where m.FID = '" + id + "' \r\n");
        sql.append("   And m.FCurCardID = t.FID) \r\n");
        sql.append(" Where t.FCompanyID = '" + company.getId() + "' \r\n");
        sql.append("   And t.FID in (" + cardIDs + ")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update t_lcm_lcmcurcard set FSourceType = 3, FFiVouchered = 1 \r\n");
        sql.append(" where fid in (" + cardIDs + ")\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void checkForEdit(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = LCMUtils.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus") != null && billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(LCMUtils.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus") != null && billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(LCMUtils.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus") != null && billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(LCMUtils.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.get("fiVouchered") != null && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(LCMUtils.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
        if (val.get("company") == null) {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 7);
        } else {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 7);
        }
    }

    protected static BillBaseInfo perpareBillInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        BOSUuid uuid = (BOSUuid)pk.getKeyValue("id");
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType());
        BillBaseInfo billInfo = iBillBase.getBillBaseInfo(pk, sic = LCMUtils.getStatusSelectors());
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        return billInfo;
    }

    protected static SelectorItemCollection getStatusSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected static StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected static StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected static StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected static StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    public static void checkPeriodConsistent(Context ctx, CompanyOrgUnitInfo company, PeriodInfo billPeriod, boolean isConstraintPeriod) throws EASBizException, BOSException {
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (billPeriod != null) {
            PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
            if (isConstraintPeriod) {
                if (!currPeriod.getId().toString().equals(billPeriod.getId().toString())) {
                    throw new FaPeriodException(FaPeriodException.PERIODNOTCONSISTENT);
                }
            } else {
                HashSet p = LCMUtils.getLaterPeriodIdSet(ctx, currPeriod.getId().toString());
                p.add(currPeriod.getId().toString());
                if (!p.contains(billPeriod.getId().toString())) {
                    throw new FaPeriodException(FaPeriodException.PERIODNOTCONSISTENT2);
                }
            }
        }
    }

    public static Map getLCMParameter(Context ctx, BOSUuid companyId, String[] lcmParamConstant) throws EASBizException, BOSException {
        if (companyId == null) {
            return new HashMap();
        }
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        for (int i = 0; i < lcmParamConstant.length; ++i) {
            paramKeyMap.put(lcmParamConstant[i], pk);
        }
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        return result == null ? new HashMap() : result;
    }

    private static String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public static DateFormat getDateFormat(Context ctx) throws EASBizException, BOSException {
        return (DateFormat)LCMUtils.getNationalConfig(ctx).get("dateFormat");
    }

    public static DateFormat getTimeFormat(Context ctx) throws EASBizException, BOSException {
        return (DateFormat)LCMUtils.getNationalConfig(ctx).get("timeFormat");
    }

    public static DateFormat getDateTimeFormat(Context ctx) throws EASBizException, BOSException {
        return (DateFormat)LCMUtils.getNationalConfig(ctx).get("dateTimeFormat");
    }

    public static DecimalFormat getDecimalFormat(Context ctx) throws EASBizException, BOSException {
        return (DecimalFormat)LCMUtils.getNationalConfig(ctx).get("numberFormat");
    }

    public static String formatDate(Context ctx, Date date) throws EASBizException, BOSException {
        return LCMUtils.getDateFormat(ctx).format(date);
    }

    public static String formatTime(Context ctx, Date date) throws EASBizException, BOSException {
        return LCMUtils.getTimeFormat(ctx).format(date);
    }

    public static String formatDateTime(Context ctx, Date date) throws EASBizException, BOSException {
        return LCMUtils.getDateTimeFormat(ctx).format(date);
    }

    public static String formatDecimal(Context ctx, BigDecimal val) throws EASBizException, BOSException {
        int scale = val.scale();
        return LCMUtils.formatDecimal(ctx, val, scale);
    }

    public static String formatDecimal(Context ctx, BigDecimal val, int scale) throws EASBizException, BOSException {
        DecimalFormat decimalFormat = LCMUtils.getDecimalFormat(ctx);
        decimalFormat.applyPattern(LCMUtils.getFormatPattern(scale));
        return decimalFormat.format(val);
    }

    private static Map getNationalConfig(Context ctx) throws EASBizException, BOSException {
        return NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
    }
}

