/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.lcm.app.ILCMAppChecker;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;

public abstract class AbstractLCMAppChecker
implements ILCMAppChecker {
    @Override
    public void checkForAudit(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
        this.checkAuditorWithCreator(ctx, billInfo);
        this.checkAuditStatus(ctx, billInfo);
        this.checkRelationBillForAudit(ctx, billInfo);
    }

    @Override
    public void checkForUnAudit(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
        this.checkUnAuditorWithAuditor(ctx, billInfo);
        this.checkUnAuditStatus(ctx, billInfo);
        this.checkRelationBillForUnAudit(ctx, billInfo);
    }

    protected void checkAuditStatus(Context ctx, BillBaseInfo billInfo) throws FaCardException {
        StringBuffer sbMsg = new StringBuffer("");
        if (2 == billInfo.getInt("DeletedStatus")) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (1 == billInfo.getInt("EffectedStatus")) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (2 == billInfo.getInt("checkedStatus")) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (2 == billInfo.getInt("blockedStatus")) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (this.isNeedCheckVoucher() && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected void checkUnAuditStatus(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
        StringBuffer sbMsg = new StringBuffer("");
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        PeriodInfo lcmPeriod = (PeriodInfo)billInfo.get("lcmperiod");
        if (lcmPeriod == null) {
            lcmPeriod = (PeriodInfo)billInfo.get("period");
        }
        if (lcmPeriod != null && !curPeriod.getId().toString().equals(lcmPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getInt("DeletedStatus") == 2) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getInt("EffectedStatus") == 1) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (1 == billInfo.getInt("checkedStatus")) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.getInt("blockedStatus") == 2) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (this.isNeedCheckVoucher() && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected boolean isNeedCheckVoucher() {
        return true;
    }

    protected void checkRelationBillForAudit(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
    }

    protected void checkRelationBillForUnAudit(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
    }

    private void checkUnAuditorWithAuditor(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
    }

    private void checkAuditorWithCreator(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
    }

    private String getCurrentCompanyId(Context ctx, BillBaseInfo billInfo) {
        if (billInfo.getCompany() != null && billInfo.getCompany().getId() != null) {
            return billInfo.getCompany().getId().toString();
        }
        return ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
    }

    private StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    private StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    private StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    private StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    private StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals((Integer)billInfo.get("blockedStatus"))) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }
}

