/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMSourceTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMCardControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class LCMCardControllerBean
extends AbstractLCMCardControllerBean {
    private static final Logger logger = Logger.getLogger(LCMCardControllerBean.class);
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    protected static final String RES_PATH = "com.kingdee.eas.fi.lcm.LCMCardResource";

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (this.existNumber(ctx, model)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
        return true;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IBillBase iBillBase;
        LCMCardInfo cardInfo;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        BOSUuid id = ((LCMCardInfo)model).getId();
        if (id != null) {
            ObjectUuidPK pk2 = new ObjectUuidPK(id);
            this.checkSave(ctx, (IObjectPK)pk2);
        }
        if ((aCompanyOrgUnitInfo = (cardInfo = (LCMCardInfo)model).getCompany()) == null) {
            cardInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        this.checkFinishInit(ctx, cardInfo, aCompanyOrgUnitInfo);
        cardInfo.setBizDate(LCMUtils.getBizDate(ctx, aCompanyOrgUnitInfo.getId().toString()));
        if (cardInfo.getStoreAdress() == null) {
            AddressInfo addressInfo = null;
            try {
                addressInfo = LCMCardControllerBean.getAddressInfo(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), cardInfo.getAddress());
            }
            catch (TaskExternalException e) {
                logger.error((Object)e);
            }
            cardInfo.setStoreAdress(addressInfo);
        }
        boolean isAutoNumber = this.isAutoNumber(ctx);
        if (cardInfo.getId() != null && (iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)(pk = new ObjectUuidPK(cardInfo.getId())).toString()).getType())).exists("where id='" + pk + "'")) {
            SelectorItemCollection seletors = new SelectorItemCollection();
            seletors.add(new SelectorItemInfo("id"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("number"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("assetCat.name"));
            seletors.add(new SelectorItemInfo("assetCat.numberRule"));
            seletors.add(new SelectorItemInfo("assetCat.number"));
            seletors.add(new SelectorItemInfo("company.id"));
            seletors.add(new SelectorItemInfo("company.number"));
            seletors.add(new SelectorItemInfo("company.name"));
            seletors.add(new SelectorItemInfo("bizDate"));
            seletors.add(new SelectorItemInfo("CU.id"));
            seletors.add(new SelectorItemInfo("CU.name"));
            seletors.add(new SelectorItemInfo("CU.number"));
            LCMCardInfo oldCardInfo = this.getLCMCardInfo(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()), seletors);
            boolean isChangedCat = false;
            if (cardInfo.getAssetCat() == null && oldCardInfo.getAssetCat() != null || cardInfo.getAssetCat() != null && oldCardInfo.getAssetCat() == null) {
                isChangedCat = true;
            }
            if (cardInfo.getAssetCat() != null && !isChangedCat) {
                isChangedCat = !cardInfo.getAssetCat().getId().equals((Object)oldCardInfo.getAssetCat().getId());
            }
            boolean canChangeCode = this.canChangeCode(ctx);
            if (cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE) && isAutoNumber) {
                if (canChangeCode || isChangedCat) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                if (isChangedCat && !canChangeCode) {
                    this.setNewNumber(ctx, cardInfo);
                }
            }
        }
        if (cardInfo.getLocalAmount() == null && cardInfo.getOriginAmount() != null && cardInfo.getExRate() != null) {
            BigDecimal localAmount = cardInfo.getOriginAmount().multiply(cardInfo.getExRate());
            cardInfo.setLocalAmount(localAmount.setScale(cardInfo.getOriginAmount().scale(), 4));
        }
        if (cardInfo.getId() == null) {
            cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            if (isAutoNumber) {
                if (cardInfo.getId() != null && cardInfo.getNumber() != null) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                this.setNewNumber(ctx, cardInfo);
            }
        }
        this.setStatusForBot(ctx, (LCMCardInfo)model);
        return super._save(ctx, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK cardPK;
        IBillBase iBillBase;
        LCMCardInfo cardInfo;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        if (pk != null) {
            this.checkSave(ctx, pk);
        }
        if ((aCompanyOrgUnitInfo = (cardInfo = (LCMCardInfo)model).getCompany()) == null) {
            cardInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        this.checkFinishInit(ctx, cardInfo, aCompanyOrgUnitInfo);
        cardInfo.setBizDate(LCMUtils.getBizDate(ctx, aCompanyOrgUnitInfo.getId().toString()));
        if (cardInfo.getStoreAdress() == null) {
            AddressInfo addressInfo = null;
            try {
                addressInfo = LCMCardControllerBean.getAddressInfo(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), cardInfo.getAddress());
            }
            catch (TaskExternalException e) {
                logger.error((Object)e);
            }
            cardInfo.setStoreAdress(addressInfo);
        }
        boolean isAutoNumber = this.isAutoNumber(ctx);
        if (cardInfo.getId() != null && (iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)(cardPK = new ObjectUuidPK(cardInfo.getId())).toString()).getType())).exists("where id='" + cardPK + "'")) {
            SelectorItemCollection seletors = new SelectorItemCollection();
            seletors.add(new SelectorItemInfo("id"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("number"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("assetCat.name"));
            seletors.add(new SelectorItemInfo("assetCat.numberRule"));
            seletors.add(new SelectorItemInfo("assetCat.number"));
            seletors.add(new SelectorItemInfo("company.id"));
            seletors.add(new SelectorItemInfo("company.number"));
            seletors.add(new SelectorItemInfo("company.name"));
            seletors.add(new SelectorItemInfo("bizDate"));
            seletors.add(new SelectorItemInfo("CU.id"));
            seletors.add(new SelectorItemInfo("CU.name"));
            seletors.add(new SelectorItemInfo("CU.number"));
            LCMCardInfo oldCardInfo = this.getLCMCardInfo(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()), seletors);
            boolean isChangedCat = false;
            if (cardInfo.getAssetCat() == null && oldCardInfo.getAssetCat() != null || cardInfo.getAssetCat() != null && oldCardInfo.getAssetCat() == null) {
                isChangedCat = true;
            }
            if (cardInfo.getAssetCat() != null && !isChangedCat) {
                isChangedCat = !cardInfo.getAssetCat().getId().equals((Object)oldCardInfo.getAssetCat().getId());
            }
            boolean canChangeCode = this.canChangeCode(ctx);
            if (cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE) && isAutoNumber) {
                if (canChangeCode || isChangedCat) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                if (isChangedCat && !canChangeCode) {
                    this.setNewNumber(ctx, cardInfo);
                }
            }
        }
        if (cardInfo.getId() == null) {
            cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            if (isAutoNumber) {
                if (cardInfo.getId() != null && cardInfo.getNumber() != null) {
                    this.recycleNumber(ctx, pk);
                }
                this.setNewNumber(ctx, cardInfo);
            }
        }
        this.setStatusForBot(ctx, (LCMCardInfo)model);
        super._save(ctx, pk, model);
    }

    protected void setStatusForBot(Context ctx, LCMCardInfo cardInfo) throws EASBizException, BOSException {
        if (cardInfo instanceof LCMMonCardInfo) {
            return;
        }
        cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        cardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        cardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        cardInfo.setSourceType(LCMSourceTypeEnum.newCard);
        cardInfo.setUsableAmt(cardInfo.getAssetAmt());
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk.toString()).getType());
        if (!iBillBase.exists("where id='" + pk + "'")) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        LCMCardInfo cardInfo = this.getLCMCardInfo(ctx, pk);
        if (EffectedStatusEnum.EFFECTED.equals((Object)cardInfo.getCheckedStatus())) {
            String msg = this.getEffectedStatus(cardInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMCardInfo cardInfo = (LCMCardInfo)model;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = cardInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            cardInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        this.checkFinishInit(ctx, cardInfo, aCompanyOrgUnitInfo);
        cardInfo.setBizDate(LCMUtils.getBizDate(ctx, aCompanyOrgUnitInfo.getId().toString()));
        if (cardInfo.getStoreAdress() == null) {
            AddressInfo addressInfo = null;
            try {
                addressInfo = LCMCardControllerBean.getAddressInfo(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), cardInfo.getAddress());
            }
            catch (TaskExternalException e) {
                logger.error((Object)e);
            }
            cardInfo.setStoreAdress(addressInfo);
        }
        boolean isAutoNumber = this.isAutoNumber(ctx);
        if (cardInfo.getId() != null) {
            SelectorItemCollection seletors = new SelectorItemCollection();
            seletors.add(new SelectorItemInfo("id"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("number"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("assetCat.name"));
            seletors.add(new SelectorItemInfo("assetCat.numberRule"));
            seletors.add(new SelectorItemInfo("assetCat.number"));
            seletors.add(new SelectorItemInfo("company.id"));
            seletors.add(new SelectorItemInfo("company.number"));
            seletors.add(new SelectorItemInfo("company.name"));
            seletors.add(new SelectorItemInfo("bizDate"));
            seletors.add(new SelectorItemInfo("CU.id"));
            seletors.add(new SelectorItemInfo("CU.name"));
            seletors.add(new SelectorItemInfo("CU.number"));
            LCMCardInfo oldCardInfo = this.getLCMCardInfo(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()), seletors);
            boolean isChangedCat = false;
            if (cardInfo.getAssetCat() == null && oldCardInfo.getAssetCat() != null || cardInfo.getAssetCat() != null && oldCardInfo.getAssetCat() == null) {
                isChangedCat = true;
            }
            if (cardInfo.getAssetCat() != null && !isChangedCat) {
                isChangedCat = !cardInfo.getAssetCat().getId().equals((Object)oldCardInfo.getAssetCat().getId());
            }
            boolean canChangeCode = this.canChangeCode(ctx);
            if (cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.EFFECTED) && isAutoNumber) {
                if (canChangeCode || isChangedCat) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                if (isChangedCat && !canChangeCode) {
                    this.setNewNumber(ctx, cardInfo);
                }
            }
        }
        if (cardInfo.getId() == null || cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            cardInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            cardInfo.setSourceType(LCMSourceTypeEnum.newCard);
            if (isAutoNumber) {
                if (cardInfo.getId() != null && cardInfo.getNumber() != null) {
                    this.recycleNumber(ctx, pk);
                }
                this.setNewNumber(ctx, cardInfo);
            }
        }
        super._submit(ctx, pk, model);
    }

    private static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().trim().length() == 0;
    }

    public static AddressInfo getAddressInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (LCMCardControllerBean.isEmpty(number)) {
            return null;
        }
        String sql = "SELECT ADDRESS.FID FROM T_BD_Address ADDRESS INNER JOIN T_ORG_CtrlUnit CU ON ADDRESS.FControlUnitID = CU.FID WHERE (ADDRESS.FAdminCUID = ? OR ADDRESS.FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE (FBOSObjectType = 'A8E556C9' AND FAssignCUID = ?))) AND ADDRESS.Fname_l2 = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId, companyId, number});
            if (rs.next()) {
                String addressId = rs.getString(1);
                AddressInfo addressInfo = new AddressInfo();
                addressInfo.setId(BOSUuid.read((String)addressId));
                return addressInfo;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        throw new TaskExternalException(FaResUtil.getRes((String)"noAddress", (Locale)ctx.getOriginLocale()) + number);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMCardInfo cardInfo = (LCMCardInfo)model;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = cardInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            cardInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        this.checkFinishInit(ctx, cardInfo, aCompanyOrgUnitInfo);
        cardInfo.setBizDate(LCMUtils.getBizDate(ctx, aCompanyOrgUnitInfo.getId().toString()));
        if (cardInfo.getStoreAdress() == null) {
            AddressInfo addressInfo = null;
            try {
                addressInfo = LCMCardControllerBean.getAddressInfo(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), cardInfo.getAddress());
            }
            catch (TaskExternalException e) {
                logger.error((Object)e);
            }
            cardInfo.setStoreAdress(addressInfo);
        }
        boolean isAutoNumber = this.isAutoNumber(ctx);
        if (cardInfo.getId() != null) {
            SelectorItemCollection seletors = new SelectorItemCollection();
            seletors.add(new SelectorItemInfo("id"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("number"));
            seletors.add(new SelectorItemInfo("assetCat.id"));
            seletors.add(new SelectorItemInfo("assetCat.name"));
            seletors.add(new SelectorItemInfo("assetCat.numberRule"));
            seletors.add(new SelectorItemInfo("assetCat.number"));
            seletors.add(new SelectorItemInfo("company.id"));
            seletors.add(new SelectorItemInfo("company.number"));
            seletors.add(new SelectorItemInfo("company.name"));
            seletors.add(new SelectorItemInfo("bizDate"));
            seletors.add(new SelectorItemInfo("CU.id"));
            seletors.add(new SelectorItemInfo("CU.name"));
            seletors.add(new SelectorItemInfo("CU.number"));
            LCMCardInfo oldCardInfo = this.getLCMCardInfo(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()), seletors);
            boolean isChangedCat = false;
            if (cardInfo.getAssetCat() == null && oldCardInfo.getAssetCat() != null || cardInfo.getAssetCat() != null && oldCardInfo.getAssetCat() == null) {
                isChangedCat = true;
            }
            if (cardInfo.getAssetCat() != null && !isChangedCat) {
                isChangedCat = !cardInfo.getAssetCat().getId().equals((Object)oldCardInfo.getAssetCat().getId());
            }
            boolean canChangeCode = this.canChangeCode(ctx);
            if (cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.EFFECTED) && isAutoNumber) {
                if (canChangeCode || isChangedCat) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                if (isChangedCat && !canChangeCode) {
                    this.setNewNumber(ctx, cardInfo);
                }
            }
        }
        if (cardInfo.getId() == null || cardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            cardInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            cardInfo.setSourceType(LCMSourceTypeEnum.newCard);
            if (isAutoNumber) {
                if (cardInfo.getId() != null && cardInfo.getNumber() != null) {
                    this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(cardInfo.getId()));
                }
                this.setNewNumber(ctx, cardInfo);
            }
        }
        return super._submit(ctx, model);
    }

    private void checkFinishInit(Context ctx, LCMCardInfo cardInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws BOSException, EASBizException {
        if (cardInfo.getLcmPeriod() == null && cardInfo.getSourceBillId() == null) {
            return;
        }
        boolean isStarted = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isStarted) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource.LCMNotEndInit", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("01", strMsg));
        }
        if (cardInfo.getLcmPeriod() == null && cardInfo.getSourceBillId() != null) {
            String periodNullMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource.getPeriodFail", (Locale)ctx.getOriginLocale());
            PeriodInfo currenctPeriod = null;
            try {
                currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            }
            catch (Exception ex) {
                throw new EASBizException(new NumericExceptionSubItem("01", periodNullMsg));
            }
            if (currenctPeriod == null) {
                throw new EASBizException(new NumericExceptionSubItem("01", periodNullMsg));
            }
            cardInfo.setLcmPeriod(currenctPeriod);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("effectedStatus"));
        sc.add(new SelectorItemInfo("company"));
        sc.add(new SelectorItemInfo("assetCat.id"));
        sc.add(new SelectorItemInfo("assetCat.name"));
        sc.add(new SelectorItemInfo("assetCat.numberRule"));
        sc.add(new SelectorItemInfo("assetCat.number"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.number"));
        sc.add(new SelectorItemInfo("company.name"));
        sc.add(new SelectorItemInfo("bizDate"));
        sc.add(new SelectorItemInfo("CU.id"));
        sc.add(new SelectorItemInfo("CU.name"));
        sc.add(new SelectorItemInfo("CU.number"));
        LCMCardInfo cardInfo = this.getLCMCardInfo(ctx, pk, sc);
        BOSUuid companyID = cardInfo.getCompany().getId();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)cardInfo, companyID.toString(), "effectedStatus") && iCodingRuleManager.isUseIntermitNumber((IObjectValue)cardInfo, companyID.toString(), "effectedStatus") && cardInfo.getNumber() != null) {
            iCodingRuleManager.recycleNumber((IObjectValue)cardInfo, companyID.toString(), "effectedStatus", "", cardInfo.getNumber());
        }
        super._delete(ctx, pk);
        AttachmentManagerFactory.getServerManager((Context)ctx).deleteAttachemtsByBoID(pk.toString());
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("effectedStatus"));
        sc.add(new SelectorItemInfo("company"));
        sc.add(new SelectorItemInfo("assetCat.id"));
        sc.add(new SelectorItemInfo("assetCat.name"));
        sc.add(new SelectorItemInfo("assetCat.numberRule"));
        sc.add(new SelectorItemInfo("assetCat.number"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.number"));
        sc.add(new SelectorItemInfo("company.name"));
        sc.add(new SelectorItemInfo("bizDate"));
        sc.add(new SelectorItemInfo("CU.id"));
        sc.add(new SelectorItemInfo("CU.name"));
        sc.add(new SelectorItemInfo("CU.number"));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < arrayPK.length; ++i) {
            BOSUuid companyID;
            LCMCardInfo cardInfo = this.getLCMCardInfo(ctx, arrayPK[i], sc);
            if (!iCodingRuleManager.isExist((IObjectValue)cardInfo, (companyID = cardInfo.getCompany().getId()).toString(), "effectedStatus") || !iCodingRuleManager.isUseIntermitNumber((IObjectValue)cardInfo, companyID.toString(), "effectedStatus") || cardInfo.getNumber() == null) continue;
            iCodingRuleManager.recycleNumber((IObjectValue)cardInfo, companyID.toString(), "effectedStatus", "", cardInfo.getNumber());
        }
        super._delete(ctx, arrayPK);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        for (int i = 0; i < arrayPK.length; ++i) {
            asm.deleteAttachemtsByBoID(arrayPK[i].toString());
        }
    }

    protected void setNewNumber(Context ctx, LCMCardInfo cardInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = cardInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        cardInfo.setBizDate(LCMUtils.getBizDate(ctx, strCompanyId));
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)cardInfo, strCompanyId, "effectedStatus", "");
        cardInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)cardInfo)) {
            this.setNewNumber(ctx, cardInfo);
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMCardInfo cardInfo = (LCMCardInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)cardInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (cardInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)cardInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (cardInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)cardInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    private void recycleNumber(Context ctx, IObjectPK pk) throws BOSException, EASBizException, CodingRuleException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("effectedStatus"));
        sc.add(new SelectorItemInfo("company"));
        sc.add(new SelectorItemInfo("assetCat.id"));
        sc.add(new SelectorItemInfo("assetCat.name"));
        sc.add(new SelectorItemInfo("assetCat.numberRule"));
        sc.add(new SelectorItemInfo("assetCat.number"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.number"));
        sc.add(new SelectorItemInfo("company.name"));
        sc.add(new SelectorItemInfo("bizDate"));
        sc.add(new SelectorItemInfo("CU.id"));
        sc.add(new SelectorItemInfo("CU.name"));
        sc.add(new SelectorItemInfo("CU.number"));
        LCMCardInfo cardInfo = (LCMCardInfo)this._getValue(ctx, pk, sc);
        if (cardInfo.getNumber() == null) {
            return;
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = cardInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)cardInfo, strCompanyID, "effectedStatus") && iCodingRuleManager.isUseIntermitNumber((IObjectValue)cardInfo, strCompanyID, "effectedStatus") && cardInfo.getNumber() != null) {
            iCodingRuleManager.recycleNumber((IObjectValue)cardInfo, strCompanyID, "effectedStatus", "", cardInfo.getNumber());
        }
    }

    protected boolean isAutoNumber(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_000", companyPK);
        paramKeyMap.put("LCM_005", companyPK);
        paramKeyMap.put("LCM_001", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmResult = iParamControl.getParamHashMap(paramKeyMap);
        if (hmResult == null || hmResult.size() == 0) {
            return true;
        }
        String autoCode = (String)hmResult.get("LCM_000");
        return autoCode == null || autoCode.trim().length() == 0 || autoCode.trim().equalsIgnoreCase("true");
    }

    protected boolean canChangeCode(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_000", companyPK);
        paramKeyMap.put("LCM_005", companyPK);
        paramKeyMap.put("LCM_001", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmResult = iParamControl.getParamHashMap(paramKeyMap);
        if (hmResult == null || hmResult.size() == 0) {
            return false;
        }
        String codeChange = (String)hmResult.get("LCM_005");
        return codeChange != null && codeChange.trim().equalsIgnoreCase("true");
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._reverseSave(ctx, pk, model);
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }
}

