/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.lcm.AbstractLCMChangeBillInfo;
import com.kingdee.eas.fi.lcm.ILCMConsumeBill;
import com.kingdee.eas.fi.lcm.ILCMDiscardBill;
import com.kingdee.eas.fi.lcm.LCMAlterModeFactory;
import com.kingdee.eas.fi.lcm.LCMAlterModeInfo;
import com.kingdee.eas.fi.lcm.LCMBakCardFactory;
import com.kingdee.eas.fi.lcm.LCMBakCardInfo;
import com.kingdee.eas.fi.lcm.LCMBizCardFactory;
import com.kingdee.eas.fi.lcm.LCMBizCardInfo;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMChangeBillFactory;
import com.kingdee.eas.fi.lcm.LCMChangeBillInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillFactory;
import com.kingdee.eas.fi.lcm.LCMDiscardBillInfo;
import com.kingdee.eas.fi.lcm.LCMUseStatusEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMChangeBillControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMChangeBillControllerBean
extends AbstractLCMChangeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.lcm.app.LCMChangeBillControllerBean");
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    protected static final String LCMChangeBillResource = "com.kingdee.eas.fi.lcm.LCMChangeBillResource";
    private final String InsertBizSql = "insert into T_LCM_LCMBizCard(fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime)";
    private final String insertBizSqlId = " select ";
    private final String InserBizSqlFrom = "  as fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime from T_LCM_LCMCurCard ";
    private final String InsertBakSql = "insert into T_LCM_LCMBakCard(fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime)";
    private final String InsertBakId = " select ";
    private final String InsertBakFrom = "  as fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime from T_LCM_LCMCurCard";
    BigDecimal ZERO = new BigDecimal("0.00");

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
        if (changeBillInfo != null && changeBillInfo.getBOSUuid("id") != null) {
            this.checkForEdit(ctx, (IObjectPK)new ObjectUuidPK(changeBillInfo.getBOSUuid("id")));
        } else {
            this.checkForEdit(ctx, (IObjectPK)new ObjectUuidPK(model.getBOSUuid("id")));
        }
        return true;
    }

    protected void checkForEdit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        PeriodInfo changeBillPeriod = billInfo.getPeriod();
        if (!curPeriod.getId().toString().equals(changeBillPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 7);
    }

    private SelectorItemCollection getChangeBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("changeMode.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        return sic;
    }

    public SelectorItemCollection getLcmCardSelectorsForUpdate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("assetCat"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("measureUnit"));
        sic.add(new SelectorItemInfo("buyDate"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("sourceMode"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("keeper"));
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("usableAmt"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("unitPrice"));
        sic.add(new SelectorItemInfo("originAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("life"));
        sic.add(new SelectorItemInfo("address"));
        sic.add(new SelectorItemInfo("useStatus"));
        sic.add(new SelectorItemInfo("amortizeMode"));
        sic.add(new SelectorItemInfo("accountAsset"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("supplier"));
        sic.add(new SelectorItemInfo("storeAdress"));
        return sic;
    }

    public SelectorItemCollection getLcmCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("assetCat.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("buyDate"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("sourceMode.*"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("dept.*"));
        sic.add(new SelectorItemInfo("keeper.*"));
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("usableAmt"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("unitPrice"));
        sic.add(new SelectorItemInfo("originAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("life"));
        sic.add(new SelectorItemInfo("address"));
        sic.add(new SelectorItemInfo("useStatus"));
        sic.add(new SelectorItemInfo("amortizeMode"));
        sic.add(new SelectorItemInfo("accountAsset.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("supplier.*"));
        sic.add(new SelectorItemInfo("storeAdress.*"));
        return sic;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        LCMBizCardInfo bizInfo;
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)super._getValue(ctx, pk, this.getChangeBillSelectors());
        LCMCurCardInfo lcmCardInfo = changeBillInfo.getChangeBillEntry().get(0).getLcmCurCard();
        if (lcmCardInfo != null && lcmCardInfo.getId() != null) {
            lcmCardInfo = (LCMCurCardInfo)LCMCurCardFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(lcmCardInfo.getId().toString()), this.getLcmCardSelectors());
        }
        if ((bizInfo = changeBillInfo.getChangeBillEntry().get(0).getLcmBizCard()) != null && bizInfo.getId() != null) {
            bizInfo = LCMBizCardFactory.getLocalInstance(ctx).getLCMBizCardInfo((IObjectPK)new ObjectUuidPK(bizInfo.getId().toString()), this.getLcmCardSelectors());
            lcmCardInfo = this.otherInfoToCardInfo(lcmCardInfo, bizInfo);
        }
        lcmCardInfo.put("changeBill", changeBillInfo);
        return lcmCardInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
        if (changeBillInfo != null && changeBillInfo.getBOSUuid("id") != null) {
            this.checkForEdit(ctx, (IObjectPK)new ObjectUuidPK(changeBillInfo.getBOSUuid("id")));
        }
        if (model instanceof LCMCurCardInfo) {
            changeBillInfo = (LCMChangeBillInfo)model.get("changeBill") != null && ((LCMChangeBillInfo)model.get("changeBill")).getId() != null ? this.getEditChangeBill(ctx, model) : this.getAddNewChangeBill(ctx, model);
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)changeBillInfo, 3);
        if (changeBillInfo == null) {
            return null;
        }
        changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeBillInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeBillInfo.setFiVouchered(false);
        IObjectPK pk = LCMChangeBillFactory.getLocalInstance(ctx).submitSelf(changeBillInfo);
        this.updateLcmCurcardSourcebillID(ctx, pk, model);
        return pk;
    }

    private void updateLcmCurcardSourcebillID(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMCurCardInfo curCard = (LCMCurCardInfo)model;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        curCard.setSourceBillId(pk.toString());
        LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCard, sic);
    }

    private void bakSourcebillIDFromBizcard(Context ctx, LCMCurCardInfo curCard, LCMBizCardInfo bizCard) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        if (bizCard.getSourceBillId() != null) {
            curCard.setSourceBillId(bizCard.getSourceBillId());
            LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCard, sic);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
        if (changeBillInfo != null && changeBillInfo.getBOSUuid("id") != null) {
            LCMBillBizProcessor.lockTable(ctx, changeBillInfo.getId().toString());
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(changeBillInfo.getBOSUuid("id")));
        }
        return this.saveBill(ctx, model);
    }

    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AbstractLCMChangeBillInfo changeBillInfo = null;
        if (model instanceof LCMCurCardInfo) {
            changeBillInfo = (LCMChangeBillInfo)model.get("changeBill") != null && ((LCMChangeBillInfo)model.get("changeBill")).getId() != null ? this.getEditChangeBill(ctx, model) : this.getAddNewChangeBill(ctx, model);
        }
        LCMUtils.verifyForLastestPeriod(ctx, changeBillInfo, 1);
        if (changeBillInfo == null) {
            return null;
        }
        changeBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        changeBillInfo.setFiVouchered(false);
        IObjectPK pk = super._save(ctx, (IObjectValue)changeBillInfo);
        this.updateLcmCurcardSourcebillID(ctx, pk, model);
        return pk;
    }

    private LCMBizCardInfo cardInfoChange(LCMBizCardInfo bizInfo, LCMCurCardInfo curCardold) {
        bizInfo.setDescription(curCardold.getDescription() == null ? null : curCardold.getDescription());
        bizInfo.setName(curCardold.getName());
        bizInfo.setSpecs(curCardold.getSpecs() == null ? null : curCardold.getSpecs());
        bizInfo.setMeasureUnit(curCardold.getMeasureUnit());
        bizInfo.setAccountAsset(curCardold.getAccountAsset());
        bizInfo.setAmortizeMode(curCardold.getAmortizeMode());
        bizInfo.setUseStatus(curCardold.getUseStatus());
        bizInfo.setLife(curCardold.getLife() == null ? null : curCardold.getLife());
        bizInfo.setAddress(curCardold.getAddress() == null ? null : curCardold.getAddress());
        bizInfo.setStoreAdress(curCardold.getStoreAdress() == null ? null : curCardold.getStoreAdress());
        bizInfo.setUsableAmt(curCardold.getUsableAmt() == null ? this.ZERO : curCardold.getUsableAmt());
        bizInfo.setLocalAmount(curCardold.getLocalAmount() == null ? this.ZERO : curCardold.getLocalAmount());
        bizInfo.setOriginAmount(curCardold.getOriginAmount() == null ? this.ZERO : curCardold.getOriginAmount());
        bizInfo.setUnitPrice(curCardold.getUnitPrice() == null ? this.ZERO : curCardold.getUnitPrice());
        bizInfo.setExRate(curCardold.getExRate() == null ? this.ZERO : curCardold.getExRate());
        bizInfo.setCurrency(curCardold.getCurrency());
        bizInfo.setAssetAmt(curCardold.getAssetAmt() == null ? null : curCardold.getAssetAmt());
        bizInfo.setSourceMode(curCardold.getSourceMode());
        bizInfo.setKeeper(curCardold.getKeeper() == null ? null : curCardold.getKeeper());
        bizInfo.setDept(curCardold.getDept() == null ? null : curCardold.getDept());
        bizInfo.setPArea(curCardold.getPArea() == null ? null : curCardold.getPArea());
        bizInfo.setMfr(curCardold.getMfr() == null ? null : curCardold.getMfr());
        bizInfo.setAccountDate(curCardold.getAccountDate());
        bizInfo.setAssetCat(curCardold.getAssetCat());
        bizInfo.setBuyDate(curCardold.getBuyDate());
        bizInfo.setNumber(curCardold.getNumber());
        bizInfo.setSupplier(curCardold.getSupplier());
        return bizInfo;
    }

    private LCMCurCardInfo otherInfoToCardInfo(LCMCurCardInfo curCard, LCMCardInfo bizInfo) {
        curCard.setDescription(bizInfo.getDescription() == null ? null : bizInfo.getDescription());
        curCard.setName(bizInfo.getName());
        curCard.setSpecs(bizInfo.getSpecs() == null ? null : bizInfo.getSpecs());
        curCard.setMeasureUnit(bizInfo.getMeasureUnit());
        curCard.setAccountAsset(bizInfo.getAccountAsset());
        curCard.setAmortizeMode(bizInfo.getAmortizeMode());
        curCard.setUseStatus(bizInfo.getUseStatus());
        curCard.setLife(bizInfo.getLife() == null ? null : bizInfo.getLife());
        curCard.setAddress(bizInfo.getAddress() == null ? null : bizInfo.getAddress());
        curCard.setStoreAdress(bizInfo.getStoreAdress() == null ? null : bizInfo.getStoreAdress());
        curCard.setUsableAmt(bizInfo.getUsableAmt() == null ? this.ZERO : bizInfo.getUsableAmt());
        curCard.setLocalAmount(bizInfo.getLocalAmount() == null ? this.ZERO : bizInfo.getLocalAmount());
        curCard.setOriginAmount(bizInfo.getOriginAmount() == null ? this.ZERO : bizInfo.getOriginAmount());
        curCard.setUnitPrice(bizInfo.getUnitPrice() == null ? this.ZERO : bizInfo.getUnitPrice());
        curCard.setExRate(bizInfo.getExRate() == null ? this.ZERO : bizInfo.getExRate());
        curCard.setCurrency(bizInfo.getCurrency());
        curCard.setAssetAmt(bizInfo.getAssetAmt() == null ? null : bizInfo.getAssetAmt());
        curCard.setSourceMode(bizInfo.getSourceMode());
        curCard.setKeeper(bizInfo.getKeeper() == null ? null : bizInfo.getKeeper());
        curCard.setDept(bizInfo.getDept() == null ? null : bizInfo.getDept());
        curCard.setPArea(bizInfo.getPArea() == null ? null : bizInfo.getPArea());
        curCard.setMfr(bizInfo.getMfr() == null ? null : bizInfo.getMfr());
        curCard.setAccountDate(bizInfo.getAccountDate());
        curCard.setAssetCat(bizInfo.getAssetCat());
        curCard.setBuyDate(bizInfo.getBuyDate());
        curCard.setNumber(bizInfo.getNumber());
        curCard.setSupplier(bizInfo.getSupplier());
        return curCard;
    }

    private LCMBizCardInfo saveCardToOtherCard(Context ctx, LCMChangeBillEntryInfo entryInfo, LCMCurCardInfo curCardold) throws EASBizException, BOSException {
        LCMBizCardInfo bizInfo = null;
        if (entryInfo != null && entryInfo.getLcmBizCard() != null) {
            bizInfo = entryInfo.getLcmBizCard();
            bizInfo = LCMBizCardFactory.getLocalInstance(ctx).getLCMBizCardInfo((IObjectPK)new ObjectUuidPK(bizInfo.getId().toString()), this.getLcmCardSelectors());
            bizInfo = this.cardInfoChange(bizInfo, curCardold);
            this.updateBizCard(ctx, bizInfo);
        } else {
            String fbizId = BOSUuid.create((String)"0120D218").toString();
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into T_LCM_LCMBizCard(fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime)");
            insertSql.append(" select ");
            insertSql.append("'" + fbizId + "'");
            insertSql.append("  as fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime from T_LCM_LCMCurCard ");
            insertSql.append("  where fid='" + curCardold.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            bizInfo = LCMBizCardFactory.getLocalInstance(ctx).getLCMBizCardInfo((IObjectPK)new ObjectUuidPK(fbizId), this.getLcmCardSelectors());
            bizInfo = this.cardInfoChange(bizInfo, curCardold);
            this.updateBizCard(ctx, bizInfo);
        }
        return bizInfo;
    }

    private void updateBizCard(Context ctx, LCMBizCardInfo bizInfo) throws EASBizException, BOSException {
        LCMBizCardFactory.getLocalInstance(ctx).updatePartial(bizInfo, this.getLcmCardSelectorsForUpdate());
    }

    private LCMChangeBillInfo getAddNewChangeBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            LCMChangeBillInfo changeBillInfo = new LCMChangeBillInfo();
            changeBillInfo.setPeriod((PeriodInfo)model.get("changePeriod"));
            changeBillInfo.setChangeDate((Date)model.get("changeDate"));
            LCMAlterModeInfo modeInfo = null;
            if (model.get("changeMode") != null) {
                modeInfo = (LCMAlterModeInfo)model.get("changeMode");
                modeInfo = LCMAlterModeFactory.getLocalInstance(ctx).getLCMAlterModeInfo((IObjectPK)new ObjectStringPK(modeInfo.getId().toString()));
            }
            changeBillInfo.setChangeMode(modeInfo);
            changeBillInfo.setDescriptionInfo((String)model.get("descriptionInfo"));
            changeBillInfo.setCreator((UserInfo)model.get("prmtCreator"));
            if (model.get("changeNumber") != null) {
                changeBillInfo.setNumber((String)model.get("changeNumber"));
            }
            changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            changeBillInfo.setFiVouchered(false);
            changeBillInfo.setCompany((CompanyOrgUnitInfo)model.get("Company"));
            LCMCurCardInfo curCardold = (LCMCurCardInfo)model;
            if (model.get("changeNumber") == null) {
                changeBillInfo.setNumber(curCardold.getNumber());
            }
            LCMChangeBillEntryInfo entryInfo = new LCMChangeBillEntryInfo();
            entryInfo.setChangeBill(changeBillInfo);
            entryInfo.setLcmCurCard(curCardold);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("blockedStatus"));
            curCardold.setBlockedStatus(BlockedStatusEnum.BLOCKED);
            LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCardold, selector);
            changeBillInfo.getChangeBillEntry().add(entryInfo);
            changeBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            entryInfo.setLcmCurCard(curCardold);
            entryInfo.setLcmBizCard(this.saveCardToOtherCard(ctx, entryInfo, curCardold));
            if (changeBillInfo.getId() == null) {
                this.setNewNumber(ctx, changeBillInfo, 100);
            }
            return changeBillInfo;
        }
        return new LCMChangeBillInfo();
    }

    protected void setNewNumber(Context ctx, LCMChangeBillInfo billInfo, int deepNo) throws EASBizException, BOSException {
        if (deepNo == 0) {
            throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        billInfo.setBizDate(LCMUtils.getBizDate(ctx, aCompanyOrgUnitInfo.getId().toString()));
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo, deepNo - 1);
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = (LCMChangeBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_LCM_LCMCHANGEBILL WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private LCMChangeBillInfo getEditChangeBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            LCMChangeBillEntryInfo entryInfo;
            LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
            changeBillInfo.setPeriod((PeriodInfo)model.get("changePeriod"));
            changeBillInfo.setChangeDate((Date)model.get("changeDate"));
            LCMAlterModeInfo modeInfo = null;
            if (model.get("changeMode") != null) {
                modeInfo = (LCMAlterModeInfo)model.get("changeMode");
                modeInfo = LCMAlterModeFactory.getLocalInstance(ctx).getLCMAlterModeInfo((IObjectPK)new ObjectStringPK(modeInfo.getId().toString()));
            }
            changeBillInfo.setChangeMode(modeInfo);
            changeBillInfo.setDescriptionInfo((String)model.get("descriptionInfo"));
            changeBillInfo.setCreator((UserInfo)model.get("prmtCreator"));
            if (model.get("changeNumber") != null) {
                changeBillInfo.setNumber((String)model.get("changeNumber"));
            }
            if ((entryInfo = changeBillInfo.getChangeBillEntry().get(0)) != null) {
                entryInfo.setLcmBizCard(this.saveCardToOtherCard(ctx, entryInfo, (LCMCurCardInfo)model));
            }
            return changeBillInfo;
        }
        return new LCMChangeBillInfo();
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        this.checkForAudit(ctx, (IObjectValue)billInfo);
        this._passAuditSelf(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        this.checkForUnAudit(ctx, (IObjectValue)billInfo);
        this._unpassAuditSelf(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = LCMChangeBillFactory.getLocalInstance(ctx).getLCMChangeBillInfo(objId).getCompany();
        this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    public void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        LCMChangeBillInfo billInfo = LCMChangeBillFactory.getLocalInstance(ctx).getLCMChangeBillInfo(pk);
        if (billInfo.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = billInfo.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                BigDecimal assetAmtChange;
                LCMBizCardInfo bizInfo;
                LCMCurCardInfo lcmCardInfo;
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                if (entry.getLcmCurCard() == null) continue;
                String lcmCardID = entry.getLcmCurCard().getId().toString();
                if (lcmCardID != null) {
                    lcmCardInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)new ObjectUuidPK(lcmCardID));
                    bizInfo = LCMBizCardFactory.getLocalInstance(ctx).getLCMBizCardInfo((IObjectPK)new ObjectUuidPK(entry.getLcmBizCard().getId().toString()), this.getLcmCardSelectors());
                    LCMBakCardInfo bakCardInfo = null;
                    if (entry.getLcmBakCard() != null) {
                        bakCardInfo = LCMBakCardFactory.getLocalInstance(ctx).getLCMBakCardInfo((IObjectPK)new ObjectUuidPK(entry.getLcmBakCard().getId().toString()));
                    }
                    if (bakCardInfo == null) {
                        String fbakId = BOSUuid.create((String)"F2A6AC91").toString();
                        StringBuffer insertSql = new StringBuffer();
                        insertSql.append("insert into T_LCM_LCMBakCard(fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime)");
                        insertSql.append(" select ");
                        insertSql.append("'" + fbakId + "'");
                        insertSql.append("  as fid,fcontrolunitid,Faccountassetid,Flcmperiodid,Feffectedstatus,Fcheckedstatus,Fdeletedstatus,Fblockedstatus,Ffivouchered,Fvoucherid,Fexrate,Funitprice,Foriginamount,Flocalamount,Flife,Fusestatus,Fdeletednum,Fdeleteddate,Famortizemode,Faccountdate,Fsourcemodeid,Fparea,Fmfr,Fdeptid,Fkeeperid,Faddress,Fassetamt,Fusableamt,Fcurrencyid,Fsourcebillid,Fsourcefunction,Fcompanyid,Fassetcatid,Fname,Fspecs,Fmeasureunitid,Fbuydate,Fnumber,Fbizdate,Fhandlerid,Fdescription,Fhaseffected,Fauditorid,Fcreatorid,Fcreatetime,Flastupdateuserid,fstoreAdress,Flastupdatetime from T_LCM_LCMCurCard");
                        insertSql.append("  where fid='" + lcmCardID + "'");
                        DbUtil.execute((Context)ctx, (String)insertSql.toString());
                        bakCardInfo = LCMBakCardFactory.getLocalInstance(ctx).getLCMBakCardInfo((IObjectPK)new ObjectUuidPK(fbakId));
                    }
                    if (entry.getLcmBakCard() == null) {
                        entry.setLcmBakCard(bakCardInfo);
                    }
                    SelectorItemCollection entrySic = new SelectorItemCollection();
                    entrySic.add(new SelectorItemInfo("lcmBakCard"));
                    entrySic.add(new SelectorItemInfo("accountChange"));
                    entrySic.add(new SelectorItemInfo("accountAssetChange"));
                    if (bizInfo.getOriginAmount() != null && lcmCardInfo.getOriginAmount() != null) {
                        if (bizInfo.getOriginAmount().compareTo(lcmCardInfo.getOriginAmount()) != 0) {
                            if (bizInfo.getOriginAmount().compareTo(lcmCardInfo.getOriginAmount()) == 1) {
                                entry.setAccountChange(bizInfo.getOriginAmount().subtract(lcmCardInfo.getOriginAmount()));
                            } else {
                                entry.setAccountChange(lcmCardInfo.getOriginAmount().subtract(bizInfo.getOriginAmount()));
                            }
                        } else {
                            entry.setAccountChange(new BigDecimal("0.00"));
                        }
                    }
                    if (bizInfo.getAccountAsset() == null && lcmCardInfo.getAccountAsset() != null || bizInfo.getAccountAsset() != null && lcmCardInfo.getAccountAsset() == null) {
                        entry.setAccountAssetChange(1);
                    }
                    if (bizInfo.getAccountAsset() != null && lcmCardInfo.getAccountAsset() != null) {
                        if (bizInfo.getAccountAsset().getId().toString().equals(lcmCardInfo.getAccountAsset().getId().toString())) {
                            entry.setAccountAssetChange(0);
                        } else {
                            entry.setAccountAssetChange(1);
                        }
                    }
                    LCMChangeBillEntryFactory.getLocalInstance(ctx).updatePartial(entry, entrySic);
                    assetAmtChange = new BigDecimal("0.00");
                    if (bizInfo.getUsableAmt() != null && lcmCardInfo.getAssetAmt() != null) {
                        assetAmtChange = bizInfo.getAssetAmt().subtract(lcmCardInfo.getAssetAmt());
                    }
                } else {
                    return;
                }
                BigDecimal currUsableAmt = lcmCardInfo.getUsableAmt();
                LCMUseStatusEnum useState = lcmCardInfo.getUseStatus();
                lcmCardInfo = this.otherInfoToCardInfo(lcmCardInfo, bizInfo);
                lcmCardInfo.setUsableAmt(currUsableAmt.add(assetAmtChange));
                lcmCardInfo.setUseStatus(useState);
                lcmCardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
                SelectorItemCollection updatesic = this.getLcmCardSelectorsForUpdate();
                lcmCardInfo.setSourceBillId(billInfo.getId().toString());
                updatesic.add(new SelectorItemInfo("blockedStatus"));
                LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)lcmCardInfo, updatesic);
                cardSet.add(lcmCardID);
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = new Date();
        billInfo.setBizDate(today);
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("auditor"));
        sic1.add(new SelectorItemInfo("bizDate"));
        sic1.add(new SelectorItemInfo("checkedStatus"));
        this.updatePartial(ctx, billInfo, sic1);
    }

    @Override
    public void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        LCMChangeBillInfo billInfo = LCMChangeBillFactory.getLocalInstance(ctx).getLCMChangeBillInfo(pk);
        if (billInfo.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = billInfo.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                BigDecimal assetAmtChange;
                LCMBakCardInfo bakCardInfo;
                LCMCurCardInfo lcmCardInfo;
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                if (entry.getLcmCurCard() == null) continue;
                String lcmCardID = entry.getLcmCurCard().getId().toString();
                if (lcmCardID != null && entry.getLcmBakCard() != null) {
                    lcmCardInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)new ObjectUuidPK(lcmCardID));
                    bakCardInfo = LCMBakCardFactory.getLocalInstance(ctx).getLCMBakCardInfo((IObjectPK)new ObjectUuidPK(entry.getLcmBakCard().getId().toString()), this.getLcmCardSelectors());
                    assetAmtChange = new BigDecimal("0.00");
                    if (bakCardInfo.getUsableAmt() != null && lcmCardInfo.getAssetAmt() != null) {
                        assetAmtChange = lcmCardInfo.getAssetAmt().subtract(bakCardInfo.getAssetAmt());
                    }
                } else {
                    return;
                }
                BigDecimal currUsableAmt = lcmCardInfo.getUsableAmt();
                LCMUseStatusEnum useState = lcmCardInfo.getUseStatus();
                lcmCardInfo = this.otherInfoToCardInfo(lcmCardInfo, bakCardInfo);
                lcmCardInfo.setUsableAmt(currUsableAmt.subtract(assetAmtChange));
                lcmCardInfo.setUseStatus(useState);
                lcmCardInfo.setBlockedStatus(BlockedStatusEnum.BLOCKED);
                SelectorItemCollection updatesic = this.getLcmCardSelectorsForUpdate();
                updatesic.add(new SelectorItemInfo("blockedStatus"));
                LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)lcmCardInfo, updatesic);
                cardSet.add(lcmCardID);
            }
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setBizDate(null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        this.updatePartial(ctx, billInfo, sic);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        if (EffectedStatusEnum.EFFECTED.equals((Object)billInfo.getEffectedStatus())) {
            String msg = this.getEffectedStatus(billInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = (LCMChangeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 4);
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = (LCMChangeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer();
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)billInfo.getCompany());
        PeriodInfo lcmPeriod = billInfo.getPeriod();
        if (!lcmPeriod.getId().toString().equals(curPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        if (billInfo.isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasGenVoucher.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 5);
        StringBuffer sbHasChangeInfo = new StringBuffer(ResourceBase.getString((String)LCMChangeBillResource, (String)"Has_change", (Locale)ctx.getOriginLocale()));
        if (billInfo.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = billInfo.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("sourceBillId"));
                ObjectUuidPK pk = new ObjectUuidPK(entry.getLcmCurCard().getId().toString());
                LCMCurCardInfo curCard = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)pk, sic);
                if (curCard != null && curCard.getSourceBillId() != null && !curCard.getSourceBillId().equals(entry.getChangeBill().getId().toString())) {
                    throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasChangeInfo.toString()});
                }
                this.checkForConsume(ctx, (IObjectPK)pk, billInfo.getBizDate());
                this.checkForDiscard(ctx, (IObjectPK)pk, billInfo.getBizDate());
            }
        }
    }

    private void checkForConsume(Context ctx, IObjectPK pk, Date changeDate) throws BOSException, EASBizException {
        StringBuffer sbHasConsumeInfo = new StringBuffer(ResourceBase.getString((String)LCMChangeBillResource, (String)"Has_Consume", (Locale)ctx.getOriginLocale()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bizDate"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCard", (Object)pk.toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("bill"));
        ILCMConsumeBill consumeBill = LCMConsumeBillFactory.getLocalInstance(ctx);
        LCMConsumeBillEntryCollection consumeCollection = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryCollection(view);
        Iterator it = consumeCollection.iterator();
        while (it.hasNext()) {
            LCMConsumeBillInfo consumeBillInfo;
            Date bizDate;
            LCMConsumeBillEntryInfo entryInfo = (LCMConsumeBillEntryInfo)it.next();
            ObjectUuidPK consumePK = new ObjectUuidPK(entryInfo.getBill().getId().toString());
            if (consumePK == null || (bizDate = (consumeBillInfo = consumeBill.getLCMConsumeBillInfo((IObjectPK)consumePK, sic)).getBizDate()) == null || changeDate.compareTo(bizDate) >= 0) continue;
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasConsumeInfo.toString()});
        }
    }

    private void checkForDiscard(Context ctx, IObjectPK pk, Date changeDate) throws BOSException, EASBizException {
        StringBuffer sbHasDiscardInfo = new StringBuffer(ResourceBase.getString((String)LCMChangeBillResource, (String)"Has_Discard", (Locale)ctx.getOriginLocale()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditDate"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCard", (Object)pk.toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("bill"));
        ILCMDiscardBill discardBill = LCMDiscardBillFactory.getLocalInstance(ctx);
        LCMDiscardBillEntryCollection discardCollection = LCMDiscardBillEntryFactory.getLocalInstance(ctx).getLCMDiscardBillEntryCollection(view);
        Iterator it = discardCollection.iterator();
        while (it.hasNext()) {
            LCMDiscardBillInfo consumeBillInfo;
            Date bizDate;
            LCMDiscardBillEntryInfo entryInfo = (LCMDiscardBillEntryInfo)it.next();
            ObjectUuidPK consumePK = new ObjectUuidPK(entryInfo.getBill().getId().toString());
            if (consumePK == null || (bizDate = (consumeBillInfo = discardBill.getLCMDiscardBillInfo((IObjectPK)consumePK, sic)).getAuditDate()) == null || changeDate.compareTo(bizDate) >= 0) continue;
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasDiscardInfo.toString()});
        }
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 0);
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.addnew(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        this.checkStateForDel(ctx, pk);
        LCMChangeBillInfo changeBill = LCMChangeBillFactory.getLocalInstance(ctx).getLCMChangeBillInfo(pk);
        if (changeBill != null && changeBill.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = changeBill.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                if (entry.getLcmBizCard() != null && entry.getLcmCurCard() != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("sourceBillId"));
                    LCMBizCardInfo bizInfo = LCMBizCardFactory.getLocalInstance(ctx).getLCMBizCardInfo((IObjectPK)new ObjectUuidPK(entry.getLcmBizCard().getId().toString()), sic);
                    LCMCurCardInfo curCard = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)new ObjectUuidPK(entry.getLcmCurCard().getId().toString()), sic);
                    this.bakSourcebillIDFromBizcard(ctx, curCard, bizInfo);
                }
                if (entry.getLcmBakCard() != null) {
                    StringBuffer deleteBakSql = new StringBuffer();
                    deleteBakSql.append("delete from  t_lcm_lcmbakcard ");
                    deleteBakSql.append("  where fid='" + entry.getLcmBakCard().getId().toString() + "'");
                    DbUtil.execute((Context)ctx, (String)deleteBakSql.toString());
                }
                if (entry.getLcmBizCard() != null) {
                    StringBuffer deleteBizSql = new StringBuffer();
                    deleteBizSql.append("delete from  t_lcm_lcmbizcard ");
                    deleteBizSql.append("  where fid='" + entry.getLcmBizCard().getId().toString() + "'");
                    DbUtil.execute((Context)ctx, (String)deleteBizSql.toString());
                }
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("update t_lcm_lcmcurcard set fblockedstatus=1");
                if (entry.getLcmCurCard() != null) {
                    insertSql.append("  where fid='" + entry.getLcmCurCard().getId().toString() + "'");
                    DbUtil.execute((Context)ctx, (String)insertSql.toString());
                    StringBuffer entrySql = new StringBuffer();
                    entrySql.append("delete from  t_lcm_lcmchangebillentry ");
                    if (entry.getChangeBill() != null) {
                        entrySql.append("  where fchangebillid='" + entry.getChangeBill().getId().toString() + "'");
                        DbUtil.execute((Context)ctx, (String)entrySql.toString());
                    }
                }
                if (entry.getLcmCurCard() == null || entry.getLcmCurCard().getId() == null) continue;
                cardSet.add(entry.getLcmCurCard().getId());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, changeBill.getCompany(), cardSet);
        }
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from  t_lcm_lcmchangebill ");
        deleteSql.append("  where fid='" + pk.toString() + "'");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        this.recycleNumber(ctx, changeBill);
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        Iterator iter = sourceBillCollection.iterator();
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(((LCMChangeBillInfo)iter.next()).getId());
            String tempMsg = this.checkForGenerateVoucher(ctx, (IObjectPK)pk);
            this.checkForVoucherByLocalAmount(ctx, (IObjectPK)pk);
            if (tempMsg.trim().length() > 0) {
                iter.remove();
                msg.append(tempMsg);
            }
            if (msg.toString().trim().length() <= 0) continue;
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        msg.append(this.checkForGenerateVoucher(ctx, sourceBillPk));
        if (msg.toString().trim().length() > 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            this.checkForGenerateVoucher(ctx, sourceBillPkList[i]);
        }
        super._generateVoucher(ctx, sourceBillPkList);
    }

    protected String checkForGenerateVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        return sbMsg.toString();
    }

    private void checkForVoucherByLocalAmount(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMChangeBillInfo billInfo = this.getLCMChangeBillInfo(ctx, pk);
        if (billInfo != null && billInfo.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = billInfo.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                StringBuffer msg = new StringBuffer("");
                if (entry.getAccountChange() != null && entry.getAccountChange().compareTo(new BigDecimal("0.00")) == 0 && entry.getAccountAssetChange() == 0) {
                    msg.append(ResourceBase.getString((String)LCMChangeBillResource, (String)"AccountNoChange", (Locale)ctx.getOriginLocale()));
                }
                if (msg.toString().trim().length() <= 0) continue;
                throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
            }
        }
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        this.setBlock(ctx, model);
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            this.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            return retValue;
        }
        IObjectPK retValue = this.addnew(ctx, coreBaseInfo);
        return retValue;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        LCMChangeBillInfo info = (LCMChangeBillInfo)(srcBillVO instanceof LCMChangeBillInfo ? srcBillVO : srcBillVO.get("changeBill"));
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            DbUtil.execute((Context)ctx, (String)"update t_lcm_lcmchangebill set ffivouchered=1 where fid = ?", (Object[])new Object[]{info.getId().toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            DbUtil.execute((Context)ctx, (String)"update t_lcm_lcmchangebill set ffivouchered=0 where fid = ?", (Object[])new Object[]{info.getId().toString()});
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller, String bindingproperty, String customString) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID, bindingproperty) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID, bindingproperty)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, bindingproperty, customString, caller.getNumber());
        }
    }

    private void setBlock(Context ctx, IObjectValue model) throws BOSException {
        LCMChangeBillInfo billInfo = (LCMChangeBillInfo)model;
        if (billInfo.getChangeBillEntry() != null) {
            LCMChangeBillEntryCollection billEntries = billInfo.getChangeBillEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMChangeBillEntryInfo entry = (LCMChangeBillEntryInfo)iter.next();
                if (entry.getLcmCurCard().getId().toString().trim().length() == 0) continue;
                String entryID = entry.getLcmCurCard().getId().toString();
                String sql = "update t_lcm_lcmcurcard set FBlockedStatus =  2  where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }
}

