/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.NBgControlCallerUtil;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.LCMAmortizeModeEnum;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillException;
import com.kingdee.eas.fi.lcm.LCMConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMUseTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMConsumeBillControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class LCMConsumeBillControllerBean
extends AbstractLCMConsumeBillControllerBean {
    private static final long serialVersionUID = -4762022493991172781L;
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    protected static final String LCMCONSUMERESOURCE = "com.kingdee.eas.fi.lcm.LCMConsumeBillResource";
    private boolean isUseWorkflow;
    private int recursiveNumber = 0;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.curCard.id"));
        selector.add(new SelectorItemInfo("entry.srcBillEntry.id"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk, selector);
        this.checkForAudit(ctx, (IObjectValue)billInfo);
        this._passAuditSelf(ctx, pk, new LCMConsumeBillInfo());
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("period.*"));
        selector.add(new SelectorItemInfo("entry.initUseQuantity"));
        selector.add(new SelectorItemInfo("entry.quantity"));
        selector.add(new SelectorItemInfo("entry.srcBillEntry.bill.blockedStatus"));
        selector.add(new SelectorItemInfo("entry.curCard.id"));
        selector.add(new SelectorItemInfo("entry.srcBillEntry.id"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk, selector);
        this.checkForUnAudit(ctx, (IObjectValue)billInfo);
        this._unpassAuditSelf(ctx, pk, billInfo);
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IRowSet rs;
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer();
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        PeriodInfo lcmPeriod = billInfo.getPeriod();
        if (!curPeriod.getId().toString().equals(lcmPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        if (billInfo.isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasGenVoucher.toString()});
        }
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)"select 1 from T_LCM_LCMConsumeBill b inner join T_LCM_LCMConsumeBillEntry e on b.fid=e.fbillid inner join t_lcm_discardbillentry de on de.FConsumeEntryID=e.fid where b.fid = ?", (Object[])new Object[]{billInfo.getId().toString()});
            if (rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.cannotDiscard", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)"select 1 from T_LCM_LCMConsumeBill b inner join T_LCM_LCMReturnConsumeEntry e on e.FConsumebillID=b.fid where b.fid = ?", (Object[])new Object[]{billInfo.getId().toString()});
            if (rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.cannotReturn", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (billInfo.getBlockedStatus().equals((Object)BlockedStatusEnum.BLOCKED)) {
            StringBuffer sbHasUsed = new StringBuffer(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"hasBlocked", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasUsed.toString()});
        }
        LCMConsumeBillEntryCollection entries = billInfo.getEntry();
        StringBuffer sbHasUsed = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"consumeBillHasUsed", (Locale)ctx.getOriginLocale()));
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            BlockedStatusEnum blockStatus;
            LCMConsumeBillEntryInfo entryInfo = (LCMConsumeBillEntryInfo)iter.next();
            if (entryInfo.getInitUseQuantity() != null && entryInfo.getQuantity().compareTo(entryInfo.getInitUseQuantity()) < 0) {
                throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasUsed.toString()});
            }
            if (entryInfo.getSrcBillEntry() == null || entryInfo.getSrcBillEntry().getBill() == null || (blockStatus = entryInfo.getSrcBillEntry().getBill().getBlockedStatus()) == null || !blockStatus.equals((Object)BlockedStatusEnum.BLOCKED)) continue;
            StringBuffer info = new StringBuffer(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"referBillBlocked", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", info.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 5);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMConsumeBill set FFiVouchered = 1, FVoucherID = ? where fid = ? ", (Object[])new Object[]{voucher.getId().toString(), srcBillPK.toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMConsumeBill set FFiVouchered = 0, FVoucherID = null where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
        }
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)billInfo.getCompany());
        PeriodInfo lcmPeriod = billInfo.getPeriod();
        if (lcmPeriod == null || !curPeriod.getId().equals((Object)lcmPeriod.getId())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 4);
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        this.checkStateForDel(ctx, pk);
        this._deleteSelf(ctx, pk);
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.curCard.id"));
        sic.add(new SelectorItemInfo("entry.srcBillEntry.id"));
        LCMConsumeBillInfo billInfo = LCMConsumeBillFactory.getLocalInstance(ctx).getLCMConsumeBillInfo(pk, sic);
        if (billInfo.getEntry() != null) {
            Iterator it = billInfo.getEntry().iterator();
            while (it.hasNext()) {
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)it.next();
                if (entry == null || entry.getSrcBillEntry() != null || entry.getCurCard() == null || entry.getCurCard().getId() == null) continue;
                cardSet.add(entry.getCurCard().getId());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
        super._delete(ctx, pk);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            this.checkStateForDel(ctx, arrayPK[i]);
        }
        this._deleteSelf(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 0);
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        LCMConsumeBillInfo billInfo = LCMConsumeBillFactory.getLocalInstance(ctx).getLCMConsumeBillInfo(pk, sic);
        this.recycleNumber(ctx, billInfo);
        this.releaseBlock(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        for (int i = 0; i < arrayPK.length; ++i) {
            IObjectPK pk = arrayPK[i];
            LCMConsumeBillInfo billInfo = LCMConsumeBillFactory.getLocalInstance(ctx).getLCMConsumeBillInfo(pk, sic);
            this.recycleNumber(ctx, billInfo);
            this.releaseBlock(ctx, pk);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        Iterator iter = sourceBillCollection.iterator();
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(((LCMConsumeBillInfo)iter.next()).getId());
            String tempMsg = this.checkForGenerateVoucher(ctx, (IObjectPK)pk);
            if (tempMsg.trim().length() <= 0) continue;
            iter.remove();
            msg.append(tempMsg);
        }
        if (sourceBillCollection.size() > 0) {
            return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        }
        if (msg.toString().trim().length() > 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        return null;
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        msg.append(this.checkForGenerateVoucher(ctx, sourceBillPk));
        if (msg.toString().trim().length() > 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        super._generateVoucher(ctx, sourceBillPkList);
    }

    protected String checkForGenerateVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BigDecimal ZERO;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("blockedStatus"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("effectedStatus"));
        selector.add(new SelectorItemInfo("entry.*"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        LCMConsumeBillEntryCollection entries = billInfo.getEntry();
        BigDecimal total = ZERO = new BigDecimal("0.00");
        boolean isFromConsumeBill = false;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
            total = total.add(entry.getInitUseAmount() == null ? ZERO : entry.getInitUseAmount());
            if (entry.getSrcBillEntry() == null) continue;
            isFromConsumeBill = true;
        }
        if (ZERO.compareTo(total) >= 1) {
            sbMsg.append(" ");
            sbMsg.append(new StringBuffer(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"totalAmountIsZero", (Locale)ctx.getOriginLocale())));
        }
        if (isFromConsumeBill) {
            sbMsg.append(" ");
            sbMsg.append(new StringBuffer(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"fromBillNotGenVoucher", (Locale)ctx.getOriginLocale())));
        }
        StringBuffer sbAll = new StringBuffer("");
        if (sbMsg.toString().length() > 0) {
            sbAll = new StringBuffer(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"numberIsZero", (Locale)ctx.getOriginLocale()));
            sbAll.append(billInfo.getNumber() + " ");
            sbAll.append(sbMsg);
        }
        return sbAll.toString();
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, LCMConsumeBillInfo model) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.curCard.id"));
        sic.add(new SelectorItemInfo("entry.srcBillEntry.id"));
        LCMConsumeBillInfo billInfo = LCMConsumeBillFactory.getLocalInstance(ctx).getLCMConsumeBillInfo(pk, sic);
        if (billInfo.getEntry() != null) {
            LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
            this.cancelBudget(ctx, billInfo);
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
                if (entry.getSrcBillEntry() == null) {
                    String cardID = entry.getCurCard().getId().toString();
                    BigDecimal requireAmt = entry.getQuantity();
                    String sql = "update T_LCM_LCMCurCard set fusableamt =  fusableamt+ " + requireAmt.toString() + " where fid = '" + cardID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "update T_LCM_LCMCurCard set FUseStatus = 0  where fid = '" + cardID + "' and fusableamt = FAssetAmt";
                    DbUtil.execute((Context)ctx, (String)sql);
                    cardSet.add(cardID);
                    continue;
                }
                if (entry.getSrcBillEntry().getId().toString().trim().length() == 0) continue;
                String entryID = entry.getSrcBillEntry().getId().toString();
                BigDecimal requireQuantity = entry.getQuantity();
                BigDecimal requireAmt = entry.getUseAmount();
                BigDecimal amortizedAmount = entry.getAmortizedAmount();
                BigDecimal amortizeAmount = entry.getAmortizeAmount();
                String sql = "update T_LCM_LCMConsumeBillEntry set FQuantity =  FQuantity+ " + requireQuantity + " where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "update T_LCM_LCMConsumeBillEntry set FLeftQuantity = FLeftQuantity + " + requireQuantity + " where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "update T_LCM_LCMConsumeBillEntry set FUseAmount =  FUseAmount+ " + requireAmt + " where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "update T_LCM_LCMConsumeBillEntry set FAmortizedAmount =  FAmortizedAmount+ " + amortizedAmount + " where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "update T_LCM_LCMConsumeBillEntry set FAmortizeAmount =  FAmortizeAmount+ " + amortizeAmount + " where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "UPDATE T_LCM_LCMConsumeBillEntry SET ";
                sql = sql + "fbeConsumeQty = fbeConsumeQty+(select sub.fbeConsumeQty from T_LCM_LCMConsumeBillEntry sub ";
                sql = sql + "where  sub.fid='" + entry.getId().toString() + "";
                sql = sql + "'),fBeConsumeAmt=fBeConsumeAmt+(select sub.fBeConsumeAmt from T_LCM_LCMConsumeBillEntry sub ";
                sql = sql + "where  sub.fid='" + entry.getId().toString() + "";
                sql = sql + "')  WHERE fID = '" + entry.getSrcBillEntry().getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        this.setBlock(ctx, (IObjectValue)billInfo);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setBizDate(null);
        super._unpassAudit(ctx, pk, (IObjectValue)billInfo);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
    }

    private void cancelBudget(Context ctx, LCMConsumeBillInfo billInfo) throws EASBizException, BOSException {
        if (LCMUseTypeEnum.OTHER.equals((Object)billInfo.getUseType())) {
            return;
        }
        NBgControlCallerUtil.returnBudget((Context)ctx, (BOSUuid)billInfo.getId());
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, LCMConsumeBillInfo model) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.curCard.id"));
        sic.add(new SelectorItemInfo("entry.curCard.amortizeMode"));
        sic.add(new SelectorItemInfo("entry.curCard.localAmount"));
        sic.add(new SelectorItemInfo("entry.curCard.unitPrice"));
        sic.add(new SelectorItemInfo("entry.curCard.assetAmt"));
        sic.add(new SelectorItemInfo("entry.curCard.exRate"));
        sic.add(new SelectorItemInfo("entry.curCard.currency.id"));
        sic.add(new SelectorItemInfo("entry.curCard.usableAmt"));
        sic.add(new SelectorItemInfo("entry.srcBillEntry.*"));
        LCMConsumeBillInfo billInfo = LCMConsumeBillFactory.getLocalInstance(ctx).getLCMConsumeBillInfo(pk, sic);
        int scale = this.getCurrencyScale(billInfo.getCompany());
        if (billInfo.getEntry() != null) {
            LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
            this.updateBudgetCtrl(ctx, billInfo);
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
                if (entry.getSrcBillEntry() == null) {
                    BigDecimal requireAmt;
                    LCMCurCardInfo lCMCurCardInfo = entry.getCurCard();
                    String cardID = entry.getCurCard().getId().toString();
                    BigDecimal useableAmt = entry.getCurCard().getUsableAmt();
                    if (useableAmt.compareTo(requireAmt = entry.getQuantity()) >= 0) {
                        String sql = "update T_LCM_LCMCurCard set fusableamt = " + useableAmt.subtract(requireAmt).toString() + " ,FUseStatus = 1  where fid = '" + cardID + "' ";
                        DbUtil.execute((Context)ctx, (String)sql);
                        if (useableAmt.compareTo(requireAmt) == 0) {
                            LCMAmortizeModeEnum amortizeMode = lCMCurCardInfo.getAmortizeMode();
                            BigDecimal useAmount = entry.getUseAmount();
                            if (amortizeMode.equals((Object)LCMAmortizeModeEnum.EQUAL_SPILT)) {
                                BigDecimal amortizedAmount = useAmount.multiply(new BigDecimal(0.5)).setScale(scale, 4);
                                entry.setAmortizeAmount(this.formatBigDecmal(useAmount.subtract(amortizedAmount), scale));
                                entry.setInitAmortizeAmount(this.formatBigDecmal(useAmount.subtract(amortizedAmount), scale));
                                entry.setAmortizedAmount(this.formatBigDecmal(amortizedAmount, scale));
                                entry.setInitAmortizedAmount(this.formatBigDecmal(amortizedAmount, scale));
                            } else {
                                entry.setAmortizedAmount(this.formatBigDecmal(useAmount, scale));
                                entry.setInitAmortizedAmount(this.formatBigDecmal(useAmount, scale));
                            }
                            entry.setUseAmount(this.formatBigDecmal(useAmount, scale));
                            entry.setInitUseAmount(this.formatBigDecmal(useAmount, scale));
                            entry.setBeConsumeAmt(this.formatBigDecmal(useAmount, scale));
                        }
                    } else {
                        throw new LCMConsumeBillException(LCMConsumeBillException.USEABLEAMTINSUFFICIENT);
                    }
                    cardSet.add(cardID);
                    continue;
                }
                if (entry.getSrcBillEntry().getId().toString().trim().length() == 0) continue;
                String entryID = entry.getSrcBillEntry().getId().toString();
                BigDecimal originQuantity = entry.getSrcBillEntry().getQuantity();
                BigDecimal requireAmt = entry.getUseAmount();
                BigDecimal requireQuantity = entry.getQuantity();
                BigDecimal requireamortizedAmt = entry.getAmortizedAmount();
                BigDecimal requireamortizeAmt = entry.getAmortizeAmount();
                if (originQuantity.compareTo(requireQuantity) >= 0) {
                    String sql = "update T_LCM_LCMConsumeBillEntry set FQuantity = FQuantity - " + requireQuantity + " where fid = '" + entryID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = originQuantity.compareTo(requireQuantity) == 0 ? "update T_LCM_LCMConsumeBillEntry set FUseAmount = 0 where fid = '" + entryID + "' " : "update T_LCM_LCMConsumeBillEntry set FUseAmount = FUseAmount - " + requireAmt + " where fid = '" + entryID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "update T_LCM_LCMConsumeBillEntry set FLeftQuantity = FLeftQuantity - " + requireQuantity + " where fid = '" + entryID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "update T_LCM_LCMConsumeBillEntry set FAmortizedAmount = FAmortizedAmount -" + requireamortizedAmt + " where fid = '" + entryID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "update T_LCM_LCMConsumeBillEntry set FAmortizeAmount = FAmortizeAmount -" + requireamortizeAmt + " where fid = '" + entryID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = "UPDATE T_LCM_LCMConsumeBillEntry SET ";
                    sql = sql + "fbeConsumeQty = fbeConsumeQty-(select sub.fbeConsumeQty from T_LCM_LCMConsumeBillEntry sub ";
                    sql = sql + "where  sub.fid='" + entry.getId().toString() + "";
                    sql = sql + "'),fBeConsumeAmt=fBeConsumeAmt-(select sub.fBeConsumeAmt from T_LCM_LCMConsumeBillEntry sub ";
                    sql = sql + "where  sub.fid='" + entry.getId().toString() + "";
                    sql = sql + "')  WHERE fID = '" + entry.getSrcBillEntry().getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    continue;
                }
                throw new LCMConsumeBillException(LCMConsumeBillException.USEABLEAMTINSUFFICIENT);
            }
        }
        this.releaseBlock(ctx, pk);
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = new Date();
        billInfo.setBizDate(today);
        super._passAudit(ctx, pk, (IObjectValue)billInfo);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
    }

    private BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(ZERO) == 0) {
            data = ZERO;
        }
        return data.setScale(scale, 4);
    }

    private int getCurrencyScale(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getRemoteInstance().getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForSubmit(ctx, model);
        String pk = model.get("id") == null ? null : model.get("id").toString();
        LCMBillBizProcessor.lockTable(ctx, pk);
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        this.noCheckoutCanAddCard(ctx, billInfo);
        if (billInfo.getId() == null) {
            this.checkForBlock(ctx, (IObjectValue)billInfo);
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 3);
        this.checkUseableAmtSufficient(ctx, billInfo);
        this.releasePartialBlock(ctx, (IObjectValue)billInfo);
        this.setBlock(ctx, (IObjectValue)billInfo);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
        Iterator iter = billEntries.iterator();
        while (iter.hasNext()) {
            LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
            entry.setUseAmount(entry.getBeConsumeAmt());
            entry.setQuantity(entry.getBeConsumeQty());
        }
        return super._submit(ctx, model);
    }

    private void checkUseableAmtSufficient(Context ctx, LCMConsumeBillInfo billInfo) throws EASBizException, BOSException {
        LCMConsumeBillEntryCollection entries = billInfo.getEntry();
        SelectorItemCollection cardSic = new SelectorItemCollection();
        cardSic.add(new SelectorItemInfo("id"));
        cardSic.add(new SelectorItemInfo("usableAmt"));
        SelectorItemCollection entrySic = new SelectorItemCollection();
        entrySic.add(new SelectorItemInfo("*"));
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
            if (entry.getSrcBillEntry() == null) {
                ObjectUuidPK cardPK = new ObjectUuidPK(entry.getCurCard().getId());
                LCMCurCardInfo cardInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)cardPK, cardSic);
                if (cardInfo == null || cardInfo.getUsableAmt().compareTo(entry.getBeConsumeQty()) != -1) continue;
                throw new LCMConsumeBillException(LCMConsumeBillException.USEABLEAMTINSUFFICIENT);
            }
            if (entry.getSrcBillEntry().getId().toString().trim().length() == 0) continue;
            ObjectUuidPK entryPK = new ObjectUuidPK(entry.getSrcBillEntry().getId());
            LCMConsumeBillEntryInfo srcEntryInfo = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryInfo((IObjectPK)entryPK, entrySic);
            if (srcEntryInfo == null || srcEntryInfo.getBeConsumeQty().compareTo(entry.getBeConsumeQty()) != -1) continue;
            throw new LCMConsumeBillException(LCMConsumeBillException.USEABLEAMTINSUFFICIENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            if (caller.getNumber() == null) {
                return;
            }
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        LCMBillBizProcessor.lockTable(ctx, pk);
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        this.noCheckoutCanAddCard(ctx, billInfo);
        if (billInfo.getId() == null) {
            this.checkForBlock(ctx, (IObjectValue)billInfo);
        } else if (billInfo.getId() != null) {
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 1);
        this.releasePartialBlock(ctx, model);
        this.setBlock(ctx, (IObjectValue)billInfo);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
        Iterator iter = billEntries.iterator();
        while (iter.hasNext()) {
            LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
            entry.setUseAmount(entry.getBeConsumeAmt());
            entry.setQuantity(entry.getBeConsumeQty());
            if (entry.getLeftQuantity() != null) continue;
            entry.setLeftQuantity(new BigDecimal("0"));
        }
        return super._save(ctx, model);
    }

    private void noCheckoutCanAddCard(Context ctx, LCMConsumeBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = billInfo.getCompany();
        if (currentCompany == null) {
            currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        HashMap lcmParam = LCMUtils.getLCMParameter(currentCompany.getId(), ctx);
        PeriodInfo curPeriod = LCMUtils.getLCMCurrentPeriod(currentCompany.getId().toString(), ctx);
        String canAddCard = (String)lcmParam.get("LCM_014");
        if (canAddCard == null || canAddCard.trim().length() == 0 || canAddCard.trim().equalsIgnoreCase("false")) {
            billInfo.setPeriod(curPeriod);
        } else {
            boolean billType = false;
            Date accDate = null;
            Date compareDate = null;
            if (billInfo.getEntry() != null) {
                LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
                Iterator iter = billEntries.iterator();
                while (iter.hasNext()) {
                    LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
                    if (entry.getSrcBillEntry() == null) {
                        billType = true;
                    }
                    compareDate = entry.getCurCard().getAccountDate();
                    if (accDate != null && (accDate == null || compareDate == null || !accDate.before(compareDate))) continue;
                    accDate = compareDate;
                }
            }
            if (billType) {
                Date useDate = billInfo.getUseDate();
                if (accDate != null) {
                    PeriodInfo accPeriod = PeriodUtils.getPeriodInfo((Context)ctx, accDate, (CompanyOrgUnitInfo)currentCompany);
                    Date date = accDate = accPeriod == null ? accDate : accPeriod.getBeginDate();
                    if (useDate != null && useDate.before(accDate)) {
                        throw new LCMConsumeBillException(LCMConsumeBillException.USEDATE_BIGGERTHAN_ACCDATE);
                    }
                }
                if (useDate != null) {
                    PeriodInfo newPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)useDate, (CompanyOrgUnitInfo)currentCompany);
                    if (newPeriod == null) {
                        throw new LCMConsumeBillException(LCMConsumeBillException.USEDATE_NOTIN_SYSTEMPERIOD);
                    }
                    billInfo.setPeriod(newPeriod);
                } else {
                    billInfo.setPeriod(curPeriod);
                }
            } else {
                billInfo.setPeriod(curPeriod);
            }
        }
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk);
        if (EffectedStatusEnum.EFFECTED.equals((Object)billInfo.getEffectedStatus())) {
            String msg = this.getEffectedStatus(billInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private void checkForBlock(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        if (billInfo.getEntry() != null) {
            LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
            LCMCurCardInfo cardInfo = null;
            SelectorItemCollection cardSic = new SelectorItemCollection();
            cardSic.add(new SelectorItemInfo("id"));
            cardSic.add(new SelectorItemInfo("number"));
            cardSic.add(new SelectorItemInfo("blockedStatus"));
            SelectorItemCollection entrySic = new SelectorItemCollection();
            entrySic.add(new SelectorItemInfo("id"));
            entrySic.add(new SelectorItemInfo("bill.blockedStatus"));
            boolean hasBlockedCard = false;
            StringBuffer sbAll = new StringBuffer("");
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
                if (entry.getSrcBillEntry() == null) {
                    ObjectUuidPK cardPK = new ObjectUuidPK(entry.getCurCard().getId());
                    cardInfo = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardInfo((IObjectPK)cardPK, cardSic);
                    if (cardInfo != null && cardInfo.getBlockedStatus().getValue() == 2) {
                        hasBlockedCard = true;
                        sbAll.append(" " + billInfo.getNumber() + " \n");
                    }
                    if (!hasBlockedCard) continue;
                    StringBuffer sbMsg = new StringBuffer("");
                    sbMsg.append(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"blockedCardNum", (Locale)ctx.getOriginLocale()));
                    sbMsg.append(sbAll);
                    sbMsg.append(" " + ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"isBlocking", (Locale)ctx.getOriginLocale()));
                    throw new LCMConsumeBillException(LCMConsumeBillException.HASBLOCKEDCARD, new String[]{sbAll.toString()});
                }
                if (entry.getSrcBillEntry().getId().toString().trim().length() == 0) continue;
                ObjectUuidPK entryPK = new ObjectUuidPK(entry.getSrcBillEntry().getId());
                LCMConsumeBillEntryInfo srcEntryInfo = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryInfo((IObjectPK)entryPK, entrySic);
                if (srcEntryInfo.getBill().getBlockedStatus().getValue() == 2) {
                    hasBlockedCard = true;
                    sbAll.append(" " + billInfo.getNumber() + " \n");
                }
                if (!hasBlockedCard) continue;
                StringBuffer sbMsg = new StringBuffer("");
                sbMsg.append(ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"blockedCardNum", (Locale)ctx.getOriginLocale()));
                sbMsg.append(sbAll);
                sbMsg.append(" " + ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"isBlocking", (Locale)ctx.getOriginLocale()));
                throw new LCMConsumeBillException(LCMConsumeBillException.HASBLOCKEDCONSUMEBILL, new String[]{sbAll.toString()});
            }
        }
    }

    private void setBlock(Context ctx, IObjectValue model) throws BOSException {
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        if (billInfo.getEntry() != null) {
            LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
                if (entry.getSrcBillEntry() == null || entry.getSrcBillEntry().getId().toString().trim().length() == 0) continue;
                String entryID = entry.getSrcBillEntry().getId().toString();
                String select = "select top 1 fbillid from T_LCM_LCMConsumeBillEntry where fid = '" + entryID + "' ";
                String sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  2  where fid = (" + select + ") ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }

    private void releaseBlock(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.curCard.id"));
        selector.add(new SelectorItemInfo("entry.srcBillEntry.bill.id"));
        LCMConsumeBillInfo billInfo = this.getLCMConsumeBillInfo(ctx, pk, selector);
        LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
        Iterator iter = billEntries.iterator();
        while (iter.hasNext()) {
            String sql;
            LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iter.next();
            if (entry.getSrcBillEntry() == null) {
                String cardID = entry.getCurCard().getId().toString();
                sql = "update T_LCM_LCMCurCard set FBlockedStatus =  1  where fid = '" + cardID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                continue;
            }
            if (entry.getSrcBillEntry().getId().toString().trim().length() == 0 || entry.getSrcBillEntry() == null || entry.getSrcBillEntry().getBill() == null) continue;
            String billID = entry.getSrcBillEntry().getBill().getId().toString();
            sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  1  where fid = '" + billID + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (this.existNumber(ctx, model)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
        return true;
    }

    protected void setNewNumber(Context ctx, LCMConsumeBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        billInfo.setBizDate(LCMUtils.getBizDate(ctx, strCompanyId));
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            ++this.recursiveNumber;
            if (this.recursiveNumber >= 100) {
                this.recursiveNumber = 0;
                throw new LCMConsumeBillException(LCMConsumeBillException.GENGERATENUMBERRULEISWRONG);
            }
            this.setNewNumber(ctx, billInfo);
        } else {
            this.recursiveNumber = 0;
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)billInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    protected boolean canChangeCode(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_000", companyPK);
        paramKeyMap.put("LCM_005", companyPK);
        paramKeyMap.put("LCM_001", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmResult = iParamControl.getParamHashMap(paramKeyMap);
        if (hmResult == null || hmResult.size() == 0) {
            return false;
        }
        String codeChange = (String)hmResult.get("LCM_005");
        return codeChange != null && codeChange.trim().equalsIgnoreCase("true");
    }

    private void updateBudgetCtrl(Context ctx, LCMConsumeBillInfo billInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_006", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmResult = iParamControl.getParamHashMap(paramKeyMap);
        if (hmResult == null || hmResult.size() == 0) {
            return;
        }
        String useBudget = (String)hmResult.get("LCM_006");
        if (useBudget == null || "false".equals(useBudget) || this.isUseWorkflow) {
            return;
        }
        if (LCMUseTypeEnum.OTHER.equals((Object)billInfo.getUseType())) {
            return;
        }
        boolean isPass = NBgControlCallerUtil.requestBudget((Context)ctx, (BOSUuid)billInfo.getId());
        if (!isPass) {
            throw new LCMConsumeBillException(LCMConsumeBillException.APPLYOVERBUDGETCTRL);
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        this.isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!this.isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    private void releasePartialBlock(Context ctx, IObjectValue model) throws BOSException {
        LCMConsumeBillInfo billInfo = (LCMConsumeBillInfo)model;
        if (billInfo.getId() == null) {
            return;
        }
        LCMConsumeBillEntryCollection oldEntries = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryCollection("select id,curCard.id,quantity,srcBillEntry.bill.id where bill.id = '" + billInfo.getId().toString() + "'");
        if (billInfo.getEntry() != null) {
            LCMConsumeBillEntryCollection billEntries = billInfo.getEntry();
            boolean isFromConsumeBillUse = false;
            Iterator iterA = oldEntries.iterator();
            while (iterA.hasNext()) {
                boolean isCardStillHere = false;
                LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iterA.next();
                if (entry.getSrcBillEntry() != null) {
                    isFromConsumeBillUse = true;
                    break;
                }
                String cardID = entry.getCurCard().getId().toString();
                Iterator iterB = billEntries.iterator();
                while (iterB.hasNext()) {
                    if (!cardID.equals(((LCMConsumeBillEntryInfo)iterB.next()).getCurCard().getId().toString())) continue;
                    isCardStillHere = true;
                    break;
                }
                if (isCardStillHere) continue;
                String sql = "update T_LCM_LCMCurCard set FBlockedStatus =  1  where fid = '" + cardID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
                isCardStillHere = false;
            }
            if (isFromConsumeBillUse) {
                iterA = oldEntries.iterator();
                while (iterA.hasNext()) {
                    LCMConsumeBillEntryInfo entry = (LCMConsumeBillEntryInfo)iterA.next();
                    if (entry.getSrcBillEntry() == null || entry.getSrcBillEntry().getBill() == null) continue;
                    String billID = entry.getSrcBillEntry().getBill().getId().toString();
                    String sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  1  where fid = '" + billID + "' ";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            }
        }
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForEdit(ctx, model);
        return true;
    }

    @Override
    protected HashMap _getNoApproveQuantity(Context ctx, HashSet idSet, String billId, boolean flag) throws BOSException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        StringBuffer sbSql = new StringBuffer(100);
        if (flag) {
            sbSql.append(" select t.fcurcardid as id, sum(t.fquantity) as quantity from t_lcm_lcmconsumebillentry t \n");
            sbSql.append(" left join t_lcm_lcmconsumebill p on t.fbillid = p.fid \n");
            sbSql.append(" where t.fcurcardid in (").append(this.convertToQueryString(idSet)).append(") \n");
            sbSql.append(" and t.fsrcbillentryid is  null \n");
            sbSql.append(" and p.fcheckedstatus = 1 \n");
            if (StringUtils.isNotBlank((String)billId)) {
                sbSql.append(" and p.fid <> '").append(billId).append("'\n");
            }
            sbSql.append(" group by t.fcurcardid \n");
        } else {
            sbSql.append(" select t.fsrcbillentryid as id, sum(t.fquantity) as quantity from t_lcm_lcmconsumebillentry t \n");
            sbSql.append(" left join t_lcm_lcmconsumebill p on t.fbillid = p.fid \n");
            sbSql.append(" where t.fsrcbillentryid in (").append(this.convertToQueryString(idSet)).append(") \n");
            sbSql.append(" and p.fcheckedstatus = 1 \n");
            if (StringUtils.isNotBlank((String)billId)) {
                sbSql.append(" and p.fid <> '").append(billId).append("'\n");
            }
            sbSql.append(" group by t.fsrcbillentryid \n");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        try {
            while (result.next()) {
                String id = result.getString("id");
                BigDecimal quantity = result.getBigDecimal("quantity");
                if (resultMap.get(id) != null) continue;
                resultMap.put(id, quantity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    private String convertToQueryString(HashSet idSet) {
        String query;
        Iterator iter;
        StringBuffer queryString = new StringBuffer(50);
        if (idSet != null && idSet.size() > 0 && (iter = idSet.iterator()) != null) {
            while (iter.hasNext()) {
                queryString.append("'").append(iter.next().toString()).append("'").append(",");
            }
        }
        query = (query = queryString.toString()).length() > 0 ? query.substring(0, query.length() - 1) : "''";
        return query;
    }

    @Override
    protected void _releaseBlockById(Context ctx, String Id) throws BOSException {
        String sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  1  where fid = '" + Id + "' ";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

