/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.app.XmlTrans;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMContrastCaclFacadeControllerBean;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LCMContrastCaclFacadeControllerBean
extends AbstractLCMContrastCaclFacadeControllerBean {
    private static final Logger logger = Logger.getLogger(LCMContrastCaclFacadeControllerBean.class);
    private static final long serialVersionUID = 3881130433177185652L;
    BigDecimal zeroValue = new BigDecimal("0");
    private static String sumBegin = "sumBegin";
    private static String sumDebit = "sumDebit";
    private static String sumCredit = "sumCredit";
    private static String sumEnd = "sumEnd";
    private static String sumRealBeginBalance = "sumRealBeginBalance";
    private static String sumRealDebit = "sumRealDebit";
    private static String sumRealCredit = "sumRealCredit";
    private static String sumRealEndBalance = "sumRealEndBalance";

    private boolean isStoreAccountDebit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap assetAccount = (HashMap)accountMap.get("STORE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (assetAccount != null && (items = assetAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == 1;
        }
        return true;
    }

    private boolean isUseAccountDebit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap decAccount = (HashMap)accountMap.get("USE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (decAccount != null && (items = decAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == 1;
        }
        return true;
    }

    @Override
    protected HashMap _lcmAcct(Context ctx, String companyID, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseCatNumber) throws BOSException, EASBizException {
        if (accountMap == null) {
            throw new IllegalArgumentException("accountMap is NULL");
        }
        if (isUseCatNumber && catMap == null) {
            throw new IllegalArgumentException("catMap is NULL");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
        CurrencyInfo currency = companyOrg.getBaseCurrency();
        HashMap result = isUseCatNumber ? this.lcmAcctUseCat(ctx, companyOrg, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, currency) : this.lcmAcctNotUseCat(ctx, companyOrg, accountMap, isIncludeUnposted, periodYear, periodNumber, currency);
        result.put("isUseCatNumber", isUseCatNumber);
        result.put("AccountMap", accountMap);
        result.put("CatMap", catMap);
        return result;
    }

    @Override
    protected boolean _isAcctEquals(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap parameter = this.getDefaultSolution(this.getQuerySolutions(ctx, companyID));
        if (parameter != null) {
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
            PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyID));
            HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
            HashMap searchResult = this._lcmAcct(ctx, companyID, accountMap, (HashMap)parameter.get("CatMap"), isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseCat);
            if (!isUseCat) {
                Set accountMapSet = accountMap.keySet();
                String[] colNamePrefix = new String[]{sumEnd};
                for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                    int colSize = colNamePrefix.length;
                    for (int i = 0; i < colSize; ++i) {
                        BigDecimal valueGl = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_LCM");
                        BigDecimal valueAsset = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_GL");
                        if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                        return false;
                    }
                }
            } else {
                Set accountMapSet = accountMap.keySet();
                IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
                String[] colNamePrefix = new String[]{sumEnd};
                for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                    HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
                    Iterator items = accountList.values().iterator();
                    while (items.hasNext()) {
                        AccountViewInfo accountInfo = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
                        int colSize = colNamePrefix.length;
                        for (int i = 0; i < colSize; ++i) {
                            BigDecimal valueGl = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_LCM_" + accountInfo.getNumber());
                            BigDecimal valueAsset = (BigDecimal)searchResult.get(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount]);
                            if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                            return false;
                        }
                    }
                }
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return true;
    }

    @Override
    protected HashMap _lcmAcct(Context ctx, String companyID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        HashMap searchResult = null;
        HashMap parameter = this.getDefaultSolution(this.getQuerySolutions(ctx, companyID));
        if (parameter == null) {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
        boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
        searchResult = this._lcmAcct(ctx, companyID, (HashMap)parameter.get("AccountMap"), (HashMap)parameter.get("CatMap"), isIncludeUnposted, periodYear, periodNumber, isUseCat);
        return searchResult == null ? new HashMap() : searchResult;
    }

    @Override
    protected HashMap _lcmAcct(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap searchResult = new HashMap();
        HashMap parameter = this.getDefaultSolution(this.getQuerySolutions(ctx, companyID));
        if (parameter != null) {
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
            PeriodInfo period = this.getPrePeriod(ctx, companyID);
            searchResult = this._lcmAcct(ctx, companyID, (HashMap)parameter.get("AccountMap"), (HashMap)parameter.get("CatMap"), isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseCat);
            if (!isUseCat) {
                Set resultKey = searchResult.keySet();
                for (int i = 0; i < resultKey.size(); ++i) {
                    String keyName = (String)resultKey.toArray()[i];
                    if (!keyName.endsWith("_GL") && !keyName.endsWith("_LCM")) continue;
                    BigDecimal valueGl = keyName.startsWith(sumDebit) || keyName.startsWith(sumCredit) ? this.zeroValue : (BigDecimal)searchResult.get(keyName);
                    searchResult.put(keyName, valueGl);
                    if (!keyName.startsWith(sumBegin)) continue;
                    searchResult.put(sumEnd + keyName.substring(sumBegin.length()), valueGl);
                }
            } else {
                HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
                Set accountMapSet = accountMap.keySet();
                IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
                String[] colNamePrefix = new String[]{sumBegin, sumCredit, sumDebit, sumEnd};
                for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                    HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
                    Iterator items = accountList.values().iterator();
                    while (items.hasNext()) {
                        AccountViewInfo accountInfo = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
                        int colSize = colNamePrefix.length;
                        for (int i = 0; i < colSize; ++i) {
                            if (colNamePrefix[i].equals(sumCredit) || colNamePrefix[i].equals(sumDebit)) {
                                searchResult.put(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_LCM_" + accountInfo.getNumber(), this.zeroValue);
                                searchResult.put(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount], this.zeroValue);
                            }
                            if (!colNamePrefix[i].equals(sumEnd)) continue;
                            searchResult.put(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_LCM_" + accountInfo.getNumber(), searchResult.get(sumBegin + "_" + accountMapSet.toArray()[setCount] + "_LCM_" + accountInfo.getNumber()));
                            searchResult.put(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount], searchResult.get(sumBegin + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount]));
                        }
                    }
                }
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return searchResult == null ? new HashMap() : searchResult;
    }

    private PeriodInfo getPrePeriod(Context ctx, String companyID) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyID));
        return startPeriod == null ? new PeriodInfo() : startPeriod;
    }

    private QuerySolutionCollection getQuerySolutions(Context ctx, String companyID) throws BOSException, EASBizException {
        String queryName = "com.kingdee.eas.fi.lcm.LCMCurCardQuery";
        String parentUI = "com.kingdee.eas.fi.lcm.client.LCMContrastUI";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filterInfo.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUI));
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(2)));
        if (companyID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3");
        } else {
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
    }

    private HashMap getDefaultSolution(QuerySolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            QuerySolutionInfo querySolutionInfo = collection.get(i);
            QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
            for (int j = 0; j < queryPanelCollection.size(); ++j) {
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(j);
                String params = queryPanelInfo.getCustomerParams();
                if (params == null) continue;
                try {
                    boolean isDefaultSolution;
                    HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                    boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                    if (!isDefaultSolution) continue;
                    return loadInfo;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return null;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected String parseAccountString(String account) {
        return account + "";
    }

    protected HashMap searchGLBalance(Context ctx, String companyOrg, HashMap accountMap, int periodYear, int periodNumber, boolean isIncludeUnposted, String currency) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        BigDecimal c_value = this.zeroValue;
        BigDecimal y_value = this.zeroValue;
        BigDecimal jf_value = this.zeroValue;
        BigDecimal df_value = this.zeroValue;
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            if (accountList == null) continue;
            c_value = this.zeroValue;
            y_value = this.zeroValue;
            jf_value = this.zeroValue;
            df_value = this.zeroValue;
            Iterator items = accountList.values().iterator();
            while (items.hasNext()) {
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()), sic);
                HashMap sum = this.searchGLBalance(ctx, companyOrg, account, periodYear, periodNumber, isIncludeUnposted);
                c_value = c_value.add(sum.get(sumBegin + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumBegin + "_GL_" + account.getNumber()) : this.zeroValue);
                y_value = y_value.add(sum.get(sumEnd + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumEnd + "_GL_" + account.getNumber()) : this.zeroValue);
                jf_value = jf_value.add(sum.get(sumDebit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumDebit + "_GL_" + account.getNumber()) : this.zeroValue);
                df_value = df_value.add(sum.get(sumCredit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumCredit + "_GL_" + account.getNumber()) : this.zeroValue);
            }
            result.put(sumBegin + "_" + accountMapSet.toArray()[setCount] + "_GL", c_value);
            result.put(sumDebit + "_" + accountMapSet.toArray()[setCount] + "_GL", jf_value);
            result.put(sumCredit + "_" + accountMapSet.toArray()[setCount] + "_GL", df_value);
            result.put(sumEnd + "_" + accountMapSet.toArray()[setCount] + "_GL", y_value);
        }
        return result;
    }

    private HashMap searchGLBalance(Context ctx, String companyOrg, AccountViewInfo account, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put(sumBegin + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg, this.parseAccountString(account.getNumber()), BalanceTypeEnum.C, periodYear, periodNumber, periodYear, periodNumber, "GLC", false, isIncludeUnposted, false));
        result.put(sumEnd + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg, this.parseAccountString(account.getNumber()), BalanceTypeEnum.Y, periodYear, periodNumber, periodYear, periodNumber, "GLC", false, isIncludeUnposted, false));
        result.put(sumDebit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg, this.parseAccountString(account.getNumber()), BalanceTypeEnum.JF, periodYear, periodNumber, periodYear, periodNumber, "GLC", false, isIncludeUnposted, false));
        result.put(sumCredit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg, this.parseAccountString(account.getNumber()), BalanceTypeEnum.DF, periodYear, periodNumber, periodYear, periodNumber, "GLC", false, isIncludeUnposted, false));
        return result;
    }

    private HashMap lcmAcctNotUseCat(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber, CurrencyInfo currency) throws BOSException, EASBizException {
        HashMap<Object, BigDecimal> result = new HashMap<Object, BigDecimal>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        String comNumber = companyOrg != null ? companyOrg.getNumber() : "";
        HashMap glValue = null;
        glValue = currency != null ? this.searchGLBalance(ctx, comNumber, accountMap, periodYear, periodNumber, isIncludeUnposted, currency.getNumber()) : this.searchGLBalance(ctx, comNumber, accountMap, periodYear, periodNumber, isIncludeUnposted, null);
        if (glValue.isEmpty()) {
            return null;
        }
        Set s = glValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            result.put(s.toArray()[number], ((BigDecimal)glValue.get(s.toArray()[number])).setScale(currencyScale, 4));
        }
        boolean isStoreDebit = this.isStoreAccountDebit(ctx, accountMap);
        boolean isUseDebit = this.isUseAccountDebit(ctx, accountMap);
        HashMap assetValue = this.searchAssetBalance(ctx, companyOrg.getId().toString(), periodYear, periodNumber, null);
        s = assetValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            String key = (String)s.toArray()[number];
            if ((key.equalsIgnoreCase("sumBegin_STORE_LCM") || key.equalsIgnoreCase("sumEnd_STORE_LCM")) && !isStoreDebit || (key.equalsIgnoreCase("sumBegin_USE_LCM") || key.equalsIgnoreCase("sumEnd_USE_LCM")) && !isUseDebit) {
                BigDecimal value = (BigDecimal)assetValue.get(key);
                result.put(key, value.negate().setScale(currencyScale, 4));
                continue;
            }
            result.put(key, ((BigDecimal)assetValue.get(key)).setScale(currencyScale, 4));
        }
        return result;
    }

    private HashMap lcmAcctUseCat(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, CurrencyInfo currency) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        HashMap sumGL = new HashMap();
        HashMap sumFA = new HashMap();
        boolean isStoreDebit = this.isStoreAccountDebit(ctx, accountMap);
        boolean isUseDebit = this.isUseAccountDebit(ctx, accountMap);
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            Iterator items = accountList.values().iterator();
            int j = 0;
            while (items.hasNext()) {
                int number;
                String id = (String)items.next();
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id), sic);
                sumGL = this.searchGLBalance(ctx, companyOrg.getNumber(), account, periodYear, periodNumber, isIncludeUnposted);
                HashMap cats = (HashMap)catMap.get(accountMapSet.toArray()[setCount] + "_" + id);
                if (cats == null) {
                    cats = new HashMap();
                }
                Collection catListPerLine = cats.values();
                sumFA = this.searchAssetBalance(ctx, companyOrg.getId().toString(), periodYear, periodNumber, catListPerLine);
                Set s = sumGL.keySet();
                for (number = 0; number < s.size(); ++number) {
                    result.put(s.toArray()[number] + "_" + accountMapSet.toArray()[setCount].toString(), ((BigDecimal)sumGL.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
                s = sumFA.keySet();
                for (number = 0; number < s.size(); ++number) {
                    String key = (String)s.toArray()[number];
                    if ((key.equalsIgnoreCase("sumBegin_STORE_LCM") || key.equalsIgnoreCase("sumEnd_STORE_LCM")) && !isStoreDebit || (key.equalsIgnoreCase("sumBegin_USE_LCM") || key.equalsIgnoreCase("sumEnd_USE_LCM")) && !isUseDebit) {
                        BigDecimal value = (BigDecimal)sumFA.get(s.toArray()[number]);
                        result.put(key + "_" + account.getNumber(), value.setScale(currencyScale, 4));
                        continue;
                    }
                    result.put(key + "_" + account.getNumber(), ((BigDecimal)sumFA.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
                ++j;
            }
        }
        return result;
    }

    protected HashMap searchAssetBalance(Context ctx, String companyOrg, int periodYear, int periodNumber, Collection catIDList) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyOrg));
            boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
            PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyOrg));
            boolean isCurrPeriod = period.getPeriodYear() == periodYear && period.getPeriodNumber() == periodNumber;
            BigDecimal sumUseRealBeginValue = this.zeroValue;
            BigDecimal sumUseRealEndValue = this.zeroValue;
            BigDecimal sumUseRealDebitValue = this.zeroValue;
            BigDecimal sumUseRealCreditValue = this.zeroValue;
            BigDecimal sumReturnValue = this.zeroValue;
            BigDecimal sumAllReturnValue = this.zeroValue;
            String sql = this.genReturnBillValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, false, isCurrPeriod).toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next() && (sumReturnValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumReturnValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genReturnBillValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, true, isCurrPeriod).toString()).toString())).next() && (sumAllReturnValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumAllReturnValue = this.zeroValue;
            }
            if (isInitEnd) {
                sql = this.genUseRealBalanceSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod, false).toString();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next() && (sumUseRealDebitValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                    sumUseRealDebitValue = this.zeroValue;
                }
                String sumUseRealCredSQL = this.gensumUseRealCreditSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod, false).toString();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sumUseRealCredSQL);
                BigDecimal sumRealCreditByDisCard = this.zeroValue;
                if (rowSet.next() && (sumRealCreditByDisCard = rowSet.getBigDecimal("sumRealCredit")) == null) {
                    sumRealCreditByDisCard = this.zeroValue;
                }
                sumUseRealCreditValue = sumUseRealCreditValue.add(sumRealCreditByDisCard);
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genUseRealBalanceSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod, true).toString()).toString())).next() && (sumUseRealEndValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumUseRealEndValue = this.zeroValue;
            }
            BigDecimal sumDiscardConsumValue = this.zeroValue;
            sql = this.genDiscardConsumeValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next() && (sumDiscardConsumValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumDiscardConsumValue = this.zeroValue;
            }
            if (sumReturnValue.compareTo(this.zeroValue) == 1) {
                sumUseRealCreditValue = sumUseRealCreditValue.add(sumReturnValue);
            }
            sumUseRealEndValue = sumUseRealEndValue.subtract(sumDiscardConsumValue).subtract(sumAllReturnValue);
            sumUseRealBeginValue = sumUseRealEndValue.subtract(sumUseRealDebitValue).add(sumUseRealCreditValue);
            result.put(sumRealBeginBalance, sumUseRealBeginValue);
            result.put(sumRealEndBalance, sumUseRealEndValue);
            result.put(sumRealDebit, sumUseRealDebitValue);
            result.put(sumRealCredit, sumUseRealCreditValue);
            BigDecimal useRealBegin = (BigDecimal)result.get(sumRealBeginBalance);
            result.put(sumBegin + "_USE_LCM", useRealBegin);
            BigDecimal useDebit = (BigDecimal)result.get(sumRealDebit);
            result.put(sumDebit + "_USE_LCM", useDebit);
            BigDecimal useCredit = (BigDecimal)result.get(sumRealCredit);
            result.put(sumCredit + "_USE_LCM", useCredit);
            BigDecimal useEnd = (BigDecimal)result.get(sumRealEndBalance);
            result.put(sumEnd + "_USE_LCM", useEnd);
            BigDecimal sumStoreRealBeginValue = this.zeroValue;
            BigDecimal sumStoreRealEndValue = this.zeroValue;
            BigDecimal sumStoreRealDebitValue = this.zeroValue;
            BigDecimal sumStoreRealCreditValue = this.zeroValue;
            BigDecimal sumRealEndValue = this.zeroValue;
            BigDecimal sumDiscardValue = this.zeroValue;
            BigDecimal sumDispatchValue = this.zeroValue;
            BigDecimal sumReturnGoodsValue = this.zeroValue;
            BigDecimal sumDebitChangeValue = this.zeroValue;
            BigDecimal sumCreditChangeValue = this.zeroValue;
            sql = this.genChangeBillDebitValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, false, isCurrPeriod).toString();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next() && (sumDebitChangeValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumDebitChangeValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genChangeBillCreditValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, false, isCurrPeriod).toString()).toString())).next() && (sumCreditChangeValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumCreditChangeValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genRealEndBalanceSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString()).toString())).next() && (sumRealEndValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumRealEndValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genDiscardValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString()).toString())).next() && (sumDiscardValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumDiscardValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genDispatchValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString()).toString())).next() && (sumDispatchValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumDispatchValue = this.zeroValue;
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genReturnGoodsBillValueSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString()).toString())).next() && (sumReturnGoodsValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumReturnGoodsValue = this.zeroValue;
            }
            sumStoreRealEndValue = sumRealEndValue.subtract(sumUseRealEndValue).subtract(sumDiscardValue).subtract(sumAllReturnValue).subtract(sumDispatchValue).subtract(sumReturnGoodsValue);
            sql = this.genRealBalanceSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod, false).toString();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next() && (sumStoreRealCreditValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumStoreRealCreditValue = this.zeroValue;
            }
            if (isInitEnd && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = this.genStoreRealDebitBalanceSQL(ctx, catIDList, periodYear, periodNumber, companyOrg, isInitEnd, isCurrPeriod).toString()).toString())).next() && (sumStoreRealDebitValue = rowSet.getBigDecimal("sumRealBalance")) == null) {
                sumStoreRealDebitValue = this.zeroValue;
            }
            if (sumDebitChangeValue.compareTo(this.zeroValue) == 1) {
                sumStoreRealDebitValue = sumStoreRealDebitValue.add(sumDebitChangeValue);
            }
            if (sumCreditChangeValue.compareTo(this.zeroValue) == 1) {
                sumStoreRealCreditValue = sumStoreRealCreditValue.add(sumCreditChangeValue);
            }
            sumStoreRealBeginValue = sumStoreRealEndValue.subtract(sumStoreRealDebitValue).add(sumStoreRealCreditValue);
            result.put(sumRealBeginBalance, sumStoreRealBeginValue);
            result.put(sumRealEndBalance, sumStoreRealEndValue);
            result.put(sumRealDebit, sumStoreRealDebitValue);
            result.put(sumRealCredit, sumStoreRealCreditValue);
            BigDecimal storeRealBegin = (BigDecimal)result.get(sumRealBeginBalance);
            result.put(sumBegin + "_STORE_LCM", storeRealBegin);
            BigDecimal storeDebit = (BigDecimal)result.get(sumRealDebit);
            result.put(sumDebit + "_STORE_LCM", storeDebit);
            BigDecimal storeCredit = (BigDecimal)result.get(sumRealCredit);
            result.put(sumCredit + "_STORE_LCM", storeCredit);
            BigDecimal storeEnd = (BigDecimal)result.get(sumRealEndBalance);
            result.put(sumEnd + "_STORE_LCM", storeEnd);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected String gensumUseRealCreditSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod, boolean isPeriodEnd) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(a.useamount) as sumRealCredit");
        sql.append(" from (");
        sql.append("select entry.fdiscardValue as useamount ,discard.fcompanyid as companyid,curcard.FAssetCatID as assetcatid ");
        sql.append(" from T_LCM_DISCardBill discard ");
        sql.append(" inner join T_LCM_DISCardBillEntry entry on discard.FID = entry.FBillID ");
        sql.append(" inner join t_lcm_lcmconsumebillentry consum on consum.fid = entry.FConsumeEntryID ");
        sql.append(" inner join T_LCM_LCMCurCard curcard on consum.FCurCardID = curcard.FID ");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = curcard.fassetcatid ");
        sql.append(" inner join t_bd_period period on period.fid = discard.fperiodid ");
        sql.append(" where period.fnumber ");
        sql.append(isPeriodEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and discard.fcheckedstatus = ").append(2);
        sql.append(" and entry.FConsumeEntryID is not NULL");
        sql.append(") as a");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = a.assetcatid");
        sql.append(" where a.companyid='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql.toString();
    }

    protected String genParameter(Collection catIDList) {
        String result = null;
        if (catIDList != null && catIDList.size() > 0) {
            Iterator items = catIDList.iterator();
            int i = 0;
            while (items.hasNext()) {
                String catID = (String)items.next();
                result = i == 0 ? " and (charindex(select Flongnumber from t_lcm_lcmlcmcat where fid='" + catID + "', cat.flongnumber) = 1 " : result + " or charindex(select Flongnumber from t_lcm_lcmlcmcat where fid='" + catID + "', cat.flongnumber) = 1 ";
                ++i;
            }
            result = result + ") ";
        }
        return result;
    }

    protected StringBuffer genUseRealBalanceSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod, boolean isPeriodEnd) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(a.useamount) as sumRealBalance");
        sql.append(" from (");
        if (isInitEnd) {
            sql.append(" select e.FInitUseAmount as useamount,bill.fcompanyid as companyid,c.FAssetCatID as assetcatid");
            sql.append(" from t_lcm_lcmconsumebill bill ");
            sql.append(" inner join t_lcm_lcmconsumebillentry e on e.fbillid = bill.fid");
            sql.append(" inner join t_lcm_lcmcurcard c on e.fcurcardid = c.fid");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = c.fassetcatid");
            sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
            sql.append(" where period.fnumber ");
            sql.append(isPeriodEnd ? "<=" : "=");
            sql.append(periodYear * 100 + periodNumber);
            sql.append(" and bill.fcheckedstatus = ").append(2);
            sql.append(" and bill.fnumber not like 'InitCardNumber:-%' and bill.fnumber is not null");
            sql.append(" and e.FSrcBillEntryID is null ");
            if (isPeriodEnd) {
                sql.append(" union all ");
            }
        }
        if (isPeriodEnd) {
            sql.append(" select detail.fuseamount as useamount, mc.fcompanyid as companyid,mc.FAssetCatID as assetcatid ");
            sql.append(" from t_lcm_lcmconsumedetail detail");
            sql.append(" inner join t_lcm_lcmmoncard mc on mc.fid = detail.fmoncardid");
        }
        sql.append(") as a");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = a.assetcatid");
        sql.append(" where a.companyid='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genRealBalanceSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod, boolean isPeriodEnd) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(a.useamount) as sumRealBalance");
        sql.append(" from (");
        if (isInitEnd) {
            sql.append(" select e.FInitUseAmount as useamount,bill.fcompanyid as companyid,c.FAssetCatID as assetcatid");
            sql.append(" from t_lcm_lcmconsumebill bill ");
            sql.append(" inner join t_lcm_lcmconsumebillentry e on e.fbillid = bill.fid");
            sql.append(" inner join t_lcm_lcmcurcard c on e.fcurcardid = c.fid");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = c.fassetcatid");
            sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
            sql.append(" where period.fnumber ");
            sql.append(isPeriodEnd ? "<=" : "=");
            sql.append(periodYear * 100 + periodNumber);
            sql.append(" and bill.fcheckedstatus = ").append(2);
            sql.append(" and bill.fnumber not like 'InitCardNumber:-%' and bill.fnumber is not null");
            sql.append(" and e.FSrcBillEntryID is null ");
            sql.append(" union all ");
        }
        if (isPeriodEnd) {
            sql.append(" select detail.fuseamount as useamount, mc.fcompanyid as companyid,mc.FAssetCatID as assetcatid ");
            sql.append(" from t_lcm_lcmconsumedetail detail");
            sql.append(" inner join t_lcm_lcmmoncard mc on mc.fid = detail.fmoncardid");
        }
        sql.append("select entry.fdiscardValue as useamount,discard.fcompanyid as companyid,curcard.FAssetCatID as assetcatid");
        sql.append(" from T_LCM_DISCardBill discard ");
        sql.append(" inner join T_LCM_DISCardBillEntry entry on discard.FID = entry.FBillID ");
        sql.append(" inner join T_LCM_LCMCurCard curcard on entry.FCurCardID = curcard.FID ");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = curcard.fassetcatid ");
        sql.append(" inner join t_bd_period period on period.fid = discard.fperiodid ");
        sql.append(" where period.fnumber ");
        sql.append(isPeriodEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and discard.fcheckedstatus = ").append(2);
        sql.append(" and curcard.fcompanyid='").append(companyID).append("'");
        sql.append(" and entry.FConsumeEntryID is NULL");
        sql.append(" union all ");
        sql.append(" select d.FLocalAmount as useamount,bill.fcompanyid as companyid,curcard.FAssetCatID as assetcatid");
        sql.append(" from T_LCM_lcmreturngoodsbill bill ");
        sql.append(" inner join T_LCM_lcmreturngoodsbillentry d on d.fbillid = bill.fid ");
        sql.append(" inner join t_lcm_lcmcurcard curcard on d.fcurcardid = curcard.fid ");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = curcard.fassetcatid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" where period.fnumber ");
        sql.append(isPeriodEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and curcard.fcompanyid='").append(companyID).append("'");
        sql.append(" union all ");
        sql.append(" select d.fassetValue as useamount,bill.fcompanyid as companyid,curcard.FAssetCatID as assetcatid");
        sql.append(" from t_lcm_lcmdispatchbill bill ");
        sql.append(" inner join t_lcm_lcmdispatchbillentry d on d.flcmdispatchbillid = bill.fid ");
        sql.append(" inner join t_lcm_lcmcurcard curcard on d.flcmcurcardid = curcard.fid ");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = curcard.fassetcatid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" where period.fnumber ");
        sql.append(isPeriodEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and curcard.fcompanyid='").append(companyID).append("'");
        sql.append(" and bill.FDispatchDirection = 0 ");
        sql.append(" and bill.FhasAffirmed = 1");
        sql.append(") as a");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = a.assetcatid");
        sql.append(" where a.companyid='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genRealEndBalanceSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        boolean isLastestPeriod;
        StringBuffer sql = new StringBuffer();
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyID));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(ctx, company);
        int lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        boolean bl = isLastestPeriod = period.getNumber() > lastestNumber && period.getNumber() == periodYear * 100 + periodNumber;
        if (!isInitEnd) {
            sql.append("select SUM(c.flocalamount) as sumRealBalance");
            sql.append(" from t_lcm_lcmmoncard c ");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = c.fassetcatid");
            sql.append(" where c.fcheckedstatus = ").append(2);
            sql.append(" and c.FPeriodID is NULL");
            sql.append(" and c.FCompanyID='").append(companyID).append("' and c.FAssetCatID=cat.FID ");
        } else if (isLastestPeriod) {
            sql.append("select SUM(c.flocalamount) as sumRealBalance ");
            sql.append(" from t_lcm_lcmcurcard c ");
            sql.append(" left outer join t_bd_period pd on pd.fid = c.flcmperiodid ");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = c.fassetcatid ");
            sql.append(" where c.fcheckedstatus = ").append(2);
            sql.append(" and (pd.fnumber <= ").append(periodYear * 100 + periodNumber).append(" or c.flcmperiodid is null) ");
            sql.append(" and c.FCompanyID = '").append(companyID).append("' ");
        } else {
            sql.append(" select SUM(a.flocalamount) sumRealBalance ");
            sql.append(" from ( ");
            sql.append(" select mon.flocalamount flocalamount,mon.fcompanyid fcompanyid,mon.FAssetCatID FAssetCatID ");
            sql.append(" from t_lcm_lcmmoncard mon ");
            sql.append(" left outer join t_bd_period p on p.fid = mon.fperiodid ");
            sql.append(" where mon.fcheckedstatus = ").append(2);
            sql.append(" and p.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" union all ");
            sql.append(" select c.flocalamount flocalamount,c.fcompanyid fcompanyid,c.FAssetCatID FAssetCatID ");
            sql.append(" from t_lcm_lcmcurcard c ");
            sql.append(" left outer join t_bd_period pd on pd.fid = c.flcmperiodid ");
            sql.append(" where c.fcheckedstatus = ").append(2);
            sql.append(" and pd.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" and not exists(select 1 from t_lcm_lcmmoncard card ");
            sql.append(" inner join t_bd_period p on p.fid = card.fperiodid ");
            sql.append(" where p.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" and card.fcompanyid = '").append(companyID).append("' ");
            sql.append(" and card.fcurcardid = c.fid ) ");
            sql.append(") as a");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = a.fassetcatid ");
            sql.append(" where a.FCompanyID = '").append(companyID).append("' ");
            sql.append(" and a.FAssetCatID = cat.FID ");
        }
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genDiscardValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FDiscardValue) as sumRealBalance from T_LCM_DiscardBill bill ");
        sql.append(" inner join T_LCM_DiscardBillEntry d on d.FBillID = bill.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = d.fcatid");
        sql.append(" where period.fnumber ");
        sql.append(" <= ");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genDispatchValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.fassetValue) as sumrealbalance from t_lcm_lcmdispatchbill bill ");
        sql.append(" inner join t_lcm_lcmdispatchbillentry d on d.flcmdispatchbillid = bill.fid ");
        sql.append(" inner join t_lcm_lcmcurcard curcard on d.flcmcurcardid = curcard.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = curcard.fassetcatid");
        sql.append(" where period.fnumber ");
        sql.append(" <= ");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and curcard.fcompanyid='").append(companyID).append("'");
        sql.append(" and bill.FDispatchDirection = 0");
        sql.append(" and bill.FhasAffirmed = 1 ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genDiscardConsumeValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FDiscardValue) as sumRealBalance from T_LCM_DiscardBill bill ");
        sql.append(" inner join T_LCM_DiscardBillEntry d on d.FBillID = bill.fid ");
        sql.append(" inner join  T_LCM_LCMConsumeBillEntry  consume on consume.fid = d.FConsumeEntryID ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = d.fcatid");
        sql.append(" where period.fnumber ");
        sql.append(" <= ");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genChangeBillDebitValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FAccountChange) as sumRealBalance from T_LCM_LCMChangeBill bill ");
        sql.append(" inner join T_LCM_LCMChangeBillEntry d on d.FChangeBillID = bill.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmcurcard card on card.fid = d.FLcmCurCardID ");
        sql.append(" inner join t_lcm_lcmbakcard bakcard on bakcard.fid = d.FLcmBakCardID ");
        sql.append(" inner join t_lcm_lcmbizcard bizcard on bizcard.fid = d.flcmbizcardid ");
        sql.append(" left outer join t_bd_period pd on pd.fid = card.flcmperiodid");
        sql.append(" where period.fnumber ");
        sql.append(isInitEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("'");
        sql.append(" and bakcard.FOriginAmount-bizcard.FOriginAmount<0 ");
        sql.append(" and (pd.fnumber !=").append(periodYear * 100 + periodNumber);
        sql.append(" or card.flcmperiodid is null)");
        return sql;
    }

    protected StringBuffer genChangeBillCreditValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FAccountChange) as sumRealBalance from T_LCM_LCMChangeBill bill ");
        sql.append(" inner join T_LCM_LCMChangeBillEntry d on d.FChangeBillID = bill.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmcurcard card on card.fid = d.FLcmCurCardID ");
        sql.append(" inner join t_lcm_lcmbakcard bakcard on bakcard.fid = d.FLcmBakCardID ");
        sql.append(" inner join t_lcm_lcmbizcard bizcard on bizcard.fid = d.flcmbizcardid ");
        sql.append(" left outer join t_bd_period pd on pd.fid = card.flcmperiodid");
        sql.append(" where period.fnumber ");
        sql.append(isInitEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("'");
        sql.append(" and bakcard.FOriginAmount-bizcard.FOriginAmount>0 ");
        sql.append(" and (pd.fnumber !=").append(periodYear * 100 + periodNumber);
        sql.append(" or card.flcmperiodid is null)");
        return sql;
    }

    protected StringBuffer genReturnBillValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FLocalAmount) as sumRealBalance from T_LCM_lcmreturnconsumebill bill ");
        sql.append(" inner join T_LCM_lcmreturnconsumeentry d on d.FEntryID = bill.fid ");
        sql.append(" inner join T_LCM_LcmCurCard card on d.fcurcardid = card.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = d.fcatid");
        sql.append(" where period.fnumber ");
        sql.append(isInitEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genReturnGoodsBillValueSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(d.FLocalAmount) as sumRealBalance from T_LCM_lcmreturngoodsbill bill ");
        sql.append(" inner join T_LCM_lcmreturngoodsbillentry d on d.FBillID = bill.fid ");
        sql.append(" inner join T_LCM_LcmCurCard card on d.fcurcardid = card.fid ");
        sql.append(" inner join t_bd_period period on period.fid = bill.fperiodid");
        sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = card.fassetcatid");
        sql.append(" where period.fnumber ");
        sql.append(isInitEnd ? "<=" : "=");
        sql.append(periodYear * 100 + periodNumber);
        sql.append(" and bill.fcheckedstatus = ").append(2);
        sql.append(" and bill.FCompanyID='").append(companyID).append("' ");
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    protected StringBuffer genStoreRealDebitBalanceSQL(Context ctx, Collection catIDList, int periodYear, int periodNumber, String companyID, boolean isInitEnd, boolean isCurrPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (!isInitEnd) {
            sql.append("select SUM(c.flocalamount) as sumRealBalance");
            sql.append(" from t_lcm_lcmmoncard c ");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = c.fassetcatid");
            sql.append(" where c.fcheckedstatus = ").append(2);
            sql.append(" and c.FPeriodID is NULL");
            sql.append(" and c.FCompanyID='").append(companyID).append("' and c.FAssetCatID=cat.FID ");
        } else {
            sql.append("select SUM(a.flocalamount) sumRealBalance");
            sql.append(" from ( ");
            sql.append(" select mon.flocalamount flocalamount,mon.fcompanyid fcompanyid,mon.FAssetCatID FAssetCatID ");
            sql.append(" from t_lcm_lcmmoncard mon ");
            sql.append(" left outer join t_bd_period p on p.fid = mon.fperiodid ");
            sql.append(" where mon.fcheckedstatus = ").append(2);
            sql.append(" and p.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" and p.fid = mon.flcmperiodid ");
            sql.append(" union all ");
            sql.append(" select c.flocalamount flocalamount,c.fcompanyid fcompanyid,c.FAssetCatID FAssetCatID ");
            sql.append(" from t_lcm_lcmcurcard c ");
            sql.append(" left outer join t_bd_period pd on pd.fid = c.flcmperiodid ");
            sql.append(" where c.fcheckedstatus = ").append(2);
            sql.append(" and pd.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" and not exists(select 1 from t_lcm_lcmmoncard card ");
            sql.append(" inner join t_bd_period p on p.fid = card.fperiodid ");
            sql.append(" where p.fnumber = ").append(periodYear * 100 + periodNumber);
            sql.append(" and card.fcompanyid = '").append(companyID).append("' ");
            sql.append(" and card.fcurcardid = c.fid) ");
            sql.append(") as a");
            sql.append(" inner join t_lcm_lcmlcmcat cat on cat.fid = a.fassetcatid ");
            sql.append(" where a.FCompanyID = '").append(companyID).append("' ");
            sql.append(" and a.FAssetCatID = cat.FID ");
        }
        String cond = this.genParameter(catIDList);
        if (cond != null) {
            sql.append(cond);
        }
        return sql;
    }

    @Override
    protected Map _getZipDataForRPC(Context ctx, List params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)params.get(0);
        if (comp.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)comp.getInvalidDate(), (Date)new Date())) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        if (!comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        String companyId = comp.getId().toString();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(companyId));
        if (startPeriod == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource.LCMNotEndInit", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        result.put("startPeriod", startPeriod);
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        result.put("currPeriod", curPeriod);
        int max = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)startPeriod.getPeriodYear(), (IObjectPK)new ObjectUuidPK(companyId));
        int min = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)startPeriod.getPeriodYear(), (IObjectPK)new ObjectUuidPK(companyId));
        result.put("maxNumber", new Integer(max));
        result.put("minNumber", new Integer(min));
        return result;
    }
}

