/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.LCMBaseException;
import com.kingdee.eas.fi.lcm.LCMCardException;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMChangeBillFactory;
import com.kingdee.eas.fi.lcm.LCMChangeBillInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMSourceTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMCurCardControllerBean;
import com.kingdee.eas.fi.lcm.app.AbstractLCMDAPTransStrategy;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.fi.lcm.app.LCMDAPCardStrategy;
import com.kingdee.eas.fi.lcm.app.dao.processor.LCMCurCardBusinessProcessorBuilder;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class LCMCurCardControllerBean
extends AbstractLCMCurCardControllerBean {
    private static final long serialVersionUID = 815301621263251222L;
    public static final BigDecimal ZERO = new BigDecimal("0");

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMCurCard set FFiVouchered = 1, FVoucherID = ? where fid = ? ", (Object[])new Object[]{voucher.getId().toString(), srcBillPK.toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMCurCard set FFiVouchered = 0, FVoucherID = null where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMCurCardInfo cardInfo = (LCMCurCardInfo)model;
        this.noCheckoutCanAddCard(ctx, cardInfo);
        boolean isFirstSave = false;
        if (cardInfo.getId() == null) {
            isFirstSave = true;
        }
        IObjectPK iobjectPK = super._save(ctx, model);
        String cardId = "'" + iobjectPK + "'";
        HashSet<IObjectPK> cardSet = new HashSet<IObjectPK>();
        cardSet.add(iobjectPK);
        this.insertIntoMoncardFromCurcard(ctx, cardInfo, cardId, isFirstSave, cardSet);
        return iobjectPK;
    }

    private void noCheckoutCanAddCard(Context ctx, LCMCurCardInfo card) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = card.getCompany();
        HashMap lcmParam = LCMUtils.getLCMParameter(currentCompany.getId(), ctx);
        PeriodInfo curPeriod = LCMUtils.getLCMCurrentPeriod(currentCompany.getId().toString(), ctx);
        String canAddCard = (String)lcmParam.get("LCM_014");
        if (canAddCard == null || canAddCard.trim().length() == 0 || canAddCard.trim().equalsIgnoreCase("false")) {
            card.setLcmPeriod(curPeriod);
        } else {
            Date accountDate = card.getAccountDate();
            if (accountDate != null) {
                PeriodInfo newPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)accountDate, (CompanyOrgUnitInfo)currentCompany);
                if (newPeriod == null) {
                    throw new LCMCardException(LCMCardException.ACCDATE_NOTIN_SYSTEMPERIOD);
                }
                card.setLcmPeriod(newPeriod);
            } else {
                card.setLcmPeriod(curPeriod);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkStateForDel(ctx, pk);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.number"));
        selector.add(new SelectorItemInfo("company.name"));
        LCMCurCardInfo curcard = this.getLCMCurCardInfo(ctx, pk, selector);
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        cardSet.add(curcard.getId());
        if (cardSet.size() > 0) {
            LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, curcard.getCompany(), cardSet);
        }
        super._delete(ctx, pk);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            this.checkStateForDel(ctx, arrayPK[i]);
        }
        super._delete(ctx, arrayPK);
    }

    @Override
    protected LCMConsumeDetailCollection _getConsumeDetail(Context ctx, BOSUuid cardID) throws BOSException, EASBizException {
        String fName = "FName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select d.usedate as useDate,d.useamt as quantity, d.useAmount as useAmount,");
        sql.append("d.amortizedAmount as amortizedAmount,d.amortizeAmount as amortizeAmount,");
        sql.append("p.").append(fName).append(" as useDepartment,person.fname_l2 as usePerson,");
        sql.append(" d.remark as description,address.").append(fName);
        sql.append(" as address,d.fnumber as fnumber,");
        sql.append(" account.FLongName_").append(ctx.getLocale().toString()).append(" accountLongName from (");
        sql.append(" select bill.fusedate as usedate,entry.FBeConsumeQty as useamt,entry.FBeConsumeAmt as useAmount,");
        sql.append(" entry.famortizedamount as amortizedAmount,entry.famortizeamount as amortizeAmount,bill.fusedepartmentid as usedepartmentid,");
        sql.append(" bill.fusepersonid as usepersonid,entry.fremark as remark,entry.FStoreAdress as FStoreAdress,bill.fnumber as fnumber");
        sql.append(" ,bill.FAccountID");
        sql.append(" from t_lcm_lcmconsumebill bill inner join t_lcm_lcmconsumebillentry entry on bill.fid = entry.fbillid");
        sql.append(" and entry.fcurcardid = '").append(cardID.toString()).append("' and bill.FCheckedStatus =").append(2);
        sql.append(" ) d left outer join t_org_baseunit p on d.usedepartmentid = p.fid");
        sql.append(" left outer join t_bd_person person on person.fid = d.usepersonid");
        sql.append(" left outer join t_bd_address address on address.fid = d.FStoreAdress");
        sql.append(" left outer join t_bd_accountview account on account.fid = d.FAccountID");
        sql.append(" order by d.useDate");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LCMConsumeDetailCollection coll = new LCMConsumeDetailCollection();
        try {
            while (iRowSet.next()) {
                LCMConsumeDetailInfo info = new LCMConsumeDetailInfo();
                info.setUseDate(iRowSet.getDate("useDate"));
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setName(iRowSet.getString("useDepartment"));
                info.setUseDepartment(adminInfo);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setName(iRowSet.getString("usePerson"));
                info.setUsePerson(personInfo);
                info.setUseAmt(iRowSet.getBigDecimal("quantity"));
                info.setUseAmount(iRowSet.getBigDecimal("useAmount"));
                info.setAmortizedAmount(iRowSet.getBigDecimal("amortizedAmount"));
                info.setAmortizeAmount(iRowSet.getBigDecimal("amortizeAmount"));
                info.setRemark(iRowSet.getString("description"));
                AddressInfo address = new AddressInfo();
                address.setName(iRowSet.getString("address"));
                info.setStoreAdress(address);
                info.setNumber(iRowSet.getString("fnumber"));
                AccountViewInfo account = new AccountViewInfo();
                account.setLongName(iRowSet.getString("accountLongName"));
                info.setAccount(account);
                coll.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    public void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        if (pk != null && !this._exists(ctx, pk)) {
            return;
        }
        model = this._getValue(ctx, pk);
        this.checkForAudit(ctx, model);
        this._passAuditSelf(ctx, pk, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    public void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        if (pk != null && !this._exists(ctx, pk)) {
            return;
        }
        model = super._getValue(ctx, pk);
        boolean isFromSource = false;
        if (ctx.get((Object)"FROM_SOURCE") != null && ctx.get((Object)"FROM_SOURCE").equals("true")) {
            isFromSource = true;
        }
        this.checkForUnAudit(ctx, model, isFromSource);
        this._unpassAuditSelf(ctx, pk, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpassAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        int size = sourceBillCollection.size();
        for (int m = 0; m < size; ++m) {
            LCMCurCardInfo card = (LCMCurCardInfo)sourceBillCollection.getObject(m);
            LCMBillBizProcessor.lockTable(ctx, card.getId().toString());
        }
        LCMDAPCardStrategy dAPTransStrategy = new LCMDAPCardStrategy();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            BillBaseInfo info = (BillBaseInfo)sourceBillCollection.getObject(i);
            if (info == null || (LCMCurCardInfo)info == null) continue;
            this.checkForGenerateVoucher(ctx, (IObjectPK)new ObjectUuidPK(((LCMCurCardInfo)info).getId()));
            sourceBillCollection.setObject(i, (IObjectValue)((AbstractLCMDAPTransStrategy)dAPTransStrategy).process4DAP(info, ctx));
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        this.checkForGenerateVoucher(ctx, sourceBillPk);
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            this.checkForGenerateVoucher(ctx, sourceBillPkList[i]);
        }
        super._generateVoucher(ctx, sourceBillPkList);
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMCurCardInfo curCardInfo = (LCMCurCardInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)curCardInfo.getCompany());
        PeriodInfo lcmPeriod = curCardInfo.getLcmPeriod();
        CompanyOrgUnitInfo currentCompany = curCardInfo.getCompany();
        HashMap lcmParam = LCMUtils.getLCMParameter(currentCompany.getId(), ctx);
        String canAuditCard = (String)lcmParam.get("LCM_014");
        if (canAuditCard == null || canAuditCard.trim().length() == 0 || canAuditCard.trim().equalsIgnoreCase("false")) {
            if (lcmPeriod == null || !curPeriod.getId().equals((Object)lcmPeriod.getId())) {
                sbMsg.append(" ");
                sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
            }
        } else {
            PeriodInfo periodInfo = lcmPeriod = lcmPeriod == null ? lcmPeriod : PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(lcmPeriod.getId()));
            if (lcmPeriod == null || !PeriodUtils.PeriodCompare((PeriodInfo)lcmPeriod, (PeriodInfo)curPeriod)) {
                sbMsg.append(" ");
                sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
            }
        }
        if (curCardInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.getBlockedStatus().equals((Object)BlockedStatusEnum.BLOCKED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(curCardInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)curCardInfo, 4);
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model, boolean isFromSource) throws EASBizException, BOSException {
        LCMCurCardInfo billInfo = (LCMCurCardInfo)model;
        StringBuffer sbMsg = new StringBuffer();
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)billInfo.getCompany());
        PeriodInfo lcmPeriod = billInfo.getLcmPeriod();
        CompanyOrgUnitInfo currentCompany = billInfo.getCompany();
        HashMap lcmParam = LCMUtils.getLCMParameter(currentCompany.getId(), ctx);
        String canUnAuditCard = (String)lcmParam.get("LCM_014");
        if (canUnAuditCard == null || canUnAuditCard.trim().length() == 0 || canUnAuditCard.trim().equalsIgnoreCase("false")) {
            if (lcmPeriod == null || !curPeriod.getId().equals((Object)lcmPeriod.getId())) {
                sbMsg.append(" ");
                sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
            }
        } else {
            PeriodInfo periodInfo = lcmPeriod = lcmPeriod == null ? lcmPeriod : PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(lcmPeriod.getId()));
            if (lcmPeriod == null || !PeriodUtils.PeriodCompare((PeriodInfo)lcmPeriod, (PeriodInfo)curPeriod)) {
                sbMsg.append(" ");
                sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
            }
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (!isFromSource && billInfo.getSourceType() != null && billInfo.getSourceType().equals((Object)LCMSourceTypeEnum.returnCard)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"isReturn", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo.getNumber() + "(" + billInfo.getName() + ")";
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
        if (LCMDispatchBillEntryFactory.getLocalInstance(ctx).exists("where LCMCurCard.id='" + billInfo.getId() + "'")) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"hasNewDispatchBill", (Locale)ctx.getOriginLocale())});
        }
        if (LCMDiscardBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id='" + billInfo.getId() + "'")) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"hasNewDiscardBill", (Locale)ctx.getOriginLocale())});
        }
        if (LCMConsumeBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id='" + billInfo.getId() + "'")) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"hasNewConsumeBill", (Locale)ctx.getOriginLocale())});
        }
        if (LCMReturnConsumeBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id='" + billInfo.getId() + "'")) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"hasNewReturnBill", (Locale)ctx.getOriginLocale())});
        }
        if (LCMChangeBillEntryFactory.getLocalInstance(ctx).exists("where LCMCurCard.id='" + billInfo.getId() + "'")) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"hasNewChangeBill", (Locale)ctx.getOriginLocale())});
        }
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        LCMCurCardInfo curCard = (LCMCurCardInfo)model;
        if (curCard.isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasGenVoucher.toString()});
        }
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMCurCardInfo cardInfo = (LCMCurCardInfo)model;
        cardInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        cardInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        cardInfo.setBizDate(today);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("bizDate"));
        this._updatePartial(ctx, model, selector);
        if (cardInfo.getSourceBillId() != null) {
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("sourceEntryID", (Object)cardInfo.getSourceBillId());
            applicationContext.putData("changeQty", (Object)cardInfo.getAssetAmt());
            BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)BOSObjectType.create((String)"4A1078C5"), (Object[])new Object[]{cardInfo.getId().toString()}, (BatchActionEnum)BatchActionEnum.AUDIT, LCMCurCardBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        cardSet.add(cardInfo.getId());
        LCMUtils.updateMonCardfromCurCard(ctx, cardInfo.getCompany(), cardSet);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMCurCardInfo cardInfo = (LCMCurCardInfo)model;
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        cardInfo.setAuditor(null);
        cardInfo.setBizDate(null);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("bizDate"));
        this._updatePartial(ctx, model, selector);
        if (cardInfo.getSourceBillId() != null) {
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("sourceEntryID", (Object)cardInfo.getSourceBillId());
            applicationContext.putData("changeQty", (Object)cardInfo.getAssetAmt());
            BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)BOSObjectType.create((String)"4A1078C5"), (Object[])new Object[]{cardInfo.getId().toString()}, (BatchActionEnum)BatchActionEnum.UNAUDIT, LCMCurCardBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        cardSet.add(cardInfo.getId());
        LCMUtils.updateMonCardfromCurCard(ctx, cardInfo.getCompany(), cardSet);
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("blockedStatus"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("lcmPeriod.id"));
        selector.add(new SelectorItemInfo("lcmPeriod.number"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.number"));
        LCMCurCardInfo curcard = this.getLCMCurCardInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (curcard.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(curcard, ctx));
        }
        if (curcard.getBlockedStatus().equals((Object)BlockedStatusEnum.BLOCKED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(curcard, ctx));
        }
        if (curcard.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(curcard, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + curcard.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)curcard, 0);
    }

    protected void checkForGenerateVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("amortizeMode"));
        selector.add(new SelectorItemInfo("assetAmt"));
        selector.add(new SelectorItemInfo("unitPrice"));
        selector.add(new SelectorItemInfo("localAmount"));
        selector.add(new SelectorItemInfo("originAmount"));
        selector.add(new SelectorItemInfo("effectedStatus"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("blockedStatus"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("sourceType"));
        LCMCurCardInfo curCardInfo = this.getLCMCurCardInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (curCardInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(curCardInfo, ctx));
        }
        if (curCardInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(curCardInfo, ctx));
        }
        if (curCardInfo.getSourceType() != null && curCardInfo.getSourceType().equals((Object)LCMSourceTypeEnum.returnCard) && !LCMUtils.checkReturnCardNeedVoucher(ctx, curCardInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"returnCantGenerateVoucher", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new LCMBaseException(LCMBaseException.CANNOT_BE_GENVOUCHER_RETURN, new String[]{sbAll.toString()});
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
        if (changeBillInfo == null) {
            boolean isFirstSubmit;
            LCMCurCardInfo cardInfo = (LCMCurCardInfo)model;
            this.noCheckoutCanAddCard(ctx, cardInfo);
            if (cardInfo.getStoreAdress() != null) {
                cardInfo.setAddress(cardInfo.getStoreAdress().getName());
            }
            if (cardInfo.getOriginAmount() != null && cardInfo.getAssetAmt() != null && cardInfo.getAssetAmt() != new BigDecimal(0.0)) {
                cardInfo.setUnitPrice(cardInfo.getOriginAmount().divide(cardInfo.getAssetAmt(), 4, 4));
            }
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)cardInfo, 3);
            BOSUuid id = ((LCMCurCardInfo)model).getId();
            boolean bl = isFirstSubmit = id == null;
            if (id != null) {
                ObjectUuidPK pk = new ObjectUuidPK(id);
                this.checkSubmit(ctx, (IObjectPK)pk);
            }
            IObjectPK iobjectPK = super._submit(ctx, model);
            String cardId = "'" + iobjectPK + "'";
            HashSet<IObjectPK> cardSet = new HashSet<IObjectPK>();
            cardSet.add(iobjectPK);
            this.insertIntoMoncardFromCurcard(ctx, cardInfo, cardId, isFirstSubmit, cardSet);
            return iobjectPK;
        }
        return LCMChangeBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)model);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMChangeBillInfo changeBillInfo = (LCMChangeBillInfo)model.get("changeBill");
        if (changeBillInfo == null) {
            LCMCurCardInfo cardInfo = (LCMCurCardInfo)model;
            this.noCheckoutCanAddCard(ctx, cardInfo);
            if (cardInfo.getStoreAdress() != null) {
                cardInfo.setAddress(cardInfo.getStoreAdress().getName());
            }
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)cardInfo, 3);
            if (pk != null) {
                this.checkSubmit(ctx, pk);
            }
            super._submit(ctx, pk, model);
        } else {
            LCMChangeBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    protected void setStatusForBot(Context ctx, LCMCardInfo cardInfo) throws EASBizException, BOSException {
        super.setStatusForBot(ctx, cardInfo);
        if (cardInfo.getLcmPeriod() == null) {
            cardInfo.setLcmPeriod(SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx)));
        }
        cardInfo.setUsableAmt(cardInfo.getAssetAmt());
    }

    private void checkSubmit(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        LCMCurCardInfo curCardInfo = this.getLCMCurCardInfo(ctx, pk);
        if (CheckedStatusEnum.AUDITED.equals((Object)curCardInfo.getCheckedStatus())) {
            String msg = this.getCheckedStatus(curCardInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private void insertIntoMoncardFromCurcard(Context ctx, LCMCurCardInfo cardInfo, String cardId, boolean isFirstOpt, HashSet cardSet) throws BOSException, EASBizException {
        PeriodInfo cardPeriod = cardInfo.getLcmPeriod();
        cardPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(cardPeriod.getId()));
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(ctx, cardInfo.getCompany());
        int lastestNumber = 0;
        try {
            lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        }
        catch (Exception e) {
            lastestNumber = 0;
        }
        if (lastestPeriodNumber == null || "".equals(lastestPeriodNumber)) {
            return;
        }
        if (lastestNumber >= cardPeriod.getNumber()) {
            if (!isFirstOpt) {
                LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, cardInfo.getCompany(), cardSet);
            }
            Object[] param = null;
            for (int i = cardPeriod.getNumber(); i <= lastestNumber; ++i) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FID from t_bd_period where fnumber = ? and ftypeid = ?");
                param = new Object[]{new Integer(i), cardPeriod.getPeriodType().getId().toString()};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                String strPeriodId = null;
                try {
                    if (rs.next()) {
                        strPeriodId = rs.getString("FID");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (strPeriodId == null || "".equals(strPeriodId)) continue;
                strPeriodId = "'" + strPeriodId + "'";
                sql = new StringBuffer();
                sql.append("Insert into T_LCM_LCMMonCard                                        \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("  FID,                                                              \r\n");
                sql.append("  FPeriodID,                                                        \r\n");
                sql.append("  FCurCardID,                                                       \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(")                                                                   \r\n");
                sql.append("Select                                                              \r\n");
                sql.append(FaLocalUtils.newBosID((Context)ctx, (String)new LCMMonCardInfo().getBOSType().toString()) + " as FID, \r\n");
                sql.append(strPeriodId).append(" as FPeriodID,                                  \r\n");
                sql.append("  FID as FCurCardID,                                         \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(" From T_LCM_LCMCurCard                                              \r\n");
                sql.append("Where FID = ").append(cardId).append("                              \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        } else {
            LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, cardInfo.getCompany(), cardSet);
        }
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForEdit(ctx, model);
        return true;
    }
}

