/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.lcm.LCMBakCardFactory;
import com.kingdee.eas.fi.lcm.LCMBakCardInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.app.AbstractLCMDAPTransStrategy;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class LCMDAPCardStrategy
extends AbstractLCMDAPTransStrategy {
    @Override
    public BillBaseInfo process4DAP(BillBaseInfo bill, Context ctx) throws BOSException, EASBizException {
        LCMCurCardInfo curCardInfo = (LCMCurCardInfo)bill;
        if (curCardInfo != null && curCardInfo.getId() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select top 1 entry.flcmbakcardid as flcmbakcardid from t_lcm_lcmchangebillentry entry ");
            sql.append(" inner join t_lcm_lcmchangebill bill on bill.fid=entry.fchangebillid ");
            sql.append(" where entry.flcmcurcardid=? order by bill.fbizdate asc ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCardInfo.getId().toString()});
            try {
                String lcmBakCardId;
                if (rowSet != null && rowSet.next() && (lcmBakCardId = rowSet.getString("flcmbakcardid")) != null && lcmBakCardId.length() != 0) {
                    SelectorItemCollection bakSic = new SelectorItemCollection();
                    bakSic.add(new SelectorItemInfo("*"));
                    LCMBakCardInfo bakCardInfo = LCMBakCardFactory.getLocalInstance(ctx).getLCMBakCardInfo((IObjectPK)new ObjectUuidPK(lcmBakCardId), bakSic);
                    this.copyValueBetweenCard(bakCardInfo, curCardInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
        }
        curCardInfo.put("forDAP", new Boolean(true));
        return curCardInfo;
    }

    private void copyValueBetweenCard(LCMBakCardInfo bakCardInfo, LCMCurCardInfo curCardInfo) {
        curCardInfo.setAssetCat(bakCardInfo.getAssetCat());
        curCardInfo.setNumber(bakCardInfo.getNumber());
        curCardInfo.setName(bakCardInfo.getName());
        curCardInfo.setSpecs(bakCardInfo.getSpecs());
        curCardInfo.setMeasureUnit(bakCardInfo.getMeasureUnit());
        curCardInfo.setBuyDate(bakCardInfo.getBuyDate());
        curCardInfo.setPArea(bakCardInfo.getPArea());
        curCardInfo.setMfr(bakCardInfo.getMfr());
        curCardInfo.setAccountDate(bakCardInfo.getAccountDate());
        curCardInfo.setDept(bakCardInfo.getDept());
        curCardInfo.setKeeper(bakCardInfo.getKeeper());
        curCardInfo.setSourceMode(bakCardInfo.getSourceMode());
        curCardInfo.setAssetAmt(bakCardInfo.getAssetAmt());
        curCardInfo.setCurrency(bakCardInfo.getCurrency());
        curCardInfo.setExRate(bakCardInfo.getExRate());
        curCardInfo.setUnitPrice(bakCardInfo.getUnitPrice());
        curCardInfo.setOriginAmount(bakCardInfo.getOriginAmount());
        curCardInfo.setLocalAmount(bakCardInfo.getLocalAmount());
        curCardInfo.setUsableAmt(bakCardInfo.getUsableAmt());
        curCardInfo.setStoreAdress(bakCardInfo.getStoreAdress());
        curCardInfo.setLife(bakCardInfo.getLife());
        curCardInfo.setUseStatus(bakCardInfo.getUseStatus());
        curCardInfo.setAmortizeMode(bakCardInfo.getAmortizeMode());
        curCardInfo.setAccountAsset(bakCardInfo.getAccountAsset());
        curCardInfo.setDescription(bakCardInfo.getDescription());
        curCardInfo.setSupplier(bakCardInfo.getSupplier());
    }
}

