/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.ILCMCurCard;
import com.kingdee.eas.fi.lcm.ILCMDispatchBillEntry;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDisPatchBillInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillException;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMDisPatchBillControllerBean;
import com.kingdee.eas.fi.lcm.app.ILCMAppChecker;
import com.kingdee.eas.fi.lcm.app.LCMDispatchChecker;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMDisPatchBillControllerBean
extends AbstractLCMDisPatchBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.lcm.app.LCMDisPatchBillControllerBean");
    private CompanyOrgUnitInfo currCompany;
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMDisPatchBill set FFiVouchered = 1, FVoucherID = ? where fid = ? ", (Object[])new Object[]{voucher.getId().toString(), srcBillPK.toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMDisPatchBill set FFiVouchered = 0, FVoucherID = null where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._passAudit(ctx, pk, null);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unpassAudit(ctx, pk, null);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    private void CheckForAffirm(Context ctx, IObjectPK billId, IObjectValue model) {
    }

    private void genearatNewCard(Context ctx, IObjectPK billId, IObjectValue model) {
    }

    private void checkForUnAffirm(Context ctx, IObjectPK billId, IObjectValue model) {
    }

    private SelectorItemCollection getAffirmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private SelectorItemCollection getDispatchSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.lcmCurCard.*"));
        sic.add(new SelectorItemInfo("entry.lcmNewCard.*"));
        sic.add(new SelectorItemInfo("entry.quantity"));
        sic.add(new SelectorItemInfo("entry.assetValue"));
        sic.add(new SelectorItemInfo("entry.description"));
        sic.add(new SelectorItemInfo("inCompany.id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("outCompany.id"));
        sic.add(new SelectorItemInfo("inCompany.CU.id"));
        return sic;
    }

    @Override
    protected boolean _affirm(Context ctx, IObjectPK billId) throws EASBizException, BOSException {
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        LCMDisPatchBillInfo inBillInfo = this.getLCMDisPatchBillInfo(ctx, billId, this.getDispatchSelector());
        if (inBillInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (inBillInfo.getDispatchDirection() == 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("company.id", (Object)inBillInfo.getInCompany().getId().toString()));
            filterItems.add(new FilterItemInfo("number", (Object)inBillInfo.getNumber()));
            filterItems.add(new FilterItemInfo("dispatchDirection", (Object)new Integer("1")));
            CoreBaseCollection outBillInfoCollection = this.getCollection(ctx, entityViewInfo);
            inBillInfo = (LCMDisPatchBillInfo)outBillInfoCollection.get(0);
        }
        if (inBillInfo.isHasAffirmed()) {
            throw new FaDispatchBillException(FaDispatchBillException.BILLHASCONFIRMED);
        }
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)inBillInfo.getCompany());
        if (!isInitEnd) {
            throw new FaCardException(FaCardException.DISPATCH_INCOMPANY_NOT_INITED);
        }
        String[] fields = new String[]{"id", "assetCat", "sourceMode", "effectedStatus", "checkedStatus", "deletedStatus", "blockedStatus", "voucher", "sourceType", "returnNumber", "number", "company", "lcmPeriod", "creator", "auditor", "handler", "creatTime", "bizDate", "assetAmt", "originAmount", "dept", "keeper", "storeAdress", "accountAsset"};
        int size = inBillInfo.getEntry().size();
        ILCMCurCard iLCMCurCard = LCMCurCardFactory.getLocalInstance(ctx);
        PeriodInfo periodIn = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)inBillInfo.getInCompany());
        ILCMDispatchBillEntry iEntry = LCMDispatchBillEntryFactory.getLocalInstance(ctx);
        for (int i = 0; i < size; ++i) {
            LCMDispatchBillEntryInfo entry = inBillInfo.getEntry().get(i);
            LCMCurCardInfo inCurCardInfo = entry.getLcmCurCard();
            LCMCurCardInfo newCurCardInfo = (LCMCurCardInfo)inCurCardInfo.clone();
            for (int j = 0; j < fields.length; ++j) {
                String key = fields[j];
                newCurCardInfo.put(key, null);
            }
            newCurCardInfo.setDescription(FaResUtil.getRes((String)"produceByAllocateBill", (Locale)ctx.getOriginLocale()));
            newCurCardInfo.setFiVouchered(false);
            newCurCardInfo.setAddress(null);
            newCurCardInfo.setStoreAdress(null);
            newCurCardInfo.setCompany(inBillInfo.getInCompany());
            newCurCardInfo.setSourceBillId(inBillInfo.getId().toString());
            newCurCardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            newCurCardInfo.setBizDate(new Date());
            newCurCardInfo.setAssetAmt(entry.getQuantity());
            Date today = new Date();
            if (DateTimeUtils.dayBefore((Date)today, (Date)periodIn.getBeginDate())) {
                today = periodIn.getBeginDate();
            } else if (DateTimeUtils.dayAfter((Date)today, (Date)periodIn.getEndDate())) {
                today = periodIn.getEndDate();
            }
            newCurCardInfo.setAccountDate(today);
            BigDecimal extRate = this.getCurrCompanyRate(ctx, today, newCurCardInfo.getCurrency());
            newCurCardInfo.setExRate(extRate);
            newCurCardInfo.setLocalAmount(entry.getAssetValue().multiply(extRate));
            newCurCardInfo.setOriginAmount(entry.getAssetValue());
            newCurCardInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            newCurCardInfo.setLcmPeriod(periodIn);
            String strPK = iLCMCurCard.save((CoreBaseInfo)newCurCardInfo).toString();
            newCurCardInfo.setId(BOSUuid.read((String)strPK.trim()));
            entry.setLcmNewCard(newCurCardInfo);
            iEntry.update((IObjectPK)new ObjectUuidPK(entry.getId().toString()), entry);
            if (entry.getLcmCurCard() == null || entry.getLcmCurCard().getId() == null) continue;
            cardSet.add(entry.getLcmCurCard().getId());
        }
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus,FUsableAmt)=(select GETDATE(),'" + currentUserId + "',1,t_lcm_lcmcurcard.FUsableAmt-FQuantity from T_LCM_LCMDispatchBillEntry where FLcmDispatchBillID='" + billId + "' and FLcmCurCardID=t_lcm_lcmcurcard.fid ) where t_lcm_lcmcurcard.fid in (select FLcmCurCardID from T_LCM_LCMDispatchBillEntry where FLcmDispatchBillID='" + billId + "')"));
        try {
            this.updateDispatchNumForCurCard(ctx, billId);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        inBillInfo.setHasAffirmed(true);
        inBillInfo.setAffirmDate(new Date());
        inBillInfo.setAffirmer(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        this._update(ctx, (IObjectPK)new ObjectUuidPK(inBillInfo.getId().toString()), (IObjectValue)inBillInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("dispatchDirection"));
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("id", (Object)inBillInfo.getId().toString(), CompareType.NOTEQUALS));
        filterItems.add(new FilterItemInfo("company.id", (Object)inBillInfo.getOutCompany().getId().toString()));
        filterItems.add(new FilterItemInfo("number", (Object)inBillInfo.getNumber()));
        filterItems.add(new FilterItemInfo("dispatchDirection", (Object)new Integer("0")));
        CoreBaseCollection outBillInfoCollection = this.getCollection(ctx, entityViewInfo);
        LCMDisPatchBillInfo outBillInfo = (LCMDisPatchBillInfo)outBillInfoCollection.get(0);
        outBillInfo.setHasAffirmed(true);
        outBillInfo.setAffirmDate(new Date());
        outBillInfo.setAffirmer(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        this._update(ctx, (IObjectPK)new ObjectUuidPK(outBillInfo.getId().toString()), (IObjectValue)outBillInfo);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, outBillInfo.getCompany(), cardSet);
        }
        return false;
    }

    @Override
    protected boolean _unAffirm(Context ctx, IObjectPK billId) throws EASBizException, BOSException {
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        LCMDisPatchBillInfo inBillInfo = this.getLCMDisPatchBillInfo(ctx, billId, this.getDispatchSelector());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("company.id", (Object)inBillInfo.getOutCompany().getId().toString()));
        filterItems.add(new FilterItemInfo("number", (Object)inBillInfo.getNumber()));
        filterItems.add(new FilterItemInfo("dispatchDirection", (Object)new Integer("0")));
        CoreBaseCollection outBillInfoCollection = this.getCollection(ctx, entityViewInfo);
        LCMDisPatchBillInfo outBillInfo = (LCMDisPatchBillInfo)outBillInfoCollection.get(0);
        if (outBillInfo.isFiVouchered()) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"39_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale())));
        }
        if (inBillInfo.getDispatchDirection() == 0) {
            EntityViewInfo entityViewInfos = new EntityViewInfo();
            FilterInfo filterInfos = new FilterInfo();
            FilterItemCollection filterItemss = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("company.id", (Object)inBillInfo.getInCompany().getId().toString()));
            filterItems.add(new FilterItemInfo("number", (Object)inBillInfo.getNumber()));
            filterItems.add(new FilterItemInfo("dispatchDirection", (Object)new Integer("1")));
            CoreBaseCollection outBillInfoCollections = this.getCollection(ctx, entityViewInfo);
            inBillInfo = (LCMDisPatchBillInfo)outBillInfoCollection.get(0);
        }
        int size = inBillInfo.getEntry().size();
        ILCMDispatchBillEntry iEntry = LCMDispatchBillEntryFactory.getLocalInstance(ctx);
        IObjectPK[] arrayPK = new IObjectPK[size];
        for (int i = 0; i < size; ++i) {
            LCMDispatchBillEntryInfo entry = inBillInfo.getEntry().get(i);
            LCMCurCardInfo newCurCardInfo = entry.getLcmNewCard();
            if (newCurCardInfo.getCheckedStatus() != null && newCurCardInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"24_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale()));
            }
            entry.setLcmNewCard(null);
            iEntry.update((IObjectPK)new ObjectUuidPK(entry.getId().toString()), entry);
            if (newCurCardInfo.getId() != null) {
                arrayPK[i] = new ObjectUuidPK(newCurCardInfo.getId().toString());
            }
            if (entry.getLcmCurCard() == null || entry.getLcmCurCard().getId() == null) continue;
            cardSet.add(entry.getLcmCurCard().getId());
        }
        ILCMCurCard iLCMCurCard = LCMCurCardFactory.getLocalInstance(ctx);
        iLCMCurCard.delete(arrayPK);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus,FUsableAmt)=(select GETDATE(),'" + currentUserId + "',2 , t_lcm_lcmcurcard.FUsableAmt+FQuantity  from T_LCM_LCMDispatchBillEntry e where e.FLcmDispatchBillID='" + billId + "' and e.FLcmCurCardID=t_lcm_lcmcurcard.fid) where t_lcm_lcmcurcard.fid in (select m.FLcmCurCardID from T_LCM_LCMDispatchBillEntry m where m.FLcmDispatchBillID='" + billId + "')"));
        try {
            this.updateDispatchNumForCurCard(ctx, billId);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        inBillInfo.setHasAffirmed(false);
        inBillInfo.setAffirmDate(null);
        inBillInfo.setAffirmer(null);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(billId.toString()), (IObjectValue)inBillInfo);
        if (outBillInfo != null) {
            outBillInfo.setHasAffirmed(false);
            outBillInfo.setAffirmDate(null);
            outBillInfo.setAffirmer(null);
            this._update(ctx, (IObjectPK)new ObjectUuidPK(outBillInfo.getId().toString()), (IObjectValue)outBillInfo);
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, outBillInfo.getCompany(), cardSet);
        }
        return false;
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMDisPatchBillInfo outBillInfo = this.getLCMDisPatchBillInfo(ctx, pk, this.getDispatchSelector());
        this.checkForUnAudit(ctx, (IObjectValue)outBillInfo);
        outBillInfo.setAuditor(null);
        outBillInfo.setAuditTime(null);
        StringBuffer inBillSql = new StringBuffer();
        inBillSql.append("select id, number ");
        inBillSql.append("where company.id = '" + outBillInfo.getInCompany().getId().toString() + "' ");
        inBillSql.append("and number = '" + outBillInfo.getNumber() + "' ");
        inBillSql.append("and dispatchDirection = 1");
        LCMDisPatchBillInfo inBillInfo = this.getLCMDisPatchBillInfo(ctx, inBillSql.toString());
        this.checkForUnAudit(ctx, (IObjectValue)inBillInfo);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus)=(select GETDATE(),'" + currentUserId + "',2 from T_LCM_LCMDispatchBillEntry e where e.FLcmDispatchBillID='" + pk + "' and e.FLcmCurCardID=t_lcm_lcmcurcard.fid) where t_lcm_lcmcurcard.fid in (select m.FLcmCurCardID from T_LCM_LCMDispatchBillEntry m where m.FLcmDispatchBillID='" + pk + "')"));
        super._unpassAudit(ctx, pk, (IObjectValue)outBillInfo);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("id", (Object)inBillInfo.getId().toString()));
        this.delete(ctx, filterInfo);
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (outBillInfo.getEntry() != null) {
            Iterator it = outBillInfo.getEntry().iterator();
            while (it.hasNext()) {
                LCMDispatchBillEntryInfo entry = (LCMDispatchBillEntryInfo)it.next();
                if (entry == null || entry.getLcmCurCard() == null || entry.getLcmCurCard().getId() == null) continue;
                cardSet.add(entry.getLcmCurCard().getId());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, outBillInfo.getCompany(), cardSet);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMDisPatchBillInfo outBillInfo = this.getLCMDisPatchBillInfo(ctx, pk, this.getDispatchSelector());
        this.checkForAudit(ctx, (IObjectValue)outBillInfo);
        outBillInfo.setDispatchDirection(0);
        outBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        outBillInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        outBillInfo.setAuditTime(new Date());
        outBillInfo.setBizDate(new Date());
        super._passAudit(ctx, pk, (IObjectValue)outBillInfo);
        LCMDisPatchBillInfo inBillInfo = (LCMDisPatchBillInfo)this.getLCMDisPatchBillInfo(ctx, pk, this.getDispatchSelector()).clone();
        inBillInfo.setCU(inBillInfo.getInCompany().getCU());
        inBillInfo.setCompany(inBillInfo.getInCompany());
        inBillInfo.setDispatchDirection(1);
        inBillInfo.setId(null);
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(inBillInfo.getInCompany().getId().toString()));
        inBillInfo.setPeriod(period);
        inBillInfo.getEntry().clear();
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        LCMDispatchBillEntryCollection outBillEnties = outBillInfo.getEntry();
        int billEntryCnt = outBillEnties.size();
        for (int i = 0; i < billEntryCnt; ++i) {
            LCMDispatchBillEntryInfo inBillEntry = (LCMDispatchBillEntryInfo)outBillEnties.get(i).clone();
            inBillEntry.setId(null);
            inBillEntry.setLcmDispatchBill(inBillInfo);
            inBillInfo.getEntry().add(inBillEntry);
            if (inBillEntry.getLcmCurCard() == null || inBillEntry.getLcmCurCard().getId() == null) continue;
            cardSet.add(inBillEntry.getLcmCurCard().getId());
        }
        this.innerAddnew(ctx, (IObjectValue)inBillInfo);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, outBillInfo.getCompany(), cardSet);
        }
    }

    private void beforeSave(Context ctx, IObjectValue model, boolean isSubmit) throws EASBizException, BOSException {
        LCMDisPatchBillInfo bill = (LCMDisPatchBillInfo)model;
        CompanyOrgUnitInfo companyinfo = this.getCurrentCompany(ctx);
        String companyId = companyinfo.getId().toString();
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)bill, 1);
        bill.setHasAffirmed(false);
        bill.setBizDate(LCMUtils.getBizDate(ctx, companyId));
        if (isSubmit) {
            bill.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        } else {
            bill.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        }
        bill.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        if (bill.getId() == null) {
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(model, bill.getCompany().getId().toString());
            if (number == null || number.length() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.discardNumEmpty", (Locale)ctx.getOriginLocale())));
            }
            if (this._exists(ctx, "where company.id='" + bill.getCompany().getId() + "' and number='" + number + "'")) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"25_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"26_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale())));
            }
            bill.setNumber(number);
        } else {
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            LCMDisPatchBillInfo savedBill = this.getLCMDisPatchBillInfo(ctx, "select effectedStatus where id='" + bill.getId() + "'");
            if (!isSubmit && savedBill.getEffectedStatus().getValue() == 2) {
                throw new LCMDiscardBillException(LCMDiscardBillException.BILL_HAD_EFFECTED);
            }
            DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select flcmcurcardid from T_LCM_LCMDispatchBillEntry where FLcmDispatchBillID= '" + bill.getId() + "')"));
            DbUtil.execute((Context)ctx, (String)("delete from T_LCM_LCMDispatchBillEntry where FLcmDispatchBillID= '" + bill.getId() + "'"));
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkStateForDel(ctx, pk);
        LCMDisPatchBillInfo info = this.getLCMDisPatchBillInfo(ctx, "select number,checkedStatus,period.id,period.number,company.id,company.number,CU.id,CU.number,entry.id,entry.lcmCurCard.id where id='" + pk + "'");
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 0);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus)=(select top 1 GETDATE(),'" + currentUserId + "',1 FROM KSQL_USERTABLES) where fid in (select FLcmCurCardID from T_LCM_LCMDispatchBillEntry  where FLcmDispatchBillID='" + pk + "')"));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)info, info.getCompany().getId().toString(), info.getNumber());
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (info.getEntry() != null) {
            Iterator it = info.getEntry().iterator();
            while (it.hasNext()) {
                LCMDispatchBillEntryInfo entry = (LCMDispatchBillEntryInfo)it.next();
                if (entry == null || entry.getLcmCurCard() == null || entry.getLcmCurCard().getId() == null) continue;
                cardSet.add(entry.getLcmCurCard().getId());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMUtils.checkForSubmit(ctx, model);
        this.beforeSave(ctx, model, true);
        IObjectPK pk = super._submit(ctx, model);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus)=(select top 1 GETDATE(),'" + currentUserId + "',2 FROM KSQL_USERTABLES) where fid in (select FLcmCurCardID from T_LCM_LCMDispatchBillEntry  where FLcmDispatchBillID='" + pk + "')"));
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMDisPatchBillInfo bill = (LCMDisPatchBillInfo)model;
        this.beforeSave(ctx, model, false);
        IObjectPK pk = super._save(ctx, model);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus)=(select top 1 GETDATE(),'" + currentUserId + "',2 FROM KSQL_USERTABLES) where fid in (select FLcmCurCardID from T_LCM_LCMDispatchBillEntry  where FLcmDispatchBillID='" + pk + "')"));
        return pk;
    }

    protected ILCMAppChecker getLCMAppChecker() {
        return new LCMDispatchChecker();
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this.getLCMAppChecker().checkForAudit(ctx, (BillBaseInfo)model);
        LCMUtils.verifyForLastestPeriod(ctx, model, 4);
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMDisPatchBillInfo bill = (LCMDisPatchBillInfo)model;
        if (bill.isHasAffirmed()) {
            String sbAll = ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"27_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale());
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
        this.getLCMAppChecker().checkForUnAudit(ctx, (BillBaseInfo)model);
        LCMUtils.verifyForLastestPeriod(ctx, model, 5);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            LCMDisPatchBillInfo dispatchBillInfo = (LCMDisPatchBillInfo)sourceBillCollection.getObject(i);
            this.checkForGenerateVoucher(ctx, (IObjectPK)new ObjectUuidPK(dispatchBillInfo.getId()));
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void checkForGenerateVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("effectedStatus"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("*"));
        LCMDisPatchBillInfo dispatchBillInfo = this.getLCMDisPatchBillInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (dispatchBillInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(dispatchBillInfo, ctx));
        }
        if (dispatchBillInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(dispatchBillInfo, ctx));
        }
        if (dispatchBillInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(dispatchBillInfo, ctx));
        }
        if (dispatchBillInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(dispatchBillInfo, ctx));
        }
        if (!dispatchBillInfo.isHasAffirmed()) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"40_LCMDisPatchBillControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpassAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            BOSUuid id = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            this.currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return this.currCompany;
    }

    protected void updateDispatchNumForCurCard(Context ctx, IObjectPK pk) throws BOSException, SQLException {
        StringBuffer idSql = new StringBuffer();
        idSql.append(" select entry.flcmcurcardid lcmcurcardid ");
        idSql.append(" from t_lcm_lcmdispatchbill bill ");
        idSql.append(" inner join t_lcm_lcmdispatchbillentry entry on entry.flcmdispatchbillid = bill.fid ");
        idSql.append(" inner join t_org_company company on company.fid = bill.fincompanyid ");
        idSql.append(" inner join t_bd_person person on person.fid = bill.finsupervisorid ");
        idSql.append(" where bill.fid = '" + pk.toString() + "' ");
        IRowSet idSet = DbUtil.executeQuery((Context)ctx, (String)idSql.toString());
        if (idSet.size() <= 0) {
            return;
        }
        String lcmCurCardId = "";
        BigDecimal zero = new BigDecimal("0.00");
        while (idSet.next()) {
            lcmCurCardId = idSet.getString("lcmcurcardid");
            String lcmCurCardSql = " select fassetamt,FUsableAmt from T_LCM_LCMCurCard where fid = '" + lcmCurCardId + "' ";
            IRowSet cardSet = DbUtil.executeQuery((Context)ctx, (String)lcmCurCardSql);
            BigDecimal assetAmt = zero;
            BigDecimal useableAmt = zero;
            if (cardSet.next()) {
                assetAmt = cardSet.getBigDecimal("fassetamt");
                useableAmt = cardSet.getBigDecimal("FUsableAmt");
            }
            if (useableAmt.compareTo(zero) > 0) {
                if (useableAmt.compareTo(assetAmt) == 0) {
                    DbUtil.execute((Context)ctx, (String)(" update T_LCM_LCMCurCard set fusestatus = 0 where fid = '" + lcmCurCardId + "' "));
                    continue;
                }
                if (useableAmt.compareTo(assetAmt) >= 0) continue;
                DbUtil.execute((Context)ctx, (String)(" update T_LCM_LCMCurCard set fusestatus = 1 where fid = '" + lcmCurCardId + "' "));
                continue;
            }
            if (useableAmt.compareTo(zero) != 0) continue;
            DbUtil.execute((Context)ctx, (String)(" update T_LCM_LCMCurCard set fusestatus = 2 where fid = '" + lcmCurCardId + "' "));
        }
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMDisPatchBillInfo billInfo = this.getLCMDisPatchBillInfo(ctx, "select number,checkedStatus,fiVouchered where id='" + pk + "'");
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private BigDecimal getCurrCompanyRate(Context ctx, Date periodDate, CurrencyInfo srcCyInfo) throws EASBizException, BOSException {
        BigDecimal rate = new BigDecimal("0.00");
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        BOSUuid currCompanyId = company.getId();
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        if (srcCyInfo != null && baseCurrency != null && srcCyInfo.getId().equals((Object)baseCurrency.getId())) {
            rate = new BigDecimal("1.00");
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currCompanyId), sic);
            ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
            ExchangeRateInfo exchangeRateInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), periodDate);
            if (exchangeRateInfo != null) {
                rate = exchangeRateInfo.getConvertRate();
            }
        }
        return rate;
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForEdit(ctx, model);
        return true;
    }
}

