/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardCollection;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillException;
import com.kingdee.eas.fi.lcm.LCMDiscardBillInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMDiscardBillControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LCMDiscardBillControllerBean
extends AbstractLCMDiscardBillControllerBean {
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)" update T_LCM_DiscardBill set FFiVouchered = 1 where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            DbUtil.execute((Context)ctx, (String)" update T_LCM_DiscardBill set FFiVouchered = 0 where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
        }
    }

    @Override
    protected Map _getLeftDiscardAmt(Context ctx, List params) throws BOSException, EASBizException {
        String cardIds = (String)params.get(0);
        if (cardIds.length() == 0) {
            return new HashMap();
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        String sql = "select fcurcardid,sum(FDiscardAmt) from t_lcm_discardbillentry where fcurcardid in(" + cardIds + ") group by fcurcardid";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String cardId = rs.getString(1);
                BigDecimal amount = rs.getBigDecimal(2);
                if (amount == null) {
                    amount = new BigDecimal("0");
                }
                result.put(cardId, amount);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        LCMDiscardBillInfo info = this.getLCMDiscardBillInfo(ctx, pk);
        if (info.getEffectedStatus().getValue() == 1) {
            throw new LCMDiscardBillException(LCMDiscardBillException.BILL_NOT_SUBMIT);
        }
        if (info.getCheckedStatus().getValue() == 2) {
            throw new LCMDiscardBillException(LCMDiscardBillException.BILL_HAD_AUDIT);
        }
        if (info.getDiscardType() == LCMDiscardTypeEnum.CARD) {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 4);
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (info.getEntry() != null) {
            LCMDiscardBillEntryCollection billEntries = info.getEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMDiscardBillEntryInfo entry = (LCMDiscardBillEntryInfo)iter.next();
                if (entry.getCurCard() == null || entry.getCurCard().getId() == null) continue;
                cardSet.add(entry.getCurCard().getId());
            }
        }
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_discardbill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',fauditdate=GETDATE(),fauditorid='" + currentUserId + "',fcheckedstatus=2 where fid='" + pk + "'"));
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus,FUsableAmt)=(select GETDATE(),'" + currentUserId + "',1,t_lcm_lcmcurcard.FUsableAmt-FDiscardAmt from t_lcm_discardbillentry where fbillid='" + pk + "' and fcurcardid=t_lcm_lcmcurcard.fid ) where t_lcm_lcmcurcard.fid in (select fcurcardid from t_lcm_discardbillentry where fbillid='" + pk + "')"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select distinct fbillid from T_LCM_LCMConsumeBillEntry where fid in (select FConsumeEntryID from t_lcm_discardbillentry where fbillid= '" + pk + "'))"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBillEntry set (FLeftQuantity)=(select T_LCM_LCMConsumeBillEntry.FLeftQuantity-e.FDiscardAmt from t_lcm_discardbillentry e where e.fbillid='" + pk + "' and e.FConsumeEntryID=T_LCM_LCMConsumeBillEntry.fid ) where T_LCM_LCMConsumeBillEntry.fid in (select m.FConsumeEntryID from t_lcm_discardbillentry m where m.fbillid='" + pk + "')"));
        try {
            this.updateDiscardNumForCurCard(ctx, pk);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage());
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    private void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, comp.getId().toString());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)comp.getId().toString()))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMDiscardBillInfo info = this.getLCMDiscardBillInfo(ctx, pk);
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)info.getCompany());
        PeriodInfo lcmPeriod = info.getPeriod();
        if (!curPeriod.getId().toString().equals(lcmPeriod.getId().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale())));
        }
        if (info.getCheckedStatus().getValue() != 2) {
            throw new LCMDiscardBillException(LCMDiscardBillException.BILL_NOT_AUDIT);
        }
        if (info.isFiVouchered()) {
            StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasGenVoucher.toString()});
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select c.fnumber from t_lcm_lcmcurcard c inner join t_lcm_discardbillentry e on c.fid=e.fcurcardid where e.fbillid='" + pk + "' and c.FBlockedStatus=2 union all select distinct b.fnumber from t_lcm_lcmconsumebill b inner join t_lcm_lcmconsumebillentry e on b.fid=e.fbillid inner join t_lcm_discardbillentry de on e.fid=de.FConsumeEntryID where de.fbillid='" + pk + "' and b.FBlockedStatus=2"));
            StringBuffer invalidCards = new StringBuffer();
            while (rs.next()) {
                if (invalidCards.length() == 0) {
                    invalidCards.append(rs.getString(1));
                    continue;
                }
                invalidCards.append("," + rs.getString(1));
            }
            if (invalidCards.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", invalidCards.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.billInProcess", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info.getDiscardType() == LCMDiscardTypeEnum.CARD) {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 5);
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (info.getEntry() != null) {
            LCMDiscardBillEntryCollection billEntries = info.getEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMDiscardBillEntryInfo entry = (LCMDiscardBillEntryInfo)iter.next();
                if (entry.getCurCard() == null || entry.getCurCard().getId() == null) continue;
                cardSet.add(entry.getCurCard().getId());
            }
        }
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_discardbill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',fauditdate=null,fauditorid=null,fcheckedstatus=1 where fid='" + pk + "'"));
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set (flastupdatetime,flastupdateuserid,FBlockedStatus,FUsableAmt)=(select GETDATE(),'" + currentUserId + "',2,t_lcm_lcmcurcard.FUsableAmt+e.FDiscardAmt from t_lcm_discardbillentry e where e.fbillid='" + pk + "' and e.fcurcardid=t_lcm_lcmcurcard.fid) where t_lcm_lcmcurcard.fid in (select m.fcurcardid from t_lcm_discardbillentry m where m.fbillid='" + pk + "')"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 2 where T_LCM_LCMConsumeBill.fid in (select distinct e.fbillid from T_LCM_LCMConsumeBillEntry e where e.fid in (select m.FConsumeEntryID from t_lcm_discardbillentry m where m.fbillid= '" + pk + "'))"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBillEntry set (FLeftQuantity)=(select T_LCM_LCMConsumeBillEntry.FLeftQuantity+e.FDiscardAmt from t_lcm_discardbillentry e where e.fbillid='" + pk + "' and e.FConsumeEntryID=T_LCM_LCMConsumeBillEntry.fid) where T_LCM_LCMConsumeBillEntry.fid in (select m.FConsumeEntryID from t_lcm_discardbillentry m where m.fbillid='" + pk + "')"));
        try {
            this.updateDiscardNumForCurCard(ctx, pk);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage());
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpassAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMDiscardBillInfo billInfo = (LCMDiscardBillInfo)model;
        if (billInfo.getId() != null) {
            LCMBillBizProcessor.lockTable(ctx, billInfo.getId().toString());
        }
        if (billInfo.getDiscardType() == LCMDiscardTypeEnum.CARD) {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 3);
        }
        LCMUtils.checkForSubmit(ctx, model);
        this.beforeSave(ctx, model, true);
        ((LCMDiscardBillInfo)model).setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IObjectPK pk = super._submit(ctx, model);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 2 where fid in (select fcurcardid from t_lcm_discardbillentry where fbillid='" + pk + "')"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 2 where fid in (select distinct fbillid from T_LCM_LCMConsumeBillEntry where fid in (select FConsumeEntryID from t_lcm_discardbillentry where fbillid= '" + pk + "'))"));
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    private void beforeSave(Context ctx, IObjectValue model, boolean isSubmit) throws EASBizException, BOSException {
        LCMDiscardBillInfo bill = (LCMDiscardBillInfo)model;
        bill.setDiscardDate(DateTimeUtils.truncateDate((Date)bill.getDiscardDate()));
        boolean isDiscardCard = bill.getDiscardType().getValue() == 1;
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        bill.setBizDate(LCMUtils.getBizDate(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        if (bill.getId() == null) {
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(model, bill.getCompany().getId().toString());
            if (number == null || number.length() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.discardNumEmpty", (Locale)ctx.getOriginLocale())));
            }
            if (this._exists(ctx, "where company.id='" + bill.getCompany().getId() + "' and number='" + number + "'")) {
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.discardNumDup", (Locale)ctx.getOriginLocale()) + number));
            }
            bill.setNumber(number);
        } else {
            LCMDiscardBillInfo savedBill = this.getLCMDiscardBillInfo(ctx, "select effectedStatus where id='" + bill.getId() + "'");
            if (!isSubmit && savedBill.getEffectedStatus().getValue() == 2) {
                throw new LCMDiscardBillException(LCMDiscardBillException.BILL_HAD_EFFECTED);
            }
            DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select fcurcardid from t_lcm_discardbillentry where fbillid= '" + bill.getId() + "')"));
            DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select distinct fbillid from T_LCM_LCMConsumeBillEntry where fid in (select FConsumeEntryID from t_lcm_discardbillentry where fbillid= '" + bill.getId() + "'))"));
            DbUtil.execute((Context)ctx, (String)("delete from t_lcm_discardbillentry where fbillid= '" + bill.getId() + "'"));
        }
        if (isSubmit && !bill.getBoolean("FROM_AUTO_DISCARD")) {
            HashSet<String> newAddCardId = new HashSet<String>();
            for (int i = 0; i < bill.getEntry().size(); ++i) {
                LCMDiscardBillEntryInfo entry = bill.getEntry().get(i);
                newAddCardId.add(isDiscardCard ? entry.getCurCard().getId().toString() : entry.getConsumeEntry().getId().toString());
            }
            StringBuffer updateCardSql = new StringBuffer();
            Iterator it = newAddCardId.iterator();
            while (it.hasNext()) {
                if (updateCardSql.length() == 0) {
                    updateCardSql.append("'" + it.next() + "'");
                    continue;
                }
                updateCardSql.append(",'" + it.next() + "'");
            }
            HashMap quantityParam = LCMUtils.getLCMParameter(bill.getCompany().getId(), ctx);
            int quantityScale = quantityParam.get("LCM_001") == null ? 0 : Integer.parseInt(quantityParam.get("LCM_001").toString());
            ArrayList<String> params = new ArrayList<String>();
            params.add(updateCardSql.toString());
            if (bill.getId() != null) {
                params.add(bill.getId().toString());
            }
            StringBuffer errMsg = new StringBuffer();
            String msgPrefix = isDiscardCard ? ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.billTypeCard", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.billTypeConsumeBill", (Locale)ctx.getOriginLocale());
            for (int i = 0; i < bill.getEntry().size(); ++i) {
                BigDecimal leftAmt;
                LCMDiscardBillEntryInfo entry = bill.getEntry().get(i);
                BigDecimal bigDecimal = leftAmt = isDiscardCard ? entry.getCurCard().getUsableAmt() : entry.getConsumeEntry().getLeftQuantity();
                if (entry.getDiscardAmt().compareTo(leftAmt) <= 0) continue;
                if (errMsg.length() != 0) {
                    errMsg.append(";");
                }
                String billNumber = isDiscardCard ? entry.getCurCard().getNumber() : entry.getConsumeEntry().getBill().getNumber();
                errMsg.append(msgPrefix + billNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.discardNumber", (Locale)ctx.getOriginLocale()) + entry.getDiscardAmt().setScale(quantityScale, 4) + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.exceedDiscardNum", (Locale)ctx.getOriginLocale()) + leftAmt.setScale(quantityScale, 4));
            }
            if (errMsg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", errMsg.toString()));
            }
            IRowSet rs = null;
            rs = isDiscardCard ? DbUtil.executeQuery((Context)ctx, (String)("select fnumber from t_lcm_lcmcurcard where FBlockedStatus=2 and fid in (" + updateCardSql + ")")) : DbUtil.executeQuery((Context)ctx, (String)("select distinct fnumber from T_LCM_LCMConsumeBill where FBlockedStatus=2 and fid in (select fbillid from T_LCM_LCMConsumeBillEntry where fid in(" + updateCardSql + "))"));
            StringBuffer invalidCards = new StringBuffer();
            try {
                while (rs.next()) {
                    if (invalidCards.length() == 0) {
                        invalidCards.append(rs.getString(1));
                        continue;
                    }
                    invalidCards.append("," + rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (invalidCards.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", invalidCards.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.billInProcess", (Locale)ctx.getOriginLocale())));
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, model, false);
        LCMDiscardBillInfo billInfo = (LCMDiscardBillInfo)model;
        if (billInfo.getDiscardType() == LCMDiscardTypeEnum.CARD) {
            LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 1);
        }
        ((LCMDiscardBillInfo)model).setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        IObjectPK pk = super._save(ctx, model);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 2 where fid in (select fcurcardid from t_lcm_discardbillentry where fbillid='" + pk + "')"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 2 where fid in (select distinct fbillid from T_LCM_LCMConsumeBillEntry where fid in (select FConsumeEntryID from t_lcm_discardbillentry where fbillid= '" + pk + "'))"));
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMDiscardBillInfo info = this.getLCMDiscardBillInfo(ctx, "select number,checkedStatus,period.id,period.number,company.id,company.number,CU.id,CU.number,entry.id,entry.curCard.id where id='" + pk + "'");
        if (info.getCheckedStatus().getValue() == 2) {
            throw new LCMDiscardBillException(LCMDiscardBillException.BILL_HAD_AUDIT);
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 0);
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select fcurcardid from t_lcm_discardbillentry where fbillid='" + pk + "')"));
        DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMConsumeBill set flastupdatetime=GETDATE(),flastupdateuserid='" + currentUserId + "',FBlockedStatus = 1 where fid in (select distinct fbillid from T_LCM_LCMConsumeBillEntry where fid in (select FConsumeEntryID from t_lcm_discardbillentry where fbillid= '" + pk + "'))"));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            CodingRuleManagerFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)info, info.getCompany().getId().toString(), info.getNumber());
        }
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (info.getEntry() != null) {
            Iterator it = info.getEntry().iterator();
            while (it.hasNext()) {
                LCMDiscardBillEntryInfo entry = (LCMDiscardBillEntryInfo)it.next();
                if (entry == null || entry.getCurCard() == null || entry.getCurCard().getId() == null) continue;
                cardSet.add(entry.getCurCard().getId());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
        super._delete(ctx, pk);
    }

    protected void updateDiscardNumForCurCard(Context ctx, IObjectPK pk) throws Exception {
        String idSql = " select case when e.fcurcardid is null then ce.FCurCardID else e.fcurcardid end fcurcardid from t_lcm_discardbill b inner join t_lcm_discardbillentry e on b.fid=e.fbillid left join t_lcm_lcmconsumebillentry ce on ce.fid=e.FConsumeEntryID  left outer join t_org_admin dept on dept.fid=b.fdeptid inner join t_bd_person person on person.fid=b.fpersonid where b.fid='" + pk + "'";
        IRowSet idrs = DbUtil.executeQuery((Context)ctx, (String)idSql);
        if (idrs.size() <= 0) {
            return;
        }
        String curCardID = "";
        while (idrs.next()) {
            String sql;
            IRowSet numRs;
            curCardID = idrs.getString("fcurcardid");
            String curSql = "select fassetamt,FUsableAmt from T_LCM_LCMCurCard where fid='" + curCardID + "'";
            IRowSet curRs = DbUtil.executeQuery((Context)ctx, (String)curSql);
            BigDecimal curDiscardNum = new BigDecimal(0);
            BigDecimal usableAmt = new BigDecimal(0);
            if (curRs.next()) {
                curDiscardNum = curRs.getBigDecimal("fassetamt");
                usableAmt = curRs.getBigDecimal("FUsableAmt");
            }
            if ((numRs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select FCurCardID,sum(amt1)FDiscardAmt \n from (select e.fcurcardid,e.FDiscardAmt amt1,e.FDiscardValue amt2,e.FDiscardFee amt3,e.FDiscardIncoming amt4 \n from t_lcm_discardbill b \n inner join t_lcm_discardbillentry e on b.fid=e.fbillid \n left outer join t_org_admin dept on dept.fid=b.fdeptid \n inner join t_bd_person person on person.fid=b.fpersonid \n where e.fcurcardid='" + curCardID + "' and b.fcheckedstatus=2 \n union all \n select ce.FCurCardID,e.FDiscardAmt amt1,e.FDiscardValue amt2,e.FDiscardFee amt3,e.FDiscardIncoming amt4 \n from t_lcm_discardbill b \n inner join t_lcm_discardbillentry e on b.fid=e.fbillid \n inner join t_lcm_lcmconsumebillentry ce on ce.fid=e.FConsumeEntryID \n left outer join t_org_admin dept on dept.fid=b.fdeptid \n inner join t_bd_person person on person.fid=b.fpersonid \n where ce.FCurCardID='" + curCardID + "' and b.fcheckedstatus=2) m \n group by FCurCardID"))).size() <= 0) {
                String uSql = "update t_lcm_lcmcurcard set fdeletedNum=0 where fid='" + curCardID + "'";
                DbUtil.execute((Context)ctx, (String)uSql);
                String cSql = "select t.fquantity,t.fcurcardid,c.fassetamt,c.fusableamt from t_lcm_lcmconsumebillentry t left join t_lcm_lcmcurcard c on c.fid=t.fcurcardid where t.fcurcardid='" + curCardID + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)cSql);
                if (rs.size() > 0) {
                    DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set fusestatus=1 where fid='" + curCardID + "'"));
                } else {
                    DbUtil.execute((Context)ctx, (String)("update t_lcm_lcmcurcard set fusestatus=0 where fid='" + curCardID + "'"));
                }
            }
            if (!numRs.next()) continue;
            String cardID = numRs.getString("FCurCardID");
            BigDecimal discardNum = numRs.getBigDecimal("FDiscardAmt");
            String uSql = "update t_lcm_lcmcurcard set fdeletedNum=" + discardNum + " where fid='" + curCardID + "'";
            DbUtil.execute((Context)ctx, (String)uSql);
            if (curDiscardNum.compareTo(discardNum) == 0) {
                DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMCurCard set fusestatus=2 where fid='" + curCardID + "'"));
                continue;
            }
            if (curDiscardNum.compareTo(discardNum) > 0) {
                DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMCurCard set fusestatus=1 where fid='" + curCardID + "'"));
                continue;
            }
            if (curDiscardNum.compareTo(usableAmt) != 0) continue;
            DbUtil.execute((Context)ctx, (String)("update T_LCM_LCMCurCard set fusestatus=0 where fid='" + curCardID + "'"));
        }
    }

    @Override
    protected IObjectCollection _getCollectionByCard(Context ctx, String cardid) throws BOSException, EASBizException {
        String locale = ctx.getLocale().toString().equals("l2") ? "_l2" : "_l3";
        String sql = "select b.FDiscardDate FDiscardDate,dept.fname" + locale + " deptname,person.fname" + locale + " personname,e.FDiscardAmt amt1,e.FDiscardValue amt2,e.FDiscardFee amt3,e.FDiscardIncoming amt4,e.fremark remark,b.fdiscardtype dtype, e.FamortizeAmount as amortizeAmount, b.fauditdate auditdate  from ";
        sql = sql + "t_lcm_discardbill b inner join t_lcm_discardbillentry e on b.fid=e.fbillid left outer join t_org_admin dept on dept.fid=b.fdeptid ";
        sql = sql + "inner join t_bd_person person on person.fid=b.fpersonid where e.fcurcardid='" + cardid + "' and b.fcheckedstatus=2";
        sql = sql + " union all ";
        sql = sql + "select b.FDiscardDate FDiscardDate,dept.fname" + locale + " deptname,person.fname" + locale + " personname,e.FDiscardAmt amt1,e.FDiscardValue amt2,e.FDiscardFee amt3,e.FDiscardIncoming amt4,e.fremark remark ,b.fdiscardtype dtype,e.FamortizeAmount as amortizeAmount,b.fauditdate auditdate  from ";
        sql = sql + "t_lcm_discardbill b inner join t_lcm_discardbillentry e on b.fid=e.fbillid inner join t_lcm_lcmconsumebillentry ce on ce.fid=e.FConsumeEntryID left outer join t_org_admin dept on dept.fid=b.fdeptid ";
        sql = sql + "inner join t_bd_person person on person.fid=b.fpersonid where ce.FCurCardID='" + cardid + "' and b.fcheckedstatus=2";
        sql = "select * from (" + sql + ") m order by m.auditdate asc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        LCMDiscardBillEntryCollection result = new LCMDiscardBillEntryCollection();
        try {
            while (rs.next()) {
                LCMDiscardBillEntryInfo entry = new LCMDiscardBillEntryInfo();
                LCMDiscardBillInfo bill = new LCMDiscardBillInfo();
                entry.setBill(bill);
                bill.setDiscardDate(rs.getDate(1));
                AdminOrgUnitInfo dept = new AdminOrgUnitInfo();
                dept.setName(rs.getString(2));
                bill.setDept(dept);
                PersonInfo person = new PersonInfo();
                person.setName(rs.getString(3));
                bill.setPerson(person);
                entry.setDiscardAmt(rs.getBigDecimal(4));
                entry.setDiscardValue(rs.getBigDecimal(5));
                entry.setDiscardFee(rs.getBigDecimal(6));
                entry.setDiscardIncoming(rs.getBigDecimal(7));
                entry.setRemark(rs.getString(8));
                bill.setDiscardType(LCMDiscardTypeEnum.getEnum(rs.getInt(9)));
                entry.setAmortizeAmount(rs.getBigDecimal(10));
                result.add(entry);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _autoDiscard(Context ctx, List params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.get(0);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
        String sql = "select fid,FBuyDate,FLife from t_lcm_lcmcurcard where fcompanyid='" + company.getId() + "' and FUsableAmt>0 and FDeletedStatus=1 and FBlockedStatus=1 and FCheckedStatus=2 and FAssetAmt>0 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> idset = new HashSet<String>();
        StringBuffer idbuff = new StringBuffer();
        try {
            while (rs.next()) {
                String useLife = rs.getString(3);
                if (useLife == null || useLife.length() == 0) {
                    useLife = "0";
                }
                int year = 0;
                try {
                    year = new BigDecimal(useLife).intValue();
                    if (year < 0) {
                        year = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(rs.getDate(2));
                endDate.add(1, year);
                long periodnumber = endDate.get(1) * 100 + endDate.get(2) + 1;
                if (periodnumber - (long)(currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber()) > 0L) continue;
                idset.add(rs.getString(1));
                if (idbuff.length() != 0) {
                    idbuff.append(",");
                }
                idbuff.append("'" + rs.getString(1) + "'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (idset.size() == 0) {
            return;
        }
        BigDecimal zero = new BigDecimal("0");
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        SelectorItemCollection sic = v.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("spec"));
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("usableAmt"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("unitPrice"));
        f.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("usableAmt", (Object)zero, CompareType.GREATER));
        LCMCurCardCollection cards = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardCollection(v);
        if (cards.size() == 0) {
            return;
        }
        int scale = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId())).getPrecision();
        ArrayList<String> list = new ArrayList<String>();
        list.add(idbuff.toString());
        LCMDiscardBillInfo bill = new LCMDiscardBillInfo();
        bill.setDiscardDate(currPeriod.getBeginDate());
        bill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        bill.setPeriod(currPeriod);
        bill.setCompany(company);
        bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        bill.setDiscardType(LCMDiscardTypeEnum.CARD);
        bill.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        bill.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        bill.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"20_LCMDiscardBillControllerBean", (Locale)ctx.getOriginLocale()));
        for (int i = 0; i < cards.size(); ++i) {
            LCMCurCardInfo card = cards.get(i);
            BigDecimal leftDiscardAmt = card.getUsableAmt();
            if (leftDiscardAmt.compareTo(zero) == 0) continue;
            LCMDiscardBillEntryInfo entry = new LCMDiscardBillEntryInfo();
            entry.setBill(bill);
            bill.getEntry().add(entry);
            entry.setCurCard(card);
            entry.setCat(card.getAssetCat());
            entry.setNumber(card.getNumber());
            entry.setName(card.getName());
            entry.setSpec(card.getSpecs());
            entry.setMeasureUnit(card.getMeasureUnit());
            entry.setAssetAmt(card.getAssetAmt());
            entry.setDiscardAmt(leftDiscardAmt);
            entry.setDiscardValue(leftDiscardAmt.multiply(card.getExRate()).multiply(card.getUnitPrice()).setScale(scale, 4));
            entry.setDiscardFee(zero);
            entry.setDiscardIncoming(zero);
        }
        if (bill.getEntry().size() == 0) {
            return;
        }
        bill.put("FROM_AUTO_DISCARD", Boolean.TRUE);
        this._save(ctx, (IObjectValue)bill);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(sourceBillCollection.getObject(i).getBOSUuid("id").toString()).append("'");
        }
        try {
            IRowSet rs;
            if (ids.length() > 0 && (rs = DbUtil.executeQuery((Context)ctx, (String)("select fnumber from t_lcm_discardbill where fid in (" + ids + ") and fcheckedstatus=1"))).next()) {
                String number = rs.getString(1);
                throw new EASBizException(new NumericExceptionSubItem("01", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.bill", (Locale)ctx.getOriginLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.cannotGenVoucher", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForEdit(ctx, model);
        return true;
    }
}

