/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.lcm.LCMChangeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDiscardBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMDispatchBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardCollection;
import com.kingdee.eas.fi.lcm.LCMMonCardFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMMonCardControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMCurInitFacadeControllerBean;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class LCMMonCardControllerBean
extends AbstractLCMMonCardControllerBean {
    private static final long serialVersionUID = 5564606024078805750L;

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LCMMonCardInfo cardInfo = (LCMMonCardInfo)model;
        if (cardInfo.getStoreAdress() != null) {
            cardInfo.setAddress(cardInfo.getStoreAdress().getName());
        }
        if (cardInfo.getConsumeDetail() != null) {
            for (int i = 0; i < cardInfo.getConsumeDetail().size(); ++i) {
                LCMConsumeDetailInfo consumeDetailInfo = cardInfo.getConsumeDetail().get(i);
                if (consumeDetailInfo.getStoreAdress() == null) continue;
                consumeDetailInfo.setAddress(consumeDetailInfo.getStoreAdress().getName());
            }
        }
        this.removeTotleLine(model);
        cardInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (cardInfo.getCurCard() != null && cardInfo.getCurCard().getId() != null) {
            cardSet.add(cardInfo.getCurCard().getId());
        }
        super._submit(ctx, pk, model);
        if (cardSet.size() > 0) {
            this.checkBeforeDelete(ctx, cardSet);
            LCMUtils.updateMonCardfromMonCard(ctx, cardInfo.getCompany(), cardInfo.getId().toString(), cardSet);
            LCMUtils.updateCurcardFromMoncard(ctx, cardInfo.getCompany(), cardInfo.getId().toString(), cardSet);
            cardInfo.setCurCard(null);
        }
        if (cardSet.size() == 0) {
            String id = "'" + pk + "'";
            LCMCurInitFacadeControllerBean.addCurCard(ctx, id);
            this.InsertIntoMoncardFromMoncard(ctx, cardInfo.getCompany(), id);
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMMonCardInfo cardInfo = (LCMMonCardInfo)model;
        if (cardInfo.getStoreAdress() != null) {
            cardInfo.setAddress(cardInfo.getStoreAdress().getName());
        }
        if (cardInfo.getOriginAmount() != null && cardInfo.getAssetAmt() != null && cardInfo.getAssetAmt() != new BigDecimal(0.0)) {
            cardInfo.setUnitPrice(cardInfo.getOriginAmount().divide(cardInfo.getAssetAmt(), 4, 4));
        }
        if (cardInfo.getConsumeDetail() != null) {
            for (int i = 0; i < cardInfo.getConsumeDetail().size(); ++i) {
                LCMConsumeDetailInfo consumeDetailInfo = cardInfo.getConsumeDetail().get(i);
                if (consumeDetailInfo.getStoreAdress() == null) continue;
                consumeDetailInfo.setAddress(consumeDetailInfo.getStoreAdress().getName());
            }
        }
        this.removeTotleLine(model);
        cardInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        if (cardInfo.getCurCard() != null && cardInfo.getCurCard().getId() != null) {
            cardSet.add(cardInfo.getCurCard().getId());
        }
        IObjectPK iObjectPK = super._submit(ctx, model);
        if (cardSet.size() > 0) {
            this.checkBeforeDelete(ctx, cardSet);
            LCMUtils.updateMonCardfromMonCard(ctx, cardInfo.getCompany(), cardInfo.getId().toString(), cardSet);
            LCMUtils.updateCurcardFromMoncard(ctx, cardInfo.getCompany(), cardInfo.getId().toString(), cardSet);
            cardInfo.setCurCard(null);
        } else {
            String id = "'" + iObjectPK.toString() + "'";
            LCMCurInitFacadeControllerBean.addCurCard(ctx, id);
            this.InsertIntoMoncardFromMoncard(ctx, cardInfo.getCompany(), id);
        }
        return iObjectPK;
    }

    private void InsertIntoMoncardFromMoncard(Context ctx, CompanyOrgUnitInfo company, String id) throws BOSException, EASBizException {
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(ctx, company);
        int lastestNumber = 0;
        try {
            lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        }
        catch (Exception e) {
            lastestNumber = 0;
        }
        if (lastestPeriodNumber == null || "".equals(lastestPeriodNumber)) {
            return;
        }
        if (lastestNumber >= curPeriod.getNumber()) {
            for (int i = curPeriod.getNumber(); i <= lastestNumber; ++i) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FID from t_bd_period where fnumber = ").append(i);
                sql.append(" and ftypeid = '").append(curPeriod.getPeriodType().getId()).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String strPeriodId = null;
                try {
                    if (rs.next()) {
                        strPeriodId = rs.getString("FID");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (strPeriodId == null || "".equals(strPeriodId)) continue;
                strPeriodId = "'" + strPeriodId + "'";
                sql = new StringBuffer();
                sql.append("Insert into T_LCM_LCMMonCard                                        \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("  FID,                                                              \r\n");
                sql.append("  FPeriodID,                                                        \r\n");
                sql.append("  FCurCardID,                                                       \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(")                                                                   \r\n");
                sql.append("Select                                                              \r\n");
                sql.append(FaLocalUtils.newBosID((Context)ctx, (String)new LCMMonCardInfo().getBOSType().toString()) + " as FID, \r\n");
                sql.append(strPeriodId).append(" as FPeriodID,                                  \r\n");
                sql.append("  FCurCardID as FCurCardID,                                         \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(" From T_LCM_LCMMonCard                                              \r\n");
                sql.append("Where FCompanyID = '").append(company.getId()).append("'            \r\n");
                sql.append("  And FID = ").append(id).append("                                  \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    @Override
    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.removeTotleLine(model);
        super._save(ctx, pk, model);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.removeTotleLine(model);
        return super._save(ctx, model);
    }

    private void removeTotleLine(IObjectValue model) {
        LCMMonCardInfo cardInfo = (LCMMonCardInfo)model;
        if (cardInfo.getConsumeDetail() != null && cardInfo.getConsumeDetail().size() > 0) {
            for (int i = 0; i < cardInfo.getConsumeDetail().size(); ++i) {
                if (cardInfo.getConsumeDetail().get(i).getUseDepartment() != null) continue;
                cardInfo.getConsumeDetail().removeObject(i);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.name"));
        sc.add(new SelectorItemInfo("company.number"));
        sc.add(new SelectorItemInfo("curCard.id"));
        LCMMonCardInfo cardInfo = LCMMonCardFactory.getLocalInstance(ctx).getLCMMonCardInfo(pk, sc);
        if (cardInfo.getCurCard() != null && cardInfo.getCurCard().getId() != null) {
            cardSet.add(cardInfo.getCurCard().getId());
        }
        if (cardSet.size() > 0) {
            this.checkBeforeDelete(ctx, cardSet);
            LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, cardInfo.getCompany(), cardSet);
            LCMCurInitFacadeControllerBean.deleteCurCard(ctx, cardSet);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        HashSet<BOSUuid> cardSet = new HashSet<BOSUuid>();
        HashSet<IObjectPK> PKSet = new HashSet<IObjectPK>();
        CompanyOrgUnitInfo company = null;
        for (int i = 0; i < arrayPK.length; ++i) {
            PKSet.add(arrayPK[i]);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("company.id"));
        sc.add(new SelectorItemInfo("company.name"));
        sc.add(new SelectorItemInfo("company.number"));
        sc.add(new SelectorItemInfo("curCard.id"));
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        v.setSelector(sc);
        filter.getFilterItems().add(new FilterItemInfo("id", PKSet, CompareType.INCLUDE));
        LCMMonCardCollection cardInfoCol = LCMMonCardFactory.getLocalInstance(ctx).getLCMMonCardCollection(v);
        for (int i = 0; i < cardInfoCol.size(); ++i) {
            LCMMonCardInfo cardInfo = cardInfoCol.get(i);
            company = cardInfo.getCompany();
            if (cardInfo.getCurCard() == null || cardInfo.getCurCard().getId() == null) continue;
            cardSet.add(cardInfo.getCurCard().getId());
        }
        if (cardSet.size() > 0) {
            this.checkBeforeDelete(ctx, cardSet);
            LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, company, cardSet);
            LCMCurInitFacadeControllerBean.deleteCurCard(ctx, cardSet);
        }
        super._delete(ctx, arrayPK);
    }

    private void checkBeforeDelete(Context ctx, HashSet set) throws FaCardException, EASBizException, BOSException {
        String ids;
        if (set.size() == 0) {
            return;
        }
        StringBuffer b = new StringBuffer();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            b.append("'").append(it.next()).append("',");
        }
        String string = ids = b.length() > 0 ? b.substring(0, b.length() - 1) : "";
        if (LCMConsumeBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id in (" + ids + ") and bill.number not like 'InitCardNumber%'")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"hasNewConsumeBill", (Locale)ctx.getLocale())});
        }
        if (LCMChangeBillEntryFactory.getLocalInstance(ctx).exists("where LCMCurCard.id in (" + ids + ")")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"hasNewChangeBill", (Locale)ctx.getLocale())});
        }
        if (LCMReturnConsumeBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id in (" + ids + ")")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"hasNewReturnBill", (Locale)ctx.getLocale())});
        }
        if (LCMDiscardBillEntryFactory.getLocalInstance(ctx).exists("where curcard.id in (" + ids + ")")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"hasNewDiscardBill", (Locale)ctx.getLocale())});
        }
        if (LCMDispatchBillEntryFactory.getLocalInstance(ctx).exists("where LCMCurCard.id in (" + ids + ")")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource", (String)"hasNewDispatchBill", (Locale)ctx.getLocale())});
        }
    }
}

