/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.lcm.LCMParamException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LCMParamCheck
implements INewParamCheck {
    private static final Logger logger = Logger.getLogger(LCMParamCheck.class);
    private static Map validatorMap = new HashMap();

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        if (modelCol == null || modelCol.size() == 0) {
            return;
        }
        ParamItemInfo model = modelCol.get(0);
        String number = model.getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (validator != null) {
            if (validator instanceof MultiOrgValidator) {
                ((MultiOrgValidator)validator).check(ctx, modelCol);
            } else {
                int size = modelCol.size();
                for (int i = 0; i < size; ++i) {
                    ((SingleOrgValidator)validator).check(ctx, modelCol.get(i));
                }
            }
        }
    }

    static {
        validatorMap.put("LCM_001", new Validator_LCM001());
        validatorMap.put("LCM_007", new Validator_LCM007());
    }

    private static class Validator_LCM007
    implements SingleOrgValidator {
        private Validator_LCM007() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramItem = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(model.getId()));
            String companyId = paramItem.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id = '" + companyId + "' ");
            if (model.getValue() != null && model.getValue().toString().equals("false")) {
                String sql = "select top 1 fid from t_lcm_lcmcurcard where fcompanyid = ? ";
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
                    if (rs.next()) {
                        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
                        String objName = "";
                        if (!currentCompany.isIsBizUnit()) {
                            objName = companyInfo.getName(ctx.getLocale()) + "(" + companyInfo.getNumber() + ")";
                        }
                        objName = objName + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.cannotChangeAutoDiscard", (Locale)ctx.getOriginLocale());
                        throw new EASBizException(new NumericExceptionSubItem("01", objName));
                    }
                }
                catch (SQLException e) {
                    throw new SQLAccessException(e);
                }
            }
        }
    }

    private static class Validator_LCM001
    implements SingleOrgValidator {
        private Validator_LCM001() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramItem = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(model.getId()));
            String oldValue = paramItem.getValue();
            String newValue = model.getValue();
            if (oldValue == null || newValue == null) {
                return;
            }
            int oldQuantityScale = new Integer(oldValue);
            int newQuantityScale = new Integer(newValue);
            String companyId = paramItem.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id = '" + companyId + "' ");
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)companyInfo);
            if (currenctPeriod != null && newQuantityScale < oldQuantityScale) {
                throw new LCMParamException(LCMParamException.AMTLENGTHISILLEGEL);
            }
        }
    }

    private static interface MultiOrgValidator {
        public void check(Context var1, ParamItemCollection var2) throws BOSException, EASBizException;
    }

    private static interface SingleOrgValidator {
        public void check(Context var1, ParamItemInfo var2) throws BOSException, EASBizException;
    }
}

