/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.lcm.ILCMChangeBill;
import com.kingdee.eas.fi.lcm.ILCMConsumeBill;
import com.kingdee.eas.fi.lcm.ILCMCurCard;
import com.kingdee.eas.fi.lcm.ILCMDisPatchBill;
import com.kingdee.eas.fi.lcm.ILCMDiscardBill;
import com.kingdee.eas.fi.lcm.ILCMReturnConsumeBill;
import com.kingdee.eas.fi.lcm.ILCMReturnGoodsBill;
import com.kingdee.eas.fi.lcm.LCMBaseException;
import com.kingdee.eas.fi.lcm.LCMChangeBillFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMContrastCaclFacadeFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMDisPatchBillFactory;
import com.kingdee.eas.fi.lcm.LCMDiscardBillFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillFactory;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMPeriodCloseFacadeControllerBean;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMPeriodCloseFacadeControllerBean
extends AbstractLCMPeriodCloseFacadeControllerBean {
    private static final long serialVersionUID = 5349945207875052684L;
    private static Logger logger = Logger.getLogger(LCMPeriodCloseFacadeControllerBean.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.lcm.LCMPeriodCloseResource";
    private static final String FA_RES_PATH = "com.kingdee.eas.fi.fa.manage.FaPeriodClose";

    @Override
    protected IObjectValue _carrayForward(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.checkCarrayForward(ctx, company);
        PeriodInfo curPeriod = this.getCurrentPeriod(ctx, company);
        IObjectValue pk = LCMPeriodCloseFacadeControllerBean.periodClose(ctx, false);
        this.processAutoDiscardCard(ctx);
        FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(company.getId().toString(), "9Yj+fTYSQYqdf2PDEqkEuc4XzhY=", curPeriod.getId().toString(), false);
        return pk;
    }

    private void processAutoDiscardCard(Context ctx) throws EASBizException, BOSException {
        boolean autoDiscard;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK pk = new ObjectUuidPK(company.getId());
        paramKeyMap.put("LCM_007", pk);
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        boolean bl = autoDiscard = result.get("LCM_007") == null ? false : Boolean.valueOf(result.get("LCM_007").toString());
        if (autoDiscard) {
            ArrayList<CompanyOrgUnitInfo> params = new ArrayList<CompanyOrgUnitInfo>();
            params.add(company);
            LCMDiscardBillFactory.getLocalInstance(ctx).autoDiscard(params);
        }
    }

    @Override
    protected IObjectValue _carrayBack(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.checkCarrayBack(ctx, currCompany);
        String companyId = currCompany.getId().toString();
        StringBuffer sql = new StringBuffer();
        Object param = null;
        String periodId = LCMPeriodCloseFacadeControllerBean.getCurrCompanyPeriod(ctx).getId().toString();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).prePeriod(SystemEnum.LOWCOSTMATERIAL, (OrgUnitInfo)company);
        PeriodInfo period = LCMPeriodCloseFacadeControllerBean.getCurrCompanyPeriod(ctx);
        periodId = period.getId().toString();
        FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(companyId, "9Yj+fTYSQYqdf2PDEqkEuc4XzhY=", period.getId().toString(), true);
        return period;
    }

    private void checkCarrayForward(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        boolean checkResult;
        boolean isRelAccount;
        if (!SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "notFinishInit")));
        }
        PeriodInfo period = this.getCurrentPeriod(ctx, company);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)period);
        if (nextPeriod == null || nextPeriod.getId() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "noNextPeriod")));
        }
        HashMap hmPara = this.gethmParam(ctx, company);
        boolean isCheckVoucher = isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
        boolean isCheckGL = false;
        if (hmPara != null) {
            String checkGL;
            String checkVoucher = (String)hmPara.get("LCM_003");
            if (checkVoucher != null && checkVoucher.trim().length() > 0) {
                boolean bl = isCheckVoucher = Boolean.valueOf(checkVoucher.trim()) != false && isRelAccount;
            }
            if ((checkGL = (String)hmPara.get("LCM_013")) != null && checkGL.trim().length() > 0) {
                isCheckGL = Boolean.valueOf(checkGL.trim()) != false && isRelAccount;
            }
        }
        this.checkNewCard(ctx, period, isCheckVoucher, company);
        this.checkNewConsumeBill(ctx, period, isCheckVoucher, company);
        this.checkNewDiscardBill(ctx, period, isCheckVoucher, company);
        this.checkNewReturnGoodsBill(ctx, period, isCheckVoucher, company);
        this.checkNewChangeBill(ctx, period, isCheckVoucher, company);
        this.checkNewReturnBill(ctx, period, isCheckVoucher, company);
        this.checkNewDispatchBill(ctx, period, isCheckVoucher, company);
        if (isCheckGL && !(checkResult = LCMContrastCaclFacadeFactory.getLocalInstance(ctx).isAcctEquals(company.getId().toString()))) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "forward_checkGL")));
        }
    }

    private PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
    }

    private void checkCarrayBack(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo LCMPeriod = LCMUtils.getLCMCurrentPeriod(company.getId().toString(), ctx);
        PeriodInfo GLPeriod = LCMUtils.getGLCurrentPeriod(company.getId().toString(), ctx);
        SystemStatusCtrolUtils systemCtrol = new SystemStatusCtrolUtils();
        boolean isRelated = systemCtrol.isRelatedAccount(ctx, company.getId().toString(), SystemEnum.LOWCOSTMATERIAL);
        if (isRelated && LCMPeriod != null && GLPeriod != null && LCMPeriod.getNumber() - 1 < GLPeriod.getNumber()) {
            String companyName = "\u3010" + company.getName() + "\u3011";
            throw new LCMBaseException(LCMBaseException.CHECK_PERIOD, new Object[]{companyName});
        }
        if (this.currentPeriodIsInit(ctx, company)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "back_InitPeriod")));
        }
        if (systemCtrol.isEqualsCurPeriodAndRelPeriod(ctx, company.getId().toString(), SystemEnum.LOWCOSTMATERIAL)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "back_IsRelGL")));
        }
        this.checkAccountSwap(ctx);
    }

    private boolean hasNewCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("lcmperiod.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        return LCMCurCardFactory.getLocalInstance(ctx).exists(filter);
    }

    private void checkNewCard(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ILCMCurCard icard = LCMCurCardFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("lcmperiod.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer("2"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        boolean hasNotAudit = icard.exists(filter);
        if (notGenVoucher) {
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("lcmperiod.id", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("localAmount", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            String mask = "#0 and #1 and #2 and (#3 or #4)  and #5 and #6";
            filter.setMaskString(mask);
            boolean hasVoucher = icard.exists(filter);
            if (hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_NoAuditNoVoucher")), (Object[])new String[]{this.getResource(ctx, FA_RES_PATH, "forward_CurCard")});
            }
            if (!hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewCard_NoVoucher")));
            }
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "forward_HasNewCard_NoAudit")));
        }
    }

    private boolean hasNewConsumeBill(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        return LCMConsumeBillFactory.getLocalInstance(ctx).exists(filter);
    }

    private boolean hasNewDiscardBill(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        return LCMDiscardBillFactory.getLocalInstance(ctx).exists(filter);
    }

    private boolean hasNewChangeBill(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        return LCMChangeBillFactory.getLocalInstance(ctx).exists(filter);
    }

    private boolean hasNewDispatchBill(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        return LCMDisPatchBillFactory.getLocalInstance(ctx).exists(filter);
    }

    private void checkNewDiscardBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ILCMDiscardBill iDiscardBill = LCMDiscardBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iDiscardBill.getType());
        String sql = "select fid from t_lcm_discardbill where fperiodid = ? and fcompanyid = ? and fcheckedStatus != 2 ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
        try {
            boolean hasNotAudit = rowSet.next();
            if (notGenVoucher) {
                sql = "select fid from t_lcm_discardbill where fperiodid = ? and fcompanyid = ? and fcheckedStatus = 2 and ffiVouchered = 0";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
                boolean hasVoucher = rowSet.next();
                if (hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
                }
                if (!hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkNewChangeBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ILCMChangeBill iChangeBill = LCMChangeBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iChangeBill.getType());
        String sql = "select fid from t_lcm_lcmchangebill where fperiodid = ? and fcompanyid = ? and fcheckedStatus != 2 ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
        try {
            boolean hasNotAudit = rowSet.next();
            if (notGenVoucher) {
                sql = "select bill.fid from t_lcm_lcmchangebill bill inner join T_LCM_LCMChangeBillEntry entry on bill.fid=entry.FChangeBillID where bill.fperiodid = ? and bill.fcompanyid = ?   and bill.fcheckedStatus = 2 and bill.ffiVouchered = 0 and (entry.FAccountChange>0 or entry.FAccountAssetChange=1) ";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
                boolean hasVoucher = rowSet.next();
                if (hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
                }
                if (!hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkNewReturnBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ILCMReturnConsumeBill iReturnBill = LCMReturnConsumeBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iReturnBill.getType());
        String sql = "select fid from T_LCM_LCMReturnConsumeBill where fperiodid = ? and fcompanyid = ? and fcheckedStatus != 2 ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
        try {
            boolean hasNotAudit = rowSet.next();
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkNewDispatchBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ILCMDisPatchBill iReturnBill = LCMDisPatchBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iReturnBill.getType());
        try {
            boolean hasVoucher;
            String sql = "select fid from T_LCM_LCMDisPatchBill where fperiodid = ? and fcompanyid = ? and fcheckedStatus != 2 ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
            boolean hasNotAudit = rowSet.next();
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
            if (notGenVoucher) {
                sql = "select fid from T_LCM_LCMDisPatchBill where fperiodid = ? and fcompanyid = ? and fcheckedStatus = 2 and FtotleAmt > 0 and ffiVouchered = 0 and FDispatchDirection = 0 and FOutCompanyID = ?";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString(), company.getId().toString()});
                hasVoucher = rowSet.next();
                if (hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            sql = "select fid from T_LCM_LCMDisPatchBill where fperiodid = ? and fcompanyid = ? and fcheckedStatus = 2 and fhasAffirmed = 0 ";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), company.getId().toString()});
            hasVoucher = rowSet.next();
            if (hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"29_LCMPeriodCloseFacadeControllerBean", (Locale)ctx.getOriginLocale())), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkNewConsumeBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ILCMConsumeBill iConsumeBill = LCMConsumeBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iConsumeBill.getType());
        StringBuffer sql = new StringBuffer();
        sql.append(" select b.fid as fid from t_lcm_lcmconsumebill b");
        sql.append(" where b.fperiodid = '").append(period.getId().toString()).append("'");
        sql.append(" and b.fcompanyid = '").append(company.getId().toString()).append("'");
        sql.append(" and b.fcheckedStatus != ").append(2);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            boolean hasNotAudit = rowSet.next();
            if (notGenVoucher) {
                sql = new StringBuffer();
                sql.append(" select fid from (");
                sql.append(" select b.fid as fid, sum(e.fuseamount) as useamount from t_lcm_lcmconsumebill b");
                sql.append(" inner join t_lcm_lcmconsumebillentry e on b.fid = e.fbillid");
                sql.append(" where b.fperiodid = '").append(period.getId().toString()).append("'");
                sql.append(" and b.fcompanyid = '").append(company.getId().toString()).append("'");
                sql.append(" and b.fcheckedStatus = ").append(2);
                sql.append(" and b.ffiVouchered = 0 and e.FSrcBillEntryID is null");
                sql.append(" group by b.fid ) as t where useamount > 0");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                boolean hasVoucher = rowSet.next();
                if (hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
                }
                if (!hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkNewReturnGoodsBill(Context ctx, PeriodInfo period, boolean notGenVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ILCMReturnGoodsBill iReturnGoodsBill = LCMReturnGoodsBillFactory.getLocalInstance(ctx);
        String billName = this.getEntityAlias(ctx, iReturnGoodsBill.getType());
        StringBuffer sql = new StringBuffer();
        sql.append(" select b.fid as fid from t_lcm_lcmreturngoodsbill b");
        sql.append(" where b.fperiodid = '").append(period.getId().toString()).append("'");
        sql.append(" and b.fcompanyid = '").append(company.getId().toString()).append("'");
        sql.append(" and b.fcheckedStatus != ").append(2);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            boolean hasNotAudit = rowSet.next();
            if (notGenVoucher) {
                sql = new StringBuffer();
                sql.append(" select fid from (");
                sql.append(" select b.fid as fid from t_lcm_lcmreturngoodsbill b");
                sql.append(" inner join t_lcm_lcmreturngoodsbillentry e on b.fid = e.fbillid");
                sql.append(" where b.fperiodid = '").append(period.getId().toString()).append("'");
                sql.append(" and b.fcompanyid = '").append(company.getId().toString()).append("'");
                sql.append(" and b.fcheckedStatus = ").append(2);
                sql.append(" and b.fiVouchered = 0 ");
                sql.append(" group by b.fid ) t");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                boolean hasVoucher = rowSet.next();
                if (hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
                }
                if (!hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void checkAccountSwap(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct ssc.fid as fid");
        sql.append(" FROM t_bd_acctrefcontrast as t");
        sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.fcurrentperiodid = t.fenabledperiodid");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(32);
        sql.append(" and t.fisenabled = 1 and ssc.fisstart = 1");
        sql.append(" and ssc.FCompanyID = '").append(currCompany.getId().toString()).append("'");
        sql.append(" and t.fcontrolunitid = '").append(cuId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FA_RES_PATH, "disableAccount")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean currentPeriodIsInit(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(32)));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod"));
        sic.add(new SelectorItemInfo("startPeriod"));
        SystemStatusCtrolCollection col = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(view);
        if (col.size() == 0) {
            return false;
        }
        PeriodInfo currentPeriod = col.get(0).getCurrentPeriod();
        if (currentPeriod == null || currentPeriod.getId() == null) {
            return false;
        }
        PeriodInfo startPeriod = col.get(0).getStartPeriod();
        if (startPeriod == null || startPeriod.getId() == null) {
            return false;
        }
        return currentPeriod.getId().toString().equals(startPeriod.getId().toString());
    }

    private String getEntityAlias(Context ctx, BOSObjectType bosType) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(bosType);
        String name = entity.getAlias();
        if (name == null) {
            name = entity.getName();
        }
        return name;
    }

    public static IObjectValue periodClose(Context ctx, boolean isCU) throws BOSException, EASBizException {
        LCMMonCardInfo monCard = new LCMMonCardInfo();
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String oprStr = "=";
        String companyId = "'" + currCompany.getId().toString() + "'";
        PeriodInfo period = LCMPeriodCloseFacadeControllerBean.getCurrCompanyPeriod(ctx);
        if (isCU) {
            oprStr = " in ";
            companyId = LCMPeriodCloseFacadeControllerBean.getCompanyIDs(ctx);
            period = LCMPeriodCloseFacadeControllerBean.getCurrCUPeriod(ctx);
        }
        if (period == null) {
            return null;
        }
        if (companyId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        String strPeriodId = "'" + period.getId().toString() + "'";
        String laterPeriodIds = LCMUtils.getLaterPeriodIds(ctx, period.getId().toString());
        sql = new StringBuffer();
        sql.append("Insert into T_LCM_LCMMonCard                                        \r\n");
        sql.append("(                                                                   \r\n");
        sql.append("  FID,                                                              \r\n");
        sql.append("  FPeriodID,                                                        \r\n");
        sql.append("  FCurCardID,                                                       \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
        sql.append(")                                                                   \r\n");
        sql.append("Select                                                              \r\n");
        sql.append(FaLocalUtils.newBosID((Context)ctx, (String)monCard.getBOSType().toString()) + " as FID, \r\n");
        sql.append(strPeriodId).append(" as FPeriodID,                                  \r\n");
        sql.append("  FID \t as FCurCardID,                                             \r\n");
        sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
        sql.append("From T_LCM_LCMCurCard                                               \r\n");
        sql.append("Where FCompanyID ").append(oprStr).append(companyId).append("       \r\n");
        sql.append(" And (FLcmPeriodID not in (").append(laterPeriodIds).append(") or FLcmPeriodID is null)      \r\n");
        sql.append(" And Not Exists (Select mon.FID From T_LCM_LCMMonCard mon               \r\n");
        sql.append(" Where mon.FCompanyID ").append(oprStr).append(companyId).append("  \r\n");
        sql.append(" And mon.FPeriodID = ").append(strPeriodId).append("                \r\n");
        sql.append(" And mon.FCurCardID = T_LCM_LCMCurCard.FID)                         \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String[] companyIDS = companyId.split(",");
        if (isCU) {
            String com = companyId.substring(1, companyId.length() - 1);
            companyIDS = com.split(",");
        }
        period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId()));
        for (int i = 0; i < companyIDS.length; ++i) {
            sql = new StringBuffer();
            sql.append("if exists (Select FCompanyID From T_LCM_LCMLASTESTPERIOD \r\n");
            sql.append(" Where FCompanyID = ").append(companyIDS[i]).append(" \r\n");
            sql.append(" And FNumber < ").append(period.getNumber()).append(") \r\n");
            sql.append("Update T_LCM_LCMLASTESTPERIOD set \r\n");
            sql.append(" FNumber = ").append(period.getNumber());
            sql.append(", FPeriodCloseDate = GETDATE() \r\n");
            sql.append(" Where FCompanyID = ").append(companyIDS[i]).append(" \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("if not exists (Select FCompanyID From T_LCM_LCMLASTESTPERIOD \r\n");
            sql.append(" Where FCompanyID = ").append(companyIDS[i]).append(") \r\n");
            sql.append("Insert into T_LCM_LCMLASTESTPERIOD(FCompanyID, FNumber, FPeriodCloseDate) \r\n");
            sql.append("Values(").append(companyIDS[i]).append(", ").append(period.getNumber()).append(", GETDATE()) \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (isCU) {
            Iterator ite = LCMPeriodCloseFacadeControllerBean.getCompanys(ctx).iterator();
            while (ite.hasNext()) {
                ictrol.nextPeriod(SystemEnum.LOWCOSTMATERIAL, (OrgUnitInfo)((CompanyOrgUnitInfo)ite.next()));
            }
            return LCMPeriodCloseFacadeControllerBean.getCurrCUPeriod(ctx);
        }
        ictrol.nextPeriod(SystemEnum.LOWCOSTMATERIAL, (OrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        return LCMPeriodCloseFacadeControllerBean.getCurrCompanyPeriod(ctx);
    }

    private static String getCompanyIDs(Context ctx) throws BOSException {
        Iterator ite = LCMPeriodCloseFacadeControllerBean.getCompanys(ctx).iterator();
        StringBuffer companyIds = new StringBuffer();
        while (ite.hasNext()) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ite.next();
            companyIds.append(",'").append(company.getId().toString()).append("'");
        }
        if (companyIds.length() > 0) {
            return "(" + companyIds.substring(1) + ")";
        }
        return null;
    }

    private static CompanyOrgUnitCollection getCompanys(Context ctx) throws BOSException {
        String currCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String fName = "FName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct company.fid as companyid,company.fnumber as fnumber, company.").append(fName).append(" as fname");
        sql.append(" from T_ORG_Company company");
        sql.append(" inner join T_BD_SystemStatusCtrol ssc on company.fid = ssc.fcompanyid");
        sql.append(" inner join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID");
        sql.append(" where ss.FName = ").append(32);
        sql.append(" and ssc.fisstart = 1 and company.fisonlyunion = 0");
        sql.append(" and company.fcontrolunitid ='").append(currCuId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("companyid");
                String name = rowSet.getString("fname");
                String number = rowSet.getString("fnumber");
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)id));
                company.setName(name);
                company.setNumber(number);
                companyColl.add(company);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return companyColl;
    }

    private static PeriodInfo getCurrCompanyPeriod(Context ctx) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(32)));
        fic.add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        sic.add(new SelectorItemInfo("currentPeriod.periodType.*"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        if (col.size() > 0) {
            currentPeriod = col.get(0).getCurrentPeriod();
        }
        return currentPeriod;
    }

    private static PeriodInfo getCurrCUPeriod(Context ctx) throws BOSException {
        String currCuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct period.FID AS fid ,period.fTypeid as periodtypeid,period.fperiodyear as periodyear, period.fperiodnumber as periodnumber");
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(32);
        sql.append(" and ssc.fisstart = 1");
        sql.append(" and company.fisonlyunion = 0");
        sql.append(" and company.fcontrolunitid = '").append(currCuId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PeriodInfo period = null;
        try {
            if (rowSet.next()) {
                period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rowSet.getString("fid")));
                period.setPeriodYear(rowSet.getInt("periodyear"));
                period.setPeriodNumber(rowSet.getInt("periodnumber"));
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)rowSet.getString("periodtypeid")));
                period.setPeriodType(periodType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return period;
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    private HashMap gethmParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap hmParam = null;
        ObjectUuidPK pk = new ObjectUuidPK(company.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_013", pk);
        paramKeyMap.put("LCM_003", pk);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        hmParam = iParamControl.getParamHashMap(paramKeyMap);
        return hmParam;
    }

    @Override
    protected String _getLCMLastestPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select FNumber From T_LCM_LCMLASTESTPERIOD Where FCompanyID = '").append(companyId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String lastestPeriodNumber = null;
        try {
            if (rs.next()) {
                lastestPeriodNumber = rs.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty(lastestPeriodNumber)) {
            sql = new StringBuffer();
            sql.append("select max(p.fnumber) as periodnumber from t_lcm_lcmmoncard m ");
            sql.append(" inner join t_bd_period p on p.fid = m.fperiodid ");
            sql.append(" where m.fcompanyid = '").append(companyId).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rowSet.next()) {
                    lastestPeriodNumber = rowSet.getString("periodnumber");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return lastestPeriodNumber;
    }
}

