/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.lcm.ILCMCurCard;
import com.kingdee.eas.fi.lcm.LCMCardCollection;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMConsumeBillException;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillInfo;
import com.kingdee.eas.fi.lcm.LCMSourceTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUseStatusEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMReturnConsumeBillControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMReturnConsumeBillControllerBean
extends AbstractLCMReturnConsumeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.lcm.app.LCMReturnConsumeBillControllerBean");
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    protected static final String LCMCONSUMERESOURCE = "com.kingdee.eas.fi.lcm.LCMReturnConsumeBillResource";
    private boolean isUseWorkflow;
    private int recursiveNumber = 0;
    private BigDecimal ZERO = new BigDecimal("0.00");
    protected int currencyScale = -1;

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        this.checkStateForDel(ctx, pk);
        this._deleteSelf(ctx, pk);
        super._delete(ctx, pk);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            this.checkStateForDel(ctx, arrayPK[i]);
        }
        this._deleteSelf(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        LCMReturnConsumeBillInfo billInfo = LCMReturnConsumeBillFactory.getLocalInstance(ctx).getLCMReturnConsumeBillInfo(pk, sic);
        this.recycleNumber(ctx, billInfo);
        this.releaseBlock(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        for (int i = 0; i < arrayPK.length; ++i) {
            IObjectPK pk = arrayPK[i];
            LCMReturnConsumeBillInfo billInfo = LCMReturnConsumeBillFactory.getLocalInstance(ctx).getLCMReturnConsumeBillInfo(pk, sic);
            this.recycleNumber(ctx, billInfo);
            this.releaseBlock(ctx, pk);
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMReturnConsumeBillInfo billInfo = this.getLCMReturnConsumeBillInfo(ctx, pk, selector);
        this.checkForAudit(ctx, (IObjectValue)billInfo);
        this._passAuditSelf(ctx, pk, (IObjectValue)new LCMReturnConsumeBillInfo());
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        this.isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!this.isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("period.*"));
        LCMReturnConsumeBillInfo billInfo = LCMReturnConsumeBillFactory.getLocalInstance(ctx).getLCMReturnConsumeBillInfo(pk, sic);
        if (billInfo.getEntry() != null) {
            LCMReturnConsumeBillEntryCollection billEntries = billInfo.getEntry();
            ILCMCurCard cardFactory = LCMCurCardFactory.getLocalInstance(ctx);
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                String newNumber;
                LCMReturnConsumeBillEntryInfo entry = (LCMReturnConsumeBillEntryInfo)iter.next();
                if (entry == null) continue;
                LCMConsumeBillEntryInfo consumeBillEntryInfo = this.getLConsumeBillEntryInfo(ctx, entry);
                this.updateCardUseStatusByReturnConsumeEntry(ctx, entry, billInfo.getCompany(), true);
                this.updateConsuemeBillByReturnConsumeEntry(ctx, entry, true);
                LCMCurCardInfo cardInfo = (LCMCurCardInfo)this.addNewLcmCardByReturnConsume(ctx, entry);
                this.updateReturnCardNumber(ctx, cardInfo);
                cardInfo.setAssetAmt(entry.getHasReturnNumber());
                cardInfo.setUsableAmt(entry.getHasReturnNumber());
                cardInfo.setDeletedNum(this.ZERO);
                cardInfo.setDeletedDate(null);
                cardInfo.setFiVouchered(false);
                cardInfo.setVoucher(null);
                cardInfo.setId(null);
                cardInfo.setSourceBillId(null);
                cardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
                cardInfo.setLcmPeriod(billInfo.getPeriod());
                Date today = DateTimeUtils.truncateDate((Date)new Date());
                PeriodInfo period = billInfo.getPeriod();
                if (today.before(period.getBeginDate()) || today.after(period.getEndDate())) {
                    cardInfo.setBuyDate(period.getEndDate());
                    cardInfo.setAccountDate(period.getEndDate());
                } else {
                    cardInfo.setBuyDate(today);
                    cardInfo.setAccountDate(today);
                }
                cardInfo.setSourceType(LCMSourceTypeEnum.returnCard);
                cardInfo.setUseStatus(LCMUseStatusEnum.NOT_USE);
                String returnnumber = cardInfo.getReturnNumber();
                if (returnnumber.length() > 5) {
                    returnnumber = returnnumber.substring(5);
                }
                if ((newNumber = cardInfo.getNumber() + "-" + ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"return", (Locale)ctx.getOriginLocale()) + "-" + returnnumber).length() > 80) {
                    newNumber = newNumber.substring(0, 80);
                }
                cardInfo.setNumber(newNumber);
                if (cardInfo.getAmortizeMode().getValue() == 1) {
                    cardInfo.setOriginAmount(entry.getReturnAmt());
                    cardInfo.setLocalAmount(entry.getLocalAmount());
                    cardInfo.setUnitPrice(entry.getReturnUnitPrice());
                } else if (cardInfo.getAmortizeMode().getValue() == 2) {
                    if (entry.getReturnAmt() == null || entry.getReturnAmt().compareTo(this.ZERO) == 0) {
                        cardInfo.setOriginAmount(entry.getHasReturnNumber().multiply(entry.getUnitPrice()).multiply(new BigDecimal("0.5").setScale(this.getCurrencyScale(ctx), 4)));
                        cardInfo.setLocalAmount(entry.getLocalAmount());
                    } else {
                        cardInfo.setOriginAmount(entry.getReturnAmt());
                        cardInfo.setLocalAmount(entry.getLocalAmount());
                        cardInfo.setUnitPrice(entry.getReturnUnitPrice());
                    }
                }
                IObjectPK cardPk = cardFactory.addnew((CoreBaseInfo)cardInfo);
                entry.setReturnCurCard(cardFactory.getLCMCurCardInfo(cardPk));
            }
        }
        this.releaseBlock(ctx, pk);
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = new Date();
        billInfo.setBizDate(today);
        super._passAudit(ctx, pk, (IObjectValue)billInfo);
    }

    private String getReturnCardNumber(Context ctx, LCMCurCardInfo cardInfo) {
        int number = Integer.parseInt(cardInfo.getReturnNumber());
        String trueNumber = new Integer(++number).toString();
        int numberLength = trueNumber.length();
        String newNumber = "";
        if (numberLength < 4) {
            for (int i = 0; i < 4 - numberLength; ++i) {
                newNumber = newNumber + "0";
            }
            newNumber = newNumber + trueNumber;
        } else {
            newNumber = trueNumber;
        }
        return newNumber;
    }

    private void updateReturnCardNumber(Context ctx, LCMCurCardInfo cardInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("returnNumber"));
        cardInfo.setReturnNumber(this.getReturnCardNumber(ctx, cardInfo));
        LCMCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)cardInfo, sic);
    }

    public SelectorItemCollection getLcmCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("assetCat.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("amortizeMode"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("buyDate"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("sourceMode.*"));
        sic.add(new SelectorItemInfo("dept.*"));
        sic.add(new SelectorItemInfo("keeper.*"));
        sic.add(new SelectorItemInfo("accountAsset.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("lcmPeriod.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("returnNumber"));
        return sic;
    }

    private LCMCardInfo addNewLcmCardByReturnConsume(Context ctx, LCMReturnConsumeBillEntryInfo entryInfo) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)this.getLcmCardSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryInfo.getCurCard().getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        LCMCardCollection cardCollection = LCMCurCardFactory.getLocalInstance(ctx).getLCMCardCollection(entityViewInfo);
        if (cardCollection.size() > 0) {
            return cardCollection.get(0);
        }
        return new LCMCurCardInfo();
    }

    private LCMConsumeBillEntryInfo getLConsumeBillEntryInfo(Context ctx, LCMReturnConsumeBillEntryInfo entryInfo) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryInfo.getConsuemEntryID(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        LCMConsumeBillEntryCollection entryCollection = LCMConsumeBillEntryFactory.getLocalInstance(ctx).getLCMConsumeBillEntryCollection(entityViewInfo);
        if (entryCollection.size() > 0) {
            return entryCollection.get(0);
        }
        return new LCMConsumeBillEntryInfo();
    }

    private void updateCardUseStatusByReturnConsumeEntry(Context ctx, LCMReturnConsumeBillEntryInfo entryInfo, CompanyOrgUnitInfo company, boolean auditOrUnaudit) throws BOSException, EASBizException {
        StringBuilder returnCountSql = new StringBuilder();
        returnCountSql.append("SELECT SUM(entry.FHASRETURNNUMBER) returnCount FROM T_LCM_LCMReturnConsumeBill bill \n");
        returnCountSql.append("LEFT JOIN T_LCM_LCMReturnConsumeEntry entry ON bill.FID = entry.FENTRYID \n");
        returnCountSql.append("WHERE entry.FCURCARDID = ? AND bill.FCheckedStatus = 2");
        IRowSet returnCountRs = DbUtil.executeQuery((Context)ctx, (String)returnCountSql.toString(), (Object[])new String[]{entryInfo.getCurCard().getId().toString()});
        try {
            if (returnCountRs != null && returnCountRs.next()) {
                BigDecimal returnCount = returnCountRs.getBigDecimal("returnCount") == null ? BigDecimal.ZERO : returnCountRs.getBigDecimal("returnCount");
                HashSet<String> cardSet = new HashSet<String>();
                cardSet.add(entryInfo.getCurCard().getId().toString());
                if (auditOrUnaudit) {
                    if (entryInfo.getAssetAmt().compareTo(returnCount.add(entryInfo.getHasReturnNumber())) == 0) {
                        String updateUsSql = "UPDATE T_LCM_LCMCURCARD SET FUSESTATUS = 3 WHERE FID = ?";
                        DbUtil.execute((Context)ctx, (String)updateUsSql.toString(), (Object[])new String[]{entryInfo.getCurCard().getId().toString()});
                        LCMUtils.updateMonCardfromCurCard(ctx, company, cardSet);
                    }
                } else if (entryInfo.getAssetAmt().compareTo(returnCount) == 0) {
                    String updateUsSql = "UPDATE T_LCM_LCMCURCARD SET FUSESTATUS = 1 WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)updateUsSql.toString(), (Object[])new String[]{entryInfo.getCurCard().getId().toString()});
                    LCMUtils.updateMonCardfromCurCard(ctx, company, cardSet);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateConsuemeBillByReturnConsumeEntry(Context ctx, LCMReturnConsumeBillEntryInfo entryInfo, boolean auditOrUnaudit) throws BOSException, FaCardException {
        LCMConsumeBillEntryInfo entry = this.getLConsumeBillEntryInfo(ctx, entryInfo);
        if (entry == null) {
            return;
        }
        if (auditOrUnaudit) {
            BigDecimal nowQuantityBigDecimal = entry.getQuantity().setScale(2, 4).subtract(entryInfo.getHasReturnNumber().setScale(2, 4));
            BigDecimal nowleftquantityBigDecimal = entry.getLeftQuantity().setScale(2, 4).subtract(entryInfo.getHasReturnNumber().setScale(2, 4));
            if (nowleftquantityBigDecimal.compareTo(this.ZERO) == -1) {
                String sbMsg = ResourceBase.getString((String)LCMCONSUMERESOURCE, (String)"ReturnOverLeft", (Locale)ctx.getOriginLocale());
                StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
                sbAll.append(entryInfo.getNumber() + sbMsg);
                sbAll.append("\n");
                throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
            }
            BigDecimal useAmount = this.ZERO;
            useAmount = entry.getUseAmount().compareTo(entryInfo.getHasReturnNumber().multiply(entryInfo.getUnitPrice())) == 0 ? this.ZERO : entry.getUseAmount().setScale(8).subtract(entryInfo.getHasReturnNumber().multiply(entryInfo.getReturnUnitPrice()).setScale(8));
            String updateConsumeSql = "update T_LCM_LCMConsumeBillEntry set FUseAmount=" + RptServerUtil.bigdecimalToString((BigDecimal)useAmount) + ",FQuantity=" + RptServerUtil.bigdecimalToString((BigDecimal)nowQuantityBigDecimal) + ",FLeftQuantity=" + RptServerUtil.bigdecimalToString((BigDecimal)nowleftquantityBigDecimal) + " where fid='" + entry.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateConsumeSql);
        } else {
            BigDecimal nowQuantityBigDecimal = entry.getQuantity().add(entryInfo.getHasReturnNumber());
            BigDecimal nowleftquantityBigDecimal = entry.getLeftQuantity().add(entryInfo.getHasReturnNumber());
            BigDecimal useAmount = this.ZERO;
            useAmount = entry.getUseAmount().compareTo(entryInfo.getHasReturnNumber().multiply(entryInfo.getUnitPrice())) == 0 ? this.ZERO : entry.getUseAmount().setScale(8).add(entryInfo.getHasReturnNumber().multiply(entryInfo.getUnitPrice()).setScale(8));
            String updateConsumeSql = "update T_LCM_LCMConsumeBillEntry set FUseAmount=" + RptServerUtil.bigdecimalToString((BigDecimal)useAmount) + ",FQuantity=" + RptServerUtil.bigdecimalToString((BigDecimal)nowQuantityBigDecimal) + ",FLeftQuantity=" + RptServerUtil.bigdecimalToString((BigDecimal)nowleftquantityBigDecimal) + " where fid='" + entry.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateConsumeSql);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        String pk = model.get("id") == null ? null : model.get("id").toString();
        LCMBillBizProcessor.lockTable(ctx, pk);
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        this.setBlock(ctx, (IObjectValue)billInfo);
        BOSUuid billId = billInfo.getId();
        if (billId != null) {
            ObjectUuidPK billPk = new ObjectUuidPK(billId);
            this.checkSubmit(ctx, (IObjectPK)billPk);
        }
        if ((aCompanyOrgUnitInfo = billInfo.getCompany()) == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        return super._submit(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        LCMBillBizProcessor.lockTable(ctx, pk);
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        if (billInfo.getId() != null && billInfo.getId() != null) {
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        this.setBlock(ctx, (IObjectValue)billInfo);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        return super._save(ctx, model);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMReturnConsumeBillInfo billInfo = this.getLCMReturnConsumeBillInfo(ctx, pk, selector);
        this.checkForUnAudit(ctx, (IObjectValue)billInfo);
        this._unpassAuditSelf(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("entry.*"));
        LCMReturnConsumeBillInfo billInfo = LCMReturnConsumeBillFactory.getLocalInstance(ctx).getLCMReturnConsumeBillInfo(pk, sic);
        if (billInfo.getEntry() != null) {
            try {
                LCMReturnConsumeBillEntryCollection billEntries = billInfo.getEntry();
                ctx.put((Object)"FROM_SOURCE", (Object)"true");
                ILCMCurCard cardFactory = LCMCurCardFactory.getLocalInstance(ctx);
                Iterator iter = billEntries.iterator();
                while (iter.hasNext()) {
                    LCMReturnConsumeBillEntryInfo entry = (LCMReturnConsumeBillEntryInfo)iter.next();
                    this.updateCardUseStatusByReturnConsumeEntry(ctx, entry, billInfo.getCompany(), false);
                    this.updateConsuemeBillByReturnConsumeEntry(ctx, entry, false);
                    if (entry.getReturnCurCard() == null) continue;
                    String curCardId = entry.getReturnCurCard().getId().toString();
                    cardFactory.unpassAudit((IObjectPK)new ObjectUuidPK(entry.getReturnCurCard().getId().toString()), (CoreBillBaseInfo)entry.getReturnCurCard());
                    String updateConsumeSql = "update T_LCM_LCMReturnConsumeEntry set FReturnCurCardID=null where FID='" + entry.getId().toString() + "'";
                    DbUtil.execute((Context)ctx, (String)updateConsumeSql);
                    cardFactory.delete((IObjectPK)new ObjectUuidPK(curCardId));
                    entry.setReturnCurCard(null);
                }
            }
            finally {
                if (ctx.get((Object)"FROM_SOURCE") != null) {
                    ctx.remove((Object)"FROM_SOURCE");
                }
            }
        }
        this.setBlock(ctx, (IObjectValue)billInfo);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setBizDate(null);
        this.setWorkflowServiceState(ctx, pk);
        super._unpassAudit(ctx, pk, (IObjectValue)billInfo);
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        LCMReturnConsumeBillInfo billInfo = this.getLCMReturnConsumeBillInfo(ctx, pk);
        if (EffectedStatusEnum.EFFECTED.equals((Object)billInfo.getEffectedStatus())) {
            String msg = this.getEffectedStatus(billInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer();
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        PeriodInfo lcmPeriod = billInfo.getPeriod();
        if (!curPeriod.getId().toString().equals(lcmPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        LCMReturnConsumeBillInfo billInfo = this.getLCMReturnConsumeBillInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 0);
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            if (caller.getNumber() == null) {
                return;
            }
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (this.existNumber(ctx, model)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
        return true;
    }

    protected void setNewNumber(Context ctx, LCMReturnConsumeBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        billInfo.setBizDate(LCMUtils.getBizDate(ctx, strCompanyId));
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            ++this.recursiveNumber;
            if (this.recursiveNumber >= 100) {
                this.recursiveNumber = 0;
                throw new LCMConsumeBillException(LCMConsumeBillException.GENGERATENUMBERRULEISWRONG);
            }
            this.setNewNumber(ctx, billInfo);
        } else {
            this.recursiveNumber = 0;
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)billInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    protected int getCurrencyScale(Context ctx) throws EASBizException, BOSException {
        if (this.currencyScale == -1) {
            this.currencyScale = this.getCurrencyScale(ctx, ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        return this.currencyScale == -1 ? 2 : this.currencyScale;
    }

    public int getCurrencyScale(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    private void setBlock(Context ctx, IObjectValue model) throws BOSException {
        LCMReturnConsumeBillInfo billInfo = (LCMReturnConsumeBillInfo)model;
        if (billInfo.getEntry() != null) {
            LCMReturnConsumeBillEntryCollection billEntries = billInfo.getEntry();
            Iterator iter = billEntries.iterator();
            while (iter.hasNext()) {
                LCMReturnConsumeBillEntryInfo entry = (LCMReturnConsumeBillEntryInfo)iter.next();
                if (entry.getConsumeBill().getId().toString().trim().length() == 0) continue;
                String entryID = entry.getConsumeBill().getId().toString();
                String sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  2  where fid = '" + entryID + "' ";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
    }

    private void releaseBlock(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.consumeBill.id"));
        LCMReturnConsumeBillInfo billInfo = this.getLCMReturnConsumeBillInfo(ctx, pk, selector);
        LCMReturnConsumeBillEntryCollection billEntries = billInfo.getEntry();
        Iterator iter = billEntries.iterator();
        while (iter.hasNext()) {
            LCMReturnConsumeBillEntryInfo entry = (LCMReturnConsumeBillEntryInfo)iter.next();
            if (entry.getConsumeBill().getId().toString().trim().length() == 0) continue;
            String billID = entry.getConsumeBill().getId().toString();
            String sql = "update T_LCM_LCMConsumeBill set FBlockedStatus =  1  where fid = '" + billID + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void checkSubmit(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        LCMReturnConsumeBillInfo returnConsumeBillInfo = this.getLCMReturnConsumeBillInfo(ctx, pk);
        if (CheckedStatusEnum.AUDITED.equals((Object)returnConsumeBillInfo.getCheckedStatus())) {
            String msg = this.getCheckedStatus(returnConsumeBillInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMUtils.checkForEdit(ctx, model);
        return true;
    }
}

