/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillCollection;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillEntryCollection;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillEntryInfo;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillException;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsBillInfo;
import com.kingdee.eas.fi.lcm.LCMReturnGoodsTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.AbstractLCMReturnGoodsBillControllerBean;
import com.kingdee.eas.fi.lcm.app.LCMBillBizProcessor;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMReturnGoodsBillControllerBean
extends AbstractLCMReturnGoodsBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.lcm.app.LCMReturnGoodsBillControllerBean");
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final BigDecimal ZERO = new BigDecimal("0");
    private int recursiveNumber = 0;

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo((Context)ctx, (IObjectValue)bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMReturnGoodsBill set FiVouchered = 1, FVoucherID = ? where fid = ? ", (Object[])new Object[]{voucher.getId().toString(), srcBillPK.toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            DbUtil.execute((Context)ctx, (String)" update T_LCM_LCMReturnGoodsBill set FiVouchered = 0, FVoucherID = null where fid = ? ", (Object[])new Object[]{srcBillPK.toString()});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        LCMReturnGoodsBillInfo bill = (LCMReturnGoodsBillInfo)model;
        LCMBillBizProcessor.lockTable(ctx, pk);
        this.beforeSave(ctx, bill, false);
        LCMUtils.verifyForLastestPeriod(ctx, model, 1);
        bill.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        IObjectPK pkSaved = super._save(ctx, model);
        this.updateCurCardBlockedStatus(ctx, pkSaved, 2);
        return pkSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LCMReturnGoodsBillInfo bill = (LCMReturnGoodsBillInfo)model;
        if (bill.getId() != null) {
            LCMBillBizProcessor.lockTable(ctx, bill.getId().toString());
        }
        LCMUtils.verifyForLastestPeriod(ctx, model, 3);
        this.beforeSave(ctx, bill, true);
        LCMUtils.checkForSubmit(ctx, model);
        LCMReturnGoodsBillEntryCollection entries = bill.getEntries();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            LCMReturnGoodsBillEntryInfo entry = (LCMReturnGoodsBillEntryInfo)iter.next();
            StringBuffer cardSql = new StringBuffer();
            cardSql.append(" SELECT FUsableAmt usableAmt, FCheckedStatus checkedStatus FROM T_LCM_LCMCURCARD WHERE FID = '");
            cardSql.append(entry.getCurCard().getId().toString());
            cardSql.append("'");
            IRowSet cardRS = DbUtil.executeQuery((Context)ctx, (String)cardSql.toString());
            try {
                Integer ckStatus = null;
                BigDecimal quantity = entry.getQuantity();
                BigDecimal usableAmt = null;
                if (cardRS.next()) {
                    ckStatus = cardRS.getInt("checkedStatus");
                    usableAmt = cardRS.getBigDecimal("usableAmt");
                }
                if (2 != ckStatus) {
                    throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CURCARD_NO_AUDIT);
                }
                if (usableAmt != null && quantity.compareTo(usableAmt) != 1) continue;
                throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.USEABLEAMTINSUFFICIENT);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
        }
        bill.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IObjectPK pkSubmited = super._submit(ctx, model);
        this.updateCurCardBlockedStatus(ctx, pkSubmited, 2);
        return pkSubmited;
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.baseCurrency.*"));
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("entries.curCard.id"));
        selector.add(new SelectorItemInfo("entries.curCard.usableAmt"));
        selector.add(new SelectorItemInfo("entries.curCard.assetAmt"));
        selector.add(new SelectorItemInfo("entries.curCard.originAmount"));
        selector.add(new SelectorItemInfo("entries.curCard.unitPrice"));
        selector.add(new SelectorItemInfo("entries.curCard.checkedStatus"));
        LCMReturnGoodsBillInfo info = this.getLCMReturnGoodsBillInfo(ctx, pk, selector);
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 1);
        if (DeletedStatusEnum.DELETED.equals((Object)info.getDeletedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_AUDITED_BILL_DELETED);
        }
        if (EffectedStatusEnum.TEMPSTORE.equals((Object)info.getEffectedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_AUDITED_BILL_NO_SUBMIT);
        }
        if (CheckedStatusEnum.AUDITED.equals((Object)info.getCheckedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_AUDITED_BILL_AUDITED);
        }
        if (info.isFiVouchered()) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_AUDITED_BILL_VOUCHERED);
        }
        this._passAuditSelf(ctx, pk, info);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, LCMReturnGoodsBillInfo info) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        LCMReturnGoodsBillEntryCollection entries = info.getEntries();
        BigDecimal exRate = info.getExRate();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            BigDecimal usableAmt;
            LCMReturnGoodsBillEntryInfo entry = (LCMReturnGoodsBillEntryInfo)iter.next();
            if (2 != entry.getCurCard().getCheckedStatus().getValue()) {
                throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CURCARD_NO_AUDIT);
            }
            BigDecimal quantity = entry.getQuantity();
            if (quantity.compareTo(usableAmt = entry.getCurCard().getUsableAmt()) == 1) {
                throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.USEABLEAMTINSUFFICIENT);
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" UPDATE T_LCM_LCMCURCARD SET FUSABLEAMT = FUSABLEAMT - ");
            updateSql.append(quantity.toString());
            updateSql.append(", FBLOCKEDSTATUS = 1 ");
            updateSql.append(" WHERE FID = '");
            updateSql.append(entry.getCurCard().getId());
            updateSql.append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            BigDecimal cardOriginAmount = entry.getCurCard().getOriginAmount();
            BigDecimal originAmount = ZERO;
            BigDecimal localAmount = ZERO;
            BigDecimal assetAmt = entry.getCurCard().getAssetAmt();
            BigDecimal unitPrice = entry.getCurCard().getUnitPrice();
            if (quantity.compareTo(usableAmt) == 0) {
                BigDecimal unUseAmount = assetAmt.subtract(quantity).multiply(unitPrice);
                originAmount = cardOriginAmount.subtract(unUseAmount);
            } else {
                originAmount = quantity.multiply(unitPrice);
            }
            localAmount = originAmount.multiply(exRate);
            entry.setOriginAmount(this.formatBigDecmal(originAmount, this.getCurrencyScale(info.getCompany())));
            entry.setLocalAmount(this.formatBigDecmal(localAmount, this.getCurrencyScale(info.getCompany())));
            cardSet.add(entry.getCurCard().getId().toString());
        }
        info.setCheckedStatus(CheckedStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setBizDate(new Date());
        super._passAudit(ctx, pk, (IObjectValue)info);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
    }

    private BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(ZERO) == 0) {
            data = ZERO;
        }
        return data.setScale(scale, 4);
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        LCMReturnGoodsBillInfo info = this.getLCMReturnGoodsBillInfo(ctx, pk);
        if (DeletedStatusEnum.DELETED.equals((Object)info.getDeletedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_UNAUDITED_BILL_DELETED);
        }
        if (EffectedStatusEnum.TEMPSTORE.equals((Object)info.getEffectedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_UNAUDITED_BILL_NO_SUBMIT);
        }
        if (CheckedStatusEnum.UNAUDITED.equals((Object)info.getCheckedStatus())) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_UNAUDITED_BILL_UNAUDITED);
        }
        if (info.isFiVouchered()) {
            throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_UNAUDITED_BILL_VOUCHERED);
        }
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)info, 5);
        try {
            StringBuffer selectCardSql = new StringBuffer();
            selectCardSql.append(" select c.fnumber from t_lcm_lcmcurcard c inner join t_lcm_lcmreturngoodsbillentry e on c.fid=e.fcurcardid where e.fbillid='");
            selectCardSql.append(pk);
            selectCardSql.append("' and c.FBlockedStatus = 2 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectCardSql.toString());
            StringBuffer invalidCards = new StringBuffer();
            while (rs.next()) {
                if (invalidCards.length() == 0) {
                    invalidCards.append(rs.getString(1));
                    continue;
                }
                invalidCards.append("," + rs.getString(1));
            }
            if (invalidCards.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("01", invalidCards.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMResource.billInProcess", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this._unpassAuditSelf(ctx, pk, info);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, LCMReturnGoodsBillInfo info) throws BOSException, EASBizException {
        HashSet<String> cardSet = new HashSet<String>();
        Iterator iter = info.getEntries().iterator();
        while (iter.hasNext()) {
            LCMReturnGoodsBillEntryInfo entry = (LCMReturnGoodsBillEntryInfo)iter.next();
            StringBuffer updateCardSql = new StringBuffer();
            updateCardSql.append(" UPDATE T_LCM_LCMCURCARD SET FUSABLEAMT = FUSABLEAMT + ");
            updateCardSql.append(entry.getQuantity().toString());
            updateCardSql.append(", FBLOCKEDSTATUS = 2 ");
            updateCardSql.append(" WHERE FID = '");
            updateCardSql.append(entry.getCurCard().getId().toString());
            updateCardSql.append("'");
            DbUtil.execute((Context)ctx, (String)updateCardSql.toString());
            cardSet.add(entry.getCurCard().getId().toString());
        }
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setAuditor(null);
        info.setBizDate(null);
        super._unpassAudit(ctx, pk, (IObjectValue)info);
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, info.getCompany(), cardSet);
        }
    }

    private void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, comp.getId().toString());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)comp.getId().toString()))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = LCMUtils.isUseWorkflow(ctx, companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow((Context)ctx, (String)objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            this.checkStateForDel(ctx, arrayPK[i]);
        }
        this._deleteSelf(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        for (int i = 0; i < arrayPK.length; ++i) {
            IObjectPK pk = arrayPK[i];
            LCMReturnGoodsBillInfo billInfo = this.getLCMReturnGoodsBillInfo(ctx, pk, sic);
            this.recycleNumber(ctx, billInfo);
            this.updateCurCardBlockedStatus(ctx, pk, 1);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LCMBillBizProcessor.lockTable(ctx, pk.toString());
        this.checkStateForDel(ctx, pk);
        this._deleteSelf(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        LCMReturnGoodsBillInfo billInfo = this.getLCMReturnGoodsBillInfo(ctx, pk, sic);
        this.recycleNumber(ctx, billInfo);
        this.updateCurCardBlockedStatus(ctx, pk, 1);
        HashSet<String> cardSet = new HashSet<String>();
        if (billInfo.getEntries() != null) {
            Iterator it = billInfo.getEntries().iterator();
            while (it.hasNext()) {
                LCMReturnGoodsBillEntryInfo entry = (LCMReturnGoodsBillEntryInfo)it.next();
                if (entry == null || entry.getCurCard() == null || entry.getCurCard().getId() == null) continue;
                cardSet.add(entry.getCurCard().getId().toString());
            }
        }
        if (cardSet.size() > 0) {
            LCMUtils.updateMonCardfromCurCard(ctx, billInfo.getCompany(), cardSet);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        Iterator iter = sourceBillCollection.iterator();
        while (iter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(((LCMReturnGoodsBillInfo)iter.next()).getId());
            String tempMsg = this.checkForGenerateVoucher(ctx, (IObjectPK)pk);
            if (tempMsg.trim().length() <= 0) continue;
            iter.remove();
            msg.append(tempMsg);
        }
        if (sourceBillCollection.size() > 0) {
            return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        }
        if (msg.toString().trim().length() > 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        return null;
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer("");
        msg.append(this.checkForGenerateVoucher(ctx, sourceBillPk));
        if (msg.toString().trim().length() > 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{msg.toString()});
        }
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        super._generateVoucher(ctx, sourceBillPkList);
    }

    @Override
    protected IObjectCollection _getDetailForCard(Context ctx, String cardId) throws BOSException, EASBizException {
        StringBuffer detailSql = new StringBuffer();
        detailSql.append(" SELECT bill.FDate returnDate, bill.FType type, department.FName_l2 departmentName,");
        detailSql.append(" person.FName_l2 personName, entry.FQuantity quantity, entry.FRemark remark,");
        detailSql.append(" entry.FOriginAmount originAmount, entry.FLocalAmount localAmount ");
        detailSql.append(" FROM T_LCM_LCMReturnGoodsBill bill ");
        detailSql.append(" LEFT JOIN T_LCM_LCMReturnGoodsBillEntry entry ");
        detailSql.append(" ON bill.FID = entry.FBillID ");
        detailSql.append(" LEFT JOIN T_LCM_LCMCurCard card ");
        detailSql.append(" ON entry.FCurCardID = card.FID ");
        detailSql.append(" LEFT JOIN T_BD_Person person ");
        detailSql.append(" ON bill.FPersonID = person.FID ");
        detailSql.append(" LEFT JOIN T_ORG_Admin department ");
        detailSql.append(" ON bill.FDepartmentID = department.FID ");
        detailSql.append(" WHERE card.FID = '");
        detailSql.append(cardId);
        detailSql.append("'");
        detailSql.append(" AND bill.FCheckedStatus = 2 ");
        IRowSet detailRS = DbUtil.executeQuery((Context)ctx, (String)detailSql.toString());
        LCMReturnGoodsBillCollection billCol = new LCMReturnGoodsBillCollection();
        try {
            while (detailRS.next()) {
                LCMReturnGoodsBillInfo billInfo = new LCMReturnGoodsBillInfo();
                billInfo.setDate(detailRS.getDate("returnDate"));
                if ("0".equals(detailRS.getString("type"))) {
                    billInfo.setType(LCMReturnGoodsTypeEnum.RETURN_GOODS_NORMAL);
                } else {
                    billInfo.setType(LCMReturnGoodsTypeEnum.RETURN_OR_CHANGE_GOODS_NORMAL);
                }
                AdminOrgUnitInfo dpt = new AdminOrgUnitInfo();
                dpt.setName(detailRS.getString("departmentName"));
                billInfo.setDepartment(dpt);
                PersonInfo p = new PersonInfo();
                p.setName(detailRS.getString("personName"));
                billInfo.setPerson(p);
                LCMReturnGoodsBillEntryInfo entry = new LCMReturnGoodsBillEntryInfo();
                entry.setQuantity(detailRS.getBigDecimal("quantity"));
                entry.setOriginAmount(detailRS.getBigDecimal("originAmount"));
                entry.setLocalAmount(detailRS.getBigDecimal("localAmount"));
                entry.setRemark(detailRS.getString("remark"));
                billInfo.getEntries().add(entry);
                billCol.add(billInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return billCol;
    }

    private void updateCurCardBlockedStatus(Context ctx, IObjectPK pkSaved, int status) throws BOSException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer updateCardSql = new StringBuffer();
        updateCardSql.append("update t_lcm_lcmcurcard set flastupdatetime=GETDATE(),flastupdateuserid='");
        updateCardSql.append(currentUserId);
        updateCardSql.append("',FBlockedStatus = ");
        updateCardSql.append(status);
        updateCardSql.append(" where fid in (select fcurcardid from t_lcm_lcmreturngoodsbillentry where fbillid='");
        updateCardSql.append(pkSaved);
        updateCardSql.append("')");
        DbUtil.execute((Context)ctx, (String)updateCardSql.toString());
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LCMReturnGoodsBillInfo billInfo = this.getLCMReturnGoodsBillInfo(ctx, pk);
        LCMUtils.verifyForLastestPeriod(ctx, (IObjectValue)billInfo, 0);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    private void beforeSave(Context ctx, LCMReturnGoodsBillInfo bill, boolean isSubmit) throws EASBizException, BOSException {
        bill.setDate(DateTimeUtils.truncateDate((Date)bill.getDate()));
        bill.setBizDate(LCMUtils.getBizDate(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = bill.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            bill.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (bill.getId() == null) {
            if (bill.getNumber() == null || bill.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)bill)) {
                this.setNewNumber(ctx, bill);
            }
        } else {
            LCMReturnGoodsBillInfo savedBill = this.getLCMReturnGoodsBillInfo(ctx, "select effectedStatus where id='" + bill.getId() + "'");
            if (!isSubmit && savedBill.getEffectedStatus().getValue() == 2) {
                throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.CANNOT_BE_SUBMIT_BILL_HAD_EFFECTED);
            }
            DbUtil.execute((Context)ctx, (String)("delete from t_lcm_lcmreturngoodsbillentry where fbillid= '" + bill.getId() + "'"));
        }
    }

    protected void setNewNumber(Context ctx, LCMReturnGoodsBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        billInfo.setBizDate(LCMUtils.getBizDate(ctx, strCompanyId));
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            ++this.recursiveNumber;
            if (this.recursiveNumber >= 100) {
                this.recursiveNumber = 0;
                throw new LCMReturnGoodsBillException(LCMReturnGoodsBillException.GENGERATENUMBERRULEISWRONG);
            }
            this.setNewNumber(ctx, billInfo);
        } else {
            this.recursiveNumber = 0;
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LCMReturnGoodsBillInfo billInfo = (LCMReturnGoodsBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)billInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            if (caller.getNumber() == null) {
                return;
            }
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    private int getCurrencyScale(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getRemoteInstance().getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    protected String checkForGenerateVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("blockedStatus"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("effectedStatus"));
        selector.add(new SelectorItemInfo("entries.*"));
        LCMReturnGoodsBillInfo billInfo = this.getLCMReturnGoodsBillInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.isFiVouchered()) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        LCMReturnGoodsBillEntryCollection entries = billInfo.getEntries();
        StringBuffer sbAll = new StringBuffer("");
        if (sbMsg.toString().length() > 0) {
            sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"numberIsZero", (Locale)ctx.getOriginLocale()));
            sbAll.append(billInfo.getNumber() + " ");
            sbAll.append(sbMsg);
        }
        return sbAll.toString();
    }
}

