/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.lcm.LCMAmortizeModeEnum;
import com.kingdee.eas.fi.lcm.LCMUseStatusEnum;
import com.kingdee.eas.fi.lcm.app.AbstractLVReportCal;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LV_FOG_CALCULATOR
extends AbstractLVReportCal {
    public static final BigDecimal zeroValue = new BigDecimal("0.00");
    private static final String LCM_RESOURCE = "com.kingdee.eas.fi.lcm.LCMResource.resource";
    public static final String ZJE = "ZJE";
    public static final String LYE = "LYE";
    private CompanyOrgUnitInfo companyInfo = null;
    private static Logger logger = Logger.getLogger(LV_FOG_CALCULATOR.class);

    public LV_FOG_CALCULATOR(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    @Override
    public void execute(SortedParameterArray params) {
        BigDecimal result = zeroValue;
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] inputsArray = param.getArgs();
            Object[] inputs = (Object[])inputsArray[0];
            this.decideYearPeriod(((BigDecimal)((Variant)inputs[10]).getValue()).intValue(), ((BigDecimal)((Variant)inputs[11]).getValue()).intValue(), ((BigDecimal)((Variant)inputs[12]).getValue()).intValue());
            try {
                result = this.getFOG_LV(this.ctx, inputs);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            param.setValue((Object)result);
        }
    }

    protected BigDecimal getFOG_LV(Context ctx, Object[] inputs) throws BOSException, EASBizException {
        String dataType = ((Variant)inputs[8]).toString();
        if (dataType == null || dataType.trim().length() == 0) {
            throw new BOSException(EASResource.getString((String)LCM_RESOURCE, (String)"getNumberTypeIsNotNull"));
        }
        if (inputs.length == 13) {
            if (dataType.equals(ZJE)) {
                try {
                    return this.getCurCardSqlAndDo(ctx, inputs);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else if (dataType.equals(LYE)) {
                try {
                    return this.getConSumeBillSqlAndDo(ctx, inputs);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return null;
    }

    private String getCompanyId(Context ctx, String number) throws BOSException, EASBizException {
        if (number == null || number.trim().length() == 0) {
            ICompanyOrgUnit icompany;
            CompanyOrgUnitInfo company;
            String strCompanyOrgUnitInfoID = FaLocalUtils.getCurrentCompanyId((Context)ctx);
            if (strCompanyOrgUnitInfoID != null && (company = (icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strCompanyOrgUnitInfoID)))) != null) {
                return company.getNumber();
            }
            return null;
        }
        return number;
    }

    private StringBuffer getLCMSql(StringBuffer sql) {
        sql.append("select isnull(sum(lcmcc.FLocalAmount),0) from t_lcm_lcmcurcard lcmcc").append(" inner join T_ORG_Company com on lcmcc.fcompanyid=com.fid").append(" left outer join t_lcm_lcmlcmcat lcmlc on lcmcc.fassetcatid=lcmlc.fid").append(" left outer join T_BD_Currency bdc on lcmcc.fcurrencyid=bdc.fid").append(" left outer join T_BD_AccountView bdav on lcmcc.faccountassetid = bdav.fid").append(" left outer join T_ORG_Admin orga on lcmcc.fdeptid =orga.fid").append(" left outer join t_lcm_lcmaltermode lcmam on lcmcc.fsourcemodeid=lcmam.fid").append(" left outer join T_BD_Period period on period.fid=lcmcc.FLcmPeriodID");
        sql.append(" where 1=1 and lcmcc.FSourceType='1' and lcmcc.FCheckedStatus=2 ");
        return sql;
    }

    private StringBuffer getUseLCMSql(StringBuffer sql) {
        sql.append("select isnull(sum(lcse.FBECONSUMEAMT),0) from t_lcm_lcmconsumebill lcs").append(" inner join t_lcm_lcmconsumebillentry lcse on  lcs.fid=lcse.fbillid").append(" inner join t_lcm_lcmcurcard lcmcc on lcse.fcurcardid=lcmcc.fid ").append(" left outer join t_lcm_lcmlcmcat lcmlc on lcmcc.fassetcatid=lcmlc.fid").append(" inner join T_ORG_Company com on lcs.fcompanyid=com.fid").append(" left outer join T_BD_Currency bdc on lcmcc.fcurrencyid=bdc.fid").append(" left outer join T_BD_AccountView bdav on lcs.faccountid = bdav.fid").append(" left outer join T_ORG_Admin orga on lcs.fusedepartmentid =orga.fid").append(" left outer join T_BD_Period period on period.fid=lcs.FPeriodID");
        sql.append(" where 1=1 and lcs.FBizDate is not null and   lcs.FCheckedStatus=2");
        return sql;
    }

    private StringBuffer getLCMCon(StringBuffer sql, Object[] paramsArray) throws BOSException {
        String company = ((Variant)paramsArray[0]).toString();
        String LCMType = ((Variant)paramsArray[1]).toString();
        String LCMNumber = ((Variant)paramsArray[2]).toString();
        String deptNumber = ((Variant)paramsArray[3]).toString();
        String sourceModel = ((Variant)paramsArray[4]).toString();
        String useStatus = ((Variant)paramsArray[5]).toString();
        String amortization = ((Variant)paramsArray[6]).toString();
        String accountNumber = ((Variant)paramsArray[7]).toString();
        String lvType = ((Variant)paramsArray[8]).toString();
        String currency = ((Variant)paramsArray[9]).toString();
        String year = ((Variant)paramsArray[10]).toString();
        String startPeriod = ((Variant)paramsArray[11]).toString();
        String endPeriod = ((Variant)paramsArray[12]).toString();
        String startDate = "";
        String endDate = "";
        if (ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"18_LV_FOG_CALCULATOR", (Locale)this.ctx.getOriginLocale()).equals(useStatus)) {
            useStatus = "";
        }
        if (ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"18_LV_FOG_CALCULATOR", (Locale)this.ctx.getOriginLocale()).equals(amortization)) {
            amortization = "";
        }
        try {
            company = this.getCompanyId(this.ctx, company);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sql.append(" And com.fnumber='").append(company).append("'");
        if (!"".equals(LCMType.trim())) {
            sql.append(" And  lcmlc.FLongNumber='").append(LCMType).append("'");
        }
        if (!"".equals(LCMNumber.trim())) {
            sql.append(" And lcmcc.fnumber='").append(LCMNumber).append("'");
        }
        if (!"".equals(deptNumber.trim())) {
            sql.append(" And orga.FNumber='").append(deptNumber).append("'");
        }
        if (!"".equals(sourceModel.trim())) {
            sql.append(" And lcmam.flongnumber='").append(sourceModel).append("'");
        }
        if (!"".equals(useStatus.trim())) {
            int intUseStatus = LCMUseStatusEnum.getEnum(useStatus).getValue();
            sql.append(" And lcmcc.fuseStatus='").append(intUseStatus).append("'");
        }
        if (!"".equals(amortization.trim())) {
            int intAmor = LCMAmortizeModeEnum.getEnum(amortization).getValue();
            sql.append(" And lcmcc.famortizemode='").append(intAmor).append("'");
        }
        if (!"".equals(accountNumber.trim())) {
            sql.append(" And bdav.fnumber='").append(accountNumber).append("'");
        }
        if (!"".equals(currency.trim())) {
            sql.append(" And bdc.fnumber='").append(currency).append("'");
        }
        String companyID = "";
        try {
            if (company == null || company.trim().length() == 0) {
                companyID = FaLocalUtils.getCurrentCompanyId((Context)this.ctx);
            } else {
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                CompanyOrgUnitInfo coui = (CompanyOrgUnitInfo)icou.getValue("select id where number='" + company + "'");
                if (coui != null) {
                    companyID = coui.getId().toString();
                }
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        PeriodInfo curPeriodInfo = null;
        try {
            curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)this.ctx));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if ("0".equals(year)) {
            year = String.valueOf(curPeriodInfo.getPeriodYear());
        } else {
            int int_year = Integer.parseInt(year);
            year = String.valueOf(curPeriodInfo.getPeriodYear() + Integer.parseInt(year));
        }
        if ("0".equals(startPeriod)) {
            startPeriod = String.valueOf(curPeriodInfo.getPeriodNumber());
        } else {
            int int_startPeriod = Integer.parseInt(startPeriod);
            startPeriod = String.valueOf(curPeriodInfo.getPeriodNumber() + int_startPeriod);
        }
        if ("0".equals(endPeriod)) {
            endPeriod = String.valueOf(curPeriodInfo.getPeriodNumber());
        } else {
            int int_endPeriod = Integer.parseInt(endPeriod);
            endPeriod = String.valueOf(curPeriodInfo.getPeriodNumber() + int_endPeriod);
        }
        if (Integer.parseInt(endPeriod) < Integer.parseInt(startPeriod)) {
            throw new BOSException(EASResource.getString((String)LCM_RESOURCE, (String)"endPeriodGreaterStartPeriod"));
        }
        sql.append(" and period.FPeriodYear=").append(new Integer(year));
        sql.append(" and period.FPeriodNumber>=").append(new Integer(startPeriod));
        sql.append(" and period.FPeriodNumber<=").append(new Integer(endPeriod));
        return sql;
    }

    private StringBuffer getUseLCMCon(StringBuffer sql, Object[] paramsArray) throws BOSException {
        String company = ((Variant)paramsArray[0]).toString();
        String LCMType = ((Variant)paramsArray[1]).toString();
        String LCMNumber = ((Variant)paramsArray[2]).toString();
        String deptNumber = ((Variant)paramsArray[3]).toString();
        String sourceModel = ((Variant)paramsArray[4]).toString();
        String useStatus = ((Variant)paramsArray[5]).toString();
        String amortization = ((Variant)paramsArray[6]).toString();
        String accountNumber = ((Variant)paramsArray[7]).toString();
        String lvType = ((Variant)paramsArray[8]).toString();
        String currency = ((Variant)paramsArray[9]).toString();
        String year = ((Variant)paramsArray[10]).toString();
        String startPeriod = ((Variant)paramsArray[11]).toString();
        String endPeriod = ((Variant)paramsArray[12]).toString();
        String startDate = "";
        String endDate = "";
        if (ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"18_LV_FOG_CALCULATOR", (Locale)this.ctx.getOriginLocale()).equals(useStatus)) {
            useStatus = "";
        }
        if (ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"18_LV_FOG_CALCULATOR", (Locale)this.ctx.getOriginLocale()).equals(amortization)) {
            amortization = "";
        }
        try {
            company = this.getCompanyId(this.ctx, company);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sql.append(" And com.fnumber='").append(company).append("'");
        if (!"".equals(LCMType.trim())) {
            sql.append(" And lcmlc.FLongNumber='").append(LCMType).append("'");
        }
        if (!"".equals(LCMNumber.trim())) {
            sql.append(" And lcmcc.fnumber='").append(LCMNumber).append("'");
        }
        if (!"".equals(deptNumber.trim())) {
            sql.append(" And orga.FNumber='").append(deptNumber).append("'");
        }
        if (!"".equals(useStatus.trim())) {
            int intUseStatus = LCMUseStatusEnum.getEnum(useStatus).getValue();
            sql.append(" And lcmcc.fuseStatus='").append(intUseStatus).append("'");
        }
        if (!"".equals(amortization.trim())) {
            int intAmor = LCMAmortizeModeEnum.getEnum(amortization).getValue();
            sql.append(" And lcmcc.famortizemode='").append(intAmor).append("'");
        }
        if (!"".equals(accountNumber.trim())) {
            sql.append(" And bdav.fnumber='").append(accountNumber).append("'");
        }
        if (!"".equals(currency.trim())) {
            sql.append(" And bdc.fnumber='").append(currency).append("'");
        }
        String companyID = "";
        try {
            if (company == null || company.trim().length() == 0) {
                companyID = FaLocalUtils.getCurrentCompanyId((Context)this.ctx);
            } else {
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                CompanyOrgUnitInfo coui = (CompanyOrgUnitInfo)icou.getValue("select id where number='" + company + "'");
                if (coui != null) {
                    companyID = coui.getId().toString();
                }
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        PeriodInfo curPeriodInfo = null;
        try {
            curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)this.ctx));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if ("0".equals(year)) {
            year = String.valueOf(curPeriodInfo.getPeriodYear());
        } else {
            int int_year = Integer.parseInt(year);
            year = String.valueOf(curPeriodInfo.getPeriodYear() + Integer.parseInt(year));
        }
        if ("0".equals(startPeriod)) {
            startPeriod = String.valueOf(curPeriodInfo.getPeriodNumber());
        } else {
            int int_startPeriod = Integer.parseInt(startPeriod);
            startPeriod = String.valueOf(curPeriodInfo.getPeriodNumber() + int_startPeriod);
        }
        if ("0".equals(endPeriod)) {
            endPeriod = String.valueOf(curPeriodInfo.getPeriodNumber());
        } else {
            int int_endPeriod = Integer.parseInt(endPeriod);
            endPeriod = String.valueOf(curPeriodInfo.getPeriodNumber() + int_endPeriod);
        }
        if (Integer.parseInt(endPeriod) < Integer.parseInt(startPeriod)) {
            throw new BOSException(EASResource.getString((String)LCM_RESOURCE, (String)"endPeriodGreaterStartPeriod"));
        }
        sql.append(" and period.FPeriodYear=").append(new Integer(year));
        sql.append(" and period.FPeriodNumber>=").append(new Integer(startPeriod));
        sql.append(" and period.FPeriodNumber<=").append(new Integer(endPeriod));
        return sql;
    }

    private BigDecimal excuteSql(Object[] paramsArray, String sql) throws SQLDataException {
        SqlParams params = new SqlParams();
        RptRowSet rs = null;
        try {
            Logger.getLogger(this.getClass()).error((Object)("LV_FOG_HL_:" + sql));
            rs = DBUtilx.executeQuery((String)sql, (SqlParams)params, (Context)this.ctx);
            if (rs.next()) {
                return rs.getBigDecimal(0);
            }
            return new BigDecimal(0);
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
    }

    private BigDecimal getCurCardSqlAndDo(Context ctx, Object[] paramsArray) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        this.getLCMSql(sql);
        this.getLCMCon(sql, paramsArray);
        return this.excuteSql(paramsArray, sql.toString());
    }

    private BigDecimal getConSumeBillSqlAndDo(Context ctx, Object[] paramsArray) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        this.getUseLCMSql(sql);
        this.getUseLCMCon(sql, paramsArray);
        return this.excuteSql(paramsArray, sql.toString());
    }

    private BigDecimal getJZC(Context ctx, Object[] paramsArray) throws EASBizException, BOSException {
        return this.getCurCardSqlAndDo(ctx, paramsArray);
    }

    private BigDecimal getLYE(Context ctx, Object[] paramsArray) throws EASBizException, BOSException {
        return this.getConSumeBillSqlAndDo(ctx, paramsArray);
    }

    private FilterItemInfo getCompanyFilter(Context ctx, String companyNumber, String tablePreFix) throws BOSException, EASBizException {
        if (this.companyInfo == null || !this.companyInfo.equals((Object)this.companyInfo.getNumber())) {
            this.companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select isBizUnit,longnumber,number where number='" + companyNumber + "'");
        }
        return new FilterItemInfo(tablePreFix + ".number", (Object)companyNumber, CompareType.EQUALS);
    }

    private String getCompanySQL(Context ctx, String companyNumber, boolean isFromMonCard) throws BOSException, EASBizException {
        boolean isEntityCompany;
        if (this.companyInfo == null || !this.companyInfo.equals((Object)this.companyInfo.getNumber())) {
            this.companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select isBizUnit,longnumber,number where number='" + companyNumber + "'");
        }
        boolean bl = isEntityCompany = this.companyInfo == null ? false : this.companyInfo.isIsBizUnit();
        if (isFromMonCard) {
            return "company.fnumber = '" + companyNumber + "'";
        }
        return "(company.fnumber = ? )";
    }
}

