/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.lcm.LCMContrastCaclFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LcmAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private Logger logger = Logger.getLogger(LcmAccountRefContrastProcess.class);

    public boolean enable(Context ctx, String companyId, String acrefID) throws BOSException, EASBizException {
        int systemEnum = 32;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyId);
        if (curPeriodId == null) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyId)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"21_LcmAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
        }
        this.LcmAlterModeSwap(ctx, companyId, acrefID);
        this.LcmCardDefaultValueSwap(ctx, companyId, acrefID);
        this.LcmCurCardSwap(ctx, companyId, acrefID);
        return true;
    }

    public boolean disEnable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        String templeTable = super.createTempleTable(ctx, acrefID);
        this.unLcmAlterModeSwap(ctx, companyID, acrefID, templeTable);
        this.unLcmCardDefaultValueSwap(ctx, companyID, acrefID, templeTable);
        this.unLcmCurCardSwap(ctx, companyID, acrefID, templeTable);
        return false;
    }

    private boolean bizChecker(Context ctx, String companyID, String acrefID, String enabledPeriodId) throws BOSException, EASBizException {
        HashMap hmPara = this.gethmParam(ctx, companyID);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)enabledPeriodId)), selector);
        StringBuffer sql = new StringBuffer();
        String oldAcctTableID = super.getOldAcctTableID(ctx, acrefID);
        sql.append("select 1 where exists(select card.* from t_lcm_lcmcurcard card ").append(" inner join t_bd_period per on card.flcmperiodid=per.fid ").append(" inner join t_bd_accountview acct on acct.fid=card.FAccountAssetID ").append(" where card.fcompanyid = ? and acct.FAccountTableID = ? ").append(" and per.fNumber > ? ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, oldAcctTableID, new Integer(perInfo.getNumber())});
        try {
            if (rs.next()) {
                throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"22_LcmAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.delete(0, sql.length());
        String newAcctTableID = this.getNewAcctTableID(ctx, acrefID);
        sql.append("select 1 where exists(select card.* from t_lcm_lcmcurcard card ").append(" inner join t_bd_period per on card.flcmperiodid=per.fid ").append(" inner join t_bd_accountview acct on acct.fid=card.FAccountAssetID ").append(" where card.fcompanyid= ? and acct.FAccountTableID = ? ").append(" and per.fnumber <= ? )");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, newAcctTableID, new Integer(perInfo.getNumber())});
        try {
            if (rs.next()) {
                throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"23_LcmAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String checkGL = (String)hmPara.get("LCM_013");
        StringBuffer checkerStr = new StringBuffer();
        boolean isCheckGL = false;
        if (checkGL != null && checkGL.trim().length() > 0) {
            isCheckGL = Boolean.valueOf(checkGL.trim());
        }
        if (isCheckGL) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
            boolean isAcctEquals = LCMContrastCaclFacadeFactory.getLocalInstance(ctx).isAcctEquals(companyID);
            if (!isAcctEquals && isRelAccount) {
                checkerStr.append(this.getResource(ctx, "com.kingdee.eas.fi.lcm.LCMPeriodCloseResource", "forward_checkGL"));
                throw new EASBizException(new NumericExceptionSubItem("1", checkerStr.toString()));
            }
        }
        return true;
    }

    private void LcmAlterModeSwap(Context ctx, String companyId, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmaltermode set faccountid = (select max(e.FNewAcctid)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctid = t_lcm_lcmaltermode.faccountid)");
        sql.append(" where fcompanyid = ? and faccountid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyId, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        this.logger.error((Object)("LcmAlterModeSwap*****" + sql.toString()));
    }

    private void unLcmAlterModeSwap(Context ctx, String companyId, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmaltermode set (faccountid) = (select tem.FoldAcctid");
        sql.append(" from ").append(templeTable).append(" tem where faccountid=tem.fnewAcctID) ");
        sql.append(" where fcompanyid =? ");
        sql.append(" and faccountid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
    }

    private void LcmCardDefaultValueSwap(Context ctx, String companyId, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmcurcarddefaultvalue set faccountassetid = (select max(e.FNewAcctid)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctid = faccountassetid)");
        sql.append(" where fcompanyid = ? and faccountassetid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyId, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        this.logger.error((Object)("LcmCardDefaultValueSwap*****" + sql.toString()));
    }

    private void unLcmCardDefaultValueSwap(Context ctx, String companyId, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmcurcarddefaultvalue set (faccountassetid) = (select tem.FoldAcctid");
        sql.append(" from ").append(templeTable).append(" tem where faccountassetid=tem.fnewAcctID) ");
        sql.append(" where fcompanyid =? ");
        sql.append(" and faccountassetid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
    }

    private void LcmCurCardSwap(Context ctx, String companyId, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmcurcard set faccountAssetid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_lcm_lcmcurcard.faccountAssetid)");
        sql.append(" where fcompanyid = ? and faccountAssetid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyId, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        this.logger.error((Object)("LcmCurCardSwap*****" + sql.toString()));
    }

    private void unLcmCurCardSwap(Context ctx, String companyId, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_lcm_lcmcurcard set faccountAssetid = (select tem.FoldAcctID ");
        sql.append(" from " + templeTable + " tem where faccountAssetid = tem.fnewAcctID) ");
        sql.append(" where fcompanyid = ? and faccountAssetid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
    }

    private HashMap gethmParam(Context ctx, String companyIds) throws BOSException, EASBizException {
        HashMap hmParam = null;
        ObjectUuidPK pk = new ObjectUuidPK(companyIds);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("LCM_013", pk);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        hmParam = iParamControl.getParamHashMap(paramKeyMap);
        return hmParam;
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    private boolean isAdjustperiod(Context ctx, String companyId, String enabledPeriodId) throws BOSException {
        String sql = " select 1 from t_bd_systemstatus a  inner join t_bd_systemstatusctrol b on a.fid = b.fsystemstatusid  where b.fcompanyid = ? and b.fcurrentperiodid = ? and a.fname = 32 and b.fisstart = 1 ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, enabledPeriodId});
        try {
            if (set.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private String getEnabledPeriodID(Context ctx, String acrefID) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fenabledperiodid from t_bd_acctrefcontrast where fid = ?", (Object[])new Object[]{acrefID});
        String curPeriodId = null;
        try {
            if (rs.next()) {
                curPeriodId = rs.getString("fenabledperiodid");
            }
        }
        catch (SQLException e1) {
            throw new BOSException("SQL Error!" + e1);
        }
        return curPeriodId;
    }
}

