/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrolChecker;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.lcm.LCMBaseException;
import com.kingdee.eas.fi.lcm.LCMChangeBillFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeBillFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMDisPatchBillFactory;
import com.kingdee.eas.fi.lcm.LCMDiscardBillFactory;
import com.kingdee.eas.fi.lcm.LCMResUtil;
import com.kingdee.eas.fi.lcm.LCMReturnConsumeBillFactory;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import org.apache.log4j.Logger;

public class LcmHasNewBizIsRef
implements ISystemStatusCtrolChecker {
    private static final Logger logger = Logger.getLogger(LcmHasNewBizIsRef.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.lcm.LCMAutoGenerateResource";

    public void check(Context ctx, SystemStatusCtrolCollection objCol) throws PeriodException {
        try {
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            int count = objCol.size();
            for (int i = 0; i < count; ++i) {
                SystemStatusInfo systemStatusInfo;
                SystemStatusCtrolInfo newSystemStatusCtrolInfo = (SystemStatusCtrolInfo)objCol.getObject(i);
                if (newSystemStatusCtrolInfo == null || newSystemStatusCtrolInfo.getId() == null || !(systemStatusInfo = newSystemStatusCtrolInfo.getSystemStatus()).getName().equals((Object)SystemEnum.LOWCOSTMATERIAL)) continue;
                String companyId = newSystemStatusCtrolInfo.getCompany().getId().toString();
                ObjectUuidPK systemStatusCtrolPK = new ObjectUuidPK(newSystemStatusCtrolInfo.getId().toString());
                SystemStatusCtrolInfo oldSystemStatusCtrolInfo = (SystemStatusCtrolInfo)iSystemStatusCtrol.getValue((IObjectPK)systemStatusCtrolPK);
                PeriodInfo newStartPeriod = newSystemStatusCtrolInfo.getStartPeriod();
                PeriodInfo oldStartPeriod = oldSystemStatusCtrolInfo.getStartPeriod();
                if (!(newStartPeriod != null && oldStartPeriod != null && !newStartPeriod.getId().equals((Object)oldStartPeriod.getId()) || newStartPeriod != null && oldStartPeriod == null) && (newStartPeriod != null || oldStartPeriod == null)) continue;
                this.checkLcmStartPeriod(ctx, companyId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
    }

    private void checkLcmStartPeriod(Context ctx, String companyId) throws PeriodException {
        this.checkIsInitEnd(ctx, companyId);
        this.checkIsExistBiz(ctx, companyId);
    }

    private void checkIsInitEnd(Context ctx, String companyId) throws PeriodException {
        try {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)company);
            if (isInitEnd) {
                LCMBaseException lcmBaseException = new LCMBaseException(LCMBaseException.LCM_INITIALIZED);
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{lcmBaseException.getMessage(ctx.getLocale())});
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
    }

    private void checkIsExistBiz(Context ctx, String companyId) throws PeriodException {
        try {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            FilterInfo curCardFilter = new FilterInfo();
            curCardFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            curCardFilter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)"3", CompareType.NOTEQUALS));
            if (LCMCurCardFactory.getLocalInstance(ctx).exists(curCardFilter)) {
                LCMBaseException lcmBaseException = new LCMBaseException(LCMBaseException.ISREF_HAS_NEW_BIZ, new Object[]{company.getNumber() + "(" + company.getName() + ")", LCMResUtil.getRes(RESOURCE_PATH, "36_LcmHasNewBizIsRef", ctx.getOriginLocale())});
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{lcmBaseException.getMessage(ctx.getLocale())});
            }
            IBillBase[] iBizBases = new IBillBase[]{LCMChangeBillFactory.getLocalInstance(ctx), LCMDisPatchBillFactory.getLocalInstance(ctx), LCMConsumeBillFactory.getLocalInstance(ctx), LCMReturnConsumeBillFactory.getLocalInstance(ctx), LCMDiscardBillFactory.getLocalInstance(ctx)};
            String[] bizNames = new String[]{LCMResUtil.getRes(RESOURCE_PATH, "31_LcmHasNewBizIsRef", ctx.getOriginLocale()), LCMResUtil.getRes(RESOURCE_PATH, "32_LcmHasNewBizIsRef", ctx.getOriginLocale()), LCMResUtil.getRes(RESOURCE_PATH, "33_LcmHasNewBizIsRef", ctx.getOriginLocale()), LCMResUtil.getRes(RESOURCE_PATH, "34_LcmHasNewBizIsRef", ctx.getOriginLocale()), LCMResUtil.getRes(RESOURCE_PATH, "35_LcmHasNewBizIsRef", ctx.getOriginLocale())};
            int size = iBizBases.length;
            for (int i = 0; i < size; ++i) {
                FilterInfo bizFilter = new FilterInfo();
                bizFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
                if (!iBizBases[i].exists(bizFilter)) continue;
                LCMBaseException lcmBaseException = new LCMBaseException(LCMBaseException.ISREF_HAS_NEW_BIZ, new Object[]{company.getNumber() + "(" + company.getName() + ")", bizNames[i]});
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{lcmBaseException.getMessage(ctx.getOriginLocale())});
            }
        }
        catch (PeriodException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{e.getMessage()});
        }
    }
}

