/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LCMAmortListDao
extends FaDaoBase {
    private static final Logger logger = Logger.getLogger(LCMAmortListDao.class);
    private static final String LCM_RES_PATH = "com.kingdee.eas.fi.lcm.LCMResource";
    private final String LCM_CAT_ID = "lcmCatID";
    private final String LCM_NAME = "lcmName";
    private final String USE_DEPT = "useDept";
    private final String USE_PERSON = "usePerson";
    private final String HAS_UN_AUDIT = "hasUnAudit";
    private final int COMSUME_BILL = 1;
    private final int DISCARD_BILL = 2;
    private final int RETURN_BILL = 3;
    private String insertCompanySql;
    private String sumSql;
    private boolean isByConsume;
    private boolean isByDiscard;
    private boolean isByReturn;
    private boolean isShowNotAudit;
    private String lcmName = null;
    private String lcmCatID = null;
    private String deptID = null;
    private String userID = null;
    private String bizTypeConsume = null;
    private String bizTypeDiscard = null;
    private String bizTypeRetturn = null;
    private String periodBegin = null;
    private String periodClose = null;
    private String yearSum = null;
    private final String BYCONSUME = "byConsume";
    private final String BYDISCARD = "byDiscard";
    private final String BYRETURN = "byReturn";
    ArrayList periods = new ArrayList();
    private PeriodTypeInfo periodType;
    private String periodTypeId;
    private String companyID;
    private BigDecimal ZERO = new BigDecimal("0");

    protected void buildSql() throws BOSException {
        this.buildResultSql();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    protected void buildData() throws BOSException {
        String where;
        String select;
        Date curBizDate;
        Iterator iter;
        int index;
        try {
            this.companyID = this.getCurrentCompany();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.periods = this.getPeriodIDList();
        ArrayList<Date> periodBeginBizDate = new ArrayList<Date>();
        ArrayList<Date> periodColoseBizDate = new ArrayList<Date>();
        Date beginBizDate = null;
        Date closeBizDate = null;
        Date yearSumDate = null;
        int flag = 0;
        Iterator iter2 = this.periods.iterator();
        while (iter2.hasNext()) {
            int periodNum = (Integer)iter2.next();
            String queryDate = "select FBeginDate,FEndDate from t_bd_period where fnumber = " + periodNum + " and ftypeid = '" + this.getPeriodTypeId() + "'";
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)queryDate);
            try {
                row.next();
                beginBizDate = row.getDate("FBeginDate");
                closeBizDate = row.getDate("FEndDate");
                periodBeginBizDate.add(flag, beginBizDate);
                periodColoseBizDate.add(flag, closeBizDate);
                yearSumDate = closeBizDate;
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            ++flag;
        }
        StringBuffer createTmpTable = new StringBuffer(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryBillSQL()));
        this.addDataTempTable(createTmpTable.toString());
        if (this.isVirCompany) {
            try {
                this.fillSumData();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (this.isVirCompany) {
            index = 0;
            iter = this.periods.iterator();
            while (iter.hasNext()) {
                int periodNum = (Integer)iter.next() * 10 + 1;
                curBizDate = (Date)periodBeginBizDate.get(index);
                select = this.getSumSelectSql(periodNum, this.periodBegin, curBizDate, true);
                where = " billType = -1 and periodnum =" + periodNum;
                this.sumSql = this.sumOption.getSumSql(this.tempTable, select, null, where, null, false, false);
                if (this.sumSql != null && this.sumSql.trim().length() > 0) {
                    DbUtil.execute((Context)this.ctx, (String)this.sumSql);
                }
                ++index;
            }
            DbUtil.execute((Context)this.ctx, (String)("update " + this.tempTable + " set periodnum = periodnum+2,billType = billType-1 where billtype = -1"));
        }
        if (this.isVirCompany) {
            index = 0;
            iter = this.periods.iterator();
            while (iter.hasNext()) {
                int periodNum = (Integer)iter.next() * 10 + 2;
                curBizDate = (Date)periodColoseBizDate.get(index);
                select = this.getSumSelectSql(periodNum, this.periodClose, curBizDate, false);
                where = " billType = -2  and periodnum =" + ++periodNum;
                this.sumSql = this.sumOption.getSumSql(this.tempTable, select, null, where, null, false, false);
                if (this.sumSql != null && this.sumSql.trim().length() > 0) {
                    DbUtil.execute((Context)this.ctx, (String)this.sumSql);
                }
                ++index;
            }
        }
        if (this.isVirCompany) {
            index = 0;
            int periodNum = 0;
            Iterator iter3 = this.periods.iterator();
            while (iter3.hasNext()) {
                periodNum = (Integer)iter3.next() * 10 + 3;
                ++index;
            }
            String select2 = this.getSumSelectSql(periodNum, this.yearSum, yearSumDate, false);
            String where2 = " billType = -3 ";
            this.sumSql = this.sumOption.getSumSql(this.tempTable, select2, null, where2, null, false, false);
            if (this.sumSql != null && this.sumSql.trim().length() > 0) {
                DbUtil.execute((Context)this.ctx, (String)this.sumSql);
            }
            DbUtil.execute((Context)this.ctx, (String)("delete from " + this.tempTable + " where billType = -1 "));
            DbUtil.execute((Context)this.ctx, (String)("delete from " + this.tempTable + " where billType = -2 "));
            DbUtil.execute((Context)this.ctx, (String)("delete from " + this.tempTable + " where billType = -3 "));
        }
        if (!this.isVirCompany) {
            try {
                this.fillSumData();
                this.fillAccData();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        this.bizTypeConsume = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"bizTypeConsume", (Locale)ctx.getOriginLocale()) + "         ' ";
        this.bizTypeDiscard = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"bizTypeDiscard", (Locale)ctx.getOriginLocale()) + "         ' ";
        this.bizTypeRetturn = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"bizTypeReturn", (Locale)ctx.getOriginLocale()) + "          ' ";
        this.periodBegin = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"periodBegin", (Locale)ctx.getOriginLocale()) + "' ";
        this.periodClose = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"periodClose", (Locale)ctx.getOriginLocale()) + "' ";
        this.yearSum = " N'" + ResourceBase.getString((String)LCM_RES_PATH, (String)"yearSum", (Locale)ctx.getOriginLocale()) + "' ";
        super.init(ctx, ev);
    }

    private String getCardSelectSql(int billType) {
        StringBuffer sql = new StringBuffer();
        String lcmbill = "";
        String billentry = "";
        switch (billType) {
            case 1: {
                lcmbill = "LCMBILL";
                billentry = "BILLENTRY";
                break;
            }
            case 2: {
                lcmbill = "DISCARDBILL";
                billentry = "DISCARDENTRY";
                break;
            }
            case 3: {
                lcmbill = "RETURNBILL";
                billentry = "RETURNENTRY";
            }
        }
        if (billType == 1) {
            sql.append(lcmbill).append(".FUseDate AS USEDATE, ");
        } else if (billType == 2) {
            sql.append(lcmbill).append(".FDiscardDate AS USEDATE, ");
        } else {
            sql.append(lcmbill).append(".FUseDate AS USEDATE, ");
        }
        sql.append("USEPERSON.").append(this.fName).append(" AS USER_NAME, ");
        if (billType == 1) {
            sql.append(this.bizTypeConsume).append(" AS bizType, ");
        } else if (billType == 2) {
            sql.append(this.bizTypeDiscard).append(" AS bizType, ");
        } else {
            sql.append(this.bizTypeRetturn).append(" AS bizType, ");
        }
        sql.append(lcmbill).append(".FNumber AS bizBillNum, ");
        if (billType == 1) {
            sql.append("voucher.FNumber AS voucherNum, ");
        } else if (billType == 2) {
            sql.append("voucher.FNumber AS voucherNum, ");
        } else {
            sql.append("TO_CHAR(null) AS voucherNum, ");
        }
        sql.append("LCMCat.").append(this.fName).append(" AS ASSETCAT_NAME, ");
        sql.append("LCMCURCARD.Fid AS cardId, ");
        sql.append("LCMCURCARD.FUnitPrice AS FUnitPrice, ");
        sql.append("LCMCURCARD.FNumber AS cardNum, ");
        sql.append("LCMCURCARD.FName AS LCM, ");
        sql.append("LCMCURCARD.FSpecs AS SPECS, ");
        sql.append("KEEPDEPT.").append(this.fName).append(" AS KEEPDEPT_NAME, ");
        sql.append("LCMCURCARD.FLife AS LIFE, ");
        sql.append("MEASUREUNIT.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
        if (billType == 1) {
            sql.append(billentry).append(".FBeConsumeQty + (case when consumeentry.FBeConsumeQty is null then 0 else consumeentry.FBeConsumeQty end) AS USEQUANTITY, ");
            sql.append(billentry).append(".FBeConsumeAmt + (case when consumeentry.FBeConsumeAmt is null then 0 else consumeentry.FBeConsumeAmt end) AS USEAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS discardQty, ");
            sql.append("TO_DECIMAL(null) AS discardAmt, ");
            sql.append("TO_DECIMAL(null) AS returnQty, ");
            sql.append("TO_DECIMAL(null) AS returnAmt, ");
            sql.append(billentry).append(".FBeConsumeQty + (case when consumeentry.FBeConsumeQty is null then 0 else consumeentry.FBeConsumeQty end) AS AMORTEDQTY, ");
            sql.append(billentry).append(".FAmortizedAmount + (case when consumeentry.FAmortizedAmount is null then 0 else consumeentry.FAmortizedAmount end) AS AMORTEDAMOUNT, ");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then ");
            sql.append(billentry).append(".FBeConsumeQty").append(" + (case when consumeentry.FBeConsumeQty is null then 0 else consumeentry.FBeConsumeQty end) else TO_DECIMAL(null) end as AMORTQTY,");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then ");
            sql.append(billentry).append(".FAmortizeAmount").append(" + (case when consumeentry.FAmortizedAmount is null then 0 else consumeentry.FAmortizedAmount end) else TO_DECIMAL(null)  end as AMORTAMOUNT,");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then  ");
            sql.append(billentry).append(".FBeConsumeQty").append(" else TO_DECIMAL(null) end as accAmortedQty,");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then  ");
            sql.append(billentry).append(".FAmortizeAmount").append(" else TO_DECIMAL(null) end as accAmortedQAmt,");
            sql.append(billentry).append(".FBeConsumeQty + (case when consumeentry.FBeConsumeQty is null then 0 else consumeentry.FBeConsumeQty end) AS USEABELQTY, ");
        } else if (billType == 2) {
            sql.append("TO_DECIMAL(null) AS USEQUANTITY, ");
            sql.append("TO_DECIMAL(null) AS USEAMOUNT, ");
            sql.append(billentry).append(".FDiscardAmt AS discardQty, ");
            sql.append(billentry).append(".FDiscardValue AS discardAmt, ");
            sql.append("TO_DECIMAL(null) AS returnQty, ");
            sql.append("TO_DECIMAL(null) AS returnAmt, ");
            sql.append(billentry).append(".FDiscardAmt AS AMORTEDQTY, ");
            sql.append(billentry).append(".FamortizeAmount AS AMORTEDAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS AMORTQTY, ");
            sql.append("TO_DECIMAL(null) AS AMORTAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS accAmortedQty, ");
            sql.append("TO_DECIMAL(null) AS accAmortedQAmt, ");
            sql.append("CASE WHEN DISCARDBILL.FDiscardType=1 Then 0.00 else ");
            sql.append("0-").append(billentry).append(".FDiscardAmt end AS USEABELQTY, ");
        } else {
            sql.append("TO_DECIMAL(null) AS USEQUANTITY, ");
            sql.append("TO_DECIMAL(null) AS USEAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS discardQty, ");
            sql.append("TO_DECIMAL(null) AS discardAmt, ");
            sql.append(billentry).append(".FHasReturnNumber AS returnQty, ");
            sql.append("RETURNENTRY.FLocalAmount AS returnAmt, -1*");
            sql.append(billentry).append(".FHasReturnNumber as AMORTEDQTY,");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then RETURNENTRY.FUnitPrice*RETURNENTRY.FHasReturnNumber*1/2*RETURNENTRY.FExRate-RETURNENTRY.FLocalAmount  else  -1*RETURNENTRY.FLocalAmount  end as AMORTEDAMOUNT, ");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then -1*");
            sql.append(billentry).append(".FHasReturnNumber ");
            sql.append(" else  TO_DECIMAL(null)  end as AMORTQTY, ");
            sql.append(" CASE WHEN LCMCURCARD.FAmortizeMode=1 then TO_DECIMAL(null) else -1*RETURNENTRY.FUnitPrice*RETURNENTRY.FHasReturnNumber*1/2*RETURNENTRY.FExRate end AS AMORTAMOUNT, ");
            sql.append("CASE WHEN LCMCURCARD.FAmortizeMode=2 Then ");
            sql.append(billentry).append(".FHasReturnNumber ");
            sql.append(" else  TO_DECIMAL(null)  end as accAmortedQty, ");
            sql.append(" CASE WHEN LCMCURCARD.FAmortizeMode=1 then TO_DECIMAL(null) else -1*RETURNENTRY.FUnitPrice*RETURNENTRY.FHasReturnNumber*1/2*RETURNENTRY.FExRate end AS accAmortedQAmt, -1*");
            sql.append(billentry).append(".FHasReturnNumber AS USEABELQTY, ");
        }
        sql.append(lcmbill).append(".FID AS BillID, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append(billType + " AS BILLTYPE, ");
        sql.append("Period.FNumber*10+2 AS PeriodNum, ");
        sql.append("0 AS isSum ");
        if (this.isVirCompany) {
            sql.append(",COMPANY.FID AS Company_Id");
        }
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        return sql.toString();
    }

    private String buildQueryBillSQL() {
        String consumeBillQuery = this.buildConsumeBillQuery(-1);
        String discardBillQuery = this.buildDiscardBillQuery();
        String returnBillQuery = this.buildReturnBillQuery();
        return (this.isByConsume ? consumeBillQuery : "") + (this.isByDiscard ? (this.isByConsume ? " union all " : "") + discardBillQuery : "") + (this.isByReturn ? (this.isByDiscard || this.isByConsume ? " union all " : "") + returnBillQuery : "");
    }

    private String buildDiscardQuery(int sumIndex) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(2));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(true, 2));
        String condSql = this.getCondSql(2, sumIndex);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        sql.append(" union all SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(2));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(false, 2));
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String buildDiscardBillQuery() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(2));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(true, 2));
        String condSql = this.getCondSql(2, -1);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        sql.append(" union all SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(2));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(false, 2));
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String buildReturnBillQuery() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(3));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(true, 3));
        String condSql = this.getCondSql(3, -1);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String buildReturnQuery(int sumIndex) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(3));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(true, 3));
        String condSql = this.getCondSql(3, sumIndex);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String buildConsumeBillQuery(int sumIndex) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(1));
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(true, 1));
        String condSql = this.getCondSql(1, sumIndex);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String getPeriodCond(int sumIndex) {
        StringBuffer sql = new StringBuffer();
        if (sumIndex >= 0) {
            int periodNum = (Integer)this.periods.get(sumIndex);
            sql.append(" period.FNumber < " + periodNum);
        } else if (this.startYear == this.endYear) {
            sql.append(" period.FPeriodYear = " + this.startYear);
            if (this.startNumber == this.endNumber) {
                sql.append(" AND period.FPeriodNumber = " + this.startNumber);
            } else {
                sql.append(" AND period.FPeriodNumber >= " + this.startNumber + " AND period.FPeriodNumber <= " + this.endNumber);
            }
        } else {
            sql.append(" (period.FPeriodYear>" + this.startYear + " OR (period.FPeriodYear=" + this.startYear + " AND period.FPeriodNumber >= " + this.startNumber + "))");
            sql.append(" AND (period.FPeriodYear<" + this.endYear + " OR (period.FPeriodYear=" + this.endYear + " AND period.FPeriodNumber <= " + this.endNumber + "))");
        }
        return sql.toString();
    }

    private String getCondSql(int billType, int sumIndex) {
        String lcmbill = "";
        String bizDate = "";
        String bizNum = "";
        switch (billType) {
            case 1: {
                lcmbill = "LCMBILL";
                bizDate = "LCMBILL.FUseDate";
                bizNum = "LCMBILL.Fnumber";
                break;
            }
            case 2: {
                lcmbill = "DISCARDBILL";
                bizDate = "DISCARDBILL.FDiscardDate";
                bizNum = "DISCARDBILL.Fnumber";
                break;
            }
            case 3: {
                lcmbill = "RETURNBILL";
                bizDate = "RETURNBILL.FUseDate";
                bizNum = "RETURNBILL.Fnumber";
            }
        }
        StringBuffer condSql = new StringBuffer();
        condSql.append(this.getPeriodCond(sumIndex));
        if (!this.isShowNotAudit) {
            condSql.append(" AND ");
            condSql.append(lcmbill + ".FCheckedStatus = 2 ");
        }
        if (this.lcmCatID != null && this.lcmCatID.trim().length() != 0) {
            condSql.append(" AND ");
            condSql.append(" LCMCat.FID ").append("in (").append(this.lcmCatID).append(") ");
        }
        if (this.deptID != null && this.deptID.trim().length() != 0) {
            condSql.append(" AND ");
            condSql.append(" USEDEPT.FID ").append("= '").append(this.deptID).append("' ");
        }
        if (this.userID != null && this.userID.trim().length() != 0) {
            condSql.append(" AND ");
            condSql.append(" USEPERSON.FID ").append("= '").append(this.userID).append("' ");
        }
        if (this.lcmName != null && this.lcmName.trim().length() != 0) {
            condSql.append(" AND ");
            condSql.append(" LCMCURCARD.FNAME ").append("= '").append(this.lcmName).append("' ");
        }
        if (!this.isVirCompany) {
            if (this.companyID != null && this.companyID.trim().length() != 0) {
                condSql.append(" AND ");
                condSql.append(" LCMCURCARD.FCompanyID ").append("= '").append(this.companyID).append("' ");
            }
        } else {
            condSql.append(" AND ");
            condSql.append(" LCMCURCARD.FCompanyID ").append("in (").append(this.strCompanyInclude).append(") ");
        }
        if (this.filter != null) {
            if (billType == 3 && this.filter.indexOf("voucher") != -1) {
                condSql.append(" AND 1=0");
                return condSql.toString();
            }
            String filterB = new String(this.filter);
            filterB = filterB.replaceAll("bizBill.FUseDate", bizDate);
            filterB = filterB.replaceAll("bizBill.Fnumber", bizNum);
            condSql.append(" AND ");
            condSql.append(" ").append(filterB);
        }
        return condSql.toString();
    }

    private String getJoinSql(boolean isDiscardFromCard, int billType) {
        String tabName;
        StringBuffer sql = new StringBuffer(" ");
        if (billType == 1) {
            sql.append(" T_LCM_LCMConsumeBill AS LCMBILL ");
            sql.append("INNER JOIN T_BD_Period AS PERIOD ON LCMBILL.FPeriodID = PERIOD.FID ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMConsumeBillEntry AS BILLENTRY ON LCMBILL.FID = BILLENTRY.FBillID ");
            sql.append("left outer join ( ");
            sql.append("  select e.fsrcbillentryid as fsrcbillentryid, ");
            sql.append("     sum(e.FBeConsumeQty) as FBeConsumeQty, ");
            sql.append("     sum(e.FBeConsumeAmt) as FBeConsumeAmt, ");
            sql.append("     sum(e.FAmortizedAmount) as FAmortizedAmount, ");
            sql.append("     sum(e.FAmortizeAmount) as FAmortizeAmount ");
            sql.append("from t_lcm_lcmconsumebill c ");
            sql.append("inner join t_lcm_lcmconsumebillentry e on e.fbillid = c.fid ");
            sql.append("inner join t_bd_period p on p.fid = c.fperiodid ");
            sql.append("where c.fcompanyid = '").append(this.companyID).append("' ");
            sql.append("  and c.fcheckedstatus = 2 ");
            sql.append("  and p.fnumber > ").append(this.startYear * 100 + this.startNumber);
            sql.append("  and e.fsrcbillentryid is not null ");
            sql.append("group by e.fsrcbillentryid) consumeentry on consumeentry.fsrcbillentryid = BILLENTRY.fid ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON BILLENTRY.FCurCardID = LCMCURCARD.FID ");
            sql.append("INNER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS KEEPDEPT ON LCMCURCARD.FDeptID = KEEPDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
            sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
            sql.append("INNER JOIN T_LCM_LCMAlterMode AS LcmAlterMode ON LCMCURCARD.FSourceModeID = LcmAlterMode.FID ");
            sql.append("INNER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS USEPERSON ON LCMBILL.FUsePersonID = USEPERSON.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON LCMBILL.FUseDepartmentID = USEDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BOT_Relation AS rela ON rela.FDestEntityID ='2652E01E' and  rela.fsrcObjectID = LCMBILL.FID ");
            sql.append("LEFT OUTER JOIN T_GL_Voucher AS Voucher ON rela.fdestobjectid = Voucher.FID ");
        } else if (billType == 2) {
            if (isDiscardFromCard) {
                sql.append(" T_LCM_DiscardBill AS DISCARDBILL ");
                sql.append("INNER JOIN T_BD_Period AS PERIOD ON DISCARDBILL.FPeriodID = PERIOD.FID ");
                sql.append("LEFT OUTER JOIN T_LCM_DiscardBillEntry AS DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
                sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON DISCARDENTRY.FCurCardID = LCMCURCARD.FID ");
                sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON LCMCURCARD.FDeptID = USEDEPT.FID ");
            } else {
                sql.append(" T_LCM_DiscardBill AS DISCARDBILL ");
                sql.append("INNER JOIN T_BD_Period AS PERIOD ON DISCARDBILL.FPeriodID = PERIOD.FID ");
                sql.append("LEFT OUTER JOIN T_LCM_DiscardBillEntry AS DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
                sql.append("LEFT OUTER JOIN T_LCM_LCMConsumeBillEntry AS CONSUMEENTRY ON CONSUMEENTRY.FID = DISCARDENTRY.FConsumeEntryID ");
                sql.append("LEFT OUTER JOIN T_LCM_LCMConsumeBill AS LCMBILL ON CONSUMEENTRY.FBillID = LCMBILL.FID ");
                sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON LCMBILL.FUseDepartmentID = USEDEPT.FID ");
                sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON CONSUMEENTRY.FCurCardID = LCMCURCARD.FID ");
            }
            sql.append("INNER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS KEEPDEPT ON LCMCURCARD.FDeptID = KEEPDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
            sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
            sql.append("INNER JOIN T_LCM_LCMAlterMode AS LcmAlterMode ON LCMCURCARD.FSourceModeID = LcmAlterMode.FID ");
            sql.append("INNER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
            sql.append("LEFT OUTER JOIN T_BOT_Relation AS rela ON DISCARDBILL.FFiVouchered = 1 and  rela.FDestEntityID ='2652E01E' and  rela.fsrcObjectID = DISCARDBILL.FID ");
            sql.append("LEFT OUTER JOIN T_GL_Voucher AS Voucher ON rela.fdestobjectid = Voucher.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS USEPERSON ON DISCARDBILL.FPersonID = USEPERSON.FID ");
        } else {
            sql.append(" T_LCM_LCMReturnConsumeBill AS RETURNBILL ");
            sql.append("INNER JOIN T_BD_Period AS PERIOD ON RETURNBILL.FPeriodID = PERIOD.FID ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMReturnConsumeEntry AS RETURNENTRY ON RETURNBILL.FID = RETURNENTRY.FEntryID ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMConsumeBill AS LCMBILL ON RETURNENTRY.FConsumebillID = LCMBILL.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON LCMBILL.FUseDepartmentID = USEDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON RETURNENTRY.FCurCardID = LCMCURCARD.FID ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS RETURNLCMCURCARD ON RETURNENTRY.FReturnCurCardID = RETURNLCMCURCARD.FID ");
            sql.append("INNER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS KEEPDEPT ON LCMCURCARD.FDeptID = KEEPDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
            sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
            sql.append("INNER JOIN T_LCM_LCMAlterMode AS LcmAlterMode ON LCMCURCARD.FSourceModeID = LcmAlterMode.FID ");
            sql.append("INNER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS USEPERSON ON RETURNBILL.FuserID = USEPERSON.FID ");
        }
        if (this.isVirCompany && (tabName = this.getSumItemJoinSql("orgArchitecture")) != null) {
            sql.append(" INNER JOIN ").append(tabName).append(" AS ").append("orgArchitecture");
            sql.append(" ON LCMCURCARD.FCompanyID = ").append("orgArchitecture").append(".FID");
        }
        String tableName = this.isLevelSum("lcmCat") ? this.getSumItemJoinSql("lcmCat") : this.getSumItemTableName("lcmCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("lcmCat");
        sql.append(" ON LCMCURCARD.FAssetCatID = ").append("lcmCat").append(".FID");
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" USEDATE, ");
        sql.append(" USER_NAME, ");
        sql.append(" bizType, ");
        sql.append(" bizBillNum, ");
        sql.append(" voucherNum, ");
        sql.append(" ASSETCAT_NAME, ");
        sql.append(" cardNum, ");
        sql.append(" LCM, ");
        sql.append(" SPECS, ");
        sql.append(" KEEPDEPT_NAME, ");
        sql.append(" LIFE, ");
        sql.append(" MEASUREUNIT_NAME, ");
        sql.append(" USEQUANTITY, ");
        sql.append(" USEAMOUNT, ");
        sql.append(" discardQty, ");
        sql.append(" discardAmt, ");
        sql.append(" returnQty, ");
        sql.append(" returnAmt, ");
        sql.append(" AMORTEDQTY, ");
        sql.append(" AMORTEDAMOUNT, ");
        sql.append(" AMORTQTY, ");
        sql.append(" AMORTAMOUNT, ");
        sql.append(" accAmortedQty, ");
        sql.append(" accAmortedQAmt, ");
        sql.append(" USEABELQTY, ");
        sql.append(" BillID, ");
        sql.append(" CARDID, ");
        sql.append(" PREC, ");
        sql.append(" BILLTYPE, ");
        sql.append(" PeriodNum, ");
        sql.append(" isSum ");
        if (this.isVirCompany) {
            sql.append(", SumLevel ");
        }
        return sql.toString();
    }

    private String getSumSelectSql(int PeriodNum, boolean isBegin, boolean isBeginNull, boolean isYearSum, String bizType, Date bizDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append("TO_DATE('" + bizDate.toString() + " ') AS  USEDATE, ");
        sql.append("TO_CHAR(null) AS  USER_NAME, ");
        sql.append(bizType + " AS  bizType, ");
        sql.append("TO_CHAR(null) AS  bizBillNum, ");
        sql.append("TO_CHAR(null) AS  voucherNum, ");
        sql.append("TO_CHAR(null) AS  ASSETCAT_NAME, ");
        sql.append("TO_CHAR(null) AS  cardID, ");
        sql.append("TO_DECIMAL(null) AS FUnitPrice, ");
        sql.append("TO_CHAR(null) AS  cardNum, ");
        sql.append("TO_CHAR(null) AS  LCM, ");
        sql.append("TO_CHAR(null) AS  SPECS, ");
        sql.append("TO_CHAR(null) AS  KEEPDEPT_NAME, ");
        sql.append("TO_CHAR(null) AS  LIFE, ");
        sql.append("TO_CHAR(null) AS  MEASUREUNIT_NAME, ");
        if (isBegin) {
            sql.append("TO_DECIMAL(null) AS  USEQUANTITY, ");
            sql.append("TO_DECIMAL(null) AS  USEAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  discardQty, ");
            sql.append("TO_DECIMAL(null) AS  discardAmt, ");
            sql.append("TO_DECIMAL(null) AS  returnQty, ");
            sql.append("TO_DECIMAL(null) AS  returnAmt, ");
            sql.append("TO_DECIMAL(null) AS  AMORTEDQTY, ");
            sql.append("TO_DECIMAL(null) AS  AMORTEDAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  AMORTQTY, ");
            sql.append("TO_DECIMAL(null) AS  AMORTAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  accAmortedQty, ");
            sql.append("TO_DECIMAL(null) AS  accAmortedQAmt, ");
            if (isBeginNull) {
                sql.append("0 AS  USEABELQTY, ");
            } else {
                sql.append("sum(USEABELQTY) AS  USEABELQTY, ");
            }
            sql.append("TO_CHAR(null) AS  BillID, ");
            sql.append("TO_INT(null) AS  PREC, ");
            sql.append("-1 AS  BILLTYPE, ");
            sql.append(PeriodNum * 10 + 1 + " AS  PeriodNum, ");
        } else if (!isYearSum) {
            sql.append("sum(USEQUANTITY) AS  USEQUANTITY, ");
            sql.append("sum(USEAMOUNT) AS  USEAMOUNT, ");
            sql.append("sum(discardQty) AS  discardQty, ");
            sql.append("sum(discardAmt) AS  discardAmt, ");
            sql.append("sum(returnQty) AS  returnQty, ");
            sql.append("sum(returnAmt) AS  returnAmt, ");
            sql.append("sum(AMORTEDQTY) AS  AMORTEDQTY, ");
            sql.append("sum(AMORTEDAMOUNT) AS  AMORTEDAMOUNT, ");
            sql.append("sum(AMORTQTY) AS  AMORTQTY, ");
            sql.append("sum(AMORTAMOUNT) AS  AMORTAMOUNT, ");
            sql.append("sum(accAmortedQty) AS  accAmortedQty, ");
            sql.append("sum(accAmortedQAmt) AS  accAmortedQAmt, ");
            sql.append("TO_DECIMAL(null) AS  USEABELQTY, ");
            sql.append("TO_CHAR(null) AS  BillID, ");
            sql.append("TO_INT(null) AS  PREC, ");
            sql.append("-2 AS  BILLTYPE, ");
            sql.append(PeriodNum * 10 + 3 + " AS  PeriodNum, ");
        } else {
            sql.append("sum(USEQUANTITY) AS  USEQUANTITY, ");
            sql.append("sum(USEAMOUNT) AS  USEAMOUNT, ");
            sql.append("sum(discardQty) AS  discardQty, ");
            sql.append("sum(discardAmt) AS  discardAmt, ");
            sql.append("sum(returnQty) AS  returnQty, ");
            sql.append("sum(returnAmt) AS  returnAmt, ");
            sql.append("sum(AMORTEDQTY) AS  AMORTEDQTY, ");
            sql.append("sum(AMORTEDAMOUNT) AS  AMORTEDAMOUNT, ");
            sql.append("sum(AMORTQTY) AS  AMORTQTY, ");
            sql.append("sum(AMORTAMOUNT) AS  AMORTAMOUNT, ");
            sql.append("sum(accAmortedQty) AS  accAmortedQty, ");
            sql.append("sum(accAmortedQAmt) AS  accAmortedQAmt, ");
            sql.append("sum(USEABELQTY) AS  USEABELQTY, ");
            sql.append("TO_CHAR(null) AS  BillID, ");
            sql.append("TO_INT(null) AS  PREC, ");
            sql.append("-3 AS  BILLTYPE, ");
            sql.append(PeriodNum + " AS  PeriodNum, ");
        }
        if (!this.isVirCompany) {
            sql.append(" 1 AS isSum ");
        } else {
            sql.append(" 0 AS isSum ");
        }
        if (this.isVirCompany) {
            sql.append(",TO_CHAR(null) AS Company_Id");
        }
        if (this.isVirCompany) {
            sql.append(",max(SumLevel) AS SumLevel");
        }
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        return sql.toString();
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.isShowNotAudit = (Boolean)m.get("hasUnAudit");
        this.isByConsume = (Boolean)m.get("byConsume");
        this.isByDiscard = (Boolean)m.get("byDiscard");
        this.isByReturn = (Boolean)m.get("byReturn");
        if (!(this.isByConsume || this.isByDiscard || this.isByReturn)) {
            this.isByReturn = true;
            this.isByDiscard = true;
            this.isByConsume = true;
        }
        this.lcmName = (String)m.get("lcmName");
        this.lcmCatID = "";
        String lcmCatNumber = (String)m.get("lcmCatID");
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)("select Fid from t_lcm_lcmlcmcat where fnumber = '" + lcmCatNumber + "'  and fcompanyid in (" + this.strCompanyInclude + ")"));
        try {
            for (int i = 0; i < row.size(); ++i) {
                row.next();
                String catId = row.getString("Fid");
                this.lcmCatID = this.lcmCatID + "'" + catId + "'";
                if (i == row.size() - 1) continue;
                this.lcmCatID = this.lcmCatID + ",";
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        this.deptID = (String)m.get("useDept");
        this.userID = (String)m.get("usePerson");
        this.periodType = (PeriodTypeInfo)m.get("periodType");
        if (this.periodType != null) {
            this.periodTypeId = this.periodType.getId().toString();
        }
        this.cf = new FaDBUtilConfig();
        this.tableFieldConfig(this.cf);
    }

    protected String getProperTempTable(Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("lcm temp table");
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        sorterSql.append(" PeriodNum,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
        }
        if (this.isVirCompany) {
            sorterSql.append(" SumLevel , ").append(" isSum DESC,");
        }
        sorterSql.append("USEDATE ,");
        sorterSql.append("BILLTYPE");
        SorterItemCollection sorters = ev.getSorter();
        for (SorterItemInfo sorterItem : sorters) {
            if (sorterItem.getPropertyName().equals("USERDEFINENAME")) continue;
            sorterSql.append(", ");
            sorterSql.append(sorterItem.toString());
        }
        String sql = sorterSql.toString();
        return sql;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        return ev.getFilter().toString();
    }

    protected String getCurrentCompany() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        BOSUuid id = ContextUtil.getCurrentFIUnit((Context)this.ctx).getId();
        return id.toString();
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    private void fillSumData() throws BOSException, SQLException {
        int index = 0;
        Date bizDate = null;
        Date fendDate = null;
        Date yearSumDate = null;
        Iterator iter = this.periods.iterator();
        while (iter.hasNext()) {
            int periodNum = (Integer)iter.next();
            String queryDate = "select FBeginDate,FEndDate from t_bd_period where fnumber = " + periodNum + " and ftypeid = '" + this.getPeriodTypeId() + "'";
            IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)queryDate);
            try {
                row.next();
                bizDate = row.getDate("FBeginDate");
                fendDate = row.getDate("FEndDate");
                yearSumDate = bizDate;
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            StringBuffer sql = new StringBuffer("INSERT INTO " + this.tempTable + " SELECT " + this.getSumSelectSql(periodNum, false, false, false, this.periodClose, fendDate) + " FROM " + this.tempTable + " WHERE billtype>0 and PeriodNum =" + (periodNum * 10 + 2));
            if (this.isVirCompany) {
                sql.append(" group by  " + this.sumOption.getStrLongNumberFields() + "," + this.sumOption.getStrNameFields());
            }
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql = new StringBuffer("INSERT INTO " + this.tempTable + " SELECT " + this.getSumSelectSql(periodNum, true, false, false, this.periodBegin, bizDate) + " FROM (" + this.buildConsumeBillQuery(index) + " union all " + this.buildReturnQuery(index) + " union all " + this.buildDiscardQuery(index) + ")A ");
            if (this.isVirCompany) {
                sql.append(" group by  " + this.sumOption.getStrLongNumberFields() + "," + this.sumOption.getStrNameFields());
            }
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            if (this.isVirCompany) {
                String insertSql = this.buildBeginInsert(periodNum * 10 + 1);
                DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
            }
            if (index == 0) {
                StringBuffer sqlB = new StringBuffer();
                sqlB.append("SELECT Fid FROM " + this.tempTable + " WHERE USEABELQTY IS NULL AND isSum = 1 and PeriodNum = " + (periodNum * 10 + 1) + "");
                IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlB.toString());
                while (rows != null && rows.next()) {
                    sql = new StringBuffer("UPDATE " + this.tempTable + " SET USEABELQTY = 0 WHERE FID = '" + rows.getString("Fid") + "'");
                    DbUtil.execute((Context)this.ctx, (String)sql.toString());
                }
            }
            if (!iter.hasNext()) {
                ArrayList<Integer> years = new ArrayList<Integer>();
                int size = this.endYear - this.startYear;
                years.add(new Integer(this.endYear));
                Iterator itera = years.iterator();
                while (itera.hasNext()) {
                    int year = (Integer)itera.next();
                    int minPeriodNum = year * 1000;
                    int maxPeriodNum = year * 1000 + 999;
                    StringBuffer sqls = new StringBuffer("INSERT INTO " + this.tempTable + " SELECT " + this.getSumSelectSql(maxPeriodNum, false, false, true, this.yearSum, fendDate) + " FROM " + this.tempTable + " WHERE isSum = 0 AND PeriodNum > " + minPeriodNum + " AND PeriodNum < " + maxPeriodNum + " and billType!=-2");
                    if (this.isVirCompany) {
                        sqls.append(" group by  " + this.sumOption.getStrLongNumberFields() + "," + this.sumOption.getStrNameFields());
                    }
                    DbUtil.execute((Context)this.ctx, (String)sqls.toString());
                }
            }
            ++index;
        }
    }

    private void fillAccData() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Fid,cardID,USEDATE,FUnitPrice FROM " + this.tempTable + " WHERE BILLTYPE < 3 AND isSum = 0 AND CARDID IS NOT NULL ORDER BY USEDATE ASC ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        while (rows != null && rows.next()) {
            String fid = rows.getString("Fid");
            String cardID = rows.getString("cardID");
            Date useDate = rows.getDate("USEDATE");
            BigDecimal unitPrice = rows.getBigDecimal("FUnitPrice");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String useDateStr = dateFormat.format(useDate);
            sql = new StringBuffer("SELECT SUM(BILLENTRY.FAmortizedAmount) AS FAmortizedAmount");
            sql.append(" FROM T_LCM_LCMConsumeBill AS LCMBILL ");
            sql.append("INNER JOIN T_LCM_LCMConsumeBillEntry AS BILLENTRY ON LCMBILL.FID = BILLENTRY.FBillID ");
            sql.append("INNER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON BILLENTRY.FCurCardID = LCMCURCARD.FID ");
            sql.append("WHERE LCMBILL.FUseDate ").append("<= TO_DATE('").append(useDateStr).append("') ");
            sql.append("AND BILLENTRY.FCurCardID ='").append(cardID).append("' ");
            IRowSet rowsB = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            rowsB.next();
            BigDecimal amortizedAmount = rowsB.getBigDecimal("FAmortizedAmount") == null ? this.ZERO : rowsB.getBigDecimal("FAmortizedAmount");
            sql = new StringBuffer("SELECT SUM(DISCARDENTRY.FamortizeAmount) AS FAmortizedAmount");
            sql.append(" FROM T_LCM_DiscardBill AS DISCARDBILL ");
            sql.append("INNER JOIN T_LCM_DiscardBillEntry AS DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
            sql.append("INNER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON DISCARDENTRY.FCurCardID = LCMCURCARD.FID ");
            sql.append("WHERE DISCARDBILL.FDiscardDate ").append("<= TO_DATE('").append(useDateStr).append("') ");
            sql.append("AND DISCARDENTRY.FCurCardID ='").append(cardID).append("' ");
            IRowSet rowsC = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            rowsC.next();
            amortizedAmount = amortizedAmount.add(rowsC.getBigDecimal("FAmortizedAmount") == null ? this.ZERO : rowsC.getBigDecimal("FAmortizedAmount"));
            sql = new StringBuffer("SELECT SUM(DISCARDENTRY.FamortizeAmount) AS FAmortizedAmount");
            sql.append(" FROM T_LCM_DiscardBill AS DISCARDBILL ");
            sql.append("INNER JOIN T_BD_Period AS PERIOD ON DISCARDBILL.FPeriodID = PERIOD.FID ");
            sql.append("INNER JOIN T_LCM_DiscardBillEntry AS DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
            sql.append("INNER JOIN T_LCM_LCMConsumeBillEntry AS CONSUMEENTRY ON CONSUMEENTRY.FID = DISCARDENTRY.FConsumeEntryID ");
            sql.append("INNER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON CONSUMEENTRY.FCurCardID = LCMCURCARD.FID ");
            sql.append("WHERE DISCARDBILL.FDiscardDate ").append("<= TO_DATE('").append(useDateStr).append("') ");
            sql.append("AND LCMCURCARD.FID ='").append(cardID).append("' ");
            IRowSet rowsD = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            rowsD.next();
            amortizedAmount = amortizedAmount.add(rowsD.getBigDecimal("FAmortizedAmount") == null ? this.ZERO : rowsD.getBigDecimal("FAmortizedAmount"));
            if (unitPrice.compareTo(this.ZERO) == 0) {
                unitPrice = new BigDecimal(1);
                sql = new StringBuffer("UPDATE " + this.tempTable + " SET AMORTEDQTY = " + amortizedAmount + ",accAmortedQAmt = " + amortizedAmount + " WHERE FID = '" + fid + "'");
                continue;
            }
            sql = new StringBuffer("UPDATE " + this.tempTable + " SET AMORTEDQTY = " + amortizedAmount + ",accAmortedQAmt = " + amortizedAmount + " WHERE FID = '" + fid + "'");
        }
    }

    private ArrayList getPeriodIDList() throws BOSException {
        String queryPeriod = "select distinct p.FNumber from t_bd_period p where p.FNumber >= " + (this.startYear * 100 + this.startNumber) + " and p.FNumber <= " + (this.endYear * 100 + this.endNumber) + " and p.ftypeid = '" + this.getPeriodTypeId() + "'  order by p.FNumber asc";
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)queryPeriod);
        try {
            while (rows.next()) {
                this.periods.add(new Integer(rows.getInt("FNumber")));
            }
        }
        catch (SQLException e) {
            throw new BOSException(queryPeriod, (Throwable)e);
        }
        return this.periods;
    }

    private String getPeriodTypeId() throws BOSException {
        String queryPeriodTypeId = this.periodTypeId;
        if (queryPeriodTypeId == null) {
            String queryPeriodType = "select ftypeid from t_bd_period where fid = '" + this.currPeriod.getId() + "'";
            IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)queryPeriodType);
            try {
                while (rows.next()) {
                    queryPeriodTypeId = rows.getString(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException(queryPeriodType.toString(), (Throwable)e);
            }
        }
        return queryPeriodTypeId;
    }

    private String getSumSelectSql(int periodNum, String bizType, Date bizDate, boolean isBegin) {
        StringBuffer sql = new StringBuffer();
        sql.append("TO_DATE('" + bizDate.toString() + "') AS  USEDATE, ");
        sql.append("TO_CHAR(null) AS  USER_NAME, ");
        sql.append(bizType + " AS  bizType, ");
        sql.append("TO_CHAR(null) AS  bizBillNum, ");
        sql.append("TO_CHAR(null) AS  voucherNum, ");
        sql.append("TO_CHAR(null) AS  ASSETCAT_NAME, ");
        sql.append("TO_CHAR(null) AS  cardID, ");
        sql.append("TO_DECIMAL(null) AS FUnitPrice, ");
        sql.append("TO_CHAR(null) AS  cardNum, ");
        sql.append("TO_CHAR(null) AS  LCM, ");
        sql.append("TO_CHAR(null) AS  SPECS, ");
        sql.append("TO_CHAR(null) AS  KEEPDEPT_NAME, ");
        sql.append("TO_CHAR(null) AS  LIFE, ");
        sql.append("TO_CHAR(null) AS  MEASUREUNIT_NAME, ");
        if (isBegin) {
            sql.append("TO_DECIMAL(null) AS  USEQUANTITY, ");
            sql.append("TO_DECIMAL(null) AS  USEAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  discardQty, ");
            sql.append("TO_DECIMAL(null) AS  discardAmt, ");
            sql.append("TO_DECIMAL(null) AS  returnQty, ");
            sql.append("TO_DECIMAL(null) AS  returnAmt, ");
            sql.append("TO_DECIMAL(null) AS  AMORTEDQTY, ");
            sql.append("TO_DECIMAL(null) AS  AMORTEDAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  AMORTQTY, ");
            sql.append("TO_DECIMAL(null) AS  AMORTAMOUNT, ");
            sql.append("TO_DECIMAL(null) AS  accAmortedQty, ");
            sql.append("TO_DECIMAL(null) AS  accAmortedQAmt, ");
        } else {
            sql.append("sum(isNull(USEQUANTITY,0)) AS  USEQUANTITY, ");
            sql.append("sum(isNull(USEAMOUNT,0)) AS  USEAMOUNT, ");
            sql.append("sum(isNull(discardQty,0)) AS  discardQty, ");
            sql.append("sum(isNull(discardAmt,0)) AS  discardAmt, ");
            sql.append("sum(isNull(returnQty,0)) AS  returnQty, ");
            sql.append("sum(isNull(returnAmt,0)) AS  returnAmt, ");
            sql.append("sum(isNull(AMORTEDQTY,0)) AS  AMORTEDQTY, ");
            sql.append("sum(isNull(AMORTEDAMOUNT,0)) AS  AMORTEDAMOUNT, ");
            sql.append("sum(isNull(AMORTQTY,0)) AS  AMORTQTY, ");
            sql.append("sum(isNull(AMORTAMOUNT,0)) AS  AMORTAMOUNT, ");
            sql.append("sum(isNull(accAmortedQty,0)) AS  accAmortedQty, ");
            sql.append("sum(isNull(accAmortedQAmt,0)) AS  accAmortedQAmt, ");
        }
        sql.append("sum(USEABELQTY) AS USEABELQTY, ");
        sql.append("TO_CHAR(null) AS BillID, ");
        sql.append("TO_INT(null) AS PREC, ");
        if (bizType.equals(this.periodBegin)) {
            sql.append("TO_INT(-4) AS BILLTYPE, ");
        } else if (bizType.equals(this.periodClose)) {
            sql.append("TO_INT(-5) AS BILLTYPE, ");
        } else if (bizType.equals(this.yearSum)) {
            sql.append("TO_INT(-6) AS BILLTYPE, ");
        } else {
            sql.append("TO_INT(null) AS BILLTYPE, ");
        }
        sql.append(periodNum + " AS PeriodNum, ");
        sql.append("1 AS isSum ");
        if (this.isVirCompany) {
            sql.append(",TO_CHAR(null) AS Company_Id");
        }
        return sql.toString();
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        int startPeriod = startYear * 100 + startNumber;
        int endPeriod = endYear * 100 + endNumber;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(32);
        if (!this.isInitPeriod) {
            sql.append(" AND currPeriod.Fnumber >= ").append(startPeriod);
            sql.append(" AND startPeriod.Fnumber <= ").append(endPeriod);
        }
        sql.append(" AND company.FID IN (").append(selectedIds).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    protected String buildBeginInsert(int periodNum) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + this.tempTable);
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append("TO_DATE(null) AS  USEDATE, ");
        sql.append("TO_CHAR(null) AS  USER_NAME, ");
        sql.append("TO_CHAR(null) AS  bizType, ");
        sql.append("TO_CHAR(null) AS  bizBillNum, ");
        sql.append("TO_CHAR(null) AS  voucherNum, ");
        sql.append("TO_CHAR(null) AS  ASSETCAT_NAME, ");
        sql.append("TO_CHAR(null) AS  cardID, ");
        sql.append("TO_DECIMAL(null) AS FUnitPrice, ");
        sql.append("TO_CHAR(null) AS  cardNum, ");
        sql.append("TO_CHAR(null) AS  LCM, ");
        sql.append("TO_CHAR(null) AS  SPECS, ");
        sql.append("TO_CHAR(null) AS  KEEPDEPT_NAME, ");
        sql.append("TO_CHAR(null) AS  LIFE, ");
        sql.append("TO_CHAR(null) AS  MEASUREUNIT_NAME, ");
        sql.append("TO_DECIMAL(null) AS  USEQUANTITY, ");
        sql.append("TO_DECIMAL(null) AS  USEAMOUNT, ");
        sql.append("TO_DECIMAL(null) AS  discardQty, ");
        sql.append("TO_DECIMAL(null) AS  discardAmt, ");
        sql.append("TO_DECIMAL(null) AS  returnQty, ");
        sql.append("TO_DECIMAL(null) AS  returnAmt, ");
        sql.append("TO_DECIMAL(null) AS  AMORTEDQTY, ");
        sql.append("TO_DECIMAL(null) AS  AMORTEDAMOUNT, ");
        sql.append("TO_DECIMAL(null) AS  AMORTQTY, ");
        sql.append("TO_DECIMAL(null) AS  AMORTAMOUNT, ");
        sql.append("TO_DECIMAL(null) AS  accAmortedQty, ");
        sql.append("TO_DECIMAL(null) AS  accAmortedQAmt, ");
        sql.append("0 AS USEABELQTY, ");
        sql.append("TO_CHAR(null) AS BillID, ");
        sql.append("TO_INT(null) AS PREC, ");
        sql.append("TO_INT(-1) AS BILLTYPE, ");
        sql.append(periodNum + " AS PeriodNum, ");
        sql.append("0 AS isSum ");
        if (this.isVirCompany) {
            sql.append(",TO_CHAR(null) AS Company_Id");
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM T_ORG_COMPANY COMPANY ");
        String tabName = this.getSumItemJoinSql("orgArchitecture");
        if (tabName != null) {
            sql.append(" INNER JOIN ").append(tabName).append(" AS ").append("orgArchitecture");
            sql.append(" ON COMPANY.FID = ").append("orgArchitecture").append(".FID");
        }
        sql.append(" WHERE COMPANY.FID ").append("in (").append(this.strCompanyInclude).append(") ");
        return sql.toString();
    }
}

