/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LCMAmortOldListDao
extends FaDaoBase {
    private static final Logger logger = Logger.getLogger(LCMAmortOldListDao.class);
    private static final String USE_DATE_FROM = "useDateFrom";
    private static final String USE_DATE_TO = "useDateTo";
    private static final String LCM_CAT_ID = "lcmCatID";
    private static final String LCM_NAME = "lcmName";
    private static final String USE_DEPT = "useDept";
    private static final String USE_PERSON = "usePerson";
    private static final String HAS_UN_AUDIT = "hasUnAudit";
    private static final String BY_DEPT = "byDept";
    private static final String BY_LCM = "byLcm";
    private String select;
    private Date useDateFrom = null;
    private Date useDateTo = null;
    private boolean isByDept;
    private boolean isByLcm;
    private boolean isShowNotAudit;
    private String lcmName = null;
    private String lcmCatID = null;
    private String deptID = null;
    private String userID = null;
    private String useDateFromStr = null;
    private String useDateToStr = null;
    private String sumSql;
    private String companyID;
    private PeriodInfo currPeriod;

    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql(true);
        this.buildResultSql();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    protected void buildData() throws BOSException {
        int start;
        try {
            this.companyID = this.getCurrentCompany();
        }
        catch (Exception e) {
            new BOSException((Throwable)e);
        }
        StringBuffer createTmpTable = new StringBuffer(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryCardSQL()));
        while (createTmpTable.indexOf("LCMCURCARD.FNAME_l2") != -1) {
            start = createTmpTable.indexOf("LCMCURCARD.FNAME_l2");
            createTmpTable.replace(start, start + "LCMCURCARD.FNAME_l2".length(), "(LCMCURCARD.FNUMBER ||'-'|| LCMCURCARD.FNAME)");
        }
        while (createTmpTable.indexOf("LCMCURCARD.FNAME_l3") != -1) {
            start = createTmpTable.indexOf("LCMCURCARD.FNAME_l3");
            createTmpTable.replace(start, start + "LCMCURCARD.FNAME_l3".length(), "(LCMCURCARD.FNUMBER ||'-'|| LCMCURCARD.FNAME)");
        }
        this.addDataTempTable(createTmpTable.toString());
        this.updateToNull();
        this.sumSql = this.sumOption.getSumSql(this.tempTable, this.select, null, null, null, true, false);
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)this.sumSql);
        }
    }

    private String getCardSelectSql(boolean isDetail) {
        StringBuffer sql = new StringBuffer();
        if (this.isByDept) {
            sql.append("LCMCURCARD.FNumber ||'-'|| LCMCURCARD.FName AS LCM, ");
        }
        String lcmbill = isDetail ? "DETAIL" : "LCMBILL";
        String lcmbillB = isDetail ? "LCMCURCARD" : "LCMBILL";
        String billentry = isDetail ? "DETAIL" : "BILLENTRY";
        sql.append("USEPERSON.").append(this.fName).append(" AS USER_NAME, ");
        sql.append("MEASUREUNIT.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
        sql.append(lcmbill).append(".FUseDate AS USEDATE, ");
        sql.append("USEDEPT.").append(this.fName).append(" AS USEDEPT_NAME, ");
        sql.append(lcmbillB).append(".FID AS BillID, ");
        sql.append("LCMCat.").append(this.fName).append(" AS ASSETCAT_NAME, ");
        sql.append("1 AS billNum, ");
        sql.append("LCMCURCARD.FSpecs AS SPECS, ");
        sql.append("LCMCURCARD.FName AS CARDNAME, ");
        sql.append("LCMCURCARD.FBuyDate AS BUYDATE, ");
        sql.append("KEEPDEPT.").append(this.fName).append(" AS KEEPDEPT_NAME, ");
        sql.append("LCMCURCARD.FAssetAmt AS ASSETAMT, ");
        sql.append("CURRENCY.").append(this.fName).append(" AS CURRENCY_NAME, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("LCMCURCARD.FOriginAmount AS ORIGINAMT, ");
        sql.append("LCMCURCARD.FLocalAmount AS LOCALAMT, ");
        sql.append("LCMCURCARD.FUsableAmt AS USEABELAMT, ");
        sql.append("ADDRESS.Fname_l2 AS STORECITY_NAME, ");
        if (!isDetail) {
            sql.append("1 AS BILLTYPE, ");
        } else {
            sql.append("2 AS BILLTYPE, ");
        }
        sql.append("LCMCURCARD.FLife AS LIFE, ");
        sql.append("LCMCURCARD.FUseStatus AS USESTATUS_NAME, ");
        if (!isDetail) {
            sql.append("BILLENTRY").append(".FBeConsumeQty + (case when consumeentry.FBeConsumeQty is null then 0 else consumeentry.FBeConsumeQty end) AS USEQUANTITY, ");
        } else {
            sql.append("DETAIL").append(".FUseAmt AS USEQUANTITY, ");
        }
        sql.append(billentry).append(".FBeConsumeAmt + (case when consumeentry.FBeConsumeAmt is null then 0 else consumeentry.FBeConsumeAmt end) AS USEAMOUNT, ");
        sql.append(billentry).append(".FAmortizedAmount + (case when consumeentry.FAmortizedAmount is null then 0 else consumeentry.FAmortizedAmount end) AS AMORTEDAMOUNT, ");
        sql.append(billentry).append(".FAmortizeAmount + (case when consumeentry.FAmortizeAmount is null then 0 else consumeentry.FAmortizeAmount end) AS AMORTAMOUNT, ");
        sql.append("COMPANY.FID AS COMPANY_ID");
        sql.append(",0 AS isSum ");
        return sql.toString();
    }

    private String buildQueryCardSQL() {
        String consumeBillQuery = this.buildConsumeBillQuery();
        return consumeBillQuery;
    }

    private String buildConsumeDetailQuery() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(true));
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(this.isCurrPeriod, true));
        String condSql = this.getCondSql(this.isCurrPeriod, true);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String buildConsumeBillQuery() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql(false));
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(this.isCurrPeriod, false));
        String condSql = this.getCondSql(this.isCurrPeriod, false);
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCondSql(boolean isCurrPeriod, boolean isDetail) {
        StringBuffer condSql = new StringBuffer();
        if (!isDetail) {
            SimpleDateFormat dateFormat;
            if (!this.isShowNotAudit) {
                condSql.append("LCMBILL.FCheckedStatus = 2 ");
            }
            if (this.useDateFrom != null) {
                if (!this.isShowNotAudit) {
                    condSql.append(" AND ");
                }
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.useDateFromStr = dateFormat.format(this.useDateFrom);
                condSql.append(" LCMBILL.FUseDate ").append(">= {ts'").append(this.useDateFromStr + " 00:00:00").append("'} ");
            }
            if (this.useDateTo != null) {
                if (!this.isShowNotAudit || this.useDateFrom != null) {
                    condSql.append(" AND ");
                }
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.useDateToStr = dateFormat.format(this.useDateTo);
                condSql.append(" LCMBILL.FUseDate ").append("<= {ts'").append(this.useDateToStr + " 23:59:59").append("'} ");
            }
            if (this.lcmCatID != null && this.lcmCatID.trim().length() != 0) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCat.FID ").append("= '").append(this.lcmCatID).append("' ");
            }
            if (this.deptID != null && this.deptID.trim().length() != 0) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" USEDEPT.FID ").append("= '").append(this.deptID).append("' ");
            }
            if (this.userID != null && this.userID.trim().length() != 0) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" USEPERSON.FID ").append("= '").append(this.userID).append("' ");
            }
            if (this.lcmName != null && this.lcmName.trim().length() != 0) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCURCARD.FNAME ").append("= '").append(this.lcmName).append("' ");
            }
            if (this.companyID != null && this.companyID.trim().length() != 0) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0 || this.lcmName != null && this.lcmName.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCURCARD.FCompanyID ").append("= '").append(this.companyID).append("' ");
            }
            if (this.filter != null) {
                if (!this.isShowNotAudit || this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0 || this.lcmName != null && this.lcmName.trim().length() != 0 || this.companyID != null && this.companyID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                if (this.filter.indexOf("BILLENTRY.FQuantity") != -1) {
                    this.filter = this.filter.replaceAll("BILLENTRY.FQuantity", "BILLENTRY.fbeConsumeQty");
                }
                if (this.filter.indexOf("BILLENTRY.FUseAmount") != -1) {
                    this.filter = this.filter.replaceAll("BILLENTRY.FUseAmount", "BILLENTRY.fbeConsumeAmt");
                }
                condSql.append(" ").append(this.filter);
            }
            if (condSql.length() <= 0) return condSql.toString();
            try {
                PeriodInfo currPeriod = this.getCurrentPeriod(ContextUtil.getCurrentFIUnit((Context)this.ctx));
                condSql.append(" AND (period.fperiodyear*100+period.fperiodnumber) <= ").append(currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber());
                if (isCurrPeriod) return condSql.toString();
                condSql.append(" AND LCMCURCARD.FPERIODID = '").append(currPeriod.getId().toString()).append("'");
                return condSql.toString();
            }
            catch (EASBizException e) {
                return condSql.toString();
            }
            catch (BOSException e) {
                return condSql.toString();
            }
        } else {
            int start;
            SimpleDateFormat dateFormat;
            if (this.useDateFrom != null) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.useDateFromStr = dateFormat.format(this.useDateFrom);
                condSql.append(" DETAIL.FUseDate ").append(">= TO_DATE('").append(this.useDateFromStr).append("') ");
            }
            if (this.useDateTo != null) {
                if (this.useDateFrom != null) {
                    condSql.append(" AND ");
                }
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.useDateToStr = dateFormat.format(this.useDateTo);
                condSql.append(" DETAIL.FUseDate ").append("<= TO_DATE('").append(this.useDateToStr).append("') ");
            }
            if (this.lcmCatID != null && this.lcmCatID.trim().length() != 0) {
                if (this.useDateFrom != null || this.useDateTo != null) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCat.FID ").append("= '").append(this.lcmCatID).append("' ");
            }
            if (this.deptID != null && this.deptID.trim().length() != 0) {
                if (this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" USEDEPT.FID ").append("= '").append(this.deptID).append("' ");
            }
            if (this.userID != null && this.userID.trim().length() != 0) {
                if (this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" USEPERSON.FID ").append("= '").append(this.userID).append("' ");
            }
            if (this.lcmName != null && this.lcmName.trim().length() != 0) {
                if (this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCURCARD.FNAME ").append("= '").append(this.lcmName).append("' ");
            }
            if (this.companyID != null && this.companyID.trim().length() != 0) {
                if (this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0 || this.lcmName != null && this.lcmName.trim().length() != 0) {
                    condSql.append(" AND ");
                }
                condSql.append(" LCMCURCARD.FCompanyID ").append("= '").append(this.companyID).append("' ");
            }
            if (this.filter == null) return condSql.toString();
            if (this.useDateFrom != null || this.useDateTo != null || this.lcmCatID != null && this.lcmCatID.trim().length() != 0 || this.deptID != null && this.deptID.trim().length() != 0 || this.userID != null && this.userID.trim().length() != 0 || this.lcmName != null && this.lcmName.trim().length() != 0 || this.companyID != null && this.companyID.trim().length() != 0) {
                condSql.append(" AND ");
            }
            StringBuffer bufferFilter = new StringBuffer(this.filter);
            while (bufferFilter.indexOf("BILLENTRY.FQuantity") != -1) {
                start = bufferFilter.indexOf("BILLENTRY.FQuantity");
                bufferFilter.replace(start, start + "BILLENTRY.FQuantity".length(), "DETAIL.FUseAmt");
            }
            while (bufferFilter.indexOf("BILLENTRY") != -1) {
                start = bufferFilter.indexOf("BILLENTRY");
                bufferFilter.replace(start, start + "BILLENTRY".length(), "DETAIL");
            }
            condSql.append(" ").append(bufferFilter);
        }
        return condSql.toString();
    }

    private String getJoinSql(boolean isCurPeriod, boolean isDetail) {
        StringBuffer sql = new StringBuffer(" ");
        if (!isDetail) {
            sql.append(" T_LCM_LCMConsumeBill AS LCMBILL ");
            sql.append("LEFT OUTER JOIN T_LCM_LCMConsumeBillEntry AS BILLENTRY ON LCMBILL.FID = BILLENTRY.FBillID ");
            sql.append("left outer join ( ");
            sql.append("  select e.fsrcbillentryid as fsrcbillentryid, ");
            sql.append("     sum(e.FBeConsumeQty) as FBeConsumeQty, ");
            sql.append("     sum(e.FBeConsumeAmt) as FBeConsumeAmt, ");
            sql.append("     sum(e.FAmortizedAmount) as FAmortizedAmount, ");
            sql.append("     sum(e.FAmortizeAmount) as FAmortizeAmount ");
            sql.append("from t_lcm_lcmconsumebill c ");
            sql.append("inner join t_lcm_lcmconsumebillentry e on e.fbillid = c.fid ");
            sql.append("inner join t_bd_period p on p.fid = c.fperiodid ");
            sql.append("where c.fcompanyid = '").append(this.companyID).append("' ");
            sql.append("  and c.fcheckedstatus = 2 ");
            sql.append("  and p.fnumber > ").append(this.currPeriod.getNumber());
            sql.append("  and e.fsrcbillentryid is not null ");
            sql.append("group by e.fsrcbillentryid) consumeentry on consumeentry.fsrcbillentryid = BILLENTRY.fid ");
            if (isCurPeriod) {
                sql.append("LEFT OUTER JOIN T_LCM_LCMCurCard AS LCMCURCARD ON BILLENTRY.FCurCardID = LCMCURCARD.FID ");
            } else {
                sql.append("LEFT OUTER JOIN T_LCM_LCMMonCard AS LCMCURCARD ON BILLENTRY.FCurCardID = LCMCURCARD.FCurCardID ");
            }
            sql.append("INNER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS KEEPER ON LCMCURCARD.FKeeperID = KEEPER.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS KEEPDEPT ON LCMCURCARD.FDeptID = KEEPDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
            sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
            sql.append("INNER JOIN T_LCM_LCMAlterMode AS LcmAlterMode ON LCMCURCARD.FSourceModeID = LcmAlterMode.FID ");
            sql.append("INNER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS USEPERSON ON LCMBILL.FUsePersonID = USEPERSON.FID ");
            sql.append("LEFT OUTER JOIN T_BD_ADDRESS AS ADDRESS ON BILLENTRY.FSTOREADRESS = ADDRESS.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON LCMBILL.FUseDepartmentID = USEDEPT.FID ");
            sql.append("inner join t_bd_period period on LCMBILL.FPeriodID = period.fid");
        } else {
            sql.append(" T_LCM_LCMConsumeDetail AS DETAIL ");
            sql.append("INNER JOIN T_LCM_LCMMonCard AS LCMCURCARD ON DETAIL.FMonCardID = LCMCURCARD.FID ");
            sql.append("INNER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS KEEPER ON LCMCURCARD.FKeeperID = KEEPER.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS KEEPDEPT ON LCMCURCARD.FDeptID = KEEPDEPT.FID ");
            sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
            sql.append("INNER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
            sql.append("INNER JOIN T_LCM_LCMAlterMode AS LcmAlterMode ON LCMCURCARD.FSourceModeID = LcmAlterMode.FID ");
            sql.append("INNER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Person AS USEPERSON ON DETAIL.FUsePersonID = USEPERSON.FID ");
            sql.append("LEFT OUTER JOIN T_ORG_Admin AS USEDEPT ON DETAIL.FUseDepartmentID = USEDEPT.FID ");
        }
        String tableName = this.isLevelSum("lcmCat") ? this.getSumItemJoinSql("lcmCat") : this.getSumItemTableName("lcmCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("lcmCat");
        sql.append(" ON LCMCURCARD.FAssetCatID = ").append("lcmCat").append(".FID");
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isByDept) {
            sql.append(" LCM, ");
        }
        sql.append(" USER_NAME, ");
        sql.append(" MEASUREUNIT_NAME, ");
        sql.append(" USEDATE, ");
        sql.append(" USEDEPT_NAME, ");
        sql.append(" BillID, ");
        sql.append(" ASSETCAT_NAME, ");
        sql.append(" billNum, ");
        sql.append(" SPECS, ");
        sql.append(" CARDNAME, ");
        sql.append(" BUYDATE, ");
        sql.append(" KEEPDEPT_NAME, ");
        sql.append(" ASSETAMT, ");
        sql.append(" CURRENCY_NAME, ");
        sql.append(" PREC, ");
        sql.append(" ORIGINAMT, ");
        sql.append(" LOCALAMT, ");
        sql.append(" USEABELAMT, ");
        sql.append(" STORECITY_NAME, ");
        sql.append(" BILLTYPE, ");
        sql.append(" LIFE, ");
        sql.append(" USESTATUS_NAME, ");
        sql.append(" USEQUANTITY, ");
        sql.append(" USEAMOUNT, ");
        sql.append(" AMORTEDAMOUNT, ");
        sql.append(" AMORTAMOUNT, ");
        sql.append(" COMPANY_ID");
        sql.append(",isSum");
        return sql.toString();
    }

    private String getSumSelectSql(boolean isSum) {
        StringBuffer sql = new StringBuffer();
        if (this.isByDept) {
            sql.append("TO_CHAR(null) AS LCM, ");
        }
        sql.append("TO_CHAR(null) AS USER_NAME, ");
        sql.append("TO_CHAR(null) AS MEASUREUNIT_NAME, ");
        sql.append("TO_DATE(NULL) AS USEDATE, ");
        sql.append("TO_CHAR(null) AS USEDEPT_NAME, ");
        sql.append("TO_CHAR(null) AS BillID, ");
        sql.append("TO_CHAR(null) AS ASSETCAT_NAME, ");
        sql.append(isSum ? "sum(billNum)" : "0").append(" AS billNum, ");
        sql.append("TO_CHAR(null) AS SPECS, ");
        sql.append("TO_CHAR(null) AS CARDNAME, ");
        sql.append("TO_DATE(NULL) AS BUYDATE, ");
        sql.append("TO_CHAR(null) AS KEEPDEPT_NAME, ");
        if (isSum) {
            sql.append("TO_DECIMAL(null) AS ASSETAMT, ");
        } else {
            sql.append("0 AS ASSETAMT, ");
        }
        sql.append("TO_CHAR(null) AS CURRENCY_NAME, ");
        sql.append("TO_INT(null) AS PREC, ");
        if (isSum) {
            sql.append("TO_DECIMAL(null) AS ORIGINAMT, ");
            sql.append("TO_DECIMAL(null) AS LOCALAMT, ");
            sql.append("TO_DECIMAL(null) AS USEABELAMT, ");
        } else {
            sql.append("0 AS ORIGINAMT, ");
            sql.append("0 AS LOCALAMT, ");
            sql.append("0 AS USEABELAMT, ");
        }
        sql.append("TO_CHAR(null) AS STORECITY_NAME, ");
        sql.append("TO_INT(null) AS BILLTYPE, ");
        sql.append("TO_CHAR(null) AS LIFE, ");
        sql.append("TO_INT(null) AS USESTATUS_NAME, ");
        sql.append("TO_DECIMAL(null) AS USEQUANTITY, ");
        if (isSum) {
            sql.append("sum(USEAMOUNT) AS USEAMOUNT, ");
            sql.append("sum(AMORTEDAMOUNT) AS AMORTEDAMOUNT, ");
            sql.append("sum(AMORTAMOUNT) AS AMORTAMOUNT, ");
        } else {
            sql.append("0 AS USEAMOUNT, ");
            sql.append("0 AS AMORTEDAMOUNT, ");
            sql.append("0 AS AMORTAMOUNT, ");
        }
        sql.append("TO_CHAR(null) AS COMPANY_ID");
        if (isSum) {
            sql.append(", 1 AS isSum ");
        } else {
            sql.append(", 0 AS isSum ");
        }
        return sql.toString();
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map m = (Map)ev.get("customcond");
        this.isShowNotAudit = (Boolean)m.get(HAS_UN_AUDIT);
        this.isByDept = (Boolean)m.get(BY_DEPT);
        this.isByLcm = (Boolean)m.get(BY_LCM);
        this.useDateFrom = (Date)m.get(USE_DATE_FROM);
        this.useDateTo = (Date)m.get(USE_DATE_TO);
        this.lcmName = (String)m.get(LCM_NAME);
        this.lcmCatID = (String)m.get(LCM_CAT_ID);
        this.deptID = (String)m.get(USE_DEPT);
        this.userID = (String)m.get(USE_PERSON);
        this.cf = new FaDBUtilConfig();
        this.tableFieldConfig(this.cf);
        PeriodInfo currPeriod = this.getCurrentPeriod(ContextUtil.getCurrentFIUnit((Context)this.ctx));
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(this.ctx, this.currCompanyInfo);
        int lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        this.isCurrPeriod = currPeriod.getNumber() > lastestNumber;
    }

    protected String getProperTempTable(Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("lcm temp table");
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
        }
        sorterSql.append(" isSum");
        SorterItemCollection sorters = ev.getSorter();
        List sumInfoList = this.sumOption.getSumInfoList();
        block0: for (SorterItemInfo sorterItem : sorters) {
            if (sorterItem.getPropertyName().equals("USERDEFINENAME")) {
                int size = sumInfoList.size();
                for (int i = 0; i < size; ++i) {
                    if (!((LevelSumSqlInfo)sumInfoList.get(i)).getResource().equals("userDefineName")) continue;
                    sorterSql.append(", ");
                    sorterSql.append(sorterItem.toString());
                    continue block0;
                }
                continue;
            }
            sorterSql.append(", ");
            sorterSql.append(sorterItem.toString());
        }
        String sql = sorterSql.toString();
        sql = sql.replaceAll("FACURCARD.FNumber", "ASSETNUMBER");
        sql = sql.replaceAll("FACURCARD.fnumber", "ASSETNUMBER");
        sql = sql.replaceAll("FACURCARD.f", " ");
        return sql;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        return ev.getFilter().toString();
    }

    protected String getCurrentCompany() throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        BOSUuid id = ContextUtil.getCurrentFIUnit((Context)this.ctx).getId();
        return id.toString();
    }

    protected PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (this.currPeriod == null) {
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)this.ctx));
        }
        return this.currPeriod;
    }
}

