/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.fi.lcm.LCMAmortizeModeEnum;
import com.kingdee.eas.fi.lcm.LCMUseStatusEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LCMListDao
extends FaDaoBase {
    private String sumSql;
    private String select;
    private String insertCompanySql;
    private String total = "";
    protected boolean isShowNotAudit = false;
    private boolean isListStyle = false;
    private boolean isOnlyDisUnAudit = false;
    private boolean isContainReturnCard = true;
    private Date buyDateFrom = null;
    private Date buyDateTo = null;
    private Date accountDateFrom = null;
    private Date accountDateTo = null;
    private String buyDateFromStr = null;
    private String buyDateToStr = null;
    private String accountDateFromStr = null;
    private String accountDateToStr = null;
    private static final String HAS_UN_AUDIT = "HasUnAudit";
    private static final String IS_SUM_STYLE = "isSumStyle";
    private static final String ONLY_DISPLAY_UN_AUDIT = "OnlyDisplayUnAudit";
    private static final String IS_CONTAIN_RETURNCARD = "isContainReturnCard";
    private static final String BUY_DATE_FROM = "buyDateFrom";
    private static final String BUY_DATE_TO = "buyDateTo";
    private static final String ACCOUNT_DATE_FROM = "accountDateFrom";
    private static final String ACCOUNT_DATE_TO = "accountDateTo";
    private BigDecimal ZERO = new BigDecimal("0");
    private String tempTableForAmortized;

    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql(true);
        this.buildResultSql();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryCardSQL()));
        if (this.isVirCompany) {
            this.insertCompanySql = this.insertVacantCompany(this.tempTable, this.getSumSelectSql(false), this.strCompanyInclude);
        }
        if (this.isVirCompany) {
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.insertCompanySql));
        }
        try {
            this.fillAmortValData();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        this.updateToNull();
        this.sumSql = this.sumOption.getSumSql(this.tempTable, this.select, null, null, null, this.isListStyle, false);
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)this.sumSql);
        }
        if (!this.isListStyle || this.isVirCompany) {
            this.deleteUnnecessaryData();
        }
        if (this.isListStyle && !this.isVirCompany && !this.sumOption.isHasSum()) {
            this.total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)this.ctx.getOriginLocale());
            StringBuffer listSum = new StringBuffer();
            listSum.append("insert into " + this.tempTable + " select newBosId('00000000') AS FId  ," + this.getSumSelectSql(true) + " from " + this.tempTable);
            DbUtil.execute((Context)this.ctx, (String)listSum.toString());
        }
    }

    private void fillAmortValData() throws BOSException, SQLException {
        if (this.strCompanyInclude == null || "''".equals(this.strCompanyInclude)) {
            return;
        }
        String[] companyIds = this.strCompanyInclude.split(",");
        String currCompanyId = this.currCompanyInfo.getId().toString();
        int loopTime = 0;
        try {
            for (int i = 0; i < companyIds.length; ++i) {
                PeriodInfo periodInfo;
                String companyId = companyIds[i];
                String tempCompanyId = companyId.replace("'", "");
                if (this.isVirCompany && currCompanyId.equals(tempCompanyId) || (periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempCompanyId)))) == null) continue;
                String sql = this.buildAmortizedValData(periodInfo, companyId);
                if (loopTime == 0) {
                    this.getAmortizedTempTable(sql);
                } else {
                    String insertSql = "insert into " + this.tempTableForAmortized + " select * from (" + sql + ") as tempTable ";
                    DbUtil.execute((Context)this.ctx, (String)insertSql);
                }
                ++loopTime;
            }
            if (loopTime > 0) {
                this.updateAmortizedValData();
                this.dropAmortizedTable(this.tempTableForAmortized);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private String buildQueryCardSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" LCMCURCARD.FId AS FId  , ");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getCardSelectSql());
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(this.isCurrPeriod));
        String condSql = this.getCondSql(this.isCurrPeriod);
        condSql = condSql.replaceAll("LcmAlterMode.fnumber", "lcmSourceType.fnumber");
        if (condSql.trim().length() != 0) {
            sql.append(" WHERE ").append(condSql);
        }
        return sql.toString();
    }

    private String getCardSelectSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            sql.append("LCMCURCARD.FNumber AS ASSETNUMBER, ");
            sql.append("LCMCURCARD.FID AS CardID, ");
            sql.append("LCMCURCARD.FName AS ASSETNAME, ");
            sql.append("lcmCat.").append(this.fName).append(" AS ASSETCAT_NAME, ");
        }
        sql.append("1 AS cardNum, ");
        if (this.isListStyle) {
            sql.append("LCMCURCARD.FAssetAmt AS ASSETAMT, ");
            sql.append("LCMCURCARD.FUsableAmt AS USEABELAMT, ");
            sql.append("LCMCURCARD.FdeletedNum AS DELETEDNUM, ");
            sql.append("MEASUREUNIT.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
            sql.append("LCMCURCARD.FAccountDate AS ACCOUNTDATE, ");
            sql.append("lcmSourceType.").append(this.fName).append(" AS ORIGINMETHOD_NAME, ");
            sql.append("case LCMCURCARD.FUseStatus when ").append(1).append(" then '").append(LCMUseStatusEnum.USING.getAlias()).append("' when ").append(2).append(" then '").append(LCMUseStatusEnum.DISCARD.getAlias()).append("' when ").append(3).append(" then '").append(LCMUseStatusEnum.RENTURNED_CONSUME.getAlias()).append("' else '").append(LCMUseStatusEnum.NOT_USE.getAlias()).append("' end AS USESTATUS_NAME, ");
            sql.append("case LCMCURCARD.FAmortizeMode when ").append(1).append(" then '").append(LCMAmortizeModeEnum.ONCE.getAlias()).append("' when ").append(2).append(" then '").append(LCMAmortizeModeEnum.EQUAL_SPILT.getAlias()).append("' else '").append(LCMAmortizeModeEnum.ONCE.getAlias()).append("' end AS AMORTIZEMODE, ");
            sql.append("STOREADRESS.").append(this.fName).append(" AS STORECITY_NAME, ");
            sql.append("LCMCURCARD.FSpecs AS SPECS, ");
            sql.append("LCMCURCARD.FPArea AS PAREA, ");
            sql.append("LCMCURCARD.FMfr AS MFR, ");
            sql.append("SUPPLIER.").append(this.fName).append(" AS SUPPLIER_NAME, ");
            sql.append("ACCOUNTASSET.").append(this.fName).append(" AS ACCOUNTASSET_NAME, ");
            sql.append("CURRENCY.").append(this.fName).append(" AS CURRENCY_NAME, ");
            sql.append("CURRENCY.FPrecision AS PREC, ");
            sql.append("EXAUX.fprecision AS EXRATEPREC, ");
            sql.append("LCMCURCARD.FExRate AS EXRATE, ");
            sql.append("LCMCURCARD.FUnitPrice AS UNITPRICE, ");
            sql.append("LCMCURCARD.FLife AS LIFE, ");
            sql.append("TO_CHAR(null) AS overDate, ");
        }
        sql.append("LCMCURCARD.FOriginAmount AS ORIGINAMT, ");
        sql.append("LCMCURCARD.FLocalAmount AS LOCALAMT, ");
        sql.append("LCMCURCARD.FLocalAmount AS amortLeftVal, ");
        if (this.isListStyle) {
            sql.append("LCMCURCARD.FBuyDate AS BUYDATE, ");
            sql.append("LCMCURCARD.FDeletedDate AS DELETEDATE, ");
        }
        sql.append("COMPANY.FID AS COMPANY_ID");
        if (this.isListStyle) {
            sql.append(", COMPANY.").append(this.fName).append(" AS COMPANY_NAME, ");
            sql.append("DEPT.").append(this.fName).append(" AS DEPT_NAME, ");
            sql.append("KEEPER.").append(this.fName).append(" AS KEEPER_NAME, ");
            sql.append("LCMCURCARD.FDescription AS REMARK, ");
            sql.append("LCMCURCARD.FCurCardID AS FCurCardID ");
        } else {
            sql.append(", LCMCURCARD.FCurCardID AS FCurCardID ");
        }
        sql.append(",0 AS isSum ");
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        return sql.toString();
    }

    private String getSumSelectSql(boolean isSum) {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            sql.append("N'" + this.total + "' AS ASSETNUMBER, ");
            sql.append("TO_CHAR(null) AS CardID, ");
            sql.append("TO_CHAR(null) AS ASSETNAME, ");
            sql.append("TO_CHAR(null) AS ASSETCAT_NAME, ");
        }
        sql.append(isSum ? "sum(cardNum)" : "0").append(" AS cardNum, ");
        if (this.isListStyle) {
            if (isSum) {
                sql.append("TO_DECIMAL(null) AS ASSETAMT, ");
                sql.append("TO_DECIMAL(null) AS USEABELAMT, ");
                sql.append("TO_DECIMAL(null) AS DELETEDNUM, ");
            } else {
                sql.append("0 AS ASSETAMT, ");
                sql.append("0 AS USEABELAMT, ");
                sql.append("0 AS DELETEDNUM, ");
            }
            sql.append("TO_CHAR(null) AS MEASUREUNIT_NAME, ");
            sql.append("null AS ACCOUNTDATE, ");
            sql.append("TO_CHAR(null) AS ORIGINMETHOD_NAME, ");
            sql.append("TO_CHAR(null) AS USESTATUS_NAME, ");
            sql.append("TO_CHAR(null) AS AMORTIZEMODE, ");
            sql.append("TO_CHAR(null) AS STORECITY_NAME, ");
            sql.append("TO_CHAR(null) AS SPECS, ");
            sql.append("TO_CHAR(null) AS PAREA, ");
            sql.append("TO_CHAR(null) AS MFR, ");
            sql.append("TO_CHAR(null) AS SUPPLIER_NAME, ");
            sql.append("TO_CHAR(null) AS ACCOUNTASSET_NAME, ");
            sql.append("TO_CHAR(null) AS CURRENCY_NAME, ");
            sql.append("TO_INT(null) AS PREC, ");
            sql.append("TO_INT(null) AS EXRATEPREC, ");
            sql.append("TO_DECIMAL(null) AS EXRATE, ");
            sql.append("TO_DECIMAL(null) AS UNITPRICE, ");
            sql.append("TO_CHAR(null) AS LIFE, ");
            sql.append("TO_CHAR(null) AS overDate, ");
        }
        if (isSum) {
            sql.append("TO_DECIMAL(null) AS ORIGINAMT, ");
            sql.append("sum(LocalAmt) AS LOCALAMT, ");
            sql.append("sum(amortLeftVal) AS amortLeftVal, ");
        } else {
            sql.append("0 AS ORIGINAMT, ");
            sql.append("0 AS LOCALAMT, ");
            sql.append("0 AS amortLeftVal, ");
        }
        if (this.isListStyle) {
            sql.append("null AS BUYDATE, ");
            sql.append("null AS DELETEDATE, ");
        }
        if (isSum) {
            // empty if block
        }
        sql.append("TO_CHAR(null) AS COMPANY_ID");
        if (this.isListStyle) {
            sql.append(", TO_CHAR(null) AS COMPANY_NAME, ");
            sql.append("TO_CHAR(null) AS DEPT_NAME, ");
            sql.append("TO_CHAR(null) AS KEEPER_NAME, ");
            sql.append("TO_CHAR(null) AS REMARK, ");
            sql.append("TO_CHAR(null) AS FCurCardID ");
        } else {
            sql.append(",TO_CHAR(null) AS FCurCardID ");
        }
        if (isSum) {
            sql.append(", 1 AS isSum ");
        } else {
            sql.append(", 0 AS isSum ");
        }
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            sql.append(" ASSETNUMBER, ");
            sql.append(" CardID, ");
            sql.append(" ASSETNAME, ");
            sql.append(" ASSETCAT_NAME, ");
        }
        sql.append(" cardNum, ");
        if (this.isListStyle) {
            sql.append(" ASSETAMT, ");
            sql.append(" USEABELAMT, ");
            sql.append(" DELETEDNUM, ");
            sql.append(" MEASUREUNIT_NAME, ");
            sql.append(" ACCOUNTDATE, ");
            sql.append(" ORIGINMETHOD_NAME, ");
            sql.append(" USESTATUS_NAME, ");
            sql.append(" AMORTIZEMODE, ");
            sql.append(" STORECITY_NAME, ");
            sql.append(" SPECS, ");
            sql.append(" PAREA, ");
            sql.append(" MFR, ");
            sql.append(" SUPPLIER_NAME, ");
            sql.append(" ACCOUNTASSET_NAME, ");
            sql.append(" CURRENCY_NAME, ");
            sql.append(" PREC, ");
            sql.append(" EXRATEPREC,");
            sql.append(" EXRATE, ");
            sql.append(" UNITPRICE, ");
            sql.append(" LIFE, ");
            sql.append(" overDate, ");
        }
        sql.append(" ORIGINAMT, ");
        sql.append(" LOCALAMT, ");
        sql.append(" amortLeftVal, ");
        if (this.isListStyle) {
            sql.append(" BUYDATE, ");
            sql.append(" DELETEDATE, ");
        }
        sql.append(" COMPANY_ID");
        if (this.isListStyle) {
            sql.append(", COMPANY_NAME");
            sql.append(", DEPT_NAME");
            sql.append(", KEEPER_NAME");
            sql.append(", REMARK");
        }
        sql.append(",isSum");
        if (this.isVirCompany) {
            sql.append(", SumLevel ");
        }
        return sql.toString();
    }

    private String getJoinSql(boolean isCurPeriod) {
        String tableName;
        StringBuffer sql = new StringBuffer("(");
        if (this.isVirCompany) {
            sql.append(this.getCurCardSQL());
            sql.append(" UNION ");
            sql.append(this.getMonCardSQL());
        } else if (this.isCurrPeriod) {
            sql.append(this.getCurCardSQL());
        } else {
            sql.append(this.getMonCardSQL());
        }
        sql.append(") AS LCMCURCARD ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON LCMCURCARD.FCurrencyID = CURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Person AS KEEPER ON LCMCURCARD.FKeeperID = KEEPER.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS DEPT ON LCMCURCARD.FDeptID = DEPT.FID ");
        sql.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON LCMCURCARD.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON LCMCURCARD.FMeasureUnitID = MEASUREUNIT.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON LCMCURCARD.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ADDRESS AS STOREADRESS ON LCMCURCARD.FSTOREADRESS = STOREADRESS.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON LCMCURCARD.FSupplier = SUPPLIER.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid");
        sql.append(" AND EXAUX.fsourcecurrencyid = CURRENCY.fid AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid");
        if (this.isVirCompany && (tableName = this.getSumItemJoinSql("orgArchitecture")) != null) {
            sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
            sql.append(" ON LCMCURCARD.FCompanyID = ").append("orgArchitecture").append(".FID");
        }
        tableName = this.isLevelSum("lcmCat") ? this.getSumItemJoinSql("lcmCat") : this.getSumItemTableName("lcmCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("lcmCat");
        sql.append(" ON LCMCURCARD.FAssetCatID = ").append("lcmCat").append(".FID");
        tableName = this.isLevelSum("lcmSourceType") ? this.getSumItemJoinSql("lcmSourceType") : this.getSumItemTableName("lcmSourceType");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("lcmSourceType");
        sql.append(" ON LCMCURCARD.FSourceModeID = ").append("lcmSourceType").append(".FID");
        return sql.toString();
    }

    private String getCurCardSQL() {
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FID AS FID,CARD.FNumber,CARD.FName,FAssetAmt,FUsableAmt,FdeletedNum,FAccountDate,FSpecs,FPArea,FMfr,FSupplier,");
        select.append("FExRate,FOriginAmount,FLocalAmount,FSourceModeID,FAccountAssetID,");
        select.append("FBuyDate,FDeletedDate,FCheckedStatus,");
        select.append("FUseStatus,FAmortizeMode,CARD.FDescription,FLife ,FUnitPrice,");
        select.append("FCurrencyID,CARD.FKeeperID AS FKeeperID,FDeptID,FAssetCatID,CARD.FMeasureUnitID");
        select.append(" AS FMeasureUnitID,FStoreAdress,FCompanyID,CARD.FID AS FCurCardID ");
        StringBuffer from = new StringBuffer("T_LCM_LCMCurCard CARD");
        from.append(" left outer join t_bd_period period on CARD.FLCMPeriodID = period.fid");
        StringBuffer where = new StringBuffer(" (period.fperiodyear*100+period.fperiodnumber <= ");
        where.append(this.startYear * 100 + this.startNumber);
        where.append(" or CARD.flcmperiodid is null) ");
        where.append(" and " + this.getCompanyFilter(true));
        if (!this.isContainReturnCard) {
            where.append(" and (CARD.FUsableAmt > 0 or (CARD.FUsableAmt = 0");
            where.append(" and " + this.getConsumeAndReturnCardAndDiscardRelation(this.getCompanyFilter(true), "CARD.fid"));
            where.append("))");
        }
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getConsumeAndReturnCardAndDiscardRelation(String companyFilter, String fcurcardid) {
        StringBuffer sql = new StringBuffer();
        String orgWhere = companyFilter.replaceAll("CARD", "").trim();
        sql.append(" (select isnull(sum(contry.finitusequantity), 0) ");
        sql.append(" from t_lcm_lcmconsumebillentry contry ");
        sql.append(" inner join t_lcm_lcmconsumebill consume on consume.fid = contry.fbillid ");
        sql.append(" inner join t_bd_period pd on pd.fid = consume.fperiodid ");
        sql.append(" where contry.fcurcardid = " + fcurcardid);
        sql.append(" and consume.fcheckedstatus = 2 ");
        sql.append(" and pd.fnumber <= " + (this.startYear * 100 + this.startNumber));
        sql.append(" and consume" + orgWhere);
        sql.append(" and fsrcbillentryid is null) ");
        sql.append(" <> ");
        sql.append(" (select isnull(sum(discardentry.fdiscardamt), 0) ");
        sql.append(" from t_lcm_discardbill discard ");
        sql.append(" inner join t_lcm_discardbillentry discardentry on discardentry.fbillid = discard.fid ");
        sql.append(" inner join t_bd_period p on p.fid = discard.fperiodid ");
        sql.append(" inner join t_lcm_lcmconsumebillentry consumeentry on consumeentry.fid = discardentry.fconsumeentryid ");
        sql.append(" where consumeentry.fcurcardid = " + fcurcardid);
        sql.append(" and discard.fcheckedstatus = 2 ");
        sql.append(" and p.fnumber <= " + (this.startYear * 100 + this.startNumber));
        sql.append(" and discard" + orgWhere);
        sql.append(" and discardentry.fconsumeentryid is not null) ");
        sql.append(" + ");
        if (this.isVirCompany) {
            if ("CARD.fid".equals(fcurcardid)) {
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            } else if ("CARD.fcurcardid".equals(fcurcardid)) {
                this.params.addInt(this.startYear);
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            }
        }
        sql.append(" (select isnull(sum(returnbillentry.FHasReturnNumber), 0) ");
        sql.append(" from t_lcm_lcmreturnconsumebill returnbill ");
        sql.append(" inner join t_lcm_lcmreturnconsumeentry returnbillentry on returnbillentry.fentryid = returnbill.fid ");
        sql.append(" inner join t_bd_period o on o.fid = returnbill.fperiodid ");
        sql.append(" where returnbillentry.fcurcardid = " + fcurcardid);
        sql.append(" and returnbill.fcheckedstatus = 2 ");
        sql.append(" and o.fnumber <= " + (this.startYear * 100 + this.startNumber));
        sql.append(" and returnbill" + orgWhere);
        sql.append(")");
        if (this.isVirCompany) {
            if ("CARD.fid".equals(fcurcardid)) {
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            } else if ("CARD.fcurcardid".equals(fcurcardid)) {
                this.params.addInt(this.startYear);
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            }
        }
        return sql.toString();
    }

    private String getMonCardSQL() {
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FID AS FID,CARD.FNumber,CARD.FName,CARD.FAssetAmt,CARD.FUsableAmt,CARD.FdeletedNum,CARD.FAccountDate,CARD.FSpecs,CARD.FPArea,CARD.FMfr,CARD.FSupplier, ");
        select.append("CARD.FExRate,CARD.FOriginAmount,CARD.FLocalAmount,CARD.FSourceModeID,CARD.FAccountAssetID,");
        select.append("CARD.FBuyDate,CARD.FDeletedDate,CARD.FCheckedStatus,");
        select.append("CARD.FUseStatus,CARD.FAmortizeMode,CARD.FDescription,CARD.FLife ,CARD.FUnitPrice,");
        select.append("CARD.FCurrencyID,CARD.FKeeperID AS FKeeperID,CARD.FDeptID,CARD.FAssetCatID,CARD.FMeasureUnitID");
        select.append(" AS FMeasureUnitID,CARD.FStoreAdress,CARD.FCompanyID,CARD.FCurCardID AS FCurCardID");
        StringBuffer from = new StringBuffer("T_LCM_LCMMonCard CARD ");
        from.append(" inner join t_bd_period period on CARD.FPeriodID = period.fid");
        StringBuffer where = new StringBuffer(" period.FPeriodYear = " + this.startYear + " and period.FPeriodNumber = " + this.startNumber);
        where.append(" and " + this.getCompanyFilter(false));
        if (!this.isContainReturnCard) {
            where.append(" and (CARD.FUsableAmt > 0 or (CARD.FUsableAmt = 0");
            where.append(" and " + this.getConsumeAndReturnCardAndDiscardRelation(this.getCompanyFilter(false), "CARD.fcurcardid"));
            where.append("))");
        }
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getCompanyFilter(boolean isCurrPeriod) {
        StringBuffer sbff = new StringBuffer();
        if (this.isVirCompany) {
            StringBuffer companyQuery = new StringBuffer();
            companyQuery.append(" SELECT company.fid FROM t_bd_SystemStatusCtrol ssc");
            companyQuery.append(" INNER JOIN t_bd_period period ON ssc.fcurrentperiodid = period.fid");
            companyQuery.append(" INNER JOIN t_org_company company ON ssc.fcompanyid = company.fid");
            companyQuery.append(" INNER JOIN t_bd_SystemStatus ss on ss.fid=ssc.fsystemstatusid");
            companyQuery.append(" WHERE ss.fname= ").append(32);
            if (isCurrPeriod) {
                companyQuery.append(" AND period.FPeriodYear = ?");
                companyQuery.append(" AND period.fperiodnumber = ?");
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            } else {
                companyQuery.append(" AND (period.FPeriodYear > ?");
                companyQuery.append(" OR (period.FPeriodYear = ?");
                companyQuery.append(" AND period.fperiodnumber > ?))");
                this.params.addInt(this.startYear);
                this.params.addInt(this.startYear);
                this.params.addInt(this.startNumber);
            }
            companyQuery.append(" AND company.fid IN (").append(this.strCompanyInclude).append(")");
            sbff.append(" CARD.FCOMPANYID IN (").append(companyQuery).append(")");
        } else {
            sbff.append(" CARD.FCOMPANYID = '" + this.currCompanyInfo.getId().toString() + "' ");
        }
        return sbff.toString();
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    private String getCondSql(boolean isCurrPeriod) {
        SimpleDateFormat dateFormat;
        StringBuffer condSql = new StringBuffer();
        if (!this.isShowNotAudit && !this.isOnlyDisUnAudit) {
            condSql.append("LCMCURCARD.FCheckedStatus = 2 ");
        }
        if (this.isOnlyDisUnAudit) {
            condSql.append(" LCMCURCARD.FCheckedStatus = 1 ");
        }
        if (this.buyDateFrom != null) {
            if (!this.isShowNotAudit && !this.isOnlyDisUnAudit || this.isOnlyDisUnAudit) {
                condSql.append(" AND ");
            }
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.buyDateFromStr = dateFormat.format(this.buyDateFrom);
            condSql.append(" LCMCURCARD.FBuyDate ").append(">= {ts'").append(this.buyDateFromStr + " 00:00:00").append("'} ");
        }
        if (this.buyDateTo != null) {
            if (!this.isShowNotAudit && !this.isOnlyDisUnAudit || this.isOnlyDisUnAudit || this.buyDateFrom != null) {
                condSql.append(" AND ");
            }
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.buyDateToStr = dateFormat.format(this.buyDateTo);
            condSql.append(" LCMCURCARD.FBuyDate ").append("<= {ts'").append(this.buyDateToStr + " 23:59:59").append("'} ");
        }
        if (this.accountDateFrom != null) {
            if (!this.isShowNotAudit && !this.isOnlyDisUnAudit || this.isOnlyDisUnAudit || this.buyDateFrom != null || this.buyDateTo != null) {
                condSql.append(" AND ");
            }
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.accountDateFromStr = dateFormat.format(this.accountDateFrom);
            condSql.append(" LCMCURCARD.FAccountDate ").append(">= {ts'").append(this.accountDateFromStr + " 00:00:00").append("'} ");
        }
        if (this.accountDateTo != null) {
            if (!this.isShowNotAudit && !this.isOnlyDisUnAudit || this.isOnlyDisUnAudit || this.buyDateFrom != null || this.buyDateTo != null || this.accountDateFrom != null) {
                condSql.append(" AND ");
            }
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.accountDateToStr = dateFormat.format(this.accountDateTo);
            condSql.append(" LCMCURCARD.FAccountDate ").append("<= {ts'").append(this.accountDateToStr + " 23:59:59").append("'} ");
        }
        if (this.filter != null) {
            if (!this.isShowNotAudit && !this.isOnlyDisUnAudit || this.isOnlyDisUnAudit || this.buyDateFrom != null || this.buyDateTo != null || this.accountDateFrom != null || this.accountDateTo != null) {
                condSql.append(" AND ");
            }
            condSql.append(" ").append(this.filter);
        }
        return condSql.toString();
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.isShowNotAudit = (Boolean)m.get(HAS_UN_AUDIT);
        this.isListStyle = (Boolean)m.get(IS_SUM_STYLE) == false;
        this.isOnlyDisUnAudit = (Boolean)m.get(ONLY_DISPLAY_UN_AUDIT);
        this.isContainReturnCard = (Boolean)m.get(IS_CONTAIN_RETURNCARD);
        this.buyDateFrom = (Date)m.get(BUY_DATE_FROM);
        this.buyDateTo = (Date)m.get(BUY_DATE_TO);
        this.accountDateFrom = (Date)m.get(ACCOUNT_DATE_FROM);
        this.accountDateTo = (Date)m.get(ACCOUNT_DATE_TO);
        this.cf = new FaDBUtilConfig();
        this.tableFieldConfig(this.cf);
        if (!this.isVirCompany) {
            String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(this.ctx, this.currCompanyInfo);
            int lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
            this.isCurrPeriod = this.startYear * 100 + this.startNumber > lastestNumber;
        }
    }

    protected String getProperTempTable(Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("lcm temp table");
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
        }
        if (this.isVirCompany) {
            sorterSql.append(" SumLevel , ").append(" isSum DESC");
        } else {
            sorterSql.append(" isSum");
        }
        if (!this.isListStyle) {
            return sorterSql.toString();
        }
        SorterItemCollection sorters = ev.getSorter();
        List sumInfoList = this.sumOption.getSumInfoList();
        block0: for (SorterItemInfo sorterItem : sorters) {
            if (sorterItem.getPropertyName().equals("USERDEFINENAME")) {
                int size = sumInfoList.size();
                for (int i = 0; i < size; ++i) {
                    if (!((LevelSumSqlInfo)sumInfoList.get(i)).getResource().equals("userDefineName")) continue;
                    sorterSql.append(", ");
                    sorterSql.append(sorterItem.toString());
                    continue block0;
                }
                continue;
            }
            sorterSql.append(", ");
            sorterSql.append(sorterItem.toString());
        }
        String sql = sorterSql.toString();
        sql = sql.replaceAll("FACURCARD.FNumber", "ASSETNUMBER");
        sql = sql.replaceAll("FACURCARD.fnumber", "ASSETNUMBER");
        sql = sql.replaceAll("FACURCARD.f", " ");
        return sql;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        FilterItemCollection filterColl = filterInfo.getFilterItems();
        for (int i = 0; i < filterColl.size(); ++i) {
            Object value;
            FilterItemInfo filter = filterColl.get(i);
            String propertyName = filter.getPropertyName();
            if ("LCMCURCARD.FUseStatus".equals(propertyName)) {
                value = filter.getCompareValue();
                filter.setCompareValue((Object)new Integer(value.toString()));
            }
            if (!"LCMCURCARD.FAmortizeMode".equals(propertyName)) continue;
            value = filter.getCompareValue();
            filter.setCompareValue((Object)new Integer(value.toString()));
        }
        return ev.getFilter().toString();
    }

    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledConfig("USEDEPARTMENT_NAME", 20);
        cf.addFiledConfig("USESTATUS_NAME", 20);
        cf.addFiledConfig("AMORTIZEMODE", 20);
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable).append(" WHERE ");
        sql.append("ISSUM=0 ");
        if (this.isListStyle) {
            sql.append("AND CARDID IS NULL");
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected String getFirstDisplayField() {
        return this.isListStyle ? "ASSETNUMBER" : null;
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        int startPeriod = startYear * 100 + startNumber;
        int endPeriod = endYear * 100 + endNumber;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(32);
        if (!this.isInitPeriod) {
            sql.append(" AND currPeriod.Fnumber >= ").append(startPeriod);
            sql.append(" AND startPeriod.Fnumber <= ").append(endPeriod);
        }
        sql.append(" AND company.FID IN (").append(selectedIds).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    private String buildAmortizedValData(PeriodInfo periodInfo, String companyId) throws BOSException, SQLException {
        String whereString = "LCMCURCARD.FID in(select t.FCurCardID from " + this.tempTable + " as t where t.isSum = 0 and t.FCurCardID IS NOT NULL) ";
        String newWhereString = "MON.FCurCardID in(select t.FCurCardID from " + this.tempTable + " as t where t.isSum = 0 and t.FCurCardID IS NOT NULL) ";
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(a.FAmortizedAmount),0) as FAmortizedAmount, a.FCurCardID as FCurCardID ");
        sql.append(" from (");
        sql.append("\t(SELECT isnull(SUM(BILLENTRY.FAmortizedAmount+ (case when consumeentry.FAmortizedAmount is null then 0 else consumeentry.FAmortizedAmount end)),0) as FAmortizedAmount,LCMCURCARD.FID as FCurCardID ");
        sql.append("\t\tFROM T_LCM_LCMConsumeBill as LCMBILL ");
        sql.append("\t\tINNER JOIN T_LCM_LCMConsumeBillEntry as BILLENTRY ON LCMBILL.FID = BILLENTRY.FBillID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMCurCard as LCMCURCARD ON BILLENTRY.FCurCardID = LCMCURCARD.FID ");
        sql.append(" \t\tINNER JOIN T_BD_Period as PERIOD ON LCMBILL.FPeriodID = PERIOD.FID ");
        sql.append("left outer join ( ");
        sql.append("  select e.fsrcbillentryid as fsrcbillentryid, ");
        sql.append("     sum(e.FAmortizedAmount) as FAmortizedAmount ");
        sql.append("from t_lcm_lcmconsumebill c ");
        sql.append("inner join t_lcm_lcmconsumebillentry e on e.fbillid = c.fid ");
        sql.append("inner join t_bd_period p on p.fid = c.fperiodid ");
        sql.append("where c.fcheckedstatus = 2 ");
        sql.append("  and p.fnumber > ").append(periodInfo.getNumber());
        sql.append("  and e.fsrcbillentryid is not null ");
        sql.append("group by e.fsrcbillentryid) consumeentry on consumeentry.fsrcbillentryid = BILLENTRY.fid ");
        sql.append("\tWHERE " + whereString + " and LCMBILL.FCHECKEDSTATUS = 2 and LCMBILL.fcompanyid in(" + companyId + ") ");
        if (!this.isCurrPeriod) {
            sql.append(" AND PERIOD.FNUMBER <= " + (this.startYear * 100 + this.startNumber));
        }
        sql.append("\t    group by LCMCURCARD.FID) ");
        sql.append(" union all ");
        sql.append("\t(SELECT isnull(SUM(DISCARDENTRY.FamortizeAmount),0) as FAmortizedAmount,LCMCURCARD.FID as FCurCardID ");
        sql.append("\t\tFROM T_LCM_DiscardBill as DISCARDBILL ");
        sql.append("\t\tINNER JOIN T_LCM_DiscardBillEntry as DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMCurCard as LCMCURCARD ON DISCARDENTRY.FCurCardID = LCMCURCARD.FID ");
        sql.append("\t\tINNER JOIN T_BD_Period as PERIOD ON DISCARDBILL.FPeriodID = PERIOD.FID ");
        sql.append("\tWHERE " + whereString + " and DISCARDBILL.FCHECKEDSTATUS = 2 and DISCARDBILL.fcompanyid in(" + companyId + ") ");
        if (!this.isCurrPeriod) {
            sql.append(" AND PERIOD.FNUMBER <= " + (this.startYear * 100 + this.startNumber));
        }
        sql.append("\t\tgroup by LCMCURCARD.FID) ");
        sql.append(" union all ");
        sql.append("\t(SELECT isnull(SUM(DISCARDENTRY.FamortizeAmount),0) as FAmortizedAmount,LCMCURCARD.FID as FCurCardID ");
        sql.append("\t\tFROM T_LCM_DiscardBill as DISCARDBILL ");
        sql.append("\t\tINNER JOIN T_BD_Period as PERIOD ON DISCARDBILL.FPeriodID = PERIOD.FID ");
        sql.append("\t\tINNER JOIN T_LCM_DiscardBillEntry as DISCARDENTRY ON DISCARDBILL.FID = DISCARDENTRY.FBillID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMConsumeBillEntry as CONSUMEENTRY ON CONSUMEENTRY.FID = DISCARDENTRY.FConsumeEntryID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMCurCard as LCMCURCARD ON CONSUMEENTRY.FCurCardID = LCMCURCARD.FID ");
        sql.append("\tWHERE " + whereString + " and DISCARDBILL.FCHECKEDSTATUS = 2 and DISCARDBILL.fcompanyid in(" + companyId + ") ");
        if (!this.isCurrPeriod) {
            sql.append(" AND PERIOD.FNUMBER <= " + (this.startYear * 100 + this.startNumber));
        }
        sql.append("\t\tgroup by LCMCURCARD.FID) ");
        sql.append(" union all ");
        sql.append("\t(SELECT isnull(SUM(returnEntry.FHASRETURNNUMBER * LCMCURCARD.FUNITPRICE * 0.5),0) as FAmortizedAmount,LCMCURCARD.FID as FCurCardID ");
        sql.append("\t\tFROM T_LCM_LCMReturnConsumeBill as returnBill ");
        sql.append("\t\tINNER JOIN T_BD_Period as PERIOD ON returnBill.FPeriodID = PERIOD.FID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMReturnConsumeEntry as returnEntry ON returnBill.FID = returnEntry.FEntryID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMCurCard as LCMCURCARD ON returnEntry.FcurcardID = LCMCURCARD.FID ");
        sql.append("\t\tWHERE " + whereString + " and returnBill.FCHECKEDSTATUS = 2 and returnBill.fcompanyid in(" + companyId + ") and LCMCURCARD.FAmortizeMode != 1");
        if (!this.isCurrPeriod) {
            sql.append(" AND PERIOD.FNUMBER <= " + (this.startYear * 100 + this.startNumber));
        }
        sql.append("\t\tgroup by LCMCURCARD.FID) ");
        sql.append(" union all ");
        sql.append("\t(SELECT isnull(SUM(DISPATCHENTRY.FassetValue),0) as FAmortizedAmount, LCMCURCARD.FID as FCurCardID ");
        sql.append("\t\tFROM T_LCM_LCMDisPatchBill as DISPATCHBILL ");
        sql.append("\t\tINNER JOIN T_LCM_LCMDispatchBillEntry as DISPATCHENTRY ON DISPATCHBILL.FID = DISPATCHENTRY.FLcmDispatchBillID ");
        sql.append("\t\tINNER JOIN T_LCM_LCMCurCard as LCMCURCARD ON DISPATCHENTRY.FLcmCurCardID = LCMCURCARD.FID ");
        sql.append("\t\tINNER JOIN T_BD_Period as PERIOD ON DISPATCHBILL.FPeriodID = PERIOD.FID ");
        sql.append("\tWHERE " + whereString + " and DISPATCHBILL.FCHECKEDSTATUS = 2 and DISPATCHENTRY.FLcmNewCardID IS NOT NULL and DISPATCHBILL.FOUTCOMPANYID in(" + companyId + ") ");
        if (!this.isCurrPeriod) {
            sql.append(" AND PERIOD.FNUMBER <= " + (this.startYear * 100 + this.startNumber));
        }
        sql.append("\t\tgroup by LCMCURCARD.FID) ");
        sql.append(" union all ");
        sql.append("\t(SELECT isnull(SUM(DETAIL.FAmortizedAmount),0) as FAmortizedAmount, MON.FCurCardID as FCurCardID ");
        sql.append("\t   FROM t_lcm_lcmconsumedetail as DETAIL\t");
        sql.append("      INNER JOIN t_lcm_lcmmoncard as MON ON MON.fid = DETAIL.fmoncardid ");
        sql.append("      INNER JOIN t_bd_systemstatusctrol as ssc on ssc.fcompanyid = mon.fcompanyid");
        sql.append("      INNER JOIN t_bd_systemstatus as ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(32);
        sql.append("\tWHERE " + newWhereString + " and MON.fperiodid is null  ");
        sql.append("      AND ssc.fstartperiodid is not null AND ssc.fisstart = 0 ");
        sql.append("\t  AND NOT EXISTS(SELECT CONSUMEBILL.fid FROM t_lcm_lcmconsumebill as CONSUMEBILL ");
        sql.append("\t\t\tINNER JOIN t_lcm_lcmconsumebillentry as CONSUMEBILLENTRY ON CONSUMEBILLENTRY.fbillid = CONSUMEBILL.fid");
        sql.append("\t\t\tWHERE CONSUMEBILL.fcompanyid = MON.fcompanyid");
        sql.append("\t\t\t\tand CONSUMEBILL.fnumber LIKE 'InitCardNumber%' ");
        sql.append("\t\t\t\tand CONSUMEBILLENTRY.FCurCardID = MON.FCurCardID)");
        sql.append("\tgroup by MON.FCurCardID)");
        sql.append(") as a group by a.FCurCardID ");
        return sql.toString();
    }

    private void updateAmortizedValData() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.tempTable + " as tt set amortLeftVal = ");
        sql.append("   (select case when (tt.localamt-t1.FAmortizedAmount) <=0 then 0 else (tt.amortLeftVal-t1.FAmortizedAmount) end ");
        sql.append("\t\tfrom " + this.tempTableForAmortized + " as t1 where tt.FCurCardID=t1.FCurCardID )");
        sql.append("where tt.isSum = 0 and tt.FCurCardID IS NOT NULL ");
        sql.append("\tand exists (select 1 from " + this.tempTableForAmortized + " as tf where tf.FCurCardID=tt.FCurCardID)");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getAmortizedTempTable(String sql) throws BOSException {
        String tableName = "LCMTempTabel";
        sql = "select * into " + tableName + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), null, (Connection)con, (FaDBUtilConfig)this.cf);
            this.tempTableForAmortized = result.getTempTable();
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTableForAmortized, "fcurcardid", false, false);
            TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTable, "fcurcardid", false, false);
        }
        catch (Exception exc) {
            throw new BOSException("Sql execute exception : " + sql.toString(), (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return this.tempTableForAmortized;
    }

    private void dropAmortizedTable(String tempTableName) throws BOSException {
        if (this.tempTableForAmortized != null) {
            try {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTableName);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

